<?php
use Illuminate\Support\Facades\Crypt;
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Student Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-12">
    <div class="card mb-4">
      <div class="card-header">
        <h4 class="card-title mb-0">Student Profile</h4>
      </div>
      <div class="card-body">
        <div class="row">
          <!-- Student Image -->
          <div class="col-md-3 text-center">
            <?php if($student->image): ?>
              <img src="<?php echo e(asset($student->image)); ?>" alt="<?php echo e($student->name); ?>" class="rounded img-fluid" style="max-width: 200px;">
            <?php else: ?>
              <div class="avatar avatar-xl">
                <span class="avatar-initial rounded bg-label-primary">
                  <?php echo e(strtoupper(substr($student->name, 0, 2))); ?>

                </span>
              </div>
            <?php endif; ?>
          </div>

          <!-- Student Details -->
          <div class="col-md-9">
            <table class="table table-borderless">
              <tbody>
                <tr>
                  <th width="200">Roll No:</th>
                  <td><?php echo e($student->roll_no ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Student Name:</th>
                  <td><strong><?php echo e($student->name); ?></strong></td>
                </tr>
                <tr>
                  <th>Father's Name:</th>
                  <td><?php echo e($student->fname ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Mobile 1:</th>
                  <td><?php echo e($student->mob1 ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Mobile 2:</th>
                  <td><?php echo e($student->mob2 ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Join Date:</th>
                  <td><?php echo e($student->join_date ? date('d-m-Y', strtotime($student->join_date)) : 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Address:</th>
                  <td><?php echo e($student->address ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Class:</th>
                  <td><?php echo e($student->class->name ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Section:</th>
                  <td><?php echo e($student->section->name ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Fee:</th>
                  <td><?php echo e($student->fee ?? 'N/A'); ?></td>
                </tr>
                <tr>
                  <th>Fee Status:</th>
                  <td>
                    <?php if($student->fstatus == 0): ?>
                      <span class="badge rounded-pill bg-label-success">Regular</span>
                    <?php else: ?>
                      <span class="badge rounded-pill bg-label-danger">Free</span>
                    <?php endif; ?>
                  </td>
                </tr>
                <tr>
                  <th>School:</th>
                  <td><?php echo e($student->school->name ?? 'N/A'); ?></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\rise\app\resources\views/myapp/admin/student_profile.blade.php ENDPATH**/ ?>