<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Staff Management'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'
  ]); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/select2/select2.js',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'
  ]); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
  <!-- Header -->
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="fw-bold mb-0">
      <span class="text-muted fw-light">Admin /</span> Staff Management
    </h4>
    <button type="button" class="btn btn-primary" id="btnAddStaff">
      <i class="ri-add-line me-1"></i> Add Staff
    </button>
  </div>

  <!-- Filters -->
  <div class="card mb-4">
    <div class="card-body">
      <form method="GET" action="<?php echo e(route('admin.staff.list')); ?>">
        <div class="row g-3">
          <div class="col-md-3">
            <label class="form-label">Search</label>
            <input type="text" name="search" class="form-control" placeholder="Name, email, mobile..." value="<?php echo e(request('search')); ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Staff Type</label>
            <select name="type_filter" class="form-select">
              <option value="">All Types</option>
              <?php $__currentLoopData = $stypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($type->id); ?>" <?php echo e(request('type_filter') == $type->id ? 'selected' : ''); ?>><?php echo e($type->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Status</label>
            <select name="status_filter" class="form-select">
              <option value="">All Status</option>
              <option value="0" <?php echo e(request('status_filter') === '0' ? 'selected' : ''); ?>>Active</option>
              <option value="1" <?php echo e(request('status_filter') === '1' ? 'selected' : ''); ?>>Disabled</option>
            </select>
          </div>
          <div class="col-md-3 d-flex align-items-end gap-2">
            <button type="submit" class="btn btn-primary">
              <i class="ri-search-line me-1"></i> Filter
            </button>
            <a href="<?php echo e(route('admin.staff.list')); ?>" class="btn btn-secondary">
              <i class="ri-refresh-line me-1"></i> Reset
            </a>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Staff Table -->
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="mb-0">Staff Members</h5>
      <span class="badge bg-secondary"><?php echo e($staff->total()); ?> Total</span>
    </div>
    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Mobile</th>
            <th>Type</th>
            <th>Status</th>
            <th>Joined</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__empty_1 = true; $__currentLoopData = $staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
          <tr>
            <td><strong><?php echo e($s->name); ?></strong></td>
            <td><?php echo e($s->email); ?></td>
            <td><?php echo e($s->mob); ?></td>
            <td><?php echo e($s->stype->name ?? 'N/A'); ?></td>
            <td>
              <?php if($s->status == 0): ?>
              <span class="badge bg-success">Active</span>
              <?php else: ?>
              <span class="badge bg-danger">Disabled</span>
              <?php endif; ?>
            </td>
            <td><?php echo e($s->joined_at ? date('d M Y', strtotime($s->joined_at)) : 'N/A'); ?></td>
            <td>
              <button type="button" 
                class="btn btn-sm btn-icon btn-text-secondary rounded-pill waves-effect btn-edit-staff" 
                data-id="<?php echo e($s->encrypted_id); ?>"
                title="Edit">
                <i class="ri-edit-box-line ri-20px"></i>
              </button>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
          <tr>
            <td colspan="7" class="text-center py-5">
              <div class="text-muted">
                <i class="ri-user-line ri-2x mb-2"></i>
                <p class="mb-0">No staff members found</p>
              </div>
            </td>
          </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
    <?php if($staff->hasPages()): ?>
    <div class="card-footer">
      <div class="d-flex justify-content-between align-items-center">
        <div class="text-muted">
          Showing <?php echo e($staff->firstItem()); ?> to <?php echo e($staff->lastItem()); ?> of <?php echo e($staff->total()); ?> entries
        </div>
        <div>
          <?php echo e($staff->appends(request()->query())->links()); ?>

        </div>
      </div>
    </div>
    <?php endif; ?>
  </div>
</div>

<!-- Staff Modal -->
<div class="modal fade" id="staffModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content" id="staffModalContent">
      <!-- Content will be loaded here -->
    </div>
  </div>
</div>

<script>
(function() {
  console.log('Staff JavaScript initializing...');
  
  // Wait for DOM
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
  
  function init() {
    console.log('Initializing staff management...');
    
    // Add Staff Button
    const btnAdd = document.getElementById('btnAddStaff');
    if (btnAdd) {
      btnAdd.addEventListener('click', function() {
        console.log('Add button clicked');
        loadStaffForm('/admin/staff/create');
      });
      console.log('Add button listener attached');
    } else {
      console.error('Add button not found!');
    }
    
    // Edit Staff Buttons
    document.querySelectorAll('.btn-edit-staff').forEach(function(btn) {
      btn.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        console.log('Edit button clicked, ID:', id);
        loadStaffForm('/admin/staff/edit/' + id);
      });
    });
    console.log('Edit buttons found:', document.querySelectorAll('.btn-edit-staff').length);
  }
  
  function loadStaffForm(url) {
    console.log('Loading form from:', url);
    
    const modalElement = document.getElementById('staffModal');
    const modalContent = document.getElementById('staffModalContent');
    
    if (!modalElement || !modalContent) {
      console.error('Modal elements not found!');
      alert('Error: Modal not found');
      return;
    }
    
    fetch(url, {
      headers: {
        'X-Requested-With': 'XMLHttpRequest',
        'Accept': 'text/html'
      }
    })
    .then(function(response) {
      console.log('Response received:', response.status);
      if (!response.ok) {
        throw new Error('HTTP ' + response.status);
      }
      return response.text();
    })
    .then(function(html) {
      console.log('Form loaded, length:', html.length);
      modalContent.innerHTML = html;
      
      // Show modal using Bootstrap
      if (typeof bootstrap !== 'undefined') {
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
        console.log('Modal shown');
      } else {
        console.error('Bootstrap not loaded!');
        alert('Error: Bootstrap not loaded');
      }
    })
    .catch(function(error) {
      console.error('Error:', error);
      alert('Failed to load form: ' + error.message);
    });
  }
  
  // Global reload function
  window.reloadStaffTable = function() {
    window.location.reload();
  };
})();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\rise\app\resources\views/myapp/admin/staff_list.blade.php ENDPATH**/ ?>