<div class="modal-header">
    <h5 class="modal-title">Payment History</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
    <!-- Student Info with Image -->
    <div class="row mb-4">
        <div class="col-12 mb-3">
            <div class="d-flex align-items-center">
                <div class="avatar avatar-lg me-3">
                    <img src="<?php echo e($student->image ? asset($student->image) : asset('assets/img/avatars/default-avatar.png')); ?>" alt="Avatar" class="rounded-circle" width="60" height="60">
                </div>
                <div>
                    <h5 class="mb-1"><?php echo e($student->name); ?> <small class="text-muted">(<?php echo e($student->roll_no); ?>)</small></h5>
                    <p class="mb-0 text-muted"><?php echo e($student->class->name ?? 'N/A'); ?> / <?php echo e($student->section->name ?? 'N/A'); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <p class="mb-2"><strong>Father Name:</strong> <?php echo e($student->fname ?? 'N/A'); ?></p>
            <p class="mb-2"><strong>Mobile:</strong> <?php echo e($student->mob1 ?? 'N/A'); ?></p>
        </div>
        <div class="col-md-6">
            <p class="mb-2"><strong>Join Date:</strong> <?php echo e($student->join_date ? date('d-m-Y', strtotime($student->join_date)) : 'N/A'); ?></p>
            <p class="mb-2"><strong>Fee Status:</strong> 
                <?php if($student->fstatus == 0): ?>
                <span class="badge bg-label-success">Regular</span>
                <?php else: ?>
                <span class="badge bg-label-danger">Free</span>
                <?php endif; ?>
            </p>
        </div>
    </div>

    <!-- Payment Statistics -->
    <div class="row mb-4">
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-success">
                <div class="card-body text-center">
                    <h6 class="mb-1">Paid Challans</h6>
                    <h4 class="text-success mb-0"><?php echo e($challans->where('status', 4)->count()); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-warning">
                <div class="card-body text-center">
                    <h6 class="mb-1">Pending</h6>
                    <h4 class="text-warning mb-0"><?php echo e($challans->whereIn('status', [0, 1, 2])->count()); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-success">
                <div class="card-body text-center">
                    <h6 class="mb-1">Total Paid</h6>
                    <h4 class="text-success mb-0">₨<?php echo e(number_format($challans->where('status', 4)->sum('amount'), 0)); ?></h4>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-danger">
                <div class="card-body text-center">
                    <h6 class="mb-1">Total Unpaid</h6>
                    <h4 class="text-danger mb-0">₨<?php echo e(number_format($challans->whereIn('status', [0, 1, 2])->sum('amount'), 0)); ?></h4>
                </div>
            </div>
        </div>
    </div>

    <!-- Challans Table -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-light">
                <tr>
                    <th>Challan No</th>
                    <th>Month</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Transaction ID</th>
                    <th>Payment Method</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $challans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $challan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><span class="fw-bold text-primary"><?php echo e($challan->challan_no); ?></span></td>
                    <td><?php echo e($challan->feemonth ? date('F Y', strtotime($challan->feemonth)) : 'N/A'); ?></td>
                    <td>
                        ₨<?php echo e(number_format($challan->amount, 2)); ?>

                        <?php if($challan->description): ?>
                        <br><small class="text-muted"><i class="ri-information-line"></i> <?php echo e($challan->description); ?></small>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if($challan->status == 0): ?>
                        <span class="badge bg-label-info">Issued</span>
                        <?php elseif($challan->status == 1): ?>
                        <span class="badge bg-label-warning">Pending</span>
                        <?php elseif($challan->status == 2): ?>
                        <span class="badge bg-label-primary">Waiting Approval</span>
                        <?php elseif($challan->status == 3): ?>
                        <span class="badge bg-label-danger">Cancelled</span>
                        <?php elseif($challan->status == 4): ?>
                        <span class="badge bg-label-success">Paid</span>
                        <?php else: ?>
                        <span class="badge bg-label-secondary">Unknown</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($challan->transid ?? 'N/A'); ?></td>
                    <td>
                        <?php if($challan->payment_method == 'cash'): ?>
                        <span class="badge bg-label-success">Cash</span>
                        <?php elseif($challan->payment_method == 'bank_transfer'): ?>
                        <span class="badge bg-label-info">Bank Transfer</span>
                        <?php if($challan->bank_reference): ?>
                        <br><small class="text-muted">Ref: <?php echo e($challan->bank_reference); ?></small>
                        <?php endif; ?>
                        <?php else: ?>
                        <span class="text-muted">-</span>
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($challan->created_at ? date('d-m-Y', strtotime($challan->created_at)) : 'N/A'); ?></td>
                </tr>
                <?php if($challan->history && $challan->history->count() > 0): ?>
                <tr>
                    <td colspan="7" class="bg-light">
                        <small class="fw-bold text-muted">Status Change History:</small>
                        <div class="ms-3 mt-2">
                            <?php $__currentLoopData = $challan->history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-2">
                                <span class="badge bg-label-secondary"><?php echo e(date('d-m-Y h:i A', strtotime($hist->created_at))); ?></span>
                                <span class="text-muted">Changed from</span>
                                <strong><?php echo e($hist->getStatusLabel($hist->old_status)); ?></strong>
                                <span class="text-muted">to</span>
                                <strong><?php echo e($hist->getStatusLabel($hist->new_status)); ?></strong>
                                <span class="text-muted">by</span>
                                <strong><?php echo e($hist->staff ? $hist->staff->name : 'System'); ?></strong>
                                <?php if($hist->notes && !str_starts_with($hist->notes, 'Status changed from')): ?>
                                <br><small class="text-muted ms-4">Note: <?php echo e($hist->notes); ?></small>
                                <?php endif; ?>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center text-muted">No payment history found</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div><?php /**PATH D:\laragon\www\rise\app\resources\views/myapp/admin/partials/student_payment_history_modal.blade.php ENDPATH**/ ?>