<?php
    // Use the passed props directly
    $items = $items ?? collect();

    // Ensure a collection
    if (!($items instanceof \Illuminate\Support\Collection)) {
        $items = collect($items);
    }

    // For AJAX-enabled selects without a value (create mode), don't render any items
    // Items will be loaded via AJAX when user types
    if ($ajax && !$value && $items->count() > 0) {
        $items = collect();
    }

    // Determine selected values
    $selected = $value ?? old($name);
    if ($multiple && is_null($selected)) {
        $selected = [];
    }
    if ($multiple && !is_array($selected) && $selected instanceof \Illuminate\Support\Collection) {
        $selected = $selected->toArray();
    }
    if ($multiple && !is_array($selected)) {
        $selected = (array) $selected;
    }

    // Build data attributes for chain selection
    $chainAttrs = '';
    if ($dependsOn) {
        $chainAttrs .= ' data-depends-on="' . $dependsOn . '"';
        $chainAttrs .= ' data-model="' . e($model ?? '') . '"';
        $chainAttrs .= ' data-filter-column="' . e($filterColumn ?? '') . '"';
        $chainAttrs .= ' data-display="' . e($display) . '"';
        $chainAttrs .= ' data-key="' . e($key) . '"';
        $chainAttrs .= ' data-chain-select="true"';
        // Add initial value for edit mode (handle both single and array)
        if ($selected) {
            if (is_array($selected)) {
                $chainAttrs .= ' data-initial-value="' . e(json_encode($selected)) . '"';
            } else {
                $chainAttrs .= ' data-initial-value="' . e($selected) . '"';
            }
        }
    }

    // Build data attributes for AJAX search
    if ($ajax && $model) {
        $chainAttrs .= ' data-ajax-search="true"';
        $chainAttrs .= ' data-ajax-model="' . e($model) . '"';
        $chainAttrs .= ' data-ajax-display="' . e($display) . '"';
        $chainAttrs .= ' data-ajax-key="' . e($key) . '"';
        $chainAttrs .= ' data-ajax-limit="' . e($ajaxLimit ?? 20) . '"';
    }
?>

<select
    name="<?php echo e($name); ?><?php echo e($multiple ? '[]' : ''); ?>"
    <?php echo e($multiple ? 'multiple' : ''); ?>

    <?php echo $chainAttrs; ?>

    <?php echo e($attributes->except(['items','display','key','placeholder','value','multiple','name','dependsOn','filterColumn','model'])); ?>

>
    <?php if($placeholder !== null && !$multiple): ?>
        <option value=""><?php echo e($placeholder); ?></option>
    <?php endif; ?>

    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            // support arrays or objects
            $optValue = is_array($item) ? ($item[$key] ?? null) : ($item->{$key} ?? null);
            $optLabel = is_array($item) ? ($item[$display] ?? null) : ($item->{$display} ?? null);
            $isSelected = $multiple
                        ? in_array((string)$optValue, array_map('strval', (array)$selected))
                        : ((string)$optValue === (string)$selected);
        ?>
        <option value="<?php echo e($optValue); ?>" <?php echo e($isSelected ? 'selected' : ''); ?>><?php echo e($optLabel); ?></option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
<?php /**PATH D:\laragon\www\rise\app\resources\views/components/form/select.blade.php ENDPATH**/ ?>