<div class="modal-header">
  <h5 class="modal-title" id="challanModalLabel"><?php echo e(isset($challan) ? 'Edit Fee Challan' : 'Create New Fee Challan'); ?></h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
  <form id="form-add-challan" method="POST" action="<?php echo e(isset($challan) ? route('admin.student.challan.update', $challan->encrypted_id) : route('admin.student.challan.store')); ?>">
    <?php echo csrf_field(); ?>
    <?php if(isset($challan)): ?>
      <?php echo method_field('PUT'); ?>
      <input type="hidden" name="challan_id" value="<?php echo e($challan->id); ?>">
    <?php endif; ?>

    <!-- Challan Number and Status -->
    <div class="row mb-3">
      <div class="col-md-6">
        <label for="challan_no" class="form-label">Challan Number <span class="text-danger">*</span></label>
        <input 
          type="text" 
          class="form-control" 
          id="challan_no" 
          name="challan_no" 
          value="<?php echo e(isset($challan) ? $challan->challan_no : $nextChallanNo); ?>"
          readonly>
        <small class="text-muted"><?php echo e(isset($challan) ? 'Cannot be changed' : 'Auto-generated'); ?></small>
      </div>
      <div class="col-md-6">
        <label for="status" class="form-label">Status</label>
        <select class="form-select" id="status" name="status">
          <option value="0" <?php echo e(isset($challan) && $challan->status == 0 ? 'selected' : ''); ?>>Issued</option>
          <option value="1" <?php echo e(isset($challan) && $challan->status == 1 ? 'selected' : ''); ?>>Pending</option>
          <option value="2" <?php echo e(isset($challan) && $challan->status == 2 ? 'selected' : ''); ?>>Waiting Approval</option>
          <option value="3" <?php echo e(isset($challan) && $challan->status == 3 ? 'selected' : ''); ?>>Cancelled</option>
          <option value="4" <?php echo e(isset($challan) && $challan->status == 4 ? 'selected' : ''); ?>>Paid</option>
        </select>
      </div>
    </div>

    <!-- Cancellation Reason (shown only when status is Cancelled) -->
    <div class="row mb-3" id="cancellationReasonContainer" style="display: <?php echo e(isset($challan) && $challan->status == 3 ? 'block' : 'none'); ?>;">
      <div class="col-12">
        <label for="cancellation_reason" class="form-label">Cancellation Reason <span class="text-danger">*</span></label>
        <textarea 
          class="form-control" 
          id="cancellation_reason" 
          name="cancellation_reason" 
          rows="3"
          placeholder="Please provide reason for cancelling this challan"><?php echo e(isset($challan) ? $challan->cancellation_reason : ''); ?></textarea>
        <small class="text-muted">Required when marking challan as cancelled</small>
      </div>
    </div>
    <!-- Payment Details (shown only when status = Paid) -->
    <div class="row mb-3" id="payment_details_row" style="display: <?php echo e(isset($challan) && $challan->status == 4 ? 'block' : 'none'); ?>">
      <div class="col-md-6">
        <label for="payment_method" class="form-label">Payment Method <span class="text-danger">*</span></label>
        <select class="form-select" id="payment_method" name="payment_method">
          <option value="">Select Payment Method</option>
          <option value="cash" <?php echo e(isset($challan) && $challan->payment_method == 'cash' ? 'selected' : ''); ?>>Cash</option>
          <option value="bank_transfer" <?php echo e(isset($challan) && $challan->payment_method == 'bank_transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
        </select>
        <small class="text-muted">Required when marking challan as paid</small>
      </div>
      <div class="col-md-6" id="bank_reference_col" style="display: <?php echo e(isset($challan) && $challan->payment_method == 'bank_transfer' ? 'block' : 'none'); ?>">
        <label for="bank_reference" class="form-label">Bank Transaction Reference <span class="text-danger">*</span></label>
        <input type="text" class="form-control" id="bank_reference" name="bank_reference" 
          value="<?php echo e(isset($challan) ? $challan->bank_reference : ''); ?>" 
          placeholder="Enter bank transaction reference">
        <small class="text-muted">Required for bank transfer payments</small>
      </div>
    </div>
    <!-- Student and Month Selection -->
    <div class="row mb-3">
      <div class="col-md-6">
        <label for="app_student_id" class="form-label">Student <span class="text-danger">*</span></label>
        <select class="form-select select2" id="app_student_id" name="app_student_id" required>
          <option value="">Select Student</option>
          <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($student->id); ?>" 
              <?php echo e(isset($challan) && $challan->app_student_id == $student->id ? 'selected' : ''); ?>

              data-class="<?php echo e($student->app_class_id); ?>" 
              data-class-name="<?php echo e($student->class?->name ?? ''); ?>"
              data-section="<?php echo e($student->app_section_id); ?>"
              data-section-name="<?php echo e($student->section?->name ?? ''); ?>"
              data-class-fee="<?php echo e($student->class?->fee ?? 0); ?>"
              data-student-fee="<?php echo e($student->fee ?? 0); ?>">
              <?php echo e($student->roll_no); ?> - <?php echo e($student->name); ?>

            </option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6">
        <label for="feemonth" class="form-label">Fee Month <span class="text-danger">*</span></label>
        <input type="month" class="form-control" id="feemonth" name="feemonth" 
          value="<?php echo e(isset($challan) ? date('Y-m', strtotime($challan->feemonth)) : ''); ?>" required>
      </div>
    </div>

    <!-- Class and Section -->
    <div class="row mb-3">
      <div class="col-md-6">
        <label for="app_class_id" class="form-label">Class <span class="text-danger">*</span></label>
        <select class="form-select select2" id="app_class_id" name="app_class_id" required>
          <option value="">Select Class</option>
          <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($class->id); ?>" <?php echo e(isset($challan) && $challan->app_class_id == $class->id ? 'selected' : ''); ?>><?php echo e($class->name); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
      <div class="col-md-6">
        <label for="app_section_id" class="form-label">Section <span class="text-danger">*</span></label>
        <select class="form-select select2" id="app_section_id" name="app_section_id" required>
          <option value="">Select Section</option>
        </select>
      </div>
    </div>

    <!-- Custom Fee Option -->
    <div class="row mb-3">
      <div class="col-12">
        <div class="form-check form-switch">
          <input class="form-check-input" type="checkbox" id="useCustomFee" name="use_custom_fee" 
            <?php echo e(isset($challan) && isset($isCustomAmount) && $isCustomAmount ? 'checked' : ''); ?>>
          <label class="form-check-label" for="useCustomFee">
            <strong>Use Custom Fee Amount</strong>
            <small class="text-muted d-block">Enable this for old/historical challans with different fee amounts</small>
          </label>
        </div>
      </div>
    </div>

    <!-- Custom Fee Input (hidden by default) -->
    <div class="row mb-3" id="customFeeContainer" style="display: <?php echo e(isset($challan) && isset($isCustomAmount) && $isCustomAmount ? 'block' : 'none'); ?>;">
      <div class="col-md-12">
        <label for="custom_amount" class="form-label">Custom Fee Amount <span class="text-danger">*</span></label>
        <input 
          type="number" 
          class="form-control" 
          id="custom_amount" 
          name="custom_amount" 
          value="<?php echo e(isset($challan) && isset($isCustomAmount) && $isCustomAmount ? $challan->amount : ''); ?>"
          placeholder="Enter custom fee amount"
          min="0"
          step="0.01">
        <small class="text-muted">This amount will override the auto-calculated fee</small>
      </div>
      <div class="col-md-12 mt-3">
        <label for="description" class="form-label">Description <span class="text-muted">(Optional)</span></label>
        <textarea 
          class="form-control" 
          id="description" 
          name="description" 
          rows="3"
          placeholder="Enter description for the custom charges (e.g., Books, Lab fee, Event charges, etc.)"><?php echo e(isset($challan) ? $challan->description : ''); ?></textarea>
        <small class="text-muted">Explain what these custom charges are for (books, events, lab fees, etc.)</small>
      </div>
    </div>

    <!-- Fee Breakdown Section -->
    <div class="card bg-light mb-3" id="feeBreakdownCard">
      <div class="card-header bg-primary text-white">
        <h6 class="mb-0">Fee Breakdown</h6>
      </div>
      <div class="card-body">
        <table class="table table-sm table-borderless mb-0">
          <tr>
            <td><strong>Expected Class Fee:</strong></td>
            <td class="text-end"><strong>Rs. <span id="classFeeCal">0.00</span></strong></td>
          </tr>
          <tr>
            <td><strong>Student Fee (Payable):</strong></td>
            <td class="text-end"><strong>Rs. <span id="studentFeeCal">0.00</span></strong></td>
          </tr>
          <tr class="table-warning">
            <td><strong>Discount:</strong></td>
            <td class="text-end"><strong>Rs. <span id="discountCal">0.00</span></strong></td>
          </tr>
          <tr>
            <td colspan="2"><hr class="my-2"></td>
          </tr>
          <tr>
            <td><strong>Extra Charges:</strong></td>
            <td class="text-end"><strong>Rs. <span id="extraChargesCal">0.00</span></strong></td>
          </tr>
          <tr class="table-success">
            <td><h5 class="mb-0"><strong>Total Payable Amount:</strong></h5></td>
            <td class="text-end"><h5 class="mb-0"><strong>Rs. <span id="totalPayableCal">0.00</span></strong></h5></td>
          </tr>
        </table>
      </div>
    </div>

    <!-- Transaction ID (Optional) -->
    <div class="row mb-3">
      <div class="col-12">
        <label for="transid" class="form-label">Transaction ID (Optional)</label>
        <input 
          type="text" 
          class="form-control" 
          id="transid" 
          name="transid" 
          value="<?php echo e(isset($challan) ? $challan->transid : ''); ?>"
          placeholder="Auto-generated when status is Waiting Approval or Paid"
          readonly>
        <small class="text-muted">This field is auto-generated by the system</small>
      </div>
    </div>

    <!-- Hidden field to store calculated amount -->
    <input type="hidden" id="amount" name="amount" value="0">

    <!-- Submit Button -->
    <div class="modal-footer">
      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      <button type="submit" class="btn btn-primary"><?php echo e(isset($challan) ? 'Update Challan' : 'Create Challan'); ?></button>
    </div>
  </form>
</div>

<script>
(function() {
  console.log('Challan form script loaded');
  
  const studentSelect = $('#app_student_id');
  const classSelect = $('#app_class_id');
  const sectionSelect = $('#app_section_id');
  const feemonthInput = $('#feemonth');
  const amountInput = $('#amount');
  const form = $('#form-add-challan');
  
  console.log('Student select found:', studentSelect.length);
  console.log('Initial student options:', studentSelect.find('option').length);

  // Variable to store pending section ID during class change
  let pendingSectionId = null;

  <?php if(isset($challan)): ?>
  // Edit mode: Store the section ID to select after sections are loaded
  pendingSectionId = <?php echo e($challan->app_section_id); ?>;
  console.log('Edit mode: pending section ID:', pendingSectionId);
  <?php endif; ?>

  // Wait for Select2 to be fully initialized before attaching event handlers
  setTimeout(function() {
    console.log('Attaching event handlers after delay');
    console.log('Class dropdown has', classSelect.find('option').length, 'options');
    console.log('Class dropdown options:', classSelect.find('option').map(function() { return $(this).val() + ':' + $(this).text(); }).get());
    
    // Function to load sections for a class
    function loadSections(classId) {
      console.log('loadSections called with classId:', classId);
      
      // Clear current options (preserve Select2)
      sectionSelect.html('<option value="">Select Section</option>');
      
      if (classId) {
        console.log('Loading sections for class:', classId);
        $.ajax({
          url: `/api/sections-by-class/${classId}`,
          method: 'GET',
          dataType: 'json',
          success: function(data) {
            console.log('Sections loaded:', data.length, 'sections', data);
            
            // Build options HTML
            let optionsHtml = '<option value="">Select Section</option>';
            data.forEach(section => {
              optionsHtml += `<option value="${section.id}">${section.name}</option>`;
            });
            
            // Set the HTML and trigger change
            sectionSelect.html(optionsHtml);
            
            if (pendingSectionId) {
              console.log('Attempting to select pending section:', pendingSectionId);
              // Small delay to ensure Select2 has processed the new options
              setTimeout(function() {
                let exists = sectionSelect.find(`option[value="${pendingSectionId}"]`).length > 0;
                
                if (exists) {
                  sectionSelect.val(pendingSectionId).trigger('change');
                  console.log('Pending section selected successfully');
                } else {
                  console.warn('Pending section ID not found in options:', pendingSectionId);
                }
                // Clear pending ID after use
                pendingSectionId = null;
              }, 50);
            } else {
              // Just trigger change to update Select2
              sectionSelect.trigger('change');
            }
          },
          error: function(xhr, status, error) {
            console.error('Error loading sections:', status, error);
            console.error('Response:', xhr.responseText);
          }
        });
      } else {
          sectionSelect.trigger('change');
      }
    }
    
    // Load sections when class changes (both regular change and Select2 change)
    classSelect.on('change', function() {
      const classId = $(this).val();
      console.log('Class change event fired, value:', classId);
      loadSections(classId);
    });

    // Update class, section, and fee breakdown when student is selected
    studentSelect.on('select2:select', function(e) {
      const data = e.params.data;
      const $option = $(data.element);
      const classId = $option.attr('data-class');
      const sectionId = $option.attr('data-section');
      const classFee = parseFloat($option.attr('data-class-fee')) || 0;
      const studentFee = parseFloat($option.attr('data-student-fee')) || 0;

      console.log('Student selected - Class ID:', classId, 'Section ID:', sectionId);

      // Auto-select class and section if available
      if (classId && classId !== '' && classId !== 'null') {
        const classOption = classSelect.find('option[value="' + classId + '"]');
        
        if (classOption.length > 0) {
          if (sectionId && sectionId !== '' && sectionId !== 'null') {
            pendingSectionId = sectionId;
            console.log('Set pending section ID:', pendingSectionId);
          }
          // Set the value and trigger change
          classSelect.val(classId).trigger('change');
          console.log('Triggered class change for:', classId);
        } else {
          console.warn('Class option not found for ID:', classId);
        }
      }

      // Update fee breakdown
      updateFeeBreakdown(classFee, studentFee);
    });

    <?php if(isset($challan)): ?>
    // Edit mode: Trigger class change to load sections
    console.log('Edit mode: Triggering class change to load sections');
    if (classSelect.val()) {
      classSelect.trigger('change');
    }
    
    // Edit mode: Calculate and display fee breakdown if not using custom amount
    <?php if(!isset($isCustomAmount) || !$isCustomAmount): ?>
    console.log('Edit mode: Calculating fee breakdown');
    const selectedStudent = studentSelect.find('option:selected');
    if (selectedStudent.val()) {
      const classFee = parseFloat(selectedStudent.attr('data-class-fee')) || 0;
      const studentFee = parseFloat(selectedStudent.attr('data-student-fee')) || 0;
      console.log('Edit mode fees - Class:', classFee, 'Student:', studentFee);
      updateFeeBreakdown(classFee, studentFee);
    }
    <?php endif; ?>
    <?php endif; ?>
  }, 150);

  // Toggle custom fee input visibility
  const useCustomFeeCheckbox = $('#useCustomFee');
  const customFeeContainer = $('#customFeeContainer');
  const customAmountInput = $('#custom_amount');
  const feeBreakdownCard = $('#feeBreakdownCard');
  const statusSelect = $('#status');
  const cancellationReasonContainer = $('#cancellationReasonContainer');
  const cancellationReasonTextarea = $('#cancellation_reason');
  const paymentDetailsRow = $('#payment_details_row');
  const paymentMethodSelect = $('#payment_method');
  const bankReferenceCol = $('#bank_reference_col');
  const bankReferenceInput = $('#bank_reference');

  // Toggle cancellation reason and payment details based on status
  statusSelect.on('change', function() {
    const statusValue = parseInt($(this).val());
    
    // Handle cancellation reason
    if (statusValue === 3) { // Cancelled
      cancellationReasonContainer.slideDown();
      cancellationReasonTextarea.prop('required', true);
    } else {
      cancellationReasonContainer.slideUp();
      cancellationReasonTextarea.prop('required', false);
      cancellationReasonTextarea.val('');
    }
    
    // Handle payment details
    if (statusValue === 4) { // Paid
      paymentDetailsRow.slideDown();
      paymentMethodSelect.prop('required', true);
    } else {
      paymentDetailsRow.slideUp();
      paymentMethodSelect.prop('required', false);
      bankReferenceCol.hide();
      bankReferenceInput.prop('required', false);
    }
  });
  
  // Toggle bank reference field based on payment method
  paymentMethodSelect.on('change', function() {
    const paymentMethod = $(this).val();
    
    if (paymentMethod === 'bank_transfer') {
      bankReferenceCol.slideDown();
      bankReferenceInput.prop('required', true);
    } else {
      bankReferenceCol.slideUp();
      bankReferenceInput.prop('required', false);
      bankReferenceInput.val('');
    }
  });

  useCustomFeeCheckbox.on('change', function() {
    if ($(this).is(':checked')) {
      customFeeContainer.slideDown();
      feeBreakdownCard.slideUp();
      customAmountInput.prop('required', true);
      $('#amount').val(customAmountInput.val() || 0);
    } else {
      customFeeContainer.slideUp();
      feeBreakdownCard.slideDown();
      customAmountInput.prop('required', false);
      customAmountInput.val('');
      // Recalculate auto fee
      const selectedOption = studentSelect.find('option:selected');
      if (selectedOption.val()) {
        const classFee = parseFloat(selectedOption.attr('data-class-fee')) || 0;
        const studentFee = parseFloat(selectedOption.attr('data-student-fee')) || 0;
        updateFeeBreakdown(classFee, studentFee);
      }
    }
  });

  // Update hidden amount when custom amount changes
  customAmountInput.on('input', function() {
    if (useCustomFeeCheckbox.is(':checked')) {
      $('#amount').val($(this).val() || 0);
    }
  });

  // Recalculate when month changes
  feemonthInput.on('change', function() {
    const selectedOption = studentSelect.find('option:selected');
    if (selectedOption.val()) {
      const classFee = parseFloat(selectedOption.data('class-fee')) || 0;
      const studentFee = parseFloat(selectedOption.data('student-fee')) || 0;
      updateFeeBreakdown(classFee, studentFee);
    }
  });

  function updateFeeBreakdown(classFee, studentFee) {
    const discount = Math.max(0, classFee - studentFee);
    const studentId = studentSelect.val();
    const month = feemonthInput.val(); // Format: YYYY-MM

    let extraCharges = 0;
    
    if (studentId && month) {
      // Fetch extra charges
      $.ajax({
        url: '/admin/student/fee-extras',
        data: { student_id: studentId, month: month },
        success: function(data) {
          extraCharges = parseFloat(data.total) || 0;
          const totalPayable = studentFee + extraCharges;
          displayFeeBreakdown(classFee, studentFee, discount, extraCharges, totalPayable);
        },
        error: function(e) {
          console.log('Extra charges fetch error', e);
          const totalPayable = studentFee + 0;
          displayFeeBreakdown(classFee, studentFee, discount, 0, totalPayable);
        }
      });
    } else {
      const totalPayable = studentFee + 0;
      displayFeeBreakdown(classFee, studentFee, discount, 0, totalPayable);
    }
  }

  function displayFeeBreakdown(classFee, studentFee, discount, extraCharges, totalPayable) {
    $('#classFeeCal').text(classFee.toFixed(2));
    $('#studentFeeCal').text(studentFee.toFixed(2));
    $('#discountCal').text(discount.toFixed(2));
    $('#extraChargesCal').text(extraCharges.toFixed(2));
    $('#totalPayableCal').text(totalPayable.toFixed(2));
    
    // Only update amount if not using custom fee
    if (!$('#useCustomFee').is(':checked')) {
      $('#amount').val(totalPayable);
    }
  }

  // Handle form submission
  form.on('submit', function(e) {
    e.preventDefault();

    const formData = new FormData(this);
    const url = $(this).attr('action');

    fetch(url, {
      method: 'POST',
      body: formData,
      headers: {
        'X-Requested-With': 'XMLHttpRequest',
        'Accept': 'application/json'
      }
    })
      .then(response => {
        if (!response.ok) {
          return response.json().then(errorData => {
            throw errorData;
          });
        }
        return response.json();
      })
      .then(data => {
        if (data.success) {
          showChallanToast('Fee challan created successfully!', 'success');
          
          // Reload DataTable using global function
          console.log('Attempting to reload table...');
          if (typeof window.reloadChallansTable === 'function') {
            const reloaded = window.reloadChallansTable();
            console.log('Table reload result:', reloaded);
          } else {
            console.error('reloadChallansTable function not found');
            // Fallback: trigger filter button click
            $('#filterBtn').click();
          }
          
          // Close modal and reset form
          const modalEl = document.getElementById('challanModal');
          const modal = bootstrap.Modal.getInstance(modalEl);
          if (modal) modal.hide();
          
          // Reset form
          form[0].reset();
        } else {
          showChallanToast(data.error || 'Failed to create challan', 'error');
        }
      })
      .catch(error => {
        console.error('Error:', error);
        // Handle validation errors
        if (error.errors) {
          const errorMessages = Object.values(error.errors).flat().join('<br>');
          showChallanToast(errorMessages, 'error');
        } else if (error.error) {
          showChallanToast(error.error, 'error');
        } else {
          showChallanToast('An error occurred while creating the challan', 'error');
        }
      });
  });

  function showChallanToast(message, type = 'success') {
    const toastElement = document.getElementById('challanToast');
    if (!toastElement) return;

    const toastTitle = document.getElementById('toastTitle');
    const toastIcon = document.getElementById('toastIcon');
    const toastMessage = document.getElementById('toastMessage');
    const toastHeader = toastElement.querySelector('.toast-header');
    const toastBody = toastElement.querySelector('.toast-body');
    const closeButton = toastHeader.querySelector('.btn-close');
    const timeText = toastHeader.querySelector('.text-muted');

    toastMessage.textContent = message;
    if (type === 'success') {
      toastTitle.textContent = 'Success';
      toastIcon.className = 'ri-checkbox-circle-fill me-2 text-success';
      toastHeader.style.backgroundColor = '#d1e7dd';
      toastHeader.style.borderBottom = '2px solid #198754';
      toastHeader.style.color = '#000';
      toastBody.style.backgroundColor = '#f8f9fa';
      toastBody.style.color = '#000';
      toastBody.style.fontWeight = 'normal';
      toastBody.style.fontSize = '';
      toastElement.style.boxShadow = '';
      toastElement.style.border = '';
      if (closeButton) closeButton.style.filter = '';
      if (timeText) timeText.style.color = '';
    } else {
      toastTitle.textContent = 'Error';
      toastIcon.className = 'ri-error-warning-fill me-2 text-white';
      toastHeader.style.backgroundColor = '#dc3545';
      toastHeader.style.borderBottom = '2px solid #b02a37';
      toastHeader.style.color = '#fff';
      toastBody.style.backgroundColor = '#f8d7da';
      toastBody.style.color = '#842029';
      toastBody.style.fontWeight = '600';
      toastBody.style.fontSize = '0.95rem';
      toastElement.style.boxShadow = '0 0.5rem 1rem rgba(220, 53, 69, 0.4)';
      toastElement.style.border = '2px solid #dc3545';
      if (closeButton) closeButton.style.filter = 'invert(1) brightness(2)';
      if (timeText) timeText.style.color = 'rgba(255, 255, 255, 0.7)';
    }

    const toast = new bootstrap.Toast(toastElement, { delay: type === 'error' ? 6000 : 3000 });
    toast.show();
  }
})();
</script>
<?php /**PATH D:\laragon\www\rise\app\resources\views/myapp/admin/challan_form.blade.php ENDPATH**/ ?>