<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name',
    'label' => null,
    'value' => null,
    'placeholder' => '',
    'helpText' => null,
    'floatingLabel' => true,
    'rows' => 3,
    'readonly' => false,
    'disabled' => false,
    'required' => false,
    'editor' => null, // 'ckeditor', 'quill', or null for plain textarea
    'editorHeight' => 300, // Height in pixels for editor
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name',
    'label' => null,
    'value' => null,
    'placeholder' => '',
    'helpText' => null,
    'floatingLabel' => true,
    'rows' => 3,
    'readonly' => false,
    'disabled' => false,
    'required' => false,
    'editor' => null, // 'ckeditor', 'quill', or null for plain textarea
    'editorHeight' => 300, // Height in pixels for editor
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $textareaValue = $value ?? old($name, '');

    // Generate unique ID if not provided
    $textareaId = $attributes->get('id', $name);
    $helpId = $textareaId . 'Help';

    // Calculate height class from rows
    $heightClass = 'h-px-' . (100 * $rows / 3);

    // Add data attribute for editor initialization
    $editorAttr = $editor ? 'data-editor="' . $editor . '"' : '';
    $editorHeightAttr = $editor ? 'data-editor-height="' . $editorHeight . '"' : '';
?>

<?php if($floatingLabel && $label && !$editor): ?>
    <div class="form-floating form-floating-outline">
        <textarea
            name="<?php echo e($name); ?>"
            id="<?php echo e($textareaId); ?>"
            class="form-control <?php echo e($heightClass); ?>"
            placeholder="<?php echo e($placeholder ?: $label); ?>"
            <?php if($helpText): ?> aria-describedby="<?php echo e($helpId); ?>" <?php endif; ?>
            <?php if($readonly): ?> readonly <?php endif; ?>
            <?php if($disabled): ?> disabled <?php endif; ?>
            <?php if($required): ?> required <?php endif; ?>
            <?php echo e($attributes->except(['label', 'helpText', 'floatingLabel', 'rows', 'value', 'name', 'placeholder', 'readonly', 'disabled', 'required', 'editor', 'editorHeight'])); ?>

        ><?php echo e($textareaValue); ?></textarea>
        <label for="<?php echo e($textareaId); ?>"><?php echo e($label); ?></label>
        <?php if($helpText): ?>
            <div id="<?php echo e($helpId); ?>" class="form-text"><?php echo e($helpText); ?></div>
        <?php endif; ?>
    </div>
<?php else: ?>
    <?php if($label): ?>
        <label for="<?php echo e($textareaId); ?>" class="form-label"><?php echo e($label); ?></label>
    <?php endif; ?>
    <textarea
        name="<?php echo e($name); ?>"
        id="<?php echo e($textareaId); ?>"
        class="form-control <?php echo e(!$editor ? $heightClass : ''); ?>"
        placeholder="<?php echo e($placeholder); ?>"
        <?php if($helpText): ?> aria-describedby="<?php echo e($helpId); ?>" <?php endif; ?>
        <?php if($readonly): ?> readonly <?php endif; ?>
        <?php if($disabled): ?> disabled <?php endif; ?>
        <?php if($required): ?> required <?php endif; ?>
        <?php echo $editorAttr; ?>

        <?php echo $editorHeightAttr; ?>

        <?php echo e($attributes->except(['label', 'helpText', 'floatingLabel', 'rows', 'value', 'name', 'placeholder', 'readonly', 'disabled', 'required', 'editor', 'editorHeight'])); ?>

    ><?php echo e($textareaValue); ?></textarea>
    <?php if($helpText): ?>
        <div id="<?php echo e($helpId); ?>" class="form-text"><?php echo e($helpText); ?></div>
    <?php endif; ?>
<?php endif; ?>

<?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

<?php if($editor === 'ckeditor'): ?>
    <?php if (! $__env->hasRenderedOnce('4977ebf7-76e8-4cb4-9310-a4b7958a7141')): $__env->markAsRenderedOnce('4977ebf7-76e8-4cb4-9310-a4b7958a7141'); ?>
    <script src="https://cdn.ckeditor.com/4.22.1/full/ckeditor.js"></script>
    <?php endif; ?>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof CKEDITOR !== 'undefined') {
                const textarea = document.getElementById('<?php echo e($textareaId); ?>');
                if (textarea && !CKEDITOR.instances['<?php echo e($textareaId); ?>']) {
                    try {
                        CKEDITOR.replace('<?php echo e($textareaId); ?>', {
                            height: <?php echo e($editorHeight); ?>,
                            versionCheck: false,
                            <?php if($readonly): ?>
                            readOnly: true,
                            <?php endif; ?>
                            <?php if($disabled): ?>
                            readOnly: true,
                            <?php endif; ?>
                        });
                        console.log('CKEditor initialized for <?php echo e($textareaId); ?>');
                    } catch(e) {
                        console.error('CKEditor initialization error:', e);
                    }
                }
            } else {
                console.error('CKEditor not loaded');
            }
        });
    </script>
<?php elseif($editor === 'quill'): ?>
    <script>
        (function() {
            function initQuillEditor_<?php echo e(str_replace(['-', '_'], '', $textareaId)); ?>() {
                if (typeof Quill === 'undefined') {
                    setTimeout(initQuillEditor_<?php echo e(str_replace(['-', '_'], '', $textareaId)); ?>, 100);
                    return;
                }

                const textarea = document.getElementById('<?php echo e($textareaId); ?>');
                if (textarea && !textarea.dataset.quillInitialized) {
                    textarea.dataset.quillInitialized = 'true';

                    // Hide the textarea
                    textarea.style.display = 'none';

                    // Create a container for Quill
                    const quillContainer = document.createElement('div');
                    quillContainer.id = '<?php echo e($textareaId); ?>_quill';
                    quillContainer.style.minHeight = '<?php echo e($editorHeight); ?>px';
                    textarea.parentNode.insertBefore(quillContainer, textarea);

                    // Initialize Quill
                    const quill = new Quill('#<?php echo e($textareaId); ?>_quill', {
                        theme: 'snow',
                        placeholder: '<?php echo e($placeholder); ?>',
                        modules: {
                            toolbar: [
                                [{ font: [] }, { size: [] }],
                                ['bold', 'italic', 'underline', 'strike'],
                                [{ color: [] }, { background: [] }],
                                [{ script: 'super' }, { script: 'sub' }],
                                [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
                                [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
                                ['link', 'image', 'video'],
                                ['clean']
                            ]
                        }
                    });

                    // Set initial content
                    const initialContent = textarea.value;
                    if (initialContent) {
                        quill.root.innerHTML = initialContent;
                    }

                    // Update textarea on content change
                    quill.on('text-change', function() {
                        textarea.value = quill.root.innerHTML;
                    });
                }
            }

            // Initialize when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', initQuillEditor_<?php echo e(str_replace(['-', '_'], '', $textareaId)); ?>);
            } else {
                initQuillEditor_<?php echo e(str_replace(['-', '_'], '', $textareaId)); ?>();
            }
        })();
    </script>
<?php endif; ?>
<?php /**PATH D:\laragon\www\rise\app\resources\views/components/form/textarea.blade.php ENDPATH**/ ?>