<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Fee Challans'); ?>

<!-- Vendor Styles -->
<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss',
  'resources/assets/vendor/libs/flatpickr/flatpickr.scss',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss',
  'resources/assets/vendor/libs/@form-validation/form-validation.scss'
  ]); ?>
<?php $__env->stopSection(); ?>

<!-- Vendor Scripts -->
<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/vendor/libs/select2/select2.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js',
  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/flatpickr/flatpickr.js',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.js',
  'resources/assets/vendor/libs/@form-validation/popular.js',
  'resources/assets/vendor/libs/@form-validation/bootstrap5.js',
  'resources/assets/vendor/libs/@form-validation/auto-focus.js'
  ]); ?>
<?php $__env->stopSection(); ?>

<!-- Page Scripts -->
<?php $__env->startSection('page-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')([
  'resources/assets/js/chain-select.js',
  'resources/assets/js/myapp/datatables-challans.js'
  ]); ?>
<script type="module">
  'use strict';

  // Define base URL for AJAX calls
  window.baseUrl = '<?php echo e(config("app.url")); ?>';

  window.addEventListener('load', function() {
    if (typeof $ === 'undefined' || typeof $.fn.select2 === 'undefined') {
      console.error('[ERROR] jQuery or Select2 is not loaded!');
      return;
    }

    var select2Elements = $('.select2');

    if (select2Elements.length) {
      select2Elements.each(function () {
        var $this = $(this);

        if ($this.hasClass('select2-hidden-accessible')) {
          return;
        }

        var select2Config = {
          placeholder: $this.data('placeholder') || 'Select value',
          dropdownParent: $this.parent()
        };

        var dependsOn = $this.data('depends-on');
        var filterColumn = $this.data('filter-column');

        $this.wrap('<div class="position-relative"></div>').select2(select2Config);
      });
    }
  });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Statistics Cards -->
<div class="row g-4 mb-4" id="challanStatsContainer">
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-primary h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-primary"><i class="ri-file-list-3-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-total-challans"><?php echo e($stats['total_challans']); ?></h4>
        </div>
        <p class="mb-0">Total Challans</p>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-warning h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-warning"><i class="ri-file-text-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-active-challans"><?php echo e($stats['issued'] + $stats['pending']); ?></h4>
        </div>
        <p class="mb-0">Active Challans</p>
        <small class="text-muted" id="stat-active-details">Issued: <?php echo e($stats['issued']); ?> | Pending: <?php echo e($stats['pending']); ?></small>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-success h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-success"><i class="ri-money-dollar-circle-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-paid-amount">₨<?php echo e(number_format($stats['paid_amount'], 0)); ?></h4>
        </div>
        <p class="mb-0">Paid Amount</p>
        <small class="text-muted" id="stat-paid-details"><?php echo e($stats['paid']); ?> paid challans</small>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-danger h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-danger"><i class="ri-wallet-3-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-unpaid-amount">₨<?php echo e(number_format($stats['unpaid_amount'], 0)); ?></h4>
        </div>
        <p class="mb-0">Unpaid Amount</p>
        <small class="text-muted">Issued & pending challans</small>
      </div>
    </div>
  </div>
</div>

<div class="row g-4">

  <!-- Filters -->
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-md-3">
          <label for="filterClass" class="form-label">Select Class <span class="text-danger">*</span></label>
          <?php if (isset($component)) { $__componentOriginal36c368e88b7801a467b55faa78ace34f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal36c368e88b7801a467b55faa78ace34f = $attributes; } ?>
<?php $component = App\View\Components\Form\Select::resolve(['name' => 'filterClass','model' => 'App\Models\App_Class','query' => [['where',['app_school_id',Auth::user()->app_school_id]]],'display' => 'name','key' => 'id','placeholder' => 'Select Class'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Form\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'form-control select2','id' => 'filterClass','data-placeholder' => 'Select Class']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal36c368e88b7801a467b55faa78ace34f)): ?>
<?php $attributes = $__attributesOriginal36c368e88b7801a467b55faa78ace34f; ?>
<?php unset($__attributesOriginal36c368e88b7801a467b55faa78ace34f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal36c368e88b7801a467b55faa78ace34f)): ?>
<?php $component = $__componentOriginal36c368e88b7801a467b55faa78ace34f; ?>
<?php unset($__componentOriginal36c368e88b7801a467b55faa78ace34f); ?>
<?php endif; ?>
        </div>
        <div class="col-md-3">
          <label for="filterSection" class="form-label">Select Section <span class="text-danger">*</span></label>
          <?php if (isset($component)) { $__componentOriginal36c368e88b7801a467b55faa78ace34f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal36c368e88b7801a467b55faa78ace34f = $attributes; } ?>
<?php $component = App\View\Components\Form\Select::resolve(['name' => 'filterSection','model' => 'App\Models\App_section','display' => 'name','key' => 'id','dependsOn' => 'filterClass','filterColumn' => 'app_class_id'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('form.select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Form\Select::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'form-control select2','id' => 'filterSection','data-placeholder' => 'Select Section']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal36c368e88b7801a467b55faa78ace34f)): ?>
<?php $attributes = $__attributesOriginal36c368e88b7801a467b55faa78ace34f; ?>
<?php unset($__attributesOriginal36c368e88b7801a467b55faa78ace34f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal36c368e88b7801a467b55faa78ace34f)): ?>
<?php $component = $__componentOriginal36c368e88b7801a467b55faa78ace34f; ?>
<?php unset($__componentOriginal36c368e88b7801a467b55faa78ace34f); ?>
<?php endif; ?>
        </div>
        <div class="col-md-3">
          <label for="filterStatus" class="form-label">Select Status</label>
          <select class="form-select select2" id="filterStatus" name="filterStatus" data-placeholder="Select Status">
            <option value=""></option>
            <option value="0">Issued</option>
            <option value="1">Pending</option>
            <option value="2">Waiting Approval</option>
            <option value="3">Cancelled</option>
            <option value="4">Paid</option>
          </select>
        </div>
        <div class="col-md-3 d-flex align-items-end gap-2">
          <button id="filterBtn" class="btn btn-primary flex-grow-1">Filter</button>
          <button id="clearFilterBtn" class="btn btn-secondary flex-grow-1">Clear</button>
        </div>
      </div>
    </div>
  </div>

  <!-- DataTable with Buttons -->
  <div class="card">
    <div class="card-datatable table-responsive pt-0">
      <table class="datatables-basic table table-bordered">
        <thead class="text-center">
          <tr>
            <th></th>
            <th></th>
            <th>Chal/Date</th>
            <th>Month</th>
            <th>Amount</th>
            <th>Student</th>
            <th>Class/Section</th>
            <th>Trans ID</th>
            <th>Status</th>
            <th>Activity</th>
            <th>Actions</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>

  <!-- Toast Container for Notifications -->
  <div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="challanToast" class="toast fade" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
      <div class="toast-header">
        <i id="toastIcon" class="ri-checkbox-circle-fill me-2"></i>
        <div id="toastTitle" class="me-auto fw-medium">Success</div>
        <small class="text-muted">just now</small>
        <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
      </div>
      <div class="toast-body">
        <span id="toastMessage">Operation completed successfully!</span>
      </div>
    </div>
  </div>

  <!-- Modal for Add/Edit Challan -->
  <div class="modal fade" id="challanModal" tabindex="-1" aria-labelledby="challanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div id="challanModalContent">
          <!-- Content will be loaded via AJAX -->
        </div>
      </div>
    </div>
  </div>

  <!-- Modal for Payment History -->
  <div class="modal fade" id="paymentHistoryModal" tabindex="-1" aria-labelledby="paymentHistoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div id="paymentHistoryModalContent">
          <!-- Content will be loaded via AJAX -->
        </div>
      </div>
    </div>
  </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\rise\app\resources\views/myapp/admin/challan_list.blade.php ENDPATH**/ ?>