<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'name',
    'label' => null,
    'value' => null,
    'type' => 'text',
    'placeholder' => '',
    'helpText' => null,
    'floatingLabel' => true,
    'size' => 'default', // 'sm', 'default', 'lg'
    'readonly' => false,
    'disabled' => false,
    'required' => false,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'name',
    'label' => null,
    'value' => null,
    'type' => 'text',
    'placeholder' => '',
    'helpText' => null,
    'floatingLabel' => true,
    'size' => 'default', // 'sm', 'default', 'lg'
    'readonly' => false,
    'disabled' => false,
    'required' => false,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $inputValue = $value ?? old($name, '');

    // Size classes
    $sizeClass = match($size) {
        'sm' => 'form-control-sm',
        'lg' => 'form-control-lg',
        default => ''
    };

    // Generate unique ID if not provided
    $inputId = $attributes->get('id', $name);
    $helpId = $inputId . 'Help';

    // Build input classes
    $inputClasses = 'form-control ' . $sizeClass;
    if ($readonly && !$disabled) {
        $inputClasses = 'form-control-plaintext px-0';
    }
?>

<?php if($floatingLabel && $label): ?>
    <div class="form-floating form-floating-outline">
        <input
            type="<?php echo e($type); ?>"
            name="<?php echo e($name); ?>"
            id="<?php echo e($inputId); ?>"
            value="<?php echo e($inputValue); ?>"
            class="<?php echo e($inputClasses); ?>"
            placeholder="<?php echo e($placeholder ?: $label); ?>"
            <?php if($helpText): ?> aria-describedby="<?php echo e($helpId); ?>" <?php endif; ?>
            <?php if($readonly): ?> readonly <?php endif; ?>
            <?php if($disabled): ?> disabled <?php endif; ?>
            <?php if($required): ?> required <?php endif; ?>
            <?php echo e($attributes->except(['label', 'helpText', 'floatingLabel', 'size', 'value', 'name', 'type', 'placeholder', 'readonly', 'disabled', 'required'])); ?>

        />
        <label for="<?php echo e($inputId); ?>" <?php if($readonly && !$disabled): ?> class="px-0" <?php endif; ?>><?php echo e($label); ?></label>
        <?php if($helpText): ?>
            <div id="<?php echo e($helpId); ?>" class="form-text"><?php echo e($helpText); ?></div>
        <?php endif; ?>
    </div>
<?php else: ?>
    <?php if($label): ?>
        <label for="<?php echo e($inputId); ?>" class="form-label"><?php echo e($label); ?></label>
    <?php endif; ?>
    <input
        type="<?php echo e($type); ?>"
        name="<?php echo e($name); ?>"
        id="<?php echo e($inputId); ?>"
        value="<?php echo e($inputValue); ?>"
        class="<?php echo e($inputClasses); ?>"
        placeholder="<?php echo e($placeholder); ?>"
        <?php if($helpText): ?> aria-describedby="<?php echo e($helpId); ?>" <?php endif; ?>
        <?php if($readonly): ?> readonly <?php endif; ?>
        <?php if($disabled): ?> disabled <?php endif; ?>
        <?php if($required): ?> required <?php endif; ?>
        <?php echo e($attributes->except(['label', 'helpText', 'floatingLabel', 'size', 'value', 'name', 'type', 'placeholder', 'readonly', 'disabled', 'required'])); ?>

    />
    <?php if($helpText): ?>
        <div id="<?php echo e($helpId); ?>" class="form-text"><?php echo e($helpText); ?></div>
    <?php endif; ?>
<?php endif; ?>

<?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
<?php /**PATH D:\laragon\www\rise\app\resources\views/components/form/input.blade.php ENDPATH**/ ?>