@extends('layouts/layoutMaster')

@section('title', 'Form Components Example - Input, Textarea, Checkbox, Radio & Switch')

<!-- Vendor Styles -->
@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/quill/typography.scss',
  'resources/assets/vendor/libs/quill/katex.scss',
  'resources/assets/vendor/libs/quill/editor.scss'
])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/cleavejs/cleave.js',
  'resources/assets/vendor/libs/cleavejs/cleave-phone.js',
  'resources/assets/vendor/libs/quill/katex.js',
  'resources/assets/vendor/libs/quill/quill.js'
])
@endsection

<!-- Page Scripts -->
@section('page-script')
<script type="module">
  'use strict';

  // Initialize Cleave.js for input masks
  document.addEventListener('DOMContentLoaded', function() {
    // Credit Card Mask
    const creditCardMask = document.querySelector('.credit-card-mask');
    if (creditCardMask) {
      new Cleave(creditCardMask, {
        creditCard: true
      });
    }

    // Phone Number Mask
    const phoneMask = document.querySelector('.phone-number-mask');
    if (phoneMask) {
      new Cleave(phoneMask, {
        phone: true,
        phoneRegionCode: 'US'
      });
    }

    // Date Mask
    const dateMask = document.querySelector('.date-mask');
    if (dateMask) {
      new Cleave(dateMask, {
        date: true,
        delimiter: '-',
        datePattern: ['Y', 'm', 'd']
      });
    }

    // Time Mask
    const timeMask = document.querySelector('.time-mask');
    if (timeMask) {
      new Cleave(timeMask, {
        time: true,
        timePattern: ['h', 'm', 's']
      });
    }

    // Numeral Mask
    const numeralMask = document.querySelector('.numeral-mask');
    if (numeralMask) {
      new Cleave(numeralMask, {
        numeral: true,
        numeralThousandsGroupStyle: 'thousand'
      });
    }

    // Block Mask
    const blockMask = document.querySelector('.block-mask');
    if (blockMask) {
      new Cleave(blockMask, {
        blocks: [4, 3, 3],
        uppercase: true
      });
    }

    // Custom Delimiter Mask
    const customDelimiter = document.querySelector('.custom-delimiter-mask');
    if (customDelimiter) {
      new Cleave(customDelimiter, {
        delimiters: ['.', '.', '-'],
        blocks: [3, 3, 3, 2],
        uppercase: true
      });
    }

    // Prefix Mask
    const prefixMask = document.querySelector('.prefix-mask');
    if (prefixMask) {
      new Cleave(prefixMask, {
        prefix: '+63',
        blocks: [3, 3, 3, 4],
        uppercase: true
      });
    }
  });

  // Initialize Quill Editor
  document.addEventListener('DOMContentLoaded', function() {
    // Full Toolbar
    const fullToolbar = [
      [{ font: [] }, { size: [] }],
      ['bold', 'italic', 'underline', 'strike'],
      [{ color: [] }, { background: [] }],
      [{ script: 'super' }, { script: 'sub' }],
      [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
      [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
      ['link', 'image', 'video'],
      ['clean']
    ];

    // Initialize Full Editor
    const fullEditorEl = document.querySelector('#full-editor');
    if (fullEditorEl) {
      const fullEditor = new Quill('#full-editor', {
        bounds: '#full-editor',
        placeholder: 'Type your content here...',
        modules: {
          toolbar: fullToolbar
        },
        theme: 'snow'
      });

      // Get content on form submit
      const editorForm = document.querySelector('#editor-form');
      if (editorForm) {
        editorForm.addEventListener('submit', function(e) {
          // Get HTML content from Quill editor
          const editorContent = fullEditor.root.innerHTML;
          // Set it to a hidden field or handle it as needed
          console.log('Editor content:', editorContent);
        });
      }
    }

    // Initialize Simple Editor (for edit mode example)
    const editEditorEl = document.querySelector('#edit-editor');
    if (editEditorEl) {
      const editEditor = new Quill('#edit-editor', {
        bounds: '#edit-editor',
        placeholder: 'Type your content here...',
        modules: {
          toolbar: [
            ['bold', 'italic', 'underline'],
            [{ list: 'ordered' }, { list: 'bullet' }],
            ['link']
          ]
        },
        theme: 'snow'
      });
    }
  });
</script>
@endsection

@section('content')
<div class="row">
  <!-- Input Component Examples -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Input Component Examples</h5>
      <div class="card-body">
        <form method="POST" action="#">
          @csrf

          <h6 class="mb-4">Basic Floating Label Inputs (Create Mode)</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="username"
                label="Username"
                placeholder="Enter username"
                helpText="Choose a unique username"
                required
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="email"
                type="email"
                label="Email Address"
                placeholder="john@example.com"
                helpText="We'll never share your email with anyone else"
              />
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="phone"
                type="tel"
                label="Phone Number"
                placeholder="90-(164)-188-556"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="password"
                type="password"
                label="Password"
                placeholder="Enter password"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Non-Floating Label Inputs</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="full_name"
                label="Full Name"
                placeholder="John Doe"
                :floatingLabel="false"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="company"
                label="Company"
                placeholder="Company Name"
                :floatingLabel="false"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Different Sizes</h6>
          <div class="row">
            <div class="col-md-4 mb-6">
              <x-form.input
                name="large_input"
                label="Large Input"
                size="lg"
                placeholder="Large input"
                :floatingLabel="false"
              />
            </div>

            <div class="col-md-4 mb-6">
              <x-form.input
                name="default_input"
                label="Default Input"
                placeholder="Default input"
                :floatingLabel="false"
              />
            </div>

            <div class="col-md-4 mb-6">
              <x-form.input
                name="small_input"
                label="Small Input"
                size="sm"
                placeholder="Small input"
                :floatingLabel="false"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">HTML5 Input Types</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="date"
                type="date"
                label="Date"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="time"
                type="time"
                label="Time"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="datetime"
                type="datetime-local"
                label="Date & Time"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="number"
                type="number"
                label="Number"
                placeholder="18"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="url"
                type="url"
                label="URL"
                placeholder="https://example.com"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="search"
                type="search"
                label="Search"
                placeholder="Search..."
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Readonly & Disabled Inputs</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="readonly_input"
                label="Readonly Input"
                value="This is readonly"
                readonly
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="disabled_input"
                label="Disabled Input"
                value="This is disabled"
                disabled
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="readonly_plain"
                label="Readonly Plain Text"
                value="email@example.com"
                readonly
                :floatingLabel="false"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Edit Mode Example (with pre-filled values)</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="edit_username"
                label="Username"
                value="johndoe123"
                helpText="Edit your username"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="edit_email"
                type="email"
                label="Email Address"
                value="john@example.com"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Input Masks (with Cleave.js)</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="credit_card"
                label="Credit Card"
                placeholder="0000 0000 0000 0000"
                class="credit-card-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">Automatically formats credit card numbers</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="phone_mask"
                type="tel"
                label="Phone Number (US)"
                placeholder="(000) 000-0000"
                class="phone-number-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">US phone number format</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="date_mask"
                label="Date (YYYY-MM-DD)"
                placeholder="YYYY-MM-DD"
                class="date-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">Automatically formats date input</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="time_mask"
                label="Time (HH:MM:SS)"
                placeholder="HH:MM:SS"
                class="time-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">24-hour time format</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="numeral_mask"
                label="Number (Thousands Separator)"
                placeholder="1,000,000"
                class="numeral-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">Formats numbers with thousand separators</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="block_mask"
                label="Block Pattern (AAA-BBB-CCC)"
                placeholder="AAA-BBB-CCC"
                class="block-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">Uppercase blocks with hyphens</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="custom_delimiter"
                label="Custom Delimiter (AAA.BBB.CCC-DD)"
                placeholder="AAA.BBB.CCC-DD"
                class="custom-delimiter-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">Custom delimiters: dots and hyphen</small>
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="prefix_mask"
                label="Prefix (+63 Philippines)"
                placeholder="+63-XXX-XXX-XXXX"
                class="prefix-mask"
                :floatingLabel="false"
              />
              <small class="text-muted">Auto-prefixes with country code</small>
            </div>
          </div>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- Textarea Component Examples -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Textarea Component Examples</h5>
      <div class="card-body">
        <form method="POST" action="#">
          @csrf

          <h6 class="mb-4">Basic Floating Label Textareas (Create Mode)</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="description"
                label="Description"
                placeholder="Enter description here..."
                helpText="Provide a detailed description"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="comments"
                label="Comments"
                placeholder="Your comments..."
                rows="3"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Non-Floating Label Textareas</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="bio"
                label="Biography"
                placeholder="Tell us about yourself..."
                :floatingLabel="false"
                rows="4"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="notes"
                label="Notes"
                placeholder="Add your notes..."
                :floatingLabel="false"
                rows="4"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Different Sizes (rows)</h6>
          <div class="row">
            <div class="col-md-4 mb-6">
              <x-form.textarea
                name="small_textarea"
                label="Small (3 rows)"
                rows="3"
              />
            </div>

            <div class="col-md-4 mb-6">
              <x-form.textarea
                name="medium_textarea"
                label="Medium (5 rows)"
                rows="5"
              />
            </div>

            <div class="col-md-4 mb-6">
              <x-form.textarea
                name="large_textarea"
                label="Large (8 rows)"
                rows="8"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Readonly & Disabled Textareas</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="readonly_textarea"
                label="Readonly Textarea"
                value="This textarea is readonly and cannot be edited."
                readonly
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="disabled_textarea"
                label="Disabled Textarea"
                value="This textarea is disabled."
                disabled
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Edit Mode Example (with pre-filled values)</h6>
          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="edit_description"
                label="Description"
                value="This is an existing description that can be edited."
                rows="4"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.textarea
                name="edit_comments"
                label="Comments"
                value="These are existing comments.
You can edit multiple lines.
Line 3 of comments."
                rows="4"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Required Fields</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              <x-form.textarea
                name="required_field"
                label="Required Field"
                placeholder="This field is required..."
                required
                rows="3"
              />
            </div>
          </div>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- Rich Text Editor (HTML) Examples -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Rich Text Editor (HTML) - Quill Editor</h5>
      <div class="card-body">
        <form method="POST" action="#" id="editor-form">
          @csrf

          <h6 class="mb-4">Full Rich Text Editor (Create Mode)</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              <label class="form-label">Article Content</label>
              <div id="full-editor" style="min-height: 300px;">
                <h6>Welcome to the Rich Text Editor</h6>
                <p>You can type here and format your text with the toolbar above. This editor supports:</p>
                <ul>
                  <li>Bold, italic, underline formatting</li>
                  <li>Headers and blockquotes</li>
                  <li>Ordered and unordered lists</li>
                  <li>Links, images, and videos</li>
                  <li>And much more!</li>
                </ul>
              </div>
              <small class="text-muted">Full-featured WYSIWYG editor with HTML output</small>

              <!-- Hidden field to store HTML content -->
              <input type="hidden" name="content" id="content-field" />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Edit Mode - Pre-filled HTML Content</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              <label class="form-label">Description</label>
              <div id="edit-editor" style="min-height: 200px;">
                <h6>Existing Content</h6>
                <p>This is <strong>existing content</strong> that has been loaded from the database.</p>
                <p>You can edit this content using the editor.</p>
                <ul>
                  <li>Item 1</li>
                  <li>Item 2</li>
                  <li>Item 3</li>
                </ul>
              </div>
              <small class="text-muted">Editor with pre-loaded HTML content for editing</small>
            </div>
          </div>

          <div class="alert alert-info mt-4">
            <strong>How to use Quill Editor in your forms:</strong>
            <ol class="mb-0 mt-2">
              <li>Add the Quill CSS and JS files (already included in this page)</li>
              <li>Create a div with a unique ID (e.g., <code>&lt;div id="my-editor"&gt;&lt;/div&gt;</code>)</li>
              <li>Initialize Quill: <code>new Quill('#my-editor', {{ '{' }}theme: 'snow'{{ '}' }})</code></li>
              <li>Get HTML content: <code>quillInstance.root.innerHTML</code></li>
              <li>Set HTML content: <code>quillInstance.root.innerHTML = 'your html'</code></li>
              <li>Store in hidden field before form submission</li>
            </ol>
          </div>

          <h6 class="mb-4 mt-4">Usage Example Code</h6>
          <pre class="bg-light p-3 rounded"><code>{{-- In Blade Template --}}
&lt;div id="my-editor" style="min-height: 200px;"&gt;
  {{-- For edit mode, you can pre-fill with existing content --}}
  {!! $article->content ?? '' !!}
&lt;/div&gt;

{{-- Hidden field to store the HTML --}}
&lt;input type="hidden" name="content" id="content-field" /&gt;

{{-- In your JavaScript (page-script section) --}}
&lt;script type="module"&gt;
  const editor = new Quill('#my-editor', {
    theme: 'snow',
    modules: {
      toolbar: [
        ['bold', 'italic', 'underline'],
        [{ list: 'ordered' }, { list: 'bullet' }],
        ['link', 'image']
      ]
    }
  });

  // On form submit, store HTML in hidden field
  document.querySelector('#my-form').addEventListener('submit', function() {
    document.querySelector('#content-field').value = editor.root.innerHTML;
  });
&lt;/script&gt;</code></pre>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- CKEditor Examples with Textarea Component -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">CKEditor with Textarea Component</h5>
      <div class="card-body">
        <form method="POST" action="#">
          @csrf

          <h6 class="mb-4">CKEditor - Create Mode</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              <x-form.textarea
                name="article_content"
                label="Article Content"
                placeholder="Start writing your article..."
                editor="ckeditor"
                :editorHeight="400"
                :floatingLabel="false"
              />
              <small class="text-muted">Full-featured WYSIWYG editor with CKEditor 4.22.1</small>
            </div>
          </div>

          <h6 class="mb-4 mt-4">CKEditor - Edit Mode (Pre-filled HTML)</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              @php
                $existingContent = '<h2>Existing Article Title</h2>
<p>This is <strong>existing HTML content</strong> loaded from the database.</p>
<ul>
  <li>Feature 1</li>
  <li>Feature 2</li>
  <li>Feature 3</li>
</ul>
<p>You can <em>edit</em> this content using the rich text editor.</p>';
              @endphp
              <x-form.textarea
                name="article_edit"
                label="Edit Article"
                :value="$existingContent"
                editor="ckeditor"
                :editorHeight="350"
                :floatingLabel="false"
              />
              <small class="text-muted">Editor with pre-loaded HTML content</small>
            </div>
          </div>

          <h6 class="mb-4 mt-4">Quill Editor - Using Textarea Component</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              <x-form.textarea
                name="description_quill"
                label="Description (Quill)"
                placeholder="Write your description..."
                editor="quill"
                :editorHeight="250"
                :floatingLabel="false"
              />
              <small class="text-muted">Quill editor initialized via textarea component</small>
            </div>
          </div>

          <h6 class="mb-4 mt-4">Quill Editor - Edit Mode</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              @php
                $quillExistingContent = '<h3>Product Description</h3>
<p>This product includes:</p>
<ol>
  <li>High quality materials</li>
  <li>2-year warranty</li>
  <li>Free shipping</li>
</ol>';
              @endphp
              <x-form.textarea
                name="description_quill_edit"
                label="Product Description"
                :value="$quillExistingContent"
                editor="quill"
                :editorHeight="250"
                :floatingLabel="false"
              />
              <small class="text-muted">Quill editor with pre-loaded content</small>
            </div>
          </div>

          <h6 class="mb-4 mt-4">Plain Textarea (No Editor)</h6>
          <div class="row">
            <div class="col-md-12 mb-6">
              <x-form.textarea
                name="plain_notes"
                label="Plain Text Notes"
                placeholder="Enter plain text notes..."
                rows="5"
                :floatingLabel="false"
              />
              <small class="text-muted">Regular textarea without any editor</small>
            </div>
          </div>

          <div class="alert alert-info mt-4">
            <strong>Using Rich Text Editors with Textarea Component:</strong>
            <ol class="mb-0 mt-2">
              <li><strong>CKEditor:</strong> Set <code>editor="ckeditor"</code> prop</li>
              <li><strong>Quill Editor:</strong> Set <code>editor="quill"</code> prop</li>
              <li><strong>Plain Textarea:</strong> Omit the <code>editor</code> prop or set it to <code>null</code></li>
              <li><strong>Height:</strong> Control editor height with <code>:editorHeight="400"</code> (in pixels)</li>
              <li><strong>Edit Mode:</strong> Pre-fill content with <code>:value="$htmlContent"</code></li>
              <li>The component automatically handles editor initialization and data binding</li>
            </ol>
          </div>

          <h6 class="mb-4 mt-4">Usage Examples</h6>
          <pre class="bg-light p-3 rounded"><code>{{-- CKEditor Example --}}
&lt;x-form.textarea
  name="content"
  label="Article Content"
  editor="ckeditor"
  :editorHeight="400"
  :floatingLabel="false"
/&gt;

{{-- CKEditor with Pre-filled Content (Edit Mode) --}}
&lt;x-form.textarea
  name="content"
  label="Article Content"
  :value="$article->content"
  editor="ckeditor"
  :editorHeight="400"
  :floatingLabel="false"
/&gt;

{{-- Quill Editor Example --}}
&lt;x-form.textarea
  name="description"
  label="Description"
  editor="quill"
  :editorHeight="250"
  :floatingLabel="false"
/&gt;

{{-- Quill with Pre-filled Content --}}
&lt;x-form.textarea
  name="description"
  label="Description"
  :value="$product->description"
  editor="quill"
  :editorHeight="250"
  :floatingLabel="false"
/&gt;

{{-- Plain Textarea (No Editor) --}}
&lt;x-form.textarea
  name="notes"
  label="Notes"
  rows="5"
  :floatingLabel="false"
/&gt;</code></pre>

          <h6 class="mb-4 mt-4">Available Editor Props:</h6>
          <ul>
            <li><code>editor</code> - Editor type: 'ckeditor', 'quill', or null (default: null)</li>
            <li><code>editorHeight</code> - Editor height in pixels (default: 300)</li>
            <li><code>value</code> - Pre-filled HTML content for edit mode</li>
            <li><code>label</code> - Field label</li>
            <li><code>name</code> - Input name attribute</li>
            <li><code>floatingLabel</code> - Use floating label style (not recommended with editors)</li>
            <li><code>helpText</code> - Helper text below the editor</li>
            <li><code>required</code> - Make field required</li>
          </ul>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- Combined Form Example (Create & Edit) -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Complete Form Example - Create & Edit Mode</h5>
      <div class="card-body">
        @php
          // Simulate edit mode with example data
          $editMode = true;
          $user = (object)[
            'name' => 'John Doe',
            'email' => 'john.doe@example.com',
            'phone' => '+1-234-567-8900',
            'address' => '123 Main Street, Apartment 4B',
            'bio' => 'Software developer with 5 years of experience in web development.',
            'website' => 'https://johndoe.com'
          ];
        @endphp

        <form method="POST" action="#">
          @csrf
          @if($editMode)
            @method('PUT')
          @endif

          <div class="alert alert-info mb-4">
            <strong>Mode:</strong> {{ $editMode ? 'Edit Mode (values pre-filled)' : 'Create Mode (empty form)' }}
          </div>

          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="user_name"
                label="Full Name"
                :value="$editMode ? $user->name : null"
                placeholder="Enter full name"
                required
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="user_email"
                type="email"
                label="Email Address"
                :value="$editMode ? $user->email : null"
                placeholder="Enter email"
                required
              />
            </div>
          </div>

          <div class="row">
            <div class="col-md-6 mb-6">
              <x-form.input
                name="user_phone"
                type="tel"
                label="Phone Number"
                :value="$editMode ? $user->phone : null"
                placeholder="Enter phone number"
              />
            </div>

            <div class="col-md-6 mb-6">
              <x-form.input
                name="user_website"
                type="url"
                label="Website"
                :value="$editMode ? $user->website : null"
                placeholder="https://example.com"
              />
            </div>
          </div>

          <div class="row">
            <div class="col-md-12 mb-6">
              <x-form.input
                name="user_address"
                label="Address"
                :value="$editMode ? $user->address : null"
                placeholder="Enter address"
              />
            </div>
          </div>

          <div class="row">
            <div class="col-md-12 mb-6">
              <x-form.textarea
                name="user_bio"
                label="Biography"
                :value="$editMode ? $user->bio : null"
                placeholder="Tell us about yourself..."
                rows="5"
              />
            </div>
          </div>

          <div class="d-flex justify-content-end gap-2">
            <button type="button" class="btn btn-outline-secondary">Cancel</button>
            <button type="submit" class="btn btn-primary">
              {{ $editMode ? 'Update' : 'Create' }}
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- Checkbox Component Examples -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Checkbox Component Examples</h5>
      <div class="card-body">
        <form method="POST" action="#">
          @csrf

          <h6 class="mb-4">Basic Checkboxes</h6>
          <div class="row">
            <div class="col-md-6 mb-4">
              <x-form.checkbox
                name="terms"
                label="I agree to terms and conditions"
              />
              <x-form.checkbox
                name="newsletter"
                label="Subscribe to newsletter"
                checked
              />
              <x-form.checkbox
                name="notifications"
                label="Enable notifications"
              />
              <x-form.checkbox
                name="disabled_checkbox"
                label="Disabled checkbox"
                disabled
              />
            </div>

            <div class="col-md-6 mb-4">
              <small class="text-light fw-medium d-block mb-3">Inline Checkboxes</small>
              <x-form.checkbox
                name="option1"
                label="Option 1"
                inline
              />
              <x-form.checkbox
                name="option2"
                label="Option 2"
                inline
              />
              <x-form.checkbox
                name="option3"
                label="Option 3 (disabled)"
                inline
                disabled
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Colored Checkboxes</h6>
          <div class="row">
            <div class="col-md-12 mb-4">
              <x-form.checkbox
                name="primary_check"
                label="Primary"
                color="primary"
                checked
              />
              <x-form.checkbox
                name="secondary_check"
                label="Secondary"
                color="secondary"
                checked
              />
              <x-form.checkbox
                name="success_check"
                label="Success"
                color="success"
                checked
              />
              <x-form.checkbox
                name="danger_check"
                label="Danger"
                color="danger"
                checked
              />
              <x-form.checkbox
                name="warning_check"
                label="Warning"
                color="warning"
                checked
              />
              <x-form.checkbox
                name="info_check"
                label="Info"
                color="info"
                checked
              />
              <x-form.checkbox
                name="dark_check"
                label="Dark"
                color="dark"
                checked
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Edit Mode - Multiple Checkboxes (Pre-selected)</h6>
          <div class="row">
            <div class="col-md-12 mb-4">
              @php
                $userPermissions = ['read', 'write']; // Simulating existing permissions
              @endphp
              <x-form.checkbox
                name="permissions[]"
                value="read"
                label="Read Permission"
                :checked="in_array('read', $userPermissions)"
              />
              <x-form.checkbox
                name="permissions[]"
                value="write"
                label="Write Permission"
                :checked="in_array('write', $userPermissions)"
              />
              <x-form.checkbox
                name="permissions[]"
                value="delete"
                label="Delete Permission"
                :checked="in_array('delete', $userPermissions)"
              />
              <x-form.checkbox
                name="permissions[]"
                value="admin"
                label="Admin Permission"
                :checked="in_array('admin', $userPermissions)"
              />
            </div>
          </div>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- Radio Component Examples -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Radio Component Examples</h5>
      <div class="card-body">
        <form method="POST" action="#">
          @csrf

          <h6 class="mb-4">Basic Radio Buttons</h6>
          <div class="row">
            <div class="col-md-6 mb-4">
              <small class="text-light fw-medium d-block mb-3">Gender</small>
              <x-form.radio
                name="gender"
                value="male"
                label="Male"
              />
              <x-form.radio
                name="gender"
                value="female"
                label="Female"
                checked
              />
              <x-form.radio
                name="gender"
                value="other"
                label="Other"
              />
            </div>

            <div class="col-md-6 mb-4">
              <small class="text-light fw-medium d-block mb-3">Inline Radio Buttons</small>
              <x-form.radio
                name="payment"
                value="card"
                label="Credit Card"
                inline
              />
              <x-form.radio
                name="payment"
                value="paypal"
                label="PayPal"
                inline
              />
              <x-form.radio
                name="payment"
                value="bank"
                label="Bank Transfer"
                inline
                disabled
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Colored Radio Buttons</h6>
          <div class="row">
            <div class="col-md-12 mb-4">
              <x-form.radio
                name="color_radio"
                value="primary"
                label="Primary"
                color="primary"
                checked
              />
              <x-form.radio
                name="color_radio"
                value="secondary"
                label="Secondary"
                color="secondary"
              />
              <x-form.radio
                name="color_radio"
                value="success"
                label="Success"
                color="success"
              />
              <x-form.radio
                name="color_radio"
                value="danger"
                label="Danger"
                color="danger"
              />
              <x-form.radio
                name="color_radio"
                value="warning"
                label="Warning"
                color="warning"
              />
              <x-form.radio
                name="color_radio"
                value="info"
                label="Info"
                color="info"
              />
              <x-form.radio
                name="color_radio"
                value="dark"
                label="Dark"
                color="dark"
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Edit Mode - Radio (Pre-selected)</h6>
          <div class="row">
            <div class="col-md-6 mb-4">
              @php
                $userRole = 'editor'; // Simulating existing role
              @endphp
              <small class="text-light fw-medium d-block mb-3">User Role</small>
              <x-form.radio
                name="role"
                value="admin"
                label="Administrator"
                :checked="$userRole === 'admin'"
              />
              <x-form.radio
                name="role"
                value="editor"
                label="Editor"
                :checked="$userRole === 'editor'"
              />
              <x-form.radio
                name="role"
                value="viewer"
                label="Viewer"
                :checked="$userRole === 'viewer'"
              />
            </div>

            <div class="col-md-6 mb-4">
              @php
                $accountType = 'premium'; // Simulating existing account type
              @endphp
              <small class="text-light fw-medium d-block mb-3">Account Type</small>
              <x-form.radio
                name="account_type"
                value="free"
                label="Free"
                :checked="$accountType === 'free'"
              />
              <x-form.radio
                name="account_type"
                value="premium"
                label="Premium"
                :checked="$accountType === 'premium'"
              />
              <x-form.radio
                name="account_type"
                value="enterprise"
                label="Enterprise"
                :checked="$accountType === 'enterprise'"
              />
            </div>
          </div>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- Switch Component Examples -->
  <div class="col-12">
    <div class="card mb-6">
      <h5 class="card-header">Switch Component Examples</h5>
      <div class="card-body">
        <form method="POST" action="#">
          @csrf

          <h6 class="mb-4">Basic Switches</h6>
          <div class="row">
            <div class="col-md-6 mb-4">
              <x-form.switch
                name="email_notifications"
                label="Email Notifications"
              />
              <x-form.switch
                name="sms_notifications"
                label="SMS Notifications"
                checked
              />
              <x-form.switch
                name="push_notifications"
                label="Push Notifications"
              />
              <x-form.switch
                name="disabled_switch"
                label="Disabled Switch"
                disabled
              />
              <x-form.switch
                name="disabled_checked_switch"
                label="Disabled Checked Switch"
                checked
                disabled
              />
            </div>

            <div class="col-md-6 mb-4">
              <small class="text-light fw-medium d-block mb-3">Privacy Settings</small>
              <x-form.switch
                name="profile_public"
                label="Public Profile"
                checked
              />
              <x-form.switch
                name="show_email"
                label="Show Email Address"
              />
              <x-form.switch
                name="show_phone"
                label="Show Phone Number"
              />
              <x-form.switch
                name="allow_messages"
                label="Allow Direct Messages"
                checked
              />
            </div>
          </div>

          <h6 class="mb-4 mt-4">Edit Mode - Switches (Pre-selected)</h6>
          <div class="row">
            <div class="col-md-6 mb-4">
              @php
                $settings = [
                  'two_factor' => true,
                  'marketing_emails' => false,
                  'auto_backup' => true,
                ];
              @endphp
              <small class="text-light fw-medium d-block mb-3">Account Settings</small>
              <x-form.switch
                name="two_factor"
                label="Two-Factor Authentication"
                :checked="$settings['two_factor']"
              />
              <x-form.switch
                name="marketing_emails"
                label="Marketing Emails"
                :checked="$settings['marketing_emails']"
              />
              <x-form.switch
                name="auto_backup"
                label="Automatic Backup"
                :checked="$settings['auto_backup']"
              />
            </div>

            <div class="col-md-6 mb-4">
              @php
                $features = [
                  'dark_mode' => true,
                  'compact_view' => false,
                  'show_avatars' => true,
                ];
              @endphp
              <small class="text-light fw-medium d-block mb-3">Display Settings</small>
              <x-form.switch
                name="dark_mode"
                label="Dark Mode"
                :checked="$features['dark_mode']"
              />
              <x-form.switch
                name="compact_view"
                label="Compact View"
                :checked="$features['compact_view']"
              />
              <x-form.switch
                name="show_avatars"
                label="Show Avatars"
                :checked="$features['show_avatars']"
              />
            </div>
          </div>

          <button type="submit" class="btn btn-primary">Submit</button>
        </form>
      </div>
    </div>
  </div>

  <!-- Usage Examples with Code -->
  <div class="col-12">
    <div class="card">
      <h5 class="card-header">Component Usage Examples</h5>
      <div class="card-body">
        <h6 class="mb-3">Input Component - Basic Usage</h6>
        <pre><code>&lt;x-form.input
  name="username"
  label="Username"
  placeholder="Enter username"
  helpText="Choose a unique username"
  required
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Input Component - Edit Mode (with value)</h6>
        <pre><code>&lt;x-form.input
  name="username"
  label="Username"
  {{-- value="{{ $user->username }}" --}}
  value="Shahzad"
  required
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Textarea Component - Basic Usage</h6>
        <pre><code>&lt;x-form.textarea
  name="description"
  label="Description"
  placeholder="Enter description..."
  rows="5"
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Textarea Component - Edit Mode (with value)</h6>
        <pre><code>&lt;x-form.textarea
  name="description"
  label="Description"
  {{-- value="{{ $item->description }}" --}}
  value="This is description"
  rows="5"
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Available Props for Input Component:</h6>
        <ul>
          <li><code>name</code> (required) - Input name attribute</li>
          <li><code>label</code> - Label text</li>
          <li><code>value</code> - Pre-filled value (for edit mode)</li>
          <li><code>type</code> - Input type (text, email, password, tel, url, number, date, etc.)</li>
          <li><code>placeholder</code> - Placeholder text</li>
          <li><code>helpText</code> - Helper text below input</li>
          <li><code>floatingLabel</code> - Enable floating label (default: true)</li>
          <li><code>size</code> - Input size: 'sm', 'default', 'lg'</li>
          <li><code>readonly</code> - Make input readonly</li>
          <li><code>disabled</code> - Make input disabled</li>
          <li><code>required</code> - Make input required</li>
        </ul>

        <h6 class="mb-3 mt-4">Available Props for Textarea Component:</h6>
        <ul>
          <li><code>name</code> (required) - Textarea name attribute</li>
          <li><code>label</code> - Label text</li>
          <li><code>value</code> - Pre-filled value (for edit mode)</li>
          <li><code>placeholder</code> - Placeholder text</li>
          <li><code>helpText</code> - Helper text below textarea</li>
          <li><code>floatingLabel</code> - Enable floating label (default: true)</li>
          <li><code>rows</code> - Number of rows (default: 3)</li>
          <li><code>readonly</code> - Make textarea readonly</li>
          <li><code>disabled</code> - Make textarea disabled</li>
          <li><code>required</code> - Make textarea required</li>
        </ul>

        <h6 class="mb-3 mt-4">Checkbox Component - Basic Usage</h6>
        <pre><code>&lt;x-form.checkbox
  name="terms"
  label="I agree to terms and conditions"
  checked
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Checkbox Component - Multiple Checkboxes (Edit Mode)</h6>
        <pre><code>{{-- @php
  $userPermissions = ['read', 'write'];
@endphp --}}

&lt;x-form.checkbox
  name="permissions[]"
  value="read"
  label="Read Permission"
  {{-- :checked="in_array('read', $userPermissions)" --}}
  checked
/&gt;
&lt;x-form.checkbox
  name="permissions[]"
  value="write"
  label="Write Permission"
  {{-- :checked="in_array('write', $userPermissions)" --}}
  checked
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Radio Component - Basic Usage</h6>
        <pre><code>&lt;x-form.radio
  name="gender"
  value="male"
  label="Male"
/&gt;
&lt;x-form.radio
  name="gender"
  value="female"
  label="Female"
  checked
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Radio Component - Edit Mode (Pre-selected)</h6>
        <pre><code>{{-- @php
  $userRole = 'editor';
@endphp --}}

&lt;x-form.radio
  name="role"
  value="admin"
  label="Administrator"
  {{-- :checked="$userRole === 'admin'" --}}
/&gt;
&lt;x-form.radio
  name="role"
  value="editor"
  label="Editor"
  {{-- :checked="$userRole === 'editor'" --}}
  checked
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Switch Component - Basic Usage</h6>
        <pre><code>&lt;x-form.switch
  name="notifications"
  label="Email Notifications"
  checked
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Switch Component - Edit Mode (Pre-selected)</h6>
        <pre><code>{{-- @php
  $settings = ['two_factor' => true];
@endphp --}}

&lt;x-form.switch
  name="two_factor"
  label="Two-Factor Authentication"
  {{-- :checked="$settings['two_factor']" --}}
  checked
/&gt;</code></pre>

        <h6 class="mb-3 mt-4">Available Props for Checkbox Component:</h6>
        <ul>
          <li><code>name</code> (required) - Checkbox name attribute</li>
          <li><code>label</code> - Label text</li>
          <li><code>value</code> - Checkbox value (default: '1')</li>
          <li><code>checked</code> - Pre-checked state (for edit mode)</li>
          <li><code>disabled</code> - Make checkbox disabled</li>
          <li><code>inline</code> - Display inline (default: false)</li>
          <li><code>color</code> - Color theme: 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark'</li>
        </ul>

        <h6 class="mb-3 mt-4">Available Props for Radio Component:</h6>
        <ul>
          <li><code>name</code> (required) - Radio name attribute</li>
          <li><code>value</code> (required) - Radio value</li>
          <li><code>label</code> - Label text</li>
          <li><code>checked</code> - Pre-checked state (for edit mode)</li>
          <li><code>disabled</code> - Make radio disabled</li>
          <li><code>inline</code> - Display inline (default: false)</li>
          <li><code>color</code> - Color theme: 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark'</li>
        </ul>

        <h6 class="mb-3 mt-4">Available Props for Switch Component:</h6>
        <ul>
          <li><code>name</code> (required) - Switch name attribute</li>
          <li><code>label</code> - Label text</li>
          <li><code>value</code> - Switch value (default: '1')</li>
          <li><code>checked</code> - Pre-checked state (for edit mode)</li>
          <li><code>disabled</code> - Make switch disabled</li>
        </ul>
      </div>
    </div>
  </div>
</div>
@endsection
