@php
use Illuminate\Support\Facades\Crypt;
$configData = Helper::appClasses();
@endphp

<!-- Student Profile Modal Content -->
<div class="modal-header">
  <h5 class="modal-title" id="studentProfileModalLabel">Student Profile</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
  <!-- Nav tabs -->
  <ul class="nav nav-tabs mb-3" role="tablist">
    <li class="nav-item" role="presentation">
      <button 
        class="nav-link active" 
        id="profile-tab" 
        data-bs-toggle="tab" 
        data-bs-target="#profile-pane" 
        type="button" 
        role="tab" 
        aria-controls="profile-pane" 
        aria-selected="true">
        <i class="ri-user-line me-2"></i>Profile Information
      </button>
    </li>
    <li class="nav-item" role="presentation">
      <button 
        class="nav-link" 
        id="history-tab" 
        data-bs-toggle="tab" 
        data-bs-target="#history-pane" 
        type="button" 
        role="tab" 
        aria-controls="history-pane" 
        aria-selected="false">
        <i class="ri-history-line me-2"></i>Payment History
      </button>
    </li>
  </ul>

  <!-- Tab content -->
  <div class="tab-content">
    <!-- Profile Information Tab -->
    <div class="tab-pane fade show active" id="profile-pane" role="tabpanel" aria-labelledby="profile-tab">
      <div class="row">
        <!-- Student Image -->
        <div class="col-md-4 text-center">
          @if($student->image)
            <img src="{{ asset($student->image) }}" alt="{{ $student->name }}" class="rounded img-fluid" style="max-width: 180px;">
          @else
            <div class="avatar avatar-xl">
              <span class="avatar-initial rounded bg-label-primary">
                {{ strtoupper(substr($student->name, 0, 2)) }}
              </span>
            </div>
          @endif
        </div>

        <!-- Student Details -->
        <div class="col-md-8">
          <table class="table table-borderless table-sm">
            <tbody>
              <tr>
                <th width="140">Roll No:</th>
                <td><strong>{{ $student->roll_no ?? 'N/A' }}</strong></td>
              </tr>
              <tr>
                <th>Student Name:</th>
                <td><strong>{{ $student->name }}</strong></td>
              </tr>
              <tr>
                <th>Father's Name:</th>
                <td>{{ $student->fname ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Mobile 1:</th>
                <td>{{ $student->mob1 ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Mobile 2:</th>
                <td>{{ $student->mob2 ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Join Date:</th>
                <td>{{ $student->join_date ? date('d-m-Y', strtotime($student->join_date)) : 'N/A' }}</td>
              </tr>
              <tr>
                <th>Address:</th>
                <td>{{ $student->address ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Class:</th>
                <td>{{ $student->class->name ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Section:</th>
                <td>{{ $student->section->name ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Fee:</th>
                <td>{{ $student->fee ?? 'N/A' }}</td>
              </tr>
              <tr>
                <th>Fee Status:</th>
                <td>
                  @if($student->fstatus == 0)
                    <span class="badge rounded-pill bg-label-success">Regular</span>
                  @else
                    <span class="badge rounded-pill bg-label-danger">Free</span>
                  @endif
                </td>
              </tr>
              <tr>
                <th>School:</th>
                <td>{{ $student->school->name ?? 'N/A' }}</td>
              </tr>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <!-- Payment History Tab -->
    <div class="tab-pane fade" id="history-pane" role="tabpanel" aria-labelledby="history-tab">
      <div class="table-responsive">
        <table class="table table-sm table-hover">
          <thead class="table-light">
            <tr>
              <th>Payment Date</th>
              <th>Month</th>
              <th>Amount</th>
              <th>Method</th>
              <th>Status</th>
              <th>Notes</th>
            </tr>
          </thead>
          <tbody id="paymentHistoryBody">
            <!-- Payment history will be loaded here -->
            <tr>
              <td colspan="6" class="text-center">
                <div class="spinner-border spinner-border-sm text-primary" role="status">
                  <span class="visually-hidden">Loading...</span>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>

<script>
  // Load payment history when the history tab is clicked
  document.addEventListener('DOMContentLoaded', function() {
    const historyTab = document.getElementById('history-tab');
    const paymentHistoryBody = document.getElementById('paymentHistoryBody');
    
    if (historyTab && paymentHistoryBody) {
      // Load payment history on tab show
      historyTab.addEventListener('shown.bs.tab', function() {
        loadPaymentHistory(paymentHistoryBody);
      });
      
      // Also load on modal show if history tab is already visible
      const modal = document.closest('.modal-content');
      if (modal) {
        // Check if we need to load - but since history tab is not active by default, we'll wait for click
      }
    }
  });

  function loadPaymentHistory(container) {
    // Get student ID from the parent context
    const studentId = document.querySelector('[data-student-id]')?.getAttribute('data-student-id');
    
    if (!studentId) {
      // Sample data for now - replace with actual API call
      displaySamplePaymentHistory(container);
      return;
    }

    // This will be replaced with actual API call
    // fetch(`/api/student/${studentId}/payment-history`)
    //   .then(r => r.json())
    //   .then(data => displayPaymentHistory(data, container))
    //   .catch(err => {
    //     console.error('Error loading payment history:', err);
    //     container.innerHTML = '<tr><td colspan="6" class="text-center text-danger">Failed to load payment history</td></tr>';
    //   });

    // For now, show sample data
    displaySamplePaymentHistory(container);
  }

  function displaySamplePaymentHistory(container) {
    const sampleData = [
      { date: '05-01-2025', month: 'January 2025', amount: '5000', method: 'Cash', status: 'Paid', notes: 'January Payment' },
      { date: '01-12-2024', month: 'December 2024', amount: '5000', method: 'Check', status: 'Paid', notes: 'December Payment' },
      { date: '03-11-2024', month: 'November 2024', amount: '5000', method: 'Bank Transfer', status: 'Paid', notes: 'November Payment' },
      { date: '02-10-2024', month: 'October 2024', amount: '5000', method: 'Cash', status: 'Paid', notes: 'October Payment' },
    ];

    let html = '';
    sampleData.forEach(payment => {
      const statusBadge = payment.status === 'Paid' 
        ? '<span class="badge rounded-pill bg-label-success">Paid</span>'
        : '<span class="badge rounded-pill bg-label-warning">Pending</span>';
      
      html += `
        <tr>
          <td><small>${payment.date}</small></td>
          <td><small>${payment.month}</small></td>
          <td><strong>${payment.amount}</strong></td>
          <td><small>${payment.method}</small></td>
          <td>${statusBadge}</td>
          <td><small>${payment.notes}</small></td>
        </tr>
      `;
    });

    container.innerHTML = html;
  }
</script>
