@php
use Illuminate\Support\Facades\Crypt;
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Student Profile')

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card mb-4">
      <div class="card-header">
        <h4 class="card-title mb-0">Student Profile</h4>
      </div>
      <div class="card-body">
        <div class="row">
          <!-- Student Image -->
          <div class="col-md-3 text-center">
            @if($student->image)
              <img src="{{ asset($student->image) }}" alt="{{ $student->name }}" class="rounded img-fluid" style="max-width: 200px;">
            @else
              <div class="avatar avatar-xl">
                <span class="avatar-initial rounded bg-label-primary">
                  {{ strtoupper(substr($student->name, 0, 2)) }}
                </span>
              </div>
            @endif
          </div>

          <!-- Student Details -->
          <div class="col-md-9">
            <table class="table table-borderless">
              <tbody>
                <tr>
                  <th width="200">Roll No:</th>
                  <td>{{ $student->roll_no ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Student Name:</th>
                  <td><strong>{{ $student->name }}</strong></td>
                </tr>
                <tr>
                  <th>Father's Name:</th>
                  <td>{{ $student->fname ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Mobile 1:</th>
                  <td>{{ $student->mob1 ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Mobile 2:</th>
                  <td>{{ $student->mob2 ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Join Date:</th>
                  <td>{{ $student->join_date ? date('d-m-Y', strtotime($student->join_date)) : 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Address:</th>
                  <td>{{ $student->address ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Class:</th>
                  <td>{{ $student->class->name ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Section:</th>
                  <td>{{ $student->section->name ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Fee:</th>
                  <td>{{ $student->fee ?? 'N/A' }}</td>
                </tr>
                <tr>
                  <th>Fee Status:</th>
                  <td>
                    @if($student->fstatus == 0)
                      <span class="badge rounded-pill bg-label-success">Regular</span>
                    @else
                      <span class="badge rounded-pill bg-label-danger">Free</span>
                    @endif
                  </td>
                </tr>
                <tr>
                  <th>School:</th>
                  <td>{{ $student->school->name ?? 'N/A' }}</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
