@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Active Students')
<!-- Vendor Styles -->
@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss',
  'resources/assets/vendor/libs/flatpickr/flatpickr.scss',
  'resources/assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.scss',
  'resources/assets/vendor/libs/@form-validation/form-validation.scss'
  ])
@endsection

@section('page-style')
<!-- Page -->
@vite([
  // 'resources/assets/vendor/scss/pages/cards-statistics.scss',
  // 'resources/assets/vendor/scss/pages/cards-analytics.scss'
])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/select2/select2.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js',
  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/flatpickr/flatpickr.js',
  'resources/assets/vendor/libs/@form-validation/popular.js',
  'resources/assets/vendor/libs/@form-validation/bootstrap5.js',
  'resources/assets/vendor/libs/@form-validation/auto-focus.js'
  ])
@endsection

<!-- Page Scripts -->
@section('page-script')
@vite([
  'resources/assets/js/chain-select.js',
  'resources/assets/js/myapp/datatables-list-students.js'
  ])
<script type="module">
  'use strict';

  // Wait for all modules to load
  window.addEventListener('load', function() {
    console.log('[DEBUG] Window loaded');
    console.log('[DEBUG] jQuery available:', typeof $ !== 'undefined');
    console.log('[DEBUG] Select2 available:', typeof $.fn.select2 !== 'undefined');

    if (typeof $ === 'undefined' || typeof $.fn.select2 === 'undefined') {
      console.error('[ERROR] jQuery or Select2 is not loaded!');
      return;
    }

    var select2Elements = $('.select2');
    console.log('[DEBUG] Found', select2Elements.length, 'select2 elements');

    if (select2Elements.length) {
      select2Elements.each(function () {
        var $this = $(this);

        // Don't re-initialize
        if ($this.hasClass('select2-hidden-accessible')) {
          return;
        }

        console.log('[DEBUG] Initializing:', $this.attr('name'));

        // Use select2Focus helper if available
        if (typeof select2Focus !== 'undefined') {
          select2Focus($this);
        }

        // Check if AJAX search is enabled
        var isAjaxSearch = $this.data('ajax-search') === true;
        var dependsOn = $this.data('depends-on');
        var filterColumn = $this.data('filter-column');

        var select2Config = {
          placeholder: $this.data('placeholder') || 'Select value',
          dropdownParent: $this.parent()
        };

        // Configure AJAX if enabled
        if (isAjaxSearch) {
          var ajaxModel = $this.data('ajax-model');
          var ajaxDisplay = $this.data('ajax-display');
          var ajaxKey = $this.data('ajax-key');
          var ajaxLimit = $this.data('ajax-limit') || 20;

          console.log('[DEBUG] AJAX Search enabled for:', $this.attr('name'));

          select2Config.ajax = {
            url: '/api/ajax-search',
            dataType: 'json',
            delay: 250,
            transport: function(params, success, failure) {
              // Check if there's a search term
              var data = params.data;
              if (!data || !data.search || data.search.length < 1) {
                console.log('[DEBUG] No search term, returning empty results');
                // Return empty results immediately without making request
                success({
                  results: [],
                  pagination: { more: false }
                });
                return;
              }

              // Make the actual AJAX request
              var $request = $.ajax(params);

              $request.then(success);
              $request.fail(failure);

              return $request;
            },
            data: function (params) {
              console.log('[DEBUG] AJAX data function called with term:', params.term);

              var data = {
                search: params.term || '',
                page: params.page || 1,
                model: ajaxModel,
                display: ajaxDisplay,
                key: ajaxKey,
                limit: ajaxLimit
              };

              // If this select depends on another, include parent filter
              if (dependsOn && filterColumn) {
                var parentSelect = document.querySelector('select[name="' + dependsOn + '"], select[name="' + dependsOn + '[]"]');
                if (parentSelect) {
                  var parentValue = parentSelect.multiple
                    ? Array.from(parentSelect.selectedOptions).map(opt => opt.value).filter(v => v !== '')
                    : parentSelect.value;

                  if (parentValue && (Array.isArray(parentValue) ? parentValue.length > 0 : parentValue !== '')) {
                    data.filterColumn = filterColumn;
                    data.filterValue = parentValue;
                    console.log('[DEBUG] Parent filter applied:', filterColumn, '=', parentValue);
                  }
                }
              }

              return data;
            },
            processResults: function (data, params) {
              params.page = params.page || 1;

              // Return empty if no data (prevents showing anything when no search term)
              if (!data || !data.results) {
                return {
                  results: [],
                  pagination: { more: false }
                };
              }

              return {
                results: data.results,
                pagination: {
                  more: data.pagination.more
                }
              };
            },
            cache: false // Disable cache to ensure fresh searches
          };
          select2Config.minimumInputLength = 1; // Require at least 1 character to search
          select2Config.placeholder = $this.data('placeholder') || 'Type to search...';
          select2Config.allowClear = true; // Allow clearing selection
        }

        // Wrap and initialize select2
        $this.wrap('<div class="position-relative"></div>').select2(select2Config);

        console.log('[DEBUG] Successfully initialized:', $this.attr('name'));
      });
    }

    console.log('[DEBUG] Select2 initialization complete');
  });
</script>
@endsection

@section('content')
<div class="row g-4">

  <!-- Filters -->
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-md-4">
          <label for="filterClass" class="form-label">Select Class <span class="text-danger">*</span></label>
          <x-form.select
            name="filterClass"
            model="App\Models\App_Class"
            :query="[['where',['app_school_id',Auth::user()->app_school_id]]]"
            display="name"
            key="id"
            placeholder="Select Class"
            class="form-control select2"
            id="filterClass"
            data-placeholder="Select Class"
          />
        </div>
        <div class="col-md-4">
          <label for="filterSection" class="form-label">Select Section <span class="text-danger">*</span></label>
          <x-form.select
            name="filterSection"
            model="App\Models\App_section"
            display="name"
            key="id"
            class="form-control select2"
            id="filterSection"
            dependsOn="filterClass"
            filterColumn="app_class_id"
            data-placeholder="Select Section"
          />
        </div>
        <div class="col-md-2 d-flex align-items-end gap-2">
          <button id="filterBtn" class="btn btn-primary flex-grow-1">Filter Students</button>
        </div>
        <div class="col-md-2 d-flex align-items-end">
          <button id="clearFilterBtn" class="btn btn-secondary w-100">Clear Filters</button>
        </div>
      </div>
    </div>
  </div>

 <!-- DataTable with Buttons -->
<div class="card">
  <div class="card-datatable table-responsive pt-0">
    <table class="datatables-basic table table-bordered">
      <thead>
        <tr>
          <th></th>
          <th></th>
          <th>Roll No.</th>
          <th>Name</th>
          <th>Father Name</th>
          <th>Mobile No.</th>
          <th>Join Date</th>
          <th>Class/Section</th>
          <th>Status</th>
          <th>Profile</th>
          <th>Actions</th>
        </tr>
      </thead>
    </table>
  </div>
</div>

<!-- Toast Container for Notifications -->
<div class="toast-container position-fixed top-0 end-0 p-3">
  <div id="studentToast" class="toast fade" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
    <div class="toast-header">
      <i id="toastIcon" class="ri-checkbox-circle-fill me-2"></i>
      <div id="toastTitle" class="me-auto fw-medium">Success</div>
      <small class="text-muted">just now</small>
      <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
    </div>
    <div class="toast-body">
      <span id="toastMessage">Student saved successfully!</span>
    </div>
  </div>
</div>

<!-- Modal for Add/Edit Student -->
<div class="modal fade" id="studentModal" tabindex="-1" aria-labelledby="studentModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div id="studentModalContent">
        <!-- Content will be loaded via AJAX -->
      </div>
    </div>
  </div>
</div>
<!--/ DataTable with Buttons -->

</div>
@endsection
