<div class="modal-header">
  <h5 class="modal-title" id="studentModalLabel">Add New Student</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
  <form action="{{ route('admin.students.store') }}" method="POST" enctype="multipart/form-data" id="form-add-new-record">
    @csrf

    <div class="row">
      <div class="col-md-6 mb-3">
        <x-form.input
          name="roll_no"
          label="Roll No"
          placeholder="Enter Roll No"
          value="{{ old('roll_no', $nextRollNo ?? '') }}"
          required
          disabled
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="name"
          label="Student Name"
          placeholder="Enter name"
          value="{{ old('name') }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="fname"
          label="Father's Name"
          placeholder="Enter father's name"
          value="{{ old('fname') }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="mob1"
          label="Mobile 1"
          placeholder="Enter mobile number"
          value="{{ old('mob1') }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="mob2"
          label="Mobile 2"
          placeholder="Enter mobile number (optional)"
          value="{{ old('mob2') }}"
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="join_date"
          label="Join Date"
          type="date"
          placeholder="Select join date"
          value="{{ old('join_date', date('Y-m-d')) }}"
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.textarea
          name="address"
          label="Address"
          placeholder="Enter address"
          value="{{ old('address') }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <label for="app_class_id" class="form-label">Select Class <span class="text-danger">*</span></label>
        <x-form.select
          name="app_class_id"
          model="App\Models\App_Class"
          :query="[['where',['app_school_id',Auth::user()->app_school_id]]]"
          display="name"
          key="id"
          placeholder="Select Class"
          class="form-control select2"
          id="app_class_id"
          data-placeholder="Select Class"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <label for="app_section_id" class="form-label">Select Section <span class="text-danger">*</span></label>
        <x-form.select
          name="app_section_id"
          model="App\Models\App_section"
          display="name"
          key="id"
          class="form-control select2"
          id="app_section_id"
          dependsOn="app_class_id"
          filterColumn="app_class_id"
          data-placeholder="Select section"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="fee"
          label="Fee"
          type="number"
          placeholder="Enter fee amount"
          value="{{ old('fee') }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <label for="fstatus" class="form-label">Fee Status <span class="text-danger">*</span></label>
        <select
          name="fstatus"
          id="fstatus"
          class="form-control"
          required
        >
          <option value="" disabled>Select Fee Status</option>
          <option value="0" {{ old('fstatus') === '0' || old('fstatus') === null ? 'selected' : '' }}>Regular</option>
          <option value="1" {{ old('fstatus') === '1' ? 'selected' : '' }}>Free</option>
        </select>
      </div>

      <div class="col-md-6 mb-3">
        <label for="image" class="form-label">Student Image</label>
        <input type="file" class="form-control" id="image" name="image" accept="image/*">
        <small class="form-text text-muted">Upload image or capture from webcam below</small>

        <div class="mt-2">
          <button type="button" id="openCamera" class="btn btn-secondary btn-sm" onclick="window.openCameraEdit(event)">Open Camera</button>
          <button type="button" id="captureBtn" class="btn btn-primary btn-sm d-none" onclick="window.captureCameraEdit(event)">Capture</button>
          <button type="button" id="closeCamera" class="btn btn-danger btn-sm d-none" onclick="window.closeCameraEdit(event)">Close Camera</button>
        </div>

        <div class="mt-2" id="cameraContainer" style="display:none;">
          <video id="video" width="280" height="210" autoplay></video>
          <canvas id="canvas" width="280" height="210" style="display:none;"></canvas>
        </div>

        <div class="mt-2">
          <img id="previewImage" src="" style="max-width:150px; display:none;" alt="Preview" class="rounded">
          <input type="hidden" name="image_data" id="image_data" value="">
        </div>
      </div>
    </div>

    <script>
      // Simple flag to ensure the camera functions from datatables-list-students.js are available
      console.log('Student form loaded, camera functions available:', {
        openCameraEdit: typeof window.openCameraEdit === 'function',
        captureCameraEdit: typeof window.captureCameraEdit === 'function',
        closeCameraEdit: typeof window.closeCameraEdit === 'function'
      });

      // Function to stop/close camera stream - EXPOSE TO WINDOW
      window.stopCameraStream = function() {
        console.log('Stopping camera stream');
        if (window.cameraStreamState && window.cameraStreamState.stream) {
          try {
            window.cameraStreamState.stream.getTracks().forEach(track => track.stop());
            window.cameraStreamState.stream = null;
            console.log('Camera stream stopped successfully');
          } catch(err) {
            console.error('Error stopping camera stream:', err);
          }
        } else {
          console.log('No camera stream to stop');
        }
      };

      // Setup camera cleanup handlers - immediate execution for dynamic forms
      (function setupCameraCleanup() {
        console.log('Setting up camera cleanup handlers');

        // Close camera when form is submitted
        const form = document.getElementById('form-add-new-record');
        if (form) {
          form.addEventListener('submit', function() {
            console.log('Form submitted, closing camera');
            window.stopCameraStream();
          });
        }

        // Close camera when modal is closed/hidden using Bootstrap modal event
        const studentModalElement = document.getElementById('studentModal');
        if (studentModalElement) {
          studentModalElement.addEventListener('hidden.bs.modal', function() {
            console.log('Modal hidden via Bootstrap event, closing camera');
            window.stopCameraStream();
            // Also hide camera UI elements
            const cameraContainer = document.getElementById('cameraContainer');
            const openBtn = document.getElementById('openCamera');
            const captureBtn = document.getElementById('captureBtn');
            const closeBtn = document.getElementById('closeCamera');
            if (cameraContainer) cameraContainer.style.display = 'none';
            if (openBtn) openBtn.classList.remove('d-none');
            if (captureBtn) captureBtn.classList.add('d-none');
            if (closeBtn) closeBtn.classList.add('d-none');
          });
        }
      })();
    </script>
  </form>
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal" onclick="stopCameraStream()">Cancel</button>
  <button type="submit" form="form-add-new-record" class="btn btn-primary">Create Student</button>
</div>
