@php use Illuminate\Support\Facades\Crypt; @endphp
<div class="modal-header">
  <h5 class="modal-title" id="studentModalLabel">Edit Student</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
  <form action="{{ route('admin.student.update', Crypt::encryptString($student->id)) }}" method="POST" enctype="multipart/form-data" id="form-edit-record">
    @csrf
    @method('PUT')

    <div class="row">
      <div class="col-md-6 mb-3">
        <x-form.input
          name="roll_no"
          label="Roll No"
          placeholder="Enter Roll No"
          value="{{ $student->roll_no }}"
          disabled
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="name"
          label="Student Name"
          placeholder="Enter name"
          value="{{ $student->name }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="fname"
          label="Father's Name"
          placeholder="Enter father's name"
          value="{{ $student->fname }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="mob1"
          label="Mobile 1"
          placeholder="Enter mobile number"
          value="{{ $student->mob1 }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="mob2"
          label="Mobile 2"
          placeholder="Enter mobile number (optional)"
          value="{{ $student->mob2 }}"
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="join_date"
          label="Join Date"
          type="date"
          placeholder="Select join date"
          value="{{ $student->join_date ? date('Y-m-d', strtotime($student->join_date)) : '' }}"
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.textarea
          name="address"
          label="Address"
          placeholder="Enter address"
          value="{{ $student->address }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <label for="app_class_id" class="form-label">Select Class <span class="text-danger">*</span></label>
        <x-form.select
          name="app_class_id"
          model="App\Models\App_Class"
          :query="[['where',['app_school_id',Auth::user()->app_school_id]]]"
          display="name"
          key="id"
          placeholder="Select Class"
          class="form-control select2"
          id="app_class_id"
          data-placeholder="Select Class"
          value="{{ $student->app_class_id }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <label for="app_section_id" class="form-label">Select Section <span class="text-danger">*</span></label>
        <x-form.select
          name="app_section_id"
          model="App\Models\App_section"
          display="name"
          key="id"
          class="form-control select2"
          id="app_section_id"
          dependsOn="app_class_id"
          filterColumn="app_class_id"
          data-placeholder="Select section"
          value="{{ $student->app_section_id }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <x-form.input
          name="fee"
          label="Fee"
          type="number"
          placeholder="Enter fee amount"
          value="{{ old('fee', $student->fee) }}"
          required
        />
      </div>

      <div class="col-md-6 mb-3">
        <label for="fstatus" class="form-label">Fee Status <span class="text-danger">*</span></label>
        <select
          name="fstatus"
          id="fstatus"
          class="form-control"
          required
        >
          <option value="" disabled>Select Fee Status</option>
          <option value="0" {{ old('fstatus', $student->fstatus) == 0 ? 'selected' : '' }}>Regular</option>
          <option value="1" {{ old('fstatus', $student->fstatus) == 1 ? 'selected' : '' }}>Free</option>
        </select>
      </div>

      <div class="col-md-6 mb-3">
        <label for="image" class="form-label">Student Image</label>

        @if($student->image)
        <div class="mb-2">
          <img src="{{ asset($student->image) }}" alt="Current Image" class="rounded" style="max-width:100px;">
          <small class="d-block text-muted">Current Image</small>
        </div>
        @endif

        <input type="file" class="form-control" id="image" name="image" accept="image/*">
        <small class="form-text text-muted">Upload new image or capture from webcam below</small>

        <div class="mt-2">
          <button type="button" id="openCamera" class="btn btn-secondary btn-sm" onclick="window.openCameraEdit(event)">Open Camera</button>
          <button type="button" id="captureBtn" class="btn btn-primary btn-sm d-none" onclick="window.captureCameraEdit(event)">Capture</button>
          <button type="button" id="closeCamera" class="btn btn-danger btn-sm d-none" onclick="window.closeCameraEdit(event)">Close Camera</button>
        </div>

        <div class="mt-2" id="cameraContainer" style="display:none;">
          <video id="video" width="280" height="210" autoplay></video>
          <canvas id="canvas" width="280" height="210" style="display:none;"></canvas>
        </div>

        <div class="mt-2">
          <img id="previewImage" src="" style="max-width:150px; display:none;" alt="Preview" class="rounded">
          <input type="hidden" name="image_data" id="image_data" value="">
        </div>
      </div>
    </div>

    <script>
      // Dummy initializeCamera for compatibility - actual functions are in main datatables-list-students.js
      window.initializeCamera = function() {
        console.log('initializeCamera called (edit form) - using onclick handlers from main JS');
      };

      // File input change handler
      var fileInput = document.getElementById('image');
      if (fileInput) {
        fileInput.addEventListener('change', function() {
          console.log('File input changed in edit form');
          if (this.files && this.files[0]) {
            var imageDataInput = document.getElementById('image_data');
            if (imageDataInput) {
              imageDataInput.value = '';
            }
            var previewImage = document.getElementById('previewImage');
            if (previewImage) {
              previewImage.style.display = 'none';
            }
          }
        });
      }
    </script>
  </form>
</div>
<div class="modal-footer">
  <button type="button" class="btn btn-label-secondary" data-bs-dismiss="modal">Cancel</button>
  <button type="submit" form="form-edit-record" class="btn btn-primary">Update Student</button>
</div>
