@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Add Student')
<!-- Vendor Styles -->
@section('vendor-style')
@vite(['resources/assets/vendor/libs/select2/select2.scss'])
@endsection

@section('page-style')
<!-- Page -->
@vite([
  // 'resources/assets/vendor/scss/pages/cards-statistics.scss',
  // 'resources/assets/vendor/scss/pages/cards-analytics.scss'
])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite(['resources/assets/vendor/libs/select2/select2.js'])
@endsection

<!-- Page Scripts -->
@section('page-script')
@vite(['resources/assets/js/chain-select.js'])
<script type="module">
  'use strict';

  // Wait for all modules to load
  window.addEventListener('load', function() {
    console.log('[DEBUG] Window loaded');
    console.log('[DEBUG] jQuery available:', typeof $ !== 'undefined');
    console.log('[DEBUG] Select2 available:', typeof $.fn.select2 !== 'undefined');

    if (typeof $ === 'undefined' || typeof $.fn.select2 === 'undefined') {
      console.error('[ERROR] jQuery or Select2 is not loaded!');
      return;
    }

    var select2Elements = $('.select2');
    console.log('[DEBUG] Found', select2Elements.length, 'select2 elements');

    if (select2Elements.length) {
      select2Elements.each(function () {
        var $this = $(this);

        // Don't re-initialize
        if ($this.hasClass('select2-hidden-accessible')) {
          return;
        }

        console.log('[DEBUG] Initializing:', $this.attr('name'));

        // Use select2Focus helper if available
        if (typeof select2Focus !== 'undefined') {
          select2Focus($this);
        }

        // Check if AJAX search is enabled
        var isAjaxSearch = $this.data('ajax-search') === true;
        var dependsOn = $this.data('depends-on');
        var filterColumn = $this.data('filter-column');

        var select2Config = {
          placeholder: $this.data('placeholder') || 'Select value',
          dropdownParent: $this.parent()
        };

        // Configure AJAX if enabled
        if (isAjaxSearch) {
          var ajaxModel = $this.data('ajax-model');
          var ajaxDisplay = $this.data('ajax-display');
          var ajaxKey = $this.data('ajax-key');
          var ajaxLimit = $this.data('ajax-limit') || 20;

          console.log('[DEBUG] AJAX Search enabled for:', $this.attr('name'));

          select2Config.ajax = {
            url: '/api/ajax-search',
            dataType: 'json',
            delay: 250,
            transport: function(params, success, failure) {
              // Check if there's a search term
              var data = params.data;
              if (!data || !data.search || data.search.length < 1) {
                console.log('[DEBUG] No search term, returning empty results');
                // Return empty results immediately without making request
                success({
                  results: [],
                  pagination: { more: false }
                });
                return;
              }

              // Make the actual AJAX request
              var $request = $.ajax(params);

              $request.then(success);
              $request.fail(failure);

              return $request;
            },
            data: function (params) {
              console.log('[DEBUG] AJAX data function called with term:', params.term);

              var data = {
                search: params.term || '',
                page: params.page || 1,
                model: ajaxModel,
                display: ajaxDisplay,
                key: ajaxKey,
                limit: ajaxLimit
              };

              // If this select depends on another, include parent filter
              if (dependsOn && filterColumn) {
                var parentSelect = document.querySelector('select[name="' + dependsOn + '"], select[name="' + dependsOn + '[]"]');
                if (parentSelect) {
                  var parentValue = parentSelect.multiple
                    ? Array.from(parentSelect.selectedOptions).map(opt => opt.value).filter(v => v !== '')
                    : parentSelect.value;

                  if (parentValue && (Array.isArray(parentValue) ? parentValue.length > 0 : parentValue !== '')) {
                    data.filterColumn = filterColumn;
                    data.filterValue = parentValue;
                    console.log('[DEBUG] Parent filter applied:', filterColumn, '=', parentValue);
                  }
                }
              }

              return data;
            },
            processResults: function (data, params) {
              params.page = params.page || 1;

              // Return empty if no data (prevents showing anything when no search term)
              if (!data || !data.results) {
                return {
                  results: [],
                  pagination: { more: false }
                };
              }

              return {
                results: data.results,
                pagination: {
                  more: data.pagination.more
                }
              };
            },
            cache: false // Disable cache to ensure fresh searches
          };
          select2Config.minimumInputLength = 1; // Require at least 1 character to search
          select2Config.placeholder = $this.data('placeholder') || 'Type to search...';
          select2Config.allowClear = true; // Allow clearing selection
        }

        // Wrap and initialize select2
        $this.wrap('<div class="position-relative"></div>').select2(select2Config);

        console.log('[DEBUG] Successfully initialized:', $this.attr('name'));
      });
    }

    console.log('[DEBUG] Select2 initialization complete');
  });
</script>
@endsection

@section('content')
<div class="row g-4">








                    <div class="row">
                        <div class="col-12">
                            <div class="card mb-4">

                                  <div class="card-header">
                                          <h4 class="card-title mb-0">Add Student</h4>
                                          {{-- <p class="text-muted mt-2 mb-0">Select dropdowns automatically populate based on parent selection. Works for unlimited levels.</p> --}}
                                  </div>

                                   @if(session('success'))
                      <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    @if ($errors->any())
                      <div class="alert alert-danger">
                        <ul>
                          @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                          @endforeach
                        </ul>
                      </div>
                    @endif

                                      <div class="card-body">

                                        <form action="{{ route('admin.students.store') }}" method="POST" enctype="multipart/form-data">
                                        @csrf


                                        <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="roll_no"
                                          label="Roll No"
                                          placeholder="Enter Roll No"
                                          value="{{ old('roll_no', $nextRollNo ?? '') }}"
                                          {{-- helpText="Choose a unique fname" --}}
                                          required
                                          disabled
                                          />
                                        </div>


                                        <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="name"
                                          label="Student Name"
                                          placeholder="Enter name"
                                          value="{{ old('name') }}"
                                          {{-- helpText="Choose a unique name" --}}
                                          required
                                          />
                                        </div>

                                        <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="fname"
                                          label="Father's Name"
                                          placeholder="Enter name"
                                          value="{{ old('fname') }}"
                                          {{-- helpText="Choose a unique fname" --}}
                                          required
                                          />
                                        </div>

                                          <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="mob1"
                                          label="Mobile 1"
                                          placeholder="Enter Number"
                                          value="{{ old('mob1') }}"
                                          {{-- helpText="Choose a unique fname" --}}
                                          required
                                          />
                                        </div>


                                             <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="mob2"
                                          label="Mobile 2"
                                          placeholder="Enter Number"
                                          value="{{ old('mob2') }}"
                                          {{-- helpText="Choose a unique fname" --}}
                                          {{-- required --}}
                                          />
                                        </div>

                                        <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="join_date"
                                          label="Join Date"
                                          type="date"
                                          placeholder="Select join date"
                                          value="{{ old('join_date', date('Y-m-d')) }}"
                                          />
                                        </div>


                                         <div class="col-md-6 mb-6">
                                          <x-form.textarea
                                          name="address"
                                          label="Address"
                                          placeholder="Enter Address"
                                          value="{{ old('address') }}"
                                          {{-- helpText="Choose a unique fname" --}}
                                          required
                                          />
                                        </div>



                                          {{-- <div class="mb-3">
                                            <label for="app_staff_id" class="form-label">Staff ID</label>
                                            <input type="number" class="form-control" id="app_staff_id" name="app_staff_id" value="{{ old('app_staff_id') }}">
                                          </div> --}}

                                          <div class="col-md-6 mb-6">
                                                      <label for="app_class_id" class="form-label">Select Class</label>
                                                      <x-form.select
                                                          name="app_class_id"
                                                          model="App\Models\App_Class"
                                                          {{-- :query="[['orderBy',['name','asc']]]" --}}
                                                          :query="[['where',['app_school_id',Auth::user()->app_school_id]]]"
                                                          display="name"
                                                          key="id"
                                                          placeholder="Select Class"
                                                          class="form-control select2 "
                                                          id="app_class_id"
                                                          data-placeholder="Select Class"
                                                          required
                                                      />
                                                  </div>


                                                    <div class="col-md-6 mb-6">
                                                      <label for="app_section_id" class="form-label">Seletct Section</label>
                                                      <x-form.select
                                                          name="app_section_id"
                                                          model="App\Models\App_section"
                                                          display="name"
                                                          key="id"
                                                          {{-- placeholder="Select section" --}}
                                                          class="form-control select2 "
                                                          id="app_section_id"
                                                          dependsOn="app_class_id"
                                                          filterColumn="app_class_id"
                                                          data-placeholder="Select section"
                                                          required
                                                      />
                                                  </div>


                                          <div class="col-md-6 mb-6">
                                          <x-form.input
                                          name="fee"
                                          label="Fee"
                                          placeholder="Enter Fee"
                                          value="{{ old('fee') }}"
                                          {{-- helpText="Choose a unique fname" --}}
                                          required
                                          />
                                        </div>

                                        <div class="col-md-6 mb-6">
                                          <label for="fstatus" class="form-label">Fee Status <span class="text-danger">*</span></label>
                                          <select
                                            name="fstatus"
                                            id="fstatus"
                                            class="form-control"
                                            required
                                          >
                                            <option value="" disabled>Select Fee Status</option>
                                            <option value="0" {{ old('fstatus') === '0' || old('fstatus') === null ? 'selected' : '' }}>Regular</option>
                                            <option value="1" {{ old('fstatus') === '1' ? 'selected' : '' }}>Free</option>
                                          </select>
                                        </div>

                      <div class="col-md-6 mb-6">
                        <label for="image" class="form-label">Image (upload or webcam)</label>
                        <input type="file" class="form-control" id="image" name="image" accept="image/*">
                        <small class="form-text text-muted">Or capture from webcam</small>

                        <div class="mt-2">
                          <button type="button" id="openCamera" class="btn btn-secondary btn-sm">Open Camera</button>
                          <button type="button" id="captureBtn" class="btn btn-primary btn-sm d-none">Capture</button>
                          <button type="button" id="closeCamera" class="btn btn-danger btn-sm d-none">Close Camera</button>
                        </div>

                        <div class="mt-2" id="cameraContainer" style="display:none;">
                          <video id="video" width="320" height="240" autoplay></video>
                          <canvas id="canvas" width="320" height="240" style="display:none;"></canvas>
                        </div>

                        <div class="mt-2">
                          <img id="previewImage" src="" style="max-width:200px; display:none;" alt="Preview">
                          <input type="hidden" name="image_data" id="image_data" value="">
                        </div>
                      </div>

                      <script>
                        (function(){
                          const openCameraBtn = document.getElementById('openCamera');
                          const closeCameraBtn = document.getElementById('closeCamera');
                          const captureBtn = document.getElementById('captureBtn');
                          const video = document.getElementById('video');
                          const canvas = document.getElementById('canvas');
                          const previewImage = document.getElementById('previewImage');
                          const imageDataInput = document.getElementById('image_data');
                          const fileInput = document.getElementById('image');
                          const cameraContainer = document.getElementById('cameraContainer');

                          let stream;

                          openCameraBtn.addEventListener('click', async () => {
                            try {
                              stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: false });
                              video.srcObject = stream;
                              cameraContainer.style.display = 'block';
                              captureBtn.classList.remove('d-none');
                              closeCameraBtn.classList.remove('d-none');
                              openCameraBtn.classList.add('d-none');
                            } catch (e) {
                              alert('Could not access camera: ' + e.message);
                            }
                          });

                          captureBtn.addEventListener('click', () => {
                            const context = canvas.getContext('2d');
                            canvas.width = video.videoWidth || 320;
                            canvas.height = video.videoHeight || 240;
                            context.drawImage(video, 0, 0, canvas.width, canvas.height);
                            const dataUrl = canvas.toDataURL('image/jpeg', 0.9);
                            previewImage.src = dataUrl;
                            previewImage.style.display = 'block';
                            imageDataInput.value = dataUrl;
                            // clear file input
                            fileInput.value = '';
                          });

                          closeCameraBtn.addEventListener('click', () => {
                            if (stream) {
                              stream.getTracks().forEach(track => track.stop());
                            }
                            cameraContainer.style.display = 'none';
                            captureBtn.classList.add('d-none');
                            closeCameraBtn.classList.add('d-none');
                            openCameraBtn.classList.remove('d-none');
                          });

                          fileInput.addEventListener('change', () => {
                            if (fileInput.files && fileInput.files[0]) {
                              // clear camera image data
                              imageDataInput.value = '';
                              previewImage.style.display = 'none';
                            }
                          });
                        })();
                      </script>

                      <button type="submit" class="btn btn-primary">Create Student</button>
                    </form>

                                      </div>
                                  </div>
                              </div>
                          </div>






                  </div>
                  @endsection
