@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Staff Management')

<!-- Vendor Styles -->
@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss'
  ])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/select2/select2.js',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.js'
  ])
@endsection

@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
  <!-- Header -->
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="fw-bold mb-0">
      <span class="text-muted fw-light">Admin /</span> Staff Management
    </h4>
    <button type="button" class="btn btn-primary" id="btnAddStaff">
      <i class="ri-add-line me-1"></i> Add Staff
    </button>
  </div>

  <!-- Filters -->
  <div class="card mb-4">
    <div class="card-body">
      <form method="GET" action="{{ route('admin.staff.list') }}">
        <div class="row g-3">
          <div class="col-md-3">
            <label class="form-label">Search</label>
            <input type="text" name="search" class="form-control" placeholder="Name, email, mobile..." value="{{ request('search') }}">
          </div>
          <div class="col-md-3">
            <label class="form-label">Staff Type</label>
            <select name="type_filter" class="form-select">
              <option value="">All Types</option>
              @foreach($stypes as $type)
              <option value="{{ $type->id }}" {{ request('type_filter') == $type->id ? 'selected' : '' }}>{{ $type->name }}</option>
              @endforeach
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Status</label>
            <select name="status_filter" class="form-select">
              <option value="">All Status</option>
              <option value="0" {{ request('status_filter') === '0' ? 'selected' : '' }}>Active</option>
              <option value="1" {{ request('status_filter') === '1' ? 'selected' : '' }}>Disabled</option>
            </select>
          </div>
          <div class="col-md-3 d-flex align-items-end gap-2">
            <button type="submit" class="btn btn-primary">
              <i class="ri-search-line me-1"></i> Filter
            </button>
            <a href="{{ route('admin.staff.list') }}" class="btn btn-secondary">
              <i class="ri-refresh-line me-1"></i> Reset
            </a>
          </div>
        </div>
      </form>
    </div>
  </div>

  <!-- Staff Table -->
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <h5 class="mb-0">Staff Members</h5>
      <span class="badge bg-secondary">{{ $staff->total() }} Total</span>
    </div>
    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>Name</th>
            <th>Email</th>
            <th>Mobile</th>
            <th>Type</th>
            <th>Status</th>
            <th>Joined</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @forelse($staff as $s)
          <tr>
            <td><strong>{{ $s->name }}</strong></td>
            <td>{{ $s->email }}</td>
            <td>{{ $s->mob }}</td>
            <td>{{ $s->stype->name ?? 'N/A' }}</td>
            <td>
              @if($s->status == 0)
              <span class="badge bg-success">Active</span>
              @else
              <span class="badge bg-danger">Disabled</span>
              @endif
            </td>
            <td>{{ $s->joined_at ? date('d M Y', strtotime($s->joined_at)) : 'N/A' }}</td>
            <td>
              <button type="button" 
                class="btn btn-sm btn-icon btn-text-secondary rounded-pill waves-effect btn-edit-staff" 
                data-id="{{ $s->encrypted_id }}"
                title="Edit">
                <i class="ri-edit-box-line ri-20px"></i>
              </button>
            </td>
          </tr>
          @empty
          <tr>
            <td colspan="7" class="text-center py-5">
              <div class="text-muted">
                <i class="ri-user-line ri-2x mb-2"></i>
                <p class="mb-0">No staff members found</p>
              </div>
            </td>
          </tr>
          @endforelse
        </tbody>
      </table>
    </div>
    @if($staff->hasPages())
    <div class="card-footer">
      <div class="d-flex justify-content-between align-items-center">
        <div class="text-muted">
          Showing {{ $staff->firstItem() }} to {{ $staff->lastItem() }} of {{ $staff->total() }} entries
        </div>
        <div>
          {{ $staff->appends(request()->query())->links() }}
        </div>
      </div>
    </div>
    @endif
  </div>
</div>

<!-- Staff Modal -->
<div class="modal fade" id="staffModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content" id="staffModalContent">
      <!-- Content will be loaded here -->
    </div>
  </div>
</div>

<script>
(function() {
  console.log('Staff JavaScript initializing...');
  
  // Wait for DOM
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
  
  function init() {
    console.log('Initializing staff management...');
    
    // Add Staff Button
    const btnAdd = document.getElementById('btnAddStaff');
    if (btnAdd) {
      btnAdd.addEventListener('click', function() {
        console.log('Add button clicked');
        loadStaffForm('/admin/staff/create');
      });
      console.log('Add button listener attached');
    } else {
      console.error('Add button not found!');
    }
    
    // Edit Staff Buttons
    document.querySelectorAll('.btn-edit-staff').forEach(function(btn) {
      btn.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        console.log('Edit button clicked, ID:', id);
        loadStaffForm('/admin/staff/edit/' + id);
      });
    });
    console.log('Edit buttons found:', document.querySelectorAll('.btn-edit-staff').length);
  }
  
  function loadStaffForm(url) {
    console.log('Loading form from:', url);
    
    const modalElement = document.getElementById('staffModal');
    const modalContent = document.getElementById('staffModalContent');
    
    if (!modalElement || !modalContent) {
      console.error('Modal elements not found!');
      alert('Error: Modal not found');
      return;
    }
    
    fetch(url, {
      headers: {
        'X-Requested-With': 'XMLHttpRequest',
        'Accept': 'text/html'
      }
    })
    .then(function(response) {
      console.log('Response received:', response.status);
      if (!response.ok) {
        throw new Error('HTTP ' + response.status);
      }
      return response.text();
    })
    .then(function(html) {
      console.log('Form loaded, length:', html.length);
      modalContent.innerHTML = html;
      
      // Show modal using Bootstrap
      if (typeof bootstrap !== 'undefined') {
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
        console.log('Modal shown');
      } else {
        console.error('Bootstrap not loaded!');
        alert('Error: Bootstrap not loaded');
      }
    })
    .catch(function(error) {
      console.error('Error:', error);
      alert('Failed to load form: ' + error.message);
    });
  }
  
  // Global reload function
  window.reloadStaffTable = function() {
    window.location.reload();
  };
})();
</script>
@endsection
