<div class="modal-header">
  <h5 class="modal-title">{{ isset($staff) ? 'Edit Staff Member' : 'Add New Staff Member' }}</h5>
  <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
  <form id="form-staff" method="POST" action="{{ isset($staff) ? route('admin.staff.update', $staff->encrypted_id) : route('admin.staff.store') }}">
    @csrf
    @if(isset($staff))
      @method('PUT')
    @endif

    <div class="row mb-3">
      <div class="col-md-6">
        <label for="name" class="form-label">Full Name <span class="text-danger">*</span></label>
        <input 
          type="text" 
          class="form-control" 
          id="name" 
          name="name" 
          value="{{ isset($staff) ? $staff->name : old('name') }}"
          required>
      </div>
      <div class="col-md-6">
        <label for="mob" class="form-label">Mobile Number <span class="text-danger">*</span></label>
        <input 
          type="text" 
          class="form-control" 
          id="mob" 
          name="mob" 
          value="{{ isset($staff) ? $staff->mob : old('mob') }}"
          required>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
        <input 
          type="email" 
          class="form-control" 
          id="email" 
          name="email" 
          value="{{ isset($staff) ? $staff->email : old('email') }}"
          required>
      </div>
      <div class="col-md-6">
        <label for="password" class="form-label">Password <span class="text-danger">{{ isset($staff) ? '' : '*' }}</span></label>
        <input 
          type="password" 
          class="form-control" 
          id="password" 
          name="password" 
          placeholder="{{ isset($staff) ? 'Leave blank to keep current password' : 'Enter password' }}"
          {{ isset($staff) ? '' : 'required' }}>
        @if(isset($staff))
        <small class="text-muted">Leave blank to keep current password</small>
        @endif
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label for="app_stype_id" class="form-label">Staff Type <span class="text-danger">*</span></label>
        <select class="form-select" id="app_stype_id" name="app_stype_id" required>
          <option value="">Select Staff Type</option>
          @foreach($stypes as $type)
          <option value="{{ $type->id }}" {{ isset($staff) && $staff->app_stype_id == $type->id ? 'selected' : '' }}>
            {{ $type->name }}
          </option>
          @endforeach
        </select>
      </div>
      <div class="col-md-6">
        <label for="status" class="form-label">Account Status <span class="text-danger">*</span></label>
        <select class="form-select" id="status" name="status" required>
          <option value="0" {{ isset($staff) && $staff->status == 0 ? 'selected' : (!isset($staff) ? 'selected' : '') }}>Active</option>
          <option value="1" {{ isset($staff) && $staff->status == 1 ? 'selected' : '' }}>Disabled</option>
        </select>
        <small class="text-muted">Disabled accounts cannot login</small>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-12">
        <label for="address" class="form-label">Address</label>
        <textarea 
          class="form-control" 
          id="address" 
          name="address" 
          rows="3"
          placeholder="Enter address">{{ isset($staff) ? $staff->address : old('address') }}</textarea>
      </div>
    </div>

    <div class="modal-footer">
      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
      <button type="submit" class="btn btn-primary">{{ isset($staff) ? 'Update Staff' : 'Add Staff' }}</button>
    </div>
  </form>
</div>

<script>
(function() {
  console.log('Form script initializing');
  
  function initForm() {
    const form = document.getElementById('form-staff');
    
    if (!form) {
      console.error('Form not found, retrying...');
      setTimeout(initForm, 100);
      return;
    }

    console.log('Form found, attaching submit handler');
    
    form.addEventListener('submit', function(e) {
      e.preventDefault();
      console.log('Form submitted');

      const submitBtn = form.querySelector('button[type="submit"]');
      const originalText = submitBtn.textContent;
      submitBtn.disabled = true;
      submitBtn.textContent = 'Saving...';

      // Prepare FormData and determine method
      const formData = new FormData(form);
      
      // Check if this is a PUT/PATCH request (Laravel _method field)
      const methodField = form.querySelector('input[name="_method"]');
      const method = methodField ? methodField.value.toUpperCase() : 'POST';
      
      // For non-GET requests via fetch, we need to send _method with POST
      if (method === 'PUT' || method === 'PATCH') {
        formData.set('_method', method);
      }
      
      fetch(form.action, {
        method: 'POST',
        headers: {
          'X-Requested-With': 'XMLHttpRequest',
          'Accept': 'application/json'
        },
        body: formData
      })
      .then(response => {
        console.log('Response status:', response.status);
        return response.json().then(data => ({
          status: response.status,
          data: data
        }));
      })
      .then(({status, data}) => {
        console.log('Response data:', data);
        
        if (status === 200 || status === 201) {
          // Success
          if (window.Swal) {
            Swal.fire({
              icon: 'success',
              title: 'Success!',
              text: data.message || 'Saved successfully',
              confirmButtonText: 'OK',
              customClass: {
                confirmButton: 'btn btn-primary'
              }
            }).then(() => {
              // Close modal
              const modal = document.getElementById('staffModal');
              const bsModal = bootstrap.Modal.getInstance(modal);
              if (bsModal) bsModal.hide();
              
              // Reload page
              setTimeout(() => window.location.reload(), 500);
            });
          } else {
            alert(data.message || 'Saved successfully');
            setTimeout(() => window.location.reload(), 1000);
          }
        } else {
          throw new Error(data.message || 'Unknown error');
        }
      })
      .catch(error => {
        console.error('Error:', error);
        submitBtn.disabled = false;
        submitBtn.textContent = originalText;
        
        if (window.Swal) {
          Swal.fire({
            icon: 'error',
            title: 'Error',
            text: error.message || 'An error occurred',
            confirmButtonText: 'OK',
            customClass: {
              confirmButton: 'btn btn-primary'
            }
          });
        } else {
          alert('Error: ' + (error.message || 'Unknown error'));
        }
      });
    });
  }
  
  // Start initialization
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', initForm);
  } else {
    initForm();
  }
})();
</script>
