<div class="modal-header">
    <h5 class="modal-title">Payment History</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<div class="modal-body">
    <!-- Student Info with Image -->
    <div class="row mb-4">
        <div class="col-12 mb-3">
            <div class="d-flex align-items-center">
                <div class="avatar avatar-lg me-3">
                    <img src="{{ $student->image ? asset($student->image) : asset('assets/img/avatars/default-avatar.png') }}" alt="Avatar" class="rounded-circle" width="60" height="60">
                </div>
                <div>
                    <h5 class="mb-1">{{ $student->name }} <small class="text-muted">({{ $student->roll_no }})</small></h5>
                    <p class="mb-0 text-muted">{{ $student->class->name ?? 'N/A' }} / {{ $student->section->name ?? 'N/A' }}</p>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <p class="mb-2"><strong>Father Name:</strong> {{ $student->fname ?? 'N/A' }}</p>
            <p class="mb-2"><strong>Mobile:</strong> {{ $student->mob1 ?? 'N/A' }}</p>
        </div>
        <div class="col-md-6">
            <p class="mb-2"><strong>Join Date:</strong> {{ $student->join_date ? date('d-m-Y', strtotime($student->join_date)) : 'N/A' }}</p>
            <p class="mb-2"><strong>Fee Status:</strong> 
                @if($student->fstatus == 0)
                <span class="badge bg-label-success">Regular</span>
                @else
                <span class="badge bg-label-danger">Free</span>
                @endif
            </p>
        </div>
    </div>

    <!-- Payment Statistics -->
    <div class="row mb-4">
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-success">
                <div class="card-body text-center">
                    <h6 class="mb-1">Paid Challans</h6>
                    <h4 class="text-success mb-0">{{ $challans->where('status', 4)->count() }}</h4>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-warning">
                <div class="card-body text-center">
                    <h6 class="mb-1">Pending</h6>
                    <h4 class="text-warning mb-0">{{ $challans->whereIn('status', [0, 1, 2])->count() }}</h4>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-success">
                <div class="card-body text-center">
                    <h6 class="mb-1">Total Paid</h6>
                    <h4 class="text-success mb-0">₨{{ number_format($challans->where('status', 4)->sum('amount'), 0) }}</h4>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-lg-3 mb-3">
            <div class="card border border-danger">
                <div class="card-body text-center">
                    <h6 class="mb-1">Total Unpaid</h6>
                    <h4 class="text-danger mb-0">₨{{ number_format($challans->whereIn('status', [0, 1, 2])->sum('amount'), 0) }}</h4>
                </div>
            </div>
        </div>
    </div>

    <!-- Challans Table -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead class="table-light">
                <tr>
                    <th>Challan No</th>
                    <th>Month</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Transaction ID</th>
                    <th>Payment Method</th>
                    <th>Date</th>
                </tr>
            </thead>
            <tbody>
                @forelse($challans as $challan)
                <tr>
                    <td><span class="fw-bold text-primary">{{ $challan->challan_no }}</span></td>
                    <td>{{ $challan->feemonth ? date('F Y', strtotime($challan->feemonth)) : 'N/A' }}</td>
                    <td>
                        ₨{{ number_format($challan->amount, 2) }}
                        @if($challan->description)
                        <br><small class="text-muted"><i class="ri-information-line"></i> {{ $challan->description }}</small>
                        @endif
                    </td>
                    <td>
                        @if($challan->status == 0)
                        <span class="badge bg-label-info">Issued</span>
                        @elseif($challan->status == 1)
                        <span class="badge bg-label-warning">Pending</span>
                        @elseif($challan->status == 2)
                        <span class="badge bg-label-primary">Waiting Approval</span>
                        @elseif($challan->status == 3)
                        <span class="badge bg-label-danger">Cancelled</span>
                        @elseif($challan->status == 4)
                        <span class="badge bg-label-success">Paid</span>
                        @else
                        <span class="badge bg-label-secondary">Unknown</span>
                        @endif
                    </td>
                    <td>{{ $challan->transid ?? 'N/A' }}</td>
                    <td>
                        @if($challan->payment_method == 'cash')
                        <span class="badge bg-label-success">Cash</span>
                        @elseif($challan->payment_method == 'bank_transfer')
                        <span class="badge bg-label-info">Bank Transfer</span>
                        @if($challan->bank_reference)
                        <br><small class="text-muted">Ref: {{ $challan->bank_reference }}</small>
                        @endif
                        @else
                        <span class="text-muted">-</span>
                        @endif
                    </td>
                    <td>{{ $challan->created_at ? date('d-m-Y', strtotime($challan->created_at)) : 'N/A' }}</td>
                </tr>
                @if($challan->history && $challan->history->count() > 0)
                <tr>
                    <td colspan="7" class="bg-light">
                        <small class="fw-bold text-muted">Status Change History:</small>
                        <div class="ms-3 mt-2">
                            @foreach($challan->history as $hist)
                            <div class="mb-2">
                                <span class="badge bg-label-secondary">{{ date('d-m-Y h:i A', strtotime($hist->created_at)) }}</span>
                                <span class="text-muted">Changed from</span>
                                <strong>{{ $hist->getStatusLabel($hist->old_status) }}</strong>
                                <span class="text-muted">to</span>
                                <strong>{{ $hist->getStatusLabel($hist->new_status) }}</strong>
                                <span class="text-muted">by</span>
                                <strong>{{ $hist->staff ? $hist->staff->name : 'System' }}</strong>
                                @if($hist->notes && !str_starts_with($hist->notes, 'Status changed from'))
                                <br><small class="text-muted ms-4">Note: {{ $hist->notes }}</small>
                                @endif
                            </div>
                            @endforeach
                        </div>
                    </td>
                </tr>
                @endif
                @empty
                <tr>
                    <td colspan="7" class="text-center text-muted">No payment history found</td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
</div>