@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Manage Cases')
@section('vendor-style')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apex-charts.scss',
  // 'resources/assets/vendor/libs/swiper/swiper.scss'
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',

  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
])
@endsection

@section('page-style')
@vite([
  // 'resources/assets/vendor/scss/pages/cards-statistics.scss',
  // 'resources/assets/vendor/scss/pages/cards-analytics.scss'
])
@endsection

@section('vendor-script')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apexcharts.js',
  // 'resources/assets/vendor/libs/swiper/swiper.js'

  'resources/assets/vendor/libs/select2/select2.js',

  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
])
@endsection

@section('page-script')
@vite(['resources/assets/js/chain-select.js'])
@vite('resources/assets/js/app-invoice-list.js')
<script type="module">
  window.addEventListener('load', function() {
    var select2Ready = typeof $ !== 'undefined' && typeof $.fn.select2 !== 'undefined';
    var lawUsedValues = new Set();
    var filterLawAjaxResults = function(processed, currentValue) {
      if (!processed || !processed.results) return processed;
      var mask = new Set(lawUsedValues);
      if (currentValue) {
        mask.delete(currentValue.toString());
      }
      var filtered = processed.results.filter(function(item) {
        if (!item) return false;
        var id = item.id != null ? item.id.toString() : '';
        return !mask.has(id);
      });
      return {
        results: filtered,
        pagination: processed.pagination
      };
    };

    var initSelect2 = function($elements) {
      if (!select2Ready || !$elements || !$elements.length) return;
      $elements.each(function () {
        var $this = $(this);
        if ($this.hasClass('select2-hidden-accessible')) return;

        var isAjaxSearch = $this.data('ajax-search') === true || $this.data('ajax') === true;
        var container = $this.parent();
        container.css('position', container.css('position') === 'static' ? 'relative' : container.css('position'));
        var config = {
          placeholder: $this.data('placeholder') || 'Select value',
          dropdownParent: container,
          width: '100%'
        };

        if (isAjaxSearch) {
          config.ajax = {
            url: '/api/ajax-search',
            dataType: 'json',
            delay: 250,
            transport: function(params, success, failure) {
              if (!params.data || !params.data.search || params.data.search.length < 1) {
                success({ results: [], pagination: { more: false } });
                return;
              }
              var $request = $.ajax(params);
              $request.then(success).fail(failure);
              return $request;
            },
            data: function (params) {
              var data = {
                search: params.term || '',
                page: params.page || 1,
                model: $this.data('ajax-model'),
                display: $this.data('ajax-display'),
                key: $this.data('ajax-key'),
                limit: $this.data('ajax-limit') || 20
              };
              var dependsOn = $this.data('depends-on');
              var filterColumn = $this.data('filter-column');
              if (dependsOn && filterColumn) {
                var parentSelect = document.querySelector('select[name="' + dependsOn + '"], select[name="' + dependsOn + '[]"]');
                if (parentSelect) {
                  var parentValue = parentSelect.multiple
                    ? Array.from(parentSelect.selectedOptions).map(opt => opt.value).filter(v => v !== '')
                    : parentSelect.value;
                  if (parentValue && (Array.isArray(parentValue) ? parentValue.length > 0 : parentValue !== '')) {
                    data.filterColumn = filterColumn;
                    data.filterValue = parentValue;
                  }
                }
              }
              return data;
            },
            processResults: function (data) {
              var base = data && data.results ? { results: data.results, pagination: { more: data.pagination.more } } : { results: [], pagination: { more: false } };
              if ($this.hasClass('law-select')) {
                return filterLawAjaxResults(base, $this.val());
              }
              return base;
            },
            cache: false
          };
          config.minimumInputLength = 1;
          config.allowClear = true;
        }

        $this.select2(config);
      });
    };

    var magContainer = document.getElementById('magrept');
    var magTemplateMarkup = magContainer ? magContainer.querySelector('.magrept-item').outerHTML : '';
    var magOptionTemplate = [];
    if (magContainer) {
      var sampleMagSelect = magContainer.querySelector('.mag-select');
      if (sampleMagSelect) {
        magOptionTemplate = Array.from(sampleMagSelect.options).map(function(option) {
          return {
            value: option.value,
            html: option.innerHTML
          };
        });
      }
    }

    var lawContainer = document.getElementById('lawrept');
    var lawTemplateMarkup = lawContainer ? lawContainer.querySelector('.lawrept-item').outerHTML : '';
    var lawOptionTemplate = [];
    if (lawContainer) {
      var sampleLawSelect = lawContainer.querySelector('.law-select');
      if (sampleLawSelect) {
        lawOptionTemplate = Array.from(sampleLawSelect.options).map(function(option) {
          return {
            value: option.value,
            html: option.innerHTML
          };
        });
      }
    }

    if (select2Ready) {
      initSelect2($('.select2'));
    }

    // --- Start: custom dynamic magazine reference rows ---
    if (magContainer && magTemplateMarkup) {
      var createMagRow = function() {
        var wrapper = document.createElement('div');
        wrapper.innerHTML = magTemplateMarkup;
        return wrapper.firstElementChild;
      };

      var setRowDisabled = function(row, disabled) {
        if (!row) return;
        row.querySelectorAll('input, select, textarea').forEach(function(ctrl) {
          if (ctrl.classList.contains('magrept-add')) return;
          if (ctrl.classList.contains('magrept-remove')) return;
          ctrl.disabled = disabled;
        });
      };

      var resetMagRowFields = function(row) {
        if (!row) return;
        row.querySelectorAll('input').forEach(function(input) {
          if (input.type === 'checkbox' || input.type === 'radio') {
            input.checked = input.defaultChecked;
          } else if (typeof input.defaultValue !== 'undefined') {
            input.value = input.defaultValue;
          } else {
            input.value = '';
          }
        });
        row.querySelectorAll('select').forEach(function(select) {
          select.selectedIndex = 0;
        });
      };

      var refreshMagButtons = function() {
        var rows = magContainer.querySelectorAll('.magrept-item');
        rows.forEach(function(row, index) {
          var addBtn = row.querySelector('.magrept-add');
          if (addBtn) {
            addBtn.style.visibility = index === rows.length - 1 ? 'visible' : 'hidden';
          }
          var removeBtn = row.querySelector('.magrept-remove');
          if (removeBtn) {
            removeBtn.style.visibility = rows.length === 1 ? 'hidden' : 'visible';
          }
        });
      };

      var refreshRowStates = function() {
        var rows = magContainer.querySelectorAll('.magrept-item');
        rows.forEach(function(row, index) {
          var disableRow = index !== rows.length - 1;
          setRowDisabled(row, disableRow);
        });
      };

      var rebuildSelectOptions = function(select, usedValues) {
        if (!select || !magOptionTemplate.length) return;
        var currentValue = select.value;
        var frag = document.createDocumentFragment();
        var hasCurrent = false;
        magOptionTemplate.forEach(function(templateOption) {
          var value = templateOption.value;
          var keepOption = !value || value === currentValue || !usedValues.has(value);
          if (!keepOption) return;
          var option = document.createElement('option');
          option.value = value;
          option.innerHTML = templateOption.html;
          if (value === currentValue) {
            hasCurrent = true;
          }
          frag.appendChild(option);
        });
        select.innerHTML = '';
        select.appendChild(frag);
        select.value = currentValue && hasCurrent ? currentValue : '';
      };

      var updateMagAvailability = function() {
        var selects = Array.from(magContainer.querySelectorAll('.mag-select'));
        if (!selects.length) return;

        var usedValues = selects.reduce(function(set, select) {
          if (select.value) {
            set.add(select.value);
          }
          return set;
        }, new Set());

        selects.forEach(function(select) {
          rebuildSelectOptions(select, usedValues);
        });

        if (select2Ready) {
          selects.forEach(function(select) {
            var $select = $(select);
            var currentValue = select.value;
            if ($select.hasClass('select2-hidden-accessible')) {
              $select.select2('destroy');
            }
            initSelect2($select);
            if (currentValue) {
              $select.val(currentValue).trigger('change.select2');
            }
          });
        }
      };

      refreshMagButtons();
      refreshRowStates();
      updateMagAvailability();

      magContainer.addEventListener('change', function(evt) {
        if (evt.target && evt.target.matches('.mag-select')) {
          updateMagAvailability();
        }
      });

      magContainer.addEventListener('focusin', function(evt) {
        if (evt.target && evt.target.matches('.mag-select')) {
          updateMagAvailability();
          if (select2Ready) {
            var $target = $(evt.target);
            var currentValue = $target.val();
            if ($target.hasClass('select2-hidden-accessible')) {
              $target.select2('destroy');
            }
            initSelect2($target);
            if (currentValue) {
              $target.val(currentValue).trigger('change.select2');
            }
          }
        }
      });

      magContainer.addEventListener('click', function(evt) {
        var addTrigger = evt.target.closest('.magrept-add');
        if (addTrigger) {
          evt.preventDefault();
          var newRow = createMagRow();
          if (!newRow) return;
          resetMagRowFields(newRow);
          newRow.querySelectorAll('[id]').forEach(function(node) {
            node.removeAttribute('id');
          });
          magContainer.appendChild(newRow);
          if (select2Ready) {
            initSelect2($(newRow).find('.select2'));
          }
          refreshMagButtons();
          refreshRowStates();
          updateMagAvailability();
          return;
        }

        var removeTrigger = evt.target.closest('.magrept-remove');
        if (removeTrigger) {
          evt.preventDefault();
          var rows = magContainer.querySelectorAll('.magrept-item');
          if (rows.length === 1) {
            refreshMagButtons();
            return;
          }
          var targetRow = removeTrigger.closest('.magrept-item');
          if (targetRow) {
            targetRow.remove();
            refreshMagButtons();
            refreshRowStates();
            updateMagAvailability();
          }
        }
      });
    }
    // --- End: custom dynamic magazine reference rows ---

    // --- Start: custom dynamic law reference rows ---

    if (lawContainer && lawTemplateMarkup) {
      var createLawRow = function() {
        var wrapper = document.createElement('div');
        wrapper.innerHTML = lawTemplateMarkup;
        return wrapper.firstElementChild;
      };

      var setLawRowDisabled = function(row, disabled) {
        if (!row) return;
        row.querySelectorAll('input, select, textarea').forEach(function(ctrl) {
          if (ctrl.classList.contains('lawrept-add')) return;
          if (ctrl.classList.contains('lawrept-remove')) return;
          ctrl.disabled = disabled;
        });
      };

      var resetLawRowFields = function(row) {
        if (!row) return;
        row.querySelectorAll('input').forEach(function(input) {
          if (input.type === 'checkbox' || input.type === 'radio') {
            input.checked = input.defaultChecked;
          } else if (typeof input.defaultValue !== 'undefined') {
            input.value = input.defaultValue;
          } else {
            input.value = '';
          }
        });
        row.querySelectorAll('select').forEach(function(select) {
          select.selectedIndex = 0;
        });
      };

      var refreshLawButtons = function() {
        var rows = lawContainer.querySelectorAll('.lawrept-item');
        rows.forEach(function(row, index) {
          var addBtn = row.querySelector('.lawrept-add');
          if (addBtn) {
            addBtn.style.visibility = index === rows.length - 1 ? 'visible' : 'hidden';
          }
          var removeBtn = row.querySelector('.lawrept-remove');
          if (removeBtn) {
            removeBtn.style.visibility = rows.length === 1 ? 'hidden' : 'visible';
          }
        });
      };

      var refreshLawRowStates = function() {
        var rows = lawContainer.querySelectorAll('.lawrept-item');
        rows.forEach(function(row, index) {
          var disableRow = index !== rows.length - 1;
          setLawRowDisabled(row, disableRow);
        });
      };

      var refreshLawUsedState = function(selects) {
        lawUsedValues.clear();
        selects.forEach(function(select) {
          var val = select.value;
          if (val) {
            lawUsedValues.add(val.toString());
          }
          select.dataset.currentValue = val || '';
        });
      };

      var rebuildLawSelectOptions = function(select, usedValues) {
        if (!select) return;
        if (select.dataset.ajax === 'true') {
          return;
        }
        if (!lawOptionTemplate.length) return;
        var currentValue = select.value;
        var frag = document.createDocumentFragment();
        var hasCurrent = false;
        lawOptionTemplate.forEach(function(templateOption) {
          var value = templateOption.value;
          var keepOption = !value || value === currentValue || !usedValues.has(value);
          if (!keepOption) return;
          var option = document.createElement('option');
          option.value = value;
          option.innerHTML = templateOption.html;
          if (value === currentValue) {
            hasCurrent = true;
          }
          frag.appendChild(option);
        });
        select.innerHTML = '';
        select.appendChild(frag);
        select.value = currentValue && hasCurrent ? currentValue : '';
      };

      var updateLawAvailability = function() {
        var selects = Array.from(lawContainer.querySelectorAll('.law-select'));
        if (!selects.length) return;

        var usedValues = selects.reduce(function(set, select) {
          if (select.value) {
            set.add(select.value);
          }
          return set;
        }, new Set());

        selects.forEach(function(select) {
          rebuildLawSelectOptions(select, usedValues);
        });

        refreshLawUsedState(selects);

        if (select2Ready) {
          selects.forEach(function(select) {
            var $select = $(select);
            var currentValue = select.value;
            if ($select.hasClass('select2-hidden-accessible')) {
              $select.select2('destroy');
            }
            initSelect2($select);
            if (currentValue) {
              $select.val(currentValue).trigger('change.select2');
            }
          });
        }
      };

      refreshLawButtons();
      refreshLawRowStates();
      updateLawAvailability();

      lawContainer.addEventListener('change', function(evt) {
        if (evt.target && evt.target.matches('.law-select')) {
          var select = evt.target;
          var prevValue = select.dataset.currentValue || '';
          var newValue = select.value || '';
          var usedExcludingCurrent = new Set(lawUsedValues);
          if (prevValue) {
            usedExcludingCurrent.delete(prevValue);
          }
          if (newValue && usedExcludingCurrent.has(newValue)) {
            if (select2Ready) {
              $(select).val(prevValue).trigger('change.select2');
            } else {
              select.value = prevValue;
            }
            return;
          }
          updateLawAvailability();
        }
      });

      lawContainer.addEventListener('focusin', function(evt) {
        if (evt.target && evt.target.matches('.law-select')) {
          updateLawAvailability();
          if (select2Ready) {
            var $target = $(evt.target);
            var currentValue = $target.val();
            if ($target.hasClass('select2-hidden-accessible')) {
              $target.select2('destroy');
            }
            initSelect2($target);
            if (currentValue) {
              $target.val(currentValue).trigger('change.select2');
            }
          }
        }
      });

      lawContainer.addEventListener('click', function(evt) {
        var addTrigger = evt.target.closest('.lawrept-add');
        if (addTrigger) {
          evt.preventDefault();
          var newRow = createLawRow();
          if (!newRow) return;
          resetLawRowFields(newRow);
          newRow.querySelectorAll('[id]').forEach(function(node) {
            node.removeAttribute('id');
          });
          lawContainer.appendChild(newRow);
          if (select2Ready) {
            initSelect2($(newRow).find('.select2'));
          }
          refreshLawButtons();
          refreshLawRowStates();
          updateLawAvailability();
          return;
        }

        var removeTrigger = evt.target.closest('.lawrept-remove');
        if (removeTrigger) {
          evt.preventDefault();
          var rows = lawContainer.querySelectorAll('.lawrept-item');
          if (rows.length === 1) {
            refreshLawButtons();
            return;
          }
          var targetRow = removeTrigger.closest('.lawrept-item');
          if (targetRow) {
            targetRow.remove();
            refreshLawButtons();
            refreshLawRowStates();
            updateLawAvailability();
          }
        }
      });
    }
    // --- End: custom dynamic law reference rows ---
  });
</script>
@endsection

@section('content')
<div class="row g-4">



  <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">

        <div class="row g-3 align-items-start">

          <div class="col-md-3">
            <h4 class="card-title mb-2">Manage Cases</h4>
            <p class="mb-0">List edit and search cases here.</p>
          </div>

          <div class="col-md-9">
            <div class="demo-inline-spacing d-flex flex-wrap gap-2">
              <button type="button" class="btn rounded-pill btn-primary">All</button>
              <button type="button" class="btn rounded-pill btn-danger">Add Record</button>
              <button type="button" class="btn rounded-pill btn-secondary">Head Notes</button>
              <button type="button" class="btn rounded-pill btn-info">Judgment</button>
              <button type="button" class="btn rounded-pill btn-warning">Export cases</button>
              <button type="button" class="btn rounded-pill btn-dark">Get Case ID</button>

              <button type="button" class="btn btn-secondary waves-effect waves-light">
              <span class="tf-icons ri-notification-4-line ri-16px me-2"></span>Secondary
            </button>


            </div>
          </div>


        </div>

      </div>
    </div>
  </div>
  <!--/ Header Card -->





    <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">







<!-- Form Start -->

        <form action="#" method="POST" class="needs-validation" novalidate>
          @csrf
          <div class="row gy-4">
            <div class="col-12 d-flex flex-wrap justify-content-between align-items-center">
              <div>
                <h5 class="mb-1">Add Case Law Detail</h5>
                <p class="text-muted mb-0">Provide the basic case attributes before saving.</p>
              </div>
              <button type="submit" class="btn btn-primary">Add Record</button>
            </div>

            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">SR # <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="sr_no" placeholder="Enter SR" required>
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Date</label>
              <input type="date" class="form-control" name="case_date" value="2011-01-15">
            </div>

             <div class="col-md-3 col-sm-6">
                    <label class="form-label fw-semibold">Select Department</label>
                    <x-form.select
                      name="mag"
                      model="App\Models\CmsDepartment"
                      :query="['orderBy',['dept_name','asc']]"
                      display="dept_name"
                      key="dept_id"
                      label="Select Department"
                      placeholder="Select Department"
                      class="form-select select2 "
                      data-placeholder="Select Department"
                    />
                  </div>

            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Status</label>
              <select class="form-select" name="status">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
                <option value="archived">Archived</option>
              </select>
            </div>

            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Year</label>
              <input type="number" class="form-control" name="year_primary" value="">
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Mag</label>
              <input type="text" class="form-control" name="mag_primary" value="SLD" disabled>
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Page</label>
              <input type="number" class="form-control" name="page_primary" placeholder="Enter page">
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Month</label>
              <select class="form-select" name="month_primary">
                <option value="">Select</option>
                <option>January</option>
                <option>February</option>
                <option>March</option>
                <option>April</option>
                <option>May</option>
                <option>June</option>
                <option>July</option>
                <option>August</option>
                <option>September</option>
                <option>October</option>
                <option>November</option>
                <option>December</option>
              </select>
            </div>

            <div class="col-12">
              <div id="magrept">
                <div class="row gy-3 align-items-end magrept-item">
                  <div class="col-md-1 col-sm-6">
                    <label class="form-label fw-semibold">Year</label>
                    <input type="number" class="form-control" name="year_secondary[]" value="">
                  </div>
                  <div class="col-md-2 col-sm-6">
                    <label class="form-label fw-semibold">Vol.</label>
                    <input type="text" class="form-control" name="volume_secondary[]" placeholder="Enter volume">
                  </div>

                  <div class="col-md-2 col-sm-6">
                    <label class="form-label fw-semibold">Select Magazine</label>
                    <x-form.select
                      name="mag"
                      model="App\Models\CmsMagazine"
                      :query="[['orderBy',['mag_name','asc']], ['where',['mag_id','<>',1]]]"
                      display="mag_name"
                      key="mag_id"
                      label="Select Magazine"
                      placeholder="Select Magazine"
                      class="form-select select2 mag-select"
                      data-placeholder="Select Magazine"
                    />
                  </div>

                  <div class="col-md-2 col-sm-6">
                    <label class="form-label fw-semibold">Page</label>
                    <input type="number" class="form-control" name="page_secondary[]" placeholder="Enter page">
                  </div>
                  <div class="col-md-3 col-sm-6">
                    <label class="form-label fw-semibold">Month</label>
                    <select class="form-select" name="month_secondary[]">
                      <option value="">Select</option>
                      <option>January</option>
                      <option>February</option>
                      <option>March</option>
                      <option>April</option>
                      <option>May</option>
                      <option>June</option>
                      <option>July</option>
                      <option>August</option>
                      <option>September</option>
                      <option>October</option>
                      <option>November</option>
                      <option>December</option>
                    </select>
                  </div>
                  <div class="col-md-1 col-sm-6 d-flex align-items-end">
                    <button type="button" class="btn btn-sm btn-primary w-100 text-nowrap magrept-add">+ Add More</button>
                  </div>
                  <div class="col-md-1 col-sm-6 d-flex align-items-end">
                    <button type="button" class="btn btn-sm btn-outline-danger w-100 magrept-remove" aria-label="Remove row">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                </div>
              </div>
            </div>





            <div class="col-md-6">
              <label class="form-label fw-semibold">Court</label>
              <input type="text" class="form-control" name="court" placeholder="Appellate Tribunal Inland Revenue">
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Case No.</label>
              <input type="text" class="form-control" name="case_no" placeholder="Enter case number">
            </div>

            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Petitioners</label>
              <textarea class="form-control" name="petitioners" rows="4"></textarea>
            </div>
            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Judges</label>
              <textarea class="form-control" name="judges" rows="4"></textarea>
            </div>
            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Lawyers</label>
              <textarea class="form-control" name="lawyers" rows="4"></textarea>
            </div>

            <div class="col-lg-12">
              <label class="form-label fw-semibold">Head Note</label>
              <textarea class="form-control" name="head_note" rows="10"></textarea>
            </div>



<div class="col-12">
<div id="lawrept">
                <div class="row gy-3 align-items-end lawrept-item">
                  <div class="col-md-5 col-sm-6">
                    <label class="form-label fw-semibold">Law/Statutes</label>
                    <x-form.select
                      name="law_id[]"
                      model="App\Models\CmsLawstatute"
                      :query="['orderBy',['law_name','asc']]"
                      display="law_name"
                      key="law_id"
                      label="Select Law"
                      placeholder="Select Law"
                      class="form-select select2 law-select"
                      data-placeholder="Select Law"
                      data-ajax="true"
                      data-ajax-search="true"
                      data-ajax-limit="20"
                      :ajax="true"
                      :ajax-limit="20"
                    />
                  </div>
                  <div class="col-md-4 col-sm-6">
                    <label class="form-label fw-semibold">Sections</label>
                    <input type="text" class="form-control" name="sections[]" placeholder="e.g. Sec 18, Sec 22">
                  </div>
                  <div class="col-md-2 col-sm-6 d-flex align-items-end">
                    <button type="button" class="btn btn-sm btn-primary w-100 text-nowrap lawrept-add">+ Add More</button>
                  </div>
                  <div class="col-md-1 col-sm-6 d-flex align-items-end">
                    <button type="button" class="btn btn-sm btn-outline-danger w-100 lawrept-remove" aria-label="Remove row">
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                </div>
              </div>
</div>


            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Attachment</label>
              <input class="form-control" type="file" name="attachment" accept=".pdf,.doc,.docx,.jpg,.png">
              <small class="text-muted d-block mt-2">Max allowed size is 5MB.</small>
            </div>

            <div class="col-12">
              <label class="form-label fw-semibold">Judgment</label>

              <x-form.textarea
                name="article_content"
                {{-- label="Article Content" --}}
                placeholder="Start writing your article..."
                editor="ckeditor"
                :editorHeight="400"
                :floatingLabel="false"
              />


            </div>

            <div class="col-12">
               <label class="form-label fw-semibold">Principle Law</label>
              <x-form.select
                      name="mag"
                      model="App\Models\CmsPrinciplelaw"
                      {{-- :query="[['orderBy',['mag_name','asc']], ['where',['mag_id','<>',1]]]" --}}
                      display="plaw_name"
                      key="plaw_id"
                      label="Select Law"
                      placeholder="Select Law"
                      class="form-select select2 mag-select"
                      data-placeholder="Select Law"
                      :ajax="true"
                      :ajaxLimit="20"
                      :multiple="true"
                    />
            </div>

            <div class="col-12 d-flex justify-content-end gap-2">
              <button type="button" class="btn btn-outline-secondary">Cancel</button>
              <button type="submit" class="btn btn-primary">Add Record</button>
            </div>
          </div>
        </form>


<!-- Form End-->









      </div>
    </div>
  </div>
  <!--/ Header Card -->













</div>
@endsection
