@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Empty Page')
@section('vendor-style')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apex-charts.scss',
  // 'resources/assets/vendor/libs/swiper/swiper.scss'


])
@endsection

@section('page-style')
<!-- Page -->
@vite([
  // 'resources/assets/vendor/scss/pages/cards-statistics.scss',
  // 'resources/assets/vendor/scss/pages/cards-analytics.scss'
])
@endsection

@section('vendor-script')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apexcharts.js',
  // 'resources/assets/vendor/libs/swiper/swiper.js'
])
@endsection

@section('page-script')
@vite([
  // 'resources/assets/js/dashboards-analytics.js'

  ])
@endsection

@section('content')
<div class="row g-4">

  <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title mb-2">Welcome to Your Page</h4>
        <p class="mb-0">This is a template page with various components. Customize it according to your needs.</p>
      </div>
    </div>
  </div>
  <!--/ Header Card -->

  <!-- Statistics Cards -->
  <div class="col-xl-3 col-sm-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
          <div class="avatar">
            <div class="avatar-initial bg-label-primary rounded-3">
              <i class="ri-user-line ri-24px"></i>
            </div>
          </div>
          <div class="d-flex align-items-center">
            <p class="mb-0 text-success me-1">+28%</p>
            <i class="ri-arrow-up-s-line text-success"></i>
          </div>
        </div>
        <div class="card-info mt-5">
          <h5 class="mb-1">1,234</h5>
          <p>Total Users</p>
          <div class="badge bg-label-secondary rounded-pill">This Month</div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xl-3 col-sm-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
          <div class="avatar">
            <div class="avatar-initial bg-label-success rounded-3">
              <i class="ri-file-text-line ri-24px"></i>
            </div>
          </div>
          <div class="d-flex align-items-center">
            <p class="mb-0 text-success me-1">+12%</p>
            <i class="ri-arrow-up-s-line text-success"></i>
          </div>
        </div>
        <div class="card-info mt-5">
          <h5 class="mb-1">567</h5>
          <p>Total Records</p>
          <div class="badge bg-label-secondary rounded-pill">This Month</div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xl-3 col-sm-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
          <div class="avatar">
            <div class="avatar-initial bg-label-warning rounded-3">
              <i class="ri-time-line ri-24px"></i>
            </div>
          </div>
          <div class="d-flex align-items-center">
            <p class="mb-0 text-danger me-1">-8%</p>
            <i class="ri-arrow-down-s-line text-danger"></i>
          </div>
        </div>
        <div class="card-info mt-5">
          <h5 class="mb-1">89</h5>
          <p>Pending Items</p>
          <div class="badge bg-label-secondary rounded-pill">This Week</div>
        </div>
      </div>
    </div>
  </div>

  <div class="col-xl-3 col-sm-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-start flex-wrap gap-2">
          <div class="avatar">
            <div class="avatar-initial bg-label-info rounded-3">
              <i class="ri-check-line ri-24px"></i>
            </div>
          </div>
          <div class="d-flex align-items-center">
            <p class="mb-0 text-success me-1">+45%</p>
            <i class="ri-arrow-up-s-line text-success"></i>
          </div>
        </div>
        <div class="card-info mt-5">
          <h5 class="mb-1">342</h5>
          <p>Completed</p>
          <div class="badge bg-label-secondary rounded-pill">This Month</div>
        </div>
      </div>
    </div>
  </div>
  <!--/ Statistics Cards -->

  <!-- Data Table -->
  <div class="col-12">
    <div class="card">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Recent Activities</h5>
        <div class="dropdown">
          <button class="btn btn-text-secondary rounded-pill text-muted border-0 p-1" type="button" id="recentActivities" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <i class="ri-more-2-line ri-20px"></i>
          </button>
          <div class="dropdown-menu dropdown-menu-end" aria-labelledby="recentActivities">
            <a class="dropdown-item" href="javascript:void(0);">View All</a>
            <a class="dropdown-item" href="javascript:void(0);">Refresh</a>
            <a class="dropdown-item" href="javascript:void(0);">Export</a>
          </div>
        </div>
      </div>
      <div class="table-responsive text-nowrap">
        <table class="table">
          <thead>
            <tr>
              <th>ID</th>
              <th>Name</th>
              <th>Status</th>
              <th>Date</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody class="table-border-bottom-0">
            <tr>
              <td><span class="fw-medium">#001</span></td>
              <td>Sample Item 1</td>
              <td><span class="badge bg-label-success rounded-pill">Active</span></td>
              <td>2025-11-12</td>
              <td>
                <div class="dropdown">
                  <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                    <i class="ri-more-2-line"></i>
                  </button>
                  <div class="dropdown-menu">
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-1"></i> Edit</a>
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1"></i> Delete</a>
                  </div>
                </div>
              </td>
            </tr>
            <tr>
              <td><span class="fw-medium">#002</span></td>
              <td>Sample Item 2</td>
              <td><span class="badge bg-label-warning rounded-pill">Pending</span></td>
              <td>2025-11-11</td>
              <td>
                <div class="dropdown">
                  <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                    <i class="ri-more-2-line"></i>
                  </button>
                  <div class="dropdown-menu">
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-1"></i> Edit</a>
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1"></i> Delete</a>
                  </div>
                </div>
              </td>
            </tr>
            <tr>
              <td><span class="fw-medium">#003</span></td>
              <td>Sample Item 3</td>
              <td><span class="badge bg-label-primary rounded-pill">In Progress</span></td>
              <td>2025-11-10</td>
              <td>
                <div class="dropdown">
                  <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                    <i class="ri-more-2-line"></i>
                  </button>
                  <div class="dropdown-menu">
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-1"></i> Edit</a>
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1"></i> Delete</a>
                  </div>
                </div>
              </td>
            </tr>
            <tr>
              <td><span class="fw-medium">#004</span></td>
              <td>Sample Item 4</td>
              <td><span class="badge bg-label-danger rounded-pill">Cancelled</span></td>
              <td>2025-11-09</td>
              <td>
                <div class="dropdown">
                  <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                    <i class="ri-more-2-line"></i>
                  </button>
                  <div class="dropdown-menu">
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-1"></i> Edit</a>
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1"></i> Delete</a>
                  </div>
                </div>
              </td>
            </tr>
            <tr>
              <td><span class="fw-medium">#005</span></td>
              <td>Sample Item 5</td>
              <td><span class="badge bg-label-info rounded-pill">On Hold</span></td>
              <td>2025-11-08</td>
              <td>
                <div class="dropdown">
                  <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                    <i class="ri-more-2-line"></i>
                  </button>
                  <div class="dropdown-menu">
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-pencil-line me-1"></i> Edit</a>
                    <a class="dropdown-item" href="javascript:void(0);"><i class="ri-delete-bin-line me-1"></i> Delete</a>
                  </div>
                </div>
              </td>
            </tr>
          </tbody>
        </table>
      </div>
    </div>
  </div>
  <!--/ Data Table -->

  <!-- Two Column Layout -->
  <div class="col-md-6">
    <div class="card h-100">
      <div class="card-header">
        <h5 class="mb-0">Quick Actions</h5>
      </div>
      <div class="card-body">
        <div class="d-grid gap-3">
          <button type="button" class="btn btn-primary">
            <i class="ri-add-line me-2"></i>Create New Item
          </button>
          <button type="button" class="btn btn-outline-secondary">
            <i class="ri-download-line me-2"></i>Export Data
          </button>
          <button type="button" class="btn btn-outline-secondary">
            <i class="ri-settings-line me-2"></i>Settings
          </button>
          <button type="button" class="btn btn-outline-secondary">
            <i class="ri-file-line me-2"></i>Generate Report
          </button>
        </div>
      </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="card h-100">
      <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Recent Notifications</h5>
        <span class="badge bg-primary rounded-pill">3 New</span>
      </div>
      <div class="card-body">
        <ul class="list-unstyled mb-0">
          <li class="d-flex align-items-center mb-4">
            <div class="avatar flex-shrink-0 me-3">
              <span class="avatar-initial rounded-circle bg-label-primary">
                <i class="ri-notification-line"></i>
              </span>
            </div>
            <div class="flex-grow-1">
              <h6 class="mb-1">New update available</h6>
              <small class="text-muted">2 hours ago</small>
            </div>
          </li>
          <li class="d-flex align-items-center mb-4">
            <div class="avatar flex-shrink-0 me-3">
              <span class="avatar-initial rounded-circle bg-label-success">
                <i class="ri-check-line"></i>
              </span>
            </div>
            <div class="flex-grow-1">
              <h6 class="mb-1">Task completed successfully</h6>
              <small class="text-muted">5 hours ago</small>
            </div>
          </li>
          <li class="d-flex align-items-center mb-4">
            <div class="avatar flex-shrink-0 me-3">
              <span class="avatar-initial rounded-circle bg-label-warning">
                <i class="ri-alert-line"></i>
              </span>
            </div>
            <div class="flex-grow-1">
              <h6 class="mb-1">Action required</h6>
              <small class="text-muted">1 day ago</small>
            </div>
          </li>
          <li class="d-flex align-items-center">
            <div class="avatar flex-shrink-0 me-3">
              <span class="avatar-initial rounded-circle bg-label-info">
                <i class="ri-information-line"></i>
              </span>
            </div>
            <div class="flex-grow-1">
              <h6 class="mb-1">System maintenance scheduled</h6>
              <small class="text-muted">2 days ago</small>
            </div>
          </li>
        </ul>
      </div>
    </div>
  </div>
  <!--/ Two Column Layout -->

  <!-- Progress Cards -->
  <div class="col-lg-4 col-md-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
          <h6 class="mb-0">Project Progress</h6>
          <span class="text-muted">75%</span>
        </div>
        <div class="progress mb-3" style="height: 8px;">
          <div class="progress-bar bg-primary" role="progressbar" style="width: 75%;" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100"></div>
        </div>
        <small class="text-muted">15 of 20 tasks completed</small>
      </div>
    </div>
  </div>

  <div class="col-lg-4 col-md-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
          <h6 class="mb-0">Storage Usage</h6>
          <span class="text-muted">60%</span>
        </div>
        <div class="progress mb-3" style="height: 8px;">
          <div class="progress-bar bg-success" role="progressbar" style="width: 60%;" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100"></div>
        </div>
        <small class="text-muted">6.0 GB of 10 GB used</small>
      </div>
    </div>
  </div>

  <div class="col-lg-4 col-md-6">
    <div class="card">
      <div class="card-body">
        <div class="d-flex justify-content-between mb-2">
          <h6 class="mb-0">Goal Achievement</h6>
          <span class="text-muted">92%</span>
        </div>
        <div class="progress mb-3" style="height: 8px;">
          <div class="progress-bar bg-warning" role="progressbar" style="width: 92%;" aria-valuenow="92" aria-valuemin="0" aria-valuemax="100"></div>
        </div>
        <small class="text-muted">Almost there!</small>
      </div>
    </div>
  </div>
  <!--/ Progress Cards -->

</div>
@endsection
