@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Fee Challans')

<!-- Vendor Styles -->
@section('vendor-style')
@vite([
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss',
  'resources/assets/vendor/libs/flatpickr/flatpickr.scss',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.scss',
  'resources/assets/vendor/libs/@form-validation/form-validation.scss'
  ])
@endsection

<!-- Vendor Scripts -->
@section('vendor-script')
@vite([
  'resources/assets/vendor/libs/select2/select2.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js',
  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/flatpickr/flatpickr.js',
  'resources/assets/vendor/libs/sweetalert2/sweetalert2.js',
  'resources/assets/vendor/libs/@form-validation/popular.js',
  'resources/assets/vendor/libs/@form-validation/bootstrap5.js',
  'resources/assets/vendor/libs/@form-validation/auto-focus.js'
  ])
@endsection

<!-- Page Scripts -->
@section('page-script')
@vite([
  'resources/assets/js/chain-select.js',
  'resources/assets/js/myapp/datatables-challans.js'
  ])
<script type="module">
  'use strict';

  // Define base URL for AJAX calls
  window.baseUrl = '{{ config("app.url") }}';

  window.addEventListener('load', function() {
    if (typeof $ === 'undefined' || typeof $.fn.select2 === 'undefined') {
      console.error('[ERROR] jQuery or Select2 is not loaded!');
      return;
    }

    var select2Elements = $('.select2');

    if (select2Elements.length) {
      select2Elements.each(function () {
        var $this = $(this);

        if ($this.hasClass('select2-hidden-accessible')) {
          return;
        }

        var select2Config = {
          placeholder: $this.data('placeholder') || 'Select value',
          dropdownParent: $this.parent()
        };

        var dependsOn = $this.data('depends-on');
        var filterColumn = $this.data('filter-column');

        $this.wrap('<div class="position-relative"></div>').select2(select2Config);
      });
    }
  });
</script>
@endsection

@section('content')
<!-- Statistics Cards -->
<div class="row g-4 mb-4" id="challanStatsContainer">
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-primary h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-primary"><i class="ri-file-list-3-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-total-challans">{{ $stats['total_challans'] }}</h4>
        </div>
        <p class="mb-0">Total Challans</p>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-warning h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-warning"><i class="ri-file-text-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-active-challans">{{ $stats['issued'] + $stats['pending'] }}</h4>
        </div>
        <p class="mb-0">Active Challans</p>
        <small class="text-muted" id="stat-active-details">Issued: {{ $stats['issued'] }} | Pending: {{ $stats['pending'] }}</small>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-success h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-success"><i class="ri-money-dollar-circle-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-paid-amount">₨{{ number_format($stats['paid_amount'], 0) }}</h4>
        </div>
        <p class="mb-0">Paid Amount</p>
        <small class="text-muted" id="stat-paid-details">{{ $stats['paid'] }} paid challans</small>
      </div>
    </div>
  </div>
  <div class="col-sm-6 col-lg-3">
    <div class="card card-border-shadow-danger h-100">
      <div class="card-body">
        <div class="d-flex align-items-center mb-2">
          <div class="avatar me-3">
            <span class="avatar-initial rounded bg-label-danger"><i class="ri-wallet-3-line ri-22px"></i></span>
          </div>
          <h4 class="mb-0" id="stat-unpaid-amount">₨{{ number_format($stats['unpaid_amount'], 0) }}</h4>
        </div>
        <p class="mb-0">Unpaid Amount</p>
        <small class="text-muted">Issued & pending challans</small>
      </div>
    </div>
  </div>
</div>

<div class="row g-4">

  <!-- Filters -->
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-md-3">
          <label for="filterClass" class="form-label">Select Class <span class="text-danger">*</span></label>
          <x-form.select
            name="filterClass"
            model="App\Models\App_Class"
            :query="[['where',['app_school_id',Auth::user()->app_school_id]]]"
            display="name"
            key="id"
            placeholder="Select Class"
            class="form-control select2"
            id="filterClass"
            data-placeholder="Select Class"
          />
        </div>
        <div class="col-md-3">
          <label for="filterSection" class="form-label">Select Section <span class="text-danger">*</span></label>
          <x-form.select
            name="filterSection"
            model="App\Models\App_section"
            display="name"
            key="id"
            class="form-control select2"
            id="filterSection"
            dependsOn="filterClass"
            filterColumn="app_class_id"
            data-placeholder="Select Section"
          />
        </div>
        <div class="col-md-3">
          <label for="filterStatus" class="form-label">Select Status</label>
          <select class="form-select select2" id="filterStatus" name="filterStatus" data-placeholder="Select Status">
            <option value=""></option>
            <option value="0">Issued</option>
            <option value="1">Pending</option>
            <option value="2">Waiting Approval</option>
            <option value="3">Cancelled</option>
            <option value="4">Paid</option>
          </select>
        </div>
        <div class="col-md-3 d-flex align-items-end gap-2">
          <button id="filterBtn" class="btn btn-primary flex-grow-1">Filter</button>
          <button id="clearFilterBtn" class="btn btn-secondary flex-grow-1">Clear</button>
        </div>
      </div>
    </div>
  </div>

  <!-- DataTable with Buttons -->
  <div class="card">
    <div class="card-datatable table-responsive pt-0">
      <table class="datatables-basic table table-bordered">
        <thead class="text-center">
          <tr>
            <th></th>
            <th></th>
            <th>Chal/Date</th>
            <th>Month</th>
            <th>Amount</th>
            <th>Student</th>
            <th>Class/Section</th>
            <th>Trans ID</th>
            <th>Status</th>
            <th>Activity</th>
            <th>Actions</th>
          </tr>
        </thead>
      </table>
    </div>
  </div>

  <!-- Toast Container for Notifications -->
  <div class="toast-container position-fixed top-0 end-0 p-3">
    <div id="challanToast" class="toast fade" role="alert" aria-live="assertive" aria-atomic="true" data-bs-delay="3000">
      <div class="toast-header">
        <i id="toastIcon" class="ri-checkbox-circle-fill me-2"></i>
        <div id="toastTitle" class="me-auto fw-medium">Success</div>
        <small class="text-muted">just now</small>
        <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
      </div>
      <div class="toast-body">
        <span id="toastMessage">Operation completed successfully!</span>
      </div>
    </div>
  </div>

  <!-- Modal for Add/Edit Challan -->
  <div class="modal fade" id="challanModal" tabindex="-1" aria-labelledby="challanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
      <div class="modal-content">
        <div id="challanModalContent">
          <!-- Content will be loaded via AJAX -->
        </div>
      </div>
    </div>
  </div>

  <!-- Modal for Payment History -->
  <div class="modal fade" id="paymentHistoryModal" tabindex="-1" aria-labelledby="paymentHistoryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
      <div class="modal-content">
        <div id="paymentHistoryModalContent">
          <!-- Content will be loaded via AJAX -->
        </div>
      </div>
    </div>
  </div>

</div>
@endsection
