@php
$configData = Helper::appClasses();
@endphp

@extends('layouts/layoutMaster')

@section('title', 'Manage Cases')
@section('vendor-style')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apex-charts.scss',
  // 'resources/assets/vendor/libs/swiper/swiper.scss'
  'resources/assets/vendor/libs/select2/select2.scss',
  'resources/assets/vendor/libs/datatables-bs5/datatables.bootstrap5.scss',

  'resources/assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.scss',
  'resources/assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.scss',
  'resources/assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.scss'
])
@endsection

@section('page-style')
@vite([
  // 'resources/assets/vendor/scss/pages/cards-statistics.scss',
  // 'resources/assets/vendor/scss/pages/cards-analytics.scss'
])
@endsection

@section('vendor-script')
@vite([
  // 'resources/assets/vendor/libs/apex-charts/apexcharts.js',
  // 'resources/assets/vendor/libs/swiper/swiper.js'

  'resources/assets/vendor/libs/select2/select2.js',

  'resources/assets/vendor/libs/moment/moment.js',
  'resources/assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js'
])
@endsection

@section('page-script')
@vite(['resources/assets/js/chain-select.js'])
@vite('resources/assets/js/app-invoice-list.js')
<script type="module">
  window.addEventListener('load', function() {
    if (typeof $ === 'undefined' || typeof $.fn.select2 === 'undefined') return;

    $('.select2').each(function () {
      var $this = $(this);
      if ($this.hasClass('select2-hidden-accessible')) return;

      var isAjaxSearch = $this.data('ajax-search') === true;
      var container = $this.parent();
      container.css('position', container.css('position') === 'static' ? 'relative' : container.css('position'));
      var config = {
        placeholder: $this.data('placeholder') || 'Select value',
        dropdownParent: container,
        width: '100%'
      };

      if (isAjaxSearch) {
        config.ajax = {
          url: '/api/ajax-search',
          dataType: 'json',
          delay: 250,
          transport: function(params, success, failure) {
            if (!params.data || !params.data.search || params.data.search.length < 1) {
              success({ results: [], pagination: { more: false } });
              return;
            }
            var $request = $.ajax(params);
            $request.then(success).fail(failure);
            return $request;
          },
          data: function (params) {
            var data = {
              search: params.term || '',
              page: params.page || 1,
              model: $this.data('ajax-model'),
              display: $this.data('ajax-display'),
              key: $this.data('ajax-key'),
              limit: $this.data('ajax-limit') || 20
            };
            var dependsOn = $this.data('depends-on');
            var filterColumn = $this.data('filter-column');
            if (dependsOn && filterColumn) {
              var parentSelect = document.querySelector('select[name="' + dependsOn + '"], select[name="' + dependsOn + '[]"]');
              if (parentSelect) {
                var parentValue = parentSelect.multiple
                  ? Array.from(parentSelect.selectedOptions).map(opt => opt.value).filter(v => v !== '')
                  : parentSelect.value;
                if (parentValue && (Array.isArray(parentValue) ? parentValue.length > 0 : parentValue !== '')) {
                  data.filterColumn = filterColumn;
                  data.filterValue = parentValue;
                }
              }
            }
            return data;
          },
          processResults: function (data) {
            return data && data.results ? { results: data.results, pagination: { more: data.pagination.more } } : { results: [], pagination: { more: false } };
          },
          cache: false
        };
        config.minimumInputLength = 1;
        config.allowClear = true;
      }

      $this.select2(config);
    });
  });
</script>
@endsection

@section('content')
<div class="row g-4">



  <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">

        <div class="row g-3 align-items-start">

          <div class="col-md-3">
            <h4 class="card-title mb-2">Manage Cases</h4>
            <p class="mb-0">List edit and search cases here.</p>
          </div>

          <div class="col-md-9">
            <div class="demo-inline-spacing d-flex flex-wrap gap-2">
              <button type="button" class="btn rounded-pill btn-primary">All</button>
              <button type="button" class="btn rounded-pill btn-danger">Add Record</button>
              <button type="button" class="btn rounded-pill btn-secondary">Head Notes</button>
              <button type="button" class="btn rounded-pill btn-info">Judgment</button>
              <button type="button" class="btn rounded-pill btn-warning">Export cases</button>
              <button type="button" class="btn rounded-pill btn-dark">Get Case ID</button>

              <button type="button" class="btn btn-secondary waves-effect waves-light">
              <span class="tf-icons ri-notification-4-line ri-16px me-2"></span>Secondary
            </button>


            </div>
          </div>


        </div>

      </div>
    </div>
  </div>
  <!--/ Header Card -->





    <!-- Header Card -->
  <div class="col-12">
    <div class="card">
      <div class="card-body">


         <div class="row mb-3">

                <div class="col-md-6 mb-6">
                    <x-form.input name="subject" label="Subject" placeholder="Enter subject" class="form-group"/>
                </div>
                <div class="col">
                    <x-form.input name="fyear" label="From year/vol" placeholder="From year/vol" class="form-group" />
                </div>
                <div class="col">
                    <x-form.input name="tyear" label="To year/vol" placeholder="To year/vol" class="form-group" />
                </div>
                <div class="col-md-2 mb-2">


                                    <x-form.select
                                        name="mag"
                                        model="App\Models\CmsMagazine"
                                        {{-- :query="[['orderBy',['mag_name','asc']]]" --}}
                                        display="mag_name"
                                        key="mag_id"
                                        label="Select Mgazine"
                                        placeholder="Select Magzine"
                                        class="form-control select2"
                                        id="magzine"
                                        data-placeholder="Select Magzine"
                                        />


                </div>

                <div class="col">
                     <button type="button" class="btn rounded-pill btn-primary form-control">Search</button>
                </div>

            </div>





            <!-- Invoice List Table -->
<div class="card">
  <div class="card-datatable table-responsive">
    <table class="invoice-list-table table">
      <thead>
        <tr>
          <th></th>
          <th></th>
          <th>#ID</th>
          <th>#</th>
          <th>Client</th>
          <th>Total</th>
          <th class="text-truncate">Issued Date</th>
          <th>Balance</th>
          <th>Invoice Status</th>
          <th class="cell-fit">Actions</th>
        </tr>
      </thead>
    </table>
  </div>
</div>







<!-- Form Start -->

        <form action="#" method="POST" class="needs-validation" novalidate>
          @csrf
          <div class="row gy-4">
            <div class="col-12 d-flex flex-wrap justify-content-between align-items-center">
              <div>
                <h5 class="mb-1">Add Case Law Detail</h5>
                <p class="text-muted mb-0">Provide the basic case attributes before saving.</p>
              </div>
              <button type="submit" class="btn btn-primary">Add Record</button>
            </div>

            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">SR # <span class="text-danger">*</span></label>
              <input type="text" class="form-control" name="sr_no" placeholder="Enter SR" required>
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Date</label>
              <input type="date" class="form-control" name="case_date" value="2011-01-15">
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Department</label>
              <select class="form-select select2" name="department" data-placeholder="Select department">
                <option value="">Select</option>
                <option value="customs">Customs</option>
                <option value="tax">Tax</option>
                <option value="tribunal">Tribunal</option>
              </select>
            </div>
            <div class="col-md-3 col-sm-6">
              <label class="form-label fw-semibold">Status</label>
              <select class="form-select" name="status">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
                <option value="archived">Archived</option>
              </select>
            </div>

            <div class="col-md-2 col-sm-6">
              <label class="form-label fw-semibold">Year</label>
              <input type="number" class="form-control" name="year_primary" value="2011">
            </div>
            <div class="col-md-2 col-sm-6">
              <label class="form-label fw-semibold">Mag</label>
              <input type="text" class="form-control" name="mag_primary" value="SLD">
            </div>
            <div class="col-md-2 col-sm-6">
              <label class="form-label fw-semibold">Page</label>
              <input type="number" class="form-control" name="page_primary" placeholder="Enter page">
            </div>
            <div class="col-md-2 col-sm-6">
              <label class="form-label fw-semibold">Month</label>
              <select class="form-select" name="month_primary">
                <option value="">Select</option>
                <option>January</option>
                <option>February</option>
                <option>March</option>
                <option>April</option>
                <option>May</option>
                <option>June</option>
                <option>July</option>
                <option>August</option>
                <option>September</option>
                <option>October</option>
                <option>November</option>
                <option>December</option>
              </select>
            </div>
            <div class="col-md-2 col-sm-6">
              <label class="form-label fw-semibold">Vol.</label>
              <input type="text" class="form-control" name="volume" placeholder="Enter volume">
            </div>
            <div class="col-md-2 col-sm-6">
              <label class="form-label fw-semibold">Month (Vol)</label>
              <select class="form-select" name="month_volume">
                <option value="">Select</option>
                <option>January</option>
                <option>February</option>
                <option>March</option>
                <option>April</option>
                <option>May</option>
                <option>June</option>
                <option>July</option>
                <option>August</option>
                <option>September</option>
                <option>October</option>
                <option>November</option>
                <option>December</option>
              </select>
            </div>

            <div class="col-md-6">
              <label class="form-label fw-semibold">Court</label>
              <input type="text" class="form-control" name="court" placeholder="Appellate Tribunal Inland Revenue">
            </div>
            <div class="col-md-6">
              <label class="form-label fw-semibold">Case No.</label>
              <input type="text" class="form-control" name="case_no" placeholder="Enter case number">
            </div>

            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Petitioners</label>
              <textarea class="form-control" name="petitioners" rows="4"></textarea>
            </div>
            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Judges</label>
              <textarea class="form-control" name="judges" rows="4"></textarea>
            </div>
            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Lawyers</label>
              <textarea class="form-control" name="lawyers" rows="4"></textarea>
            </div>

            <div class="col-lg-8">
              <label class="form-label fw-semibold">Head Note</label>
              <textarea class="form-control" name="head_note" rows="6"></textarea>
            </div>
            <div class="col-lg-4">
              <div class="d-flex justify-content-between align-items-center">
                <label class="form-label fw-semibold mb-0">References</label>
                <button type="button" class="btn btn-sm btn-success">+ Add More</button>
              </div>
              <textarea class="form-control mt-2" name="references" rows="6"></textarea>
            </div>

            <div class="col-lg-4 col-md-6">
              <div class="d-flex justify-content-between align-items-center">
                <label class="form-label fw-semibold mb-0">Law/Statutes</label>
                <button type="button" class="btn btn-sm btn-success">+ Add More</button>
              </div>
              <select class="form-select select2 mt-2" name="laws" data-placeholder="Select law">
                <option value="">Select</option>
                <option value="income_tax">Income Tax Ordinance</option>
                <option value="sales_tax">Sales Tax Act</option>
                <option value="customs_act">Customs Act</option>
              </select>
            </div>
            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Sections</label>
              <input type="text" class="form-control" name="sections" placeholder="e.g. Sec 18, Sec 22">
            </div>
            <div class="col-lg-4 col-md-6">
              <label class="form-label fw-semibold">Attachment</label>
              <input class="form-control" type="file" name="attachment" accept=".pdf,.doc,.docx,.jpg,.png">
              <small class="text-muted d-block mt-2">Max allowed size is 5MB.</small>
            </div>

            <div class="col-12">
              <label class="form-label fw-semibold">Judgment</label>
              <div class="border rounded">
                <div class="border-bottom bg-light px-3 py-2 d-flex flex-wrap gap-2">
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-bold"></i></button>
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-italic"></i></button>
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-underline"></i></button>
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-list-unordered"></i></button>
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-list-ordered"></i></button>
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-link"></i></button>
                  <button type="button" class="btn btn-sm btn-outline-secondary"><i class="ri-picture-in-picture-2-line"></i></button>
                </div>
                <textarea class="form-control border-0 rounded-0" name="judgment" rows="8" placeholder="Write judgment details here..."></textarea>
              </div>
            </div>

            <div class="col-12">
              <label class="form-label fw-semibold">Principle Law</label>
              <input type="text" class="form-control" name="principle_law" placeholder="Enter relevant principle law">
            </div>

            <div class="col-12 d-flex justify-content-end gap-2">
              <button type="button" class="btn btn-outline-secondary">Cancel</button>
              <button type="submit" class="btn btn-primary">Add Record</button>
            </div>
          </div>
        </form>


<!-- Form End-->

<!-- Form End-->









      </div>
    </div>
  </div>
  <!--/ Header Card -->













</div>
@endsection
