@props([
    'name',
    'label' => null,
    'value' => null,
    'placeholder' => '',
    'helpText' => null,
    'floatingLabel' => true,
    'rows' => 3,
    'readonly' => false,
    'disabled' => false,
    'required' => false,
    'editor' => null, // 'ckeditor', 'quill', or null for plain textarea
    'editorHeight' => 300, // Height in pixels for editor
])

@php
    $textareaValue = $value ?? old($name, '');

    // Generate unique ID if not provided
    $textareaId = $attributes->get('id', $name);
    $helpId = $textareaId . 'Help';

    // Calculate height class from rows
    $heightClass = 'h-px-' . (100 * $rows / 3);

    // Add data attribute for editor initialization
    $editorAttr = $editor ? 'data-editor="' . $editor . '"' : '';
    $editorHeightAttr = $editor ? 'data-editor-height="' . $editorHeight . '"' : '';
@endphp

@if($floatingLabel && $label && !$editor)
    <div class="form-floating form-floating-outline">
        <textarea
            name="{{ $name }}"
            id="{{ $textareaId }}"
            class="form-control {{ $heightClass }}"
            placeholder="{{ $placeholder ?: $label }}"
            @if($helpText) aria-describedby="{{ $helpId }}" @endif
            @if($readonly) readonly @endif
            @if($disabled) disabled @endif
            @if($required) required @endif
            {{ $attributes->except(['label', 'helpText', 'floatingLabel', 'rows', 'value', 'name', 'placeholder', 'readonly', 'disabled', 'required', 'editor', 'editorHeight']) }}
        >{{ $textareaValue }}</textarea>
        <label for="{{ $textareaId }}">{{ $label }}</label>
        @if($helpText)
            <div id="{{ $helpId }}" class="form-text">{{ $helpText }}</div>
        @endif
    </div>
@else
    @if($label)
        <label for="{{ $textareaId }}" class="form-label">{{ $label }}</label>
    @endif
    <textarea
        name="{{ $name }}"
        id="{{ $textareaId }}"
        class="form-control {{ !$editor ? $heightClass : '' }}"
        placeholder="{{ $placeholder }}"
        @if($helpText) aria-describedby="{{ $helpId }}" @endif
        @if($readonly) readonly @endif
        @if($disabled) disabled @endif
        @if($required) required @endif
        {!! $editorAttr !!}
        {!! $editorHeightAttr !!}
        {{ $attributes->except(['label', 'helpText', 'floatingLabel', 'rows', 'value', 'name', 'placeholder', 'readonly', 'disabled', 'required', 'editor', 'editorHeight']) }}
    >{{ $textareaValue }}</textarea>
    @if($helpText)
        <div id="{{ $helpId }}" class="form-text">{{ $helpText }}</div>
    @endif
@endif

@error($name)
    <div class="invalid-feedback d-block">{{ $message }}</div>
@enderror

@if($editor === 'ckeditor')
    @once
    <script src="https://cdn.ckeditor.com/4.22.1/full/ckeditor.js"></script>
    @endonce

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            if (typeof CKEDITOR !== 'undefined') {
                const textarea = document.getElementById('{{ $textareaId }}');
                if (textarea && !CKEDITOR.instances['{{ $textareaId }}']) {
                    try {
                        CKEDITOR.replace('{{ $textareaId }}', {
                            height: {{ $editorHeight }},
                            versionCheck: false,
                            @if($readonly)
                            readOnly: true,
                            @endif
                            @if($disabled)
                            readOnly: true,
                            @endif
                        });
                        console.log('CKEditor initialized for {{ $textareaId }}');
                    } catch(e) {
                        console.error('CKEditor initialization error:', e);
                    }
                }
            } else {
                console.error('CKEditor not loaded');
            }
        });
    </script>
@elseif($editor === 'quill')
    <script>
        (function() {
            function initQuillEditor_{{ str_replace(['-', '_'], '', $textareaId) }}() {
                if (typeof Quill === 'undefined') {
                    setTimeout(initQuillEditor_{{ str_replace(['-', '_'], '', $textareaId) }}, 100);
                    return;
                }

                const textarea = document.getElementById('{{ $textareaId }}');
                if (textarea && !textarea.dataset.quillInitialized) {
                    textarea.dataset.quillInitialized = 'true';

                    // Hide the textarea
                    textarea.style.display = 'none';

                    // Create a container for Quill
                    const quillContainer = document.createElement('div');
                    quillContainer.id = '{{ $textareaId }}_quill';
                    quillContainer.style.minHeight = '{{ $editorHeight }}px';
                    textarea.parentNode.insertBefore(quillContainer, textarea);

                    // Initialize Quill
                    const quill = new Quill('#{{ $textareaId }}_quill', {
                        theme: 'snow',
                        placeholder: '{{ $placeholder }}',
                        modules: {
                            toolbar: [
                                [{ font: [] }, { size: [] }],
                                ['bold', 'italic', 'underline', 'strike'],
                                [{ color: [] }, { background: [] }],
                                [{ script: 'super' }, { script: 'sub' }],
                                [{ header: '1' }, { header: '2' }, 'blockquote', 'code-block'],
                                [{ list: 'ordered' }, { list: 'bullet' }, { indent: '-1' }, { indent: '+1' }],
                                ['link', 'image', 'video'],
                                ['clean']
                            ]
                        }
                    });

                    // Set initial content
                    const initialContent = textarea.value;
                    if (initialContent) {
                        quill.root.innerHTML = initialContent;
                    }

                    // Update textarea on content change
                    quill.on('text-change', function() {
                        textarea.value = quill.root.innerHTML;
                    });
                }
            }

            // Initialize when DOM is ready
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', initQuillEditor_{{ str_replace(['-', '_'], '', $textareaId) }});
            } else {
                initQuillEditor_{{ str_replace(['-', '_'], '', $textareaId) }}();
            }
        })();
    </script>
@endif
