@props([
    'name',
    'label' => null,
    'value' => '1',
    'checked' => false,
    'disabled' => false,
])

@php
    // Determine if switch should be checked
    $isChecked = $checked || old($name) == $value;

    // Generate unique ID if not provided
    $switchId = $attributes->get('id', $name);
@endphp

<div class="form-check form-switch">
    <input
        class="form-check-input"
        type="checkbox"
        name="{{ $name }}"
        id="{{ $switchId }}"
        value="{{ $value }}"
        @if($isChecked) checked @endif
        @if($disabled) disabled @endif
        {{ $attributes->except(['label', 'checked', 'disabled', 'name', 'value']) }}
    />
    @if($label)
        <label class="form-check-label" for="{{ $switchId }}">
            {{ $label }}
        </label>
    @endif
</div>

@error($name)
    <div class="invalid-feedback d-block">{{ $message }}</div>
@enderror
