@props([
    'name',
    'label' => null,
    'value',
    'checked' => false,
    'disabled' => false,
    'inline' => false,
    'color' => null, // 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark'
])

@php
    // Determine if radio should be checked
    $isChecked = $checked || old($name) == $value;

    // Generate unique ID if not provided
    $radioId = $attributes->get('id', $name . '_' . str_replace(' ', '_', $value));

    // Build wrapper classes
    $wrapperClasses = 'form-check';
    if ($inline) {
        $wrapperClasses .= ' form-check-inline';
    }
    if ($color) {
        $wrapperClasses .= ' form-check-' . $color;
    }
@endphp

<div class="{{ $wrapperClasses }}">
    <input
        class="form-check-input"
        type="radio"
        name="{{ $name }}"
        id="{{ $radioId }}"
        value="{{ $value }}"
        @if($isChecked) checked @endif
        @if($disabled) disabled @endif
        {{ $attributes->except(['label', 'checked', 'disabled', 'inline', 'color', 'name', 'value']) }}
    />
    @if($label)
        <label class="form-check-label" for="{{ $radioId }}">
            {{ $label }}
        </label>
    @endif
</div>

@error($name)
    <div class="invalid-feedback d-block">{{ $message }}</div>
@enderror
