@props([
    'name',
    'label' => null,
    'value' => null,
    'type' => 'text',
    'placeholder' => '',
    'helpText' => null,
    'floatingLabel' => true,
    'size' => 'default', // 'sm', 'default', 'lg'
    'readonly' => false,
    'disabled' => false,
    'required' => false,
])

@php
    $inputValue = $value ?? old($name, '');

    // Size classes
    $sizeClass = match($size) {
        'sm' => 'form-control-sm',
        'lg' => 'form-control-lg',
        default => ''
    };

    // Generate unique ID if not provided
    $inputId = $attributes->get('id', $name);
    $helpId = $inputId . 'Help';

    // Build input classes
    $inputClasses = 'form-control ' . $sizeClass;
    if ($readonly && !$disabled) {
        $inputClasses = 'form-control-plaintext px-0';
    }
@endphp

@if($floatingLabel && $label)
    <div class="form-floating form-floating-outline">
        <input
            type="{{ $type }}"
            name="{{ $name }}"
            id="{{ $inputId }}"
            value="{{ $inputValue }}"
            class="{{ $inputClasses }}"
            placeholder="{{ $placeholder ?: $label }}"
            @if($helpText) aria-describedby="{{ $helpId }}" @endif
            @if($readonly) readonly @endif
            @if($disabled) disabled @endif
            @if($required) required @endif
            {{ $attributes->except(['label', 'helpText', 'floatingLabel', 'size', 'value', 'name', 'type', 'placeholder', 'readonly', 'disabled', 'required']) }}
        />
        <label for="{{ $inputId }}" @if($readonly && !$disabled) class="px-0" @endif>{{ $label }}</label>
        @if($helpText)
            <div id="{{ $helpId }}" class="form-text">{{ $helpText }}</div>
        @endif
    </div>
@else
    @if($label)
        <label for="{{ $inputId }}" class="form-label">{{ $label }}</label>
    @endif
    <input
        type="{{ $type }}"
        name="{{ $name }}"
        id="{{ $inputId }}"
        value="{{ $inputValue }}"
        class="{{ $inputClasses }}"
        placeholder="{{ $placeholder }}"
        @if($helpText) aria-describedby="{{ $helpId }}" @endif
        @if($readonly) readonly @endif
        @if($disabled) disabled @endif
        @if($required) required @endif
        {{ $attributes->except(['label', 'helpText', 'floatingLabel', 'size', 'value', 'name', 'type', 'placeholder', 'readonly', 'disabled', 'required']) }}
    />
    @if($helpText)
        <div id="{{ $helpId }}" class="form-text">{{ $helpText }}</div>
    @endif
@endif

@error($name)
    <div class="invalid-feedback d-block">{{ $message }}</div>
@enderror
