@props([
    'name',
    'label' => null,
    'value' => '1',
    'checked' => false,
    'disabled' => false,
    'inline' => false,
    'color' => null, // 'primary', 'secondary', 'success', 'danger', 'warning', 'info', 'dark'
])

@php
    // Determine if checkbox should be checked
    $isChecked = $checked || old($name) == $value;

    // Generate unique ID if not provided
    $checkboxId = $attributes->get('id', $name . '_' . str_replace(' ', '_', $value));

    // Build wrapper classes
    $wrapperClasses = 'form-check';
    if ($inline) {
        $wrapperClasses .= ' form-check-inline';
    }
    if ($color) {
        $wrapperClasses .= ' form-check-' . $color;
    }
@endphp

<div class="{{ $wrapperClasses }}">
    <input
        class="form-check-input"
        type="checkbox"
        name="{{ $name }}"
        id="{{ $checkboxId }}"
        value="{{ $value }}"
        @if($isChecked) checked @endif
        @if($disabled) disabled @endif
        {{ $attributes->except(['label', 'checked', 'disabled', 'inline', 'color', 'name', 'value']) }}
    />
    @if($label)
        <label class="form-check-label" for="{{ $checkboxId }}">
            {{ $label }}
        </label>
    @endif
</div>

@error($name)
    <div class="invalid-feedback d-block">{{ $message }}</div>
@enderror
