!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):(e="undefined"!=typeof globalThis?globalThis:e||self).mapboxgl=t()}(this,(function(){"use strict";var e="undefined"!=typeof self?self:{},t="3.0.1";let i;const r={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==i){const e=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{i=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):e}catch(t){i=e}}return i},get API_TILEJSON_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/v[0-9]*\/.*\.json.*$)/i},get API_SPRITE_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*\/sprite.*\..*$)/i},get API_FONTS_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/fonts\/v[0-9]*\/)(.*\.pbf.*$)/i},get API_STYLE_REGEX(){return/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/styles\/v[0-9]*\/)(.*$)/i},get API_CDN_URL_REGEX(){return/^((https?:)?\/\/)?api\.mapbox\.c(n|om)(\/mapbox-gl-js\/)(.*$)/i},get EVENTS_URL(){if(!r.API_URL)return null;try{const e=new URL(r.API_URL);return"api.mapbox.cn"===e.hostname?"https://events.mapbox.cn/events/v2":"api.mapbox.com"===e.hostname?"https://events.mapbox.com/events/v2":null}catch(e){return null}},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,DEFAULT_STYLE:"mapbox://styles/mapbox/standard",MAX_PARALLEL_IMAGE_REQUESTS:16,DRACO_URL:"https://api.mapbox.com/mapbox-gl-js/draco_decoder_gltf_v1.5.6.wasm",GLYPHS_URL:"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},n={supported:!1,testSupport:function(e){!s&&a&&(l?c(e):o=e)}};let o,a,s=!1,l=!1;function c(e){const t=e.createTexture();e.bindTexture(e.TEXTURE_2D,t);try{if(e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,a),e.isContextLost())return;n.supported=!0}catch(e){}e.deleteTexture(t),s=!0}e.document&&(a=e.document.createElement("img"),a.onload=function(){o&&c(o),o=null,l=!0},a.onerror=function(){s=!0,o=null},a.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const u="01";function h(e){return e&&e.__esModule&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}var d=p;function p(e,t,i,r){this.cx=3*e,this.bx=3*(i-e)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*t,this.by=3*(r-t)-this.cy,this.ay=1-this.cy-this.by,this.p1x=e,this.p1y=t,this.p2x=i,this.p2y=r}p.prototype={sampleCurveX:function(e){return((this.ax*e+this.bx)*e+this.cx)*e},sampleCurveY:function(e){return((this.ay*e+this.by)*e+this.cy)*e},sampleCurveDerivativeX:function(e){return(3*this.ax*e+2*this.bx)*e+this.cx},solveCurveX:function(e,t){if(void 0===t&&(t=1e-6),e<0)return 0;if(e>1)return 1;for(var i=e,r=0;r<8;r++){var n=this.sampleCurveX(i)-e;if(Math.abs(n)<t)return i;var o=this.sampleCurveDerivativeX(i);if(Math.abs(o)<1e-6)break;i-=n/o}var a=0,s=1;for(i=e,r=0;r<20&&(n=this.sampleCurveX(i),!(Math.abs(n-e)<t));r++)e>n?a=i:s=i,i=.5*(s-a)+a;return i},solve:function(e,t){return this.sampleCurveY(this.solveCurveX(e,t))}};var f=h(d),m=_;function _(e,t){this.x=e,this.y=t}_.prototype={clone:function(){return new _(this.x,this.y)},add:function(e){return this.clone()._add(e)},sub:function(e){return this.clone()._sub(e)},multByPoint:function(e){return this.clone()._multByPoint(e)},divByPoint:function(e){return this.clone()._divByPoint(e)},mult:function(e){return this.clone()._mult(e)},div:function(e){return this.clone()._div(e)},rotate:function(e){return this.clone()._rotate(e)},rotateAround:function(e,t){return this.clone()._rotateAround(e,t)},matMult:function(e){return this.clone()._matMult(e)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(e){return this.x===e.x&&this.y===e.y},dist:function(e){return Math.sqrt(this.distSqr(e))},distSqr:function(e){var t=e.x-this.x,i=e.y-this.y;return t*t+i*i},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(e){return Math.atan2(this.y-e.y,this.x-e.x)},angleWith:function(e){return this.angleWithSep(e.x,e.y)},angleWithSep:function(e,t){return Math.atan2(this.x*t-this.y*e,this.x*e+this.y*t)},_matMult:function(e){var t=e[2]*this.x+e[3]*this.y;return this.x=e[0]*this.x+e[1]*this.y,this.y=t,this},_add:function(e){return this.x+=e.x,this.y+=e.y,this},_sub:function(e){return this.x-=e.x,this.y-=e.y,this},_mult:function(e){return this.x*=e,this.y*=e,this},_div:function(e){return this.x/=e,this.y/=e,this},_multByPoint:function(e){return this.x*=e.x,this.y*=e.y,this},_divByPoint:function(e){return this.x/=e.x,this.y/=e.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var e=this.y;return this.y=this.x,this.x=-e,this},_rotate:function(e){var t=Math.cos(e),i=Math.sin(e),r=i*this.x+t*this.y;return this.x=t*this.x-i*this.y,this.y=r,this},_rotateAround:function(e,t){var i=Math.cos(e),r=Math.sin(e),n=t.y+r*(this.x-t.x)+i*(this.y-t.y);return this.x=t.x+i*(this.x-t.x)-r*(this.y-t.y),this.y=n,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},_.convert=function(e){return e instanceof _?e:Array.isArray(e)?new _(e[0],e[1]):e};var g=h(m);function y(e,t){if(Array.isArray(e)){if(!Array.isArray(t)||e.length!==t.length)return!1;for(let i=0;i<e.length;i++)if(!y(e[i],t[i]))return!1;return!0}if("object"==typeof e&&null!==e&&null!==t){if("object"!=typeof t)return!1;if(Object.keys(e).length!==Object.keys(t).length)return!1;for(const i in e)if(!y(e[i],t[i]))return!1;return!0}return e===t}const x=Math.PI/180,v=180/Math.PI;function b(e){return e*x}function w(e){return e*v}const T=[[0,0],[1,0],[1,1],[0,1]];function E(e){if(e<=0)return 0;if(e>=1)return 1;const t=e*e,i=t*e;return 4*(e<.5?i:3*(e-t)+i-.75)}function M(e){let t=1/0,i=1/0,r=-1/0,n=-1/0;for(const o of e)t=Math.min(t,o.x),i=Math.min(i,o.y),r=Math.max(r,o.x),n=Math.max(n,o.y);return{min:new g(t,i),max:new g(r,n)}}function S(e,t,i=0,r=!0){const n=new g(i,i),o=e.sub(n),a=t.add(n),s=[o,new g(a.x,o.y),a,new g(o.x,a.y)];return r&&s.push(o.clone()),s}function A(e,t,i,r){const n=new f(e,t,i,r);return function(e){return n.solve(e)}}const C=A(.25,.1,.25,1);function I(e,t,i){return Math.min(i,Math.max(t,e))}function D(e,t,i){return(i=I((i-e)/(t-e),0,1))*i*(3-2*i)}function P(e,t,i){const r=i-t,n=((e-t)%r+r)%r+t;return n===t?i:n}function L(e,t,i){if(!e.length)return i(null,[]);let r=e.length;const n=new Array(e.length);let o=null;e.forEach(((e,a)=>{t(e,((e,t)=>{e&&(o=e),n[a]=t,0==--r&&i(o,n)}))}))}function z(e,...t){for(const i of t)for(const t in i)e[t]=i[t];return e}function R(e,t){const i={};for(let r=0;r<t.length;r++){const n=t[r];n in e&&(i[n]=e[n])}return i}let k=1;function B(){return k++}function O(){return function e(t){return t?(t^Math.random()*(16>>t/4)).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,e)}()}function F(e){return e<=1?1:Math.pow(2,Math.ceil(Math.log(e)/Math.LN2))}function U(e){return!!e&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(e)}function V(e,t){e.forEach((e=>{t[e]&&(t[e]=t[e].bind(t))}))}function N(e,t){return-1!==e.indexOf(t,e.length-t.length)}function j(e,t,i){const r={};for(const n in e)r[n]=t.call(i||this,e[n],n,e);return r}function G(e,t,i){const r={};for(const n in e)t.call(i||this,e[n],n,e)&&(r[n]=e[n]);return r}function q(e){return Array.isArray(e)?e.map(q):"object"==typeof e&&e?j(e,q):e}const Z={};function $(e){Z[e]||("undefined"!=typeof console&&console.warn(e),Z[e]=!0)}function H(e,t,i){return(i.y-e.y)*(t.x-e.x)>(t.y-e.y)*(i.x-e.x)}function W(e){let t=0;for(let i,r,n=0,o=e.length,a=o-1;n<o;a=n++)i=e[n],r=e[a],t+=(r.x-i.x)*(i.y+r.y);return t}function X([e,t,i]){const r=b(t+90),n=b(i);return{x:e*Math.cos(r)*Math.sin(n),y:e*Math.sin(r)*Math.sin(n),z:e*Math.cos(n),azimuthal:t,polar:i}}function Y(e,t,i){const r=Math.sqrt(e*e+t*t+i*i),n=r>0?Math.acos(i/r)*v:0;let o=0!==e||0!==t?Math.atan2(-t,-e)*v+90:0;return o<0&&(o+=360),[r,o,n]}function K(){return"undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function J(e){const t={};if(e.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,((e,i,r,n)=>{const o=r||n;return t[i]=!o||o.toLowerCase(),""})),t["max-age"]){const e=parseInt(t["max-age"],10);isNaN(e)?delete t["max-age"]:t["max-age"]=e}return t}let Q=null;function ee(){return!!e.document.fullscreenElement||!!e.document.webkitFullscreenElement}function te(t){try{const i=e[t];return i.setItem("_mapbox_test_",1),i.removeItem("_mapbox_test_"),!0}catch(e){return!1}}function ie(e,t){return[e[4*t],e[4*t+1],e[4*t+2],e[4*t+3]]}function re(e,t,i){e[4*t+0]=i[0],e[4*t+1]=i[1],e[4*t+2]=i[2],e[4*t+3]=i[3]}function ne(e,t){return[Math.pow(e[0],2.2)*t,Math.pow(e[1],2.2)*t,Math.pow(e[2],2.2)*t]}function oe(e){return[Math.pow(e[0],1/2.2),Math.pow(e[1],1/2.2),Math.pow(e[2],1/2.2)]}const ae="mapbox-tiles";let se=500,le=50;let ce,ue;function he(){try{return e.caches}catch(e){}}function de(){he()&&!ce&&(ce=e.caches.open(ae))}function pe(e){const t=e.indexOf("?");if(t<0)return e;const i=function(e){const t=e.indexOf("?");return t>0?e.slice(t+1).split("&"):[]}(e),r=i.filter((e=>{const t=e.split("=");return"language"===t[0]||"worldview"===t[0]}));return r.length?`${e.slice(0,t)}?${r.join("&")}`:e.slice(0,t)}let fe=1/0;function me(e){fe++,fe>le&&(e.getActor().send("enforceCacheSizeLimit",se),fe=0)}const _e={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image",Model:"Model"};"function"==typeof Object.freeze&&Object.freeze(_e);class AJAXError extends Error{constructor(e,t,i){401===t&&Ce(i)&&(e+=": you may have provided an invalid Mapbox access token. See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes"),super(e),this.status=t,this.url=i}toString(){return`${this.name}: ${this.message} (${this.status}): ${this.url}`}}const ge=K()?()=>self.worker&&self.worker.referrer:()=>("blob:"===e.location.protocol?e.parent:e).location.href;const ye=function(t,i){if(!(/^file:/.test(r=t.url)||/^file:/.test(ge())&&!/^\w+:/.test(r))){if(e.fetch&&e.Request&&e.AbortController&&e.Request.prototype.hasOwnProperty("signal"))return function(t,i){const r=new e.AbortController,n=new e.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:ge(),referrerPolicy:t.referrerPolicy,signal:r.signal});let o=!1,a=!1;const s=(l=n.url).indexOf("sku=")>0&&Ce(l);var l;"json"===t.type&&n.headers.set("Accept","application/json");const c=(r,o,l)=>{if(a)return;if(r&&"SecurityError"!==r.message&&$(r.toString()),o&&l)return u(o);const c=Date.now();e.fetch(n).then((e=>{if(e.ok){const t=s?e.clone():null;return u(e,t,c)}return i(new AJAXError(e.statusText,e.status,t.url))})).catch((e=>{"AbortError"!==e.name&&i(new Error(`${e.message} ${t.url}`))}))},u=(r,s,l)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then((t=>{a||(s&&l&&function(t,i,r){if(de(),!ce)return;const n={status:i.status,statusText:i.statusText,headers:new e.Headers};i.headers.forEach(((e,t)=>n.headers.set(t,e)));const o=J(i.headers.get("Cache-Control")||"");if(o["no-store"])return;o["max-age"]&&n.headers.set("Expires",new Date(r+1e3*o["max-age"]).toUTCString());const a=n.headers.get("Expires");a&&(new Date(a).getTime()-r<42e4||function(e,t){if(void 0===ue)try{new Response(new ReadableStream),ue=!0}catch(e){ue=!1}ue?t(e.body):e.blob().then(t)}(i,(i=>{const r=new e.Response(i,n);de(),ce&&ce.then((e=>e.put(pe(t.url),r))).catch((e=>$(e.message)))})))}(n,s,l),o=!0,i(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")))})).catch((e=>{a||i(new Error(e.message))}))};return s?function(e,t){if(de(),!ce)return t(null);const i=pe(e.url);ce.then((e=>{e.match(i).then((r=>{const n=function(e){if(!e)return!1;const t=new Date(e.headers.get("Expires")||0),i=J(e.headers.get("Cache-Control")||"");return t>Date.now()&&!i["no-cache"]}(r);e.delete(i),n&&e.put(i,r.clone()),t(null,r,n)})).catch(t)})).catch(t)}(n,c):c(null,null),{cancel:()=>{a=!0,o||r.abort()}}}(t,i);if(K()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,i,void 0,!0)}var r;return function(t,i){const r=new e.XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return"json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{i(new Error(r.statusText))},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let e=r.response;if("json"===t.type)try{e=JSON.parse(r.response)}catch(e){return i(e)}i(null,e,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"))}else i(new AJAXError(r.statusText,r.status,t.url))},r.send(t.body),{cancel:()=>r.abort()}}(t,i)},xe=function(e,t){return ye(z(e,{type:"json"}),t)},ve=function(e,t){return ye(z(e,{type:"arrayBuffer"}),t)};function be(t){const i=e.document.createElement("a");return i.href=t,i.protocol===e.document.location.protocol&&i.host===e.document.location.host}const we="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let Te,Ee;Te=[],Ee=0;const Me=function(t,i){if(n.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),Ee>=r.MAX_PARALLEL_IMAGE_REQUESTS){const e={requestParameters:t,callback:i,cancelled:!1,cancel(){this.cancelled=!0}};return Te.push(e),e}Ee++;let o=!1;const a=()=>{if(!o)for(o=!0,Ee--;Te.length&&Ee<r.MAX_PARALLEL_IMAGE_REQUESTS;){const e=Te.shift(),{requestParameters:t,callback:i,cancelled:r}=e;r||(e.cancel=Me(t,i).cancel)}},s=ve(t,((t,r,n,o)=>{a(),t?i(t):r&&(e.createImageBitmap?function(t,i){const r=new e.Blob([new Uint8Array(t)],{type:"image/png"});e.createImageBitmap(r).then((e=>{i(null,e)})).catch((e=>{i(new Error(`Could not load image because of ${e.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`))}))}(r,((e,t)=>i(e,t,n,o))):function(t,i){const r=new e.Image,n=e.URL;r.onload=()=>{i(null,r),n.revokeObjectURL(r.src),r.onload=null,e.requestAnimationFrame((()=>{r.src=we}))},r.onerror=()=>i(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const o=new e.Blob([new Uint8Array(t)],{type:"image/png"});r.src=t.byteLength?n.createObjectURL(o):we}(r,((e,t)=>i(e,t,n,o))))}));return{cancel:()=>{s.cancel(),a()}}},Se="NO_ACCESS_TOKEN";class RequestManager{constructor(e,t,i){this._transformRequestFn=e,this._customAccessToken=t,this._silenceAuthErrors=!!i,this._createSkuToken()}_createSkuToken(){const e=function(){let e="";for(let t=0;t<10;t++)e+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return{token:["1",u,e].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=e.token,this._skuTokenExpiresAt=e.tokenExpiresAt}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(e,t){return this._transformRequestFn&&this._transformRequestFn(e,t)||{url:e}}normalizeStyleURL(e,i){if(!Ae(e))return e;const r=ze(e);return r.params.push(`sdk=js-${t}`),r.path=`/styles/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||i)}normalizeGlyphsURL(e,t){if(!Ae(e))return e;const i=ze(e);return i.path=`/fonts/v1${i.path}`,this._makeAPIURL(i,this._customAccessToken||t)}normalizeModelURL(e,t){if(!Ae(e))return e;const i=ze(e);return i.path=`/models/v1${i.path}`,this._makeAPIURL(i,this._customAccessToken||t)}normalizeSourceURL(e,t,i,r){if(!Ae(e))return e;const n=ze(e);return n.path=`/v4/${n.authority}.json`,n.params.push("secure"),i&&n.params.push(`language=${i}`),r&&n.params.push(`worldview=${r}`),this._makeAPIURL(n,this._customAccessToken||t)}normalizeSpriteURL(e,t,i,r){const n=ze(e);return Ae(e)?(n.path=`/styles/v1${n.path}/sprite${t}${i}`,this._makeAPIURL(n,this._customAccessToken||r)):(n.path+=`${t}${i}`,Re(n))}normalizeTileURL(e,t,i){if(this._isSkuTokenExpired()&&this._createSkuToken(),e&&!Ae(e))return e;const o=ze(e);o.path=o.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${t||i&&"raster"!==o.authority&&512===i?"@2x":""}${n.supported?".webp":"$1"}`),"raster"===o.authority?o.path=`/${r.RASTER_URL_PREFIX}${o.path}`:(o.path=o.path.replace(/^.+\/v4\//,"/"),o.path=`/${r.TILE_URL_VERSION}${o.path}`);const a=this._customAccessToken||function(e){for(const t of e){const e=t.match(/^access_token=(.*)$/);if(e)return e[1]}return null}(o.params)||r.ACCESS_TOKEN;return r.REQUIRE_ACCESS_TOKEN&&a&&this._skuToken&&o.params.push(`sku=${this._skuToken}`),this._makeAPIURL(o,a)}canonicalizeTileURL(e,t){const i=ze(e);if(!i.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!i.path.match(/\.[\w]+$/))return e;let n="mapbox://";i.path.match(/^\/raster\/v1\//)?n+=`raster/${i.path.replace(`/${r.RASTER_URL_PREFIX}/`,"")}`:n+=`tiles/${i.path.replace(`/${r.TILE_URL_VERSION}/`,"")}`;let o=i.params;return t&&(o=o.filter((e=>!e.match(/^access_token=/)))),o.length&&(n+=`?${o.join("&")}`),n}canonicalizeTileset(e,t){const i=!!t&&Ae(t),r=[];for(const t of e.tiles||[])Ce(t)?r.push(this.canonicalizeTileURL(t,i)):r.push(t);return r}_makeAPIURL(e,t){const i="See https://docs.mapbox.com/api/overview/#access-tokens-and-token-scopes",n=ze(r.API_URL);if(e.protocol=n.protocol,e.authority=n.authority,"http"===e.protocol){const t=e.params.indexOf("secure");t>=0&&e.params.splice(t,1)}if("/"!==n.path&&(e.path=`${n.path}${e.path}`),!r.REQUIRE_ACCESS_TOKEN)return Re(e);if(t=t||r.ACCESS_TOKEN,!this._silenceAuthErrors){if(!t)throw new Error(`An API access token is required to use Mapbox GL. ${i}`);if("s"===t[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${i}`)}return e.params=e.params.filter((e=>-1===e.indexOf("access_token"))),e.params.push(`access_token=${t||""}`),Re(e)}}function Ae(e){return 0===e.indexOf("mapbox:")}function Ce(e){return r.API_URL_REGEX.test(e)}function Ie(e){return r.API_CDN_URL_REGEX.test(e)}function De(e){return r.API_STYLE_REGEX.test(e)&&!Pe(e)}function Pe(e){return r.API_SPRITE_REGEX.test(e)}const Le=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function ze(e){const t=e.match(Le);if(!t)throw new Error("Unable to parse URL object");return{protocol:t[1],authority:t[2],path:t[3]||"/",params:t[4]?t[4].split("&"):[]}}function Re(e){const t=e.params.length?`?${e.params.join("&")}`:"";return`${e.protocol}://${e.authority}${e.path}${t}`}const ke="mapbox.eventData";function Be(t){if(!t)return null;const i=t.split(".");if(!i||3!==i.length)return null;try{return JSON.parse(decodeURIComponent(e.atob(i[1]).split("").map((e=>"%"+("00"+e.charCodeAt(0).toString(16)).slice(-2))).join("")))}catch(e){return null}}class TelemetryEvent{constructor(e){this.type=e,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null}getStorageKey(t){const i=Be(r.ACCESS_TOKEN);let n="";return n=i&&i.u?e.btoa(encodeURIComponent(i.u).replace(/%([0-9A-F]{2})/g,((e,t)=>String.fromCharCode(Number("0x"+t))))):r.ACCESS_TOKEN||"",t?`${ke}.${t}:${n}`:`${ke}:${n}`}fetchEventData(){const t=te("localStorage"),i=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=e.localStorage.getItem(i);t&&(this.eventData=JSON.parse(t));const n=e.localStorage.getItem(r);n&&(this.anonId=n)}catch(e){$("Unable to read from LocalStorage")}}saveEventData(){const t=te("localStorage"),i=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{e.localStorage.setItem(r,this.anonId),Object.keys(this.eventData).length>=1&&e.localStorage.setItem(i,JSON.stringify(this.eventData))}catch(e){$("Unable to write to LocalStorage")}}processRequests(e){}postEvent(e,t,i,n){if(!r.EVENTS_URL)return;const o=ze(r.EVENTS_URL);o.params.push(`access_token=${n||r.ACCESS_TOKEN||""}`);const a={event:this.type,created:new Date(e).toISOString()},s=t?z(a,t):a,l={url:Re(o),headers:{"Content-Type":"text/plain"},body:JSON.stringify([s])};this.pendingRequest=function(e,t){return ye(z(e,{method:"POST"}),t)}(l,(e=>{this.pendingRequest=null,i(e),this.saveEventData(),this.processRequests(n)}))}queueRequest(e,t){this.queue.push(e),this.processRequests(t)}}const Oe=new class TurnstileEvent extends TelemetryEvent{constructor(e){super("appUserTurnstile"),this._customAccessToken=e}postTurnstileEvent(e,t){r.EVENTS_URL&&r.ACCESS_TOKEN&&Array.isArray(e)&&e.some((e=>Ae(e)||Ce(e)))&&this.queueRequest(Date.now(),t)}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const i=Be(r.ACCESS_TOKEN),n=i?i.u:r.ACCESS_TOKEN;let o=n!==this.eventData.tokenU;U(this.anonId)||(this.anonId=O(),o=!0);const a=this.queue.shift();if(this.eventData.lastSuccess){const e=new Date(this.eventData.lastSuccess),t=new Date(a),i=(a-this.eventData.lastSuccess)/864e5;o=o||i>=1||i<-1||e.getDate()!==t.getDate()}else o=!0;o?this.postEvent(a,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:u,"enabled.telemetry":!1,userId:this.anonId},(e=>{e||(this.eventData.lastSuccess=a,this.eventData.tokenU=n)}),e):this.processRequests()}},Fe=Oe.postTurnstileEvent.bind(Oe),Ue=new class MapLoadEvent extends TelemetryEvent{constructor(){super("map.load"),this.success={},this.skuToken=""}postMapLoadEvent(e,t,i,n){this.skuToken=t,this.errorCb=n,r.EVENTS_URL&&(i||r.ACCESS_TOKEN?this.queueRequest({id:e,timestamp:Date.now()},i):this.errorCb(new Error(Se)))}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:i,timestamp:r}=this.queue.shift();i&&this.success[i]||(this.anonId||this.fetchEventData(),U(this.anonId)||(this.anonId=O()),this.postEvent(r,{sdkIdentifier:"mapbox-gl-js",sdkVersion:t,skuId:u,skuToken:this.skuToken,userId:this.anonId},(e=>{e?this.errorCb(e):i&&(this.success[i]=!0)}),e))}},Ve=Ue.postMapLoadEvent.bind(Ue),Ne=new class PerformanceEvent extends TelemetryEvent{constructor(){super("gljs.performance")}postPerformanceEvent(e,t){r.EVENTS_URL&&(e||r.ACCESS_TOKEN)&&this.queueRequest({timestamp:Date.now(),performanceData:t},e)}processRequests(i){if(this.pendingRequest||0===this.queue.length)return;const{timestamp:r,performanceData:n}=this.queue.shift(),o=function(i){const r=e.performance.getEntriesByType("resource"),n=e.performance.getEntriesByType("mark"),o=function(e){const t={};if(e)for(const i in e)if("other"!==i)for(const r of e[i]){const e=`${i}ResolveRangeMin`,n=`${i}ResolveRangeMax`,o=`${i}RequestCount`,a=`${i}RequestCachedCount`;t[e]=Math.min(t[e]||1/0,r.startTime),t[n]=Math.max(t[n]||-1/0,r.responseEnd);const s=e=>{void 0===t[e]&&(t[e]=0),++t[e]};void 0!==r.transferSize&&0===r.transferSize&&s(a),s(o)}return t}(function(e,t){const i={};if(e)for(const r of e){const e=t(r);void 0===i[e]&&(i[e]=[]),i[e].push(r)}return i}(r,Xe)),a=e.devicePixelRatio,s=e.navigator.connection||e.navigator.mozConnection||e.navigator.webkitConnection,l={counters:[],metadata:[],attributes:[]},c=(e,t,i)=>{null!=i&&e.push({name:t,value:i.toString()})};for(const e in o)c(l.counters,e,o[e]);if(i.interactionRange[0]!==1/0&&i.interactionRange[1]!==-1/0&&(c(l.counters,"interactionRangeMin",i.interactionRange[0]),c(l.counters,"interactionRangeMax",i.interactionRange[1])),n)for(const e of Object.keys(He)){const t=He[e],i=n.find((e=>e.name===t));i&&c(l.counters,t,i.startTime)}return c(l.counters,"visibilityHidden",i.visibilityHidden),c(l.attributes,"style",function(e){if(e)for(const t of e){const e=t.name.split("?")[0];if(De(e)){const t=e.split("/").slice(-2);if(2===t.length)return`mapbox://styles/${t[0]}/${t[1]}`}}}(r)),c(l.attributes,"terrainEnabled",i.terrainEnabled?"true":"false"),c(l.attributes,"fogEnabled",i.fogEnabled?"true":"false"),c(l.attributes,"projection",i.projection),c(l.attributes,"zoom",i.zoom),c(l.metadata,"devicePixelRatio",a),c(l.metadata,"connectionEffectiveType",s?s.effectiveType:void 0),c(l.metadata,"navigatorUserAgent",e.navigator.userAgent),c(l.metadata,"screenWidth",e.screen.width),c(l.metadata,"screenHeight",e.screen.height),c(l.metadata,"windowWidth",e.innerWidth),c(l.metadata,"windowHeight",e.innerHeight),c(l.metadata,"mapWidth",i.width/a),c(l.metadata,"mapHeight",i.height/a),c(l.metadata,"webglRenderer",i.renderer),c(l.metadata,"webglVendor",i.vendor),c(l.metadata,"sdkVersion",t),c(l.metadata,"sdkIdentifier","mapbox-gl-js"),l}(n);for(const e of o.metadata);for(const e of o.counters);for(const e of o.attributes);this.postEvent(r,o,(()=>{}),i)}},je=Ne.postPerformanceEvent.bind(Ne),Ge=new class MapSessionAPI extends TelemetryEvent{constructor(){super("map.auth"),this.success={},this.skuToken=""}getSession(e,t,i,n){if(!r.API_URL||!r.SESSION_PATH)return;const o=ze(r.API_URL+r.SESSION_PATH);o.params.push(`sku=${t||""}`),o.params.push(`access_token=${n||r.ACCESS_TOKEN||""}`);const a={url:Re(o),headers:{"Content-Type":"text/plain"}};this.pendingRequest=function(e,t){return ye(z(e,{method:"GET"}),t)}(a,(e=>{this.pendingRequest=null,i(e),this.saveEventData(),this.processRequests(n)}))}getSessionAPI(e,t,i,n){this.skuToken=t,this.errorCb=n,r.SESSION_PATH&&r.API_URL&&(i||r.ACCESS_TOKEN?this.queueRequest({id:e,timestamp:Date.now()},i):this.errorCb(new Error(Se)))}processRequests(e){if(this.pendingRequest||0===this.queue.length)return;const{id:t,timestamp:i}=this.queue.shift();t&&this.success[t]||this.getSession(i,this.skuToken,(e=>{e?this.errorCb(e):t&&(this.success[t]=!0)}),e)}},qe=Ge.getSessionAPI.bind(Ge),Ze=new Set;function $e(e,t){t?Ze.add(e):Ze.delete(e)}const He={create:"create",load:"load",fullLoad:"fullLoad"},We={mark(t){e.performance.mark(t)},measure(t,i,r){e.performance.measure(t,i,r)}};function Xe(e){const t=e.name.split("?")[0];return Ie(t)&&t.includes("mapbox-gl.js")?"javascript":Ie(t)&&t.includes("mapbox-gl.css")?"css":function(e){return r.API_FONTS_REGEX.test(e)}(t)?"fontRange":Pe(t)?"sprite":De(t)?"style":function(e){return r.API_TILEJSON_REGEX.test(e)}(t)?"tilejson":"other"}var Ye=Ke;function Ke(e){return!function(e){return"undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return!1;var e,t,i=new Blob([""],{type:"text/javascript"}),r=URL.createObjectURL(i);try{t=new Worker(r),e=!0}catch(t){e=!1}return t&&t.terminate(),URL.revokeObjectURL(r),e}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return!1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===Je[t=e&&e.failIfMajorPerformanceCaveat]&&(Je[t]=function(e){var t,i=function(e){var t=document.createElement("canvas"),i=Object.create(Ke.webGLContextAttributes);return i.failIfMajorPerformanceCaveat=e,t.getContext("webgl",i)||t.getContext("experimental-webgl",i)}(e);if(!i)return!1;try{t=i.createShader(i.VERTEX_SHADER)}catch(e){return!1}return!(!t||i.isContextLost())&&(i.shaderSource(t,"void main() {}"),i.compileShader(t),!0===i.getShaderParameter(t,i.COMPILE_STATUS))}(t)),Je[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var t}(e)}var Je={};let Qe,et,tt,it;Ke.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const rt={now:()=>void 0!==tt?tt:e.performance.now(),setNow(e){tt=e},restoreNow(){tt=void 0},frame(t){const i=e.requestAnimationFrame(t);return{cancel:()=>e.cancelAnimationFrame(i)}},getImageData(t,i=0){const{width:r,height:n}=t;it||(it=e.document.createElement("canvas"));const o=it.getContext("2d",{willReadFrequently:!0});if(!o)throw new Error("failed to create canvas 2d context");return(r>it.width||n>it.height)&&(it.width=r,it.height=n),o.clearRect(-i,-i,r+2*i,n+2*i),o.drawImage(t,0,0,r,n),o.getImageData(-i,-i,r+2*i,n+2*i)},resolveURL:t=>(Qe||(Qe=e.document.createElement("a")),Qe.href=t,Qe.href),get devicePixelRatio(){return e.devicePixelRatio},get prefersReducedMotion(){return!!e.matchMedia&&(null==et&&(et=e.matchMedia("(prefers-reduced-motion: reduce)")),et.matches)}};function nt(t,i,r){const n=e.document.createElement(t);return void 0!==i&&(n.className=i),r&&r.appendChild(n),n}function ot(t,i,r){const n=e.document.createElementNS("http://www.w3.org/2000/svg",t);for(const e of Object.keys(i))n.setAttributeNS(null,e,i[e]);return r&&r.appendChild(n),n}const at=e.document&&e.document.documentElement.style,st=at&&void 0!==at.userSelect?"userSelect":"WebkitUserSelect";let lt;function ct(){at&&st&&(lt=at[st],at[st]="none")}function ut(){at&&st&&(at[st]=lt)}function ht(t){t.preventDefault(),t.stopPropagation(),e.removeEventListener("click",ht,!0)}function dt(){e.addEventListener("click",ht,!0),e.setTimeout((()=>{e.removeEventListener("click",ht,!0)}),0)}function pt(e,t){const i=e.getBoundingClientRect();return _t(e,i,t)}function ft(e,t){const i=e.getBoundingClientRect(),r=[];for(let n=0;n<t.length;n++)r.push(_t(e,i,t[n]));return r}function mt(t){return void 0!==e.InstallTrigger&&2===t.button&&t.ctrlKey&&e.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:t.button}function _t(e,t,i){const r=e.offsetWidth===t.width?1:e.offsetWidth/t.width;return new g((i.clientX-t.left)*r,(i.clientY-t.top)*r)}function gt(e,t,i){i[e]&&-1!==i[e].indexOf(t)||(i[e]=i[e]||[],i[e].push(t))}function yt(e,t,i){if(i&&i[e]){const r=i[e].indexOf(t);-1!==r&&i[e].splice(r,1)}}class Event{constructor(e,t={}){z(this,t),this.type=e}}class ErrorEvent extends Event{constructor(e,t={}){super("error",z({error:e},t))}}class Evented{on(e,t){return this._listeners=this._listeners||{},gt(e,t,this._listeners),this}off(e,t){return yt(e,t,this._listeners),yt(e,t,this._oneTimeListeners),this}once(e,t){return t?(this._oneTimeListeners=this._oneTimeListeners||{},gt(e,t,this._oneTimeListeners),this):new Promise((t=>this.once(e,t)))}fire(e,t){"string"==typeof e&&(e=new Event(e,t||{}));const i=e.type;if(this.listens(i)){e.target=this;const t=this._listeners&&this._listeners[i]?this._listeners[i].slice():[];for(const i of t)i.call(this,e);const r=this._oneTimeListeners&&this._oneTimeListeners[i]?this._oneTimeListeners[i].slice():[];for(const t of r)yt(i,t,this._oneTimeListeners),t.call(this,e);const n=this._eventedParent;n&&(z(e,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(e))}else e instanceof ErrorEvent&&console.error(e.error);return this}listens(e){return!!(this._listeners&&this._listeners[e]&&this._listeners[e].length>0||this._oneTimeListeners&&this._oneTimeListeners[e]&&this._oneTimeListeners[e].length>0||this._eventedParent&&this._eventedParent.listens(e))}setEventedParent(e,t){return this._eventedParent=e,this._eventedParentData=t,this}}var xt=JSON.parse('{"$version":8,"$root":{"version":{"required":true,"type":"enum","values":[8]},"fragment":{"type":"boolean"},"name":{"type":"string"},"metadata":{"type":"*"},"center":{"type":"array","value":"number"},"zoom":{"type":"number"},"bearing":{"type":"number","default":0,"period":360},"pitch":{"type":"number","default":0},"light":{"type":"light"},"lights":{"required":false,"type":"array","value":"light-3d"},"terrain":{"type":"terrain"},"fog":{"type":"fog"},"camera":{"type":"camera"},"imports":{"type":"array","value":"import"},"schema":{"type":"schema"},"sources":{"required":true,"type":"sources"},"sprite":{"type":"string"},"glyphs":{"type":"string","default":"mapbox://fonts/mapbox/{fontstack}/{range}.pbf"},"transition":{"type":"transition"},"projection":{"type":"projection"},"layers":{"required":true,"type":"array","value":"layer"},"models":{"type":"models"}},"model":{"type":"string","required":true},"import":{"id":{"type":"string","required":true},"url":{"type":"string","required":true},"config":{"type":"config"},"data":{"type":"$root"}},"config":{"*":{"type":"*"}},"schema":{"*":{"type":"option"}},"option":{"default":{"type":"*","required":true},"type":{"type":"enum","values":{"string":1,"number":1,"boolean":1,"color":1}},"array":{"type":"boolean"},"minValue":{"type":"number"},"maxValue":{"type":"number"},"stepValue":{"type":"number"},"values":{"type":"array","value":"*"},"metadata":{"type":"*"}},"models":{"*":{"type":"model"}},"light-3d":{"id":{"type":"string","required":true},"properties":{"type":"properties"},"type":{"type":"enum","values":{"ambient":{},"directional":{},"flat":{}}}},"properties":["properties_light_directional","properties_light_ambient","properties_light_flat"],"properties_light_directional":{"direction":{"type":"array","default":[210,30],"minimum":[0,0],"maximum":[360,90],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"cast-shadows":{"type":"boolean","default":false,"expression":{},"property-type":"data-constant"},"shadow-intensity":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_ambient":{"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"properties_light_flat":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"sources":{"*":{"type":"source"}},"source":["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image","source_model"],"source_vector":{"type":{"required":true,"type":"enum","values":{"vector":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"attribution":{"type":"string"},"promoteId":{"type":"promoteId"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster":{"type":{"required":true,"type":"enum","values":{"raster":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"scheme":{"type":"enum","values":{"xyz":1,"tms":1},"default":"xyz"},"attribution":{"type":"string"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_raster_dem":{"type":{"required":true,"type":"enum","values":{"raster-dem":1}},"url":{"type":"string"},"tiles":{"type":"array","value":"string"},"bounds":{"type":"array","value":"number","length":4,"default":[-180,-85.051129,180,85.051129]},"minzoom":{"type":"number","default":0},"maxzoom":{"type":"number","default":22},"tileSize":{"type":"number","default":512},"attribution":{"type":"string"},"encoding":{"type":"enum","values":{"terrarium":1,"mapbox":1},"default":"mapbox"},"volatile":{"type":"boolean","default":false},"*":{"type":"*"}},"source_geojson":{"type":{"required":true,"type":"enum","values":{"geojson":1}},"data":{"type":"*"},"maxzoom":{"type":"number","default":18},"attribution":{"type":"string"},"buffer":{"type":"number","default":128,"maximum":512,"minimum":0},"filter":{"type":"*"},"tolerance":{"type":"number","default":0.375},"cluster":{"type":"boolean","default":false},"clusterRadius":{"type":"number","default":50,"minimum":0},"clusterMaxZoom":{"type":"number"},"clusterMinPoints":{"type":"number"},"clusterProperties":{"type":"*"},"lineMetrics":{"type":"boolean","default":false},"generateId":{"type":"boolean","default":false},"promoteId":{"type":"promoteId"}},"source_video":{"type":{"required":true,"type":"enum","values":{"video":1}},"urls":{"required":true,"type":"array","value":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_image":{"type":{"required":true,"type":"enum","values":{"image":1}},"url":{"required":false,"type":"string"},"coordinates":{"required":true,"type":"array","length":4,"value":{"type":"array","length":2,"value":"number"}}},"source_model":{"type":{"required":true,"type":"enum","values":{"model":1,"batched-model":1}},"maxzoom":{"type":"number","default":18},"minzoom":{"type":"number","default":0},"tiles":{"type":"array","value":"string"}},"layer":{"id":{"type":"string","required":true},"type":{"type":"enum","values":{"fill":{},"line":{},"symbol":{},"circle":{},"heatmap":{},"fill-extrusion":{},"raster":{},"hillshade":{},"model":{},"background":{},"sky":{},"slot":{}},"required":true},"metadata":{"type":"*"},"source":{"type":"string"},"source-layer":{"type":"string"},"slot":{"type":"string"},"minzoom":{"type":"number","minimum":0,"maximum":24},"maxzoom":{"type":"number","minimum":0,"maximum":24},"filter":{"type":"filter"},"layout":{"type":"layout"},"paint":{"type":"paint"}},"layout":["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky","layout_model"],"layout_background":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_sky":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_model":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"model-id":{"type":"string","default":"","property-type":"data-driven","expression":{"parameters":["zoom","feature"]}}},"layout_fill":{"fill-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_circle":{"circle-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_heatmap":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_fill-extrusion":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"},"fill-extrusion-edge-radius":{"type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"constant"}},"layout_line":{"line-cap":{"type":"enum","values":{"butt":1,"round":1,"square":1},"default":"butt","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-join":{"type":"enum","values":{"bevel":1,"round":1,"miter":1},"default":"miter","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{"type":"number","default":2,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-round-limit":{"type":"number","default":1.05,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_symbol":{"symbol-placement":{"type":"enum","values":{"point":1,"line":1,"line-center":1},"default":"point","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-spacing":{"type":"number","default":250,"minimum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{"type":"number","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{"type":"enum","values":{"auto":1,"viewport-y":1,"source":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"symbol-z-elevate":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-size":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{"type":"enum","values":{"none":1,"width":1,"height":1,"both":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit-padding":{"type":"array","value":"number","length":4,"default":[0,0,0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-image":{"type":"resolvedImage","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{"type":"enum","values":{"map":1,"viewport":1,"auto":1},"default":"auto","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-field":{"type":"formatted","default":"","tokens":true,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-font":{"type":"array","value":"string","default":["Open Sans Regular","Arial Unicode MS Regular"],"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-size":{"type":"number","default":16,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{"type":"number","default":10,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{"type":"number","default":1.2,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-letter-spacing":{"type":"number","default":0,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-justify":{"type":"enum","values":{"auto":1,"left":1,"center":1,"right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{"type":"number","default":0,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["zoom","feature"]}},"text-variable-anchor":{"type":"array","value":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-anchor":{"type":"enum","values":{"center":1,"left":1,"right":1,"top":1,"bottom":1,"top-left":1,"top-right":1,"bottom-left":1,"bottom-right":1},"default":"center","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{"type":"number","default":45,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-writing-mode":{"type":"array","value":"enum","values":{"horizontal":1,"vertical":1},"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-rotate":{"type":"number","default":0,"period":360,"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-padding":{"type":"number","default":2,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-keep-upright":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-transform":{"type":"enum","values":{"none":1,"uppercase":1,"lowercase":1},"default":"none","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-offset":{"type":"array","value":"number","length":2,"default":[0,0],"expression":{"interpolated":true,"parameters":["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"text-optional":{"type":"boolean","default":false,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_raster":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"layout_hillshade":{"visibility":{"type":"enum","values":{"visible":1,"none":1},"default":"visible","expression":{},"property-type":"constant"}},"filter":{"type":"array","value":"*"},"filter_symbol":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature","pitch","distance-from-center"]}},"filter_fill":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_line":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_circle":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_fill-extrusion":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_heatmap":{"type":"boolean","default":false,"property-type":"data-driven","expression":{"parameters":["zoom","feature"]}},"filter_operator":{"type":"enum","values":{"==":1,"!=":1,">":1,">=":1,"<":1,"<=":1,"in":1,"!in":1,"all":1,"any":1,"none":1,"has":1,"!has":1}},"geometry_type":{"type":"enum","values":{"Point":1,"LineString":1,"Polygon":1}},"function":{"expression":{"type":"expression"},"stops":{"type":"array","value":"function_stop"},"base":{"type":"number","default":1,"minimum":0},"property":{"type":"string","default":"$zoom"},"type":{"type":"enum","values":{"identity":1,"exponential":1,"interval":1,"categorical":1},"default":"exponential"},"colorSpace":{"type":"enum","values":{"rgb":1,"lab":1,"hcl":1},"default":"rgb"},"default":{"type":"*","required":false}},"function_stop":{"type":"array","minimum":0,"maximum":24,"value":["number","color"],"length":2},"expression":{"type":"array","value":"*","minimum":1},"fog":{"range":{"type":"array","default":[0.5,10],"minimum":-20,"maximum":20,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"high-color":{"type":"color","property-type":"data-constant","default":"#245cdf","expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"space-color":{"type":"color","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,"#010b19",7,"#367ab9"],"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"horizon-blend":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],4,0.2,7,0.1],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"star-intensity":{"type":"number","property-type":"data-constant","default":["interpolate",["linear"],["zoom"],5,0.35,6,0],"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true},"transition":true},"vertical-range":{"type":"array","default":[0,0],"minimum":0,"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"],"relaxZoomRestriction":true}}},"camera":{"camera-projection":{"type":"enum","values":{"perspective":1,"orthographic":1},"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"default":"perspective","property-type":"data-constant"}},"light":{"anchor":{"type":"enum","default":"viewport","values":{"map":1,"viewport":1},"property-type":"data-constant","expression":{"parameters":["zoom"]}},"position":{"type":"array","default":[1.15,210,30],"length":3,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"color":{"type":"color","property-type":"data-constant","default":"#ffffff","expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"intensity":{"type":"number","property-type":"data-constant","default":0.5,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"projection":{"name":{"type":"enum","values":{"albers":1,"equalEarth":1,"equirectangular":1,"lambertConformalConic":1,"mercator":1,"naturalEarth":1,"winkelTripel":1,"globe":1},"default":"mercator","required":true},"center":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-180,-90],"maximum":[180,90]},"parallels":{"type":"array","length":2,"value":"number","property-type":"data-constant","minimum":[-90,-90],"maximum":[90,90]}},"terrain":{"source":{"type":"string","required":true},"exaggeration":{"type":"number","property-type":"data-constant","default":1,"minimum":0,"maximum":1000,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true}},"paint":["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky","paint_model"],"paint_fill":{"fill-antialias":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-outline-color":{"type":"color","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"fill-extrusion-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"fill-extrusion-height":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{"type":"boolean","default":true,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"fill-extrusion-ambient-occlusion-intensity":{"property-type":"data-constant","type":"number","private":true,"default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-radius":{"property-type":"data-constant","type":"number","private":true,"default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-wall-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-radius":{"property-type":"data-constant","type":"number","default":3,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"transition":true},"fill-extrusion-ambient-occlusion-ground-attenuation":{"property-type":"data-constant","type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-flood-light-color":{"property-type":"data-constant","type":"color","default":"#ffffff","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-intensity":{"property-type":"data-constant","type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]}},"fill-extrusion-flood-light-wall-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-radius":{"property-type":"data-driven","type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["feature","feature-state"]}},"fill-extrusion-flood-light-ground-attenuation":{"property-type":"data-constant","type":"number","default":0.69,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-vertical-scale":{"property-type":"data-constant","type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"fill-extrusion-rounded-roof":{"property-type":"data-constant","type":"boolean","default":true,"expression":{"parameters":["zoom"]}},"fill-extrusion-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"}},"paint_line":{"line-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"line-width":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-gap-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-offset":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"line-dasharray":{"type":"array","value":"number","minimum":0,"expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom","feature"]},"property-type":"data-driven"},"line-gradient":{"type":"color","expression":{"interpolated":true,"parameters":["line-progress"]},"property-type":"color-ramp"},"line-trim-offset":{"type":"array","value":"number","length":2,"default":[0,0],"minimum":[0,0],"maximum":[1,1],"property-type":"constant"},"line-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"line-border-width":{"type":"number","private":true,"default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-border-color":{"type":"color","private":true,"default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state"]},"property-type":"data-driven"}},"paint_circle":{"circle-radius":{"type":"number","default":5,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-blur":{"type":"number","default":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-stroke-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"circle-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_heatmap":{"heatmap-radius":{"type":"number","default":30,"minimum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-weight":{"type":"number","default":1,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"heatmap-intensity":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"heatmap-color":{"type":"color","default":["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",0.1,"royalblue",0.3,"cyan",0.5,"lime",0.7,"yellow",1,"red"],"expression":{"interpolated":true,"parameters":["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_symbol":{"icon-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"text-emissive-strength":{"type":"number","default":1,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-driven"},"icon-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"icon-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"icon-image-cross-fade":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"transition":true},"text-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-color":{"type":"color","default":"#000000","transition":true,"overridable":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-color":{"type":"color","default":"rgba(0, 0, 0, 0)","transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-width":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-halo-blur":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","feature","feature-state","measure-light"]},"property-type":"data-driven"},"text-translate":{"type":"array","value":"number","length":2,"default":[0,0],"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"map","expression":{"parameters":["zoom"]},"property-type":"data-constant"}},"paint_raster":{"raster-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-color":{"type":"color","expression":{"interpolated":true,"parameters":["raster-value"]},"property-type":"color-ramp"},"raster-color-mix":{"type":"array","default":[0.2126,0.7152,0.0722,0],"length":4,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-color-range":{"type":"array","default":[0,1],"length":2,"value":"number","property-type":"data-constant","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]}},"raster-hue-rotate":{"type":"number","default":0,"period":360,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{"type":"number","default":0,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-saturation":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-contrast":{"type":"number","default":0,"minimum":-1,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"raster-resampling":{"type":"enum","values":{"linear":1,"nearest":1},"default":"linear","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{"type":"number","default":300,"minimum":0,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_hillshade":{"hillshade-illumination-direction":{"type":"number","default":335,"minimum":0,"maximum":359,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{"type":"enum","values":{"map":1,"viewport":1},"default":"viewport","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{"type":"number","default":0.5,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-highlight-color":{"type":"color","default":"#FFFFFF","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-accent-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"},"hillshade-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_background":{"background-color":{"type":"color","default":"#000000","transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-pattern":{"type":"resolvedImage","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"background-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"background-emissive-strength":{"type":"number","default":0,"minimum":0,"transition":true,"expression":{"interpolated":true,"parameters":["zoom","measure-light"]},"property-type":"data-constant"}},"paint_sky":{"sky-type":{"type":"enum","values":{"gradient":1,"atmosphere":1},"default":"atmosphere","expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{"type":"array","value":"number","length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{"type":"number","default":10,"minimum":0,"maximum":100,"property-type":"data-constant"},"sky-gradient-center":{"type":"array","value":"number","default":[0,0],"length":2,"minimum":[0,0],"maximum":[360,180],"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{"type":"number","default":90,"minimum":0,"maximum":180,"expression":{"parameters":["zoom"]},"property-type":"data-constant"},"sky-gradient":{"type":"color","default":["interpolate",["linear"],["sky-radial-progress"],0.8,"#87ceeb",1,"white"],"expression":{"interpolated":true,"parameters":["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-atmosphere-color":{"type":"color","default":"white","property-type":"data-constant"},"sky-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"}},"paint_model":{"model-opacity":{"type":"number","default":1,"minimum":0,"maximum":1,"transition":true,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant"},"model-rotation":{"type":"array","value":"number","length":3,"default":[0,0,0],"period":360,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-scale":{"type":"array","value":"number","length":3,"default":[1,1,1],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-translation":{"type":"array","value":"number","length":3,"default":[0,0,0],"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","zoom"]},"transition":true},"model-color":{"type":"color","default":"#ffffff","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light","zoom"]},"transition":true},"model-color-mix-intensity":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-type":{"type":"enum","values":{"common-3d":1,"location-indicator":1},"default":"common-3d","property-type":"data-constant"},"model-cast-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-receive-shadows":{"type":"boolean","default":true,"expression":{},"property-type":"data-constant"},"model-ambient-occlusion-intensity":{"type":"number","default":1,"minimum":0,"maximum":1,"expression":{"interpolated":true,"parameters":["zoom"]},"property-type":"data-constant","transition":true},"model-emissive-strength":{"type":"number","property-type":"data-driven","default":0,"minimum":0,"maximum":5,"expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-roughness":{"type":"number","default":1,"minimum":0,"maximum":1,"property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state"]},"transition":true},"model-height-based-emissive-strength-multiplier":{"type":"array","default":[1,1,1,1,0],"length":5,"value":"number","property-type":"data-driven","expression":{"interpolated":true,"parameters":["feature","feature-state","measure-light"]},"transition":true},"model-cutoff-fade-range":{"type":"number","default":0,"minimum":0,"maximum":1,"expression":{},"property-type":"data-constant"}},"transition":{"duration":{"type":"number","default":300,"minimum":0},"delay":{"type":"number","default":0,"minimum":0}},"property-type":{"data-driven":{"type":"property-type"},"color-ramp":{"type":"property-type"},"data-constant":{"type":"property-type"},"constant":{"type":"property-type"}},"promoteId":{"*":{"type":"string"}}}');class ValidationError{constructor(e,t,i,r){this.message=(e?`${e}: `:"")+i,r&&(this.identifier=r),null!=t&&t.__line__&&(this.line=t.__line__)}}class ValidationWarning extends ValidationError{}function vt(e,...t){for(const i of t)for(const t in i)e[t]=i[t];return e}function bt(e){return e instanceof Number||e instanceof String||e instanceof Boolean?e.valueOf():e}function wt(e){if(Array.isArray(e))return e.map(wt);if(e instanceof Object&&!(e instanceof Number||e instanceof String||e instanceof Boolean)){const t={};for(const i in e)t[i]=wt(e[i]);return t}return bt(e)}class ParsingError extends Error{constructor(e,t){super(t),this.message=t,this.key=e}}var Tt=ParsingError;class Scope{constructor(e,t=[]){this.parent=e,this.bindings={};for(const[e,i]of t)this.bindings[e]=i}concat(e){return new Scope(this,e)}get(e){if(this.bindings[e])return this.bindings[e];if(this.parent)return this.parent.get(e);throw new Error(`${e} not found in scope.`)}has(e){return!!this.bindings[e]||!!this.parent&&this.parent.has(e)}}var Et=Scope;const Mt={kind:"null"},St={kind:"number"},Ct={kind:"string"},It={kind:"boolean"},Dt={kind:"color"},Pt={kind:"object"},Lt={kind:"value"},zt={kind:"collator"},Rt={kind:"formatted"},kt={kind:"resolvedImage"};function Bt(e,t){return{kind:"array",itemType:e,N:t}}function Ot(e){if("array"===e.kind){const t=Ot(e.itemType);return"number"==typeof e.N?`array<${t}, ${e.N}>`:"value"===e.itemType.kind?"array":`array<${t}>`}return e.kind}const Ft=[Mt,St,Ct,It,Dt,Rt,Pt,Bt(Lt),kt];function Ut(e,t){if("error"===t.kind)return null;if("array"===e.kind){if("array"===t.kind&&(0===t.N&&"value"===t.itemType.kind||!Ut(e.itemType,t.itemType))&&("number"!=typeof e.N||e.N===t.N))return null}else{if(e.kind===t.kind)return null;if("value"===e.kind)for(const e of Ft)if(!Ut(e,t))return null}return`Expected ${Ot(e)} but found ${Ot(t)} instead.`}function Vt(e,t){return t.some((t=>t.kind===e.kind))}function Nt(e,t){return t.some((t=>"null"===t?null===e:"array"===t?Array.isArray(e):"object"===t?e&&!Array.isArray(e)&&"object"==typeof e:t===typeof e))}var jt,Gt={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function qt(e){return(e=Math.round(e))<0?0:e>255?255:e}function Zt(e){return qt("%"===e[e.length-1]?parseFloat(e)/100*255:parseInt(e))}function $t(e){return(t="%"===e[e.length-1]?parseFloat(e)/100:parseFloat(e))<0?0:t>1?1:t;var t}function Ht(e,t,i){return i<0?i+=1:i>1&&(i-=1),6*i<1?e+(t-e)*i*6:2*i<1?t:3*i<2?e+(t-e)*(2/3-i)*6:e}try{jt={}.parseCSSColor=function(e){var t,i=e.replace(/ /g,"").toLowerCase();if(i in Gt)return Gt[i].slice();if("#"===i[0])return 4===i.length?(t=parseInt(i.substr(1),16))>=0&&t<=4095?[(3840&t)>>4|(3840&t)>>8,240&t|(240&t)>>4,15&t|(15&t)<<4,1]:null:7===i.length&&(t=parseInt(i.substr(1),16))>=0&&t<=16777215?[(16711680&t)>>16,(65280&t)>>8,255&t,1]:null;var r=i.indexOf("("),n=i.indexOf(")");if(-1!==r&&n+1===i.length){var o=i.substr(0,r),a=i.substr(r+1,n-(r+1)).split(","),s=1;switch(o){case"rgba":if(4!==a.length)return null;s=$t(a.pop());case"rgb":return 3!==a.length?null:[Zt(a[0]),Zt(a[1]),Zt(a[2]),s];case"hsla":if(4!==a.length)return null;s=$t(a.pop());case"hsl":if(3!==a.length)return null;var l=(parseFloat(a[0])%360+360)%360/360,c=$t(a[1]),u=$t(a[2]),h=u<=.5?u*(c+1):u+c-u*c,d=2*u-h;return[qt(255*Ht(d,h,l+1/3)),qt(255*Ht(d,h,l)),qt(255*Ht(d,h,l-1/3)),s];default:return null}}return null}}catch(e){}class Color{constructor(e,t,i,r=1){this.r=e,this.g=t,this.b=i,this.a=r}static parse(e){if(!e)return;if(e instanceof Color)return e;if("string"!=typeof e)return;const t=jt(e);return t?new Color(t[0]/255*t[3],t[1]/255*t[3],t[2]/255*t[3],t[3]):void 0}toString(){const[e,t,i,r]=this.toArray();return`rgba(${Math.round(e)},${Math.round(t)},${Math.round(i)},${r})`}toArray(){const{r:e,g:t,b:i,a:r}=this;return 0===r?[0,0,0,0]:[255*e/r,255*t/r,255*i/r,r]}toArray01(){const{r:e,g:t,b:i,a:r}=this;return 0===r?[0,0,0,0]:[e/r,t/r,i/r,r]}toArray01Scaled(e){const{r:t,g:i,b:r,a:n}=this;return 0===n?[0,0,0]:[t/n*e,i/n*e,r/n*e]}toArray01PremultipliedAlpha(){const{r:e,g:t,b:i,a:r}=this;return[e,t,i,r]}toArray01Linear(){const{r:e,g:t,b:i,a:r}=this;return 0===r?[0,0,0,0]:[Math.pow(e/r,2.2),Math.pow(t/r,2.2),Math.pow(i/r,2.2),r]}}Color.black=new Color(0,0,0,1),Color.white=new Color(1,1,1,1),Color.transparent=new Color(0,0,0,0),Color.red=new Color(1,0,0,1),Color.blue=new Color(0,0,1,1);var Wt=Color;class Collator{constructor(e,t,i){this.sensitivity=e?t?"variant":"case":t?"accent":"base",this.locale=i,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"})}compare(e,t){return this.collator.compare(e,t)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class FormattedSection{constructor(e,t,i,r,n){this.text=e.normalize?e.normalize():e,this.image=t,this.scale=i,this.fontStack=r,this.textColor=n}}class Formatted{constructor(e){this.sections=e}static fromString(e){return new Formatted([new FormattedSection(e,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some((e=>0!==e.text.length||e.image&&0!==e.image.namePrimary.length))}static factory(e){return e instanceof Formatted?e:Formatted.fromString(e)}toString(){return 0===this.sections.length?"":this.sections.map((e=>e.text)).join("")}serialize(){const e=["format"];for(const t of this.sections){if(t.image){e.push(["image",t.image.namePrimary]);continue}e.push(t.text);const i={};t.fontStack&&(i["text-font"]=["literal",t.fontStack.split(",")]),t.scale&&(i["font-scale"]=t.scale),t.textColor&&(i["text-color"]=["rgba"].concat(t.textColor.toArray())),e.push(i)}return e}}class ResolvedImage{constructor(e){this.namePrimary=e.namePrimary,e.nameSecondary&&(this.nameSecondary=e.nameSecondary),this.available=e.available}toString(){return this.nameSecondary?`[${this.namePrimary},${this.nameSecondary}]`:this.namePrimary}static fromString(e,t){return e?new ResolvedImage({namePrimary:e,nameSecondary:t,available:!1}):null}serialize(){return this.nameSecondary?["image",this.namePrimary,this.nameSecondary]:["image",this.namePrimary]}}function Xt(e,t,i,r){return"number"==typeof e&&e>=0&&e<=255&&"number"==typeof t&&t>=0&&t<=255&&"number"==typeof i&&i>=0&&i<=255?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid rgba value [${[e,t,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof r?[e,t,i,r]:[e,t,i]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function Yt(e){if(null===e)return!0;if("string"==typeof e)return!0;if("boolean"==typeof e)return!0;if("number"==typeof e)return!0;if(e instanceof Wt)return!0;if(e instanceof Collator)return!0;if(e instanceof Formatted)return!0;if(e instanceof ResolvedImage)return!0;if(Array.isArray(e)){for(const t of e)if(!Yt(t))return!1;return!0}if("object"==typeof e){for(const t in e)if(!Yt(e[t]))return!1;return!0}return!1}function Kt(e){if(null===e)return Mt;if("string"==typeof e)return Ct;if("boolean"==typeof e)return It;if("number"==typeof e)return St;if(e instanceof Wt)return Dt;if(e instanceof Collator)return zt;if(e instanceof Formatted)return Rt;if(e instanceof ResolvedImage)return kt;if(Array.isArray(e)){const t=e.length;let i;for(const t of e){const e=Kt(t);if(i){if(i===e)continue;i=Lt;break}i=e}return Bt(i||Lt,t)}return Pt}function Jt(e){const t=typeof e;return null===e?"":"string"===t||"number"===t||"boolean"===t?String(e):e instanceof Wt||e instanceof Formatted||e instanceof ResolvedImage?e.toString():JSON.stringify(e)}class Literal{constructor(e,t){this.type=e,this.value=t}static parse(e,t){if(2!==e.length)return t.error(`'literal' expression requires exactly one argument, but found ${e.length-1} instead.`);if(!Yt(e[1]))return t.error("invalid value");const i=e[1];let r=Kt(i);const n=t.expectedType;return"array"!==r.kind||0!==r.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(r=n),new Literal(r,i)}evaluate(){return this.value}eachChild(){}outputDefined(){return!0}serialize(){return"array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof Wt?["rgba"].concat(this.value.toArray()):this.value instanceof Formatted?this.value.serialize():this.value}}var Qt=Literal,ei=class RuntimeError{constructor(e){this.name="ExpressionEvaluationError",this.message=e}toJSON(){return this.message}};const ti={string:Ct,number:St,boolean:It,object:Pt};class Assertion{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");let i,r=1;const n=e[0];if("array"===n){let n,o;if(e.length>2){const i=e[1];if("string"!=typeof i||!(i in ti)||"object"===i)return t.error('The item type argument of "array" must be one of string, number, boolean',1);n=ti[i],r++}else n=Lt;if(e.length>3){if(null!==e[2]&&("number"!=typeof e[2]||e[2]<0||e[2]!==Math.floor(e[2])))return t.error('The length argument to "array" must be a positive integer literal',2);o=e[2],r++}i=Bt(n,o)}else i=ti[n];const o=[];for(;r<e.length;r++){const i=t.parse(e[r],r,Lt);if(!i)return null;o.push(i)}return new Assertion(i,o)}evaluate(e){for(let t=0;t<this.args.length;t++){const i=this.args[t].evaluate(e);if(!Ut(this.type,Kt(i)))return i;if(t===this.args.length-1)throw new ei(`Expected value to be of type ${Ot(this.type)}, but found ${Ot(Kt(i))} instead.`)}return null}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}serialize(){const e=this.type,t=[e.kind];if("array"===e.kind){const i=e.itemType;if("string"===i.kind||"number"===i.kind||"boolean"===i.kind){t.push(i.kind);const r=e.N;("number"==typeof r||this.args.length>1)&&t.push(r)}}return t.concat(this.args.map((e=>e.serialize())))}}var ii=Assertion;class FormatExpression{constructor(e){this.type=Rt,this.sections=e}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const i=e[1];if(!Array.isArray(i)&&"object"==typeof i)return t.error("First argument must be an image or text section.");const r=[];let n=!1;for(let i=1;i<=e.length-1;++i){const o=e[i];if(n&&"object"==typeof o&&!Array.isArray(o)){n=!1;let e=null;if(o["font-scale"]&&(e=t.parse(o["font-scale"],1,St),!e))return null;let i=null;if(o["text-font"]&&(i=t.parse(o["text-font"],1,Bt(Ct)),!i))return null;let a=null;if(o["text-color"]&&(a=t.parse(o["text-color"],1,Dt),!a))return null;const s=r[r.length-1];s.scale=e,s.font=i,s.textColor=a}else{const o=t.parse(e[i],1,Lt);if(!o)return null;const a=o.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return t.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,r.push({content:o,scale:null,font:null,textColor:null})}}return new FormatExpression(r)}evaluate(e){return new Formatted(this.sections.map((t=>{const i=t.content.evaluate(e);return Kt(i)===kt?new FormattedSection("",i,null,null,null):new FormattedSection(Jt(i),null,t.scale?t.scale.evaluate(e):null,t.font?t.font.evaluate(e).join(","):null,t.textColor?t.textColor.evaluate(e):null)})))}eachChild(e){for(const t of this.sections)e(t.content),t.scale&&e(t.scale),t.font&&e(t.font),t.textColor&&e(t.textColor)}outputDefined(){return!1}serialize(){const e=["format"];for(const t of this.sections){e.push(t.content.serialize());const i={};t.scale&&(i["font-scale"]=t.scale.serialize()),t.font&&(i["text-font"]=t.font.serialize()),t.textColor&&(i["text-color"]=t.textColor.serialize()),e.push(i)}return e}}class ImageExpression{constructor(e,t){this.type=kt,this.inputPrimary=e,this.inputSecondary=t}static parse(e,t){if(e.length<2)return t.error("Expected two or more arguments.");const i=t.parse(e[1],1,Ct);if(!i)return t.error("No image name provided.");if(2===e.length)return new ImageExpression(i);const r=t.parse(e[2],1,Ct);return r?new ImageExpression(i,r):t.error("Secondary image variant is not a string.")}evaluate(e){const t=ResolvedImage.fromString(this.inputPrimary.evaluate(e),this.inputSecondary?this.inputSecondary.evaluate(e):void 0);return t&&e.availableImages&&(t.available=e.availableImages.indexOf(t.namePrimary)>-1,t.nameSecondary&&t.available&&e.availableImages&&(t.available=e.availableImages.indexOf(t.nameSecondary)>-1)),t}eachChild(e){e(this.inputPrimary),this.inputSecondary&&e(this.inputSecondary)}outputDefined(){return!1}serialize(){return this.inputSecondary?["image",this.inputPrimary.serialize(),this.inputSecondary.serialize()]:["image",this.inputPrimary.serialize()]}}function ri(e){return e instanceof Number?"number":e instanceof String?"string":e instanceof Boolean?"boolean":Array.isArray(e)?"array":null===e?"null":typeof e}const ni={"to-boolean":It,"to-color":Dt,"to-number":St,"to-string":Ct};class Coercion{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expected at least one argument.");const i=e[0],r=[];let n=Mt;if("to-array"===i){if(!Array.isArray(e[1]))return null;const i=e[1].length;if(t.expectedType){if("array"!==t.expectedType.kind)return t.error(`Expected ${t.expectedType.kind} but found array.`);n=Bt(t.expectedType.itemType,i)}else{if(!(i>0&&Yt(e[1][0])))return null;n=Bt(Kt(e[1][0]),i)}for(let o=0;o<i;o++){const i=e[1][o];let a;if("array"===ri(i))a=t.parse(i,void 0,n.itemType);else{const e=ri(i);if(e!==n.itemType.kind)return t.error(`Expected ${n.itemType.kind} but found ${e}.`);a=t.registry.literal.parse(["literal",void 0===i?null:i],t)}if(!a)return null;r.push(a)}}else{if(("to-boolean"===i||"to-string"===i)&&2!==e.length)return t.error("Expected one argument.");n=ni[i];for(let i=1;i<e.length;i++){const n=t.parse(e[i],i,Lt);if(!n)return null;r.push(n)}}return new Coercion(n,r)}evaluate(e){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(e));if("color"===this.type.kind){let t,i;for(const r of this.args){if(t=r.evaluate(e),i=null,t instanceof Wt)return t;if("string"==typeof t){const i=e.parseColor(t);if(i)return i}else if(Array.isArray(t)&&(i=t.length<3||t.length>4?`Invalid rbga value ${JSON.stringify(t)}: expected an array containing either three or four numeric values.`:Xt(t[0],t[1],t[2],t[3]),!i))return new Wt(t[0]/255,t[1]/255,t[2]/255,t[3])}throw new ei(i||`Could not parse color from value '${"string"==typeof t?t:String(JSON.stringify(t))}'`)}if("number"===this.type.kind){let t=null;for(const i of this.args){if(t=i.evaluate(e),null===t)return 0;const r=Number(t);if(!isNaN(r))return r}throw new ei(`Could not convert ${JSON.stringify(t)} to number.`)}return"formatted"===this.type.kind?Formatted.fromString(Jt(this.args[0].evaluate(e))):"resolvedImage"===this.type.kind?ResolvedImage.fromString(Jt(this.args[0].evaluate(e))):"array"===this.type.kind?this.args.map((t=>t.evaluate(e))):Jt(this.args[0].evaluate(e))}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}serialize(){if("formatted"===this.type.kind)return new FormatExpression([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new ImageExpression(this.args[0]).serialize();const e="array"===this.type.kind?[]:[`to-${this.type.kind}`];return this.eachChild((t=>{e.push(t.serialize())})),e}}var oi=Coercion;const ai=["Unknown","Point","LineString","Polygon"];var si=class EvaluationContext{constructor(e){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null,this.featureTileCoord=null,this.featureDistanceData=null,this.options=e}id(){return this.feature&&void 0!==this.feature.id?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?ai[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}measureLight(e){return this.globals.brightness||0}distanceFromCenter(){if(this.featureTileCoord&&this.featureDistanceData){const e=this.featureDistanceData.center,t=this.featureDistanceData.scale,{x:i,y:r}=this.featureTileCoord;return this.featureDistanceData.bearing[0]*(i*t-e[0])+this.featureDistanceData.bearing[1]*(r*t-e[1])}return 0}parseColor(e){let t=this._parseColorCache[e];return t||(t=this._parseColorCache[e]=Wt.parse(e)),t}getConfig(e){return this.options?this.options.get(e):null}};class CompoundExpression{constructor(e,t,i,r){this.name=e,this.type=t,this._evaluate=i,this.args=r}evaluate(e){return this._evaluate(e,this.args)}eachChild(e){this.args.forEach(e)}outputDefined(){return!1}serialize(){return[this.name].concat(this.args.map((e=>e.serialize())))}static parse(e,t){const i=e[0],r=CompoundExpression.definitions[i];if(!r)return t.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(r)?r[0]:r.type,o=Array.isArray(r)?[[r[1],r[2]]]:r.overloads,a=o.filter((([t])=>!Array.isArray(t)||t.length===e.length-1));let s=null;for(const[r,o]of a){s=new fr(t.registry,t.path,null,t.scope,void 0,t.options);const a=[];let l=!1;for(let t=1;t<e.length;t++){const i=e[t],n=Array.isArray(r)?r[t-1]:r.type,o=s.parse(i,1+a.length,n);if(!o){l=!0;break}a.push(o)}if(!l)if(Array.isArray(r)&&r.length!==a.length)s.error(`Expected ${r.length} arguments, but found ${a.length} instead.`);else{for(let e=0;e<a.length;e++){const t=Array.isArray(r)?r[e]:r.type,i=a[e];s.concat(e+1).checkSubtype(t,i.type)}if(0===s.errors.length)return new CompoundExpression(i,n,o,a)}}if(1===a.length)t.errors.push(...s.errors);else{const i=(a.length?a:o).map((([e])=>{return t=e,Array.isArray(t)?`(${t.map(Ot).join(", ")})`:`(${Ot(t.type)}...)`;var t})).join(" | "),r=[];for(let i=1;i<e.length;i++){const n=t.parse(e[i],1+r.length);if(!n)return null;r.push(Ot(n.type))}t.error(`Expected arguments of type ${i}, but found (${r.join(", ")}) instead.`)}return null}static register(e,t){CompoundExpression.definitions=t;for(const i in t)e[i]=CompoundExpression}}var li=CompoundExpression;class CollatorExpression{constructor(e,t,i){this.type=zt,this.locale=i,this.caseSensitive=e,this.diacriticSensitive=t}static parse(e,t){if(2!==e.length)return t.error("Expected one argument.");const i=e[1];if("object"!=typeof i||Array.isArray(i))return t.error("Collator options argument must be an object.");const r=t.parse(void 0!==i["case-sensitive"]&&i["case-sensitive"],1,It);if(!r)return null;const n=t.parse(void 0!==i["diacritic-sensitive"]&&i["diacritic-sensitive"],1,It);if(!n)return null;let o=null;return i.locale&&(o=t.parse(i.locale,1,Ct),!o)?null:new CollatorExpression(r,n,o)}evaluate(e){return new Collator(this.caseSensitive.evaluate(e),this.diacriticSensitive.evaluate(e),this.locale?this.locale.evaluate(e):null)}eachChild(e){e(this.caseSensitive),e(this.diacriticSensitive),this.locale&&e(this.locale)}outputDefined(){return!1}serialize(){const e={};return e["case-sensitive"]=this.caseSensitive.serialize(),e["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(e.locale=this.locale.serialize()),["collator",e]}}var ci={exports:{}};!function(e,t){e.exports=function(){function e(i,r,n,o,a){for(;o>n;){if(o-n>600){var s=o-n+1,l=r-n+1,c=Math.log(s),u=.5*Math.exp(2*c/3),h=.5*Math.sqrt(c*u*(s-u)/s)*(l-s/2<0?-1:1);e(i,r,Math.max(n,Math.floor(r-l*u/s+h)),Math.min(o,Math.floor(r+(s-l)*u/s+h)),a)}var d=i[r],p=n,f=o;for(t(i,n,r),a(i[o],d)>0&&t(i,n,o);p<f;){for(t(i,p,f),p++,f--;a(i[p],d)<0;)p++;for(;a(i[f],d)>0;)f--}0===a(i[n],d)?t(i,n,f):t(i,++f,o),f<=r&&(n=f+1),r<=f&&(o=f-1)}}function t(e,t,i){var r=e[t];e[t]=e[i],e[i]=r}function i(e,t){return e<t?-1:e>t?1:0}return function(t,r,n,o,a){e(t,r,n||0,o||t.length-1,a||i)}}()}(ci);var ui=h(ci.exports);function hi(e){let t=0;for(let i,r,n=0,o=e.length,a=o-1;n<o;a=n++)i=e[n],r=e[a],t+=(r.x-i.x)*(i.y+r.y);return t}function di(e,t){e[0]=Math.min(e[0],t[0]),e[1]=Math.min(e[1],t[1]),e[2]=Math.max(e[2],t[0]),e[3]=Math.max(e[3],t[1])}function pi(e,t){return!(e[0]<=t[0]||e[2]>=t[2]||e[1]<=t[1]||e[3]>=t[3])}function fi(e,t,i){const r=e[0]-t[0],n=e[1]-t[1],o=e[0]-i[0],a=e[1]-i[1];return r*a-o*n==0&&r*o<=0&&n*a<=0}function mi(e,t,i=!1){let r=!1;for(let s=0,l=t.length;s<l;s++){const l=t[s];for(let t=0,s=l.length,c=s-1;t<s;c=t++){const s=l[c],u=l[t];if(fi(e,s,u))return i;(o=s)[1]>(n=e)[1]!=(a=u)[1]>n[1]&&n[0]<(a[0]-o[0])*(n[1]-o[1])/(a[1]-o[1])+o[0]&&(r=!r)}}var n,o,a;return r}function _i(e,t,i,r){const n=r[0]-i[0],o=r[1]-i[1],a=(e[0]-i[0])*o-n*(e[1]-i[1]),s=(t[0]-i[0])*o-n*(t[1]-i[1]);return a>0&&s<0||a<0&&s>0}function gi(e,t,i,r){return 0!=(n=[r[0]-i[0],r[1]-i[1]])[0]*(o=[t[0]-e[0],t[1]-e[1]])[1]-n[1]*o[0]&&!(!_i(e,t,i,r)||!_i(i,r,e,t));var n,o}const yi=8192;function xi(e,t){const i=(180+e[0])/360,r=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e[1]*Math.PI/360)))/360,n=Math.pow(2,t.z);return[Math.round(i*n*yi),Math.round(r*n*yi)]}function vi(e,t){for(let i=0;i<t.length;i++)if(mi(e,t[i]))return!0;return!1}function bi(e,t,i){for(const r of i)for(let i=0,n=r.length,o=n-1;i<n;o=i++)if(gi(e,t,r[o],r[i]))return!0;return!1}function wi(e,t){for(let i=0;i<e.length;++i)if(!mi(e[i],t))return!1;for(let i=0;i<e.length-1;++i)if(bi(e[i],e[i+1],t))return!1;return!0}function Ti(e,t){for(let i=0;i<t.length;i++)if(wi(e,t[i]))return!0;return!1}function Ei(e,t,i){const r=[];for(let n=0;n<e.length;n++){const o=[];for(let r=0;r<e[n].length;r++){const a=xi(e[n][r],i);di(t,a),o.push(a)}r.push(o)}return r}function Mi(e,t,i){const r=[];for(let n=0;n<e.length;n++){const o=Ei(e[n],t,i);r.push(o)}return r}function Si(e,t,i,r){if(e[0]<i[0]||e[0]>i[2]){const t=.5*r;let n=e[0]-i[0]>t?-r:i[0]-e[0]>t?r:0;0===n&&(n=e[0]-i[2]>t?-r:i[2]-e[0]>t?r:0),e[0]+=n}di(t,e)}function Ai(e,t,i,r){const n=Math.pow(2,r.z)*yi,o=[r.x*yi,r.y*yi],a=[];if(!e)return a;for(const r of e)for(const e of r){const r=[e.x+o[0],e.y+o[1]];Si(r,t,i,n),a.push(r)}return a}function Ci(e,t,i,r){const n=Math.pow(2,r.z)*yi,o=[r.x*yi,r.y*yi],a=[];if(!e)return a;for(const i of e){const e=[];for(const r of i){const i=[r.x+o[0],r.y+o[1]];di(t,i),e.push(i)}a.push(e)}if(t[2]-t[0]<=n/2){(s=t)[0]=s[1]=1/0,s[2]=s[3]=-1/0;for(const e of a)for(const r of e)Si(r,t,i,n)}var s;return a}class Within{constructor(e,t){this.type=It,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'within' expression requires exactly one argument, but found ${e.length-1} instead.`);if(Yt(e[1])){const t=e[1];if("FeatureCollection"===t.type)for(let e=0;e<t.features.length;++e){const i=t.features[e].geometry.type;if("Polygon"===i||"MultiPolygon"===i)return new Within(t,t.features[e].geometry)}else if("Feature"===t.type){const e=t.geometry.type;if("Polygon"===e||"MultiPolygon"===e)return new Within(t,t.geometry)}else if("Polygon"===t.type||"MultiPolygon"===t.type)return new Within(t,t)}return t.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(e){if(null!=e.geometry()&&null!=e.canonicalID()){if("Point"===e.geometryType())return function(e,t){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=e.canonicalID();if(!n)return!1;if("Polygon"===t.type){const o=Ei(t.coordinates,r,n),a=Ai(e.geometry(),i,r,n);if(!pi(i,r))return!1;for(const e of a)if(!mi(e,o))return!1}if("MultiPolygon"===t.type){const o=Mi(t.coordinates,r,n),a=Ai(e.geometry(),i,r,n);if(!pi(i,r))return!1;for(const e of a)if(!vi(e,o))return!1}return!0}(e,this.geometries);if("LineString"===e.geometryType())return function(e,t){const i=[1/0,1/0,-1/0,-1/0],r=[1/0,1/0,-1/0,-1/0],n=e.canonicalID();if(!n)return!1;if("Polygon"===t.type){const o=Ei(t.coordinates,r,n),a=Ci(e.geometry(),i,r,n);if(!pi(i,r))return!1;for(const e of a)if(!wi(e,o))return!1}if("MultiPolygon"===t.type){const o=Mi(t.coordinates,r,n),a=Ci(e.geometry(),i,r,n);if(!pi(i,r))return!1;for(const e of a)if(!Ti(e,o))return!1}return!0}(e,this.geometries)}return!1}eachChild(){}outputDefined(){return!0}serialize(){return["within",this.geojson]}}var Ii=Within,Di={exports:{}};!function(e,t){e.exports=function(){var e={kilometers:1,miles:1e3/1609.344,nauticalmiles:1e3/1852,meters:1e3,metres:1e3,yards:1e3/.9144,feet:1e3/.3048,inches:1e3/.0254},t=1/298.257223563,i=t*(2-t),r=Math.PI/180,n=function(t,n){if(void 0===t)throw new Error("No latitude given.");if(n&&!e[n])throw new Error("Unknown unit "+n+". Use one of: "+Object.keys(e).join(", "));var o=6378.137*r*(n?e[n]:1),a=Math.cos(t*r),s=1/(1-i*(1-a*a)),l=Math.sqrt(s);this.kx=o*l*a,this.ky=o*l*s*(1-i)},o={units:{configurable:!0}};function a(e,t){return e[0]===t[0]&&e[1]===t[1]}function s(e,t,i){var r=l(t[0]-e[0]);return[e[0]+r*i,e[1]+(t[1]-e[1])*i]}function l(e){for(;e<-180;)e+=360;for(;e>180;)e-=360;return e}return n.fromTile=function(e,t,i){var o=Math.PI*(1-2*(e+.5)/Math.pow(2,t)),a=Math.atan(.5*(Math.exp(o)-Math.exp(-o)))/r;return new n(a,i)},o.units.get=function(){return e},n.prototype.distance=function(e,t){var i=l(e[0]-t[0])*this.kx,r=(e[1]-t[1])*this.ky;return Math.sqrt(i*i+r*r)},n.prototype.bearing=function(e,t){var i=l(t[0]-e[0])*this.kx;return Math.atan2(i,(t[1]-e[1])*this.ky)/r},n.prototype.destination=function(e,t,i){var n=i*r;return this.offset(e,Math.sin(n)*t,Math.cos(n)*t)},n.prototype.offset=function(e,t,i){return[e[0]+t/this.kx,e[1]+i/this.ky]},n.prototype.lineDistance=function(e){for(var t=0,i=0;i<e.length-1;i++)t+=this.distance(e[i],e[i+1]);return t},n.prototype.area=function(e){for(var t=0,i=0;i<e.length;i++)for(var r=e[i],n=0,o=r.length,a=o-1;n<o;a=n++)t+=l(r[n][0]-r[a][0])*(r[n][1]+r[a][1])*(i?-1:1);return Math.abs(t)/2*this.kx*this.ky},n.prototype.along=function(e,t){var i=0;if(t<=0)return e[0];for(var r=0;r<e.length-1;r++){var n=e[r],o=e[r+1],a=this.distance(n,o);if((i+=a)>t)return s(n,o,(t-(i-a))/a)}return e[e.length-1]},n.prototype.pointToSegmentDistance=function(e,t,i){var r=t[0],n=t[1],o=l(i[0]-r)*this.kx,a=(i[1]-n)*this.ky,s=0;return 0===o&&0===a||((s=(l(e[0]-r)*this.kx*o+(e[1]-n)*this.ky*a)/(o*o+a*a))>1?(r=i[0],n=i[1]):s>0&&(r+=o/this.kx*s,n+=a/this.ky*s)),o=l(e[0]-r)*this.kx,a=(e[1]-n)*this.ky,Math.sqrt(o*o+a*a)},n.prototype.pointOnLine=function(e,t){for(var i,r,n,o,a=1/0,s=0;s<e.length-1;s++){var c=e[s][0],u=e[s][1],h=l(e[s+1][0]-c)*this.kx,d=(e[s+1][1]-u)*this.ky,p=0;0===h&&0===d||((p=(l(t[0]-c)*this.kx*h+(t[1]-u)*this.ky*d)/(h*h+d*d))>1?(c=e[s+1][0],u=e[s+1][1]):p>0&&(c+=h/this.kx*p,u+=d/this.ky*p));var f=(h=l(t[0]-c)*this.kx)*h+(d=(t[1]-u)*this.ky)*d;f<a&&(a=f,i=c,r=u,n=s,o=p)}return{point:[i,r],index:n,t:Math.max(0,Math.min(1,o))}},n.prototype.lineSlice=function(e,t,i){var r=this.pointOnLine(i,e),n=this.pointOnLine(i,t);if(r.index>n.index||r.index===n.index&&r.t>n.t){var o=r;r=n,n=o}var s=[r.point],l=r.index+1,c=n.index;!a(i[l],s[0])&&l<=c&&s.push(i[l]);for(var u=l+1;u<=c;u++)s.push(i[u]);return a(i[c],n.point)||s.push(n.point),s},n.prototype.lineSliceAlong=function(e,t,i){for(var r=0,n=[],o=0;o<i.length-1;o++){var a=i[o],l=i[o+1],c=this.distance(a,l);if((r+=c)>e&&0===n.length&&n.push(s(a,l,(e-(r-c))/c)),r>=t)return n.push(s(a,l,(t-(r-c))/c)),n;r>e&&n.push(l)}return n},n.prototype.bufferPoint=function(e,t){var i=t/this.ky,r=t/this.kx;return[e[0]-r,e[1]-i,e[0]+r,e[1]+i]},n.prototype.bufferBBox=function(e,t){var i=t/this.ky,r=t/this.kx;return[e[0]-r,e[1]-i,e[2]+r,e[3]+i]},n.prototype.insideBBox=function(e,t){return l(e[0]-t[0])>=0&&l(e[0]-t[2])<=0&&e[1]>=t[1]&&e[1]<=t[3]},Object.defineProperties(n,o),n}()}(Di);var Pi=h(Di.exports),Li={exports:{}};!function(e,t){e.exports=function(){var e=function(e,i){if(void 0===e&&(e=[]),void 0===i&&(i=t),this.data=e,this.length=this.data.length,this.compare=i,this.length>0)for(var r=(this.length>>1)-1;r>=0;r--)this._down(r)};function t(e,t){return e<t?-1:e>t?1:0}return e.prototype.push=function(e){this.data.push(e),this.length++,this._up(this.length-1)},e.prototype.pop=function(){if(0!==this.length){var e=this.data[0],t=this.data.pop();return this.length--,this.length>0&&(this.data[0]=t,this._down(0)),e}},e.prototype.peek=function(){return this.data[0]},e.prototype._up=function(e){for(var t=this.data,i=this.compare,r=t[e];e>0;){var n=e-1>>1,o=t[n];if(i(r,o)>=0)break;t[e]=o,e=n}t[e]=r},e.prototype._down=function(e){for(var t=this.data,i=this.compare,r=this.length>>1,n=t[e];e<r;){var o=1+(e<<1),a=t[o],s=o+1;if(s<this.length&&i(t[s],a)<0&&(o=s,a=t[s]),i(a,n)>=0)break;t[e]=a,e=o}t[e]=n},e}()}(Li);var zi=h(Li.exports),Ri=8192;function ki(e,t){return t.dist-e.dist}const Bi=100,Oi=50;function Fi(e){const t=[1/0,1/0,-1/0,-1/0];if(t.length!==e.length)return!1;for(let i=0;i<t.length;i++)if(t[i]!==e[i])return!1;return!0}function Ui(e){return e[1]-e[0]+1}function Vi(e,t){const i=e[1]>=e[0]&&e[1]<t;return i||console.warn("Distance Expression: Index is out of range"),i}function Ni(e,t){if(e[0]>e[1])return[null,null];const i=Ui(e);if(t){if(2===i)return[e,null];const t=Math.floor(i/2);return[[e[0],e[0]+t],[e[0]+t,e[1]]]}{if(1===i)return[e,null];const t=Math.floor(i/2)-1;return[[e[0],e[0]+t],[e[0]+t+1,e[1]]]}}function ji(e,t){const i=[1/0,1/0,-1/0,-1/0];if(!Vi(t,e.length))return i;for(let r=t[0];r<=t[1];++r)di(i,e[r]);return i}function Gi(e){const t=[1/0,1/0,-1/0,-1/0];for(let i=0;i<e.length;++i)for(let r=0;r<e[i].length;++r)di(t,e[i][r]);return t}function qi(e,t,i){if(Fi(e)||Fi(t))return NaN;let r=0,n=0;return e[2]<t[0]&&(r=t[0]-e[2]),e[0]>t[2]&&(r=e[0]-t[2]),e[1]>t[3]&&(n=e[1]-t[3]),e[3]<t[1]&&(n=t[1]-e[3]),i.distance([0,0],[r,n])}function Zi(e,t){const i=Math.pow(2,t.z);return[(n=(e.x/Ri+t.x)/i,360*n-180),(r=(e.y/Ri+t.y)/i,360/Math.PI*Math.atan(Math.exp((180-360*r)*Math.PI/180))-90)];var r,n}function $i(e,t){const i=[];for(let r=0;r<e.length;++r)i.push(Zi(e[r],t));return i}function Hi(e,t,i){const r=i.pointOnLine(t,e).point;return i.distance(e,r)}function Wi(e,t,i,r,n){const o=i.slice(r[0],r[1]+1);let a=1/0;for(let i=t[0];i<=t[1];++i)if(0===(a=Math.min(a,Hi(e[i],o,n))))return 0;return a}function Xi(e,t,i,r,n){const o=Math.min(n.pointToSegmentDistance(e,i,r),n.pointToSegmentDistance(t,i,r)),a=Math.min(n.pointToSegmentDistance(i,e,t),n.pointToSegmentDistance(r,e,t));return Math.min(o,a)}function Yi(e,t,i,r,n){if(!Vi(t,e.length)||!Vi(r,i.length))return NaN;let o=1/0;for(let a=t[0];a<t[1];++a)for(let t=r[0];t<r[1];++t){if(gi(e[a],e[a+1],i[t],i[t+1]))return 0;o=Math.min(o,Xi(e[a],e[a+1],i[t],i[t+1],n))}return o}function Ki(e,t,i,r,n){if(!Vi(t,e.length)||!Vi(r,i.length))return NaN;let o=1/0;for(let a=t[0];a<=t[1];++a)for(let t=r[0];t<=r[1];++t)if(0===(o=Math.min(o,n.distance(e[a],i[t]))))return o;return o}function Ji(e,t,i){if(mi(e,t,!0))return 0;let r=1/0;for(const n of t){const t=n.length;if(t<2)return console.warn("Distance Expression: Invalid polygon!"),NaN;if(n[0]!==n[t-1]&&0===(r=Math.min(r,i.pointToSegmentDistance(e,n[t-1],n[0]))))return r;if(0===(r=Math.min(r,Hi(e,n,i))))return r}return r}function Qi(e,t,i,r){if(!Vi(t,e.length))return NaN;for(let r=t[0];r<=t[1];++r)if(mi(e[r],i,!0))return 0;let n=1/0;for(let o=t[0];o<t[1];++o)for(const t of i)for(let i=0,a=t.length,s=a-1;i<a;s=i++){if(gi(e[o],e[o+1],t[s],t[i]))return 0;n=Math.min(n,Xi(e[o],e[o+1],t[s],t[i],r))}return n}function er(e,t){for(const i of e)for(let e=0;e<=i.length-1;++e)if(mi(i[e],t,!0))return!0;return!1}function tr(e,t,i,r=1/0){const n=Gi(e),o=Gi(t);if(r!==1/0&&qi(n,o,i)>=r)return r;if(pi(n,o)){if(er(e,t))return 0}else if(er(t,e))return 0;let a=r;for(const r of e)for(let e=0,n=r.length,o=n-1;e<n;o=e++)for(const n of t)for(let t=0,s=n.length,l=s-1;t<s;l=t++){if(gi(r[o],r[e],n[l],n[t]))return 0;a=Math.min(a,Xi(r[o],r[e],n[l],n[t],i))}return a}function ir(e,t,i,r,n,o,a){if(null===o||null===a)return;const s=qi(ji(r,o),ji(n,a),i);s<t&&e.push({dist:s,range1:o,range2:a})}function rr(e,t,i,r,n=1/0){let o=Math.min(r.distance(e[0],i[0][0]),n);if(0===o)return o;const a=new zi([{dist:0,range1:[0,e.length-1],range2:[0,0]}],ki),s=t?Oi:Bi,l=Gi(i);for(;a.length;){const n=a.pop();if(n.dist>=o)continue;const c=n.range1;if(Ui(c)<=s){if(!Vi(c,e.length))return NaN;if(t){const t=Qi(e,c,i,r);if(0===(o=Math.min(o,t)))return o}else for(let t=c[0];t<=c[1];++t){const n=Ji(e[t],i,r);if(0===(o=Math.min(o,n)))return o}}else{const i=Ni(c,t);if(null!==i[0]){const t=qi(ji(e,i[0]),l,r);t<o&&a.push({dist:t,range1:i[0],range2:[0,0]})}if(null!==i[1]){const t=qi(ji(e,i[1]),l,r);t<o&&a.push({dist:t,range1:i[1],range2:[0,0]})}}}return o}function nr(e,t,i,r,n,o=1/0){let a=Math.min(o,n.distance(e[0],i[0]));if(0===a)return a;const s=new zi([{dist:0,range1:[0,e.length-1],range2:[0,i.length-1]}],ki),l=t?Oi:Bi,c=r?Oi:Bi;for(;s.length;){const o=s.pop();if(o.dist>=a)continue;const u=o.range1,h=o.range2;if(Ui(u)<=l&&Ui(h)<=c){if(!Vi(u,e.length)||!Vi(h,i.length))return NaN;if(t&&r?a=Math.min(a,Yi(e,u,i,h,n)):t||r?t&&!r?a=Math.min(a,Wi(i,h,e,u,n)):!t&&r&&(a=Math.min(a,Wi(e,u,i,h,n))):a=Math.min(a,Ki(e,u,i,h,n)),0===a)return a}else{const o=Ni(u,t),l=Ni(h,r);ir(s,a,n,e,i,o[0],l[0]),ir(s,a,n,e,i,o[0],l[1]),ir(s,a,n,e,i,o[1],l[0]),ir(s,a,n,e,i,o[1],l[1])}}return a}function or(e,t,i,r,n=1/0){let o=n;const a=ji(e,[0,e.length-1]);for(const n of i)if(!(o!==1/0&&qi(a,ji(n,[0,n.length-1]),r)>=o)&&(o=Math.min(o,nr(e,t,n,!0,r,o)),0===o))return o;return o}function ar(e,t,i,r,n=1/0){let o=n;const a=ji(e,[0,e.length-1]);for(const n of i){if(o!==1/0&&qi(a,Gi(n),r)>=o)continue;const i=rr(e,t,n,r,o);if(isNaN(i))return i;if(0===(o=Math.min(o,i)))return o}return o}function sr(e){return"Point"===e||"MultiPoint"===e||"LineString"===e||"MultiLineString"===e||"Polygon"===e||"MultiPolygon"===e}class Distance{constructor(e,t){this.type=St,this.geojson=e,this.geometries=t}static parse(e,t){if(2!==e.length)return t.error(`'distance' expression requires either one argument, but found ' ${e.length-1} instead.`);if(Yt(e[1])){const t=e[1];if("FeatureCollection"===t.type){for(let e=0;e<t.features.length;++e)if(sr(t.features[e].geometry.type))return new Distance(t,t.features[e].geometry)}else if("Feature"===t.type){if(sr(t.geometry.type))return new Distance(t,t.geometry)}else if(sr(t.type))return new Distance(t,t)}return t.error("'distance' expression needs to be an array with format ['Distance', GeoJSONObj].")}evaluate(e){const t=e.geometry(),i=e.canonicalID();if(null!=t&&null!=i){if("Point"===e.geometryType())return function(e,t,i){const r=[];for(const i of e)for(const e of i)r.push(Zi(e,t));const n=new Pi(r[0][1],"meters");return"Point"===i.type||"MultiPoint"===i.type||"LineString"===i.type?nr(r,!1,"Point"===i.type?[i.coordinates]:i.coordinates,"LineString"===i.type,n):"MultiLineString"===i.type?or(r,!1,i.coordinates,n):"Polygon"===i.type||"MultiPolygon"===i.type?ar(r,!1,"Polygon"===i.type?[i.coordinates]:i.coordinates,n):null}(t,i,this.geometries);if("LineString"===e.geometryType())return function(e,t,i){const r=[];for(const i of e){const e=[];for(const r of i)e.push(Zi(r,t));r.push(e)}const n=new Pi(r[0][0][1],"meters");if("Point"===i.type||"MultiPoint"===i.type||"LineString"===i.type)return or("Point"===i.type?[i.coordinates]:i.coordinates,"LineString"===i.type,r,n);if("MultiLineString"===i.type){let e=1/0;for(let t=0;t<i.coordinates.length;t++){const o=or(i.coordinates[t],!0,r,n,e);if(isNaN(o))return o;if(0===(e=Math.min(e,o)))return e}return e}if("Polygon"===i.type||"MultiPolygon"===i.type){let e=1/0;for(let t=0;t<r.length;t++){const o=ar(r[t],!0,"Polygon"===i.type?[i.coordinates]:i.coordinates,n,e);if(isNaN(o))return o;if(0===(e=Math.min(e,o)))return e}return e}return null}(t,i,this.geometries);if("Polygon"===e.geometryType())return function(e,t,i){const r=[];for(const i of function(e,t){const i=e.length;if(i<=1)return[e];const r=[];let n,o;for(let t=0;t<i;t++){const i=hi(e[t]);0!==i&&(e[t].area=Math.abs(i),void 0===o&&(o=i<0),o===i<0?(n&&r.push(n),n=[e[t]]):n.push(e[t]))}return n&&r.push(n),r}(e)){const e=[];for(let r=0;r<i.length;++r)e.push($i(i[r],t));r.push(e)}const n=new Pi(r[0][0][0][1],"meters");if("Point"===i.type||"MultiPoint"===i.type||"LineString"===i.type)return ar("Point"===i.type?[i.coordinates]:i.coordinates,"LineString"===i.type,r,n);if("MultiLineString"===i.type){let e=1/0;for(let t=0;t<i.coordinates.length;t++){const o=ar(i.coordinates[t],!0,r,n,e);if(isNaN(o))return o;if(0===(e=Math.min(e,o)))return e}return e}return"Polygon"===i.type||"MultiPolygon"===i.type?function(e,t,i){let r=1/0;for(const n of e)for(const e of t){const t=tr(n,e,i,r);if(isNaN(t))return t;if(0===(r=Math.min(r,t)))return r}return r}("Polygon"===i.type?[i.coordinates]:i.coordinates,r,n):null}(t,i,this.geometries);console.warn("Distance Expression: currently only evaluates valid Point/LineString/Polygon geometries.")}else console.warn("Distance Expression: requirs valid feature and canonical information.");return null}eachChild(){}outputDefined(){return!0}serialize(){return["distance",this.geojson]}}var lr=Distance;function cr(e){if(e instanceof li){if("get"===e.name&&1===e.args.length)return!1;if("feature-state"===e.name)return!1;if("has"===e.name&&1===e.args.length)return!1;if("properties"===e.name||"geometry-type"===e.name||"id"===e.name)return!1;if(/^filter-/.test(e.name))return!1}if(e instanceof Ii)return!1;if(e instanceof lr)return!1;let t=!0;return e.eachChild((e=>{t&&!cr(e)&&(t=!1)})),t}function ur(e){if(e instanceof li&&"feature-state"===e.name)return!1;let t=!0;return e.eachChild((e=>{t&&!ur(e)&&(t=!1)})),t}function hr(e){if(e instanceof li&&"config"===e.name)return!1;let t=!0;return e.eachChild((e=>{t&&!hr(e)&&(t=!1)})),t}function dr(e,t){if(e instanceof li&&t.indexOf(e.name)>=0)return!1;let i=!0;return e.eachChild((e=>{i&&!dr(e,t)&&(i=!1)})),i}class Var{constructor(e,t){this.type=t.type,this.name=e,this.boundExpression=t}static parse(e,t){if(2!==e.length||"string"!=typeof e[1])return t.error("'var' expression requires exactly one string literal argument.");const i=e[1];return t.scope.has(i)?new Var(i,t.scope.get(i)):t.error(`Unknown variable "${i}". Make sure "${i}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(e){return this.boundExpression.evaluate(e)}eachChild(){}outputDefined(){return!1}serialize(){return["var",this.name]}}var pr=Var;class ParsingContext{constructor(e,t=[],i,r=new Et,n=[],o){this.registry=e,this.path=t,this.key=t.map((e=>`[${e}]`)).join(""),this.scope=r,this.errors=n,this.expectedType=i,this.options=o}parse(e,t,i,r,n={}){return t||i?this.concat(t,i,r)._parse(e,n):this._parse(e,n)}_parse(e,t){function i(e,t,i){return"assert"===i?new ii(t,[e]):"coerce"===i?new oi(t,[e]):e}if(null!==e&&"string"!=typeof e&&"boolean"!=typeof e&&"number"!=typeof e||(e=["literal",e]),Array.isArray(e)){if(0===e.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const r="string"==typeof e[0]?this.registry[e[0]]:void 0;if(r){let n=r.parse(e,this);if(!n)return null;if(this.expectedType){const e=this.expectedType,r=n.type;if("string"!==e.kind&&"number"!==e.kind&&"boolean"!==e.kind&&"object"!==e.kind&&"array"!==e.kind||"value"!==r.kind)if("color"!==e.kind&&"formatted"!==e.kind&&"resolvedImage"!==e.kind||"value"!==r.kind&&"string"!==r.kind){if(this.checkSubtype(e,r))return null}else n=i(n,e,t.typeAnnotation||"coerce");else n=i(n,e,t.typeAnnotation||"assert")}if(!(n instanceof Qt)&&"resolvedImage"!==n.type.kind&&mr(n)){const e=new si(this.options);try{n=new Qt(n.type,n.evaluate(e))}catch(e){return this.error(e.message),null}}return n}return oi.parse(["to-array",e],this)}return this.error(void 0===e?"'undefined' value invalid. Use null instead.":"object"==typeof e?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof e} instead.`)}concat(e,t,i){const r="number"==typeof e?this.path.concat(e):this.path,n=i?this.scope.concat(i):this.scope;return new ParsingContext(this.registry,r,t||null,n,this.errors,this.options)}error(e,...t){const i=`${this.key}${t.map((e=>`[${e}]`)).join("")}`;this.errors.push(new Tt(i,e))}checkSubtype(e,t){const i=Ut(e,t);return i&&this.error(i),i}}var fr=ParsingContext;function mr(e){if(e instanceof pr)return mr(e.boundExpression);if(e instanceof li&&"error"===e.name)return!1;if(e instanceof li&&"config"===e.name)return!1;if(e instanceof CollatorExpression)return!1;if(e instanceof Ii)return!1;if(e instanceof lr)return!1;const t=e instanceof oi||e instanceof ii;let i=!0;return e.eachChild((e=>{i=t?i&&mr(e):i&&e instanceof Qt})),!!i&&cr(e)&&dr(e,["zoom","heatmap-density","line-progress","raster-value","sky-radial-progress","accumulated","is-supported-script","pitch","distance-from-center","measure-light"])}function _r(e,t){const i=e.length-1;let r,n,o=0,a=i,s=0;for(;o<=a;)if(s=Math.floor((o+a)/2),r=e[s],n=e[s+1],r<=t){if(s===i||t<n)return s;o=s+1}else{if(!(r>t))throw new ei("Input is not a number.");a=s-1}return 0}class Step{constructor(e,t,i){this.type=e,this.input=t,this.labels=[],this.outputs=[];for(const[e,t]of i)this.labels.push(e),this.outputs.push(t)}static parse(e,t){if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");const i=t.parse(e[1],1,St);if(!i)return null;const r=[];let n=null;t.expectedType&&"value"!==t.expectedType.kind&&(n=t.expectedType);for(let i=1;i<e.length;i+=2){const o=1===i?-1/0:e[i],a=e[i+1],s=i,l=i+1;if("number"!=typeof o)return t.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',s);if(r.length&&r[r.length-1][0]>=o)return t.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',s);const c=t.parse(a,l,n);if(!c)return null;n=n||c.type,r.push([o,c])}return new Step(n,i,r)}evaluate(e){const t=this.labels,i=this.outputs;if(1===t.length)return i[0].evaluate(e);const r=this.input.evaluate(e);if(r<=t[0])return i[0].evaluate(e);const n=t.length;return r>=t[n-1]?i[n-1].evaluate(e):i[_r(t,r)].evaluate(e)}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}serialize(){const e=["step",this.input.serialize()];for(let t=0;t<this.labels.length;t++)t>0&&e.push(this.labels[t]),e.push(this.outputs[t].serialize());return e}}var gr=Step;function yr(e,t,i){return e*(1-i)+t*i}function xr(e,t,i){return e.map(((e,r)=>yr(e,t[r],i)))}var vr=Object.freeze({__proto__:null,array:xr,color:function(e,t,i){return new Wt(yr(e.r,t.r,i),yr(e.g,t.g,i),yr(e.b,t.b,i),yr(e.a,t.a,i))},number:yr});const br=.95047,wr=1.08883,Tr=4/29,Er=6/29,Mr=3*Er*Er,Sr=Er*Er*Er,Ar=Math.PI/180,Cr=180/Math.PI;function Ir(e){return e>Sr?Math.pow(e,1/3):e/Mr+Tr}function Dr(e){return e>Er?e*e*e:Mr*(e-Tr)}function Pr(e){return 255*(e<=.0031308?12.92*e:1.055*Math.pow(e,1/2.4)-.055)}function Lr(e){return(e/=255)<=.04045?e/12.92:Math.pow((e+.055)/1.055,2.4)}function zr(e){const t=Lr(e.r),i=Lr(e.g),r=Lr(e.b),n=Ir((.4124564*t+.3575761*i+.1804375*r)/br),o=Ir((.2126729*t+.7151522*i+.072175*r)/1);return{l:116*o-16,a:500*(n-o),b:200*(o-Ir((.0193339*t+.119192*i+.9503041*r)/wr)),alpha:e.a}}function Rr(e){let t=(e.l+16)/116,i=isNaN(e.a)?t:t+e.a/500,r=isNaN(e.b)?t:t-e.b/200;return t=1*Dr(t),i=br*Dr(i),r=wr*Dr(r),new Wt(Pr(3.2404542*i-1.5371385*t-.4985314*r),Pr(-.969266*i+1.8760108*t+.041556*r),Pr(.0556434*i-.2040259*t+1.0572252*r),e.alpha)}function kr(e,t,i){const r=t-e;return e+i*(r>180||r<-180?r-360*Math.round(r/360):r)}const Br={forward:zr,reverse:Rr,interpolate:function(e,t,i){return{l:yr(e.l,t.l,i),a:yr(e.a,t.a,i),b:yr(e.b,t.b,i),alpha:yr(e.alpha,t.alpha,i)}}},Or={forward:function(e){const{l:t,a:i,b:r}=zr(e),n=Math.atan2(r,i)*Cr;return{h:n<0?n+360:n,c:Math.sqrt(i*i+r*r),l:t,alpha:e.a}},reverse:function(e){const t=e.h*Ar,i=e.c;return Rr({l:e.l,a:Math.cos(t)*i,b:Math.sin(t)*i,alpha:e.alpha})},interpolate:function(e,t,i){return{h:kr(e.h,t.h,i),c:yr(e.c,t.c,i),l:yr(e.l,t.l,i),alpha:yr(e.alpha,t.alpha,i)}}};var Fr=Object.freeze({__proto__:null,hcl:Or,lab:Br});class Interpolate{constructor(e,t,i,r,n){this.type=e,this.operator=t,this.interpolation=i,this.input=r,this.labels=[],this.outputs=[];for(const[e,t]of n)this.labels.push(e),this.outputs.push(t)}static interpolationFactor(e,t,i,r){let n=0;if("exponential"===e.name)n=Ur(t,e.base,i,r);else if("linear"===e.name)n=Ur(t,1,i,r);else if("cubic-bezier"===e.name){const o=e.controlPoints;n=new f(o[0],o[1],o[2],o[3]).solve(Ur(t,1,i,r))}return n}static parse(e,t){let[i,r,n,...o]=e;if(!Array.isArray(r)||0===r.length)return t.error("Expected an interpolation type expression.",1);if("linear"===r[0])r={name:"linear"};else if("exponential"===r[0]){const e=r[1];if("number"!=typeof e)return t.error("Exponential interpolation requires a numeric base.",1,1);r={name:"exponential",base:e}}else{if("cubic-bezier"!==r[0])return t.error(`Unknown interpolation type ${String(r[0])}`,1,0);{const e=r.slice(1);if(4!==e.length||e.some((e=>"number"!=typeof e||e<0||e>1)))return t.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);r={name:"cubic-bezier",controlPoints:e}}}if(e.length-1<4)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if((e.length-1)%2!=0)return t.error("Expected an even number of arguments.");if(n=t.parse(n,2,St),!n)return null;const a=[];let s=null;"interpolate-hcl"===i||"interpolate-lab"===i?s=Dt:t.expectedType&&"value"!==t.expectedType.kind&&(s=t.expectedType);for(let e=0;e<o.length;e+=2){const i=o[e],r=o[e+1],n=e+3,l=e+4;if("number"!=typeof i)return t.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(a.length&&a[a.length-1][0]>=i)return t.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const c=t.parse(r,l,s);if(!c)return null;s=s||c.type,a.push([i,c])}return"number"===s.kind||"color"===s.kind||"array"===s.kind&&"number"===s.itemType.kind&&"number"==typeof s.N?new Interpolate(s,i,r,n,a):t.error(`Type ${Ot(s)} is not interpolatable.`)}evaluate(e){const t=this.labels,i=this.outputs;if(1===t.length)return i[0].evaluate(e);const r=this.input.evaluate(e);if(r<=t[0])return i[0].evaluate(e);const n=t.length;if(r>=t[n-1])return i[n-1].evaluate(e);const o=_r(t,r),a=Interpolate.interpolationFactor(this.interpolation,r,t[o],t[o+1]),s=i[o].evaluate(e),l=i[o+1].evaluate(e);return"interpolate"===this.operator?vr[this.type.kind.toLowerCase()](s,l,a):"interpolate-hcl"===this.operator?Or.reverse(Or.interpolate(Or.forward(s),Or.forward(l),a)):Br.reverse(Br.interpolate(Br.forward(s),Br.forward(l),a))}eachChild(e){e(this.input);for(const t of this.outputs)e(t)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))}serialize(){let e;e="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const t=[this.operator,e,this.input.serialize()];for(let e=0;e<this.labels.length;e++)t.push(this.labels[e],this.outputs[e].serialize());return t}}function Ur(e,t,i,r){const n=r-i,o=e-i;return 0===n?0:1===t?o/n:(Math.pow(t,o)-1)/(Math.pow(t,n)-1)}var Vr=Interpolate;class Coalesce{constructor(e,t){this.type=e,this.args=t}static parse(e,t){if(e.length<2)return t.error("Expectected at least one argument.");let i=null;const r=t.expectedType;r&&"value"!==r.kind&&(i=r);const n=[];for(const r of e.slice(1)){const e=t.parse(r,1+n.length,i,void 0,{typeAnnotation:"omit"});if(!e)return null;i=i||e.type,n.push(e)}const o=r&&n.some((e=>Ut(r,e.type)));return new Coalesce(o?Lt:i,n)}evaluate(e){let t,i=null,r=0;for(const n of this.args){if(r++,i=n.evaluate(e),i&&i instanceof ResolvedImage&&!i.available&&(t||(t=i),i=null,r===this.args.length))return t;if(null!==i)break}return i}eachChild(e){this.args.forEach(e)}outputDefined(){return this.args.every((e=>e.outputDefined()))}serialize(){const e=["coalesce"];return this.eachChild((t=>{e.push(t.serialize())})),e}}var Nr=Coalesce;class Let{constructor(e,t){this.type=t.type,this.bindings=[].concat(e),this.result=t}evaluate(e){return this.result.evaluate(e)}eachChild(e){for(const t of this.bindings)e(t[1]);e(this.result)}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found ${e.length-1} instead.`);const i=[];for(let r=1;r<e.length-1;r+=2){const n=e[r];if("string"!=typeof n)return t.error(`Expected string, but found ${typeof n} instead.`,r);if(/[^a-zA-Z0-9_]/.test(n))return t.error("Variable names must contain only alphanumeric characters or '_'.",r);const o=t.parse(e[r+1],r+1);if(!o)return null;i.push([n,o])}const r=t.parse(e[e.length-1],e.length-1,t.expectedType,i);return r?new Let(i,r):null}outputDefined(){return this.result.outputDefined()}serialize(){const e=["let"];for(const[t,i]of this.bindings)e.push(t,i.serialize());return e.push(this.result.serialize()),e}}var jr=Let;class At{constructor(e,t,i){this.type=e,this.index=t,this.input=i}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,St),r=t.parse(e[2],2,Bt(t.expectedType||Lt));return i&&r?new At(r.type.itemType,i,r):null}evaluate(e){const t=this.index.evaluate(e),i=this.input.evaluate(e);if(t<0)throw new ei(`Array index out of bounds: ${t} < 0.`);if(t>=i.length)throw new ei(`Array index out of bounds: ${t} > ${i.length-1}.`);if(t!==Math.floor(t))throw new ei(`Array index must be an integer, but found ${t} instead.`);return i[t]}eachChild(e){e(this.index),e(this.input)}outputDefined(){return!1}serialize(){return["at",this.index.serialize(),this.input.serialize()]}}var Gr=At;class In{constructor(e,t){this.type=It,this.needle=e,this.haystack=t}static parse(e,t){if(3!==e.length)return t.error(`Expected 2 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Lt),r=t.parse(e[2],2,Lt);return i&&r?Vt(i.type,[It,Ct,St,Mt,Lt])?new In(i,r):t.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ot(i.type)} instead`):null}evaluate(e){const t=this.needle.evaluate(e),i=this.haystack.evaluate(e);if(null==i)return!1;if(!Nt(t,["boolean","string","number","null"]))throw new ei(`Expected first argument to be of type boolean, string, number or null, but found ${Ot(Kt(t))} instead.`);if(!Nt(i,["string","array"]))throw new ei(`Expected second argument to be of type array or string, but found ${Ot(Kt(i))} instead.`);return i.indexOf(t)>=0}eachChild(e){e(this.needle),e(this.haystack)}outputDefined(){return!0}serialize(){return["in",this.needle.serialize(),this.haystack.serialize()]}}var qr=In;class IndexOf{constructor(e,t,i){this.type=St,this.needle=e,this.haystack=t,this.fromIndex=i}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 3 or 4 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Lt),r=t.parse(e[2],2,Lt);if(!i||!r)return null;if(!Vt(i.type,[It,Ct,St,Mt,Lt]))return t.error(`Expected first argument to be of type boolean, string, number or null, but found ${Ot(i.type)} instead`);if(4===e.length){const n=t.parse(e[3],3,St);return n?new IndexOf(i,r,n):null}return new IndexOf(i,r)}evaluate(e){const t=this.needle.evaluate(e),i=this.haystack.evaluate(e);if(!Nt(t,["boolean","string","number","null"]))throw new ei(`Expected first argument to be of type boolean, string, number or null, but found ${Ot(Kt(t))} instead.`);if(!Nt(i,["string","array"]))throw new ei(`Expected second argument to be of type array or string, but found ${Ot(Kt(i))} instead.`);if(this.fromIndex){const r=this.fromIndex.evaluate(e);return i.indexOf(t,r)}return i.indexOf(t)}eachChild(e){e(this.needle),e(this.haystack),this.fromIndex&&e(this.fromIndex)}outputDefined(){return!1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const e=this.fromIndex.serialize();return["index-of",this.needle.serialize(),this.haystack.serialize(),e]}return["index-of",this.needle.serialize(),this.haystack.serialize()]}}var Zr=IndexOf;class Match{constructor(e,t,i,r,n,o){this.inputType=e,this.type=t,this.input=i,this.cases=r,this.outputs=n,this.otherwise=o}static parse(e,t){if(e.length<5)return t.error(`Expected at least 4 arguments, but found only ${e.length-1}.`);if(e.length%2!=1)return t.error("Expected an even number of arguments.");let i,r;t.expectedType&&"value"!==t.expectedType.kind&&(r=t.expectedType);const n={},o=[];for(let a=2;a<e.length-1;a+=2){let s=e[a];const l=e[a+1];Array.isArray(s)||(s=[s]);const c=t.concat(a);if(0===s.length)return c.error("Expected at least one branch label.");for(const e of s){if("number"!=typeof e&&"string"!=typeof e)return c.error("Branch labels must be numbers or strings.");if("number"==typeof e&&Math.abs(e)>Number.MAX_SAFE_INTEGER)return c.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof e&&Math.floor(e)!==e)return c.error("Numeric branch labels must be integer values.");if(i){if(c.checkSubtype(i,Kt(e)))return null}else i=Kt(e);if(void 0!==n[String(e)])return c.error("Branch labels must be unique.");n[String(e)]=o.length}const u=t.parse(l,a,r);if(!u)return null;r=r||u.type,o.push(u)}const a=t.parse(e[1],1,Lt);if(!a)return null;const s=t.parse(e[e.length-1],e.length-1,r);return s?"value"!==a.type.kind&&t.concat(1).checkSubtype(i,a.type)?null:new Match(i,r,a,n,o,s):null}evaluate(e){const t=this.input.evaluate(e);return(Kt(t)===this.inputType&&this.outputs[this.cases[t]]||this.otherwise).evaluate(e)}eachChild(e){e(this.input),this.outputs.forEach(e),e(this.otherwise)}outputDefined(){return this.outputs.every((e=>e.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const e=["match",this.input.serialize()],t=Object.keys(this.cases).sort(),i=[],r={};for(const e of t){const t=r[this.cases[e]];void 0===t?(r[this.cases[e]]=i.length,i.push([this.cases[e],[e]])):i[t][1].push(e)}const n=e=>"number"===this.inputType.kind?Number(e):e;for(const[t,r]of i)e.push(1===r.length?n(r[0]):r.map(n)),e.push(this.outputs[t].serialize());return e.push(this.otherwise.serialize()),e}}var $r=Match;class Case{constructor(e,t,i){this.type=e,this.branches=t,this.otherwise=i}static parse(e,t){if(e.length<4)return t.error(`Expected at least 3 arguments, but found only ${e.length-1}.`);if(e.length%2!=0)return t.error("Expected an odd number of arguments.");let i;t.expectedType&&"value"!==t.expectedType.kind&&(i=t.expectedType);const r=[];for(let n=1;n<e.length-1;n+=2){const o=t.parse(e[n],n,It);if(!o)return null;const a=t.parse(e[n+1],n+1,i);if(!a)return null;r.push([o,a]),i=i||a.type}const n=t.parse(e[e.length-1],e.length-1,i);return n?new Case(i,r,n):null}evaluate(e){for(const[t,i]of this.branches)if(t.evaluate(e))return i.evaluate(e);return this.otherwise.evaluate(e)}eachChild(e){for(const[t,i]of this.branches)e(t),e(i);e(this.otherwise)}outputDefined(){return this.branches.every((([e,t])=>t.outputDefined()))&&this.otherwise.outputDefined()}serialize(){const e=["case"];return this.eachChild((t=>{e.push(t.serialize())})),e}}var Hr=Case;class Slice{constructor(e,t,i,r){this.type=e,this.input=t,this.beginIndex=i,this.endIndex=r}static parse(e,t){if(e.length<=2||e.length>=5)return t.error(`Expected 3 or 4 arguments, but found ${e.length-1} instead.`);const i=t.parse(e[1],1,Lt),r=t.parse(e[2],2,St);if(!i||!r)return null;if(!Vt(i.type,[Bt(Lt),Ct,Lt]))return t.error(`Expected first argument to be of type array or string, but found ${Ot(i.type)} instead`);if(4===e.length){const n=t.parse(e[3],3,St);return n?new Slice(i.type,i,r,n):null}return new Slice(i.type,i,r)}evaluate(e){const t=this.input.evaluate(e),i=this.beginIndex.evaluate(e);if(!Nt(t,["string","array"]))throw new ei(`Expected first argument to be of type array or string, but found ${Ot(Kt(t))} instead.`);if(this.endIndex){const r=this.endIndex.evaluate(e);return t.slice(i,r)}return t.slice(i)}eachChild(e){e(this.input),e(this.beginIndex),this.endIndex&&e(this.endIndex)}outputDefined(){return!1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const e=this.endIndex.serialize();return["slice",this.input.serialize(),this.beginIndex.serialize(),e]}return["slice",this.input.serialize(),this.beginIndex.serialize()]}}var Wr=Slice;function Xr(e,t){return"=="===e||"!="===e?"boolean"===t.kind||"string"===t.kind||"number"===t.kind||"null"===t.kind||"value"===t.kind:"string"===t.kind||"number"===t.kind||"value"===t.kind}function Yr(e,t,i,r){return 0===r.compare(t,i)}function Kr(e,t,i){const r="=="!==e&&"!="!==e;return class Comparison{constructor(e,t,i){this.type=It,this.lhs=e,this.rhs=t,this.collator=i,this.hasUntypedArgument="value"===e.type.kind||"value"===t.type.kind}static parse(e,t){if(3!==e.length&&4!==e.length)return t.error("Expected two or three arguments.");const i=e[0];let n=t.parse(e[1],1,Lt);if(!n)return null;if(!Xr(i,n.type))return t.concat(1).error(`"${i}" comparisons are not supported for type '${Ot(n.type)}'.`);let o=t.parse(e[2],2,Lt);if(!o)return null;if(!Xr(i,o.type))return t.concat(2).error(`"${i}" comparisons are not supported for type '${Ot(o.type)}'.`);if(n.type.kind!==o.type.kind&&"value"!==n.type.kind&&"value"!==o.type.kind)return t.error(`Cannot compare types '${Ot(n.type)}' and '${Ot(o.type)}'.`);r&&("value"===n.type.kind&&"value"!==o.type.kind?n=new ii(o.type,[n]):"value"!==n.type.kind&&"value"===o.type.kind&&(o=new ii(n.type,[o])));let a=null;if(4===e.length){if("string"!==n.type.kind&&"string"!==o.type.kind&&"value"!==n.type.kind&&"value"!==o.type.kind)return t.error("Cannot use collator to compare non-string types.");if(a=t.parse(e[3],3,zt),!a)return null}return new Comparison(n,o,a)}evaluate(n){const o=this.lhs.evaluate(n),a=this.rhs.evaluate(n);if(r&&this.hasUntypedArgument){const t=Kt(o),i=Kt(a);if(t.kind!==i.kind||"string"!==t.kind&&"number"!==t.kind)throw new ei(`Expected arguments for "${e}" to be (string, string) or (number, number), but found (${t.kind}, ${i.kind}) instead.`)}if(this.collator&&!r&&this.hasUntypedArgument){const e=Kt(o),i=Kt(a);if("string"!==e.kind||"string"!==i.kind)return t(n,o,a)}return this.collator?i(n,o,a,this.collator.evaluate(n)):t(n,o,a)}eachChild(e){e(this.lhs),e(this.rhs),this.collator&&e(this.collator)}outputDefined(){return!0}serialize(){const t=[e];return this.eachChild((e=>{t.push(e.serialize())})),t}}}const Jr=Kr("==",(function(e,t,i){return t===i}),Yr),Qr=Kr("!=",(function(e,t,i){return t!==i}),(function(e,t,i,r){return!Yr(0,t,i,r)})),en=Kr("<",(function(e,t,i){return t<i}),(function(e,t,i,r){return r.compare(t,i)<0})),tn=Kr(">",(function(e,t,i){return t>i}),(function(e,t,i,r){return r.compare(t,i)>0})),rn=Kr("<=",(function(e,t,i){return t<=i}),(function(e,t,i,r){return r.compare(t,i)<=0})),nn=Kr(">=",(function(e,t,i){return t>=i}),(function(e,t,i,r){return r.compare(t,i)>=0}));class NumberFormat{constructor(e,t,i,r,n,o){this.type=Ct,this.number=e,this.locale=t,this.currency=i,this.unit=r,this.minFractionDigits=n,this.maxFractionDigits=o}static parse(e,t){if(3!==e.length)return t.error("Expected two arguments.");const i=t.parse(e[1],1,St);if(!i)return null;const r=e[2];if("object"!=typeof r||Array.isArray(r))return t.error("NumberFormat options argument must be an object.");let n=null;if(r.locale&&(n=t.parse(r.locale,1,Ct),!n))return null;let o=null;if(r.currency&&(o=t.parse(r.currency,1,Ct),!o))return null;let a=null;if(r.unit&&(a=t.parse(r.unit,1,Ct),!a))return null;let s=null;if(r["min-fraction-digits"]&&(s=t.parse(r["min-fraction-digits"],1,St),!s))return null;let l=null;return r["max-fraction-digits"]&&(l=t.parse(r["max-fraction-digits"],1,St),!l)?null:new NumberFormat(i,n,o,a,s,l)}evaluate(e){return new Intl.NumberFormat(this.locale?this.locale.evaluate(e):[],{style:(this.currency?"currency":this.unit&&"unit")||"decimal",currency:this.currency?this.currency.evaluate(e):void 0,unit:this.unit?this.unit.evaluate(e):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(e):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(e):void 0}).format(this.number.evaluate(e))}eachChild(e){e(this.number),this.locale&&e(this.locale),this.currency&&e(this.currency),this.unit&&e(this.unit),this.minFractionDigits&&e(this.minFractionDigits),this.maxFractionDigits&&e(this.maxFractionDigits)}outputDefined(){return!1}serialize(){const e={};return this.locale&&(e.locale=this.locale.serialize()),this.currency&&(e.currency=this.currency.serialize()),this.unit&&(e.unit=this.unit.serialize()),this.minFractionDigits&&(e["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(e["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),e]}}class Length{constructor(e){this.type=St,this.input=e}static parse(e,t){if(2!==e.length)return t.error(`Expected 1 argument, but found ${e.length-1} instead.`);const i=t.parse(e[1],1);return i?"array"!==i.type.kind&&"string"!==i.type.kind&&"value"!==i.type.kind?t.error(`Expected argument of type string or array, but found ${Ot(i.type)} instead.`):new Length(i):null}evaluate(e){const t=this.input.evaluate(e);if("string"==typeof t)return t.length;if(Array.isArray(t))return t.length;throw new ei(`Expected value to be of type string or array, but found ${Ot(Kt(t))} instead.`)}eachChild(e){e(this.input)}outputDefined(){return!1}serialize(){const e=["length"];return this.eachChild((t=>{e.push(t.serialize())})),e}}function on(e){return function(){e=1831565813+(e|=0)|0;let t=Math.imul(e^e>>>15,1|e);return t=t+Math.imul(t^t>>>7,61|t)^t,((t^t>>>14)>>>0)/4294967296}}const an={"==":Jr,"!=":Qr,">":tn,"<":en,">=":nn,"<=":rn,array:ii,at:Gr,boolean:ii,case:Hr,coalesce:Nr,collator:CollatorExpression,format:FormatExpression,image:ImageExpression,in:qr,"index-of":Zr,interpolate:Vr,"interpolate-hcl":Vr,"interpolate-lab":Vr,length:Length,let:jr,literal:Qt,match:$r,number:ii,"number-format":NumberFormat,object:ii,slice:Wr,step:gr,string:ii,"to-boolean":oi,"to-color":oi,"to-number":oi,"to-string":oi,var:pr,within:Ii,distance:lr};function sn(e,[t,i,r,n]){t=t.evaluate(e),i=i.evaluate(e),r=r.evaluate(e);const o=n?n.evaluate(e):1,a=Xt(t,i,r,o);if(a)throw new ei(a);return new Wt(t/255*o,i/255*o,r/255*o,o)}function ln(e,[t,i,r,n]){t=t.evaluate(e),i=i.evaluate(e),r=r.evaluate(e);const o=n?n.evaluate(e):1,a=function(e,t,i,r){return"number"==typeof e&&e>=0&&e<=360?"number"==typeof t&&t>=0&&t<=100&&"number"==typeof i&&i>=0&&i<=100?void 0===r||"number"==typeof r&&r>=0&&r<=1?null:`Invalid hsla value [${[e,t,i,r].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid hsla value [${("number"==typeof r?[e,t,i,r]:[e,t,i]).join(", ")}]: 's', and 'l' must be between 0 and 100.`:`Invalid hsla value [${("number"==typeof r?[e,t,i,r]:[e,t,i]).join(", ")}]: 'h' must be between 0 and 360.`}(t,i,r,o);if(a)throw new ei(a);const s=`hsla(${t}, ${i}%, ${r}%, ${o})`,l=Wt.parse(s);if(!l)throw new ei(`Failed to parse HSLA color: ${s}`);return l}function cn(e,t){return e in t}function un(e,t){const i=t[e];return void 0===i?null:i}function hn(e,t,i){i.length&&(t+=`${i}`);const r=e.getConfig(t);return r?r.evaluate(e):null}function dn(e){return{type:e}}li.register(an,{error:[{kind:"error"},[Ct],(e,[t])=>{throw new ei(t.evaluate(e))}],typeof:[Ct,[Lt],(e,[t])=>Ot(Kt(t.evaluate(e)))],"to-rgba":[Bt(St,4),[Dt],(e,[t])=>t.evaluate(e).toArray()],rgb:[Dt,[St,St,St],sn],rgba:[Dt,[St,St,St,St],sn],hsl:[Dt,[St,St,St],ln],hsla:[Dt,[St,St,St,St],ln],has:{type:It,overloads:[[[Ct],(e,[t])=>cn(t.evaluate(e),e.properties())],[[Ct,Pt],(e,[t,i])=>cn(t.evaluate(e),i.evaluate(e))]]},get:{type:Lt,overloads:[[[Ct],(e,[t])=>un(t.evaluate(e),e.properties())],[[Ct,Pt],(e,[t,i])=>un(t.evaluate(e),i.evaluate(e))]]},config:{type:Lt,overloads:[[[Ct],(e,[t])=>hn(e,t.evaluate(e),"")],[[Ct,Ct],(e,[t,i])=>hn(e,t.evaluate(e),i.evaluate(e))]]},"feature-state":[Lt,[Ct],(e,[t])=>un(t.evaluate(e),e.featureState||{})],properties:[Pt,[],e=>e.properties()],"geometry-type":[Ct,[],e=>e.geometryType()],id:[Lt,[],e=>e.id()],zoom:[St,[],e=>e.globals.zoom],pitch:[St,[],e=>e.globals.pitch||0],"distance-from-center":[St,[],e=>e.distanceFromCenter()],"measure-light":[St,[Ct],(e,[t])=>e.measureLight(t.evaluate(e))],"heatmap-density":[St,[],e=>e.globals.heatmapDensity||0],"line-progress":[St,[],e=>e.globals.lineProgress||0],"raster-value":[St,[],e=>e.globals.rasterValue||0],"sky-radial-progress":[St,[],e=>e.globals.skyRadialProgress||0],accumulated:[Lt,[],e=>void 0===e.globals.accumulated?null:e.globals.accumulated],"+":[St,dn(St),(e,t)=>{let i=0;for(const r of t)i+=r.evaluate(e);return i}],"*":[St,dn(St),(e,t)=>{let i=1;for(const r of t)i*=r.evaluate(e);return i}],"-":{type:St,overloads:[[[St,St],(e,[t,i])=>t.evaluate(e)-i.evaluate(e)],[[St],(e,[t])=>-t.evaluate(e)]]},"/":[St,[St,St],(e,[t,i])=>t.evaluate(e)/i.evaluate(e)],"%":[St,[St,St],(e,[t,i])=>t.evaluate(e)%i.evaluate(e)],ln2:[St,[],()=>Math.LN2],pi:[St,[],()=>Math.PI],e:[St,[],()=>Math.E],"^":[St,[St,St],(e,[t,i])=>Math.pow(t.evaluate(e),i.evaluate(e))],sqrt:[St,[St],(e,[t])=>Math.sqrt(t.evaluate(e))],log10:[St,[St],(e,[t])=>Math.log(t.evaluate(e))/Math.LN10],ln:[St,[St],(e,[t])=>Math.log(t.evaluate(e))],log2:[St,[St],(e,[t])=>Math.log(t.evaluate(e))/Math.LN2],sin:[St,[St],(e,[t])=>Math.sin(t.evaluate(e))],cos:[St,[St],(e,[t])=>Math.cos(t.evaluate(e))],tan:[St,[St],(e,[t])=>Math.tan(t.evaluate(e))],asin:[St,[St],(e,[t])=>Math.asin(t.evaluate(e))],acos:[St,[St],(e,[t])=>Math.acos(t.evaluate(e))],atan:[St,[St],(e,[t])=>Math.atan(t.evaluate(e))],min:[St,dn(St),(e,t)=>Math.min(...t.map((t=>t.evaluate(e))))],max:[St,dn(St),(e,t)=>Math.max(...t.map((t=>t.evaluate(e))))],abs:[St,[St],(e,[t])=>Math.abs(t.evaluate(e))],round:[St,[St],(e,[t])=>{const i=t.evaluate(e);return i<0?-Math.round(-i):Math.round(i)}],floor:[St,[St],(e,[t])=>Math.floor(t.evaluate(e))],ceil:[St,[St],(e,[t])=>Math.ceil(t.evaluate(e))],"filter-==":[It,[Ct,Lt],(e,[t,i])=>e.properties()[t.value]===i.value],"filter-id-==":[It,[Lt],(e,[t])=>e.id()===t.value],"filter-type-==":[It,[Ct],(e,[t])=>e.geometryType()===t.value],"filter-<":[It,[Ct,Lt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r<n}],"filter-id-<":[It,[Lt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i<r}],"filter->":[It,[Ct,Lt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r>n}],"filter-id->":[It,[Lt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i>r}],"filter-<=":[It,[Ct,Lt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r<=n}],"filter-id-<=":[It,[Lt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i<=r}],"filter->=":[It,[Ct,Lt],(e,[t,i])=>{const r=e.properties()[t.value],n=i.value;return typeof r==typeof n&&r>=n}],"filter-id->=":[It,[Lt],(e,[t])=>{const i=e.id(),r=t.value;return typeof i==typeof r&&i>=r}],"filter-has":[It,[Lt],(e,[t])=>t.value in e.properties()],"filter-has-id":[It,[],e=>null!==e.id()&&void 0!==e.id()],"filter-type-in":[It,[Bt(Ct)],(e,[t])=>t.value.indexOf(e.geometryType())>=0],"filter-id-in":[It,[Bt(Lt)],(e,[t])=>t.value.indexOf(e.id())>=0],"filter-in-small":[It,[Ct,Bt(Lt)],(e,[t,i])=>i.value.indexOf(e.properties()[t.value])>=0],"filter-in-large":[It,[Ct,Bt(Lt)],(e,[t,i])=>function(e,t,i,r){for(;i<=r;){const n=i+r>>1;if(t[n]===e)return!0;t[n]>e?r=n-1:i=n+1}return!1}(e.properties()[t.value],i.value,0,i.value.length-1)],all:{type:It,overloads:[[[It,It],(e,[t,i])=>t.evaluate(e)&&i.evaluate(e)],[dn(It),(e,t)=>{for(const i of t)if(!i.evaluate(e))return!1;return!0}]]},any:{type:It,overloads:[[[It,It],(e,[t,i])=>t.evaluate(e)||i.evaluate(e)],[dn(It),(e,t)=>{for(const i of t)if(i.evaluate(e))return!0;return!1}]]},"!":[It,[It],(e,[t])=>!t.evaluate(e)],"is-supported-script":[It,[Ct],(e,[t])=>{const i=e.globals&&e.globals.isSupportedScript;return!i||i(t.evaluate(e))}],upcase:[Ct,[Ct],(e,[t])=>t.evaluate(e).toUpperCase()],downcase:[Ct,[Ct],(e,[t])=>t.evaluate(e).toLowerCase()],concat:[Ct,dn(Lt),(e,t)=>t.map((t=>Jt(t.evaluate(e)))).join("")],"resolved-locale":[Ct,[zt],(e,[t])=>t.evaluate(e).resolvedLocale()],random:[St,[St,St,Lt],(e,t)=>{const[i,r,n]=t.map((t=>t.evaluate(e)));if(i>r)return i;if(i===r)return i;let o;if("string"==typeof n)o=function(e){let t=0;if(0===e.length)return t;for(let i=0;i<e.length;i++)t=(t<<5)-t+e.charCodeAt(i),t&=t;return t}(n);else{if("number"!=typeof n)throw new ei(`Invalid seed input: ${n}`);o=n}return i+on(o)()*(r-i)}]});var pn=an;function fn(e){return{result:"success",value:e}}function mn(e){return{result:"error",value:e}}function _n(e,t){return!!e&&!!e.parameters&&e.parameters.indexOf(t)>-1}function gn(e){return"data-driven"===e["property-type"]}function yn(e){return _n(e.expression,"measure-light")}function xn(e){return _n(e.expression,"zoom")}function vn(e){return!!e.expression&&e.expression.interpolated}function bn(e){return"object"==typeof e&&null!==e&&!Array.isArray(e)}function wn(e){return e}function Tn(e,t){const i="color"===t.type,r=e.stops&&"object"==typeof e.stops[0][0],n=r||!(r||void 0!==e.property),o=e.type||(vn(t)?"exponential":"interval");if(i&&((e=vt({},e)).stops&&(e.stops=e.stops.map((e=>[e[0],Wt.parse(e[1])]))),e.default=Wt.parse(e.default?e.default:t.default)),e.colorSpace&&"rgb"!==e.colorSpace&&!Fr[e.colorSpace])throw new Error(`Unknown color space: ${e.colorSpace}`);let a,s,l;if("exponential"===o)a=An;else if("interval"===o)a=Sn;else if("categorical"===o){a=Mn,s=Object.create(null);for(const t of e.stops)s[t[0]]=t[1];l=typeof e.stops[0][0]}else{if("identity"!==o)throw new Error(`Unknown function type "${o}"`);a=Cn}if(r){const i={},r=[];for(let t=0;t<e.stops.length;t++){const n=e.stops[t],o=n[0].zoom;void 0===i[o]&&(i[o]={zoom:o,type:e.type,property:e.property,default:e.default,stops:[]},r.push(o)),i[o].stops.push([n[0].value,n[1]])}const n=[];for(const e of r)n.push([i[e].zoom,Tn(i[e],t)]);const o={name:"linear"};return{kind:"composite",interpolationType:o,interpolationFactor:Vr.interpolationFactor.bind(void 0,o),zoomStops:n.map((e=>e[0])),evaluate:({zoom:i},r)=>An({stops:n,base:e.base},t,i).evaluate(i,r)}}if(n){const i="exponential"===o?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return{kind:"camera",interpolationType:i,interpolationFactor:Vr.interpolationFactor.bind(void 0,i),zoomStops:e.stops.map((e=>e[0])),evaluate:({zoom:i})=>a(e,t,i,s,l)}}return{kind:"source",evaluate(i,r){const n=r&&r.properties?r.properties[e.property]:void 0;return void 0===n?En(e.default,t.default):a(e,t,n,s,l)}}}function En(e,t,i){return void 0!==e?e:void 0!==t?t:void 0!==i?i:void 0}function Mn(e,t,i,r,n){return En(typeof i===n?r[i]:void 0,e.default,t.default)}function Sn(e,t,i){if("number"!==ri(i))return En(e.default,t.default);const r=e.stops.length;if(1===r)return e.stops[0][1];if(i<=e.stops[0][0])return e.stops[0][1];if(i>=e.stops[r-1][0])return e.stops[r-1][1];const n=_r(e.stops.map((e=>e[0])),i);return e.stops[n][1]}function An(e,t,i){const r=void 0!==e.base?e.base:1;if("number"!==ri(i))return En(e.default,t.default);const n=e.stops.length;if(1===n)return e.stops[0][1];if(i<=e.stops[0][0])return e.stops[0][1];if(i>=e.stops[n-1][0])return e.stops[n-1][1];const o=_r(e.stops.map((e=>e[0])),i),a=function(e,t,i,r){const n=r-i,o=e-i;return 0===n?0:1===t?o/n:(Math.pow(t,o)-1)/(Math.pow(t,n)-1)}(i,r,e.stops[o][0],e.stops[o+1][0]),s=e.stops[o][1],l=e.stops[o+1][1];let c=vr[t.type]||wn;if(e.colorSpace&&"rgb"!==e.colorSpace){const t=Fr[e.colorSpace];c=(e,i)=>t.reverse(t.interpolate(t.forward(e),t.forward(i),a))}return"function"==typeof s.evaluate?{evaluate(...e){const t=s.evaluate.apply(void 0,e),i=l.evaluate.apply(void 0,e);if(void 0!==t&&void 0!==i)return c(t,i,a)}}:c(s,l,a)}function Cn(e,t,i){return"color"===t.type?i=Wt.parse(i):"formatted"===t.type?i=Formatted.fromString(i.toString()):"resolvedImage"===t.type?i=ResolvedImage.fromString(i.toString()):ri(i)===t.type||"enum"===t.type&&t.values[i]||(i=void 0),En(i,e.default,t.default)}class StyleExpression{constructor(e,t,i){this.expression=e,this._warningHistory={},this._evaluator=new si(i),this._defaultValue=t?function(e){return"color"===e.type&&(bn(e.default)||Array.isArray(e.default))?new Wt(0,0,0,0):"color"===e.type?Wt.parse(e.default)||null:void 0===e.default?null:e.default}(t):null,this._enumValues=t&&"enum"===t.type?t.values:null}evaluateWithoutErrorHandling(e,t,i,r,n,o,a,s){return this._evaluator.globals=e,this._evaluator.feature=t,this._evaluator.featureState=i,this._evaluator.canonical=r||null,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=o,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=s||null,this.expression.evaluate(this._evaluator)}evaluate(e,t,i,r,n,o,a,s){this._evaluator.globals=e,this._evaluator.feature=t||null,this._evaluator.featureState=i||null,this._evaluator.canonical=r||null,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=o||null,this._evaluator.featureTileCoord=a||null,this._evaluator.featureDistanceData=s||null;try{const e=this.expression.evaluate(this._evaluator);if(null==e||"number"==typeof e&&e!=e)return this._defaultValue;if(this._enumValues&&!(e in this._enumValues))throw new ei(`Expected value to be one of ${Object.keys(this._enumValues).map((e=>JSON.stringify(e))).join(", ")}, but found ${JSON.stringify(e)} instead.`);return e}catch(e){return this._warningHistory[e.message]||(this._warningHistory[e.message]=!0,"undefined"!=typeof console&&console.warn(e.message)),this._defaultValue}}}function Dn(e){return Array.isArray(e)&&e.length>0&&"string"==typeof e[0]&&e[0]in pn}function Pn(e,t,i){const r=new fr(pn,[],t?function(e){const t={color:Dt,string:Ct,number:St,enum:Ct,boolean:It,formatted:Rt,resolvedImage:kt};return"array"===e.type?Bt(t[e.value]||Lt,e.length):t[e.type]}(t):void 0,void 0,void 0,i),n=r.parse(e,void 0,void 0,void 0,t&&"string"===t.type?{typeAnnotation:"coerce"}:void 0);return n?fn(new StyleExpression(n,t,i)):mn(r.errors)}class ZoomConstantExpression{constructor(e,t,i){this.kind=e,this._styleExpression=t,this.isLightConstant=i,this.isStateDependent="constant"!==e&&!ur(t.expression),this.isConfigDependent=!hr(t.expression)}evaluateWithoutErrorHandling(e,t,i,r,n,o){return this._styleExpression.evaluateWithoutErrorHandling(e,t,i,r,n,o)}evaluate(e,t,i,r,n,o){return this._styleExpression.evaluate(e,t,i,r,n,o)}}class ZoomDependentExpression{constructor(e,t,i,r,n){this.kind=e,this.zoomStops=i,this._styleExpression=t,this.isStateDependent="camera"!==e&&!ur(t.expression),this.isLightConstant=n,this.isConfigDependent=!hr(t.expression),this.interpolationType=r}evaluateWithoutErrorHandling(e,t,i,r,n,o){return this._styleExpression.evaluateWithoutErrorHandling(e,t,i,r,n,o)}evaluate(e,t,i,r,n,o){return this._styleExpression.evaluate(e,t,i,r,n,o)}interpolationFactor(e,t,i){return this.interpolationType?Vr.interpolationFactor(this.interpolationType,e,t,i):0}}function Ln(e,t,i){if("error"===(e=Pn(e,t,i)).result)return e;const r=e.value.expression,n=cr(r);if(!n&&!gn(t))return mn([new Tt("","data expressions not supported")]);const o=dr(r,["zoom","pitch","distance-from-center"]);if(!o&&!xn(t))return mn([new Tt("","zoom expressions not supported")]);const a=dr(r,["measure-light"]);if(!a&&!yn(t))return mn([new Tt("","measure-light expression not supported")]);const s=t.expression&&t.expression.relaxZoomRestriction,l=zn(r);return l||o||s?l instanceof Tt?mn([l]):l instanceof Vr&&!vn(t)?mn([new Tt("",'"interpolate" expressions cannot be used with this property')]):fn(l?new ZoomDependentExpression(n?"camera":"composite",e.value,l.labels,l instanceof Vr?l.interpolation:void 0,a):new ZoomConstantExpression(n?"constant":"source",e.value,a)):mn([new Tt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression, or in the properties of atmosphere.')])}class StylePropertyFunction{constructor(e,t){this._parameters=e,this._specification=t,vt(this,Tn(this._parameters,this._specification))}static deserialize(e){return new StylePropertyFunction(e._parameters,e._specification)}static serialize(e){return{_parameters:e._parameters,_specification:e._specification}}}function zn(e){let t=null;if(e instanceof jr)t=zn(e.result);else if(e instanceof Nr){for(const i of e.args)if(t=zn(i),t)break}else(e instanceof gr||e instanceof Vr)&&e.input instanceof li&&"zoom"===e.input.name&&(t=e);return t instanceof Tt||e.eachChild((e=>{const i=zn(e);i instanceof Tt?t=i:t&&i&&t!==i&&(t=new Tt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'))})),t}function Rn(e){const t=e.key,i=e.value,r=e.valueSpec||{},n=e.objectElementValidators||{},o=e.style,a=e.styleSpec;let s=[];const l=ri(i);if("object"!==l)return[new ValidationError(t,i,`object expected, ${l} found`)];for(const e in i){const l=e.split(".")[0];let c;n[l]?c=n[l]:r[l]?c=go:n["*"]?c=n["*"]:r["*"]&&(c=go),c?s=s.concat(c({key:(t?`${t}.`:t)+e,value:i[e],valueSpec:r[l]||r["*"],style:o,styleSpec:a,object:i,objectKey:e},i)):s.push(new ValidationWarning(t,i[e],`unknown property "${e}"`))}for(const e in r)n[e]||r[e].required&&void 0===r[e].default&&void 0===i[e]&&s.push(new ValidationError(t,i,`missing required property "${e}"`));return s}function kn(e){const t=e.value,i=e.valueSpec,r=e.style,n=e.styleSpec,o=e.key,a=e.arrayElementValidator||go;if("array"!==ri(t))return[new ValidationError(o,t,`array expected, ${ri(t)} found`)];if(i.length&&t.length!==i.length)return[new ValidationError(o,t,`array length ${i.length} expected, length ${t.length} found`)];if(i["min-length"]&&t.length<i["min-length"])return[new ValidationError(o,t,`array length at least ${i["min-length"]} expected, length ${t.length} found`)];let s={type:i.value,values:i.values,minimum:i.minimum,maximum:i.maximum,function:void 0};n.$version<7&&(s.function=i.function),"object"===ri(i.value)&&(s=i.value);let l=[];for(let e=0;e<t.length;e++)l=l.concat(a({array:t,arrayIndex:e,value:t[e],valueSpec:s,style:r,styleSpec:n,key:`${o}[${e}]`},!0));return l}function Bn(e){const t=e.key,i=e.value,r=e.valueSpec;let n=ri(i);if("number"===n&&i!=i&&(n="NaN"),"number"!==n)return[new ValidationError(t,i,`number expected, ${n} found`)];if("minimum"in r){let n=r.minimum;if("array"===ri(r.minimum)&&(n=r.minimum[e.arrayIndex]),i<n)return[new ValidationError(t,i,`${i} is less than the minimum value ${n}`)]}if("maximum"in r){let n=r.maximum;if("array"===ri(r.maximum)&&(n=r.maximum[e.arrayIndex]),i>n)return[new ValidationError(t,i,`${i} is greater than the maximum value ${n}`)]}return[]}function On(e){const t=e.valueSpec,i=bt(e.value.type);let r,n,o,a={};const s="categorical"!==i&&void 0===e.value.property,l=!s,c="array"===ri(e.value.stops)&&"array"===ri(e.value.stops[0])&&"object"===ri(e.value.stops[0][0]),u=Rn({key:e.key,value:e.value,valueSpec:e.styleSpec.function,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{stops:function(e){if("identity"===i)return[new ValidationError(e.key,e.value,'identity function may not have a "stops" property')];let t=[];const r=e.value;return t=t.concat(kn({key:e.key,value:r,valueSpec:e.valueSpec,style:e.style,styleSpec:e.styleSpec,arrayElementValidator:h})),"array"===ri(r)&&0===r.length&&t.push(new ValidationError(e.key,r,"array must have at least one stop")),t},default:function(e){return go({key:e.key,value:e.value,valueSpec:t,style:e.style,styleSpec:e.styleSpec})}}});return"identity"===i&&s&&u.push(new ValidationError(e.key,e.value,'missing required property "property"')),"identity"===i||e.value.stops||u.push(new ValidationError(e.key,e.value,'missing required property "stops"')),"exponential"===i&&e.valueSpec.expression&&!vn(e.valueSpec)&&u.push(new ValidationError(e.key,e.value,"exponential functions not supported")),e.styleSpec.$version>=8&&(l&&!gn(e.valueSpec)?u.push(new ValidationError(e.key,e.value,"property functions not supported")):s&&!xn(e.valueSpec)&&u.push(new ValidationError(e.key,e.value,"zoom functions not supported"))),"categorical"!==i&&!c||void 0!==e.value.property||u.push(new ValidationError(e.key,e.value,'"property" property is required')),u;function h(e){let i=[];const r=e.value,s=e.key;if("array"!==ri(r))return[new ValidationError(s,r,`array expected, ${ri(r)} found`)];if(2!==r.length)return[new ValidationError(s,r,`array length 2 expected, length ${r.length} found`)];if(c){if("object"!==ri(r[0]))return[new ValidationError(s,r,`object expected, ${ri(r[0])} found`)];if(void 0===r[0].zoom)return[new ValidationError(s,r,"object stop key must have zoom")];if(void 0===r[0].value)return[new ValidationError(s,r,"object stop key must have value")];const t=bt(r[0].zoom);if("number"!=typeof t)return[new ValidationError(s,r[0].zoom,"stop zoom values must be numbers")];if(o&&o>t)return[new ValidationError(s,r[0].zoom,"stop zoom values must appear in ascending order")];t!==o&&(o=t,n=void 0,a={}),i=i.concat(Rn({key:`${s}[0]`,value:r[0],valueSpec:{zoom:{}},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{zoom:Bn,value:d}}))}else i=i.concat(d({key:`${s}[0]`,value:r[0],valueSpec:{},style:e.style,styleSpec:e.styleSpec},r));return Dn(wt(r[1]))?i.concat([new ValidationError(`${s}[1]`,r[1],"expressions are not allowed in function stops.")]):i.concat(go({key:`${s}[1]`,value:r[1],valueSpec:t,style:e.style,styleSpec:e.styleSpec}))}function d(e,o){const s=ri(e.value),l=bt(e.value),c=null!==e.value?e.value:o;if(r){if(s!==r)return[new ValidationError(e.key,c,`${s} stop domain type must match previous stop domain type ${r}`)]}else r=s;if("number"!==s&&"string"!==s&&"boolean"!==s&&"number"!=typeof l&&"string"!=typeof l&&"boolean"!=typeof l)return[new ValidationError(e.key,c,"stop domain value must be a number, string, or boolean")];if("number"!==s&&"categorical"!==i){let r=`number expected, ${s} found`;return gn(t)&&void 0===i&&(r+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new ValidationError(e.key,c,r)]}return"categorical"!==i||"number"!==s||"number"==typeof l&&isFinite(l)&&Math.floor(l)===l?"categorical"!==i&&"number"===s&&"number"==typeof l&&"number"==typeof n&&void 0!==n&&l<n?[new ValidationError(e.key,c,"stop domain values must appear in ascending order")]:(n=l,"categorical"===i&&l in a?[new ValidationError(e.key,c,"stop domain values must be unique")]:(a[l]=!0,[])):[new ValidationError(e.key,c,`integer expected, found ${String(l)}`)]}}function Fn(e){const t=("property"===e.expressionContext?Ln:Pn)(wt(e.value),e.valueSpec);if("error"===t.result)return t.value.map((t=>new ValidationError(`${e.key}${t.key}`,e.value,t.message)));const i=t.value.expression||t.value._styleExpression.expression;if("property"===e.expressionContext&&"text-font"===e.propertyKey&&!i.outputDefined())return[new ValidationError(e.key,e.value,`Invalid data expression for "${e.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===e.expressionContext&&"layout"===e.propertyType&&!ur(i))return[new ValidationError(e.key,e.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===e.expressionContext)return Un(i,e);if(e.expressionContext&&0===e.expressionContext.indexOf("cluster")){if(!dr(i,["zoom","feature-state"]))return[new ValidationError(e.key,e.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===e.expressionContext&&!cr(i))return[new ValidationError(e.key,e.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return[]}function Un(e,t){const i=new Set(["zoom","feature-state","pitch","distance-from-center"]);if(t.valueSpec&&t.valueSpec.expression)for(const e of t.valueSpec.expression.parameters)i.delete(e);if(0===i.size)return[];const r=[];return e instanceof li&&i.has(e.name)?[new ValidationError(t.key,t.value,`["${e.name}"] expression is not supported in a filter for a ${t.object.type} layer with id: ${t.object.id}`)]:(e.eachChild((e=>{r.push(...Un(e,t))})),r)}function Vn(e){const t=e.key,i=e.value,r=e.valueSpec,n=[];return Array.isArray(r.values)?-1===r.values.indexOf(bt(i))&&n.push(new ValidationError(t,i,`expected one of [${r.values.join(", ")}], ${JSON.stringify(i)} found`)):-1===Object.keys(r.values).indexOf(bt(i))&&n.push(new ValidationError(t,i,`expected one of [${Object.keys(r.values).join(", ")}], ${JSON.stringify(i)} found`)),n}function Nn(e){if(!0===e||!1===e)return!0;if(!Array.isArray(e)||0===e.length)return!1;switch(e[0]){case"has":return e.length>=2&&"$id"!==e[1]&&"$type"!==e[1];case"in":return e.length>=3&&("string"!=typeof e[1]||Array.isArray(e[2]));case"!in":case"!has":case"none":return!1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==e.length||Array.isArray(e[1])||Array.isArray(e[2]);case"any":case"all":for(const t of e.slice(1))if(!Nn(t)&&"boolean"!=typeof t)return!1;return!0;default:return!0}}function jn(e,t="fill"){if(null==e)return{filter:()=>!0,needGeometry:!1,needFeature:!1};Nn(e)||(e=Xn(e));const i=e;let r=!0;try{r=function(e){if(!Zn(e))return e;let t=wt(e);return qn(t),t=Gn(t),t}(i)}catch(e){console.warn(`Failed to extract static filter. Filter will continue working, but at higher memory usage and slower framerate.\nThis is most likely a bug, please report this via https://github.com/mapbox/mapbox-gl-js/issues/new?assignees=&labels=&template=Bug_report.md\nand paste the contents of this message in the report.\nThank you!\nFilter Expression:\n${JSON.stringify(i,null,2)}\n        `)}const n=xt[`filter_${t}`],o=Pn(r,n);let a=null;if("error"===o.result)throw new Error(o.value.map((e=>`${e.key}: ${e.message}`)).join(", "));a=(e,t,i)=>o.value.evaluate(e,t,{},i);let s=null,l=null;if(r!==i){const e=Pn(i,n);if("error"===e.result)throw new Error(e.value.map((e=>`${e.key}: ${e.message}`)).join(", "));s=(t,i,r,n,o)=>e.value.evaluate(t,i,{},r,void 0,void 0,n,o),l=!cr(e.value.expression)}return{filter:a,dynamicFilter:s||void 0,needGeometry:Wn(r),needFeature:!!l}}function Gn(e){if(!Array.isArray(e))return e;const t=function(e){if($n.has(e[0]))for(let t=1;t<e.length;t++)if(Zn(e[t]))return!0;return e}(e);return!0===t?t:t.map((e=>Gn(e)))}function qn(e){let t=!1;const i=[];if("case"===e[0]){for(let r=1;r<e.length-1;r+=2)t=t||Zn(e[r]),i.push(e[r+1]);i.push(e[e.length-1])}else if("match"===e[0]){t=t||Zn(e[1]);for(let t=2;t<e.length-1;t+=2)i.push(e[t+1]);i.push(e[e.length-1])}else if("step"===e[0]){t=t||Zn(e[1]);for(let t=1;t<e.length-1;t+=2)i.push(e[t+1])}t&&(e.length=0,e.push("any",...i));for(let t=1;t<e.length;t++)qn(e[t])}function Zn(e){if(!Array.isArray(e))return!1;if("pitch"===(t=e[0])||"distance-from-center"===t)return!0;var t;for(let t=1;t<e.length;t++)if(Zn(e[t]))return!0;return!1}const $n=new Set(["in","==","!=",">",">=","<","<=","to-boolean"]);function Hn(e,t){return e<t?-1:e>t?1:0}function Wn(e){if(!Array.isArray(e))return!1;if("within"===e[0]||"distance"===e[0])return!0;for(let t=1;t<e.length;t++)if(Wn(e[t]))return!0;return!1}function Xn(e){if(!e)return!0;const t=e[0];return e.length<=1?"any"!==t:"=="===t?Yn(e[1],e[2],"=="):"!="===t?Qn(Yn(e[1],e[2],"==")):"<"===t||">"===t||"<="===t||">="===t?Yn(e[1],e[2],t):"any"===t?(i=e.slice(1),["any"].concat(i.map(Xn))):"all"===t?["all"].concat(e.slice(1).map(Xn)):"none"===t?["all"].concat(e.slice(1).map(Xn).map(Qn)):"in"===t?Kn(e[1],e.slice(2)):"!in"===t?Qn(Kn(e[1],e.slice(2))):"has"===t?Jn(e[1]):"!has"!==t||Qn(Jn(e[1]));var i}function Yn(e,t,i){switch(e){case"$type":return[`filter-type-${i}`,t];case"$id":return[`filter-id-${i}`,t];default:return[`filter-${i}`,e,t]}}function Kn(e,t){if(0===t.length)return!1;switch(e){case"$type":return["filter-type-in",["literal",t]];case"$id":return["filter-id-in",["literal",t]];default:return t.length>200&&!t.some((e=>typeof e!=typeof t[0]))?["filter-in-large",e,["literal",t.sort(Hn)]]:["filter-in-small",e,["literal",t]]}}function Jn(e){switch(e){case"$type":return!0;case"$id":return["filter-has-id"];default:return["filter-has",e]}}function Qn(e){return["!",e]}function eo(e){return Nn(wt(e.value))?Fn(vt({},e,{expressionContext:"filter",valueSpec:e.styleSpec[`filter_${e.layerType||"fill"}`]})):to(e)}function to(e){const t=e.value,i=e.key;if("array"!==ri(t))return[new ValidationError(i,t,`array expected, ${ri(t)} found`)];const r=e.styleSpec;let n,o=[];if(t.length<1)return[new ValidationError(i,t,"filter array must have at least 1 element")];switch(o=o.concat(Vn({key:`${i}[0]`,value:t[0],valueSpec:r.filter_operator,style:e.style,styleSpec:e.styleSpec})),bt(t[0])){case"<":case"<=":case">":case">=":t.length>=2&&"$type"===bt(t[1])&&o.push(new ValidationError(i,t,`"$type" cannot be use with operator "${t[0]}"`));case"==":case"!=":3!==t.length&&o.push(new ValidationError(i,t,`filter array for operator "${t[0]}" must have 3 elements`));case"in":case"!in":t.length>=2&&(n=ri(t[1]),"string"!==n&&o.push(new ValidationError(`${i}[1]`,t[1],`string expected, ${n} found`)));for(let a=2;a<t.length;a++)n=ri(t[a]),"$type"===bt(t[1])?o=o.concat(Vn({key:`${i}[${a}]`,value:t[a],valueSpec:r.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==n&&"number"!==n&&"boolean"!==n&&o.push(new ValidationError(`${i}[${a}]`,t[a],`string, number, or boolean expected, ${n} found`));break;case"any":case"all":case"none":for(let r=1;r<t.length;r++)o=o.concat(to({key:`${i}[${r}]`,value:t[r],style:e.style,styleSpec:e.styleSpec}));break;case"has":case"!has":n=ri(t[1]),2!==t.length?o.push(new ValidationError(i,t,`filter array for "${t[0]}" operator must have 2 elements`)):"string"!==n&&o.push(new ValidationError(`${i}[1]`,t[1],`string expected, ${n} found`))}return o}function io(e,t){const i=e.key,r=e.style,n=e.layer,o=e.styleSpec,a=e.value,s=e.objectKey,l=o[`${t}_${e.layerType}`];if(!l)return[];const c=s.match(/^(.*)-transition$/);if("paint"===t&&c&&l[c[1]]&&l[c[1]].transition)return go({key:i,value:a,valueSpec:o.transition,style:r,styleSpec:o});const u=e.valueSpec||l[s];if(!u)return[new ValidationWarning(i,a,`unknown property "${s}"`)];let h;if("string"===ri(a)&&gn(u)&&!u.tokens&&(h=/^{([^}]+)}$/.exec(a))){const e=`\`{ "type": "identity", "property": ${h?JSON.stringify(h[1]):'"_"'} }\``;return[new ValidationError(i,a,`"${s}" does not support interpolation syntax\nUse an identity property function instead: ${e}.`)]}const d=[];if("symbol"===e.layerType)"text-field"!==s||!r||r.glyphs||r.imports||d.push(new ValidationError(i,a,'use of "text-field" requires a style "glyphs" property')),"text-font"===s&&bn(wt(a))&&"identity"===bt(a.type)&&d.push(new ValidationError(i,a,'"text-font" does not support identity functions'));else if("model"===e.layerType&&"paint"===t&&n&&n.layout&&n.layout.hasOwnProperty("model-id")&&gn(u)&&(yn(u)||xn(u))){const e=Ln(wt(a),u),t=e.value.expression||e.value._styleExpression.expression;t&&!dr(t,["measure-light"])&&d.push(new ValidationError(i,a,`${s} does not support measure-light expressions when the model layer source is vector tile or GeoJSON.`))}return d.concat(go({key:e.key,value:a,valueSpec:u,style:r,styleSpec:o,expressionContext:"property",propertyType:t,propertyKey:s}))}function ro(e){return io(e,"paint")}function no(e){return io(e,"layout")}function oo(e){let t=[];const i=e.value,r=e.key,n=e.style,o=e.styleSpec;i.type||i.ref||t.push(new ValidationError(r,i,'either "type" or "ref" is required'));let a=bt(i.type);const s=bt(i.ref);if(i.id){const o=bt(i.id);for(let a=0;a<e.arrayIndex;a++){const e=n.layers[a];bt(e.id)===o&&t.push(new ValidationError(r,i.id,`duplicate layer id "${i.id}", previously used at line ${e.id.__line__}`))}}if("ref"in i){let e;["type","source","source-layer","filter","layout"].forEach((e=>{e in i&&t.push(new ValidationError(r,i[e],`"${e}" is prohibited for ref layers`))})),n.layers.forEach((t=>{bt(t.id)===s&&(e=t)})),e?e.ref?t.push(new ValidationError(r,i.ref,"ref cannot reference another ref layer")):a=bt(e.type):"string"==typeof s&&t.push(new ValidationError(r,i.ref,`ref layer "${s}" not found`))}else if("background"!==a&&"sky"!==a&&"slot"!==a)if(i.source){const e=n.sources&&n.sources[i.source],o=e&&bt(e.type);e?"vector"===o&&"raster"===a?t.push(new ValidationError(r,i.source,`layer "${i.id}" requires a raster source`)):"raster"===o&&"raster"!==a?t.push(new ValidationError(r,i.source,`layer "${i.id}" requires a vector source`)):"vector"!==o||i["source-layer"]?"raster-dem"===o&&"hillshade"!==a?t.push(new ValidationError(r,i.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!i.paint||!i.paint["line-gradient"]&&!i.paint["line-trim-offset"]||"geojson"===o&&e.lineMetrics||t.push(new ValidationError(r,i,`layer "${i.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):t.push(new ValidationError(r,i,`layer "${i.id}" must specify a "source-layer"`)):t.push(new ValidationError(r,i.source,`source "${i.source}" not found`))}else t.push(new ValidationError(r,i,'missing required property "source"'));return t=t.concat(Rn({key:r,value:i,valueSpec:o.layer,style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":()=>[],type:()=>go({key:`${r}.type`,value:i.type,valueSpec:o.layer.type,style:e.style,styleSpec:e.styleSpec,object:i,objectKey:"type"}),filter:e=>eo(vt({layerType:a},e)),layout:e=>Rn({layer:i,key:e.key,value:e.value,valueSpec:{},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":e=>no(vt({layerType:a},e))}}),paint:e=>Rn({layer:i,key:e.key,value:e.value,valueSpec:{},style:e.style,styleSpec:e.styleSpec,objectElementValidators:{"*":e=>ro(vt({layerType:a,layer:i},e))}})}})),t}function ao(e){const t=e.value,i=e.key,r=ri(t);return"string"!==r?[new ValidationError(i,t,`string expected, ${r} found`)]:[]}const so={promoteId:function({key:e,value:t}){if("string"===ri(t))return ao({key:e,value:t});{const i=[];for(const r in t)i.push(...ao({key:`${e}.${r}`,value:t[r]}));return i}}};function lo(e){const t=e.value,i=e.key,r=e.styleSpec,n=e.style;if(!t.type)return[new ValidationError(i,t,'"type" is required')];const o=bt(t.type);let a;switch(o){case"vector":case"raster":case"raster-dem":return a=Rn({key:i,value:t,valueSpec:r[`source_${o.replace("-","_")}`],style:e.style,styleSpec:r,objectElementValidators:so}),a;case"geojson":if(a=Rn({key:i,value:t,valueSpec:r.source_geojson,style:n,styleSpec:r,objectElementValidators:so}),t.cluster)for(const e in t.clusterProperties){const[r,n]=t.clusterProperties[e],o="string"==typeof r?[r,["accumulated"],["get",e]]:r;a.push(...Fn({key:`${i}.${e}.map`,value:n,expressionContext:"cluster-map"})),a.push(...Fn({key:`${i}.${e}.reduce`,value:o,expressionContext:"cluster-reduce"}))}return a;case"video":return Rn({key:i,value:t,valueSpec:r.source_video,style:n,styleSpec:r});case"image":return Rn({key:i,value:t,valueSpec:r.source_image,style:n,styleSpec:r});case"canvas":return[new ValidationError(i,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return Vn({key:`${i}.type`,value:t.type,valueSpec:{values:co(r)},style:n,styleSpec:r})}}function co(e){return e.source.reduce(((t,i)=>{const r=e[i];return"enum"===r.type.type&&(t=t.concat(Object.keys(r.type.values))),t}),[])}function uo(e){const t=e.value;let i=[];if(!t)return i;const r=ri(t);return"string"!==r?(i=i.concat([new ValidationError(e.key,t,`string expected, "${r}" found`)]),i):(function(e){const t=-1===e.indexOf("://");try{return new URL(e,t?"http://example.com":void 0),!0}catch(e){return!1}}(t)||(i=i.concat([new ValidationError(e.key,t,`invalid url "${t}"`)])),i)}function ho(e){const t=e.value,i=e.styleSpec,r=i.light,n=e.style;let o=[];const a=ri(t);if(void 0===t)return o;if("object"!==a)return o=o.concat([new ValidationError("light",t,`object expected, ${a} found`)]),o;for(const e in t){const a=e.match(/^(.*)-transition$/);o=o.concat(a&&r[a[1]]&&r[a[1]].transition?go({key:e,value:t[e],valueSpec:i.transition,style:n,styleSpec:i}):r[e]?go({key:e,value:t[e],valueSpec:r[e],style:n,styleSpec:i}):[new ValidationError(e,t[e],`unknown property "${e}"`)])}return o}function po(e){const t=e.value;let i=[];if(!t)return i;const r=ri(t);if("object"!==r)return i=i.concat([new ValidationError("light-3d",t,`object expected, ${r} found`)]),i;const n=e.styleSpec,o=n["light-3d"],a=e.key,s=e.style,l=e.style.lights;for(const e of["type","id"])if(!(e in t))return i=i.concat([new ValidationError("light-3d",t,`missing property ${e} on light`)]),i;if(t.type&&l)for(let r=0;r<e.arrayIndex;r++){const e=bt(t.type),n=l[r];bt(n.type)===e&&i.push(new ValidationError(a,t.id,`duplicate light type "${t.type}", previously defined at line ${n.id.__line__}`))}const c=`properties_light_${t.type}`;if(!(c in n))return i=i.concat([new ValidationError("light-3d",t,`Invalid light type ${t.type}`)]),i;const u=n[c];for(const r in t)if("properties"===r){const o=t[r],a=ri(o);if("object"!==a)return i=i.concat([new ValidationError("properties",o,`object expected, ${a} found`)]),i;for(const t in o)i=i.concat(u[t]?go({key:t,value:o[t],valueSpec:u[t],style:s,styleSpec:n}):[new ValidationWarning(e.key,o[t],`unknown property "${t}"`)])}else{const e=r.match(/^(.*)-transition$/);i=i.concat(e&&o[e[1]]&&o[e[1]].transition?go({key:r,value:t[r],valueSpec:n.transition,style:s,styleSpec:n}):o[r]?go({key:r,value:t[r],valueSpec:o[r],style:s,styleSpec:n}):[new ValidationWarning(r,t[r],`unknown property "${r}"`)])}return i}function fo(e){const t=e.value,i=e.key,r=e.style,n=e.styleSpec,o=n.terrain;let a=[];const s=ri(t);if(void 0===t)return a;if("object"!==s)return a=a.concat([new ValidationError("terrain",t,`object expected, ${s} found`)]),a;for(const e in t){const i=e.match(/^(.*)-transition$/);a=a.concat(i&&o[i[1]]&&o[i[1]].transition?go({key:e,value:t[e],valueSpec:n.transition,style:r,styleSpec:n}):o[e]?go({key:e,value:t[e],valueSpec:o[e],style:r,styleSpec:n}):[new ValidationWarning(e,t[e],`unknown property "${e}"`)])}if(t.source){const e=r.sources&&r.sources[t.source],n=e&&bt(e.type);e?"raster-dem"!==n&&a.push(new ValidationError(i,t.source,`terrain cannot be used with a source of type ${String(n)}, it only be used with a "raster-dem" source type`)):a.push(new ValidationError(i,t.source,`source "${t.source}" not found`))}else a.push(new ValidationError(i,t,'terrain is missing required property "source"'));return a}function mo(e){const t=e.value,i=e.style,r=e.styleSpec,n=r.fog;let o=[];const a=ri(t);if(void 0===t)return o;if("object"!==a)return o=o.concat([new ValidationError("fog",t,`object expected, ${a} found`)]),o;for(const e in t){const a=e.match(/^(.*)-transition$/);o=o.concat(a&&n[a[1]]&&n[a[1]].transition?go({key:e,value:t[e],valueSpec:r.transition,style:i,styleSpec:r}):n[e]?go({key:e,value:t[e],valueSpec:n[e],style:i,styleSpec:r}):[new ValidationWarning(e,t[e],`unknown property "${e}"`)])}return o}const _o={"*":()=>[],array:kn,boolean:function(e){const t=e.value,i=e.key,r=ri(t);return"boolean"!==r?[new ValidationError(i,t,`boolean expected, ${r} found`)]:[]},number:Bn,color:function(e){const t=e.key,i=e.value,r=ri(i);return"string"!==r?[new ValidationError(t,i,`color expected, ${r} found`)]:null===jt(i)?[new ValidationError(t,i,`color expected, "${i}" found`)]:[]},enum:Vn,filter:eo,function:On,layer:oo,object:Rn,source:lo,model:uo,light:ho,"light-3d":po,terrain:fo,fog:mo,string:ao,formatted:function(e){return 0===ao(e).length?[]:Fn(e)},resolvedImage:function(e){return 0===ao(e).length?[]:Fn(e)},projection:function(e){const t=e.value,i=e.styleSpec,r=i.projection,n=e.style;let o=[];const a=ri(t);if("object"===a)for(const e in t)o=o.concat(go({key:e,value:t[e],valueSpec:r[e],style:n,styleSpec:i}));else"string"!==a&&(o=o.concat([new ValidationError("projection",t,`object or string expected, ${a} found`)]));return o},import:function(e){const{value:t,styleSpec:i}=e,{data:r,...n}=t;Object.defineProperty(n,"__line__",{value:t.__line__,enumerable:!1});let o=Rn(vt({},e,{value:n,valueSpec:i.import}));return""===bt(n.id)&&o.push(new ValidationError(`${e.key}.id`,n,"import id can't be an empty string")),r&&(o=o.concat(xo(r,i,{key:`${e.key}.data`}))),o}};function go(e,t=!1){const i=e.value,r=e.valueSpec,n=e.styleSpec;if(r.expression&&bn(bt(i)))return On(e);if(r.expression&&Dn(wt(i)))return Fn(e);if(r.type&&_o[r.type]){const i=_o[r.type](e);return!0===t&&i.length>0&&"array"===ri(e.value)?Fn(e):i}return Rn(vt({},e,{valueSpec:r.type?n[r.type]:r}))}function yo(e){const t=e.value,i=e.key,r=ao(e);return r.length||(-1===t.indexOf("{fontstack}")&&r.push(new ValidationError(i,t,'"glyphs" url must include a "{fontstack}" token')),-1===t.indexOf("{range}")&&r.push(new ValidationError(i,t,'"glyphs" url must include a "{range}" token'))),r}function xo(e,t=xt,i={}){return go({key:i.key||"",value:e,valueSpec:t.$root,styleSpec:t,style:e,objectElementValidators:{glyphs:yo,"*":()=>[]}})}function vo(e,t=xt){return Po(xo(e,t))}const bo=e=>Po(lo(e)),wo=e=>Po(ho(e)),To=e=>Po(po(e)),Eo=e=>Po(fo(e)),Mo=e=>Po(mo(e)),So=e=>Po(oo(e)),Ao=e=>Po(eo(e)),Co=e=>Po(ro(e)),Io=e=>Po(no(e)),Do=e=>Po(uo(e));function Po(e){return e.slice().sort(((e,t)=>e.line&&t.line?e.line-t.line:0))}function Lo(e,t){let i=!1;if(t&&t.length)for(const r of t)r instanceof ValidationWarning?$(r.message):(e.fire(new ErrorEvent(new Error(r.message))),i=!0);return i}var zo=ko,Ro=3;function ko(e,t,i){var r=this.cells=[];if(e instanceof ArrayBuffer){this.arrayBuffer=e;var n=new Int32Array(this.arrayBuffer);e=n[0],this.d=(t=n[1])+2*(i=n[2]);for(var o=0;o<this.d*this.d;o++){var a=n[Ro+o],s=n[Ro+o+1];r.push(a===s?null:n.subarray(a,s))}var l=n[Ro+r.length+1];this.keys=n.subarray(n[Ro+r.length],l),this.bboxes=n.subarray(l),this.insert=this._insertReadonly}else{this.d=t+2*i;for(var c=0;c<this.d*this.d;c++)r.push([]);this.keys=[],this.bboxes=[]}this.n=t,this.extent=e,this.padding=i,this.scale=t/e,this.uid=0;var u=i/t*e;this.min=-u,this.max=e+u}ko.prototype.insert=function(e,t,i,r,n){this._forEachCell(t,i,r,n,this._insertCell,this.uid++),this.keys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)},ko.prototype._insertReadonly=function(){throw"Cannot insert into a GridIndex created from an ArrayBuffer."},ko.prototype._insertCell=function(e,t,i,r,n,o){this.cells[n].push(o)},ko.prototype.query=function(e,t,i,r,n){var o=this.min,a=this.max;if(e<=o&&t<=o&&a<=i&&a<=r&&!n)return Array.prototype.slice.call(this.keys);var s=[];return this._forEachCell(e,t,i,r,this._queryCell,s,{},n),s},ko.prototype._queryCell=function(e,t,i,r,n,o,a,s){var l=this.cells[n];if(null!==l)for(var c=this.keys,u=this.bboxes,h=0;h<l.length;h++){var d=l[h];if(void 0===a[d]){var p=4*d;(s?s(u[p+0],u[p+1],u[p+2],u[p+3]):e<=u[p+2]&&t<=u[p+3]&&i>=u[p+0]&&r>=u[p+1])?(a[d]=!0,o.push(c[d])):a[d]=!1}}},ko.prototype._forEachCell=function(e,t,i,r,n,o,a,s){for(var l=this._convertToCellCoord(e),c=this._convertToCellCoord(t),u=this._convertToCellCoord(i),h=this._convertToCellCoord(r),d=l;d<=u;d++)for(var p=c;p<=h;p++){var f=this.d*p+d;if((!s||s(this._convertFromCellCoord(d),this._convertFromCellCoord(p),this._convertFromCellCoord(d+1),this._convertFromCellCoord(p+1)))&&n.call(this,e,t,i,r,f,o,a,s))return}},ko.prototype._convertFromCellCoord=function(e){return(e-this.padding)/this.scale},ko.prototype._convertToCellCoord=function(e){return Math.max(0,Math.min(this.d-1,Math.floor(e*this.scale)+this.padding))},ko.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var e=this.cells,t=Ro+this.cells.length+1+1,i=0,r=0;r<this.cells.length;r++)i+=this.cells[r].length;var n=new Int32Array(t+i+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;for(var o=t,a=0;a<e.length;a++){var s=e[a];n[Ro+a]=o,n.set(s,o),o+=s.length}return n[Ro+e.length]=o,n.set(this.keys,o),n[Ro+e.length+1]=o+=this.keys.length,n.set(this.bboxes,o),o+=this.bboxes.length,n.buffer};var Bo=h(zo);const Oo={};function Fo(e,t,i={}){Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),Oo[t]={klass:e,omit:i.omit||[]}}Fo(Object,"Object"),Bo.serialize=function(e,t){const i=e.toArrayBuffer();return t&&t.add(i),{buffer:i}},Bo.deserialize=function(e){return new Bo(e.buffer)},Object.defineProperty(Bo,"name",{value:"Grid"}),Fo(Bo,"Grid"),Fo(Wt,"Color"),Fo(Error,"Error"),Fo(AJAXError,"AJAXError"),Fo(ResolvedImage,"ResolvedImage"),Fo(StylePropertyFunction,"StylePropertyFunction"),Fo(StyleExpression,"StyleExpression",{omit:["_evaluator"]}),Fo(ZoomDependentExpression,"ZoomDependentExpression"),Fo(ZoomConstantExpression,"ZoomConstantExpression"),Fo(li,"CompoundExpression",{omit:["_evaluate"]});for(const e in pn)Oo[pn[e]._classRegistryKey]||Fo(pn[e],`Expression${e}`);function Uo(e){return e&&"undefined"!=typeof ArrayBuffer&&(e instanceof ArrayBuffer||e.constructor&&"ArrayBuffer"===e.constructor.name)}function Vo(t){return e.ImageBitmap&&t instanceof e.ImageBitmap}function No(t,i){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Uo(t)||Vo(t))return i&&i.add(t),t;if(ArrayBuffer.isView(t)){const e=t;return i&&i.add(e.buffer),e}if(t instanceof e.ImageData)return i&&i.add(t.data.buffer),t;if(Array.isArray(t)){const e=[];for(const r of t)e.push(No(r,i));return e}if(t instanceof Map){const e={$name:"Map"};for(const[i,r]of t.entries())e[i]=No(r);return e}if("object"==typeof t){const e=t.constructor,r=e._classRegistryKey;if(!r)throw new Error(`can't serialize object of unregistered class ${r}`);const n=e.serialize?e.serialize(t,i):{};if(!e.serialize){for(const e in t)t.hasOwnProperty(e)&&(Oo[r].omit.indexOf(e)>=0||(n[e]=No(t[e],i)));t instanceof Error&&(n.message=t.message)}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return"Object"!==r&&(n.$name=r),n}throw new Error("can't serialize object of type "+typeof t)}function jo(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Uo(t)||Vo(t)||ArrayBuffer.isView(t)||t instanceof e.ImageData)return t;if(Array.isArray(t))return t.map(jo);if("object"==typeof t){const e=t.$name||"Object";if("Map"===e){const e=new Map;for(const i of Object.keys(t))"$name"!==i&&e.set(i,jo(t[i]));return e}const{klass:i}=Oo[e];if(!i)throw new Error(`can't deserialize unregistered class ${e}`);if(i.deserialize)return i.deserialize(t);const r=Object.create(i.prototype);for(const e of Object.keys(t))"$name"!==e&&(r[e]=jo(t[e]));return r}throw new Error("can't deserialize object of type "+typeof t)}const Go={"Latin-1 Supplement":e=>e>=128&&e<=255,Arabic:e=>e>=1536&&e<=1791,"Arabic Supplement":e=>e>=1872&&e<=1919,"Arabic Extended-A":e=>e>=2208&&e<=2303,"Hangul Jamo":e=>e>=4352&&e<=4607,"Unified Canadian Aboriginal Syllabics":e=>e>=5120&&e<=5759,Khmer:e=>e>=6016&&e<=6143,"Unified Canadian Aboriginal Syllabics Extended":e=>e>=6320&&e<=6399,"General Punctuation":e=>e>=8192&&e<=8303,"Letterlike Symbols":e=>e>=8448&&e<=8527,"Number Forms":e=>e>=8528&&e<=8591,"Miscellaneous Technical":e=>e>=8960&&e<=9215,"Control Pictures":e=>e>=9216&&e<=9279,"Optical Character Recognition":e=>e>=9280&&e<=9311,"Enclosed Alphanumerics":e=>e>=9312&&e<=9471,"Geometric Shapes":e=>e>=9632&&e<=9727,"Miscellaneous Symbols":e=>e>=9728&&e<=9983,"Miscellaneous Symbols and Arrows":e=>e>=11008&&e<=11263,"CJK Radicals Supplement":e=>e>=11904&&e<=12031,"Kangxi Radicals":e=>e>=12032&&e<=12255,"Ideographic Description Characters":e=>e>=12272&&e<=12287,"CJK Symbols and Punctuation":e=>e>=12288&&e<=12351,Hiragana:e=>e>=12352&&e<=12447,Katakana:e=>e>=12448&&e<=12543,Bopomofo:e=>e>=12544&&e<=12591,"Hangul Compatibility Jamo":e=>e>=12592&&e<=12687,Kanbun:e=>e>=12688&&e<=12703,"Bopomofo Extended":e=>e>=12704&&e<=12735,"CJK Strokes":e=>e>=12736&&e<=12783,"Katakana Phonetic Extensions":e=>e>=12784&&e<=12799,"Enclosed CJK Letters and Months":e=>e>=12800&&e<=13055,"CJK Compatibility":e=>e>=13056&&e<=13311,"CJK Unified Ideographs Extension A":e=>e>=13312&&e<=19903,"Yijing Hexagram Symbols":e=>e>=19904&&e<=19967,"CJK Unified Ideographs":e=>e>=19968&&e<=40959,"Yi Syllables":e=>e>=40960&&e<=42127,"Yi Radicals":e=>e>=42128&&e<=42191,"Hangul Jamo Extended-A":e=>e>=43360&&e<=43391,"Hangul Syllables":e=>e>=44032&&e<=55215,"Hangul Jamo Extended-B":e=>e>=55216&&e<=55295,"Private Use Area":e=>e>=57344&&e<=63743,"CJK Compatibility Ideographs":e=>e>=63744&&e<=64255,"Arabic Presentation Forms-A":e=>e>=64336&&e<=65023,"Vertical Forms":e=>e>=65040&&e<=65055,"CJK Compatibility Forms":e=>e>=65072&&e<=65103,"Small Form Variants":e=>e>=65104&&e<=65135,"Arabic Presentation Forms-B":e=>e>=65136&&e<=65279,"Halfwidth and Fullwidth Forms":e=>e>=65280&&e<=65519,"CJK Unified Ideographs Extension B":e=>e>=131072&&e<=173791};function qo(e){for(const t of e)if(Zo(t.charCodeAt(0)))return!0;return!1}function Zo(e){return!(746!==e&&747!==e&&(e<4352||!(Go["Bopomofo Extended"](e)||Go.Bopomofo(e)||Go["CJK Compatibility Forms"](e)&&!(e>=65097&&e<=65103)||Go["CJK Compatibility Ideographs"](e)||Go["CJK Compatibility"](e)||Go["CJK Radicals Supplement"](e)||Go["CJK Strokes"](e)||!(!Go["CJK Symbols and Punctuation"](e)||e>=12296&&e<=12305||e>=12308&&e<=12319||12336===e)||Go["CJK Unified Ideographs Extension A"](e)||Go["CJK Unified Ideographs"](e)||Go["Enclosed CJK Letters and Months"](e)||Go["Hangul Compatibility Jamo"](e)||Go["Hangul Jamo Extended-A"](e)||Go["Hangul Jamo Extended-B"](e)||Go["Hangul Jamo"](e)||Go["Hangul Syllables"](e)||Go.Hiragana(e)||Go["Ideographic Description Characters"](e)||Go.Kanbun(e)||Go["Kangxi Radicals"](e)||Go["Katakana Phonetic Extensions"](e)||Go.Katakana(e)&&12540!==e||!(!Go["Halfwidth and Fullwidth Forms"](e)||65288===e||65289===e||65293===e||e>=65306&&e<=65310||65339===e||65341===e||65343===e||e>=65371&&e<=65503||65507===e||e>=65512&&e<=65519)||!(!Go["Small Form Variants"](e)||e>=65112&&e<=65118||e>=65123&&e<=65126)||Go["Unified Canadian Aboriginal Syllabics"](e)||Go["Unified Canadian Aboriginal Syllabics Extended"](e)||Go["Vertical Forms"](e)||Go["Yijing Hexagram Symbols"](e)||Go["Yi Syllables"](e)||Go["Yi Radicals"](e))))}function $o(e){return e>=1424&&e<=2303||Go["Arabic Presentation Forms-A"](e)||Go["Arabic Presentation Forms-B"](e)}function Ho(e,t){return!(!t&&$o(e)||e>=2304&&e<=3583||e>=3840&&e<=4255||Go.Khmer(e))}function Wo(e){for(const t of e)if($o(t.charCodeAt(0)))return!0;return!1}const Xo="deferred",Yo="loading",Ko="loaded";let Jo=null,Qo="unavailable",ea=null;const ta=function(e){e&&"string"==typeof e&&e.indexOf("NetworkError")>-1&&(Qo="error"),Jo&&Jo(e)};function ia(){ra.fire(new Event("pluginStateChange",{pluginStatus:Qo,pluginURL:ea}))}const ra=new Evented,na=function(){return Qo},oa=function(){if(Qo!==Xo||!ea)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Qo=Yo,ia(),ea&&ve({url:ea},(e=>{e?ta(e):(Qo=Ko,ia())}))},aa={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>Qo===Ko||null!=aa.applyArabicShaping,isLoading:()=>Qo===Yo,setState(e){Qo=e.pluginStatus,ea=e.pluginURL},isParsed:()=>null!=aa.applyArabicShaping,getPluginURL:()=>ea};class EvaluationParameters{constructor(e,t){this.zoom=e,t?(this.now=t.now,this.fadeDuration=t.fadeDuration,this.transition=t.transition,this.pitch=t.pitch,this.brightness=t.brightness):(this.now=0,this.fadeDuration=0,this.transition={},this.pitch=0,this.brightness=0)}isSupportedScript(e){return function(e,t){for(const i of e)if(!Ho(i.charCodeAt(0),t))return!1;return!0}(e,aa.isLoaded())}}class PropertyValue{constructor(e,t,i){this.property=e,this.value=t,this.expression=function(e,t,i){if(bn(e))return new StylePropertyFunction(e,t);if(Dn(e)||Array.isArray(e)&&e.length>0){const r=Ln(e,t,i);if("error"===r.result)throw new Error(r.value.map((e=>`${e.key}: ${e.message}`)).join(", "));return r.value}{let i=e;return"string"==typeof e&&"color"===t.type&&(i=Wt.parse(e)),{kind:"constant",isConfigDependent:!1,evaluate:()=>i}}}(void 0===t?e.specification.default:t,e.specification,i)}isDataDriven(){return"source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(e,t,i){return this.property.possiblyEvaluate(this,e,t,i)}}class TransitionablePropertyValue{constructor(e,t){this.property=e,this.value=new PropertyValue(e,void 0,t)}transitioned(e,t){return new TransitioningPropertyValue(this.property,this.value,t,z({},e.transition,this.transition),e.now)}untransitioned(){return new TransitioningPropertyValue(this.property,this.value,null,{},0)}}class Transitionable{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultTransitionablePropertyValues),this._options=t,this.isConfigDependent=!1}getValue(e){return q(this._values[e].value.value)}setValue(e,t){this._values.hasOwnProperty(e)||(this._values[e]=new TransitionablePropertyValue(this._values[e].property,this._options)),this._values[e].value=new PropertyValue(this._values[e].property,null===t?void 0:q(t),this._options),this.isConfigDependent=this.isConfigDependent||this._values[e].value.expression.isConfigDependent}setTransitionOrValue(e,t){t&&(this._options=t);const i=this._properties.properties;if(e)for(const t in e){const r=e[t];if(N(t,"-transition")){const e=t.slice(0,-11);i[e]&&this.setTransition(e,r)}else i[t]&&this.setValue(t,r)}}getTransition(e){return q(this._values[e].transition)}setTransition(e,t){this._values.hasOwnProperty(e)||(this._values[e]=new TransitionablePropertyValue(this._values[e].property)),this._values[e].transition=q(t)||void 0}serialize(){const e={};for(const t of Object.keys(this._values)){const i=this.getValue(t);void 0!==i&&(e[t]=i);const r=this.getTransition(t);void 0!==r&&(e[`${t}-transition`]=r)}return e}transitioned(e,t){const i=new Transitioning(this._properties);for(const r of Object.keys(this._values))i._values[r]=this._values[r].transitioned(e,t._values[r]);return i}untransitioned(){const e=new Transitioning(this._properties);for(const t of Object.keys(this._values))e._values[t]=this._values[t].untransitioned();return e}}class TransitioningPropertyValue{constructor(e,t,i,r,n){const o=r.delay||0,a=r.duration||0;n=n||0,this.property=e,this.value=t,this.begin=n+o,this.end=this.begin+a,e.specification.transition&&(r.delay||r.duration)&&(this.prior=i)}possiblyEvaluate(e,t,i){const r=e.now||0,n=this.value.possiblyEvaluate(e,t,i),o=this.prior;if(o){if(r>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(r<this.begin)return o.possiblyEvaluate(e,t,i);{const a=(r-this.begin)/(this.end-this.begin);return this.property.interpolate(o.possiblyEvaluate(e,t,i),n,E(a))}}return n}}class Transitioning{constructor(e){this._properties=e,this._values=Object.create(e.defaultTransitioningPropertyValues)}possiblyEvaluate(e,t,i){const r=new PossiblyEvaluated(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(e,t,i);return r}hasTransition(){for(const e of Object.keys(this._values))if(this._values[e].prior)return!0;return!1}}class Layout{constructor(e,t){this._properties=e,this._values=Object.create(e.defaultPropertyValues),this._options=t,this.isConfigDependent=!1}getValue(e){return q(this._values[e].value)}setValue(e,t){this._values[e]=new PropertyValue(this._values[e].property,null===t?void 0:q(t),this._options),this.isConfigDependent=this.isConfigDependent||this._values[e].expression.isConfigDependent}serialize(){const e={};for(const t of Object.keys(this._values)){const i=this.getValue(t);void 0!==i&&(e[t]=i)}return e}possiblyEvaluate(e,t,i){const r=new PossiblyEvaluated(this._properties);for(const n of Object.keys(this._values))r._values[n]=this._values[n].possiblyEvaluate(e,t,i);return r}}class PossiblyEvaluatedPropertyValue{constructor(e,t,i){this.property=e,this.value=t,this.parameters=i}isConstant(){return"constant"===this.value.kind}constantOr(e){return"constant"===this.value.kind?this.value.value:e}evaluate(e,t,i,r){return this.property.evaluate(this.value,this.parameters,e,t,i,r)}}class PossiblyEvaluated{constructor(e){this._properties=e,this._values=Object.create(e.defaultPossiblyEvaluatedValues)}get(e){return this._values[e]}}class DataConstantProperty{constructor(e){this.specification=e}possiblyEvaluate(e,t){return e.expression.evaluate(t)}interpolate(e,t,i){const r=vr[this.specification.type];return r?r(e,t,i):e}}class DataDrivenProperty{constructor(e,t){this.specification=e,this.overrides=t}possiblyEvaluate(e,t,i,r){return new PossiblyEvaluatedPropertyValue(this,"constant"===e.expression.kind||"camera"===e.expression.kind?{kind:"constant",value:e.expression.evaluate(t,null,{},i,r)}:e.expression,t)}interpolate(e,t,i){if("constant"!==e.value.kind||"constant"!==t.value.kind)return e;if(void 0===e.value.value||void 0===t.value.value)return new PossiblyEvaluatedPropertyValue(this,{kind:"constant",value:void 0},e.parameters);const r=vr[this.specification.type];return r?new PossiblyEvaluatedPropertyValue(this,{kind:"constant",value:r(e.value.value,t.value.value,i)},e.parameters):e}evaluate(e,t,i,r,n,o){return"constant"===e.kind?e.value:e.evaluate(t,i,r,n,o)}}class ColorRampProperty{constructor(e){this.specification=e}possiblyEvaluate(e,t,i,r){return!!e.expression.evaluate(t,null,{},i,r)}interpolate(){return!1}}class Properties{constructor(e){this.properties=e,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];const t=new EvaluationParameters(0,{});for(const i in e){const r=e[i];r.specification.overridable&&this.overridableProperties.push(i);const n=this.defaultPropertyValues[i]=new PropertyValue(r,void 0),o=this.defaultTransitionablePropertyValues[i]=new TransitionablePropertyValue(r);this.defaultTransitioningPropertyValues[i]=o.untransitioned(),this.defaultPossiblyEvaluatedValues[i]=n.possiblyEvaluate(t)}}}function sa(e,t){return t?`${e}${t}`:e}function la(e){const t=e.indexOf("");return t>=0?e.slice(0,t):e}Fo(DataDrivenProperty,"DataDrivenProperty"),Fo(DataConstantProperty,"DataConstantProperty"),Fo(ColorRampProperty,"ColorRampProperty");const ca="-transition";class StyleLayer extends Evented{constructor(e,t,i){if(super(),this.id=e.id,this.type=e.type,this._featureFilter={filter:()=>!0,needGeometry:!1,needFeature:!1},this._filterCompiled=!1,this.isConfigDependent=!1,"custom"!==e.type&&(this.metadata=e.metadata,this.minzoom=e.minzoom,this.maxzoom=e.maxzoom,"background"!==e.type&&"sky"!==e.type&&"slot"!==e.type&&(this.source=e.source,this.sourceLayer=e["source-layer"],this.filter=e.filter),this.options=i,e.slot&&(this.slot=e.slot),t.layout&&(this._unevaluatedLayout=new Layout(t.layout,i),this.isConfigDependent=this.isConfigDependent||this._unevaluatedLayout.isConfigDependent),t.paint)){this._transitionablePaint=new Transitionable(t.paint,i);for(const t in e.paint)this.setPaintProperty(t,e.paint[t],{validate:!1});for(const t in e.layout)this.setLayoutProperty(t,e.layout[t],{validate:!1});this.isConfigDependent=this.isConfigDependent||this._transitionablePaint.isConfigDependent,this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new PossiblyEvaluated(t.paint)}}setScope(e){this.scope=e,this.fqid=sa(this.id,e)}getLayoutProperty(e){return"visibility"===e?this.visibility:this._unevaluatedLayout.getValue(e)}setLayoutProperty(e,t,i={}){if(null!=t&&this._validate(Io,`layers.${this.id}.layout.${e}`,e,t,i))return;if("custom"===this.type&&"visibility"===e)return void(this.visibility=t);const r=this._unevaluatedLayout;r._properties.properties[e]&&(r.setValue(e,t),this.isConfigDependent=this.isConfigDependent||r.isConfigDependent,"visibility"===e&&this.possiblyEvaluateVisibility())}possiblyEvaluateVisibility(){this.visibility=this._unevaluatedLayout._values.visibility.possiblyEvaluate({zoom:0})}getPaintProperty(e){return N(e,ca)?this._transitionablePaint.getTransition(e.slice(0,-11)):this._transitionablePaint.getValue(e)}setPaintProperty(e,t,i={}){if(null!=t&&this._validate(Co,`layers.${this.id}.paint.${e}`,e,t,i))return!1;const r=this._transitionablePaint,n=r._properties.properties;if(N(e,ca)){const i=e.slice(0,-11);return n[i]&&r.setTransition(i,t||void 0),!1}if(!n[e])return!1;const o=r._values[e],a=o.value.isDataDriven(),s=o.value;r.setValue(e,t),this.isConfigDependent=this.isConfigDependent||r.isConfigDependent,this._handleSpecialPaintPropertyUpdate(e);const l=r._values[e].value,c=l.isDataDriven(),u=N(e,"pattern")||"line-dasharray"===e;return c||a||u||this._handleOverridablePaintPropertyUpdate(e,s,l)}_handleSpecialPaintPropertyUpdate(e){}getProgramIds(){return null}getDefaultProgramParams(e,t){return null}_handleOverridablePaintPropertyUpdate(e,t,i){return!1}isHidden(e){return!!(this.minzoom&&e<this.minzoom)||!!(this.maxzoom&&e>=this.maxzoom)||"none"===this.visibility}updateTransitions(e){this._transitioningPaint=this._transitionablePaint.transitioned(e,this._transitioningPaint)}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(e,t){this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(e,void 0,t)),this.paint=this._transitioningPaint.possiblyEvaluate(e,void 0,t)}serialize(){return G({id:this.id,type:this.type,slot:this.slot,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()},((e,t)=>!(void 0===e||"layout"===t&&!Object.keys(e).length||"paint"===t&&!Object.keys(e).length)))}_validate(e,t,i,r,n={}){return(!n||!1!==n.validate)&&Lo(this,e.call(vo,{key:t,layerType:this.type,objectKey:i,value:r,styleSpec:xt,style:{glyphs:!0,sprite:!0}}))}is3D(){return!1}isSky(){return!1}isTileClipped(){return!1}hasOffscreenPass(){return!1}hasShadowPass(){return!1}canCastShadows(){return!1}hasLightBeamPass(){return!1}cutoffRange(){return 0}resize(){}isStateDependent(){for(const e in this.paint._values){const t=this.paint.get(e);if(t instanceof PossiblyEvaluatedPropertyValue&&gn(t.property.specification)&&("source"===t.value.kind||"composite"===t.value.kind)&&t.value.isStateDependent)return!0}return!1}compileFilter(){this._filterCompiled||(this._featureFilter=jn(this.filter),this._filterCompiled=!0)}invalidateCompiledFilter(){this._filterCompiled=!1}dynamicFilter(){return this._featureFilter.dynamicFilter}dynamicFilterNeedsFeature(){return this._featureFilter.needFeature}}class StyleChanges{constructor(){this.changed=!1,this._updatedLayers={},this._removedLayers={},this.updatedSourceCaches={},this.updatedPaintProps=new Set,this.changedImages=new Set}updateLayer(e){const t=e.scope;this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._updatedLayers[t].add(e.id)}removeLayer(e){const t=e.scope;this._removedLayers[t]=this._removedLayers[t]||{},this._updatedLayers[t]=this._updatedLayers[t]||new Set,this._removedLayers[t][e.id]=e,this._updatedLayers[t].delete(e.id),this.updatedPaintProps.delete(e.fqid)}getRemovedLayer(e){return this._removedLayers[e.scope]?this._removedLayers[e.scope][e.id]:null}discardLayerRemoval(e){this._removedLayers[e.scope]&&delete this._removedLayers[e.scope][e.id]}getLayerUpdatesByScope(){const e={};for(const t in this._updatedLayers)e[t]=e[t]||{},e[t].updatedIds=Array.from(this._updatedLayers[t].values());for(const t in this._removedLayers)e[t]=e[t]||{},e[t].removedIds=Object.keys(this._removedLayers[t]);return e}reset(){this.changed=!1,this._updatedLayers={},this._removedLayers={},this.updatedSourceCaches={},this.updatedPaintProps.clear(),this.changedImages.clear()}}const ua={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class Struct{constructor(e,t){this._structArray=e,this._pos1=t*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8}}class StructArray{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0)}static serialize(e,t){return e._trim(),t&&(e.isTransferred=!0,t.add(e.arrayBuffer)),{length:e.length,arrayBuffer:e.arrayBuffer}}static deserialize(e){const t=Object.create(this.prototype);return t.arrayBuffer=e.arrayBuffer,t.length=e.length,t.capacity=e.arrayBuffer.byteLength/t.bytesPerElement,t._refreshViews(),t}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews())}clear(){this.length=0}resize(e){this.reserve(e),this.length=e}reserve(e){if(e>this.capacity){this.capacity=Math.max(e,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const t=this.uint8;this._refreshViews(),t&&this.uint8.set(t)}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}destroy(){this.int8=this.uint8=this.int16=this.uint16=this.int32=this.uint32=this.float32=null,this.arrayBuffer=null}}function ha(e,t=1){let i=0,r=0;return{members:e.map((e=>{const n=ua[e.type].BYTES_PER_ELEMENT,o=i=da(i,Math.max(t,n)),a=e.components||1;return r=Math.max(r,n),i+=n*a,{name:e.name,type:e.type,components:a,offset:o}})),size:da(i,Math.max(r,t)),alignment:t}}function da(e,t){return Math.ceil(e/t)*t}class StructArrayLayout2i4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.int16[r+0]=t,this.int16[r+1]=i,e}}StructArrayLayout2i4.prototype.bytesPerElement=4,Fo(StructArrayLayout2i4,"StructArrayLayout2i4");class StructArrayLayout3i6 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.int16[n+0]=t,this.int16[n+1]=i,this.int16[n+2]=r,e}}StructArrayLayout3i6.prototype.bytesPerElement=6,Fo(StructArrayLayout3i6,"StructArrayLayout3i6");class StructArrayLayout4i8 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=4*e;return this.int16[o+0]=t,this.int16[o+1]=i,this.int16[o+2]=r,this.int16[o+3]=n,e}}StructArrayLayout4i8.prototype.bytesPerElement=8,Fo(StructArrayLayout4i8,"StructArrayLayout4i8");class StructArrayLayout5i10 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const a=5*e;return this.int16[a+0]=t,this.int16[a+1]=i,this.int16[a+2]=r,this.int16[a+3]=n,this.int16[a+4]=o,e}}StructArrayLayout5i10.prototype.bytesPerElement=10,Fo(StructArrayLayout5i10,"StructArrayLayout5i10");class StructArrayLayout2i4ub1f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n,o,a)}emplace(e,t,i,r,n,o,a,s){const l=6*e,c=12*e,u=3*e;return this.int16[l+0]=t,this.int16[l+1]=i,this.uint8[c+4]=r,this.uint8[c+5]=n,this.uint8[c+6]=o,this.uint8[c+7]=a,this.float32[u+2]=s,e}}StructArrayLayout2i4ub1f12.prototype.bytesPerElement=12,Fo(StructArrayLayout2i4ub1f12,"StructArrayLayout2i4ub1f12");class StructArrayLayout4f16 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=4*e;return this.float32[o+0]=t,this.float32[o+1]=i,this.float32[o+2]=r,this.float32[o+3]=n,e}}StructArrayLayout4f16.prototype.bytesPerElement=16,Fo(StructArrayLayout4f16,"StructArrayLayout4f16");class StructArrayLayout4ui1f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const a=6*e,s=3*e;return this.uint16[a+0]=t,this.uint16[a+1]=i,this.uint16[a+2]=r,this.uint16[a+3]=n,this.float32[s+2]=o,e}}StructArrayLayout4ui1f12.prototype.bytesPerElement=12,Fo(StructArrayLayout4ui1f12,"StructArrayLayout4ui1f12");class StructArrayLayout4ui8 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=4*e;return this.uint16[o+0]=t,this.uint16[o+1]=i,this.uint16[o+2]=r,this.uint16[o+3]=n,e}}StructArrayLayout4ui8.prototype.bytesPerElement=8,Fo(StructArrayLayout4ui8,"StructArrayLayout4ui8");class StructArrayLayout6i12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,o)}emplace(e,t,i,r,n,o,a){const s=6*e;return this.int16[s+0]=t,this.int16[s+1]=i,this.int16[s+2]=r,this.int16[s+3]=n,this.int16[s+4]=o,this.int16[s+5]=a,e}}StructArrayLayout6i12.prototype.bytesPerElement=12,Fo(StructArrayLayout6i12,"StructArrayLayout6i12");class StructArrayLayout4i4ui4i24 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a,s,l,c,u,h){const d=this.length;return this.resize(d+1),this.emplace(d,e,t,i,r,n,o,a,s,l,c,u,h)}emplace(e,t,i,r,n,o,a,s,l,c,u,h,d){const p=12*e;return this.int16[p+0]=t,this.int16[p+1]=i,this.int16[p+2]=r,this.int16[p+3]=n,this.uint16[p+4]=o,this.uint16[p+5]=a,this.uint16[p+6]=s,this.uint16[p+7]=l,this.int16[p+8]=c,this.int16[p+9]=u,this.int16[p+10]=h,this.int16[p+11]=d,e}}StructArrayLayout4i4ui4i24.prototype.bytesPerElement=24,Fo(StructArrayLayout4i4ui4i24,"StructArrayLayout4i4ui4i24");class StructArrayLayout3i3f20 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o){const a=this.length;return this.resize(a+1),this.emplace(a,e,t,i,r,n,o)}emplace(e,t,i,r,n,o,a){const s=10*e,l=5*e;return this.int16[s+0]=t,this.int16[s+1]=i,this.int16[s+2]=r,this.float32[l+2]=n,this.float32[l+3]=o,this.float32[l+4]=a,e}}StructArrayLayout3i3f20.prototype.bytesPerElement=20,Fo(StructArrayLayout3i3f20,"StructArrayLayout3i3f20");class StructArrayLayout1ul4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint32[1*e+0]=t,e}}StructArrayLayout1ul4.prototype.bytesPerElement=4,Fo(StructArrayLayout1ul4,"StructArrayLayout1ul4");class StructArrayLayout2ui4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.uint16[r+0]=t,this.uint16[r+1]=i,e}}StructArrayLayout2ui4.prototype.bytesPerElement=4,Fo(StructArrayLayout2ui4,"StructArrayLayout2ui4");class StructArrayLayout5i4f1i1ul2ui40 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a,s,l,c,u,h,d){const p=this.length;return this.resize(p+1),this.emplace(p,e,t,i,r,n,o,a,s,l,c,u,h,d)}emplace(e,t,i,r,n,o,a,s,l,c,u,h,d,p){const f=20*e,m=10*e;return this.int16[f+0]=t,this.int16[f+1]=i,this.int16[f+2]=r,this.int16[f+3]=n,this.int16[f+4]=o,this.float32[m+3]=a,this.float32[m+4]=s,this.float32[m+5]=l,this.float32[m+6]=c,this.int16[f+14]=u,this.uint32[m+8]=h,this.uint16[f+18]=d,this.uint16[f+19]=p,e}}StructArrayLayout5i4f1i1ul2ui40.prototype.bytesPerElement=40,Fo(StructArrayLayout5i4f1i1ul2ui40,"StructArrayLayout5i4f1i1ul2ui40");class StructArrayLayout3i2i2i16 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n,o,a)}emplace(e,t,i,r,n,o,a,s){const l=8*e;return this.int16[l+0]=t,this.int16[l+1]=i,this.int16[l+2]=r,this.int16[l+4]=n,this.int16[l+5]=o,this.int16[l+6]=a,this.int16[l+7]=s,e}}StructArrayLayout3i2i2i16.prototype.bytesPerElement=16,Fo(StructArrayLayout3i2i2i16,"StructArrayLayout3i2i2i16");class StructArrayLayout2f1f2i16 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const a=4*e,s=8*e;return this.float32[a+0]=t,this.float32[a+1]=i,this.float32[a+2]=r,this.int16[s+6]=n,this.int16[s+7]=o,e}}StructArrayLayout2f1f2i16.prototype.bytesPerElement=16,Fo(StructArrayLayout2f1f2i16,"StructArrayLayout2f1f2i16");class StructArrayLayout2ub2f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=12*e,a=3*e;return this.uint8[o+0]=t,this.uint8[o+1]=i,this.float32[a+1]=r,this.float32[a+2]=n,e}}StructArrayLayout2ub2f12.prototype.bytesPerElement=12,Fo(StructArrayLayout2ub2f12,"StructArrayLayout2ub2f12");class StructArrayLayout3f12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.float32[n+0]=t,this.float32[n+1]=i,this.float32[n+2]=r,e}}StructArrayLayout3f12.prototype.bytesPerElement=12,Fo(StructArrayLayout3f12,"StructArrayLayout3f12");class StructArrayLayout3ui6 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i){const r=this.length;return this.resize(r+1),this.emplace(r,e,t,i)}emplace(e,t,i,r){const n=3*e;return this.uint16[n+0]=t,this.uint16[n+1]=i,this.uint16[n+2]=r,e}}StructArrayLayout3ui6.prototype.bytesPerElement=6,Fo(StructArrayLayout3ui6,"StructArrayLayout3ui6");class StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v){const b=this.length;return this.resize(b+1),this.emplace(b,e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v)}emplace(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v,b){const w=30*e,T=15*e,E=60*e;return this.int16[w+0]=t,this.int16[w+1]=i,this.int16[w+2]=r,this.float32[T+2]=n,this.float32[T+3]=o,this.uint16[w+8]=a,this.uint16[w+9]=s,this.uint32[T+5]=l,this.uint32[T+6]=c,this.uint32[T+7]=u,this.uint16[w+16]=h,this.uint16[w+17]=d,this.uint16[w+18]=p,this.float32[T+10]=f,this.float32[T+11]=m,this.uint8[E+48]=_,this.uint8[E+49]=g,this.uint8[E+50]=y,this.uint32[T+13]=x,this.int16[w+28]=v,this.uint8[E+58]=b,e}}StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60.prototype.bytesPerElement=60,Fo(StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60,"StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60");class StructArrayLayout2f9i15ui1ul4f1ub80 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,T,E,M,S,A,C,I,D,P){const L=this.length;return this.resize(L+1),this.emplace(L,e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,T,E,M,S,A,C,I,D,P)}emplace(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,T,E,M,S,A,C,I,D,P,L){const z=20*e,R=40*e,k=80*e;return this.float32[z+0]=t,this.float32[z+1]=i,this.int16[R+4]=r,this.int16[R+5]=n,this.int16[R+6]=o,this.int16[R+7]=a,this.int16[R+8]=s,this.int16[R+9]=l,this.int16[R+10]=c,this.int16[R+11]=u,this.int16[R+12]=h,this.uint16[R+13]=d,this.uint16[R+14]=p,this.uint16[R+15]=f,this.uint16[R+16]=m,this.uint16[R+17]=_,this.uint16[R+18]=g,this.uint16[R+19]=y,this.uint16[R+20]=x,this.uint16[R+21]=v,this.uint16[R+22]=b,this.uint16[R+23]=w,this.uint16[R+24]=T,this.uint16[R+25]=E,this.uint16[R+26]=M,this.uint16[R+27]=S,this.uint32[z+14]=A,this.float32[z+15]=C,this.float32[z+16]=I,this.float32[z+17]=D,this.float32[z+18]=P,this.uint8[k+76]=L,e}}StructArrayLayout2f9i15ui1ul4f1ub80.prototype.bytesPerElement=80,Fo(StructArrayLayout2f9i15ui1ul4f1ub80,"StructArrayLayout2f9i15ui1ul4f1ub80");class StructArrayLayout1f4 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.float32[1*e+0]=t,e}}StructArrayLayout1f4.prototype.bytesPerElement=4,Fo(StructArrayLayout1f4,"StructArrayLayout1f4");class StructArrayLayout5f20 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n){const o=this.length;return this.resize(o+1),this.emplace(o,e,t,i,r,n)}emplace(e,t,i,r,n,o){const a=5*e;return this.float32[a+0]=t,this.float32[a+1]=i,this.float32[a+2]=r,this.float32[a+3]=n,this.float32[a+4]=o,e}}StructArrayLayout5f20.prototype.bytesPerElement=20,Fo(StructArrayLayout5f20,"StructArrayLayout5f20");class StructArrayLayout7f28 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n,o,a)}emplace(e,t,i,r,n,o,a,s){const l=7*e;return this.float32[l+0]=t,this.float32[l+1]=i,this.float32[l+2]=r,this.float32[l+3]=n,this.float32[l+4]=o,this.float32[l+5]=a,this.float32[l+6]=s,e}}StructArrayLayout7f28.prototype.bytesPerElement=28,Fo(StructArrayLayout7f28,"StructArrayLayout7f28");class StructArrayLayout1ul3ui12 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e,t,i,r){const n=this.length;return this.resize(n+1),this.emplace(n,e,t,i,r)}emplace(e,t,i,r,n){const o=6*e;return this.uint32[3*e+0]=t,this.uint16[o+2]=i,this.uint16[o+3]=r,this.uint16[o+4]=n,e}}StructArrayLayout1ul3ui12.prototype.bytesPerElement=12,Fo(StructArrayLayout1ul3ui12,"StructArrayLayout1ul3ui12");class StructArrayLayout1ui2 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint16[1*e+0]=t,e}}StructArrayLayout1ui2.prototype.bytesPerElement=2,Fo(StructArrayLayout1ui2,"StructArrayLayout1ui2");class StructArrayLayout2f8 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t){const i=this.length;return this.resize(i+1),this.emplace(i,e,t)}emplace(e,t,i){const r=2*e;return this.float32[r+0]=t,this.float32[r+1]=i,e}}StructArrayLayout2f8.prototype.bytesPerElement=8,Fo(StructArrayLayout2f8,"StructArrayLayout2f8");class StructArrayLayout16f64 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m){const _=this.length;return this.resize(_+1),this.emplace(_,e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m)}emplace(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_){const g=16*e;return this.float32[g+0]=t,this.float32[g+1]=i,this.float32[g+2]=r,this.float32[g+3]=n,this.float32[g+4]=o,this.float32[g+5]=a,this.float32[g+6]=s,this.float32[g+7]=l,this.float32[g+8]=c,this.float32[g+9]=u,this.float32[g+10]=h,this.float32[g+11]=d,this.float32[g+12]=p,this.float32[g+13]=f,this.float32[g+14]=m,this.float32[g+15]=_,e}}StructArrayLayout16f64.prototype.bytesPerElement=64,Fo(StructArrayLayout16f64,"StructArrayLayout16f64");class StructArrayLayout4ui3f20 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer)}emplaceBack(e,t,i,r,n,o,a){const s=this.length;return this.resize(s+1),this.emplace(s,e,t,i,r,n,o,a)}emplace(e,t,i,r,n,o,a,s){const l=10*e,c=5*e;return this.uint16[l+0]=t,this.uint16[l+1]=i,this.uint16[l+2]=r,this.uint16[l+3]=n,this.float32[c+2]=o,this.float32[c+3]=a,this.float32[c+4]=s,e}}StructArrayLayout4ui3f20.prototype.bytesPerElement=20,Fo(StructArrayLayout4ui3f20,"StructArrayLayout4ui3f20");class StructArrayLayout1ub1 extends StructArray{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer)}emplaceBack(e){const t=this.length;return this.resize(t+1),this.emplace(t,e)}emplace(e,t){return this.uint8[1*e+0]=t,e}}StructArrayLayout1ub1.prototype.bytesPerElement=1,Fo(StructArrayLayout1ub1,"StructArrayLayout1ub1");class CollisionBoxStruct extends Struct{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.int16[this._pos2+3]}get tileAnchorY(){return this._structArray.int16[this._pos2+4]}get x1(){return this._structArray.float32[this._pos4+3]}get y1(){return this._structArray.float32[this._pos4+4]}get x2(){return this._structArray.float32[this._pos4+5]}get y2(){return this._structArray.float32[this._pos4+6]}get padding(){return this._structArray.int16[this._pos2+14]}get featureIndex(){return this._structArray.uint32[this._pos4+8]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+18]}get bucketIndex(){return this._structArray.uint16[this._pos2+19]}}CollisionBoxStruct.prototype.size=40;class CollisionBoxArray extends StructArrayLayout5i4f1i1ul2ui40{get(e){return new CollisionBoxStruct(this,e)}}Fo(CollisionBoxArray,"CollisionBoxArray");class PlacedSymbolStruct extends Struct{get projectedAnchorX(){return this._structArray.int16[this._pos2+0]}get projectedAnchorY(){return this._structArray.int16[this._pos2+1]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+2]}get tileAnchorX(){return this._structArray.float32[this._pos4+2]}get tileAnchorY(){return this._structArray.float32[this._pos4+3]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+8]}get numGlyphs(){return this._structArray.uint16[this._pos2+9]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+5]}get lineStartIndex(){return this._structArray.uint32[this._pos4+6]}get lineLength(){return this._structArray.uint32[this._pos4+7]}get segment(){return this._structArray.uint16[this._pos2+16]}get lowerSize(){return this._structArray.uint16[this._pos2+17]}get upperSize(){return this._structArray.uint16[this._pos2+18]}get lineOffsetX(){return this._structArray.float32[this._pos4+10]}get lineOffsetY(){return this._structArray.float32[this._pos4+11]}get writingMode(){return this._structArray.uint8[this._pos1+48]}get placedOrientation(){return this._structArray.uint8[this._pos1+49]}set placedOrientation(e){this._structArray.uint8[this._pos1+49]=e}get hidden(){return this._structArray.uint8[this._pos1+50]}set hidden(e){this._structArray.uint8[this._pos1+50]=e}get crossTileID(){return this._structArray.uint32[this._pos4+13]}set crossTileID(e){this._structArray.uint32[this._pos4+13]=e}get associatedIconIndex(){return this._structArray.int16[this._pos2+28]}get flipState(){return this._structArray.uint8[this._pos1+58]}set flipState(e){this._structArray.uint8[this._pos1+58]=e}}PlacedSymbolStruct.prototype.size=60;class PlacedSymbolArray extends StructArrayLayout3i2f2ui3ul3ui2f3ub1ul1i1ub60{get(e){return new PlacedSymbolStruct(this,e)}}Fo(PlacedSymbolArray,"PlacedSymbolArray");class SymbolInstanceStruct extends Struct{get tileAnchorX(){return this._structArray.float32[this._pos4+0]}get tileAnchorY(){return this._structArray.float32[this._pos4+1]}get projectedAnchorX(){return this._structArray.int16[this._pos2+4]}get projectedAnchorY(){return this._structArray.int16[this._pos2+5]}get projectedAnchorZ(){return this._structArray.int16[this._pos2+6]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+7]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+8]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+9]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+10]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+11]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+12]}get key(){return this._structArray.uint16[this._pos2+13]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+14]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+15]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+16]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+17]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+18]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+19]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+20]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+21]}get featureIndex(){return this._structArray.uint16[this._pos2+22]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+23]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+24]}get numIconVertices(){return this._structArray.uint16[this._pos2+25]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+26]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+27]}get crossTileID(){return this._structArray.uint32[this._pos4+14]}set crossTileID(e){this._structArray.uint32[this._pos4+14]=e}get textOffset0(){return this._structArray.float32[this._pos4+15]}get textOffset1(){return this._structArray.float32[this._pos4+16]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+17]}get zOffset(){return this._structArray.float32[this._pos4+18]}set zOffset(e){this._structArray.float32[this._pos4+18]=e}get hasIconTextFit(){return this._structArray.uint8[this._pos1+76]}}SymbolInstanceStruct.prototype.size=80;class SymbolInstanceArray extends StructArrayLayout2f9i15ui1ul4f1ub80{get(e){return new SymbolInstanceStruct(this,e)}}Fo(SymbolInstanceArray,"SymbolInstanceArray");class GlyphOffsetArray extends StructArrayLayout1f4{getoffsetX(e){return this.float32[1*e+0]}}Fo(GlyphOffsetArray,"GlyphOffsetArray");class SymbolLineVertexArray extends StructArrayLayout2i4{getx(e){return this.int16[2*e+0]}gety(e){return this.int16[2*e+1]}}Fo(SymbolLineVertexArray,"SymbolLineVertexArray");class FeatureIndexStruct extends Struct{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}FeatureIndexStruct.prototype.size=12;class FeatureIndexArray extends StructArrayLayout1ul3ui12{get(e){return new FeatureIndexStruct(this,e)}}Fo(FeatureIndexArray,"FeatureIndexArray");class FillExtrusionCentroidArray extends StructArrayLayout2ui4{geta_centroid_pos0(e){return this.uint16[2*e+0]}geta_centroid_pos1(e){return this.uint16[2*e+1]}}Fo(FillExtrusionCentroidArray,"FillExtrusionCentroidArray");const pa=ha([{name:"a_pos",components:2,type:"Int16"}],4),fa=ha([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]);class SegmentVector{constructor(e=[]){this.segments=e}_prepareSegment(e,t,i,r){let n=this.segments[this.segments.length-1];return e>SegmentVector.MAX_VERTEX_ARRAY_LENGTH&&$(`Max vertices per segment is ${SegmentVector.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${e}`),(!n||n.vertexLength+e>SegmentVector.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==r)&&(n={vertexOffset:t,primitiveOffset:i,vertexLength:0,primitiveLength:0},void 0!==r&&(n.sortKey=r),this.segments.push(n)),n}prepareSegment(e,t,i,r){return this._prepareSegment(e,t.length,i.length,r)}get(){return this.segments}destroy(){for(const e of this.segments)for(const t in e.vaos)e.vaos[t].destroy()}static simpleSegment(e,t,i,r){return new SegmentVector([{vertexOffset:e,primitiveOffset:t,vertexLength:i,primitiveLength:r,vaos:{},sortKey:0}])}}function ma(e,t){return 256*(e=I(Math.floor(e),0,255))+I(Math.floor(t),0,255)}SegmentVector.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Fo(SegmentVector,"SegmentVector");const _a=ha([{name:"a_pattern",components:4,type:"Uint16"},{name:"a_pixel_ratio",components:1,type:"Float32"}]),ga=ha([{name:"a_dash",components:4,type:"Uint16"}]);var ya={exports:{}},xa={exports:{}};!function(e){e.exports=function(e,t){var i,r,n,o,a,s,l,c;for(r=e.length-(i=3&e.length),n=t,a=3432918353,s=461845907,c=0;c<r;)l=255&e.charCodeAt(c)|(255&e.charCodeAt(++c))<<8|(255&e.charCodeAt(++c))<<16|(255&e.charCodeAt(++c))<<24,++c,n=27492+(65535&(o=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*s+(((l>>>16)*s&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(o>>>16)&65535)<<16);switch(l=0,i){case 3:l^=(255&e.charCodeAt(c+2))<<16;case 2:l^=(255&e.charCodeAt(c+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&e.charCodeAt(c)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*s+(((l>>>16)*s&65535)<<16)&4294967295}return n^=e.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0}}(xa);var va=xa.exports,ba={exports:{}};!function(e){e.exports=function(e,t){for(var i,r=e.length,n=t^r,o=0;r>=4;)i=1540483477*(65535&(i=255&e.charCodeAt(o)|(255&e.charCodeAt(++o))<<8|(255&e.charCodeAt(++o))<<16|(255&e.charCodeAt(++o))<<24))+((1540483477*(i>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(i=1540483477*(65535&(i^=i>>>24))+((1540483477*(i>>>16)&65535)<<16)),r-=4,++o;switch(r){case 3:n^=(255&e.charCodeAt(o+2))<<16;case 2:n^=(255&e.charCodeAt(o+1))<<8;case 1:n=1540483477*(65535&(n^=255&e.charCodeAt(o)))+((1540483477*(n>>>16)&65535)<<16)}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0}}(ba);var wa=va,Ta=ba.exports;ya.exports=wa,ya.exports.murmur3=wa,ya.exports.murmur2=Ta;var Ea=h(ya.exports);class FeaturePositionMap{constructor(){this.ids=[],this.uniqueIds=[],this.positions=[],this.indexed=!1}add(e,t,i,r){this.ids.push(Ma(e)),this.positions.push(t,i,r)}eachPosition(e,t){const i=Ma(e);let r=0,n=this.ids.length-1;for(;r<n;){const e=r+n>>1;this.ids[e]>=i?n=e:r=e+1}for(;this.ids[r]===i;)t(this.positions[3*r],this.positions[3*r+1],this.positions[3*r+2]),r++}static serialize(e,t){const i=new Float64Array(e.ids),r=new Uint32Array(e.positions);return Sa(i,r,0,i.length-1),t&&(t.add(i.buffer),t.add(r.buffer)),{ids:i,positions:r}}static deserialize(e){const t=new FeaturePositionMap;let i;t.ids=e.ids,t.positions=e.positions;for(const e of t.ids)e!==i&&t.uniqueIds.push(e),i=e;return t.indexed=!0,t}}function Ma(e){const t=+e;return!isNaN(t)&&Number.MIN_SAFE_INTEGER<=t&&t<=Number.MAX_SAFE_INTEGER?t:Ea(String(e))}function Sa(e,t,i,r){for(;i<r;){const n=e[i+r>>1];let o=i-1,a=r+1;for(;;){do{o++}while(e[o]<n);do{a--}while(e[a]>n);if(o>=a)break;Aa(e,o,a),Aa(t,3*o,3*a),Aa(t,3*o+1,3*a+1),Aa(t,3*o+2,3*a+2)}a-i<r-a?(Sa(e,t,i,a),i=a+1):(Sa(e,t,a+1,r),r=a)}}function Aa(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}Fo(FeaturePositionMap,"FeaturePositionMap");class Uniform{constructor(e){this.gl=e.gl,this.initialized=!1}fetchUniformLocation(e,t){return this.location||this.initialized||(this.location=this.gl.getUniformLocation(e,t),this.initialized=!0),!!this.location}}class Uniform1i extends Uniform{constructor(e){super(e),this.current=0}set(e,t,i){this.fetchUniformLocation(e,t)&&this.current!==i&&(this.current=i,this.gl.uniform1i(this.location,i))}}class Uniform1f extends Uniform{constructor(e){super(e),this.current=0}set(e,t,i){this.fetchUniformLocation(e,t)&&this.current!==i&&(this.current=i,this.gl.uniform1f(this.location,i))}}class Uniform2f extends Uniform{constructor(e){super(e),this.current=[0,0]}set(e,t,i){this.fetchUniformLocation(e,t)&&(i[0]===this.current[0]&&i[1]===this.current[1]||(this.current=i,this.gl.uniform2f(this.location,i[0],i[1])))}}class Uniform3f extends Uniform{constructor(e){super(e),this.current=[0,0,0]}set(e,t,i){this.fetchUniformLocation(e,t)&&(i[0]===this.current[0]&&i[1]===this.current[1]&&i[2]===this.current[2]||(this.current=i,this.gl.uniform3f(this.location,i[0],i[1],i[2])))}}class Uniform4f extends Uniform{constructor(e){super(e),this.current=[0,0,0,0]}set(e,t,i){this.fetchUniformLocation(e,t)&&(i[0]===this.current[0]&&i[1]===this.current[1]&&i[2]===this.current[2]&&i[3]===this.current[3]||(this.current=i,this.gl.uniform4f(this.location,i[0],i[1],i[2],i[3])))}}class UniformColor extends Uniform{constructor(e){super(e),this.current=Wt.transparent}set(e,t,i){this.fetchUniformLocation(e,t)&&(i.r===this.current.r&&i.g===this.current.g&&i.b===this.current.b&&i.a===this.current.a||(this.current=i,this.gl.uniform4f(this.location,i.r,i.g,i.b,i.a)))}}const Ca=new Float32Array(16);class UniformMatrix4f extends Uniform{constructor(e){super(e),this.current=Ca}set(e,t,i){if(this.fetchUniformLocation(e,t)){if(i[12]!==this.current[12]||i[0]!==this.current[0])return this.current=i,void this.gl.uniformMatrix4fv(this.location,!1,i);for(let e=1;e<16;e++)if(i[e]!==this.current[e]){this.current=i,this.gl.uniformMatrix4fv(this.location,!1,i);break}}}}const Ia=new Float32Array(9);class UniformMatrix3f extends Uniform{constructor(e){super(e),this.current=Ia}set(e,t,i){if(this.fetchUniformLocation(e,t))for(let e=0;e<9;e++)if(i[e]!==this.current[e]){this.current=i,this.gl.uniformMatrix3fv(this.location,!1,i);break}}}const Da=new Float32Array(4);class UniformMatrix2f extends Uniform{constructor(e){super(e),this.current=Da}set(e,t,i){if(this.fetchUniformLocation(e,t))for(let e=0;e<4;e++)if(i[e]!==this.current[e]){this.current=i,this.gl.uniformMatrix2fv(this.location,!1,i);break}}}function Pa(e){return[ma(255*e.r,255*e.g),ma(255*e.b,255*e.a)]}class ConstantBinder{constructor(e,t,i){this.value=e,this.uniformNames=t.map((e=>`u_${e}`)),this.type=i}setUniform(e,t,i,r,n){t.set(e,n,r.constantOr(this.value))}getBinding(e,t){return"color"===this.type?new UniformColor(e):new Uniform1f(e)}}class PatternConstantBinder{constructor(e,t){this.uniformNames=t.map((e=>`u_${e}`)),this.pattern=null,this.pixelRatio=1}setConstantPatternPositions(e){this.pixelRatio=e.pixelRatio||1,this.pattern=e.tl.concat(e.br)}setUniform(e,t,i,r,n){const o="u_pattern"===n||"u_dash"===n?this.pattern:"u_pixel_ratio"===n?this.pixelRatio:null;o&&t.set(e,n,o)}getBinding(e,t){return"u_pattern"===t||"u_dash"===t?new Uniform4f(e):new Uniform1f(e)}}class SourceExpressionBinder{constructor(e,t,i,r){this.expression=e,this.type=i,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===i?2:1,offset:0}))),this.paintVertexArray=new r}populatePaintArray(e,t,i,r,n,o,a){const s=this.paintVertexArray.length,l=this.expression.evaluate(new EvaluationParameters(0,{brightness:o}),t,{},n,r,a);this.paintVertexArray.resize(e),this._setPaintValue(s,e,l)}updatePaintArray(e,t,i,r,n,o,a){const s=this.expression.evaluate({zoom:0,brightness:a},i,r,void 0,n);this._setPaintValue(e,t,s)}_setPaintValue(e,t,i){if("color"===this.type){const r=Pa(i);for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,r[0],r[1])}else{for(let r=e;r<t;r++)this.paintVertexArray.emplace(r,i);this.maxValue=Math.max(this.maxValue,Math.abs(i))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class CompositeExpressionBinder{constructor(e,t,i,r,n,o){this.expression=e,this.uniformNames=t.map((e=>`u_${e}_t`)),this.type=i,this.useIntegerZoom=r,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=t.map((e=>({name:`a_${e}`,type:"Float32",components:"color"===i?4:2,offset:0}))),this.paintVertexArray=new o}populatePaintArray(e,t,i,r,n,o,a){const s=this.expression.evaluate(new EvaluationParameters(this.zoom,{brightness:o}),t,{},n,r,a),l=this.expression.evaluate(new EvaluationParameters(this.zoom+1,{brightness:o}),t,{},n,r,a),c=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValue(c,e,s,l)}updatePaintArray(e,t,i,r,n,o,a){const s=this.expression.evaluate({zoom:this.zoom,brightness:a},i,r,void 0,n),l=this.expression.evaluate({zoom:this.zoom+1,brightness:a},i,r,void 0,n);this._setPaintValue(e,t,s,l)}_setPaintValue(e,t,i,r){if("color"===this.type){const n=Pa(i),o=Pa(r);for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,n[0],n[1],o[0],o[1])}else{for(let n=e;n<t;n++)this.paintVertexArray.emplace(n,i,r);this.maxValue=Math.max(this.maxValue,Math.abs(i),Math.abs(r))}}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}setUniform(e,t,i,r,n){const o=this.useIntegerZoom?Math.floor(i.zoom):i.zoom,a=I(this.expression.interpolationFactor(o,this.zoom,this.zoom+1),0,1);t.set(e,n,a)}getBinding(e,t){return new Uniform1f(e)}}class PatternCompositeBinder{constructor(e,t,i,r,n){this.expression=e,this.layerId=n,this.paintVertexAttributes=("array"===i?ga:_a).members;for(let e=0;e<t.length;++e);this.paintVertexArray=new r}populatePaintArray(e,t,i){const r=this.paintVertexArray.length;this.paintVertexArray.resize(e),this._setPaintValues(r,e,t.patterns&&t.patterns[this.layerId],i)}updatePaintArray(e,t,i,r,n,o,a){this._setPaintValues(e,t,i.patterns&&i.patterns[this.layerId],o)}_setPaintValues(e,t,i,r){if(!r||!i)return;const n=r[i];if(!n)return;const{tl:o,br:a,pixelRatio:s}=n;for(let i=e;i<t;i++)this.paintVertexArray.emplace(i,o[0],o[1],a[0],a[1],s)}upload(e){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer=e.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent||!this.expression.isLightConstant))}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy()}}class ProgramConfiguration{constructor(e,t,i=(()=>!0)){this.binders={},this._buffers=[];const r=[];for(const n in e.paint._values){const o=e.paint.get(n);if(!i(n))continue;if(!(o instanceof PossiblyEvaluatedPropertyValue&&gn(o.property.specification)))continue;const a=za(n,e.type),s=o.value,l=o.property.specification.type,c=!!o.property.useIntegerZoom,u="line-dasharray"===n||n.endsWith("pattern"),h="line-dasharray"===n&&"constant"!==e.layout.get("line-cap").value.kind;if("constant"!==s.kind||h)if("source"===s.kind||h||u){const t=Ba(n,l,"source");this.binders[n]=u?new PatternCompositeBinder(s,a,l,t,e.id):new SourceExpressionBinder(s,a,l,t),r.push(`/a_${n}`)}else{const e=Ba(n,l,"composite");this.binders[n]=new CompositeExpressionBinder(s,a,l,c,t,e),r.push(`/z_${n}`)}else this.binders[n]=u?new PatternConstantBinder(s.value,a):new ConstantBinder(s.value,a,l),r.push(`/u_${n}`)}this.cacheKey=r.sort().join("")}getMaxValue(e){const t=this.binders[e];return t instanceof SourceExpressionBinder||t instanceof CompositeExpressionBinder?t.maxValue:0}populatePaintArrays(e,t,i,r,n,o,a){for(const s in this.binders){const l=this.binders[s];(l instanceof SourceExpressionBinder||l instanceof CompositeExpressionBinder||l instanceof PatternCompositeBinder)&&l.populatePaintArray(e,t,i,r,n,o,a)}}setConstantPatternPositions(e){for(const t in this.binders){const i=this.binders[t];i instanceof PatternConstantBinder&&i.setConstantPatternPositions(e)}}updatePaintArrays(e,t,i,r,n,o,a,s){let l=!1;const c=Object.keys(e),u=0!==c.length,h=u?c:t.uniqueIds;for(const c in this.binders){const d=this.binders[c];if((d instanceof SourceExpressionBinder||d instanceof CompositeExpressionBinder||d instanceof PatternCompositeBinder)&&(!0===d.expression.isStateDependent||!1===d.expression.isLightConstant)){const p=n.paint.get(c);d.expression=p.value;for(const i of h){const n=e[i.toString()];t.eachPosition(i,((e,t,i)=>{const l=r.feature(e);d.updatePaintArray(t,i,l,n,o,a,s)}))}if(!u)for(const t of i.uniqueIds){const n=e[t.toString()];i.eachPosition(t,((e,t,i)=>{const l=r.feature(e);d.updatePaintArray(t,i,l,n,o,a,s)}))}l=!0}}return l}defines(){const e=[];for(const t in this.binders){const i=this.binders[t];(i instanceof ConstantBinder||i instanceof PatternConstantBinder)&&e.push(...i.uniformNames.map((e=>`#define HAS_UNIFORM_${e}`)))}return e}getBinderAttributes(){const e=[];for(const t in this.binders){const i=this.binders[t];if(i instanceof SourceExpressionBinder||i instanceof CompositeExpressionBinder||i instanceof PatternCompositeBinder)for(let t=0;t<i.paintVertexAttributes.length;t++)e.push(i.paintVertexAttributes[t].name)}return e}getBinderUniforms(){const e=[];for(const t in this.binders){const i=this.binders[t];if(i instanceof ConstantBinder||i instanceof PatternConstantBinder||i instanceof CompositeExpressionBinder)for(const t of i.uniformNames)e.push(t)}return e}getPaintVertexBuffers(){return this._buffers}getUniforms(e){const t=[];for(const i in this.binders){const r=this.binders[i];if(r instanceof ConstantBinder||r instanceof PatternConstantBinder||r instanceof CompositeExpressionBinder)for(const n of r.uniformNames)t.push({name:n,property:i,binding:r.getBinding(e,n)})}return t}setUniforms(e,t,i,r,n){for(const{name:t,property:o,binding:a}of i)this.binders[o].setUniform(e,a,n,r.get(o),t)}updatePaintBuffers(){this._buffers=[];for(const e in this.binders){const t=this.binders[e];(t instanceof SourceExpressionBinder||t instanceof CompositeExpressionBinder||t instanceof PatternCompositeBinder)&&t.paintVertexBuffer&&this._buffers.push(t.paintVertexBuffer)}}upload(e){for(const t in this.binders){const i=this.binders[t];(i instanceof SourceExpressionBinder||i instanceof CompositeExpressionBinder||i instanceof PatternCompositeBinder)&&i.upload(e)}this.updatePaintBuffers()}destroy(){for(const e in this.binders){const t=this.binders[e];(t instanceof SourceExpressionBinder||t instanceof CompositeExpressionBinder||t instanceof PatternCompositeBinder)&&t.destroy()}}}class ProgramConfigurationSet{constructor(e,t,i=(()=>!0)){this.programConfigurations={};for(const r of e)this.programConfigurations[r.id]=new ProgramConfiguration(r,t,i);this.needsUpload=!1,this._featureMap=new FeaturePositionMap,this._featureMapWithoutIds=new FeaturePositionMap,this._bufferOffset=0,this._idlessCounter=0}populatePaintArrays(e,t,i,r,n,o,a,s){for(const i in this.programConfigurations)this.programConfigurations[i].populatePaintArrays(e,t,r,n,o,a,s);void 0!==t.id?this._featureMap.add(t.id,i,this._bufferOffset,e):(this._featureMapWithoutIds.add(this._idlessCounter,i,this._bufferOffset,e),this._idlessCounter+=1),this._bufferOffset=e,this.needsUpload=!0}updatePaintArrays(e,t,i,r,n,o){for(const a of i)this.needsUpload=this.programConfigurations[a.id].updatePaintArrays(e,this._featureMap,this._featureMapWithoutIds,t,a,r,n,o||0)||this.needsUpload}get(e){return this.programConfigurations[e]}upload(e){if(this.needsUpload){for(const t in this.programConfigurations)this.programConfigurations[t].upload(e);this.needsUpload=!1}}destroy(){for(const e in this.programConfigurations)this.programConfigurations[e].destroy()}}const La={"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-emissive-strength":["emissive_strength"],"icon-emissive-strength":["emissive_strength"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern","pixel_ratio"],"fill-pattern":["pattern","pixel_ratio"],"fill-extrusion-pattern":["pattern","pixel_ratio"],"line-dasharray":["dash"]};function za(e,t){return La[e]||[e.replace(`${t}-`,"").replace(/-/g,"_")]}const Ra={"line-pattern":{source:StructArrayLayout4ui1f12,composite:StructArrayLayout4ui1f12},"fill-pattern":{source:StructArrayLayout4ui1f12,composite:StructArrayLayout4ui1f12},"fill-extrusion-pattern":{source:StructArrayLayout4ui1f12,composite:StructArrayLayout4ui1f12},"line-dasharray":{source:StructArrayLayout4ui8,composite:StructArrayLayout4ui8}},ka={color:{source:StructArrayLayout2f8,composite:StructArrayLayout4f16},number:{source:StructArrayLayout1f4,composite:StructArrayLayout2f8}};function Ba(e,t,i){const r=Ra[e];return r&&r[i]||ka[t][i]}Fo(ConstantBinder,"ConstantBinder"),Fo(PatternConstantBinder,"PatternConstantBinder"),Fo(SourceExpressionBinder,"SourceExpressionBinder"),Fo(PatternCompositeBinder,"PatternCompositeBinder"),Fo(CompositeExpressionBinder,"CompositeExpressionBinder"),Fo(ProgramConfiguration,"ProgramConfiguration",{omit:["_buffers"]}),Fo(ProgramConfigurationSet,"ProgramConfigurationSet");class LngLatBounds{constructor(e,t){e&&(t?this.setSouthWest(e).setNorthEast(t):4===e.length?this.setSouthWest([e[0],e[1]]).setNorthEast([e[2],e[3]]):this.setSouthWest(e[0]).setNorthEast(e[1]))}setNorthEast(e){return this._ne=e instanceof du?new du(e.lng,e.lat):du.convert(e),this}setSouthWest(e){return this._sw=e instanceof du?new du(e.lng,e.lat):du.convert(e),this}extend(e){const t=this._sw,i=this._ne;let r,n;if(e instanceof du)r=e,n=e;else{if(!(e instanceof LngLatBounds))return Array.isArray(e)?4===e.length||e.every(Array.isArray)?this.extend(LngLatBounds.convert(e)):this.extend(du.convert(e)):"object"==typeof e&&null!==e&&e.hasOwnProperty("lat")&&(e.hasOwnProperty("lon")||e.hasOwnProperty("lng"))?this.extend(du.convert(e)):this;if(r=e._sw,n=e._ne,!r||!n)return this}return t||i?(t.lng=Math.min(r.lng,t.lng),t.lat=Math.min(r.lat,t.lat),i.lng=Math.max(n.lng,i.lng),i.lat=Math.max(n.lat,i.lat)):(this._sw=new du(r.lng,r.lat),this._ne=new du(n.lng,n.lat)),this}getCenter(){return new du((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new du(this.getWest(),this.getNorth())}getSouthEast(){return new du(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return[this._sw.toArray(),this._ne.toArray()]}toString(){return`LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return!(this._sw&&this._ne)}contains(e){const{lng:t,lat:i}=du.convert(e);let r=this._sw.lng<=t&&t<=this._ne.lng;return this._sw.lng>this._ne.lng&&(r=this._sw.lng>=t&&t>=this._ne.lng),this._sw.lat<=i&&i<=this._ne.lat&&r}static convert(e){return!e||e instanceof LngLatBounds?e:new LngLatBounds(e)}}var Oa={},Fa={};Object.defineProperty(Fa,"__esModule",{value:!0}),Fa.setMatrixArrayType=function(e){Fa.ARRAY_TYPE=Va=e},Fa.toRadian=function(e){return e*ja},Fa.equals=function(e,t){return Math.abs(e-t)<=Ua*Math.max(1,Math.abs(e),Math.abs(t))},Fa.RANDOM=Fa.ARRAY_TYPE=Fa.EPSILON=void 0;var Ua=1e-6;Fa.EPSILON=Ua;var Va="undefined"!=typeof Float32Array?Float32Array:Array;Fa.ARRAY_TYPE=Va;var Na=Math.random;Fa.RANDOM=Na;var ja=Math.PI/180;Math.hypot||(Math.hypot=function(){for(var e=0,t=arguments.length;t--;)e+=arguments[t]*arguments[t];return Math.sqrt(e)});var Ga={};function qa(e){return qa="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},qa(e)}Object.defineProperty(Ga,"__esModule",{value:!0}),Ga.create=function(){var e=new Za.ARRAY_TYPE(4);return Za.ARRAY_TYPE!=Float32Array&&(e[1]=0,e[2]=0),e[0]=1,e[3]=1,e},Ga.clone=function(e){var t=new Za.ARRAY_TYPE(4);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},Ga.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e},Ga.identity=function(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=1,e},Ga.fromValues=function(e,t,i,r){var n=new Za.ARRAY_TYPE(4);return n[0]=e,n[1]=t,n[2]=i,n[3]=r,n},Ga.set=function(e,t,i,r,n){return e[0]=t,e[1]=i,e[2]=r,e[3]=n,e},Ga.transpose=function(e,t){if(e===t){var i=t[1];e[1]=t[2],e[2]=i}else e[0]=t[0],e[1]=t[2],e[2]=t[1],e[3]=t[3];return e},Ga.invert=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=i*o-n*r;return a?(e[0]=o*(a=1/a),e[1]=-r*a,e[2]=-n*a,e[3]=i*a,e):null},Ga.adjoint=function(e,t){var i=t[0];return e[0]=t[3],e[1]=-t[1],e[2]=-t[2],e[3]=i,e},Ga.determinant=function(e){return e[0]*e[3]-e[2]*e[1]},Ga.multiply=Ha,Ga.rotate=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=Math.sin(i),l=Math.cos(i);return e[0]=r*l+o*s,e[1]=n*l+a*s,e[2]=r*-s+o*l,e[3]=n*-s+a*l,e},Ga.scale=function(e,t,i){var r=t[1],n=t[2],o=t[3],a=i[0],s=i[1];return e[0]=t[0]*a,e[1]=r*a,e[2]=n*s,e[3]=o*s,e},Ga.fromRotation=function(e,t){var i=Math.sin(t),r=Math.cos(t);return e[0]=r,e[1]=i,e[2]=-i,e[3]=r,e},Ga.fromScaling=function(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=t[1],e},Ga.str=function(e){return"mat2("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+")"},Ga.frob=function(e){return Math.hypot(e[0],e[1],e[2],e[3])},Ga.LDU=function(e,t,i,r){return e[2]=r[2]/r[0],i[0]=r[0],i[1]=r[1],i[3]=r[3]-e[2]*i[1],[e,t,i]},Ga.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e[3]=t[3]+i[3],e},Ga.subtract=Wa,Ga.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Ga.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=e[3],a=t[0],s=t[1],l=t[2],c=t[3];return Math.abs(i-a)<=Za.EPSILON*Math.max(1,Math.abs(i),Math.abs(a))&&Math.abs(r-s)<=Za.EPSILON*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-l)<=Za.EPSILON*Math.max(1,Math.abs(n),Math.abs(l))&&Math.abs(o-c)<=Za.EPSILON*Math.max(1,Math.abs(o),Math.abs(c))},Ga.multiplyScalar=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e},Ga.multiplyScalarAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e[3]=t[3]+i[3]*r,e},Ga.sub=Ga.mul=void 0;var Za=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==qa(e)&&"function"!=typeof e)return{default:e};var i=$a(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function $a(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return($a=function(e){return e?i:t})(e)}function Ha(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=i[0],l=i[1],c=i[2],u=i[3];return e[0]=r*s+o*l,e[1]=n*s+a*l,e[2]=r*c+o*u,e[3]=n*c+a*u,e}function Wa(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e[3]=t[3]-i[3],e}Ga.mul=Ha,Ga.sub=Wa;var Xa={};function Ya(e){return Ya="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Ya(e)}Object.defineProperty(Xa,"__esModule",{value:!0}),Xa.create=function(){var e=new Ka.ARRAY_TYPE(6);return Ka.ARRAY_TYPE!=Float32Array&&(e[1]=0,e[2]=0,e[4]=0,e[5]=0),e[0]=1,e[3]=1,e},Xa.clone=function(e){var t=new Ka.ARRAY_TYPE(6);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t},Xa.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e},Xa.identity=function(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=1,e[4]=0,e[5]=0,e},Xa.fromValues=function(e,t,i,r,n,o){var a=new Ka.ARRAY_TYPE(6);return a[0]=e,a[1]=t,a[2]=i,a[3]=r,a[4]=n,a[5]=o,a},Xa.set=function(e,t,i,r,n,o,a){return e[0]=t,e[1]=i,e[2]=r,e[3]=n,e[4]=o,e[5]=a,e},Xa.invert=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=i*o-r*n;return l?(e[0]=o*(l=1/l),e[1]=-r*l,e[2]=-n*l,e[3]=i*l,e[4]=(n*s-o*a)*l,e[5]=(r*a-i*s)*l,e):null},Xa.determinant=function(e){return e[0]*e[3]-e[1]*e[2]},Xa.multiply=Qa,Xa.rotate=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=Math.sin(i),u=Math.cos(i);return e[0]=r*u+o*c,e[1]=n*u+a*c,e[2]=r*-c+o*u,e[3]=n*-c+a*u,e[4]=s,e[5]=l,e},Xa.scale=function(e,t,i){var r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=i[0],c=i[1];return e[0]=t[0]*l,e[1]=r*l,e[2]=n*c,e[3]=o*c,e[4]=a,e[5]=s,e},Xa.translate=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=i[0],u=i[1];return e[0]=r,e[1]=n,e[2]=o,e[3]=a,e[4]=r*c+o*u+s,e[5]=n*c+a*u+l,e},Xa.fromRotation=function(e,t){var i=Math.sin(t),r=Math.cos(t);return e[0]=r,e[1]=i,e[2]=-i,e[3]=r,e[4]=0,e[5]=0,e},Xa.fromScaling=function(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=t[1],e[4]=0,e[5]=0,e},Xa.fromTranslation=function(e,t){return e[0]=1,e[1]=0,e[2]=0,e[3]=1,e[4]=t[0],e[5]=t[1],e},Xa.str=function(e){return"mat2d("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+", "+e[4]+", "+e[5]+")"},Xa.frob=function(e){return Math.hypot(e[0],e[1],e[2],e[3],e[4],e[5],1)},Xa.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e[3]=t[3]+i[3],e[4]=t[4]+i[4],e[5]=t[5]+i[5],e},Xa.subtract=es,Xa.multiplyScalar=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e[4]=t[4]*i,e[5]=t[5]*i,e},Xa.multiplyScalarAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e[3]=t[3]+i[3]*r,e[4]=t[4]+i[4]*r,e[5]=t[5]+i[5]*r,e},Xa.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]},Xa.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=e[3],a=e[4],s=e[5],l=t[0],c=t[1],u=t[2],h=t[3],d=t[4],p=t[5];return Math.abs(i-l)<=Ka.EPSILON*Math.max(1,Math.abs(i),Math.abs(l))&&Math.abs(r-c)<=Ka.EPSILON*Math.max(1,Math.abs(r),Math.abs(c))&&Math.abs(n-u)<=Ka.EPSILON*Math.max(1,Math.abs(n),Math.abs(u))&&Math.abs(o-h)<=Ka.EPSILON*Math.max(1,Math.abs(o),Math.abs(h))&&Math.abs(a-d)<=Ka.EPSILON*Math.max(1,Math.abs(a),Math.abs(d))&&Math.abs(s-p)<=Ka.EPSILON*Math.max(1,Math.abs(s),Math.abs(p))},Xa.sub=Xa.mul=void 0;var Ka=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==Ya(e)&&"function"!=typeof e)return{default:e};var i=Ja(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function Ja(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(Ja=function(e){return e?i:t})(e)}function Qa(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=i[0],u=i[1],h=i[2],d=i[3],p=i[4],f=i[5];return e[0]=r*c+o*u,e[1]=n*c+a*u,e[2]=r*h+o*d,e[3]=n*h+a*d,e[4]=r*p+o*f+s,e[5]=n*p+a*f+l,e}function es(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e[3]=t[3]-i[3],e[4]=t[4]-i[4],e[5]=t[5]-i[5],e}Xa.mul=Qa,Xa.sub=es;var ts={};function is(e){return is="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},is(e)}Object.defineProperty(ts,"__esModule",{value:!0}),ts.create=function(){var e=new rs.ARRAY_TYPE(9);return rs.ARRAY_TYPE!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[5]=0,e[6]=0,e[7]=0),e[0]=1,e[4]=1,e[8]=1,e},ts.fromMat4=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[4],e[4]=t[5],e[5]=t[6],e[6]=t[8],e[7]=t[9],e[8]=t[10],e},ts.clone=function(e){var t=new rs.ARRAY_TYPE(9);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t},ts.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e},ts.fromValues=function(e,t,i,r,n,o,a,s,l){var c=new rs.ARRAY_TYPE(9);return c[0]=e,c[1]=t,c[2]=i,c[3]=r,c[4]=n,c[5]=o,c[6]=a,c[7]=s,c[8]=l,c},ts.set=function(e,t,i,r,n,o,a,s,l,c){return e[0]=t,e[1]=i,e[2]=r,e[3]=n,e[4]=o,e[5]=a,e[6]=s,e[7]=l,e[8]=c,e},ts.identity=function(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=1,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e},ts.transpose=function(e,t){if(e===t){var i=t[1],r=t[2],n=t[5];e[1]=t[3],e[2]=t[6],e[3]=i,e[5]=t[7],e[6]=r,e[7]=n}else e[0]=t[0],e[1]=t[3],e[2]=t[6],e[3]=t[1],e[4]=t[4],e[5]=t[7],e[6]=t[2],e[7]=t[5],e[8]=t[8];return e},ts.invert=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=t[6],c=t[7],u=t[8],h=u*a-s*c,d=-u*o+s*l,p=c*o-a*l,f=i*h+r*d+n*p;return f?(e[0]=h*(f=1/f),e[1]=(-u*r+n*c)*f,e[2]=(s*r-n*a)*f,e[3]=d*f,e[4]=(u*i-n*l)*f,e[5]=(-s*i+n*o)*f,e[6]=p*f,e[7]=(-c*i+r*l)*f,e[8]=(a*i-r*o)*f,e):null},ts.adjoint=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=t[6],c=t[7],u=t[8];return e[0]=a*u-s*c,e[1]=n*c-r*u,e[2]=r*s-n*a,e[3]=s*l-o*u,e[4]=i*u-n*l,e[5]=n*o-i*s,e[6]=o*c-a*l,e[7]=r*l-i*c,e[8]=i*a-r*o,e},ts.determinant=function(e){var t=e[3],i=e[4],r=e[5],n=e[6],o=e[7],a=e[8];return e[0]*(a*i-r*o)+e[1]*(-a*t+r*n)+e[2]*(o*t-i*n)},ts.multiply=os,ts.translate=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=i[0],p=i[1];return e[0]=r,e[1]=n,e[2]=o,e[3]=a,e[4]=s,e[5]=l,e[6]=d*r+p*a+c,e[7]=d*n+p*s+u,e[8]=d*o+p*l+h,e},ts.rotate=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=Math.sin(i),p=Math.cos(i);return e[0]=p*r+d*a,e[1]=p*n+d*s,e[2]=p*o+d*l,e[3]=p*a-d*r,e[4]=p*s-d*n,e[5]=p*l-d*o,e[6]=c,e[7]=u,e[8]=h,e},ts.scale=function(e,t,i){var r=i[0],n=i[1];return e[0]=r*t[0],e[1]=r*t[1],e[2]=r*t[2],e[3]=n*t[3],e[4]=n*t[4],e[5]=n*t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e},ts.fromTranslation=function(e,t){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=1,e[5]=0,e[6]=t[0],e[7]=t[1],e[8]=1,e},ts.fromRotation=function(e,t){var i=Math.sin(t),r=Math.cos(t);return e[0]=r,e[1]=i,e[2]=0,e[3]=-i,e[4]=r,e[5]=0,e[6]=0,e[7]=0,e[8]=1,e},ts.fromScaling=function(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=0,e[4]=t[1],e[5]=0,e[6]=0,e[7]=0,e[8]=1,e},ts.fromMat2d=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=0,e[3]=t[2],e[4]=t[3],e[5]=0,e[6]=t[4],e[7]=t[5],e[8]=1,e},ts.fromQuat=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=i+i,s=r+r,l=n+n,c=i*a,u=r*a,h=r*s,d=n*a,p=n*s,f=n*l,m=o*a,_=o*s,g=o*l;return e[0]=1-h-f,e[3]=u-g,e[6]=d+_,e[1]=u+g,e[4]=1-c-f,e[7]=p-m,e[2]=d-_,e[5]=p+m,e[8]=1-c-h,e},ts.normalFromMat4=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=t[6],c=t[7],u=t[8],h=t[9],d=t[10],p=t[11],f=t[12],m=t[13],_=t[14],g=t[15],y=i*s-r*a,x=i*l-n*a,v=i*c-o*a,b=r*l-n*s,w=r*c-o*s,T=n*c-o*l,E=u*m-h*f,M=u*_-d*f,S=u*g-p*f,A=h*_-d*m,C=h*g-p*m,I=d*g-p*_,D=y*I-x*C+v*A+b*S-w*M+T*E;return D?(e[0]=(s*I-l*C+c*A)*(D=1/D),e[1]=(l*S-a*I-c*M)*D,e[2]=(a*C-s*S+c*E)*D,e[3]=(n*C-r*I-o*A)*D,e[4]=(i*I-n*S+o*M)*D,e[5]=(r*S-i*C-o*E)*D,e[6]=(m*T-_*w+g*b)*D,e[7]=(_*v-f*T-g*x)*D,e[8]=(f*w-m*v+g*y)*D,e):null},ts.projection=function(e,t,i){return e[0]=2/t,e[1]=0,e[2]=0,e[3]=0,e[4]=-2/i,e[5]=0,e[6]=-1,e[7]=1,e[8]=1,e},ts.str=function(e){return"mat3("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+", "+e[4]+", "+e[5]+", "+e[6]+", "+e[7]+", "+e[8]+")"},ts.frob=function(e){return Math.hypot(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},ts.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e[3]=t[3]+i[3],e[4]=t[4]+i[4],e[5]=t[5]+i[5],e[6]=t[6]+i[6],e[7]=t[7]+i[7],e[8]=t[8]+i[8],e},ts.subtract=as,ts.multiplyScalar=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e[4]=t[4]*i,e[5]=t[5]*i,e[6]=t[6]*i,e[7]=t[7]*i,e[8]=t[8]*i,e},ts.multiplyScalarAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e[3]=t[3]+i[3]*r,e[4]=t[4]+i[4]*r,e[5]=t[5]+i[5]*r,e[6]=t[6]+i[6]*r,e[7]=t[7]+i[7]*r,e[8]=t[8]+i[8]*r,e},ts.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},ts.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=e[3],a=e[4],s=e[5],l=e[6],c=e[7],u=e[8],h=t[0],d=t[1],p=t[2],f=t[3],m=t[4],_=t[5],g=t[6],y=t[7],x=t[8];return Math.abs(i-h)<=rs.EPSILON*Math.max(1,Math.abs(i),Math.abs(h))&&Math.abs(r-d)<=rs.EPSILON*Math.max(1,Math.abs(r),Math.abs(d))&&Math.abs(n-p)<=rs.EPSILON*Math.max(1,Math.abs(n),Math.abs(p))&&Math.abs(o-f)<=rs.EPSILON*Math.max(1,Math.abs(o),Math.abs(f))&&Math.abs(a-m)<=rs.EPSILON*Math.max(1,Math.abs(a),Math.abs(m))&&Math.abs(s-_)<=rs.EPSILON*Math.max(1,Math.abs(s),Math.abs(_))&&Math.abs(l-g)<=rs.EPSILON*Math.max(1,Math.abs(l),Math.abs(g))&&Math.abs(c-y)<=rs.EPSILON*Math.max(1,Math.abs(c),Math.abs(y))&&Math.abs(u-x)<=rs.EPSILON*Math.max(1,Math.abs(u),Math.abs(x))},ts.sub=ts.mul=void 0;var rs=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==is(e)&&"function"!=typeof e)return{default:e};var i=ns(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function ns(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(ns=function(e){return e?i:t})(e)}function os(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=i[0],p=i[1],f=i[2],m=i[3],_=i[4],g=i[5],y=i[6],x=i[7],v=i[8];return e[0]=d*r+p*a+f*c,e[1]=d*n+p*s+f*u,e[2]=d*o+p*l+f*h,e[3]=m*r+_*a+g*c,e[4]=m*n+_*s+g*u,e[5]=m*o+_*l+g*h,e[6]=y*r+x*a+v*c,e[7]=y*n+x*s+v*u,e[8]=y*o+x*l+v*h,e}function as(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e[3]=t[3]-i[3],e[4]=t[4]-i[4],e[5]=t[5]-i[5],e[6]=t[6]-i[6],e[7]=t[7]-i[7],e[8]=t[8]-i[8],e}ts.mul=os,ts.sub=as;var ss={};function ls(e){return ls="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},ls(e)}Object.defineProperty(ss,"__esModule",{value:!0}),ss.create=function(){var e=new cs.ARRAY_TYPE(16);return cs.ARRAY_TYPE!=Float32Array&&(e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=0,e[12]=0,e[13]=0,e[14]=0),e[0]=1,e[5]=1,e[10]=1,e[15]=1,e},ss.clone=function(e){var t=new cs.ARRAY_TYPE(16);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},ss.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},ss.fromValues=function(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m){var _=new cs.ARRAY_TYPE(16);return _[0]=e,_[1]=t,_[2]=i,_[3]=r,_[4]=n,_[5]=o,_[6]=a,_[7]=s,_[8]=l,_[9]=c,_[10]=u,_[11]=h,_[12]=d,_[13]=p,_[14]=f,_[15]=m,_},ss.set=function(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_){return e[0]=t,e[1]=i,e[2]=r,e[3]=n,e[4]=o,e[5]=a,e[6]=s,e[7]=l,e[8]=c,e[9]=u,e[10]=h,e[11]=d,e[12]=p,e[13]=f,e[14]=m,e[15]=_,e},ss.identity=hs,ss.transpose=function(e,t){if(e===t){var i=t[1],r=t[2],n=t[3],o=t[6],a=t[7],s=t[11];e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=i,e[6]=t[9],e[7]=t[13],e[8]=r,e[9]=o,e[11]=t[14],e[12]=n,e[13]=a,e[14]=s}else e[0]=t[0],e[1]=t[4],e[2]=t[8],e[3]=t[12],e[4]=t[1],e[5]=t[5],e[6]=t[9],e[7]=t[13],e[8]=t[2],e[9]=t[6],e[10]=t[10],e[11]=t[14],e[12]=t[3],e[13]=t[7],e[14]=t[11],e[15]=t[15];return e},ss.invert=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=t[6],c=t[7],u=t[8],h=t[9],d=t[10],p=t[11],f=t[12],m=t[13],_=t[14],g=t[15],y=i*s-r*a,x=i*l-n*a,v=i*c-o*a,b=r*l-n*s,w=r*c-o*s,T=n*c-o*l,E=u*m-h*f,M=u*_-d*f,S=u*g-p*f,A=h*_-d*m,C=h*g-p*m,I=d*g-p*_,D=y*I-x*C+v*A+b*S-w*M+T*E;return D?(e[0]=(s*I-l*C+c*A)*(D=1/D),e[1]=(n*C-r*I-o*A)*D,e[2]=(m*T-_*w+g*b)*D,e[3]=(d*w-h*T-p*b)*D,e[4]=(l*S-a*I-c*M)*D,e[5]=(i*I-n*S+o*M)*D,e[6]=(_*v-f*T-g*x)*D,e[7]=(u*T-d*v+p*x)*D,e[8]=(a*C-s*S+c*E)*D,e[9]=(r*S-i*C-o*E)*D,e[10]=(f*w-m*v+g*y)*D,e[11]=(h*v-u*w-p*y)*D,e[12]=(s*M-a*A-l*E)*D,e[13]=(i*A-r*M+n*E)*D,e[14]=(m*x-f*b-_*y)*D,e[15]=(u*b-h*x+d*y)*D,e):null},ss.adjoint=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=t[4],s=t[5],l=t[6],c=t[7],u=t[8],h=t[9],d=t[10],p=t[11],f=t[12],m=t[13],_=t[14],g=t[15];return e[0]=s*(d*g-p*_)-h*(l*g-c*_)+m*(l*p-c*d),e[1]=-(r*(d*g-p*_)-h*(n*g-o*_)+m*(n*p-o*d)),e[2]=r*(l*g-c*_)-s*(n*g-o*_)+m*(n*c-o*l),e[3]=-(r*(l*p-c*d)-s*(n*p-o*d)+h*(n*c-o*l)),e[4]=-(a*(d*g-p*_)-u*(l*g-c*_)+f*(l*p-c*d)),e[5]=i*(d*g-p*_)-u*(n*g-o*_)+f*(n*p-o*d),e[6]=-(i*(l*g-c*_)-a*(n*g-o*_)+f*(n*c-o*l)),e[7]=i*(l*p-c*d)-a*(n*p-o*d)+u*(n*c-o*l),e[8]=a*(h*g-p*m)-u*(s*g-c*m)+f*(s*p-c*h),e[9]=-(i*(h*g-p*m)-u*(r*g-o*m)+f*(r*p-o*h)),e[10]=i*(s*g-c*m)-a*(r*g-o*m)+f*(r*c-o*s),e[11]=-(i*(s*p-c*h)-a*(r*p-o*h)+u*(r*c-o*s)),e[12]=-(a*(h*_-d*m)-u*(s*_-l*m)+f*(s*d-l*h)),e[13]=i*(h*_-d*m)-u*(r*_-n*m)+f*(r*d-n*h),e[14]=-(i*(s*_-l*m)-a*(r*_-n*m)+f*(r*l-n*s)),e[15]=i*(s*d-l*h)-a*(r*d-n*h)+u*(r*l-n*s),e},ss.determinant=function(e){var t=e[0],i=e[1],r=e[2],n=e[3],o=e[4],a=e[5],s=e[6],l=e[7],c=e[8],u=e[9],h=e[10],d=e[11],p=e[12],f=e[13],m=e[14],_=e[15];return(t*a-i*o)*(h*_-d*m)-(t*s-r*o)*(u*_-d*f)+(t*l-n*o)*(u*m-h*f)+(i*s-r*a)*(c*_-d*p)-(i*l-n*a)*(c*m-h*p)+(r*l-n*s)*(c*f-u*p)},ss.multiply=ds,ss.translate=function(e,t,i){var r,n,o,a,s,l,c,u,h,d,p,f,m=i[0],_=i[1],g=i[2];return t===e?(e[12]=t[0]*m+t[4]*_+t[8]*g+t[12],e[13]=t[1]*m+t[5]*_+t[9]*g+t[13],e[14]=t[2]*m+t[6]*_+t[10]*g+t[14],e[15]=t[3]*m+t[7]*_+t[11]*g+t[15]):(n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=t[9],p=t[10],f=t[11],e[0]=r=t[0],e[1]=n,e[2]=o,e[3]=a,e[4]=s,e[5]=l,e[6]=c,e[7]=u,e[8]=h,e[9]=d,e[10]=p,e[11]=f,e[12]=r*m+s*_+h*g+t[12],e[13]=n*m+l*_+d*g+t[13],e[14]=o*m+c*_+p*g+t[14],e[15]=a*m+u*_+f*g+t[15]),e},ss.scale=function(e,t,i){var r=i[0],n=i[1],o=i[2];return e[0]=t[0]*r,e[1]=t[1]*r,e[2]=t[2]*r,e[3]=t[3]*r,e[4]=t[4]*n,e[5]=t[5]*n,e[6]=t[6]*n,e[7]=t[7]*n,e[8]=t[8]*o,e[9]=t[9]*o,e[10]=t[10]*o,e[11]=t[11]*o,e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},ss.rotate=function(e,t,i,r){var n,o,a,s,l,c,u,h,d,p,f,m,_,g,y,x,v,b,w,T,E,M,S,A,C=r[0],I=r[1],D=r[2],P=Math.hypot(C,I,D);return P<cs.EPSILON?null:(C*=P=1/P,I*=P,D*=P,n=Math.sin(i),o=Math.cos(i),l=t[1],c=t[2],u=t[3],d=t[5],p=t[6],f=t[7],_=t[9],g=t[10],y=t[11],w=C*I*(a=1-o)-D*n,T=I*I*a+o,E=D*I*a+C*n,M=C*D*a+I*n,S=I*D*a-C*n,A=D*D*a+o,e[0]=(s=t[0])*(x=C*C*a+o)+(h=t[4])*(v=I*C*a+D*n)+(m=t[8])*(b=D*C*a-I*n),e[1]=l*x+d*v+_*b,e[2]=c*x+p*v+g*b,e[3]=u*x+f*v+y*b,e[4]=s*w+h*T+m*E,e[5]=l*w+d*T+_*E,e[6]=c*w+p*T+g*E,e[7]=u*w+f*T+y*E,e[8]=s*M+h*S+m*A,e[9]=l*M+d*S+_*A,e[10]=c*M+p*S+g*A,e[11]=u*M+f*S+y*A,t!==e&&(e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e)},ss.rotateX=function(e,t,i){var r=Math.sin(i),n=Math.cos(i),o=t[4],a=t[5],s=t[6],l=t[7],c=t[8],u=t[9],h=t[10],d=t[11];return t!==e&&(e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[4]=o*n+c*r,e[5]=a*n+u*r,e[6]=s*n+h*r,e[7]=l*n+d*r,e[8]=c*n-o*r,e[9]=u*n-a*r,e[10]=h*n-s*r,e[11]=d*n-l*r,e},ss.rotateY=function(e,t,i){var r=Math.sin(i),n=Math.cos(i),o=t[0],a=t[1],s=t[2],l=t[3],c=t[8],u=t[9],h=t[10],d=t[11];return t!==e&&(e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=o*n-c*r,e[1]=a*n-u*r,e[2]=s*n-h*r,e[3]=l*n-d*r,e[8]=o*r+c*n,e[9]=a*r+u*n,e[10]=s*r+h*n,e[11]=l*r+d*n,e},ss.rotateZ=function(e,t,i){var r=Math.sin(i),n=Math.cos(i),o=t[0],a=t[1],s=t[2],l=t[3],c=t[4],u=t[5],h=t[6],d=t[7];return t!==e&&(e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15]),e[0]=o*n+c*r,e[1]=a*n+u*r,e[2]=s*n+h*r,e[3]=l*n+d*r,e[4]=c*n-o*r,e[5]=u*n-a*r,e[6]=h*n-s*r,e[7]=d*n-l*r,e},ss.fromTranslation=function(e,t){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=t[0],e[13]=t[1],e[14]=t[2],e[15]=1,e},ss.fromScaling=function(e,t){return e[0]=t[0],e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=t[1],e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=t[2],e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},ss.fromRotation=function(e,t,i){var r,n,o,a=i[0],s=i[1],l=i[2],c=Math.hypot(a,s,l);return c<cs.EPSILON?null:(a*=c=1/c,s*=c,l*=c,r=Math.sin(t),n=Math.cos(t),e[0]=a*a*(o=1-n)+n,e[1]=s*a*o+l*r,e[2]=l*a*o-s*r,e[3]=0,e[4]=a*s*o-l*r,e[5]=s*s*o+n,e[6]=l*s*o+a*r,e[7]=0,e[8]=a*l*o+s*r,e[9]=s*l*o-a*r,e[10]=l*l*o+n,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e)},ss.fromXRotation=function(e,t){var i=Math.sin(t),r=Math.cos(t);return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=r,e[6]=i,e[7]=0,e[8]=0,e[9]=-i,e[10]=r,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},ss.fromYRotation=function(e,t){var i=Math.sin(t),r=Math.cos(t);return e[0]=r,e[1]=0,e[2]=-i,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=i,e[9]=0,e[10]=r,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},ss.fromZRotation=function(e,t){var i=Math.sin(t),r=Math.cos(t);return e[0]=r,e[1]=i,e[2]=0,e[3]=0,e[4]=-i,e[5]=r,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},ss.fromRotationTranslation=ps,ss.fromQuat2=function(e,t){var i=new cs.ARRAY_TYPE(3),r=-t[0],n=-t[1],o=-t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=r*r+n*n+o*o+a*a;return h>0?(i[0]=2*(s*a+u*r+l*o-c*n)/h,i[1]=2*(l*a+u*n+c*r-s*o)/h,i[2]=2*(c*a+u*o+s*n-l*r)/h):(i[0]=2*(s*a+u*r+l*o-c*n),i[1]=2*(l*a+u*n+c*r-s*o),i[2]=2*(c*a+u*o+s*n-l*r)),ps(e,t,i),e},ss.getTranslation=function(e,t){return e[0]=t[12],e[1]=t[13],e[2]=t[14],e},ss.getScaling=fs,ss.getRotation=function(e,t){var i=new cs.ARRAY_TYPE(3);fs(i,t);var r=1/i[0],n=1/i[1],o=1/i[2],a=t[0]*r,s=t[1]*n,l=t[2]*o,c=t[4]*r,u=t[5]*n,h=t[6]*o,d=t[8]*r,p=t[9]*n,f=t[10]*o,m=a+u+f,_=0;return m>0?(_=2*Math.sqrt(m+1),e[3]=.25*_,e[0]=(h-p)/_,e[1]=(d-l)/_,e[2]=(s-c)/_):a>u&&a>f?(_=2*Math.sqrt(1+a-u-f),e[3]=(h-p)/_,e[0]=.25*_,e[1]=(s+c)/_,e[2]=(d+l)/_):u>f?(_=2*Math.sqrt(1+u-a-f),e[3]=(d-l)/_,e[0]=(s+c)/_,e[1]=.25*_,e[2]=(h+p)/_):(_=2*Math.sqrt(1+f-a-u),e[3]=(s-c)/_,e[0]=(d+l)/_,e[1]=(h+p)/_,e[2]=.25*_),e},ss.fromRotationTranslationScale=function(e,t,i,r){var n=t[0],o=t[1],a=t[2],s=t[3],l=n+n,c=o+o,u=a+a,h=n*l,d=n*c,p=n*u,f=o*c,m=o*u,_=a*u,g=s*l,y=s*c,x=s*u,v=r[0],b=r[1],w=r[2];return e[0]=(1-(f+_))*v,e[1]=(d+x)*v,e[2]=(p-y)*v,e[3]=0,e[4]=(d-x)*b,e[5]=(1-(h+_))*b,e[6]=(m+g)*b,e[7]=0,e[8]=(p+y)*w,e[9]=(m-g)*w,e[10]=(1-(h+f))*w,e[11]=0,e[12]=i[0],e[13]=i[1],e[14]=i[2],e[15]=1,e},ss.fromRotationTranslationScaleOrigin=function(e,t,i,r,n){var o=t[0],a=t[1],s=t[2],l=t[3],c=o+o,u=a+a,h=s+s,d=o*c,p=o*u,f=o*h,m=a*u,_=a*h,g=s*h,y=l*c,x=l*u,v=l*h,b=r[0],w=r[1],T=r[2],E=n[0],M=n[1],S=n[2],A=(1-(m+g))*b,C=(p+v)*b,I=(f-x)*b,D=(p-v)*w,P=(1-(d+g))*w,L=(_+y)*w,z=(f+x)*T,R=(_-y)*T,k=(1-(d+m))*T;return e[0]=A,e[1]=C,e[2]=I,e[3]=0,e[4]=D,e[5]=P,e[6]=L,e[7]=0,e[8]=z,e[9]=R,e[10]=k,e[11]=0,e[12]=i[0]+E-(A*E+D*M+z*S),e[13]=i[1]+M-(C*E+P*M+R*S),e[14]=i[2]+S-(I*E+L*M+k*S),e[15]=1,e},ss.fromQuat=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=i+i,s=r+r,l=n+n,c=i*a,u=r*a,h=r*s,d=n*a,p=n*s,f=n*l,m=o*a,_=o*s,g=o*l;return e[0]=1-h-f,e[1]=u+g,e[2]=d-_,e[3]=0,e[4]=u-g,e[5]=1-c-f,e[6]=p+m,e[7]=0,e[8]=d+_,e[9]=p-m,e[10]=1-c-h,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e},ss.frustum=function(e,t,i,r,n,o,a){var s=1/(i-t),l=1/(n-r),c=1/(o-a);return e[0]=2*o*s,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=2*o*l,e[6]=0,e[7]=0,e[8]=(i+t)*s,e[9]=(n+r)*l,e[10]=(a+o)*c,e[11]=-1,e[12]=0,e[13]=0,e[14]=a*o*2*c,e[15]=0,e},ss.perspectiveNO=ms,ss.perspectiveZO=function(e,t,i,r,n){var o,a=1/Math.tan(t/2);return e[0]=a/i,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=a,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=-1,e[12]=0,e[13]=0,e[15]=0,null!=n&&n!==1/0?(e[10]=n*(o=1/(r-n)),e[14]=n*r*o):(e[10]=-1,e[14]=-r),e},ss.perspectiveFromFieldOfView=function(e,t,i,r){var n=Math.tan(t.upDegrees*Math.PI/180),o=Math.tan(t.downDegrees*Math.PI/180),a=Math.tan(t.leftDegrees*Math.PI/180),s=Math.tan(t.rightDegrees*Math.PI/180),l=2/(a+s),c=2/(n+o);return e[0]=l,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=c,e[6]=0,e[7]=0,e[8]=-(a-s)*l*.5,e[9]=(n-o)*c*.5,e[10]=r/(i-r),e[11]=-1,e[12]=0,e[13]=0,e[14]=r*i/(i-r),e[15]=0,e},ss.orthoNO=_s,ss.orthoZO=function(e,t,i,r,n,o,a){var s=1/(t-i),l=1/(r-n),c=1/(o-a);return e[0]=-2*s,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=c,e[11]=0,e[12]=(t+i)*s,e[13]=(n+r)*l,e[14]=o*c,e[15]=1,e},ss.lookAt=function(e,t,i,r){var n,o,a,s,l,c,u,h,d,p,f=t[0],m=t[1],_=t[2],g=r[0],y=r[1],x=r[2],v=i[0],b=i[1],w=i[2];return Math.abs(f-v)<cs.EPSILON&&Math.abs(m-b)<cs.EPSILON&&Math.abs(_-w)<cs.EPSILON?hs(e):(u=f-v,h=m-b,d=_-w,n=y*(d*=p=1/Math.hypot(u,h,d))-x*(h*=p),o=x*(u*=p)-g*d,a=g*h-y*u,(p=Math.hypot(n,o,a))?(n*=p=1/p,o*=p,a*=p):(n=0,o=0,a=0),s=h*a-d*o,l=d*n-u*a,c=u*o-h*n,(p=Math.hypot(s,l,c))?(s*=p=1/p,l*=p,c*=p):(s=0,l=0,c=0),e[0]=n,e[1]=s,e[2]=u,e[3]=0,e[4]=o,e[5]=l,e[6]=h,e[7]=0,e[8]=a,e[9]=c,e[10]=d,e[11]=0,e[12]=-(n*f+o*m+a*_),e[13]=-(s*f+l*m+c*_),e[14]=-(u*f+h*m+d*_),e[15]=1,e)},ss.targetTo=function(e,t,i,r){var n=t[0],o=t[1],a=t[2],s=r[0],l=r[1],c=r[2],u=n-i[0],h=o-i[1],d=a-i[2],p=u*u+h*h+d*d;p>0&&(u*=p=1/Math.sqrt(p),h*=p,d*=p);var f=l*d-c*h,m=c*u-s*d,_=s*h-l*u;return(p=f*f+m*m+_*_)>0&&(f*=p=1/Math.sqrt(p),m*=p,_*=p),e[0]=f,e[1]=m,e[2]=_,e[3]=0,e[4]=h*_-d*m,e[5]=d*f-u*_,e[6]=u*m-h*f,e[7]=0,e[8]=u,e[9]=h,e[10]=d,e[11]=0,e[12]=n,e[13]=o,e[14]=a,e[15]=1,e},ss.str=function(e){return"mat4("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+", "+e[4]+", "+e[5]+", "+e[6]+", "+e[7]+", "+e[8]+", "+e[9]+", "+e[10]+", "+e[11]+", "+e[12]+", "+e[13]+", "+e[14]+", "+e[15]+")"},ss.frob=function(e){return Math.hypot(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},ss.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e[3]=t[3]+i[3],e[4]=t[4]+i[4],e[5]=t[5]+i[5],e[6]=t[6]+i[6],e[7]=t[7]+i[7],e[8]=t[8]+i[8],e[9]=t[9]+i[9],e[10]=t[10]+i[10],e[11]=t[11]+i[11],e[12]=t[12]+i[12],e[13]=t[13]+i[13],e[14]=t[14]+i[14],e[15]=t[15]+i[15],e},ss.subtract=gs,ss.multiplyScalar=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e[4]=t[4]*i,e[5]=t[5]*i,e[6]=t[6]*i,e[7]=t[7]*i,e[8]=t[8]*i,e[9]=t[9]*i,e[10]=t[10]*i,e[11]=t[11]*i,e[12]=t[12]*i,e[13]=t[13]*i,e[14]=t[14]*i,e[15]=t[15]*i,e},ss.multiplyScalarAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e[3]=t[3]+i[3]*r,e[4]=t[4]+i[4]*r,e[5]=t[5]+i[5]*r,e[6]=t[6]+i[6]*r,e[7]=t[7]+i[7]*r,e[8]=t[8]+i[8]*r,e[9]=t[9]+i[9]*r,e[10]=t[10]+i[10]*r,e[11]=t[11]+i[11]*r,e[12]=t[12]+i[12]*r,e[13]=t[13]+i[13]*r,e[14]=t[14]+i[14]*r,e[15]=t[15]+i[15]*r,e},ss.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[11]===t[11]&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[15]===t[15]},ss.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=e[3],a=e[4],s=e[5],l=e[6],c=e[7],u=e[8],h=e[9],d=e[10],p=e[11],f=e[12],m=e[13],_=e[14],g=e[15],y=t[0],x=t[1],v=t[2],b=t[3],w=t[4],T=t[5],E=t[6],M=t[7],S=t[8],A=t[9],C=t[10],I=t[11],D=t[12],P=t[13],L=t[14],z=t[15];return Math.abs(i-y)<=cs.EPSILON*Math.max(1,Math.abs(i),Math.abs(y))&&Math.abs(r-x)<=cs.EPSILON*Math.max(1,Math.abs(r),Math.abs(x))&&Math.abs(n-v)<=cs.EPSILON*Math.max(1,Math.abs(n),Math.abs(v))&&Math.abs(o-b)<=cs.EPSILON*Math.max(1,Math.abs(o),Math.abs(b))&&Math.abs(a-w)<=cs.EPSILON*Math.max(1,Math.abs(a),Math.abs(w))&&Math.abs(s-T)<=cs.EPSILON*Math.max(1,Math.abs(s),Math.abs(T))&&Math.abs(l-E)<=cs.EPSILON*Math.max(1,Math.abs(l),Math.abs(E))&&Math.abs(c-M)<=cs.EPSILON*Math.max(1,Math.abs(c),Math.abs(M))&&Math.abs(u-S)<=cs.EPSILON*Math.max(1,Math.abs(u),Math.abs(S))&&Math.abs(h-A)<=cs.EPSILON*Math.max(1,Math.abs(h),Math.abs(A))&&Math.abs(d-C)<=cs.EPSILON*Math.max(1,Math.abs(d),Math.abs(C))&&Math.abs(p-I)<=cs.EPSILON*Math.max(1,Math.abs(p),Math.abs(I))&&Math.abs(f-D)<=cs.EPSILON*Math.max(1,Math.abs(f),Math.abs(D))&&Math.abs(m-P)<=cs.EPSILON*Math.max(1,Math.abs(m),Math.abs(P))&&Math.abs(_-L)<=cs.EPSILON*Math.max(1,Math.abs(_),Math.abs(L))&&Math.abs(g-z)<=cs.EPSILON*Math.max(1,Math.abs(g),Math.abs(z))},ss.sub=ss.mul=ss.ortho=ss.perspective=void 0;var cs=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==ls(e)&&"function"!=typeof e)return{default:e};var i=us(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function us(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(us=function(e){return e?i:t})(e)}function hs(e){return e[0]=1,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=1,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=1,e[11]=0,e[12]=0,e[13]=0,e[14]=0,e[15]=1,e}function ds(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=t[8],d=t[9],p=t[10],f=t[11],m=t[12],_=t[13],g=t[14],y=t[15],x=i[0],v=i[1],b=i[2],w=i[3];return e[0]=x*r+v*s+b*h+w*m,e[1]=x*n+v*l+b*d+w*_,e[2]=x*o+v*c+b*p+w*g,e[3]=x*a+v*u+b*f+w*y,e[4]=(x=i[4])*r+(v=i[5])*s+(b=i[6])*h+(w=i[7])*m,e[5]=x*n+v*l+b*d+w*_,e[6]=x*o+v*c+b*p+w*g,e[7]=x*a+v*u+b*f+w*y,e[8]=(x=i[8])*r+(v=i[9])*s+(b=i[10])*h+(w=i[11])*m,e[9]=x*n+v*l+b*d+w*_,e[10]=x*o+v*c+b*p+w*g,e[11]=x*a+v*u+b*f+w*y,e[12]=(x=i[12])*r+(v=i[13])*s+(b=i[14])*h+(w=i[15])*m,e[13]=x*n+v*l+b*d+w*_,e[14]=x*o+v*c+b*p+w*g,e[15]=x*a+v*u+b*f+w*y,e}function ps(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=r+r,l=n+n,c=o+o,u=r*s,h=r*l,d=r*c,p=n*l,f=n*c,m=o*c,_=a*s,g=a*l,y=a*c;return e[0]=1-(p+m),e[1]=h+y,e[2]=d-g,e[3]=0,e[4]=h-y,e[5]=1-(u+m),e[6]=f+_,e[7]=0,e[8]=d+g,e[9]=f-_,e[10]=1-(u+p),e[11]=0,e[12]=i[0],e[13]=i[1],e[14]=i[2],e[15]=1,e}function fs(e,t){var i=t[4],r=t[5],n=t[6],o=t[8],a=t[9],s=t[10];return e[0]=Math.hypot(t[0],t[1],t[2]),e[1]=Math.hypot(i,r,n),e[2]=Math.hypot(o,a,s),e}function ms(e,t,i,r,n){var o,a=1/Math.tan(t/2);return e[0]=a/i,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=a,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[11]=-1,e[12]=0,e[13]=0,e[15]=0,null!=n&&n!==1/0?(e[10]=(n+r)*(o=1/(r-n)),e[14]=2*n*r*o):(e[10]=-1,e[14]=-2*r),e}function _s(e,t,i,r,n,o,a){var s=1/(t-i),l=1/(r-n),c=1/(o-a);return e[0]=-2*s,e[1]=0,e[2]=0,e[3]=0,e[4]=0,e[5]=-2*l,e[6]=0,e[7]=0,e[8]=0,e[9]=0,e[10]=2*c,e[11]=0,e[12]=(t+i)*s,e[13]=(n+r)*l,e[14]=(a+o)*c,e[15]=1,e}function gs(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e[3]=t[3]-i[3],e[4]=t[4]-i[4],e[5]=t[5]-i[5],e[6]=t[6]-i[6],e[7]=t[7]-i[7],e[8]=t[8]-i[8],e[9]=t[9]-i[9],e[10]=t[10]-i[10],e[11]=t[11]-i[11],e[12]=t[12]-i[12],e[13]=t[13]-i[13],e[14]=t[14]-i[14],e[15]=t[15]-i[15],e}ss.perspective=ms,ss.ortho=_s,ss.mul=ds,ss.sub=gs;var ys={},xs={};function vs(e){return vs="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},vs(e)}Object.defineProperty(xs,"__esModule",{value:!0}),xs.create=Ts,xs.clone=function(e){var t=new bs.ARRAY_TYPE(3);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t},xs.length=Es,xs.fromValues=function(e,t,i){var r=new bs.ARRAY_TYPE(3);return r[0]=e,r[1]=t,r[2]=i,r},xs.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e},xs.set=function(e,t,i,r){return e[0]=t,e[1]=i,e[2]=r,e},xs.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e},xs.subtract=Ms,xs.multiply=Ss,xs.divide=As,xs.ceil=function(e,t){return e[0]=Math.ceil(t[0]),e[1]=Math.ceil(t[1]),e[2]=Math.ceil(t[2]),e},xs.floor=function(e,t){return e[0]=Math.floor(t[0]),e[1]=Math.floor(t[1]),e[2]=Math.floor(t[2]),e},xs.min=function(e,t,i){return e[0]=Math.min(t[0],i[0]),e[1]=Math.min(t[1],i[1]),e[2]=Math.min(t[2],i[2]),e},xs.max=function(e,t,i){return e[0]=Math.max(t[0],i[0]),e[1]=Math.max(t[1],i[1]),e[2]=Math.max(t[2],i[2]),e},xs.round=function(e,t){return e[0]=Math.round(t[0]),e[1]=Math.round(t[1]),e[2]=Math.round(t[2]),e},xs.scale=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e},xs.scaleAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e},xs.distance=Cs,xs.squaredDistance=Is,xs.squaredLength=Ds,xs.negate=function(e,t){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e},xs.inverse=function(e,t){return e[0]=1/t[0],e[1]=1/t[1],e[2]=1/t[2],e},xs.normalize=function(e,t){var i=t[0],r=t[1],n=t[2],o=i*i+r*r+n*n;return o>0&&(o=1/Math.sqrt(o)),e[0]=t[0]*o,e[1]=t[1]*o,e[2]=t[2]*o,e},xs.dot=Ps,xs.cross=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=i[0],s=i[1],l=i[2];return e[0]=n*l-o*s,e[1]=o*a-r*l,e[2]=r*s-n*a,e},xs.lerp=function(e,t,i,r){var n=t[0],o=t[1],a=t[2];return e[0]=n+r*(i[0]-n),e[1]=o+r*(i[1]-o),e[2]=a+r*(i[2]-a),e},xs.hermite=function(e,t,i,r,n,o){var a=o*o,s=a*(2*o-3)+1,l=a*(o-2)+o,c=a*(o-1),u=a*(3-2*o);return e[0]=t[0]*s+i[0]*l+r[0]*c+n[0]*u,e[1]=t[1]*s+i[1]*l+r[1]*c+n[1]*u,e[2]=t[2]*s+i[2]*l+r[2]*c+n[2]*u,e},xs.bezier=function(e,t,i,r,n,o){var a=1-o,s=a*a,l=o*o,c=s*a,u=3*o*s,h=3*l*a,d=l*o;return e[0]=t[0]*c+i[0]*u+r[0]*h+n[0]*d,e[1]=t[1]*c+i[1]*u+r[1]*h+n[1]*d,e[2]=t[2]*c+i[2]*u+r[2]*h+n[2]*d,e},xs.random=function(e,t){t=t||1;var i=2*bs.RANDOM()*Math.PI,r=2*bs.RANDOM()-1,n=Math.sqrt(1-r*r)*t;return e[0]=Math.cos(i)*n,e[1]=Math.sin(i)*n,e[2]=r*t,e},xs.transformMat4=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=i[3]*r+i[7]*n+i[11]*o+i[15];return e[0]=(i[0]*r+i[4]*n+i[8]*o+i[12])/(a=a||1),e[1]=(i[1]*r+i[5]*n+i[9]*o+i[13])/a,e[2]=(i[2]*r+i[6]*n+i[10]*o+i[14])/a,e},xs.transformMat3=function(e,t,i){var r=t[0],n=t[1],o=t[2];return e[0]=r*i[0]+n*i[3]+o*i[6],e[1]=r*i[1]+n*i[4]+o*i[7],e[2]=r*i[2]+n*i[5]+o*i[8],e},xs.transformQuat=function(e,t,i){var r=i[0],n=i[1],o=i[2],a=t[0],s=t[1],l=t[2],c=n*l-o*s,u=o*a-r*l,h=r*s-n*a,d=n*h-o*u,p=o*c-r*h,f=r*u-n*c,m=2*i[3];return u*=m,h*=m,p*=2,f*=2,e[0]=a+(c*=m)+(d*=2),e[1]=s+u+p,e[2]=l+h+f,e},xs.rotateX=function(e,t,i,r){var n=[],o=[];return n[0]=t[0]-i[0],n[1]=t[1]-i[1],n[2]=t[2]-i[2],o[0]=n[0],o[1]=n[1]*Math.cos(r)-n[2]*Math.sin(r),o[2]=n[1]*Math.sin(r)+n[2]*Math.cos(r),e[0]=o[0]+i[0],e[1]=o[1]+i[1],e[2]=o[2]+i[2],e},xs.rotateY=function(e,t,i,r){var n=[],o=[];return n[0]=t[0]-i[0],n[1]=t[1]-i[1],n[2]=t[2]-i[2],o[0]=n[2]*Math.sin(r)+n[0]*Math.cos(r),o[1]=n[1],o[2]=n[2]*Math.cos(r)-n[0]*Math.sin(r),e[0]=o[0]+i[0],e[1]=o[1]+i[1],e[2]=o[2]+i[2],e},xs.rotateZ=function(e,t,i,r){var n=[],o=[];return n[0]=t[0]-i[0],n[1]=t[1]-i[1],n[2]=t[2]-i[2],o[0]=n[0]*Math.cos(r)-n[1]*Math.sin(r),o[1]=n[0]*Math.sin(r)+n[1]*Math.cos(r),o[2]=n[2],e[0]=o[0]+i[0],e[1]=o[1]+i[1],e[2]=o[2]+i[2],e},xs.angle=function(e,t){var i=e[0],r=e[1],n=e[2],o=t[0],a=t[1],s=t[2],l=Math.sqrt(i*i+r*r+n*n)*Math.sqrt(o*o+a*a+s*s),c=l&&Ps(e,t)/l;return Math.acos(Math.min(Math.max(c,-1),1))},xs.zero=function(e){return e[0]=0,e[1]=0,e[2]=0,e},xs.str=function(e){return"vec3("+e[0]+", "+e[1]+", "+e[2]+")"},xs.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]},xs.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=t[0],a=t[1],s=t[2];return Math.abs(i-o)<=bs.EPSILON*Math.max(1,Math.abs(i),Math.abs(o))&&Math.abs(r-a)<=bs.EPSILON*Math.max(1,Math.abs(r),Math.abs(a))&&Math.abs(n-s)<=bs.EPSILON*Math.max(1,Math.abs(n),Math.abs(s))},xs.forEach=xs.sqrLen=xs.len=xs.sqrDist=xs.dist=xs.div=xs.mul=xs.sub=void 0;var bs=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==vs(e)&&"function"!=typeof e)return{default:e};var i=ws(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function ws(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(ws=function(e){return e?i:t})(e)}function Ts(){var e=new bs.ARRAY_TYPE(3);return bs.ARRAY_TYPE!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e}function Es(e){return Math.hypot(e[0],e[1],e[2])}function Ms(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e}function Ss(e,t,i){return e[0]=t[0]*i[0],e[1]=t[1]*i[1],e[2]=t[2]*i[2],e}function As(e,t,i){return e[0]=t[0]/i[0],e[1]=t[1]/i[1],e[2]=t[2]/i[2],e}function Cs(e,t){return Math.hypot(t[0]-e[0],t[1]-e[1],t[2]-e[2])}function Is(e,t){var i=t[0]-e[0],r=t[1]-e[1],n=t[2]-e[2];return i*i+r*r+n*n}function Ds(e){var t=e[0],i=e[1],r=e[2];return t*t+i*i+r*r}function Ps(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]}xs.sub=Ms,xs.mul=Ss,xs.div=As,xs.dist=Cs,xs.sqrDist=Is,xs.len=Es,xs.sqrLen=Ds;var Ls,zs=(Ls=Ts(),function(e,t,i,r,n,o){var a,s;for(t||(t=3),i||(i=0),s=r?Math.min(r*t+i,e.length):e.length,a=i;a<s;a+=t)Ls[0]=e[a],Ls[1]=e[a+1],Ls[2]=e[a+2],n(Ls,Ls,o),e[a]=Ls[0],e[a+1]=Ls[1],e[a+2]=Ls[2];return e});xs.forEach=zs;var Rs={};function ks(e){return ks="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},ks(e)}Object.defineProperty(Rs,"__esModule",{value:!0}),Rs.create=Fs,Rs.clone=function(e){var t=new Bs.ARRAY_TYPE(4);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t},Rs.fromValues=function(e,t,i,r){var n=new Bs.ARRAY_TYPE(4);return n[0]=e,n[1]=t,n[2]=i,n[3]=r,n},Rs.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e},Rs.set=function(e,t,i,r,n){return e[0]=t,e[1]=i,e[2]=r,e[3]=n,e},Rs.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e[3]=t[3]+i[3],e},Rs.subtract=Us,Rs.multiply=Vs,Rs.divide=Ns,Rs.ceil=function(e,t){return e[0]=Math.ceil(t[0]),e[1]=Math.ceil(t[1]),e[2]=Math.ceil(t[2]),e[3]=Math.ceil(t[3]),e},Rs.floor=function(e,t){return e[0]=Math.floor(t[0]),e[1]=Math.floor(t[1]),e[2]=Math.floor(t[2]),e[3]=Math.floor(t[3]),e},Rs.min=function(e,t,i){return e[0]=Math.min(t[0],i[0]),e[1]=Math.min(t[1],i[1]),e[2]=Math.min(t[2],i[2]),e[3]=Math.min(t[3],i[3]),e},Rs.max=function(e,t,i){return e[0]=Math.max(t[0],i[0]),e[1]=Math.max(t[1],i[1]),e[2]=Math.max(t[2],i[2]),e[3]=Math.max(t[3],i[3]),e},Rs.round=function(e,t){return e[0]=Math.round(t[0]),e[1]=Math.round(t[1]),e[2]=Math.round(t[2]),e[3]=Math.round(t[3]),e},Rs.scale=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e},Rs.scaleAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e[2]=t[2]+i[2]*r,e[3]=t[3]+i[3]*r,e},Rs.distance=js,Rs.squaredDistance=Gs,Rs.length=qs,Rs.squaredLength=Zs,Rs.negate=function(e,t){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=-t[3],e},Rs.inverse=function(e,t){return e[0]=1/t[0],e[1]=1/t[1],e[2]=1/t[2],e[3]=1/t[3],e},Rs.normalize=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=i*i+r*r+n*n+o*o;return a>0&&(a=1/Math.sqrt(a)),e[0]=i*a,e[1]=r*a,e[2]=n*a,e[3]=o*a,e},Rs.dot=function(e,t){return e[0]*t[0]+e[1]*t[1]+e[2]*t[2]+e[3]*t[3]},Rs.cross=function(e,t,i,r){var n=i[0]*r[1]-i[1]*r[0],o=i[0]*r[2]-i[2]*r[0],a=i[0]*r[3]-i[3]*r[0],s=i[1]*r[2]-i[2]*r[1],l=i[1]*r[3]-i[3]*r[1],c=i[2]*r[3]-i[3]*r[2],u=t[0],h=t[1],d=t[2],p=t[3];return e[0]=h*c-d*l+p*s,e[1]=-u*c+d*a-p*o,e[2]=u*l-h*a+p*n,e[3]=-u*s+h*o-d*n,e},Rs.lerp=function(e,t,i,r){var n=t[0],o=t[1],a=t[2],s=t[3];return e[0]=n+r*(i[0]-n),e[1]=o+r*(i[1]-o),e[2]=a+r*(i[2]-a),e[3]=s+r*(i[3]-s),e},Rs.random=function(e,t){var i,r,n,o,a,s;t=t||1;do{a=(i=2*Bs.RANDOM()-1)*i+(r=2*Bs.RANDOM()-1)*r}while(a>=1);do{s=(n=2*Bs.RANDOM()-1)*n+(o=2*Bs.RANDOM()-1)*o}while(s>=1);var l=Math.sqrt((1-a)/s);return e[0]=t*i,e[1]=t*r,e[2]=t*n*l,e[3]=t*o*l,e},Rs.transformMat4=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3];return e[0]=i[0]*r+i[4]*n+i[8]*o+i[12]*a,e[1]=i[1]*r+i[5]*n+i[9]*o+i[13]*a,e[2]=i[2]*r+i[6]*n+i[10]*o+i[14]*a,e[3]=i[3]*r+i[7]*n+i[11]*o+i[15]*a,e},Rs.transformQuat=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=i[0],s=i[1],l=i[2],c=i[3],u=c*r+s*o-l*n,h=c*n+l*r-a*o,d=c*o+a*n-s*r,p=-a*r-s*n-l*o;return e[0]=u*c+p*-a+h*-l-d*-s,e[1]=h*c+p*-s+d*-a-u*-l,e[2]=d*c+p*-l+u*-s-h*-a,e[3]=t[3],e},Rs.zero=function(e){return e[0]=0,e[1]=0,e[2]=0,e[3]=0,e},Rs.str=function(e){return"vec4("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+")"},Rs.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]},Rs.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=e[3],a=t[0],s=t[1],l=t[2],c=t[3];return Math.abs(i-a)<=Bs.EPSILON*Math.max(1,Math.abs(i),Math.abs(a))&&Math.abs(r-s)<=Bs.EPSILON*Math.max(1,Math.abs(r),Math.abs(s))&&Math.abs(n-l)<=Bs.EPSILON*Math.max(1,Math.abs(n),Math.abs(l))&&Math.abs(o-c)<=Bs.EPSILON*Math.max(1,Math.abs(o),Math.abs(c))},Rs.forEach=Rs.sqrLen=Rs.len=Rs.sqrDist=Rs.dist=Rs.div=Rs.mul=Rs.sub=void 0;var Bs=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==ks(e)&&"function"!=typeof e)return{default:e};var i=Os(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function Os(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(Os=function(e){return e?i:t})(e)}function Fs(){var e=new Bs.ARRAY_TYPE(4);return Bs.ARRAY_TYPE!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0,e[3]=0),e}function Us(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e[2]=t[2]-i[2],e[3]=t[3]-i[3],e}function Vs(e,t,i){return e[0]=t[0]*i[0],e[1]=t[1]*i[1],e[2]=t[2]*i[2],e[3]=t[3]*i[3],e}function Ns(e,t,i){return e[0]=t[0]/i[0],e[1]=t[1]/i[1],e[2]=t[2]/i[2],e[3]=t[3]/i[3],e}function js(e,t){return Math.hypot(t[0]-e[0],t[1]-e[1],t[2]-e[2],t[3]-e[3])}function Gs(e,t){var i=t[0]-e[0],r=t[1]-e[1],n=t[2]-e[2],o=t[3]-e[3];return i*i+r*r+n*n+o*o}function qs(e){return Math.hypot(e[0],e[1],e[2],e[3])}function Zs(e){var t=e[0],i=e[1],r=e[2],n=e[3];return t*t+i*i+r*r+n*n}Rs.sub=Us,Rs.mul=Vs,Rs.div=Ns,Rs.dist=js,Rs.sqrDist=Gs,Rs.len=qs,Rs.sqrLen=Zs;var $s=function(){var e=Fs();return function(t,i,r,n,o,a){var s,l;for(i||(i=4),r||(r=0),l=n?Math.min(n*i+r,t.length):t.length,s=r;s<l;s+=i)e[0]=t[s],e[1]=t[s+1],e[2]=t[s+2],e[3]=t[s+3],o(e,e,a),t[s]=e[0],t[s+1]=e[1],t[s+2]=e[2],t[s+3]=e[3];return t}}();function Hs(e){return Hs="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Hs(e)}Rs.forEach=$s,Object.defineProperty(ys,"__esModule",{value:!0}),ys.create=el,ys.identity=function(e){return e[0]=0,e[1]=0,e[2]=0,e[3]=1,e},ys.setAxisAngle=tl,ys.getAxisAngle=function(e,t){var i=2*Math.acos(t[3]),r=Math.sin(i/2);return r>Ws.EPSILON?(e[0]=t[0]/r,e[1]=t[1]/r,e[2]=t[2]/r):(e[0]=1,e[1]=0,e[2]=0),i},ys.getAngle=function(e,t){var i=ll(e,t);return Math.acos(2*i*i-1)},ys.multiply=il,ys.rotateX=function(e,t,i){i*=.5;var r=t[0],n=t[1],o=t[2],a=t[3],s=Math.sin(i),l=Math.cos(i);return e[0]=r*l+a*s,e[1]=n*l+o*s,e[2]=o*l-n*s,e[3]=a*l-r*s,e},ys.rotateY=function(e,t,i){i*=.5;var r=t[0],n=t[1],o=t[2],a=t[3],s=Math.sin(i),l=Math.cos(i);return e[0]=r*l-o*s,e[1]=n*l+a*s,e[2]=o*l+r*s,e[3]=a*l-n*s,e},ys.rotateZ=function(e,t,i){i*=.5;var r=t[0],n=t[1],o=t[2],a=t[3],s=Math.sin(i),l=Math.cos(i);return e[0]=r*l+n*s,e[1]=n*l-r*s,e[2]=o*l+a*s,e[3]=a*l-o*s,e},ys.calculateW=function(e,t){var i=t[0],r=t[1],n=t[2];return e[0]=i,e[1]=r,e[2]=n,e[3]=Math.sqrt(Math.abs(1-i*i-r*r-n*n)),e},ys.exp=rl,ys.ln=nl,ys.pow=function(e,t,i){return nl(e,t),sl(e,e,i),rl(e,e),e},ys.slerp=ol,ys.random=function(e){var t=Ws.RANDOM(),i=Ws.RANDOM(),r=Ws.RANDOM(),n=Math.sqrt(1-t),o=Math.sqrt(t);return e[0]=n*Math.sin(2*Math.PI*i),e[1]=n*Math.cos(2*Math.PI*i),e[2]=o*Math.sin(2*Math.PI*r),e[3]=o*Math.cos(2*Math.PI*r),e},ys.invert=function(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=i*i+r*r+n*n+o*o,s=a?1/a:0;return e[0]=-i*s,e[1]=-r*s,e[2]=-n*s,e[3]=o*s,e},ys.conjugate=function(e,t){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=t[3],e},ys.fromMat3=al,ys.fromEuler=function(e,t,i,r){var n=.5*Math.PI/180;t*=n,i*=n,r*=n;var o=Math.sin(t),a=Math.cos(t),s=Math.sin(i),l=Math.cos(i),c=Math.sin(r),u=Math.cos(r);return e[0]=o*l*u-a*s*c,e[1]=a*s*u+o*l*c,e[2]=a*l*c-o*s*u,e[3]=a*l*u+o*s*c,e},ys.str=function(e){return"quat("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+")"},ys.setAxes=ys.sqlerp=ys.rotationTo=ys.equals=ys.exactEquals=ys.normalize=ys.sqrLen=ys.squaredLength=ys.len=ys.length=ys.lerp=ys.dot=ys.scale=ys.mul=ys.add=ys.set=ys.copy=ys.fromValues=ys.clone=void 0;var Ws=Qs(Fa),Xs=Qs(ts),Ys=Qs(xs),Ks=Qs(Rs);function Js(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(Js=function(e){return e?i:t})(e)}function Qs(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==Hs(e)&&"function"!=typeof e)return{default:e};var i=Js(t);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}function el(){var e=new Ws.ARRAY_TYPE(4);return Ws.ARRAY_TYPE!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0),e[3]=1,e}function tl(e,t,i){i*=.5;var r=Math.sin(i);return e[0]=r*t[0],e[1]=r*t[1],e[2]=r*t[2],e[3]=Math.cos(i),e}function il(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=i[0],l=i[1],c=i[2],u=i[3];return e[0]=r*u+a*s+n*c-o*l,e[1]=n*u+a*l+o*s-r*c,e[2]=o*u+a*c+r*l-n*s,e[3]=a*u-r*s-n*l-o*c,e}function rl(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=Math.sqrt(i*i+r*r+n*n),s=Math.exp(o),l=a>0?s*Math.sin(a)/a:0;return e[0]=i*l,e[1]=r*l,e[2]=n*l,e[3]=s*Math.cos(a),e}function nl(e,t){var i=t[0],r=t[1],n=t[2],o=t[3],a=Math.sqrt(i*i+r*r+n*n),s=a>0?Math.atan2(a,o)/a:0;return e[0]=i*s,e[1]=r*s,e[2]=n*s,e[3]=.5*Math.log(i*i+r*r+n*n+o*o),e}function ol(e,t,i,r){var n,o,a,s,l,c=t[0],u=t[1],h=t[2],d=t[3],p=i[0],f=i[1],m=i[2],_=i[3];return(o=c*p+u*f+h*m+d*_)<0&&(o=-o,p=-p,f=-f,m=-m,_=-_),1-o>Ws.EPSILON?(n=Math.acos(o),a=Math.sin(n),s=Math.sin((1-r)*n)/a,l=Math.sin(r*n)/a):(s=1-r,l=r),e[0]=s*c+l*p,e[1]=s*u+l*f,e[2]=s*h+l*m,e[3]=s*d+l*_,e}function al(e,t){var i,r=t[0]+t[4]+t[8];if(r>0)i=Math.sqrt(r+1),e[3]=.5*i,e[0]=(t[5]-t[7])*(i=.5/i),e[1]=(t[6]-t[2])*i,e[2]=(t[1]-t[3])*i;else{var n=0;t[4]>t[0]&&(n=1),t[8]>t[3*n+n]&&(n=2);var o=(n+1)%3,a=(n+2)%3;i=Math.sqrt(t[3*n+n]-t[3*o+o]-t[3*a+a]+1),e[n]=.5*i,e[3]=(t[3*o+a]-t[3*a+o])*(i=.5/i),e[o]=(t[3*o+n]+t[3*n+o])*i,e[a]=(t[3*a+n]+t[3*n+a])*i}return e}ys.clone=Ks.clone,ys.fromValues=Ks.fromValues,ys.copy=Ks.copy,ys.set=Ks.set,ys.add=Ks.add,ys.mul=il;var sl=Ks.scale;ys.scale=sl;var ll=Ks.dot;ys.dot=ll,ys.lerp=Ks.lerp;var cl=Ks.length;ys.length=cl,ys.len=cl;var ul=Ks.squaredLength;ys.squaredLength=ul,ys.sqrLen=ul;var hl=Ks.normalize;ys.normalize=hl,ys.exactEquals=Ks.exactEquals,ys.equals=Ks.equals;var dl,pl,fl,ml=(dl=Ys.create(),pl=Ys.fromValues(1,0,0),fl=Ys.fromValues(0,1,0),function(e,t,i){var r=Ys.dot(t,i);return r<-.999999?(Ys.cross(dl,pl,t),Ys.len(dl)<1e-6&&Ys.cross(dl,fl,t),Ys.normalize(dl,dl),tl(e,dl,Math.PI),e):r>.999999?(e[0]=0,e[1]=0,e[2]=0,e[3]=1,e):(Ys.cross(dl,t,i),e[0]=dl[0],e[1]=dl[1],e[2]=dl[2],e[3]=1+r,hl(e,e))});ys.rotationTo=ml;var _l,gl,yl=(_l=el(),gl=el(),function(e,t,i,r,n,o){return ol(_l,t,n,o),ol(gl,i,r,o),ol(e,_l,gl,2*o*(1-o)),e});ys.sqlerp=yl;var xl,vl=(xl=Xs.create(),function(e,t,i,r){return xl[0]=i[0],xl[3]=i[1],xl[6]=i[2],xl[1]=r[0],xl[4]=r[1],xl[7]=r[2],xl[2]=-t[0],xl[5]=-t[1],xl[8]=-t[2],hl(e,al(e,xl))});ys.setAxes=vl;var bl={};function wl(e){return wl="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},wl(e)}Object.defineProperty(bl,"__esModule",{value:!0}),bl.create=function(){var e=new Tl.ARRAY_TYPE(8);return Tl.ARRAY_TYPE!=Float32Array&&(e[0]=0,e[1]=0,e[2]=0,e[4]=0,e[5]=0,e[6]=0,e[7]=0),e[3]=1,e},bl.clone=function(e){var t=new Tl.ARRAY_TYPE(8);return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t},bl.fromValues=function(e,t,i,r,n,o,a,s){var l=new Tl.ARRAY_TYPE(8);return l[0]=e,l[1]=t,l[2]=i,l[3]=r,l[4]=n,l[5]=o,l[6]=a,l[7]=s,l},bl.fromRotationTranslationValues=function(e,t,i,r,n,o,a){var s=new Tl.ARRAY_TYPE(8);s[0]=e,s[1]=t,s[2]=i,s[3]=r;var l=.5*n,c=.5*o,u=.5*a;return s[4]=l*r+c*i-u*t,s[5]=c*r+u*e-l*i,s[6]=u*r+l*t-c*e,s[7]=-l*e-c*t-u*i,s},bl.fromRotationTranslation=Cl,bl.fromTranslation=function(e,t){return e[0]=0,e[1]=0,e[2]=0,e[3]=1,e[4]=.5*t[0],e[5]=.5*t[1],e[6]=.5*t[2],e[7]=0,e},bl.fromRotation=function(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=0,e[5]=0,e[6]=0,e[7]=0,e},bl.fromMat4=function(e,t){var i=El.create();Ml.getRotation(i,t);var r=new Tl.ARRAY_TYPE(3);return Ml.getTranslation(r,t),Cl(e,i,r),e},bl.copy=Il,bl.identity=function(e){return e[0]=0,e[1]=0,e[2]=0,e[3]=1,e[4]=0,e[5]=0,e[6]=0,e[7]=0,e},bl.set=function(e,t,i,r,n,o,a,s,l){return e[0]=t,e[1]=i,e[2]=r,e[3]=n,e[4]=o,e[5]=a,e[6]=s,e[7]=l,e},bl.getDual=function(e,t){return e[0]=t[4],e[1]=t[5],e[2]=t[6],e[3]=t[7],e},bl.setDual=function(e,t){return e[4]=t[0],e[5]=t[1],e[6]=t[2],e[7]=t[3],e},bl.getTranslation=function(e,t){var i=t[4],r=t[5],n=t[6],o=t[7],a=-t[0],s=-t[1],l=-t[2],c=t[3];return e[0]=2*(i*c+o*a+r*l-n*s),e[1]=2*(r*c+o*s+n*a-i*l),e[2]=2*(n*c+o*l+i*s-r*a),e},bl.translate=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=.5*i[0],l=.5*i[1],c=.5*i[2],u=t[4],h=t[5],d=t[6],p=t[7];return e[0]=r,e[1]=n,e[2]=o,e[3]=a,e[4]=a*s+n*c-o*l+u,e[5]=a*l+o*s-r*c+h,e[6]=a*c+r*l-n*s+d,e[7]=-r*s-n*l-o*c+p,e},bl.rotateX=function(e,t,i){var r=-t[0],n=-t[1],o=-t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=s*a+u*r+l*o-c*n,d=l*a+u*n+c*r-s*o,p=c*a+u*o+s*n-l*r,f=u*a-s*r-l*n-c*o;return El.rotateX(e,t,i),e[4]=h*(a=e[3])+f*(r=e[0])+d*(o=e[2])-p*(n=e[1]),e[5]=d*a+f*n+p*r-h*o,e[6]=p*a+f*o+h*n-d*r,e[7]=f*a-h*r-d*n-p*o,e},bl.rotateY=function(e,t,i){var r=-t[0],n=-t[1],o=-t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=s*a+u*r+l*o-c*n,d=l*a+u*n+c*r-s*o,p=c*a+u*o+s*n-l*r,f=u*a-s*r-l*n-c*o;return El.rotateY(e,t,i),e[4]=h*(a=e[3])+f*(r=e[0])+d*(o=e[2])-p*(n=e[1]),e[5]=d*a+f*n+p*r-h*o,e[6]=p*a+f*o+h*n-d*r,e[7]=f*a-h*r-d*n-p*o,e},bl.rotateZ=function(e,t,i){var r=-t[0],n=-t[1],o=-t[2],a=t[3],s=t[4],l=t[5],c=t[6],u=t[7],h=s*a+u*r+l*o-c*n,d=l*a+u*n+c*r-s*o,p=c*a+u*o+s*n-l*r,f=u*a-s*r-l*n-c*o;return El.rotateZ(e,t,i),e[4]=h*(a=e[3])+f*(r=e[0])+d*(o=e[2])-p*(n=e[1]),e[5]=d*a+f*n+p*r-h*o,e[6]=p*a+f*o+h*n-d*r,e[7]=f*a-h*r-d*n-p*o,e},bl.rotateByQuatAppend=function(e,t,i){var r=i[0],n=i[1],o=i[2],a=i[3],s=t[0],l=t[1],c=t[2],u=t[3];return e[0]=s*a+u*r+l*o-c*n,e[1]=l*a+u*n+c*r-s*o,e[2]=c*a+u*o+s*n-l*r,e[3]=u*a-s*r-l*n-c*o,e[4]=(s=t[4])*a+(u=t[7])*r+(l=t[5])*o-(c=t[6])*n,e[5]=l*a+u*n+c*r-s*o,e[6]=c*a+u*o+s*n-l*r,e[7]=u*a-s*r-l*n-c*o,e},bl.rotateByQuatPrepend=function(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=i[0],l=i[1],c=i[2],u=i[3];return e[0]=r*u+a*s+n*c-o*l,e[1]=n*u+a*l+o*s-r*c,e[2]=o*u+a*c+r*l-n*s,e[3]=a*u-r*s-n*l-o*c,e[4]=r*(u=i[7])+a*(s=i[4])+n*(c=i[6])-o*(l=i[5]),e[5]=n*u+a*l+o*s-r*c,e[6]=o*u+a*c+r*l-n*s,e[7]=a*u-r*s-n*l-o*c,e},bl.rotateAroundAxis=function(e,t,i,r){if(Math.abs(r)<Tl.EPSILON)return Il(e,t);var n=Math.hypot(i[0],i[1],i[2]);r*=.5;var o=Math.sin(r),a=o*i[0]/n,s=o*i[1]/n,l=o*i[2]/n,c=Math.cos(r),u=t[0],h=t[1],d=t[2],p=t[3];e[0]=u*c+p*a+h*l-d*s,e[1]=h*c+p*s+d*a-u*l,e[2]=d*c+p*l+u*s-h*a,e[3]=p*c-u*a-h*s-d*l;var f=t[4],m=t[5],_=t[6],g=t[7];return e[4]=f*c+g*a+m*l-_*s,e[5]=m*c+g*s+_*a-f*l,e[6]=_*c+g*l+f*s-m*a,e[7]=g*c-f*a-m*s-_*l,e},bl.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e[2]=t[2]+i[2],e[3]=t[3]+i[3],e[4]=t[4]+i[4],e[5]=t[5]+i[5],e[6]=t[6]+i[6],e[7]=t[7]+i[7],e},bl.multiply=Dl,bl.scale=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e[2]=t[2]*i,e[3]=t[3]*i,e[4]=t[4]*i,e[5]=t[5]*i,e[6]=t[6]*i,e[7]=t[7]*i,e},bl.lerp=function(e,t,i,r){var n=1-r;return Pl(t,i)<0&&(r=-r),e[0]=t[0]*n+i[0]*r,e[1]=t[1]*n+i[1]*r,e[2]=t[2]*n+i[2]*r,e[3]=t[3]*n+i[3]*r,e[4]=t[4]*n+i[4]*r,e[5]=t[5]*n+i[5]*r,e[6]=t[6]*n+i[6]*r,e[7]=t[7]*n+i[7]*r,e},bl.invert=function(e,t){var i=zl(t);return e[0]=-t[0]/i,e[1]=-t[1]/i,e[2]=-t[2]/i,e[3]=t[3]/i,e[4]=-t[4]/i,e[5]=-t[5]/i,e[6]=-t[6]/i,e[7]=t[7]/i,e},bl.conjugate=function(e,t){return e[0]=-t[0],e[1]=-t[1],e[2]=-t[2],e[3]=t[3],e[4]=-t[4],e[5]=-t[5],e[6]=-t[6],e[7]=t[7],e},bl.normalize=function(e,t){var i=zl(t);if(i>0){i=Math.sqrt(i);var r=t[0]/i,n=t[1]/i,o=t[2]/i,a=t[3]/i,s=t[4],l=t[5],c=t[6],u=t[7],h=r*s+n*l+o*c+a*u;e[0]=r,e[1]=n,e[2]=o,e[3]=a,e[4]=(s-r*h)/i,e[5]=(l-n*h)/i,e[6]=(c-o*h)/i,e[7]=(u-a*h)/i}return e},bl.str=function(e){return"quat2("+e[0]+", "+e[1]+", "+e[2]+", "+e[3]+", "+e[4]+", "+e[5]+", "+e[6]+", "+e[7]+")"},bl.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]},bl.equals=function(e,t){var i=e[0],r=e[1],n=e[2],o=e[3],a=e[4],s=e[5],l=e[6],c=e[7],u=t[0],h=t[1],d=t[2],p=t[3],f=t[4],m=t[5],_=t[6],g=t[7];return Math.abs(i-u)<=Tl.EPSILON*Math.max(1,Math.abs(i),Math.abs(u))&&Math.abs(r-h)<=Tl.EPSILON*Math.max(1,Math.abs(r),Math.abs(h))&&Math.abs(n-d)<=Tl.EPSILON*Math.max(1,Math.abs(n),Math.abs(d))&&Math.abs(o-p)<=Tl.EPSILON*Math.max(1,Math.abs(o),Math.abs(p))&&Math.abs(a-f)<=Tl.EPSILON*Math.max(1,Math.abs(a),Math.abs(f))&&Math.abs(s-m)<=Tl.EPSILON*Math.max(1,Math.abs(s),Math.abs(m))&&Math.abs(l-_)<=Tl.EPSILON*Math.max(1,Math.abs(l),Math.abs(_))&&Math.abs(c-g)<=Tl.EPSILON*Math.max(1,Math.abs(c),Math.abs(g))},bl.sqrLen=bl.squaredLength=bl.len=bl.length=bl.dot=bl.mul=bl.setReal=bl.getReal=void 0;var Tl=Al(Fa),El=Al(ys),Ml=Al(ss);function Sl(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(Sl=function(e){return e?i:t})(e)}function Al(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==wl(e)&&"function"!=typeof e)return{default:e};var i=Sl(t);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}function Cl(e,t,i){var r=.5*i[0],n=.5*i[1],o=.5*i[2],a=t[0],s=t[1],l=t[2],c=t[3];return e[0]=a,e[1]=s,e[2]=l,e[3]=c,e[4]=r*c+n*l-o*s,e[5]=n*c+o*a-r*l,e[6]=o*c+r*s-n*a,e[7]=-r*a-n*s-o*l,e}function Il(e,t){return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e}function Dl(e,t,i){var r=t[0],n=t[1],o=t[2],a=t[3],s=i[4],l=i[5],c=i[6],u=i[7],h=t[4],d=t[5],p=t[6],f=t[7],m=i[0],_=i[1],g=i[2],y=i[3];return e[0]=r*y+a*m+n*g-o*_,e[1]=n*y+a*_+o*m-r*g,e[2]=o*y+a*g+r*_-n*m,e[3]=a*y-r*m-n*_-o*g,e[4]=r*u+a*s+n*c-o*l+h*y+f*m+d*g-p*_,e[5]=n*u+a*l+o*s-r*c+d*y+f*_+p*m-h*g,e[6]=o*u+a*c+r*l-n*s+p*y+f*g+h*_-d*m,e[7]=a*u-r*s-n*l-o*c+f*y-h*m-d*_-p*g,e}bl.getReal=El.copy,bl.setReal=El.copy,bl.mul=Dl;var Pl=El.dot;bl.dot=Pl;var Ll=El.length;bl.length=Ll,bl.len=Ll;var zl=El.squaredLength;bl.squaredLength=zl,bl.sqrLen=zl;var Rl={};function kl(e){return kl="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},kl(e)}Object.defineProperty(Rl,"__esModule",{value:!0}),Rl.create=Fl,Rl.clone=function(e){var t=new Bl.ARRAY_TYPE(2);return t[0]=e[0],t[1]=e[1],t},Rl.fromValues=function(e,t){var i=new Bl.ARRAY_TYPE(2);return i[0]=e,i[1]=t,i},Rl.copy=function(e,t){return e[0]=t[0],e[1]=t[1],e},Rl.set=function(e,t,i){return e[0]=t,e[1]=i,e},Rl.add=function(e,t,i){return e[0]=t[0]+i[0],e[1]=t[1]+i[1],e},Rl.subtract=Ul,Rl.multiply=Vl,Rl.divide=Nl,Rl.ceil=function(e,t){return e[0]=Math.ceil(t[0]),e[1]=Math.ceil(t[1]),e},Rl.floor=function(e,t){return e[0]=Math.floor(t[0]),e[1]=Math.floor(t[1]),e},Rl.min=function(e,t,i){return e[0]=Math.min(t[0],i[0]),e[1]=Math.min(t[1],i[1]),e},Rl.max=function(e,t,i){return e[0]=Math.max(t[0],i[0]),e[1]=Math.max(t[1],i[1]),e},Rl.round=function(e,t){return e[0]=Math.round(t[0]),e[1]=Math.round(t[1]),e},Rl.scale=function(e,t,i){return e[0]=t[0]*i,e[1]=t[1]*i,e},Rl.scaleAndAdd=function(e,t,i,r){return e[0]=t[0]+i[0]*r,e[1]=t[1]+i[1]*r,e},Rl.distance=jl,Rl.squaredDistance=Gl,Rl.length=ql,Rl.squaredLength=Zl,Rl.negate=function(e,t){return e[0]=-t[0],e[1]=-t[1],e},Rl.inverse=function(e,t){return e[0]=1/t[0],e[1]=1/t[1],e},Rl.normalize=function(e,t){var i=t[0],r=t[1],n=i*i+r*r;return n>0&&(n=1/Math.sqrt(n)),e[0]=t[0]*n,e[1]=t[1]*n,e},Rl.dot=function(e,t){return e[0]*t[0]+e[1]*t[1]},Rl.cross=function(e,t,i){var r=t[0]*i[1]-t[1]*i[0];return e[0]=e[1]=0,e[2]=r,e},Rl.lerp=function(e,t,i,r){var n=t[0],o=t[1];return e[0]=n+r*(i[0]-n),e[1]=o+r*(i[1]-o),e},Rl.random=function(e,t){t=t||1;var i=2*Bl.RANDOM()*Math.PI;return e[0]=Math.cos(i)*t,e[1]=Math.sin(i)*t,e},Rl.transformMat2=function(e,t,i){var r=t[0],n=t[1];return e[0]=i[0]*r+i[2]*n,e[1]=i[1]*r+i[3]*n,e},Rl.transformMat2d=function(e,t,i){var r=t[0],n=t[1];return e[0]=i[0]*r+i[2]*n+i[4],e[1]=i[1]*r+i[3]*n+i[5],e},Rl.transformMat3=function(e,t,i){var r=t[0],n=t[1];return e[0]=i[0]*r+i[3]*n+i[6],e[1]=i[1]*r+i[4]*n+i[7],e},Rl.transformMat4=function(e,t,i){var r=t[0],n=t[1];return e[0]=i[0]*r+i[4]*n+i[12],e[1]=i[1]*r+i[5]*n+i[13],e},Rl.rotate=function(e,t,i,r){var n=t[0]-i[0],o=t[1]-i[1],a=Math.sin(r),s=Math.cos(r);return e[0]=n*s-o*a+i[0],e[1]=n*a+o*s+i[1],e},Rl.angle=function(e,t){var i=e[0],r=e[1],n=t[0],o=t[1],a=Math.sqrt(i*i+r*r)*Math.sqrt(n*n+o*o);return Math.acos(Math.min(Math.max(a&&(i*n+r*o)/a,-1),1))},Rl.zero=function(e){return e[0]=0,e[1]=0,e},Rl.str=function(e){return"vec2("+e[0]+", "+e[1]+")"},Rl.exactEquals=function(e,t){return e[0]===t[0]&&e[1]===t[1]},Rl.equals=function(e,t){var i=e[0],r=e[1],n=t[0],o=t[1];return Math.abs(i-n)<=Bl.EPSILON*Math.max(1,Math.abs(i),Math.abs(n))&&Math.abs(r-o)<=Bl.EPSILON*Math.max(1,Math.abs(r),Math.abs(o))},Rl.forEach=Rl.sqrLen=Rl.sqrDist=Rl.dist=Rl.div=Rl.mul=Rl.sub=Rl.len=void 0;var Bl=function(e,t){if(e&&e.__esModule)return e;if(null===e||"object"!==kl(e)&&"function"!=typeof e)return{default:e};var i=Ol(void 0);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}(Fa);function Ol(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(Ol=function(e){return e?i:t})(e)}function Fl(){var e=new Bl.ARRAY_TYPE(2);return Bl.ARRAY_TYPE!=Float32Array&&(e[0]=0,e[1]=0),e}function Ul(e,t,i){return e[0]=t[0]-i[0],e[1]=t[1]-i[1],e}function Vl(e,t,i){return e[0]=t[0]*i[0],e[1]=t[1]*i[1],e}function Nl(e,t,i){return e[0]=t[0]/i[0],e[1]=t[1]/i[1],e}function jl(e,t){return Math.hypot(t[0]-e[0],t[1]-e[1])}function Gl(e,t){var i=t[0]-e[0],r=t[1]-e[1];return i*i+r*r}function ql(e){return Math.hypot(e[0],e[1])}function Zl(e){var t=e[0],i=e[1];return t*t+i*i}Rl.len=ql,Rl.sub=Ul,Rl.mul=Vl,Rl.div=Nl,Rl.dist=jl,Rl.sqrDist=Gl,Rl.sqrLen=Zl;var $l=function(){var e=Fl();return function(t,i,r,n,o,a){var s,l;for(i||(i=2),r||(r=0),l=n?Math.min(n*i+r,t.length):t.length,s=r;s<l;s+=i)e[0]=t[s],e[1]=t[s+1],o(e,e,a),t[s]=e[0],t[s+1]=e[1];return t}}();function Hl(e){return Hl="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Hl(e)}Rl.forEach=$l,Object.defineProperty(Oa,"__esModule",{value:!0});var Wl=Oa.vec4=lc=Oa.vec3=Oa.vec2=Oa.quat2=nc=Oa.quat=ic=Oa.mat4=ec=Oa.mat3=Oa.mat2d=Kl=Oa.mat2=Oa.glMatrix=void 0,Xl=hc(Fa);Oa.glMatrix=Xl;var Yl=hc(Ga),Kl=Oa.mat2=Yl,Jl=hc(Xa);Oa.mat2d=Jl;var Ql=hc(ts),ec=Oa.mat3=Ql,tc=hc(ss),ic=Oa.mat4=tc,rc=hc(ys),nc=Oa.quat=rc,oc=hc(bl);Oa.quat2=oc;var ac=hc(Rl);Oa.vec2=ac;var sc=hc(xs),lc=Oa.vec3=sc,cc=hc(Rs);function uc(e){if("function"!=typeof WeakMap)return null;var t=new WeakMap,i=new WeakMap;return(uc=function(e){return e?i:t})(e)}function hc(e,t){if(!t&&e&&e.__esModule)return e;if(null===e||"object"!==Hl(e)&&"function"!=typeof e)return{default:e};var i=uc(t);if(i&&i.has(e))return i.get(e);var r={},n=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var o in e)if("default"!==o&&Object.prototype.hasOwnProperty.call(e,o)){var a=n?Object.getOwnPropertyDescriptor(e,o):null;a&&(a.get||a.set)?Object.defineProperty(r,o,a):r[o]=e[o]}return r.default=e,i&&i.set(e,r),r}Wl=Oa.vec4=cc;const dc=ha([{type:"Float32",name:"a_globe_pos",components:3},{type:"Float32",name:"a_uv",components:2}]),{members:pc}=dc,fc=ha([{name:"a_pos_3",components:3,type:"Int16"}]);var mc=ha([{name:"a_pos",type:"Int16",components:2}]),_c={};!function(e,t){!function(e){function t(e,t,r){var n=i(256*e,256*(t=Math.pow(2,r)-t-1),r),o=i(256*(e+1),256*(t+1),r);return n[0]+","+n[1]+","+o[0]+","+o[1]}function i(e,t,i){var r=2*Math.PI*6378137/256/Math.pow(2,i);return[e*r-2*Math.PI*6378137/2,t*r-2*Math.PI*6378137/2]}e.getURL=function(e,i,r,n,o,a){return a=a||{},e+"?"+["bbox="+t(r,n,o),"format="+(a.format||"image/png"),"service="+(a.service||"WMS"),"version="+(a.version||"1.1.1"),"request="+(a.request||"GetMap"),"srs="+(a.srs||"EPSG:3857"),"width="+(a.width||256),"height="+(a.height||256),"layers="+i].join("&")},e.getTileBBox=t,e.getMercCoords=i,Object.defineProperty(e,"__esModule",{value:!0})}(t)}(0,_c);var gc=_c;class CanonicalTileID{constructor(e,t,i){this.z=e,this.x=t,this.y=i,this.key=yc(0,e,e,t,i)}equals(e){return this.z===e.z&&this.x===e.x&&this.y===e.y}url(e,t){const i=gc.getTileBBox(this.x,this.y,this.z),r=function(e,t,i){let r,n="";for(let o=e;o>0;o--)r=1<<o-1,n+=(t&r?1:0)+(i&r?2:0);return n}(this.z,this.x,this.y);return e[(this.x+this.y)%e.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace(/{z}/g,String(this.z)).replace(/{x}/g,String(this.x)).replace(/{y}/g,String("tms"===t?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",r).replace("{bbox-epsg-3857}",i)}toString(){return`${this.z}/${this.x}/${this.y}`}}class UnwrappedTileID{constructor(e,t){this.wrap=e,this.canonical=t,this.key=yc(e,t.z,t.z,t.x,t.y)}}class OverscaledTileID{constructor(e,t,i,r,n){this.overscaledZ=e,this.wrap=t,this.canonical=new CanonicalTileID(i,+r,+n),this.key=0===t&&e===i?this.canonical.key:yc(t,e,i,r,n)}equals(e){return this.overscaledZ===e.overscaledZ&&this.wrap===e.wrap&&this.canonical.equals(e.canonical)}scaledTo(e){const t=this.canonical.z-e;return e>this.canonical.z?new OverscaledTileID(e,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new OverscaledTileID(e,this.wrap,e,this.canonical.x>>t,this.canonical.y>>t)}calculateScaledKey(e,t=!0){if(this.overscaledZ===e&&t)return this.key;if(e>this.canonical.z)return yc(this.wrap*+t,e,this.canonical.z,this.canonical.x,this.canonical.y);{const i=this.canonical.z-e;return yc(this.wrap*+t,e,e,this.canonical.x>>i,this.canonical.y>>i)}}isChildOf(e){if(e.wrap!==this.wrap)return!1;const t=this.canonical.z-e.canonical.z;return 0===e.overscaledZ||e.overscaledZ<this.overscaledZ&&e.canonical.z<this.canonical.z&&e.canonical.x===this.canonical.x>>t&&e.canonical.y===this.canonical.y>>t}children(e){if(this.overscaledZ>=e)return[new OverscaledTileID(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const t=this.canonical.z+1,i=2*this.canonical.x,r=2*this.canonical.y;return[new OverscaledTileID(t,this.wrap,t,i,r),new OverscaledTileID(t,this.wrap,t,i+1,r),new OverscaledTileID(t,this.wrap,t,i,r+1),new OverscaledTileID(t,this.wrap,t,i+1,r+1)]}isLessThan(e){return this.wrap<e.wrap||!(this.wrap>e.wrap)&&(this.overscaledZ<e.overscaledZ||!(this.overscaledZ>e.overscaledZ)&&(this.canonical.x<e.canonical.x||!(this.canonical.x>e.canonical.x)&&this.canonical.y<e.canonical.y))}wrapped(){return new OverscaledTileID(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(e){return new OverscaledTileID(this.overscaledZ,e,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new UnwrappedTileID(this.wrap,this.canonical)}toString(){return`${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}}function yc(e,t,i,r,n){const o=1<<Math.min(i,22);let a=o*(n%o)+r%o;return e&&i<22&&(a+=o*o*((e<0?-2*e-1:2*e)%(1<<2*(22-i)))),16*(32*a+i)+(t-i)}const xc=[e=>{let t=e.canonical.x-1,i=e.wrap;return t<0&&(t=(1<<e.canonical.z)-1,i--),new OverscaledTileID(e.overscaledZ,i,e.canonical.z,t,e.canonical.y)},e=>{let t=e.canonical.x+1,i=e.wrap;return t===1<<e.canonical.z&&(t=0,i++),new OverscaledTileID(e.overscaledZ,i,e.canonical.z,t,e.canonical.y)},e=>new OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,(0===e.canonical.y?1<<e.canonical.z:e.canonical.y)-1),e=>new OverscaledTileID(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y===(1<<e.canonical.z)-1?0:e.canonical.y+1)];Fo(CanonicalTileID,"CanonicalTileID"),Fo(OverscaledTileID,"OverscaledTileID",{omit:["projMatrix"]});class Ray{constructor(e,t){this.pos=e,this.dir=t}intersectsPlane(e,t,i){const r=lc.dot(t,this.dir);if(Math.abs(r)<1e-6)return!1;const n=((e[0]-this.pos[0])*t[0]+(e[1]-this.pos[1])*t[1]+(e[2]-this.pos[2])*t[2])/r;return i[0]=this.pos[0]+this.dir[0]*n,i[1]=this.pos[1]+this.dir[1]*n,i[2]=this.pos[2]+this.dir[2]*n,!0}closestPointOnSphere(e,t,i){if(lc.equals(this.pos,e)||0===t)return i[0]=i[1]=i[2]=0,!1;const[r,n,o]=this.dir,a=this.pos[0]-e[0],s=this.pos[1]-e[1],l=this.pos[2]-e[2],c=r*r+n*n+o*o,u=2*(a*r+s*n+l*o),h=u*u-4*c*(a*a+s*s+l*l-t*t);if(h<0){const e=Math.max(-u/2,0),c=a+r*e,h=s+n*e,d=l+o*e,p=Math.hypot(c,h,d);return i[0]=c*t/p,i[1]=h*t/p,i[2]=d*t/p,!1}{const e=(-u-Math.sqrt(h))/(2*c);if(e<0){const e=Math.hypot(a,s,l);return i[0]=a*t/e,i[1]=s*t/e,i[2]=l*t/e,!1}return i[0]=a+r*e,i[1]=s+n*e,i[2]=l+o*e,!0}}}class FrustumCorners{constructor(e,t,i,r,n){this.TL=e,this.TR=t,this.BR=i,this.BL=r,this.horizon=n}static fromInvProjectionMatrix(e,t,i){const r=[-1,1,1],n=[1,1,1],o=[1,-1,1],a=[-1,-1,1],s=lc.transformMat4(r,r,e),l=lc.transformMat4(n,n,e),c=lc.transformMat4(o,o,e),u=lc.transformMat4(a,a,e);return new FrustumCorners(s,l,c,u,t/i)}}function vc(e,t,i){let r=1/0,n=-1/0;const o=[];for(const a of e){lc.sub(o,a,t);const e=lc.dot(o,i);r=Math.min(r,e),n=Math.max(n,e)}return[r,n]}function bc(e,t){let i=!0;for(let r=0;r<e.planes.length;r++){const n=e.planes[r];let o=0;for(let e=0;e<t.length;e++)o+=lc.dot(n,t[e])+n[3]>=0;if(0===o)return 0;o!==t.length&&(i=!1)}return i?2:1}function wc(e,t){for(const i of e.projections){const r=vc(t,e.points[0],i.axis);if(i.projection[1]<r[0]||i.projection[0]>r[1])return 0}return 1}function Tc(e,t){let i=0;const r=[0,0,0,0];for(let n=0;n<e.length;n++)r[0]=e[n][0],r[1]=e[n][1],r[2]=e[n][2],r[3]=1,Wl.dot(r,t)>=0&&i++;return i}class Frustum{constructor(e,t){this.points=e||new Array(8).fill([0,0,0]),this.planes=t||new Array(6).fill([0,0,0,0]),this.bounds=Aabb.fromPoints(this.points),this.projections=[],this.frustumEdges=[lc.sub([],this.points[2],this.points[3]),lc.sub([],this.points[0],this.points[3]),lc.sub([],this.points[4],this.points[0]),lc.sub([],this.points[5],this.points[1]),lc.sub([],this.points[6],this.points[2]),lc.sub([],this.points[7],this.points[3])];for(const e of this.frustumEdges){const t=[0,-e[2],e[1]],i=[e[2],0,-e[0]];this.projections.push({axis:t,projection:vc(this.points,this.points[0],t)}),this.projections.push({axis:i,projection:vc(this.points,this.points[0],i)})}}static fromInvProjectionMatrix(e,t,i,r){const n=Math.pow(2,i),o=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map((i=>{const o=Wl.transformMat4([],i,e),a=1/o[3]/t*n;return Wl.mul(o,o,[a,a,r?1/o[3]:a,a])})),a=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map((e=>{const t=lc.sub([],o[e[0]],o[e[1]]),i=lc.sub([],o[e[2]],o[e[1]]),r=lc.normalize([],lc.cross([],t,i)),n=-lc.dot(r,o[e[1]]);return r.concat(n)})),s=[];for(let e=0;e<o.length;e++)s.push([o[e][0],o[e][1],o[e][2]]);return new Frustum(s,a)}intersectsPrecise(e,t,i){for(let i=0;i<t.length;i++)if(!Tc(e,t[i]))return 0;for(let t=0;t<this.planes.length;t++)if(!Tc(e,this.planes[t]))return 0;for(const t of i)for(const i of this.frustumEdges){const r=lc.cross([],t,i),n=lc.length(r);if(0===n)continue;lc.scale(r,r,1/n);const o=vc(this.points,this.points[0],r),a=vc(e,this.points[0],r);if(o[0]>a[1]||a[0]>o[1])return 0}return 1}}class Aabb{static fromPoints(e){const t=[1/0,1/0,1/0],i=[-1/0,-1/0,-1/0];for(const r of e)lc.min(t,t,r),lc.max(i,i,r);return new Aabb(t,i)}static fromTileIdAndHeight(e,t,i){const r=1<<e.canonical.z,n=e.canonical.x,o=e.canonical.y;return new Aabb([n/r,o/r,t],[(n+1)/r,(o+1)/r,i])}static applyTransform(e,t){const i=e.getCorners();for(let e=0;e<i.length;++e)lc.transformMat4(i[e],i[e],t);return Aabb.fromPoints(i)}static projectAabbCorners(e,t){const i=e.getCorners();for(let e=0;e<i.length;++e)lc.transformMat4(i[e],i[e],t);return i}constructor(e,t){this.min=e,this.max=t,this.center=lc.scale([],lc.add([],this.min,this.max),.5)}quadrant(e){const t=[e%2==0,e<2],i=lc.clone(this.min),r=lc.clone(this.max);for(let e=0;e<t.length;e++)i[e]=t[e]?this.min[e]:this.center[e],r[e]=t[e]?this.center[e]:this.max[e];return r[2]=this.max[2],new Aabb(i,r)}distanceX(e){return Math.max(Math.min(this.max[0],e[0]),this.min[0])-e[0]}distanceY(e){return Math.max(Math.min(this.max[1],e[1]),this.min[1])-e[1]}distanceZ(e){return Math.max(Math.min(this.max[2],e[2]),this.min[2])-e[2]}getCorners(){const e=this.min,t=this.max;return[[e[0],e[1],e[2]],[t[0],e[1],e[2]],[t[0],t[1],e[2]],[e[0],t[1],e[2]],[e[0],e[1],t[2]],[t[0],e[1],t[2]],[t[0],t[1],t[2]],[e[0],t[1],t[2]]]}intersects(e){return this.intersectsAabb(e.bounds)?bc(e,this.getCorners()):0}intersectsFlat(e){return this.intersectsAabb(e.bounds)?bc(e,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsPrecise(e,t){return t||this.intersects(e)?wc(e,this.getCorners()):0}intersectsPreciseFlat(e,t){return t||this.intersectsFlat(e)?wc(e,[[this.min[0],this.min[1],0],[this.max[0],this.min[1],0],[this.max[0],this.max[1],0],[this.min[0],this.max[1],0]]):0}intersectsAabb(e){for(let t=0;t<3;++t)if(this.min[t]>e.max[t]||e.min[t]>this.max[t])return!1;return!0}intersectsAabbXY(e){return!(this.min[0]>e.max[0]||e.min[0]>this.max[0]||this.min[1]>e.max[1]||e.min[1]>this.max[1])}encapsulate(e){for(let t=0;t<3;t++)this.min[t]=Math.min(this.min[t],e.min[t]),this.max[t]=Math.max(this.max[t],e.max[t])}encapsulatePoint(e){for(let t=0;t<3;t++)this.min[t]=Math.min(this.min[t],e[t]),this.max[t]=Math.max(this.max[t],e[t])}closestPoint(e){return[Math.max(Math.min(this.max[0],e[0]),this.min[0]),Math.max(Math.min(this.max[1],e[1]),this.min[1]),Math.max(Math.min(this.max[2],e[2]),this.min[2])]}}Fo(Aabb,"Aabb");const Ec=5,Mc=6,Sc=Ri/Math.PI/2,Ac=16383,Cc=64,Ic=[Cc,32,16],Dc=-Sc,Pc=Sc,Lc=[new Aabb([Dc,Dc,Dc],[Pc,Pc,Pc]),new Aabb([Dc,Dc,Dc],[0,0,Pc]),new Aabb([0,Dc,Dc],[Pc,0,Pc]),new Aabb([Dc,0,Dc],[0,Pc,Pc]),new Aabb([0,0,Dc],[Pc,Pc,Pc])];function zc(e){return e*Sc/uu}function Rc(e,t,i,r=!0){const n=lc.scale([],e._camera.position,e.worldSize),o=[t,i,1,1];Wl.transformMat4(o,o,e.pixelMatrixInverse),Wl.scale(o,o,1/o[3]);const a=lc.sub([],o,n),s=lc.normalize([],a),l=e.globeMatrix,c=[l[12],l[13],l[14]],u=lc.sub([],c,n),h=lc.length(u),d=lc.normalize([],u),p=e.worldSize/(2*Math.PI),f=lc.dot(d,s),m=Math.asin(p/h);if(m<Math.acos(f)){if(!r)return null;const e=[],t=[];lc.scale(e,s,h/f),lc.normalize(t,lc.sub(t,e,u)),lc.normalize(s,lc.add(s,u,lc.scale(s,t,Math.tan(m)*h)))}const _=[];new Ray(n,s).closestPointOnSphere(c,p,_);const g=lc.normalize([],ie(l,0)),y=lc.normalize([],ie(l,1)),x=lc.normalize([],ie(l,2)),v=lc.dot(g,_),b=lc.dot(y,_),T=lc.dot(x,_),E=w(Math.asin(-b/p));let M=w(Math.atan2(v,T));M=e.center.lng+function(e,t){const i=(t-e+180)%360-180;return i<-180?i+360:i}(e.center.lng,M);const S=_u(M),A=I(gu(E),0,1);return new MercatorCoordinate(S,A)}class Arc{constructor(e,t,i){this.a=lc.sub([],e,i),this.b=lc.sub([],t,i),this.center=i;const r=lc.normalize([],this.a),n=lc.normalize([],this.b);this.angle=Math.acos(lc.dot(r,n))}}function kc(e,t){if(0===e.angle)return null;let i;return i=0===e.a[t]?1/e.angle*.5*Math.PI:1/e.angle*Math.atan(e.b[t]/e.a[t]/Math.sin(e.angle)-1/Math.tan(e.angle)),i<0||i>1?null:function(e,t,i,r){const n=Math.sin(i);return e*(Math.sin((1-r)*i)/n)+t*(Math.sin(r*i)/n)}(e.a[t],e.b[t],e.angle,I(i,0,1))+e.center[t]}function Bc(e){if(e.z<=1)return Lc[e.z+2*e.y+e.x];const t=jc(Nc(e));return Aabb.fromPoints(t)}function Oc(e,t,i){return lc.scale(e,e,1-i),lc.scaleAndAdd(e,e,t,i)}function Fc(e,t){const i=Qc(t.zoom);if(0===i)return Bc(e);const r=Nc(e),n=jc(r),o=_u(r.getWest())*t.worldSize,a=_u(r.getEast())*t.worldSize,s=gu(r.getNorth())*t.worldSize,l=gu(r.getSouth())*t.worldSize,c=[o,s,0],u=[a,s,0],h=[o,l,0],d=[a,l,0],p=ic.invert([],t.globeMatrix);return lc.transformMat4(c,c,p),lc.transformMat4(u,u,p),lc.transformMat4(h,h,p),lc.transformMat4(d,d,p),n[0]=Oc(n[0],h,i),n[1]=Oc(n[1],d,i),n[2]=Oc(n[2],u,i),n[3]=Oc(n[3],c,i),Aabb.fromPoints(n)}function Uc(e,t,i){for(const r of e)lc.transformMat4(r,r,t),lc.scale(r,r,i)}function Vc(e,t,i,r){const n=t/e.worldSize,o=e.globeMatrix;if(i.z<=1){const e=Bc(i).getCorners();return Uc(e,o,n),Aabb.fromPoints(e)}const a=Nc(i,r),s=jc(a);Uc(s,o,n);const l=Number.MAX_VALUE,c=[-l,-l,-l],u=[l,l,l];if(a.contains(e.center)){for(const e of s)lc.min(u,u,e),lc.max(c,c,e);c[2]=0;const t=e.point,i=[t.x*n,t.y*n,0];return lc.min(u,u,i),lc.max(c,c,i),new Aabb(u,c)}const h=[o[12]*n,o[13]*n,o[14]*n],d=a.getCenter(),p=I(e.center.lat,-wu,wu),f=I(d.lat,-wu,wu),m=_u(e.center.lng),_=gu(p);let g=m-_u(d.lng);const y=_-gu(f);g>.5?g-=1:g<-.5&&(g+=1);let x=0;if(Math.abs(g)>Math.abs(y))x=g>=0?1:3;else{x=y>=0?0:2;const e=[o[4]*n,o[5]*n,o[6]*n],t=-Math.sin(b(y>=0?a.getSouth():a.getNorth()))*Sc;lc.scaleAndAdd(h,h,e,t)}const v=s[x],w=s[(x+1)%4],T=new Arc(v,w,h),E=[kc(T,0)||v[0],kc(T,1)||v[1],kc(T,2)||v[2]],M=Qc(e.zoom);if(M>0){const r=function({x:e,y:t,z:i},r,n,o,a){const s=1/(1<<i);let l=e*s,c=l+s,u=t*s,h=u+s,d=0;const p=(l+c)/2-o;return p>.5?d=-1:p<-.5&&(d=1),l=((l+d)*r-(o*=r))*n+o,c=((c+d)*r-o)*n+o,u=(u*r-(a*=r))*n+a,h=(h*r-a)*n+a,[[l,h,0],[c,h,0],[c,u,0],[l,u,0]]}(i,t,e._pixelsPerMercatorPixel,m,_);for(let e=0;e<s.length;e++)Oc(s[e],r[e],M);const n=lc.add([],r[x],r[(x+1)%4]);lc.scale(n,n,.5),Oc(E,n,M)}for(const e of s)lc.min(u,u,e),lc.max(c,c,e);return u[2]=Math.min(v[2],w[2]),lc.min(u,u,E),lc.max(c,c,E),new Aabb(u,c)}function Nc({x:e,y:t,z:i},r=!1){const n=1/(1<<i),o=new du(xu(e*n),t===(1<<i)-1&&r?-90:vu((t+1)*n)),a=new du(xu((e+1)*n),0===t&&r?90:vu(t*n));return new LngLatBounds(o,a)}function jc(e){const t=b(e.getNorth()),i=b(e.getSouth()),r=Math.cos(t),n=Math.cos(i),o=Math.sin(t),a=Math.sin(i),s=e.getWest(),l=e.getEast();return[Gc(n,a,s),Gc(n,a,l),Gc(r,o,l),Gc(r,o,s)]}function Gc(e,t,i,r=Sc){return i=b(i),[e*Math.sin(i)*r,-t*r,e*Math.cos(i)*r]}function qc(e,t,i){return Gc(Math.cos(b(e)),Math.sin(b(e)),t,i)}function Zc(e,t,i,r){const n=1<<i.z,o=(e/Ri+i.x)/n;return qc(vu((t/Ri+i.y)/n),xu(o),r)}function $c({min:e,max:t}){return Ac/Math.max(t[0]-e[0],t[1]-e[1],t[2]-e[2])}const Hc=new Float64Array(16);function Wc(e){const t=$c(e),i=ic.fromScaling(Hc,[t,t,t]);return ic.translate(i,i,lc.negate([],e.min))}function Xc(e){const t=ic.fromTranslation(Hc,e.min),i=1/$c(e);return ic.scale(t,t,[i,i,i])}function Yc(e){const t=Ri/(2*Math.PI);return e/(2*Math.PI)/t}function Kc(e,t){return Ri/(512*Math.pow(2,e))*$c(Bc(t))}function Jc(e,t,i,r,n){const o=Yc(i),a=[e,t,-i/(2*Math.PI)],s=ic.identity(new Float64Array(16));return ic.translate(s,s,a),ic.scale(s,s,[o,o,o]),ic.rotateX(s,s,b(-n)),ic.rotateY(s,s,b(-r)),s}function Qc(e){return D(Ec,Mc,e)}function eu(e,t,i){const r=ic.identity(new Float64Array(16)),n=(t/(1<<e)-.5)*Math.PI*2;return ic.rotateY(r,i.globeMatrix,n),Float32Array.from(r)}function tu(e,t,i){const r=Qc(i.zoom),n=e.style.map._antialias,o=t.extStandardDerivativesForceOff||e.terrain&&e.terrain.exaggeration()>0;return 0===r&&!n&&!o}function iu(e,t,i,r){const n=t.getNorth(),o=t.getSouth(),a=t.getWest(),s=t.getEast(),l=1<<e.z,c=s-a,u=n-o,h=c/Cc,d=-u/Ic[i],p=[0,h,0,d,0,0,n,a,0];if(e.z>0){const e=180/r;ec.multiply(p,p,[e/c+1,0,0,0,e/u+1,0,-.5*e/h,.5*e/d,1])}return p[2]=l,p[5]=e.x,p[8]=e.y,p}function ru(e){const t=wu-5;e=I(e,-t,t)/t*90;const i=Math.pow(Math.abs(Math.sin(b(e))),3);return Math.round(i*(Ic.length-1))}function nu(e){const t=[0,0,0],i=ic.identity(new Float64Array(16));return ic.multiply(i,e.pixelMatrix,e.globeMatrix),lc.transformMat4(t,t,i),new g(t[0],t[1])}function ou(e,t){const i=qc(t.lat,t.lng),r=function(e){const t=qc(e._center.lat,e._center.lng),i=lc.fromValues(0,1,0);let r=lc.cross([],i,t);const n=ic.fromRotation([],-e.angle,t);r=lc.transformMat4(r,r,n),ic.fromRotation(n,-e._pitch,r);const o=lc.normalize([],t);return lc.scale(o,o,zc(e.cameraToCenterDistance/e.pixelsPerMeter)),lc.transformMat4(o,o,n),lc.add([],t,o)}(e),n=lc.subtract([],r,i);return lc.angle(n,i)}function au(e,t){return ou(e,t)>Math.PI/2*1.01}const su=b(85),lu=Math.cos(su),cu=Math.sin(su);class GlobeSharedBuffers{constructor(e){this._createGrid(e),this._createPoles(e)}destroy(){this._poleIndexBuffer.destroy(),this._gridBuffer.destroy(),this._gridIndexBuffer.destroy(),this._poleNorthVertexBuffer.destroy(),this._poleSouthVertexBuffer.destroy();for(const e of this._poleSegments)e.destroy();for(const e of this._gridSegments)e.withSkirts.destroy(),e.withoutSkirts.destroy()}_fillGridMeshWithLods(e,t){const i=new StructArrayLayout2i4,r=new StructArrayLayout3ui6,n=[],o=e+1+2,a=t[0]+1,s=t[0]+1+(1+t.length),l=(e,t,i)=>{let r=e===o-1?e-2:0===e?e:e-1;return r+=i?24575:0,[r,t]};for(let e=0;e<o;++e)i.emplaceBack(...l(e,0,!0));for(let e=0;e<a;++e)for(let t=0;t<o;++t)i.emplaceBack(...l(t,e,(0===t||t===o-1)&&!0));for(let e=0;e<t.length;++e){const r=t[e];for(let e=0;e<o;++e)i.emplaceBack(...l(e,r,!0))}for(let e=0;e<t.length;++e){const a=r.length,l=t[e]+1+2,c=new StructArrayLayout3ui6;for(let i=0;i<l-1;i++){const n=i===l-2,a=n?o*(s-t.length+e-i):o;for(let e=0;e<o-1;e++){const t=i*o+e;0===i||n||0===e||e===o-2?(c.emplaceBack(t+1,t,t+a),c.emplaceBack(t+a,t+a+1,t+1)):(r.emplaceBack(t+1,t,t+a),r.emplaceBack(t+a,t+a+1,t+1))}}const u=SegmentVector.simpleSegment(0,a,i.length,r.length-a);for(let e=0;e<c.uint16.length;e+=3)r.emplaceBack(c.uint16[e],c.uint16[e+1],c.uint16[e+2]);const h=SegmentVector.simpleSegment(0,a,i.length,r.length-a);n.push({withoutSkirts:u,withSkirts:h})}return{vertices:i,indices:r,segments:n}}_createGrid(e){const t=this._fillGridMeshWithLods(Cc,Ic);this._gridSegments=t.segments,this._gridBuffer=e.createVertexBuffer(t.vertices,mc.members),this._gridIndexBuffer=e.createIndexBuffer(t.indices,!0)}_createPoles(e){const t=new StructArrayLayout3ui6;for(let e=0;e<=Cc;e++)t.emplaceBack(0,e+1,e+2);this._poleIndexBuffer=e.createIndexBuffer(t,!0);const i=new StructArrayLayout5f20,r=new StructArrayLayout5f20,n=new StructArrayLayout5f20,o=new StructArrayLayout5f20;this._poleSegments=[];for(let e=0,t=0;e<Ec;e++){const a=360/(1<<e);i.emplaceBack(0,-Sc,0,.5,0),r.emplaceBack(0,-Sc,0,.5,1),n.emplaceBack(0,-Sc,0,.5,.5),o.emplaceBack(0,-Sc,0,.5,.5);for(let e=0;e<=Cc;e++){let t=e/Cc,s=0;const l=yr(0,a,t),[c,u,h]=Gc(lu,cu,l,Sc);i.emplaceBack(c,u,h,t,s),r.emplaceBack(c,u,h,t,1-s);const d=b(l);t=.5+.5*Math.sin(d),s=.5+.5*Math.cos(d),n.emplaceBack(c,u,h,t,s),o.emplaceBack(c,u,h,t,1-s)}this._poleSegments.push(SegmentVector.simpleSegment(t,0,66,64)),t+=66}this._poleNorthVertexBuffer=e.createVertexBuffer(i,pc,!1),this._poleSouthVertexBuffer=e.createVertexBuffer(r,pc,!1),this._texturedPoleNorthVertexBuffer=e.createVertexBuffer(n,pc,!1),this._texturedPoleSouthVertexBuffer=e.createVertexBuffer(o,pc,!1)}getGridBuffers(e,t){return[this._gridBuffer,this._gridIndexBuffer,t?this._gridSegments[e].withSkirts:this._gridSegments[e].withoutSkirts]}getPoleBuffers(e,t){return[t?this._texturedPoleNorthVertexBuffer:this._poleNorthVertexBuffer,t?this._texturedPoleSouthVertexBuffer:this._poleSouthVertexBuffer,this._poleIndexBuffer,this._poleSegments[e]]}}const uu=6371008.8,hu=2*Math.PI*uu;class LngLat{constructor(e,t){if(isNaN(e)||isNaN(t))throw new Error(`Invalid LngLat object: (${e}, ${t})`);if(this.lng=+e,this.lat=+t,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new LngLat(P(this.lng,-180,180),this.lat)}toArray(){return[this.lng,this.lat]}toString(){return`LngLat(${this.lng}, ${this.lat})`}distanceTo(e){const t=Math.PI/180,i=this.lat*t,r=e.lat*t,n=Math.sin(i)*Math.sin(r)+Math.cos(i)*Math.cos(r)*Math.cos((e.lng-this.lng)*t);return uu*Math.acos(Math.min(n,1))}toBounds(e=0){const t=360*e/40075017,i=t/Math.cos(Math.PI/180*this.lat);return new LngLatBounds(new LngLat(this.lng-i,this.lat-t),new LngLat(this.lng+i,this.lat+t))}toEcef(e){const t=zc(e);return qc(this.lat,this.lng,Sc+t)}static convert(e){if(e instanceof LngLat)return e;if(Array.isArray(e)&&(2===e.length||3===e.length))return new LngLat(Number(e[0]),Number(e[1]));if(!Array.isArray(e)&&"object"==typeof e&&null!==e)return new LngLat(Number("lng"in e?e.lng:e.lon),Number(e.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}var du=LngLat;const pu=0,fu=25.5;function mu(e){return hu*Math.cos(e*Math.PI/180)}function _u(e){return(180+e)/360}function gu(e){return(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+e*Math.PI/360)))/360}function yu(e,t){return e/mu(t)}function xu(e){return 360*e-180}function vu(e){return 360/Math.PI*Math.atan(Math.exp((180-360*e)*Math.PI/180))-90}function bu(e,t){return e*mu(vu(t))}const wu=85.051129;function Tu(e){return Math.cos(b(I(e,-wu,wu)))}function Eu(e,t){const i=I(t,pu,fu),r=Math.pow(2,i);return Tu(e)*hu/(512*r)}function Mu(e){return 1/Math.cos(e*Math.PI/180)}function Su(e,t=0){const i=Math.exp(Math.PI*(1-(e.y+t/Ri)/(1<<e.z)*2));return 80150034*i/(i*i+1)/Ri/(1<<e.z)}class MercatorCoordinate{constructor(e,t,i=0){this.x=+e,this.y=+t,this.z=+i}static fromLngLat(e,t=0){const i=du.convert(e);return new MercatorCoordinate(_u(i.lng),gu(i.lat),yu(t,i.lat))}toLngLat(){return new du(xu(this.x),vu(this.y))}toAltitude(){return bu(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/hu*Mu(vu(this.y))}}function Au(e,t,i,r,n,o,a,s,l){const c=(t+r)/2,u=(i+n)/2,h=new g(c,u);s(h),function(e,t,i,r,n,o){const a=i-n,s=r-o;return Math.abs((r-t)*a-(i-e)*s)/Math.hypot(a,s)}(h.x,h.y,o.x,o.y,a.x,a.y)>=l?(Au(e,t,i,c,u,o,h,s,l),Au(e,c,u,r,n,h,a,s,l)):e.push(a)}function Cu(e,t,i){let r=e[0],n=r.x,o=r.y;t(r);const a=[r];for(let s=1;s<e.length;s++){const l=e[s],{x:c,y:u}=l;t(l),Au(a,n,o,c,u,r,l,t,i),n=c,o=u,r=l}return a}function Iu(e,t,i,r){if(r(t,i)){const n=t.add(i)._mult(.5);Iu(e,t,n,r),Iu(e,n,i,r)}else e.push(i)}function Du(e,t){let i=e[0];const r=[i];for(let n=1;n<e.length;n++){const o=e[n];Iu(r,i,o,t),i=o}return r}const Pu=Math.pow(2,14)-1,Lu=-Pu-1;function zu(e,t){const i=Math.round(e.x*t),r=Math.round(e.y*t);return e.x=I(i,Lu,Pu),e.y=I(r,Lu,Pu),(i<e.x||i>e.x+1||r<e.y||r>e.y+1)&&$("Geometry exceeds allowed extent, reduce your vector tile buffer size"),e}function Ru(e,t,i){const r=e.loadGeometry(),n=e.extent,o=Ri/n;if(t&&i&&i.projection.isReprojectedInTileSpace){const o=1<<t.z,{scale:a,x:s,y:l,projection:c}=i,u=e=>{const i=xu((t.x+e.x/n)/o),r=vu((t.y+e.y/n)/o),u=c.project(i,r);e.x=(u.x*a-s)*n,e.y=(u.y*a-l)*n};for(let t=0;t<r.length;t++)if(1!==e.type)r[t]=Cu(r[t],u,1);else{const e=[];for(const i of r[t])i.x<0||i.x>=n||i.y<0||i.y>=n||(u(i),e.push(i));r[t]=e}}for(const e of r)for(const t of e)zu(t,o);return r}function ku(e,t){return{type:e.type,id:e.id,properties:e.properties,geometry:t?Ru(e):[]}}function Bu(e,t,i,r,n){e.emplaceBack(2*t+(r+1)/2,2*i+(n+1)/2)}function Ou(e,t,i){const r=16384;e.emplaceBack(t.x,t.y,t.z,i[0]*r,i[1]*r,i[2]*r)}class CircleBucket{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.fqid)),this.index=e.index,this.hasPattern=!1,this.projection=e.projection,this.layoutVertexArray=new StructArrayLayout2i4,this.indexArray=new StructArrayLayout3ui6,this.segments=new SegmentVector,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i,r){const n=this.layers[0],o=[];let a=null;"circle"===n.type&&(a=n.layout.get("circle-sort-key"));for(const{feature:t,id:n,index:s,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,c=ku(t,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),c,i))continue;const u=a?a.evaluate(c,{},i):void 0,h={id:n,properties:t.properties,type:t.type,sourceLayerIndex:l,index:s,geometry:e?c.geometry:Ru(t,i,r),patterns:{},sortKey:u};o.push(h)}a&&o.sort(((e,t)=>e.sortKey-t.sortKey));let s=null;"globe"===r.projection.name&&(this.globeExtVertexArray=new StructArrayLayout6i12,s=r.projection);for(const r of o){const{geometry:n,index:o,sourceLayerIndex:a}=r,l=e[o].feature;this.addFeature(r,n,o,t.availableImages,i,s,t.brightness),t.featureIndex.insert(l,n,o,a,this.index)}}update(e,t,i,r,n){const o=0!==Object.keys(e).length;o&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(e,t,o?this.stateDependentLayers:this.layers,i,r,n)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,pa.members),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.globeExtVertexArray&&(this.globeExtVertexBuffer=e.createVertexBuffer(this.globeExtVertexArray,fa.members))),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy())}addFeature(e,t,i,r,n,o,a){for(const i of t)for(const t of i){const i=t.x,r=t.y;if(i<0||i>=Ri||r<0||r>=Ri)continue;if(o){const e=o.projectTilePoint(i,r,n),t=o.upVector(n,i,r),a=this.globeExtVertexArray;Ou(a,e,t),Ou(a,e,t),Ou(a,e,t),Ou(a,e,t)}const a=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,e.sortKey),s=a.vertexLength;Bu(this.layoutVertexArray,i,r,-1,-1),Bu(this.layoutVertexArray,i,r,1,-1),Bu(this.layoutVertexArray,i,r,1,1),Bu(this.layoutVertexArray,i,r,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+2,s+3),a.vertexLength+=4,a.primitiveLength+=2}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,{},r,n,a)}}function Fu(e,t){for(let i=0;i<e.length;i++)if(Hu(t,e[i]))return!0;for(let i=0;i<t.length;i++)if(Hu(e,t[i]))return!0;return!!ju(e,t)}function Uu(e,t,i){return!!Hu(e,t)||!!qu(t,e,i)}function Vu(e,t){if(1===e.length)return $u(t,e[0]);for(let i=0;i<t.length;i++){const r=t[i];for(let t=0;t<r.length;t++)if(Hu(e,r[t]))return!0}for(let i=0;i<e.length;i++)if($u(t,e[i]))return!0;for(let i=0;i<t.length;i++)if(ju(e,t[i]))return!0;return!1}function Nu(e,t,i){if(e.length>1){if(ju(e,t))return!0;for(let r=0;r<t.length;r++)if(qu(t[r],e,i))return!0}for(let r=0;r<e.length;r++)if(qu(e[r],t,i))return!0;return!1}function ju(e,t){if(0===e.length||0===t.length)return!1;for(let i=0;i<e.length-1;i++){const r=e[i],n=e[i+1];for(let e=0;e<t.length-1;e++)if(Gu(r,n,t[e],t[e+1]))return!0}return!1}function Gu(e,t,i,r){return H(e,i,r)!==H(t,i,r)&&H(e,t,i)!==H(e,t,r)}function qu(e,t,i){const r=i*i;if(1===t.length)return e.distSqr(t[0])<r;for(let i=1;i<t.length;i++)if(Zu(e,t[i-1],t[i])<r)return!0;return!1}function Zu(e,t,i){const r=t.distSqr(i);if(0===r)return e.distSqr(t);const n=((e.x-t.x)*(i.x-t.x)+(e.y-t.y)*(i.y-t.y))/r;return e.distSqr(n<0?t:n>1?i:i.sub(t)._mult(n)._add(t))}function $u(e,t){let i,r,n,o=!1;for(let a=0;a<e.length;a++){i=e[a];for(let e=0,a=i.length-1;e<i.length;a=e++)r=i[e],n=i[a],r.y>t.y!=n.y>t.y&&t.x<(n.x-r.x)*(t.y-r.y)/(n.y-r.y)+r.x&&(o=!o)}return o}function Hu(e,t){let i=!1;for(let r=0,n=e.length-1;r<e.length;n=r++){const o=e[r],a=e[n];o.y>t.y!=a.y>t.y&&t.x<(a.x-o.x)*(t.y-o.y)/(a.y-o.y)+o.x&&(i=!i)}return i}function Wu(e,t,i,r,n){for(const o of e)if(t<=o.x&&i<=o.y&&r>=o.x&&n>=o.y)return!0;const o=[new g(t,i),new g(t,n),new g(r,n),new g(r,i)];if(e.length>2)for(const t of o)if(Hu(e,t))return!0;for(let t=0;t<e.length-1;t++)if(Xu(e[t],e[t+1],o))return!0;return!1}function Xu(e,t,i){const r=i[0],n=i[2];if(e.x<r.x&&t.x<r.x||e.x>n.x&&t.x>n.x||e.y<r.y&&t.y<r.y||e.y>n.y&&t.y>n.y)return!1;const o=H(e,t,i[0]);return o!==H(e,t,i[1])||o!==H(e,t,i[2])||o!==H(e,t,i[3])}function Yu(e,t,i,r,n,o){let a=t.y-e.y,s=e.x-t.x;if(o=o||0){const e=a*a+s*s;if(0===e)return!0;const t=Math.sqrt(e);a/=t,s/=t}return!((i.x-e.x)*a+(i.y-e.y)*s-o<0||(r.x-e.x)*a+(r.y-e.y)*s-o<0||(n.x-e.x)*a+(n.y-e.y)*s-o<0)}function Ku(e,t,i,r,n,o,a){return!(Yu(e,t,r,n,o,a)||Yu(t,i,r,n,o,a)||Yu(i,e,r,n,o,a)||Yu(r,n,e,t,i,a)||Yu(n,o,e,t,i,a)||Yu(o,r,e,t,i,a))}function Ju(e,t,i){const r=t.paint.get(e).value;return"constant"===r.kind?r.value:i.programConfigurations.get(t.id).getMaxValue(e)}function Qu(e){return Math.sqrt(e[0]*e[0]+e[1]*e[1])}function eh(e,t,i,r,n){if(!t[0]&&!t[1])return e;const o=g.convert(t)._mult(n);"viewport"===i&&o._rotate(-r);const a=[];for(let t=0;t<e.length;t++)a.push(e[t].sub(o));return a}function th(e,t,i,r){const n=g.convert(e)._mult(r);return"viewport"===t&&n._rotate(-i),n}Fo(CircleBucket,"CircleBucket",{omit:["layers"]});const ih=new Properties({"circle-sort-key":new DataDrivenProperty(xt.layout_circle["circle-sort-key"]),visibility:new DataConstantProperty(xt.layout_circle.visibility)});var rh={paint:new Properties({"circle-radius":new DataDrivenProperty(xt.paint_circle["circle-radius"]),"circle-color":new DataDrivenProperty(xt.paint_circle["circle-color"]),"circle-blur":new DataDrivenProperty(xt.paint_circle["circle-blur"]),"circle-opacity":new DataDrivenProperty(xt.paint_circle["circle-opacity"]),"circle-translate":new DataConstantProperty(xt.paint_circle["circle-translate"]),"circle-translate-anchor":new DataConstantProperty(xt.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new DataConstantProperty(xt.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new DataConstantProperty(xt.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new DataDrivenProperty(xt.paint_circle["circle-stroke-width"]),"circle-stroke-color":new DataDrivenProperty(xt.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new DataDrivenProperty(xt.paint_circle["circle-stroke-opacity"]),"circle-emissive-strength":new DataConstantProperty(xt.paint_circle["circle-emissive-strength"])}),layout:ih};const nh=ic.create(),oh=(e,t,i,r,n,o)=>{const a=e.transform,s="globe"===a.projection.name;let l;if("map"===o.paint.get("circle-pitch-alignment"))if(s){const e=Kc(a.zoom,t.canonical)*a._pixelsPerMercatorPixel;l=Float32Array.from([e,0,0,e])}else l=a.calculatePixelsToTileUnitsMatrix(i);else l=new Float32Array([a.pixelsToGLUnits[0],0,0,a.pixelsToGLUnits[1]]);const c={u_camera_to_center_distance:e.transform.getCameraToCenterDistance(a.projection),u_matrix:e.translatePosMatrix(t.projMatrix,i,o.paint.get("circle-translate"),o.paint.get("circle-translate-anchor")),u_device_pixel_ratio:rt.devicePixelRatio,u_extrude_scale:l,u_inv_rot_matrix:nh,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0],u_emissive_strength:o.paint.get("circle-emissive-strength")};if(s){c.u_inv_rot_matrix=r,c.u_merc_center=n,c.u_tile_id=[t.canonical.x,t.canonical.y,1<<t.canonical.z],c.u_zoom_transition=Qc(a.zoom);const e=n[0]*Ri,i=n[1]*Ri;c.u_up_dir=a.projection.upVector(new CanonicalTileID(0,0,0),e,i)}return c},ah=e=>{const t=[];return"map"===e.paint.get("circle-pitch-alignment")&&t.push("PITCH_WITH_MAP"),"map"===e.paint.get("circle-pitch-scale")&&t.push("SCALE_WITH_MAP"),t};function sh(e,t,i,r,n,o,a,s,l){if(o&&e.queryGeometry.isAboveHorizon)return!1;o&&(l*=e.pixelToTileUnitsFactor);const c=e.tileID.canonical,u=i.projection.upVectorScale(c,i.center.lat,i.worldSize).metersToTile;for(const h of t)for(const t of h){const h=t.add(s),d=n&&i.elevation?i.elevation.exaggeration()*n.getElevationAt(h.x,h.y,!0):0,p=i.projection.projectTilePoint(h.x,h.y,c);if(d>0){const e=i.projection.upVector(c,h.x,h.y);p.x+=e[0]*u*d,p.y+=e[1]*u*d,p.z+=e[2]*u*d}const f=o?h:lh(p.x,p.y,p.z,r),m=o?e.tilespaceRays.map((e=>hh(e,d))):e.queryGeometry.screenGeometry,_=Wl.transformMat4([],[p.x,p.y,p.z,1],r);if(!a&&o?l*=_[3]/i.cameraToCenterDistance:a&&!o&&(l*=i.cameraToCenterDistance/_[3]),o){const e=vu((t.y/Ri+c.y)/(1<<c.z));l/=i.projection.pixelsPerMeter(e,1)/yu(1,e)}if(Uu(m,f,l))return!0}return!1}function lh(e,t,i,r){const n=Wl.transformMat4([],[e,t,i,1],r);return new g(n[0]/n[3],n[1]/n[3])}const ch=lc.fromValues(0,0,0),uh=lc.fromValues(0,0,1);function hh(e,t){const i=lc.create();return ch[2]=t,e.intersectsPlane(ch,uh,i),new g(i[0],i[1])}class HeatmapBucket extends CircleBucket{}function dh(e,{width:t,height:i},r,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==t*i*r)throw new RangeError("mismatched image size")}else n=new Uint8Array(t*i*r);return e.width=t,e.height=i,e.data=n,e}function ph(e,t,i){const{width:r,height:n}=t;r===e.width&&n===e.height||(fh(e,t,{x:0,y:0},{x:0,y:0},{width:Math.min(e.width,r),height:Math.min(e.height,n)},i),e.width=r,e.height=n,e.data=t.data)}function fh(e,t,i,r,n,o){if(0===n.width||0===n.height)return t;if(n.width>e.width||n.height>e.height||i.x>e.width-n.width||i.y>e.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>t.width||n.height>t.height||r.x>t.width-n.width||r.y>t.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const a=e.data,s=t.data;for(let l=0;l<n.height;l++){const c=((i.y+l)*e.width+i.x)*o,u=((r.y+l)*t.width+r.x)*o;for(let e=0;e<n.width*o;e++)s[u+e]=a[c+e]}return t}Fo(HeatmapBucket,"HeatmapBucket",{omit:["layers"]});class AlphaImage{constructor(e,t){dh(this,e,1,t)}resize(e){ph(this,new AlphaImage(e),1)}clone(){return new AlphaImage({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,i,r,n){fh(e,t,i,r,n,1)}}class RGBAImage{constructor(e,t){dh(this,e,4,t)}resize(e){ph(this,new RGBAImage(e),4)}replace(e,t){t?this.data.set(e):this.data=e instanceof Uint8ClampedArray?new Uint8Array(e.buffer):e}clone(){return new RGBAImage({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(e,t,i,r,n){fh(e,t,i,r,n,4)}}class Float32Image{constructor(e,t){this.width=e.width,this.height=e.height,this.data=t instanceof Uint8Array?new Float32Array(t.buffer):t}}Fo(AlphaImage,"AlphaImage"),Fo(RGBAImage,"RGBAImage");const mh=new Properties({visibility:new DataConstantProperty(xt.layout_heatmap.visibility)});var _h={paint:new Properties({"heatmap-radius":new DataDrivenProperty(xt.paint_heatmap["heatmap-radius"]),"heatmap-weight":new DataDrivenProperty(xt.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new DataConstantProperty(xt.paint_heatmap["heatmap-intensity"]),"heatmap-color":new ColorRampProperty(xt.paint_heatmap["heatmap-color"]),"heatmap-opacity":new DataConstantProperty(xt.paint_heatmap["heatmap-opacity"])}),layout:mh};function gh(e){const t={},i=e.resolution||256,r=e.clips?e.clips.length:1,n=e.image||new RGBAImage({width:i,height:r}),o=(i,r,o)=>{t[e.evaluationKey]=o;const a=e.expression.evaluate(t);a&&(n.data[i+r+0]=Math.floor(255*a.r/a.a),n.data[i+r+1]=Math.floor(255*a.g/a.a),n.data[i+r+2]=Math.floor(255*a.b/a.a),n.data[i+r+3]=Math.floor(255*a.a))};if(e.clips)for(let t=0,n=0;t<r;++t,n+=4*i)for(let r=0,a=0;r<i;r++,a+=4){const s=r/(i-1),{start:l,end:c}=e.clips[t];o(n,a,l*(1-s)+c*s)}else for(let e=0,t=0;e<i;e++,t+=4)o(0,t,e/(i-1));return n}const yh=new Properties({visibility:new DataConstantProperty(xt.layout_hillshade.visibility)});var xh={paint:new Properties({"hillshade-illumination-direction":new DataConstantProperty(xt.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new DataConstantProperty(xt.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new DataConstantProperty(xt.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new DataConstantProperty(xt.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new DataConstantProperty(xt.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new DataConstantProperty(xt.paint_hillshade["hillshade-accent-color"]),"hillshade-emissive-strength":new DataConstantProperty(xt.paint_hillshade["hillshade-emissive-strength"])}),layout:yh};const vh=ha([{name:"a_pos",components:2,type:"Int16"}],4),{members:bh}=vh;var wh={exports:{}};function Th(e,t,i){i=i||2;var r,n,o,a,s,l,c,u=t&&t.length,h=u?t[0]*i:e.length,d=Eh(e,0,h,i,!0),p=[];if(!d||d.next===d.prev)return p;if(u&&(d=function(e,t,i,r){var n,o,a,s=[];for(n=0,o=t.length;n<o;n++)(a=Eh(e,t[n]*r,n<o-1?t[n+1]*r:e.length,r,!1))===a.next&&(a.steiner=!0),s.push(kh(a));for(s.sort(Ph),n=0;n<s.length;n++)i=Lh(s[n],i);return i}(e,t,d,i)),e.length>80*i){r=o=e[0],n=a=e[1];for(var f=i;f<h;f+=i)(s=e[f])<r&&(r=s),(l=e[f+1])<n&&(n=l),s>o&&(o=s),l>a&&(a=l);c=0!==(c=Math.max(o-r,a-n))?32767/c:0}return Sh(d,p,i,r,n,c,0),p}function Eh(e,t,i,r,n){var o,a;if(n===Wh(e,t,i,r)>0)for(o=t;o<i;o+=r)a=Zh(o,e[o],e[o+1],a);else for(o=i-r;o>=t;o-=r)a=Zh(o,e[o],e[o+1],a);return a&&Uh(a,a.next)&&($h(a),a=a.next),a}function Mh(e,t){if(!e)return e;t||(t=e);var i,r=e;do{if(i=!1,r.steiner||!Uh(r,r.next)&&0!==Fh(r.prev,r,r.next))r=r.next;else{if($h(r),(r=t=r.prev)===r.next)break;i=!0}}while(i||r!==t);return t}function Sh(e,t,i,r,n,o,a){if(e){!a&&o&&function(e,t,i,r){var n=e;do{0===n.z&&(n.z=Rh(n.x,n.y,t,i,r)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next}while(n!==e);n.prevZ.nextZ=null,n.prevZ=null,function(e){var t,i,r,n,o,a,s,l,c=1;do{for(i=e,e=null,o=null,a=0;i;){for(a++,r=i,s=0,t=0;t<c&&(s++,r=r.nextZ);t++);for(l=c;s>0||l>0&&r;)0!==s&&(0===l||!r||i.z<=r.z)?(n=i,i=i.nextZ,s--):(n=r,r=r.nextZ,l--),o?o.nextZ=n:e=n,n.prevZ=o,o=n;i=r}o.nextZ=null,c*=2}while(a>1)}(n)}(e,r,n,o);for(var s,l,c=e;e.prev!==e.next;)if(s=e.prev,l=e.next,o?Ch(e,r,n,o):Ah(e))t.push(s.i/i|0),t.push(e.i/i|0),t.push(l.i/i|0),$h(e),e=l.next,c=l.next;else if((e=l)===c){a?1===a?Sh(e=Ih(Mh(e),t,i),t,i,r,n,o,2):2===a&&Dh(e,t,i,r,n,o):Sh(Mh(e),t,i,r,n,o,1);break}}}function Ah(e){var t=e.prev,i=e,r=e.next;if(Fh(t,i,r)>=0)return!1;for(var n=t.x,o=i.x,a=r.x,s=t.y,l=i.y,c=r.y,u=n<o?n<a?n:a:o<a?o:a,h=s<l?s<c?s:c:l<c?l:c,d=n>o?n>a?n:a:o>a?o:a,p=s>l?s>c?s:c:l>c?l:c,f=r.next;f!==t;){if(f.x>=u&&f.x<=d&&f.y>=h&&f.y<=p&&Bh(n,s,o,l,a,c,f.x,f.y)&&Fh(f.prev,f,f.next)>=0)return!1;f=f.next}return!0}function Ch(e,t,i,r){var n=e.prev,o=e,a=e.next;if(Fh(n,o,a)>=0)return!1;for(var s=n.x,l=o.x,c=a.x,u=n.y,h=o.y,d=a.y,p=s<l?s<c?s:c:l<c?l:c,f=u<h?u<d?u:d:h<d?h:d,m=s>l?s>c?s:c:l>c?l:c,_=u>h?u>d?u:d:h>d?h:d,g=Rh(p,f,t,i,r),y=Rh(m,_,t,i,r),x=e.prevZ,v=e.nextZ;x&&x.z>=g&&v&&v.z<=y;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==a&&Bh(s,u,l,h,c,d,x.x,x.y)&&Fh(x.prev,x,x.next)>=0)return!1;if(x=x.prevZ,v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==a&&Bh(s,u,l,h,c,d,v.x,v.y)&&Fh(v.prev,v,v.next)>=0)return!1;v=v.nextZ}for(;x&&x.z>=g;){if(x.x>=p&&x.x<=m&&x.y>=f&&x.y<=_&&x!==n&&x!==a&&Bh(s,u,l,h,c,d,x.x,x.y)&&Fh(x.prev,x,x.next)>=0)return!1;x=x.prevZ}for(;v&&v.z<=y;){if(v.x>=p&&v.x<=m&&v.y>=f&&v.y<=_&&v!==n&&v!==a&&Bh(s,u,l,h,c,d,v.x,v.y)&&Fh(v.prev,v,v.next)>=0)return!1;v=v.nextZ}return!0}function Ih(e,t,i){var r=e;do{var n=r.prev,o=r.next.next;!Uh(n,o)&&Vh(n,r,r.next,o)&&Gh(n,o)&&Gh(o,n)&&(t.push(n.i/i|0),t.push(r.i/i|0),t.push(o.i/i|0),$h(r),$h(r.next),r=e=o),r=r.next}while(r!==e);return Mh(r)}function Dh(e,t,i,r,n,o){var a=e;do{for(var s=a.next.next;s!==a.prev;){if(a.i!==s.i&&Oh(a,s)){var l=qh(a,s);return a=Mh(a,a.next),l=Mh(l,l.next),Sh(a,t,i,r,n,o,0),void Sh(l,t,i,r,n,o,0)}s=s.next}a=a.next}while(a!==e)}function Ph(e,t){return e.x-t.x}function Lh(e,t){var i=function(e,t){var i,r=t,n=e.x,o=e.y,a=-1/0;do{if(o<=r.y&&o>=r.next.y&&r.next.y!==r.y){var s=r.x+(o-r.y)*(r.next.x-r.x)/(r.next.y-r.y);if(s<=n&&s>a&&(a=s,i=r.x<r.next.x?r:r.next,s===n))return i}r=r.next}while(r!==t);if(!i)return null;var l,c=i,u=i.x,h=i.y,d=1/0;r=i;do{n>=r.x&&r.x>=u&&n!==r.x&&Bh(o<h?n:a,o,u,h,o<h?a:n,o,r.x,r.y)&&(l=Math.abs(o-r.y)/(n-r.x),Gh(r,e)&&(l<d||l===d&&(r.x>i.x||r.x===i.x&&zh(i,r)))&&(i=r,d=l)),r=r.next}while(r!==c);return i}(e,t);if(!i)return t;var r=qh(i,e);return Mh(r,r.next),Mh(i,i.next)}function zh(e,t){return Fh(e.prev,e,t.prev)<0&&Fh(t.next,e,e.next)<0}function Rh(e,t,i,r,n){return(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=(e-i)*n|0)|e<<8))|e<<4))|e<<2))|e<<1))|(t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=(t-r)*n|0)|t<<8))|t<<4))|t<<2))|t<<1))<<1}function kh(e){var t=e,i=e;do{(t.x<i.x||t.x===i.x&&t.y<i.y)&&(i=t),t=t.next}while(t!==e);return i}function Bh(e,t,i,r,n,o,a,s){return(n-a)*(t-s)>=(e-a)*(o-s)&&(e-a)*(r-s)>=(i-a)*(t-s)&&(i-a)*(o-s)>=(n-a)*(r-s)}function Oh(e,t){return e.next.i!==t.i&&e.prev.i!==t.i&&!function(e,t){var i=e;do{if(i.i!==e.i&&i.next.i!==e.i&&i.i!==t.i&&i.next.i!==t.i&&Vh(i,i.next,e,t))return!0;i=i.next}while(i!==e);return!1}(e,t)&&(Gh(e,t)&&Gh(t,e)&&function(e,t){var i=e,r=!1,n=(e.x+t.x)/2,o=(e.y+t.y)/2;do{i.y>o!=i.next.y>o&&i.next.y!==i.y&&n<(i.next.x-i.x)*(o-i.y)/(i.next.y-i.y)+i.x&&(r=!r),i=i.next}while(i!==e);return r}(e,t)&&(Fh(e.prev,e,t.prev)||Fh(e,t.prev,t))||Uh(e,t)&&Fh(e.prev,e,e.next)>0&&Fh(t.prev,t,t.next)>0)}function Fh(e,t,i){return(t.y-e.y)*(i.x-t.x)-(t.x-e.x)*(i.y-t.y)}function Uh(e,t){return e.x===t.x&&e.y===t.y}function Vh(e,t,i,r){var n=jh(Fh(e,t,i)),o=jh(Fh(e,t,r)),a=jh(Fh(i,r,e)),s=jh(Fh(i,r,t));return n!==o&&a!==s||!(0!==n||!Nh(e,i,t))||!(0!==o||!Nh(e,r,t))||!(0!==a||!Nh(i,e,r))||!(0!==s||!Nh(i,t,r))}function Nh(e,t,i){return t.x<=Math.max(e.x,i.x)&&t.x>=Math.min(e.x,i.x)&&t.y<=Math.max(e.y,i.y)&&t.y>=Math.min(e.y,i.y)}function jh(e){return e>0?1:e<0?-1:0}function Gh(e,t){return Fh(e.prev,e,e.next)<0?Fh(e,t,e.next)>=0&&Fh(e,e.prev,t)>=0:Fh(e,t,e.prev)<0||Fh(e,e.next,t)<0}function qh(e,t){var i=new Hh(e.i,e.x,e.y),r=new Hh(t.i,t.x,t.y),n=e.next,o=t.prev;return e.next=t,t.prev=e,i.next=n,n.prev=i,r.next=i,i.prev=r,o.next=r,r.prev=o,r}function Zh(e,t,i,r){var n=new Hh(e,t,i);return r?(n.next=r.next,n.prev=r,r.next.prev=n,r.next=n):(n.prev=n,n.next=n),n}function $h(e){e.next.prev=e.prev,e.prev.next=e.next,e.prevZ&&(e.prevZ.nextZ=e.nextZ),e.nextZ&&(e.nextZ.prevZ=e.prevZ)}function Hh(e,t,i){this.i=e,this.x=t,this.y=i,this.prev=null,this.next=null,this.z=0,this.prevZ=null,this.nextZ=null,this.steiner=!1}function Wh(e,t,i,r){for(var n=0,o=t,a=i-r;o<i;o+=r)n+=(e[a]-e[o])*(e[o+1]+e[a+1]),a=o;return n}wh.exports=Th,wh.exports.default=Th,Th.deviation=function(e,t,i,r){var n=t&&t.length,o=Math.abs(Wh(e,0,n?t[0]*i:e.length,i));if(n)for(var a=0,s=t.length;a<s;a++)o-=Math.abs(Wh(e,t[a]*i,a<s-1?t[a+1]*i:e.length,i));var l=0;for(a=0;a<r.length;a+=3){var c=r[a]*i,u=r[a+1]*i,h=r[a+2]*i;l+=Math.abs((e[c]-e[h])*(e[u+1]-e[c+1])-(e[c]-e[u])*(e[h+1]-e[c+1]))}return 0===o&&0===l?0:Math.abs((l-o)/o)},Th.flatten=function(e){for(var t=e[0][0].length,i={vertices:[],holes:[],dimensions:t},r=0,n=0;n<e.length;n++){for(var o=0;o<e[n].length;o++)for(var a=0;a<t;a++)i.vertices.push(e[n][o][a]);n>0&&i.holes.push(r+=e[n-1].length)}return i};var Xh=h(wh.exports);function Yh(e,t){const i=e.length;if(i<=1)return[e];const r=[];let n,o;for(let t=0;t<i;t++){const i=W(e[t]);0!==i&&(e[t].area=Math.abs(i),void 0===o&&(o=i<0),o===i<0?(n&&r.push(n),n=[e[t]]):n.push(e[t]))}if(n&&r.push(n),t>1)for(let e=0;e<r.length;e++)r[e].length<=t||(ui(r[e],t,1,r[e].length-1,Kh),r[e]=r[e].slice(0,t));return r}function Kh(e,t){return t.area-e.area}function Jh(e,t,i){const r=i.patternDependencies;let n=!1;for(const i of t){const t=i.paint.get(`${e}-pattern`);t.isConstant()||(n=!0);const o=t.constantOr(null);o&&(n=!0,r[o]=!0)}return n}function Qh(e,t,i,r,n){const o=n.patternDependencies;for(const a of t){const t=a.paint.get(`${e}-pattern`).value;if("constant"!==t.kind){let e=t.evaluate({zoom:r},i,{},n.availableImages);e=e&&e.name?e.name:e,o[e]=!0,i.patterns[a.id]=e}}return i}class FillBucket{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.fqid)),this.index=e.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new StructArrayLayout2i4,this.indexArray=new StructArrayLayout3ui6,this.indexArray2=new StructArrayLayout2ui4,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.segments=new SegmentVector,this.segments2=new SegmentVector,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.projection=e.projection}populate(e,t,i,r){this.hasPattern=Jh("fill",this.layers,t);const n=this.layers[0].layout.get("fill-sort-key"),o=[];for(const{feature:a,id:s,index:l,sourceLayerIndex:c}of e){const e=this.layers[0]._featureFilter.needGeometry,u=ku(a,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),u,i))continue;const h=n?n.evaluate(u,{},i,t.availableImages):void 0,d={id:s,properties:a.properties,type:a.type,sourceLayerIndex:c,index:l,geometry:e?u.geometry:Ru(a,i,r),patterns:{},sortKey:h};o.push(d)}n&&o.sort(((e,t)=>e.sortKey-t.sortKey));for(const r of o){const{geometry:n,index:o,sourceLayerIndex:a}=r;if(this.hasPattern){const e=Qh("fill",this.layers,r,this.zoom,t);this.patternFeatures.push(e)}else this.addFeature(r,n,o,i,{},t.availableImages,t.brightness);t.featureIndex.insert(e[o].feature,n,o,a,this.index)}}update(e,t,i,r,n){const o=0!==Object.keys(e).length;o&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(e,t,o?this.stateDependentLayers:this.layers,i,r,n)}addFeatures(e,t,i,r,n,o){for(const e of this.patternFeatures)this.addFeature(e,e.geometry,e.index,t,i,r,o)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,bh),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.indexBuffer2=e.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy())}addFeature(e,t,i,r,n,o=[],a){for(const e of Yh(t,500)){let t=0;for(const i of e)t+=i.length;const i=this.segments.prepareSegment(t,this.layoutVertexArray,this.indexArray),r=i.vertexLength,n=[],o=[];for(const t of e){if(0===t.length)continue;t!==e[0]&&o.push(n.length/2);const i=this.segments2.prepareSegment(t.length,this.layoutVertexArray,this.indexArray2),r=i.vertexLength;this.layoutVertexArray.emplaceBack(t[0].x,t[0].y),this.indexArray2.emplaceBack(r+t.length-1,r),n.push(t[0].x),n.push(t[0].y);for(let e=1;e<t.length;e++)this.layoutVertexArray.emplaceBack(t[e].x,t[e].y),this.indexArray2.emplaceBack(r+e-1,r+e),n.push(t[e].x),n.push(t[e].y);i.vertexLength+=t.length,i.primitiveLength+=t.length}const a=Xh(n,o);for(let e=0;e<a.length;e+=3)this.indexArray.emplaceBack(r+a[e],r+a[e+1],r+a[e+2]);i.vertexLength+=t,i.primitiveLength+=a.length/3}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,n,o,r,a)}}Fo(FillBucket,"FillBucket",{omit:["layers","patternFeatures"]});const ed=new Properties({"fill-sort-key":new DataDrivenProperty(xt.layout_fill["fill-sort-key"]),visibility:new DataConstantProperty(xt.layout_fill.visibility)});var td={paint:new Properties({"fill-antialias":new DataConstantProperty(xt.paint_fill["fill-antialias"]),"fill-opacity":new DataDrivenProperty(xt.paint_fill["fill-opacity"]),"fill-color":new DataDrivenProperty(xt.paint_fill["fill-color"]),"fill-outline-color":new DataDrivenProperty(xt.paint_fill["fill-outline-color"]),"fill-translate":new DataConstantProperty(xt.paint_fill["fill-translate"]),"fill-translate-anchor":new DataConstantProperty(xt.paint_fill["fill-translate-anchor"]),"fill-pattern":new DataDrivenProperty(xt.paint_fill["fill-pattern"]),"fill-emissive-strength":new DataConstantProperty(xt.paint_fill["fill-emissive-strength"])}),layout:ed};const id=ha([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),rd=ha([{name:"a_pos_end",components:4,type:"Int16"},{name:"a_angular_offset_factor",components:1,type:"Int16"}]),nd=ha([{name:"a_centroid_pos",components:2,type:"Uint16"}]),od=ha([{name:"a_hidden_by_landmark",components:1,type:"Uint8"}]),ad=ha([{name:"a_pos_3",components:3,type:"Int16"},{name:"a_pos_normal_3",components:3,type:"Int16"}]),{members:sd}=id;var ld=m,cd=ud;function ud(e,t,i,r,n){this.properties={},this.extent=i,this.type=0,this._pbf=e,this._geometry=-1,this._keys=r,this._values=n,e.readFields(hd,this,t)}function hd(e,t,i){1==e?t.id=i.readVarint():2==e?function(e,t){for(var i=e.readVarint()+e.pos;e.pos<i;){var r=t._keys[e.readVarint()],n=t._values[e.readVarint()];t.properties[r]=n}}(i,t):3==e?t.type=i.readVarint():4==e&&(t._geometry=i.pos)}function dd(e){for(var t,i,r=0,n=0,o=e.length,a=o-1;n<o;a=n++)r+=((i=e[a]).x-(t=e[n]).x)*(t.y+i.y);return r}ud.types=["Unknown","Point","LineString","Polygon"],ud.prototype.loadGeometry=function(){var e=this._pbf;e.pos=this._geometry;for(var t,i=e.readVarint()+e.pos,r=1,n=0,o=0,a=0,s=[];e.pos<i;){if(n<=0){var l=e.readVarint();r=7&l,n=l>>3}if(n--,1===r||2===r)o+=e.readSVarint(),a+=e.readSVarint(),1===r&&(t&&s.push(t),t=[]),t.push(new ld(o,a));else{if(7!==r)throw new Error("unknown command "+r);t&&t.push(t[0].clone())}}return t&&s.push(t),s},ud.prototype.bbox=function(){var e=this._pbf;e.pos=this._geometry;for(var t=e.readVarint()+e.pos,i=1,r=0,n=0,o=0,a=1/0,s=-1/0,l=1/0,c=-1/0;e.pos<t;){if(r<=0){var u=e.readVarint();i=7&u,r=u>>3}if(r--,1===i||2===i)(n+=e.readSVarint())<a&&(a=n),n>s&&(s=n),(o+=e.readSVarint())<l&&(l=o),o>c&&(c=o);else if(7!==i)throw new Error("unknown command "+i)}return[a,l,s,c]},ud.prototype.toGeoJSON=function(e,t,i){var r,n,o=this.extent*Math.pow(2,i),a=this.extent*e,s=this.extent*t,l=this.loadGeometry(),c=ud.types[this.type];function u(e){for(var t=0;t<e.length;t++){var i=e[t];e[t]=[360*(i.x+a)/o-180,360/Math.PI*Math.atan(Math.exp((180-360*(i.y+s)/o)*Math.PI/180))-90]}}switch(this.type){case 1:var h=[];for(r=0;r<l.length;r++)h[r]=l[r][0];u(l=h);break;case 2:for(r=0;r<l.length;r++)u(l[r]);break;case 3:for(l=function(e){var t=e.length;if(t<=1)return[e];for(var i,r,n=[],o=0;o<t;o++){var a=dd(e[o]);0!==a&&(void 0===r&&(r=a<0),r===a<0?(i&&n.push(i),i=[e[o]]):i.push(e[o]))}return i&&n.push(i),n}(l),r=0;r<l.length;r++)for(n=0;n<l[r].length;n++)u(l[r][n])}1===l.length?l=l[0]:c="Multi"+c;var d={type:"Feature",geometry:{type:c,coordinates:l},properties:this.properties};return"id"in this&&(d.id=this.id),d};var pd=cd,fd=md;function md(e,t){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=e,this._keys=[],this._values=[],this._features=[],e.readFields(_d,this,t),this.length=this._features.length}function _d(e,t,i){15===e?t.version=i.readVarint():1===e?t.name=i.readString():5===e?t.extent=i.readVarint():2===e?t._features.push(i.pos):3===e?t._keys.push(i.readString()):4===e&&t._values.push(function(e){for(var t=null,i=e.readVarint()+e.pos;e.pos<i;){var r=e.readVarint()>>3;t=1===r?e.readString():2===r?e.readFloat():3===r?e.readDouble():4===r?e.readVarint64():5===r?e.readVarint():6===r?e.readSVarint():7===r?e.readBoolean():null}return t}(i))}md.prototype.feature=function(e){if(e<0||e>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[e];var t=this._pbf.readVarint()+this._pbf.pos;return new pd(this._pbf,t,this.extent,this._keys,this._values)};var gd=fd;function yd(e,t,i){if(3===e){var r=new gd(i,i.readVarint()+i.pos);r.length&&(t[r.name]=r)}}var xd=function(e,t){this.layers=e.readFields(yd,{},t)},vd=cd;function bd(e,t,i,r){const n=[],o=0===r?(e,t,i,r,n,o)=>{e.push(new g(o,i+(o-t)/(r-t)*(n-i)))}:(e,t,i,r,n,o)=>{e.push(new g(t+(o-i)/(n-i)*(r-t),o))};for(const a of e){const e=[];for(const n of a){if(n.length<=2)continue;const a=[];for(let e=0;e<n.length-1;e++){const s=n[e].x,l=n[e].y,c=n[e+1].x,u=n[e+1].y,h=0===r?s:l,d=0===r?c:u;h<t?d>t&&o(a,s,l,c,u,t):h>i?d<i&&o(a,s,l,c,u,i):a.push(n[e]),d<t&&h>=t&&o(a,s,l,c,u,t),d>i&&h<=i&&o(a,s,l,c,u,i)}let s=n[n.length-1];const l=0===r?s.x:s.y;l>=t&&l<=i&&a.push(s),a.length&&(s=a[a.length-1],a[0].x===s.x&&a[0].y===s.y||a.push(a[0]),e.push(a))}e.length&&n.push(e)}return n}class DictionaryCoder{constructor(e){this._stringToNumber={},this._numberToString=[];for(let t=0;t<e.length;t++){const i=e[t];this._stringToNumber[i]=t,this._numberToString[t]=i}}encode(e){return this._stringToNumber[e]}decode(e){return this._numberToString[e]}}var wd={
/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
read:function(e,t,i,r,n){var o,a,s=8*n-r-1,l=(1<<s)-1,c=l>>1,u=-7,h=i?n-1:0,d=i?-1:1,p=e[t+h];for(h+=d,o=p&(1<<-u)-1,p>>=-u,u+=s;u>0;o=256*o+e[t+h],h+=d,u-=8);for(a=o&(1<<-u)-1,o>>=-u,u+=r;u>0;a=256*a+e[t+h],h+=d,u-=8);if(0===o)o=1-c;else{if(o===l)return a?NaN:1/0*(p?-1:1);a+=Math.pow(2,r),o-=c}return(p?-1:1)*a*Math.pow(2,o-r)},write:function(e,t,i,r,n,o){var a,s,l,c=8*o-n-1,u=(1<<c)-1,h=u>>1,d=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,p=r?0:o-1,f=r?1:-1,m=t<0||0===t&&1/t<0?1:0;for(t=Math.abs(t),isNaN(t)||t===1/0?(s=isNaN(t)?1:0,a=u):(a=Math.floor(Math.log(t)/Math.LN2),t*(l=Math.pow(2,-a))<1&&(a--,l*=2),(t+=a+h>=1?d/l:d*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=u?(s=0,a=u):a+h>=1?(s=(t*l-1)*Math.pow(2,n),a+=h):(s=t*Math.pow(2,h-1)*Math.pow(2,n),a=0));n>=8;e[i+p]=255&s,p+=f,s/=256,n-=8);for(a=a<<n|s,c+=n;c>0;e[i+p]=255&a,p+=f,a/=256,c-=8);e[i+p-f]|=128*m}},Td=Md,Ed=wd;function Md(e){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(e)?e:new Uint8Array(e||0),this.pos=0,this.type=0,this.length=this.buf.length}Md.Varint=0,Md.Fixed64=1,Md.Bytes=2,Md.Fixed32=5;var Sd=4294967296,Ad=1/Sd,Cd="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function Id(e){return e.type===Md.Bytes?e.readVarint()+e.pos:e.pos+1}function Dd(e,t,i){return i?4294967296*t+(e>>>0):4294967296*(t>>>0)+(e>>>0)}function Pd(e,t,i){var r=t<=16383?1:t<=2097151?2:t<=268435455?3:Math.floor(Math.log(t)/(7*Math.LN2));i.realloc(r);for(var n=i.pos-1;n>=e;n--)i.buf[n+r]=i.buf[n]}function Ld(e,t){for(var i=0;i<e.length;i++)t.writeVarint(e[i])}function zd(e,t){for(var i=0;i<e.length;i++)t.writeSVarint(e[i])}function Rd(e,t){for(var i=0;i<e.length;i++)t.writeFloat(e[i])}function kd(e,t){for(var i=0;i<e.length;i++)t.writeDouble(e[i])}function Bd(e,t){for(var i=0;i<e.length;i++)t.writeBoolean(e[i])}function Od(e,t){for(var i=0;i<e.length;i++)t.writeFixed32(e[i])}function Fd(e,t){for(var i=0;i<e.length;i++)t.writeSFixed32(e[i])}function Ud(e,t){for(var i=0;i<e.length;i++)t.writeFixed64(e[i])}function Vd(e,t){for(var i=0;i<e.length;i++)t.writeSFixed64(e[i])}function Nd(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16)+16777216*e[t+3]}function jd(e,t,i){e[i]=t,e[i+1]=t>>>8,e[i+2]=t>>>16,e[i+3]=t>>>24}function Gd(e,t){return(e[t]|e[t+1]<<8|e[t+2]<<16)+(e[t+3]<<24)}Md.prototype={destroy:function(){this.buf=null},readFields:function(e,t,i){for(i=i||this.length;this.pos<i;){var r=this.readVarint(),n=r>>3,o=this.pos;this.type=7&r,e(n,t,this),this.pos===o&&this.skip(r)}return t},readMessage:function(e,t){return this.readFields(e,t,this.readVarint()+this.pos)},readFixed32:function(){var e=Nd(this.buf,this.pos);return this.pos+=4,e},readSFixed32:function(){var e=Gd(this.buf,this.pos);return this.pos+=4,e},readFixed64:function(){var e=Nd(this.buf,this.pos)+Nd(this.buf,this.pos+4)*Sd;return this.pos+=8,e},readSFixed64:function(){var e=Nd(this.buf,this.pos)+Gd(this.buf,this.pos+4)*Sd;return this.pos+=8,e},readFloat:function(){var e=Ed.read(this.buf,this.pos,!0,23,4);return this.pos+=4,e},readDouble:function(){var e=Ed.read(this.buf,this.pos,!0,52,8);return this.pos+=8,e},readVarint:function(e){var t,i,r=this.buf;return t=127&(i=r[this.pos++]),i<128?t:(t|=(127&(i=r[this.pos++]))<<7,i<128?t:(t|=(127&(i=r[this.pos++]))<<14,i<128?t:(t|=(127&(i=r[this.pos++]))<<21,i<128?t:function(e,t,i){var r,n,o=i.buf;if(r=(112&(n=o[i.pos++]))>>4,n<128)return Dd(e,r,t);if(r|=(127&(n=o[i.pos++]))<<3,n<128)return Dd(e,r,t);if(r|=(127&(n=o[i.pos++]))<<10,n<128)return Dd(e,r,t);if(r|=(127&(n=o[i.pos++]))<<17,n<128)return Dd(e,r,t);if(r|=(127&(n=o[i.pos++]))<<24,n<128)return Dd(e,r,t);if(r|=(1&(n=o[i.pos++]))<<31,n<128)return Dd(e,r,t);throw new Error("Expected varint not more than 10 bytes")}(t|=(15&(i=r[this.pos]))<<28,e,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var e=this.readVarint();return e%2==1?(e+1)/-2:e/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var e=this.readVarint()+this.pos,t=this.pos;return this.pos=e,e-t>=12&&Cd?function(e,t,i){return Cd.decode(e.subarray(t,i))}(this.buf,t,e):function(e,t,i){for(var r="",n=t;n<i;){var o,a,s,l=e[n],c=null,u=l>239?4:l>223?3:l>191?2:1;if(n+u>i)break;1===u?l<128&&(c=l):2===u?128==(192&(o=e[n+1]))&&(c=(31&l)<<6|63&o)<=127&&(c=null):3===u?(a=e[n+2],128==(192&(o=e[n+1]))&&128==(192&a)&&((c=(15&l)<<12|(63&o)<<6|63&a)<=2047||c>=55296&&c<=57343)&&(c=null)):4===u&&(a=e[n+2],s=e[n+3],128==(192&(o=e[n+1]))&&128==(192&a)&&128==(192&s)&&((c=(15&l)<<18|(63&o)<<12|(63&a)<<6|63&s)<=65535||c>=1114112)&&(c=null)),null===c?(c=65533,u=1):c>65535&&(c-=65536,r+=String.fromCharCode(c>>>10&1023|55296),c=56320|1023&c),r+=String.fromCharCode(c),n+=u}return r}(this.buf,t,e)},readBytes:function(){var e=this.readVarint()+this.pos,t=this.buf.subarray(this.pos,e);return this.pos=e,t},readPackedVarint:function(e,t){if(this.type!==Md.Bytes)return e.push(this.readVarint(t));var i=Id(this);for(e=e||[];this.pos<i;)e.push(this.readVarint(t));return e},readPackedSVarint:function(e){if(this.type!==Md.Bytes)return e.push(this.readSVarint());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readSVarint());return e},readPackedBoolean:function(e){if(this.type!==Md.Bytes)return e.push(this.readBoolean());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readBoolean());return e},readPackedFloat:function(e){if(this.type!==Md.Bytes)return e.push(this.readFloat());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readFloat());return e},readPackedDouble:function(e){if(this.type!==Md.Bytes)return e.push(this.readDouble());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readDouble());return e},readPackedFixed32:function(e){if(this.type!==Md.Bytes)return e.push(this.readFixed32());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readFixed32());return e},readPackedSFixed32:function(e){if(this.type!==Md.Bytes)return e.push(this.readSFixed32());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readSFixed32());return e},readPackedFixed64:function(e){if(this.type!==Md.Bytes)return e.push(this.readFixed64());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readFixed64());return e},readPackedSFixed64:function(e){if(this.type!==Md.Bytes)return e.push(this.readSFixed64());var t=Id(this);for(e=e||[];this.pos<t;)e.push(this.readSFixed64());return e},skip:function(e){var t=7&e;if(t===Md.Varint)for(;this.buf[this.pos++]>127;);else if(t===Md.Bytes)this.pos=this.readVarint()+this.pos;else if(t===Md.Fixed32)this.pos+=4;else{if(t!==Md.Fixed64)throw new Error("Unimplemented type: "+t);this.pos+=8}},writeTag:function(e,t){this.writeVarint(e<<3|t)},realloc:function(e){for(var t=this.length||16;t<this.pos+e;)t*=2;if(t!==this.length){var i=new Uint8Array(t);i.set(this.buf),this.buf=i,this.length=t}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(e){this.realloc(4),jd(this.buf,e,this.pos),this.pos+=4},writeSFixed32:function(e){this.realloc(4),jd(this.buf,e,this.pos),this.pos+=4},writeFixed64:function(e){this.realloc(8),jd(this.buf,-1&e,this.pos),jd(this.buf,Math.floor(e*Ad),this.pos+4),this.pos+=8},writeSFixed64:function(e){this.realloc(8),jd(this.buf,-1&e,this.pos),jd(this.buf,Math.floor(e*Ad),this.pos+4),this.pos+=8},writeVarint:function(e){(e=+e||0)>268435455||e<0?function(e,t){var i,r;if(e>=0?(i=e%4294967296|0,r=e/4294967296|0):(r=~(-e/4294967296),4294967295^(i=~(-e%4294967296))?i=i+1|0:(i=0,r=r+1|0)),e>=0x10000000000000000||e<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");t.realloc(10),function(e,t,i){i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,e>>>=7,i.buf[i.pos++]=127&e|128,i.buf[i.pos]=127&(e>>>=7)}(i,0,t),function(e,t){var i=(7&e)<<4;t.buf[t.pos++]|=i|((e>>>=3)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e|((e>>>=7)?128:0),e&&(t.buf[t.pos++]=127&e)))))}(r,t)}(e,this):(this.realloc(4),this.buf[this.pos++]=127&e|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=127&(e>>>=7)|(e>127?128:0),e<=127||(this.buf[this.pos++]=e>>>7&127))))},writeSVarint:function(e){this.writeVarint(e<0?2*-e-1:2*e)},writeBoolean:function(e){this.writeVarint(Boolean(e))},writeString:function(e){e=String(e),this.realloc(4*e.length),this.pos++;var t=this.pos;this.pos=function(e,t,i){for(var r,n,o=0;o<t.length;o++){if((r=t.charCodeAt(o))>55295&&r<57344){if(!n){r>56319||o+1===t.length?(e[i++]=239,e[i++]=191,e[i++]=189):n=r;continue}if(r<56320){e[i++]=239,e[i++]=191,e[i++]=189,n=r;continue}r=n-55296<<10|r-56320|65536,n=null}else n&&(e[i++]=239,e[i++]=191,e[i++]=189,n=null);r<128?e[i++]=r:(r<2048?e[i++]=r>>6|192:(r<65536?e[i++]=r>>12|224:(e[i++]=r>>18|240,e[i++]=r>>12&63|128),e[i++]=r>>6&63|128),e[i++]=63&r|128)}return i}(this.buf,e,this.pos);var i=this.pos-t;i>=128&&Pd(t,i,this),this.pos=t-1,this.writeVarint(i),this.pos+=i},writeFloat:function(e){this.realloc(4),Ed.write(this.buf,e,this.pos,!0,23,4),this.pos+=4},writeDouble:function(e){this.realloc(8),Ed.write(this.buf,e,this.pos,!0,52,8),this.pos+=8},writeBytes:function(e){var t=e.length;this.writeVarint(t),this.realloc(t);for(var i=0;i<t;i++)this.buf[this.pos++]=e[i]},writeRawMessage:function(e,t){this.pos++;var i=this.pos;e(t,this);var r=this.pos-i;r>=128&&Pd(i,r,this),this.pos=i-1,this.writeVarint(r),this.pos+=r},writeMessage:function(e,t,i){this.writeTag(e,Md.Bytes),this.writeRawMessage(t,i)},writePackedVarint:function(e,t){t.length&&this.writeMessage(e,Ld,t)},writePackedSVarint:function(e,t){t.length&&this.writeMessage(e,zd,t)},writePackedBoolean:function(e,t){t.length&&this.writeMessage(e,Bd,t)},writePackedFloat:function(e,t){t.length&&this.writeMessage(e,Rd,t)},writePackedDouble:function(e,t){t.length&&this.writeMessage(e,kd,t)},writePackedFixed32:function(e,t){t.length&&this.writeMessage(e,Od,t)},writePackedSFixed32:function(e,t){t.length&&this.writeMessage(e,Fd,t)},writePackedFixed64:function(e,t){t.length&&this.writeMessage(e,Ud,t)},writePackedSFixed64:function(e,t){t.length&&this.writeMessage(e,Vd,t)},writeBytesField:function(e,t){this.writeTag(e,Md.Bytes),this.writeBytes(t)},writeFixed32Field:function(e,t){this.writeTag(e,Md.Fixed32),this.writeFixed32(t)},writeSFixed32Field:function(e,t){this.writeTag(e,Md.Fixed32),this.writeSFixed32(t)},writeFixed64Field:function(e,t){this.writeTag(e,Md.Fixed64),this.writeFixed64(t)},writeSFixed64Field:function(e,t){this.writeTag(e,Md.Fixed64),this.writeSFixed64(t)},writeVarintField:function(e,t){this.writeTag(e,Md.Varint),this.writeVarint(t)},writeSVarintField:function(e,t){this.writeTag(e,Md.Varint),this.writeSVarint(t)},writeStringField:function(e,t){this.writeTag(e,Md.Bytes),this.writeString(t)},writeFloatField:function(e,t){this.writeTag(e,Md.Fixed32),this.writeFloat(t)},writeDoubleField:function(e,t){this.writeTag(e,Md.Fixed64),this.writeDouble(t)},writeBooleanField:function(e,t){this.writeVarintField(e,Boolean(t))}};var qd=h(Td);const Zd=["tile","layer","source","sourceLayer","state"];class Feature{constructor(e,t,i,r,n){this.type="Feature",this._vectorTileFeature=e,this._z=t,this._x=i,this._y=r,this.properties=e.properties,this.id=n}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._x,this._y,this._z).geometry),this._geometry}set geometry(e){this._geometry=e}toJSON(){const e={type:"Feature",state:void 0,geometry:this.geometry,properties:this.properties};void 0!==this.id&&(e.id=this.id);for(const t of Zd)void 0!==this[t]&&(e[t]=this[t]);return e}}class SourceFeatureState{constructor(){this.state={},this.stateChanges={},this.deletedStates={}}updateState(e,t,i){const r=String(t);if(this.stateChanges[e]=this.stateChanges[e]||{},this.stateChanges[e][r]=this.stateChanges[e][r]||{},z(this.stateChanges[e][r],i),null===this.deletedStates[e]){this.deletedStates[e]={};for(const t in this.state[e])t!==r&&(this.deletedStates[e][t]=null)}else if(this.deletedStates[e]&&null===this.deletedStates[e][r]){this.deletedStates[e][r]={};for(const t in this.state[e][r])i[t]||(this.deletedStates[e][r][t]=null)}else for(const t in i)this.deletedStates[e]&&this.deletedStates[e][r]&&null===this.deletedStates[e][r][t]&&delete this.deletedStates[e][r][t]}removeFeatureState(e,t,i){if(null===this.deletedStates[e])return;const r=String(t);if(this.deletedStates[e]=this.deletedStates[e]||{},i&&void 0!==t)null!==this.deletedStates[e][r]&&(this.deletedStates[e][r]=this.deletedStates[e][r]||{},this.deletedStates[e][r][i]=null);else if(void 0!==t)if(this.stateChanges[e]&&this.stateChanges[e][r])for(i in this.deletedStates[e][r]={},this.stateChanges[e][r])this.deletedStates[e][r][i]=null;else this.deletedStates[e][r]=null;else this.deletedStates[e]=null}getState(e,t){const i=String(t),r=z({},(this.state[e]||{})[i],(this.stateChanges[e]||{})[i]);if(null===this.deletedStates[e])return{};if(this.deletedStates[e]){const i=this.deletedStates[e][t];if(null===i)return{};for(const e in i)delete r[e]}return r}initializeTileState(e,t){e.setFeatureState(this.state,t)}coalesceChanges(e,t){const i={};for(const e in this.stateChanges){this.state[e]=this.state[e]||{};const t={};for(const i in this.stateChanges[e])this.state[e][i]||(this.state[e][i]={}),z(this.state[e][i],this.stateChanges[e][i]),t[i]=this.state[e][i];i[e]=t}for(const e in this.deletedStates){this.state[e]=this.state[e]||{};const t={};if(null===this.deletedStates[e])for(const i in this.state[e])t[i]={},this.state[e][i]={};else for(const i in this.deletedStates[e]){if(null===this.deletedStates[e][i])this.state[e][i]={};else if(this.state[e][i])for(const t of Object.keys(this.deletedStates[e][i]))delete this.state[e][i][t];t[i]=this.state[e][i]}i[e]=i[e]||{},z(i[e],t)}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(i).length)for(const r in e)e[r].setFeatureState(i,t)}}class MipLevel{constructor(e){this.size=e,this.minimums=[],this.maximums=[],this.leaves=[]}getElevation(e,t){const i=this.toIdx(e,t);return{min:this.minimums[i],max:this.maximums[i]}}isLeaf(e,t){return this.leaves[this.toIdx(e,t)]}toIdx(e,t){return t*this.size+e}}function $d(e,t,i,r){let n=0,o=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(r[a])<1e-15){if(i[a]<e[a]||i[a]>t[a])return null}else{const s=1/r[a];let l=(e[a]-i[a])*s,c=(t[a]-i[a])*s;if(l>c){const e=l;l=c,c=e}if(l>n&&(n=l),c<o&&(o=c),n>o)return null}return n}function Hd(e,t,i,r,n,o,a,s,l,c,u){const h=r-e,d=n-t,p=o-i,f=a-e,m=s-t,_=l-i,g=u[1]*_-u[2]*m,y=u[2]*f-u[0]*_,x=u[0]*m-u[1]*f,v=h*g+d*y+p*x;if(Math.abs(v)<1e-15)return null;const b=1/v,w=c[0]-e,T=c[1]-t,E=c[2]-i,M=(w*g+T*y+E*x)*b;if(M<0||M>1)return null;const S=T*p-E*d,A=E*h-w*p,C=w*d-T*h,I=(u[0]*S+u[1]*A+u[2]*C)*b;return I<0||M+I>1?null:(f*S+m*A+_*C)*b}function Wd(e,t,i){return(e-t)/(i-t)}function Xd(e,t,i,r,n,o,a,s,l){const c=1<<i,u=o-r,h=a-n,d=(e+1)/c*u+r,p=(t+0)/c*h+n,f=(t+1)/c*h+n;s[0]=(e+0)/c*u+r,s[1]=p,l[0]=d,l[1]=f}class DemMinMaxQuadTree{constructor(e){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=e,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const t=function(e){const t=Math.ceil(Math.log2(e.dim/8)),i=[];let r=Math.ceil(Math.pow(2,t));const n=1/r,o=(e,t,i,r,n)=>{const o=r?1:0,a=(e+1)*i-o,s=t*i,l=(t+1)*i-o;n[0]=e*i,n[1]=s,n[2]=a,n[3]=l};let a=new MipLevel(r);const s=[];for(let t=0;t<r*r;t++){o(t%r,Math.floor(t/r),n,!1,s);const i=Kd(s[0],s[1],e),l=Kd(s[2],s[1],e),c=Kd(s[2],s[3],e),u=Kd(s[0],s[3],e);a.minimums.push(Math.min(i,l,c,u)),a.maximums.push(Math.max(i,l,c,u)),a.leaves.push(1)}for(i.push(a),r/=2;r>=1;r/=2){const e=i[i.length-1];a=new MipLevel(r);for(let t=0;t<r*r;t++){o(t%r,Math.floor(t/r),2,!0,s);const i=e.getElevation(s[0],s[1]),n=e.getElevation(s[2],s[1]),l=e.getElevation(s[2],s[3]),c=e.getElevation(s[0],s[3]),u=e.isLeaf(s[0],s[1]),h=e.isLeaf(s[2],s[1]),d=e.isLeaf(s[2],s[3]),p=e.isLeaf(s[0],s[3]),f=Math.min(i.min,n.min,l.min,c.min),m=Math.max(i.max,n.max,l.max,c.max),_=u&&h&&d&&p;a.maximums.push(m),a.minimums.push(f),a.leaves.push(m-f<=5&&_?1:0)}i.push(a)}return i}(this.dem),i=t.length-1,r=t[i];this._addNode(r.minimums[0],r.maximums[0],r.leaves[0]),this._construct(t,0,0,i,0)}raycastRoot(e,t,i,r,n,o,a=1){return $d([e,t,-100],[i,r,this.maximums[0]*a],n,o)}raycast(e,t,i,r,n,o,a=1){if(!this.nodeCount)return null;const s=this.raycastRoot(e,t,i,r,n,o,a);if(null==s)return null;const l=[],c=[],u=[],h=[],d=[{idx:0,t:s,nodex:0,nodey:0,depth:0}];for(;d.length>0;){const{idx:s,t:p,nodex:f,nodey:m,depth:_}=d.pop();if(this.leaves[s]){Xd(f,m,_,e,t,i,r,u,h);const s=1<<_,l=(f+0)/s,c=(f+1)/s,d=(m+0)/s,g=(m+1)/s,y=Kd(l,d,this.dem)*a,x=Kd(c,d,this.dem)*a,v=Kd(c,g,this.dem)*a,b=Kd(l,g,this.dem)*a,w=Hd(u[0],u[1],y,h[0],u[1],x,h[0],h[1],v,n,o),T=Hd(h[0],h[1],v,u[0],h[1],b,u[0],u[1],y,n,o),E=Math.min(null!==w?w:Number.MAX_VALUE,null!==T?T:Number.MAX_VALUE);if(E!==Number.MAX_VALUE)return E;{const e=lc.scaleAndAdd([],n,o,p);if(Yd(y,x,b,v,Wd(e[0],u[0],h[0]),Wd(e[1],u[1],h[1]))>=e[2])return p}continue}let g=0;for(let d=0;d<this._siblingOffset.length;d++){Xd((f<<1)+this._siblingOffset[d][0],(m<<1)+this._siblingOffset[d][1],_+1,e,t,i,r,u,h),u[2]=-100,h[2]=this.maximums[this.childOffsets[s]+d]*a;const p=$d(u,h,n,o);if(null!=p){const e=p;l[d]=e;let t=!1;for(let i=0;i<g&&!t;i++)e>=l[c[i]]&&(c.splice(i,0,d),t=!0);t||(c[g]=d),g++}}for(let e=0;e<g;e++){const t=c[e];d.push({idx:this.childOffsets[s]+t,t:l[t],nodex:(f<<1)+this._siblingOffset[t][0],nodey:(m<<1)+this._siblingOffset[t][1],depth:_+1})}}return null}_addNode(e,t,i){return this.minimums.push(e),this.maximums.push(t),this.leaves.push(i),this.childOffsets.push(0),this.nodeCount++}_construct(e,t,i,r,n){if(1===e[r].isLeaf(t,i))return;this.childOffsets[n]||(this.childOffsets[n]=this.nodeCount);const o=r-1,a=e[o];let s=0,l=0;for(let e=0;e<this._siblingOffset.length;e++){const r=2*t+this._siblingOffset[e][0],n=2*i+this._siblingOffset[e][1],o=a.getElevation(r,n),c=a.isLeaf(r,n),u=this._addNode(o.min,o.max,c);c&&(s|=1<<e),l||(l=u)}for(let r=0;r<this._siblingOffset.length;r++)s&1<<r||this._construct(e,2*t+this._siblingOffset[r][0],2*i+this._siblingOffset[r][1],o,l+r)}}function Yd(e,t,i,r,n,o){return yr(yr(e,i,o),yr(t,r,o),n)}function Kd(e,t,i){const r=i.dim,n=I(e*r-.5,0,r-1),o=I(t*r-.5,0,r-1),a=Math.floor(n),s=Math.floor(o),l=Math.min(a+1,r-1),c=Math.min(s+1,r-1);return Yd(i.get(a,s),i.get(l,s),i.get(a,c),i.get(l,c),n-a,o-s)}const Jd={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768],float:[1,1,1,1]};function Qd(e,t,i){return(256*e*256+256*t+i)/10-1e4}function ep(e,t,i){return 256*e+t+i/256-32768}class DEMData{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(e,t,i,r,n=!1){if(this.uid=e,t.height!==t.width)throw new RangeError("DEM tiles must be square");if(i&&"mapbox"!==i&&"terrarium"!==i)return $(`"${i}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=t.height;const o=this.dim=t.height-2,a=new Uint32Array(t.data.buffer);if(this.pixels=new Uint8Array(t.data.buffer),this.encoding=i||"mapbox",this.borderReady=n,this._modifiedForSources={},!n){for(let e=0;e<o;e++)a[this._idx(-1,e)]=a[this._idx(0,e)],a[this._idx(o,e)]=a[this._idx(o-1,e)],a[this._idx(e,-1)]=a[this._idx(e,0)],a[this._idx(e,o)]=a[this._idx(e,o-1)];a[this._idx(-1,-1)]=a[this._idx(0,0)],a[this._idx(o,-1)]=a[this._idx(o-1,0)],a[this._idx(-1,o)]=a[this._idx(0,o-1)],a[this._idx(o,o)]=a[this._idx(o-1,o-1)]}if(r){const e=new Float32Array(t.data.buffer),i="terrarium"===this.encoding?ep:Qd;for(let t=0;t<a.length;++t){const r=4*t;e[t]=i(this.pixels[r],this.pixels[r+1],this.pixels[r+2])}this.encoding="float"}this._timestamp=rt.now()}_buildQuadTree(){this._tree=new DemMinMaxQuadTree(this)}get(e,t,i=!1){i&&(e=I(e,-1,this.dim),t=I(t,-1,this.dim));const r=this._idx(e,t);if("float"===this.encoding)return this.floatView||(this.floatView=new Float32Array(this.pixels.buffer)),this.floatView[r];const n=4*r;return("terrarium"===this.encoding?ep:Qd)(this.pixels[n],this.pixels[n+1],this.pixels[n+2])}set(e,t,i){const r=this._idx(e,t);if("float"===this.encoding){this.floatView||(this.floatView=new Float32Array(this.pixels.buffer));const e=this.floatView[r];return this.floatView[r]=i,i-e}const n=4*r,o=("terrarium"===this.encoding?ep:Qd)(this.pixels[n],this.pixels[n+1],this.pixels[n+2]),a=DEMData.pack(i,"terrarium"===this.encoding?"terrarium":"mapbox");return this.pixels[n]=a[0],this.pixels[n+1]=a[1],this.pixels[n+2]=a[2],i-o}static getUnpackVector(e){return Jd[e]}get unpackVector(){return Jd[this.encoding]}_idx(e,t){if(e<-1||e>=this.dim+1||t<-1||t>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return(t+1)*this.stride+(e+1)}static pack(e,t){const i=[0,0,0,0],r=DEMData.getUnpackVector(t);let n=Math.floor((e+r[3])/r[2]);return i[2]=n%256,n=Math.floor(n/256),i[1]=n%256,n=Math.floor(n/256),i[0]=n,i}getPixels(){return"float"===this.encoding?new Float32Image({width:this.stride,height:this.stride},this.pixels):new RGBAImage({width:this.stride,height:this.stride},this.pixels)}backfillBorder(e,t,i){if(this.dim!==e.dim)throw new Error("dem dimension mismatch");let r=t*this.dim,n=t*this.dim+this.dim,o=i*this.dim,a=i*this.dim+this.dim;switch(t){case-1:r=n-1;break;case 1:n=r+1}switch(i){case-1:o=a-1;break;case 1:a=o+1}const s=-t*this.dim,l=-i*this.dim;for(let t=o;t<a;t++)for(let i=r;i<n;i++){const r=4*this._idx(i,t),n=4*this._idx(i+s,t+l);this.pixels[r+0]=e.pixels[n+0],this.pixels[r+1]=e.pixels[n+1],this.pixels[r+2]=e.pixels[n+2],this.pixels[r+3]=e.pixels[n+3]}}onDeserialize(){this._tree&&(this._tree.dem=this)}}Fo(DEMData,"DEMData"),Fo(DemMinMaxQuadTree,"DemMinMaxQuadTree",{omit:["dem"]});class Elevation{isDataAvailableAtPoint(e){const t=this._source();if(this.isUsingMockSource()||!t||e.y<0||e.y>1)return!1;const i=t.getSource().maxzoom,r=1<<i,n=Math.floor(e.x),o=Math.floor((e.x-n)*r),a=Math.floor(e.y*r),s=this.findDEMTileFor(new OverscaledTileID(i,n,i,o,a));return!(!s||!s.dem)}getAtPointOrZero(e,t=0){return this.getAtPoint(e,t)||0}getAtPoint(e,t,i=!0){if(this.isUsingMockSource())return null;null==t&&(t=null);const r=this._source();if(!r)return t;if(e.y<0||e.y>1)return t;const n=r.getSource().maxzoom,o=1<<n,a=Math.floor(e.x),s=e.x-a,l=new OverscaledTileID(n,a,n,Math.floor(s*o),Math.floor(e.y*o)),c=this.findDEMTileFor(l);if(!c||!c.dem)return t;const u=c.dem,h=1<<c.tileID.canonical.z,d=(s*h-c.tileID.canonical.x)*u.dim,p=(e.y*h-c.tileID.canonical.y)*u.dim,f=Math.floor(d),m=Math.floor(p);return(i?this.exaggeration():1)*yr(yr(u.get(f,m),u.get(f,m+1),p-m),yr(u.get(f+1,m),u.get(f+1,m+1),p-m),d-f)}getAtTileOffset(e,t,i){const r=1<<e.canonical.z;return this.getAtPointOrZero(new MercatorCoordinate(e.wrap+(e.canonical.x+t/Ri)/r,(e.canonical.y+i/Ri)/r))}getAtTileOffsetFunc(e,t,i,r){return n=>{const o=this.getAtTileOffset(e,n.x,n.y),a=r.upVector(e.canonical,n.x,n.y),s=r.upVectorScale(e.canonical,t,i).metersToTile;return lc.scale(a,a,o*s),a}}getForTilePoints(e,t,i,r){if(this.isUsingMockSource())return!1;const n=DEMSampler.create(this,e,r);return!!n&&(t.forEach((e=>{e[2]=this.exaggeration()*n.getElevationAt(e[0],e[1],i)})),!0)}getMinMaxForTile(e){if(this.isUsingMockSource())return null;const t=this.findDEMTileFor(e);if(!t||!t.dem)return null;const i=t.dem.tree,r=t.tileID,n=1<<e.canonical.z-r.canonical.z;let o=e.canonical.x/n-r.canonical.x,a=e.canonical.y/n-r.canonical.y,s=0;for(let t=0;t<e.canonical.z-r.canonical.z&&!i.leaves[s];t++){o*=2,a*=2;const e=2*Math.floor(a)+Math.floor(o);s=i.childOffsets[s]+e,o%=1,a%=1}return{min:this.exaggeration()*i.minimums[s],max:this.exaggeration()*i.maximums[s]}}getMinElevationBelowMSL(){throw new Error("Pure virtual method called.")}raycast(e,t,i){throw new Error("Pure virtual method called.")}pointCoordinate(e){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}isUsingMockSource(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(e){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}}class DEMSampler{constructor(e,t,i){this._demTile=e,this._dem=this._demTile.dem,this._scale=t,this._offset=i}static create(e,t,i){const r=i||e.findDEMTileFor(t);if(!r||!r.dem)return;const n=r.dem,o=r.tileID,a=1<<t.canonical.z-o.canonical.z;return new DEMSampler(r,n.dim/Ri/a,[(t.canonical.x/a-o.canonical.x)*n.dim,(t.canonical.y/a-o.canonical.y)*n.dim])}tileCoordToPixel(e,t){const i=t*this._scale+this._offset[1],r=Math.floor(e*this._scale+this._offset[0]),n=Math.floor(i);return new g(r,n)}getElevationAt(e,t,i,r){const n=e*this._scale+this._offset[0],o=t*this._scale+this._offset[1],a=Math.floor(n),s=Math.floor(o),l=this._dem;return r=!!r,i?yr(yr(l.get(a,s,r),l.get(a,s+1,r),o-s),yr(l.get(a+1,s,r),l.get(a+1,s+1,r),o-s),n-a):l.get(a,s,r)}getElevationAtPixel(e,t,i){return this._dem.get(e,t,!!i)}getMeterToDEM(e){return(1<<this._demTile.tileID.canonical.z)*yu(1,e)*this._dem.stride}}function tp(e,t,i,r,n){return j(e,((e,o)=>{const a=t instanceof PossiblyEvaluated?t.get(o):null;return a&&a.evaluate?a.evaluate(i,r,n):a}))}function ip(e,t){return t-e}Fo(class FeatureIndex{constructor(e,t){this.tileID=e,this.x=e.canonical.x,this.y=e.canonical.y,this.z=e.canonical.z,this.grid=new Bo(Ri,16,0),this.featureIndexArray=new FeatureIndexArray,this.promoteId=t}insert(e,t,i,r,n,o=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(i,r,n,o);const s=this.grid;for(let e=0;e<t.length;e++){const i=t[e],r=[1/0,1/0,-1/0,-1/0];for(let e=0;e<i.length;e++){const t=i[e];r[0]=Math.min(r[0],t.x),r[1]=Math.min(r[1],t.y),r[2]=Math.max(r[2],t.x),r[3]=Math.max(r[3],t.y)}r[0]<Ri&&r[1]<Ri&&r[2]>=0&&r[3]>=0&&s.insert(a,r[0],r[1],r[2],r[3])}}loadVTLayers(){if(!this.vtLayers){this.vtLayers=new xd(new qd(this.rawTileData)).layers,this.sourceLayerCoder=new DictionaryCoder(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"]),this.vtFeatures={};for(const e in this.vtLayers)this.vtFeatures[e]=[]}return this.vtLayers}query(e,t,i,r){this.loadVTLayers();const n=e.params||{},o=jn(n.filter),a=e.tileResult,s=e.transform,l=a.bufferedTilespaceBounds,c=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,((e,t,i,r)=>Wu(a.bufferedTilespaceGeometry,e,t,i,r)));c.sort(ip);let u=null;s.elevation&&c.length>0&&(u=DEMSampler.create(s.elevation,this.tileID));const h={};let d;for(let s=0;s<c.length;s++){const l=c[s];if(l===d)continue;d=l;const p=this.featureIndexArray.get(l);let f=null;this.loadMatchingFeature(h,p,o,n.layers,n.availableImages,t,i,r,((t,i,r,n=0)=>(f||(f=Ru(t,this.tileID.canonical,e.tileTransform)),i.queryIntersectsFeature(a,t,r,f,this.z,e.transform,e.pixelPosMatrix,u,n))))}return h}loadMatchingFeature(e,t,i,r,n,o,a,s,l){const{featureIndex:c,bucketIndex:u,sourceLayerIndex:h,layoutVertexArrayOffset:d}=t,p=this.bucketLayerIDs[u];if(r&&!function(e,t){for(let i=0;i<e.length;i++)if(t.indexOf(e[i])>=0)return!0;return!1}(r,p))return;const f=this.sourceLayerCoder.decode(h),m=this.vtLayers[f].feature(c);if(i.needGeometry){const e=ku(m,!0);if(!i.filter(new EvaluationParameters(this.tileID.overscaledZ),e,this.tileID.canonical))return}else if(!i.filter(new EvaluationParameters(this.tileID.overscaledZ),m))return;const _=this.getId(m,f);for(let t=0;t<p.length;t++){const i=p[t];if(r&&r.indexOf(i)<0)continue;const u=o[i];if(!u)continue;let h={};void 0!==_&&s&&(h=s.getState(u.sourceLayer||"_geojsonTileLayer",_));const f=z({},a[i]);f.paint=tp(f.paint,u.paint,m,h,n),f.layout=tp(f.layout,u.layout,m,h,n);const g=!l||l(m,u,h,d);if(!g)continue;const y=new Feature(m,this.z,this.x,this.y,_);y.layer=f;let x=e[i];void 0===x&&(x=e[i]=[]),x.push({featureIndex:c,feature:y,intersectionZ:g})}}lookupSymbolFeatures(e,t,i,r,n,o,a,s){const l={};this.loadVTLayers();const c=jn(n);for(const n of e)this.loadMatchingFeature(l,{bucketIndex:i,sourceLayerIndex:r,featureIndex:n,layoutVertexArrayOffset:0},c,o,a,s,t);return l}loadFeature(e){const{featureIndex:t,sourceLayerIndex:i}=e;this.loadVTLayers();const r=this.sourceLayerCoder.decode(i),n=this.vtFeatures[r];if(n[t])return n[t];const o=this.vtLayers[r].feature(t);return n[t]=o,o}hasLayer(e){for(const t of this.bucketLayerIDs)for(const i of t)if(e===i)return!0;return!1}getId(e,t){let i=e.id;if(this.promoteId){const r="string"==typeof this.promoteId?this.promoteId:this.promoteId[t];null!=r&&(i=e.properties[r]),"boolean"==typeof i&&(i=Number(i))}return i}},"FeatureIndex",{omit:["rawTileData","sourceLayerCoder"]});const rp=ha([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_tex_size",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),np=ha([{name:"a_globe_anchor",components:3,type:"Int16"},{name:"a_globe_normal",components:3,type:"Float32"}],4),op=ha([{name:"a_projected_pos",components:4,type:"Float32"}],4);ha([{name:"a_fade_opacity",components:1,type:"Uint32"}],4);const ap=ha([{name:"a_z_offset",components:1,type:"Float32"}],4),sp=ha([{name:"a_texb",components:2,type:"Uint16"}]),lp=ha([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}]),cp=ha([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]);ha([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"tileAnchorX"},{type:"Int16",name:"tileAnchorY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]);const up=ha([{name:"a_pos",components:3,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4),hp=ha([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);ha([{name:"triangle",components:3,type:"Uint16"}]),ha([{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"},{type:"Uint8",name:"flipState"}]),ha([{type:"Float32",name:"tileAnchorX"},{type:"Float32",name:"tileAnchorY"},{type:"Int16",name:"projectedAnchorX"},{type:"Int16",name:"projectedAnchorY"},{type:"Int16",name:"projectedAnchorZ"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"},{type:"Float32",name:"zOffset"},{type:"Uint8",name:"hasIconTextFit"}]),ha([{type:"Float32",name:"offsetX"}]),ha([{type:"Int16",name:"x"},{type:"Int16",name:"y"}]);const dp=128;function pp(e,t){const{expression:i}=t;if("constant"===i.kind)return{kind:"constant",layoutSize:i.evaluate(new EvaluationParameters(e+1))};if("source"===i.kind)return{kind:"source"};{const{zoomStops:t,interpolationType:r}=i;let n=0;for(;n<t.length&&t[n]<=e;)n++;n=Math.max(0,n-1);let o=n;for(;o<t.length&&t[o]<e+1;)o++;o=Math.min(t.length-1,o);const a=t[n],s=t[o];return"composite"===i.kind?{kind:"composite",minZoom:a,maxZoom:s,interpolationType:r}:{kind:"camera",minZoom:a,maxZoom:s,minSize:i.evaluate(new EvaluationParameters(a)),maxSize:i.evaluate(new EvaluationParameters(s)),interpolationType:r}}}function fp(e,{uSize:t,uSizeT:i},{lowerSize:r,upperSize:n}){return"source"===e.kind?r/dp:"composite"===e.kind?yr(r/dp,n/dp,i):t}function mp(e,t){let i=0,r=0;if("constant"===e.kind)r=e.layoutSize;else if("source"!==e.kind){const{interpolationType:n,minZoom:o,maxZoom:a}=e,s=n?I(Vr.interpolationFactor(n,t,o,a),0,1):0;"camera"===e.kind?r=yr(e.minSize,e.maxSize,s):i=s}return{uSizeT:i,uSize:r}}var _p=Object.freeze({__proto__:null,SIZE_PACK_FACTOR:dp,evaluateSizeForFeature:fp,evaluateSizeForZoom:mp,getSizeData:pp});function gp(e,t,i){return e.sections.forEach((e=>{e.text=function(e,t,i){const r=t.layout.get("text-transform").evaluate(i,{});return"uppercase"===r?e=e.toLocaleUpperCase():"lowercase"===r&&(e=e.toLocaleLowerCase()),e}(e.text,t,i)})),e}const yp={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂","←":"↑","→":"↓"},xp=3;function vp(e,t,i){t.glyphs=[],1===e&&i.readMessage(bp,t)}function bp(e,t,i){if(3===e){const{id:e,bitmap:r,width:n,height:o,left:a,top:s,advance:l}=i.readMessage(wp,{});t.glyphs.push({id:e,bitmap:new AlphaImage({width:n+2*xp,height:o+2*xp},r),metrics:{width:n,height:o,left:a,top:s,advance:l}})}else 4===e?t.ascender=i.readSVarint():5===e&&(t.descender=i.readSVarint())}function wp(e,t,i){1===e?t.id=i.readVarint():2===e?t.bitmap=i.readBytes():3===e?t.width=i.readVarint():4===e?t.height=i.readVarint():5===e?t.left=i.readSVarint():6===e?t.top=i.readSVarint():7===e&&(t.advance=i.readVarint())}function Tp(e){let t=0,i=0;for(const r of e)t+=r.w*r.h,i=Math.max(i,r.w);e.sort(((e,t)=>t.h-e.h));const r=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(t/.95)),i),h:1/0}];let n=0,o=0;for(const t of e)for(let e=r.length-1;e>=0;e--){const i=r[e];if(!(t.w>i.w||t.h>i.h)){if(t.x=i.x,t.y=i.y,o=Math.max(o,t.y+t.h),n=Math.max(n,t.x+t.w),t.w===i.w&&t.h===i.h){const t=r.pop();e<r.length&&(r[e]=t)}else t.h===i.h?(i.x+=t.w,i.w-=t.w):t.w===i.w?(i.y+=t.h,i.h-=t.h):(r.push({x:i.x+t.w,y:i.y,w:i.w-t.w,h:t.h}),i.y+=t.h,i.h-=t.h);break}}return{w:n,h:o,fill:t/(n*o)||0}}class ImagePosition{constructor(e,{pixelRatio:t,version:i,stretchX:r,stretchY:n,content:o}){this.paddedRect=e,this.pixelRatio=t,this.stretchX=r,this.stretchY=n,this.content=o,this.version=i}get tl(){return[this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return[this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get displaySize(){return[(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}Fo(ImagePosition,"ImagePosition"),Fo(class ImageAtlas{constructor(e,t){const i={},r={};this.haveRenderCallbacks=[];const n=[];this.addImages(e,i,n),this.addImages(t,r,n);const{w:o,h:a}=Tp(n),s=new RGBAImage({width:o||1,height:a||1});for(const t in e){const r=e[t],n=i[t].paddedRect;RGBAImage.copy(r.data,s,{x:0,y:0},{x:n.x+1,y:n.y+1},r.data)}for(const e in t){const i=t[e],n=r[e].paddedRect,o=n.x+1,a=n.y+1,l=i.data.width,c=i.data.height;RGBAImage.copy(i.data,s,{x:0,y:0},{x:o,y:a},i.data),RGBAImage.copy(i.data,s,{x:0,y:c-1},{x:o,y:a-1},{width:l,height:1}),RGBAImage.copy(i.data,s,{x:0,y:0},{x:o,y:a+c},{width:l,height:1}),RGBAImage.copy(i.data,s,{x:l-1,y:0},{x:o-1,y:a},{width:1,height:c}),RGBAImage.copy(i.data,s,{x:0,y:0},{x:o+l,y:a},{width:1,height:c})}this.image=s,this.iconPositions=i,this.patternPositions=r}addImages(e,t,i){for(const r in e){const n=e[r],o={x:0,y:0,w:n.data.width+2,h:n.data.height+2};i.push(o),t[r]=new ImagePosition(o,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(r)}}patchUpdatedImages(e,t,i){this.haveRenderCallbacks=this.haveRenderCallbacks.filter((t=>e.hasImage(t,i))),e.dispatchRenderCallbacks(this.haveRenderCallbacks,i);for(const r in e.getUpdatedImages(i))this.patchUpdatedImage(this.iconPositions[r],e.getImage(r,i),t),this.patchUpdatedImage(this.patternPositions[r],e.getImage(r,i),t)}patchUpdatedImage(e,t,i){if(!e||!t)return;if(e.version===t.version)return;e.version=t.version;const[r,n]=e.tl;i.update(t.data,void 0,{x:r,y:n})}},"ImageAtlas");const Ep={horizontal:1,vertical:2,horizontalOnly:3};function Mp(e){let t=.5,i=.5;switch(e){case"right":case"top-right":case"bottom-right":t=1;break;case"left":case"top-left":case"bottom-left":t=0}switch(e){case"bottom":case"bottom-right":case"bottom-left":i=1;break;case"top":case"top-right":case"top-left":i=0}return{horizontalAlign:t,verticalAlign:i}}class Anchor extends g{constructor(e,t,i,r,n){super(e,t),this.angle=r,this.z=i,void 0!==n&&(this.segment=n)}clone(){return new Anchor(this.x,this.y,this.z,this.angle,this.segment)}}Fo(Anchor,"Anchor");const Sp=1e20;function Ap(e,t,i,r,n,o,a,s,l){for(let c=t;c<t+r;c++)Cp(e,i*o+c,o,n,a,s,l);for(let c=i;c<i+n;c++)Cp(e,c*o+t,1,r,a,s,l)}function Cp(e,t,i,r,n,o,a){o[0]=0,a[0]=-Sp,a[1]=Sp,n[0]=e[t];for(let s=1,l=0,c=0;s<r;s++){n[s]=e[t+s*i];const r=s*s;do{const e=o[l];c=(n[s]-n[e]+r-e*e)/(s-e)/2}while(c<=a[l]&&--l>-1);l++,o[l]=s,a[l]=c,a[l+1]=Sp}for(let s=0,l=0;s<r;s++){for(;a[l+1]<s;)l++;const r=o[l],c=s-r;e[t+s*i]=n[r]+c*c}}class GlyphManager{constructor(e,t,i){this.requestManager=e,this.localGlyphMode=t,this.localFontFamily=i,this.urls={},this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}}}setURL(e,t){this.urls[t]=e}getGlyphs(e,t,i){const n=[],o=this.urls[t]||r.GLYPHS_URL;for(const t in e)for(const i of e[t])n.push({stack:t,id:i});L(n,(({stack:e,id:t},i)=>{let r=this.entries[e];r||(r=this.entries[e]={glyphs:{},requests:{},ranges:{},ascender:void 0,descender:void 0});let n=r.glyphs[t];if(void 0!==n)return void i(null,{stack:e,id:t,glyph:n});if(n=this._tinySDF(r,e,t),n)return r.glyphs[t]=n,void i(null,{stack:e,id:t,glyph:n});const a=Math.floor(t/256);if(256*a>65535)return void i(new Error("glyphs > 65535 not supported"));if(r.ranges[a])return void i(null,{stack:e,id:t,glyph:n});let s=r.requests[a];s||(s=r.requests[a]=[],GlyphManager.loadGlyphRange(e,a,o,this.requestManager,((e,t)=>{if(t){r.ascender=t.ascender,r.descender=t.descender;for(const e in t.glyphs)this._doesCharSupportLocalGlyph(+e)||(r.glyphs[+e]=t.glyphs[+e]);r.ranges[a]=!0}for(const i of s)i(e,t);delete r.requests[a]}))),s.push(((r,n)=>{r?i(r):n&&i(null,{stack:e,id:t,glyph:n.glyphs[t]||null})}))}),((e,t)=>{if(e)i(e);else if(t){const e={};for(const{stack:i,id:r,glyph:n}of t)void 0===e[i]&&(e[i]={}),void 0===e[i].glyphs&&(e[i].glyphs={}),e[i].glyphs[r]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics},e[i].ascender=this.entries[i].ascender,e[i].descender=this.entries[i].descender;i(null,e)}}))}_doesCharSupportLocalGlyph(e){return 0!==this.localGlyphMode&&(2===this.localGlyphMode?!!this.localFontFamily:!!this.localFontFamily&&(Go["CJK Unified Ideographs"](e)||Go["Hangul Syllables"](e)||Go.Hiragana(e)||Go.Katakana(e)||Go["CJK Symbols and Punctuation"](e)||Go["CJK Unified Ideographs Extension A"](e)||Go["CJK Unified Ideographs Extension B"](e)))}_tinySDF(e,t,i){const r=this.localFontFamily;if(!r||!this._doesCharSupportLocalGlyph(i))return;let n=e.tinySDF;if(!n){let i="400";/bold/i.test(t)?i="900":/medium/i.test(t)?i="500":/light/i.test(t)&&(i="200"),n=e.tinySDF=new GlyphManager.TinySDF({fontFamily:r,fontWeight:i,fontSize:48,buffer:6,radius:16}),n.fontWeight=i}if(this.localGlyphs[n.fontWeight][i])return this.localGlyphs[n.fontWeight][i];const o=String.fromCodePoint(i),{data:a,width:s,height:l,glyphWidth:c,glyphHeight:u,glyphLeft:h,glyphTop:d,glyphAdvance:p}=n.draw(o);return this.localGlyphs[n.fontWeight][i]={id:i,bitmap:new AlphaImage({width:s,height:l},a),metrics:{width:c/2,height:u/2,left:h/2,top:d/2-27,advance:p/2,localGlyph:!0}}}}GlyphManager.loadGlyphRange=function(e,t,i,r,n){const o=256*t,a=o+255,s=r.transformRequest(r.normalizeGlyphsURL(i).replace("{fontstack}",e).replace("{range}",`${o}-${a}`),_e.Glyphs);ve(s,((e,t)=>{if(e)n(e);else if(t){const e={},i=function(e){return new qd(e).readFields(vp,{})}(t);for(const t of i.glyphs)e[t.id]=t;n(null,{glyphs:e,ascender:i.ascender,descender:i.descender})}}))},GlyphManager.TinySDF=class TinySDF{constructor({fontSize:e=24,buffer:t=3,radius:i=8,cutoff:r=.25,fontFamily:n="sans-serif",fontWeight:o="normal",fontStyle:a="normal"}={}){this.buffer=t,this.cutoff=r,this.radius=i;const s=this.size=e+4*t,l=this._createCanvas(s),c=this.ctx=l.getContext("2d",{willReadFrequently:!0});c.font=`${a} ${o} ${e}px ${n}`,c.textBaseline="alphabetic",c.textAlign="left",c.fillStyle="black",this.gridOuter=new Float64Array(s*s),this.gridInner=new Float64Array(s*s),this.f=new Float64Array(s),this.z=new Float64Array(s+1),this.v=new Uint16Array(s)}_createCanvas(e){const t=document.createElement("canvas");return t.width=t.height=e,t}draw(e){const{width:t,actualBoundingBoxAscent:i,actualBoundingBoxDescent:r,actualBoundingBoxLeft:n,actualBoundingBoxRight:o}=this.ctx.measureText(e),a=Math.ceil(i),s=Math.max(0,Math.min(this.size-this.buffer,Math.ceil(o-n))),l=Math.min(this.size-this.buffer,a+Math.ceil(r)),c=s+2*this.buffer,u=l+2*this.buffer,h=Math.max(c*u,0),d=new Uint8ClampedArray(h),p={data:d,width:c,height:u,glyphWidth:s,glyphHeight:l,glyphTop:a,glyphLeft:0,glyphAdvance:t};if(0===s||0===l)return p;const{ctx:f,buffer:m,gridInner:_,gridOuter:g}=this;f.clearRect(m,m,s,l),f.fillText(e,m,m+a);const y=f.getImageData(m,m,s,l);g.fill(Sp,0,h),_.fill(0,0,h);for(let e=0;e<l;e++)for(let t=0;t<s;t++){const i=y.data[4*(e*s+t)+3]/255;if(0===i)continue;const r=(e+m)*c+t+m;if(1===i)g[r]=0,_[r]=Sp;else{const e=.5-i;g[r]=e>0?e*e:0,_[r]=e<0?e*e:0}}Ap(g,0,0,c,u,c,this.f,this.v,this.z),Ap(_,m,m,s,l,c,this.f,this.v,this.z);for(let e=0;e<h;e++){const t=Math.sqrt(g[e])-Math.sqrt(_[e]);d[e]=Math.round(255-255*(t/this.radius+this.cutoff))}return p}};const Ip=7,Dp=Number.POSITIVE_INFINITY,Pp=Math.sqrt(2);function Lp(e,[t,i]){let r=0,n=0;if(i===Dp){t<0&&(t=0);const i=t/Pp;switch(e){case"top-right":case"top-left":n=i-Ip;break;case"bottom-right":case"bottom-left":n=-i+Ip;break;case"bottom":n=-t+Ip;break;case"top":n=t-Ip}switch(e){case"top-right":case"bottom-right":r=-i;break;case"top-left":case"bottom-left":r=i;break;case"left":r=t;break;case"right":r=-t}}else{switch(t=Math.abs(t),i=Math.abs(i),e){case"top-right":case"top-left":case"top":n=i-Ip;break;case"bottom-right":case"bottom-left":case"bottom":n=-i+Ip}switch(e){case"top-right":case"bottom-right":case"right":r=-t;break;case"top-left":case"bottom-left":case"left":r=t}}return[r,n]}const zp=255*dp;function Rp(e,t){const i=e.fovAboveCenter,r=e.elevation?e.elevation.getMinElevationBelowMSL()*t:0,n=(e._camera.position[2]*e.worldSize-r)/Math.cos(e._pitch),o=Math.sin(i)*n/Math.sin(Math.max(Math.PI/2-e._pitch-i,.01)),a=Math.sin(e._pitch)*o+n;return Math.min(1.01*a,n*(1/e._horizonShift))}function kp(e,t){if(!t.isReprojectedInTileSpace)return{scale:1<<e.z,x:e.x,y:e.y,x2:e.x+1,y2:e.y+1,projection:t};const i=Math.pow(2,-e.z),r=e.x*i,n=(e.x+1)*i,o=e.y*i,a=(e.y+1)*i,s=xu(r),l=xu(n),c=vu(o),u=vu(a),h=t.project(s,c),d=t.project(l,c),p=t.project(l,u),f=t.project(s,u);let m=Math.min(h.x,d.x,p.x,f.x),_=Math.min(h.y,d.y,p.y,f.y),g=Math.max(h.x,d.x,p.x,f.x),y=Math.max(h.y,d.y,p.y,f.y);const x=i/16;function v(e,i,r,n,o,a){const s=(r+o)/2,l=(n+a)/2,c=t.project(xu(s),vu(l)),u=Math.max(0,m-c.x,_-c.y,c.x-g,c.y-y);m=Math.min(m,c.x),g=Math.max(g,c.x),_=Math.min(_,c.y),y=Math.max(y,c.y),u>x&&(v(e,c,r,n,s,l),v(c,i,s,l,o,a))}v(h,d,r,o,n,o),v(d,p,n,o,n,a),v(p,f,n,a,r,a),v(f,h,r,a,r,o),m-=x,_-=x,g+=x,y+=x;const b=1/Math.max(g-m,y-_);return{scale:b,x:m*b,y:_*b,x2:g*b,y2:y*b,projection:t}}function Bp(e,t,i,r,n,o,a,s,l){if("globe"===l.name)return Vc(e,t,new CanonicalTileID(i,r,n),!1);const c=kp({z:i,x:r,y:n},l);return new Aabb([(o+c.x/c.scale)*t,t*(c.y/c.scale),a],[(o+c.x2/c.scale)*t,t*(c.y2/c.scale),s])}function Op(e,{x:t,y:i},r=0){return new g(((t-r)*e.scale-e.x)*Ri,(i*e.scale-e.y)*Ri)}function Fp(e,t,i=0){return lc.fromValues(((t.x-i)*e.scale-e.x)*Ri,(t.y*e.scale-e.y)*Ri,bu(t.z,t.y))}const Up=ic.identity(new Float32Array(16));class Projection{constructor(e){this.spec=e,this.name=e.name,this.wrap=!1,this.requiresDraping=!1,this.supportsWorldCopies=!1,this.supportsTerrain=!1,this.supportsFog=!1,this.supportsFreeCamera=!1,this.zAxisUnit="meters",this.isReprojectedInTileSpace=!0,this.unsupportedLayers=["custom"],this.center=[0,0],this.range=[3.5,7]}project(e,t){return{x:0,y:0,z:0}}unproject(e,t){return new du(0,0)}projectTilePoint(e,t,i){return{x:e,y:t,z:0}}locationPoint(e,t,i=!0){return e._coordinatePoint(e.locationCoordinate(t),i)}pixelsPerMeter(e,t){return yu(1,e)*t}pixelSpaceConversion(e,t,i){return 1}farthestPixelDistance(e){return Rp(e,e.pixelsPerMeter)}pointCoordinate(e,t,i,r){const n=e.horizonLineFromTop(!1),o=new g(t,Math.max(n,i));return e.rayIntersectionCoordinate(e.pointRayIntersection(o,r))}pointCoordinate3D(e,t,i){const r=new g(t,i);if(e.elevation)return e.elevation.pointCoordinate(r);{const t=this.pointCoordinate(e,r.x,r.y,0);return[t.x,t.y,t.z]}}isPointAboveHorizon(e,t){if(e.elevation)return!this.pointCoordinate3D(e,t.x,t.y);const i=e.horizonLineFromTop();return t.y<i}createInversionMatrix(e,t){return Up}createTileMatrix(e,t,i){let r,n,o;const a=i.canonical,s=ic.identity(new Float64Array(16));if(this.isReprojectedInTileSpace){const l=kp(a,this);r=1,n=l.x+i.wrap*l.scale,o=l.y,ic.scale(s,s,[r/l.scale,r/l.scale,e.pixelsPerMeter/t])}else r=t/e.zoomScale(a.z),n=(a.x+Math.pow(2,a.z)*i.wrap)*r,o=a.y*r;return ic.translate(s,s,[n,o,0]),ic.scale(s,s,[r/Ri,r/Ri,1]),s}upVector(e,t,i){return[0,0,1]}upVectorScale(e,t,i){return{metersToTile:1}}}class Albers extends Projection{constructor(e){super(e),this.range=[4,7],this.center=e.center||[-96,37.5];const[t,i]=this.parallels=e.parallels||[29.5,45.5],r=Math.sin(b(t));this.n=(r+Math.sin(b(i)))/2,this.c=1+r*(2*this.n-r),this.r0=Math.sqrt(this.c)/this.n}project(e,t){const{n:i,c:r,r0:n}=this,o=b(e-this.center[0]),a=b(t),s=Math.sqrt(r-2*i*Math.sin(a))/i;return{x:s*Math.sin(o*i),y:s*Math.cos(o*i)-n,z:0}}unproject(e,t){const{n:i,c:r,r0:n}=this,o=n+t;let a=Math.atan2(e,Math.abs(o))*Math.sign(o);o*i<0&&(a-=Math.PI*Math.sign(e)*Math.sign(o));const s=b(this.center[0])*i;a=P(a,-Math.PI-s,Math.PI-s);const l=I(w(a/i)+this.center[0],-180,180),c=Math.asin(I((r-(e*e+o*o)*i*i)/(2*i),-1,1)),u=I(w(c),-wu,wu);return new du(l,u)}}const Vp=1.340264,Np=-.081106,jp=893e-6,Gp=.003796,qp=Math.sqrt(3)/2;class EqualEarth extends Projection{project(e,t){t=t/180*Math.PI,e=e/180*Math.PI;const i=Math.asin(qp*Math.sin(t)),r=i*i,n=r*r*r;return{x:.5*(e*Math.cos(i)/(qp*(Vp+3*Np*r+n*(7*jp+9*Gp*r)))/Math.PI+.5),y:1-.5*(i*(Vp+Np*r+n*(jp+Gp*r))/Math.PI+1),z:0}}unproject(e,t){e=(2*e-.5)*Math.PI;let i=t=(2*(1-t)-1)*Math.PI,r=i*i,n=r*r*r;for(let e,o,a,s=0;s<12&&(o=i*(Vp+Np*r+n*(jp+Gp*r))-t,a=Vp+3*Np*r+n*(7*jp+9*Gp*r),e=o/a,i=I(i-e,-Math.PI/3,Math.PI/3),r=i*i,n=r*r*r,!(Math.abs(e)<1e-12));++s);const o=qp*e*(Vp+3*Np*r+n*(7*jp+9*Gp*r))/Math.cos(i),a=Math.asin(Math.sin(i)/qp),s=I(180*o/Math.PI,-180,180),l=I(180*a/Math.PI,-wu,wu);return new du(s,l)}}class Equirectangular extends Projection{constructor(e){super(e),this.wrap=!0,this.supportsWorldCopies=!0}project(e,t){return{x:.5+e/360,y:.5-t/360,z:0}}unproject(e,t){const i=360*(e-.5),r=I(360*(.5-t),-wu,wu);return new du(i,r)}}const Zp=Math.PI/2;function $p(e){return Math.tan((Zp+e)/2)}class LambertConformalConic extends Projection{constructor(e){super(e),this.center=e.center||[0,30];const[t,i]=this.parallels=e.parallels||[30,30];let r=b(t),n=b(i);this.southernCenter=r+n<0,this.southernCenter&&(r=-r,n=-n);const o=Math.cos(r),a=$p(r);this.n=r===n?Math.sin(r):Math.log(o/Math.cos(n))/Math.log($p(n)/a),this.f=o*Math.pow($p(r),this.n)/this.n}project(e,t){t=b(t),this.southernCenter&&(t=-t),e=b(e-this.center[0]);const i=1e-6,{n:r,f:n}=this;n>0?t<-Zp+i&&(t=-Zp+i):t>Zp-i&&(t=Zp-i);const o=n/Math.pow($p(t),r);let a=o*Math.sin(r*e),s=n-o*Math.cos(r*e);return a=.5*(a/Math.PI+.5),s=.5*(s/Math.PI+.5),{x:a,y:this.southernCenter?s:1-s,z:0}}unproject(e,t){e=(2*e-.5)*Math.PI,this.southernCenter&&(t=1-t),t=(2*(1-t)-.5)*Math.PI;const{n:i,f:r}=this,n=r-t,o=Math.sign(n),a=Math.sign(i)*Math.sqrt(e*e+n*n);let s=Math.atan2(e,Math.abs(n))*o;n*i<0&&(s-=Math.PI*Math.sign(e)*o);const l=I(w(s/i)+this.center[0],-180,180),c=I(w(2*Math.atan(Math.pow(r/a,1/i))-Zp),-wu,wu);return new du(l,this.southernCenter?-c:c)}}class Mercator extends Projection{constructor(e){super(e),this.wrap=!0,this.supportsWorldCopies=!0,this.supportsTerrain=!0,this.supportsFog=!0,this.supportsFreeCamera=!0,this.isReprojectedInTileSpace=!1,this.unsupportedLayers=[],this.range=null}project(e,t){return{x:_u(e),y:gu(t),z:0}}unproject(e,t){const i=xu(e),r=vu(t);return new du(i,r)}}const Hp=b(wu);class NaturalEarth extends Projection{project(e,t){const i=(t=b(t))*t,r=i*i;return{x:.5*((e=b(e))*(.8707-.131979*i+r*(r*(.003971*i-.001529*r)-.013791))/Math.PI+.5),y:1-.5*(t*(1.007226+i*(.015085+r*(.028874*i-.044475-.005916*r)))/Math.PI+1),z:0}}unproject(e,t){e=(2*e-.5)*Math.PI;let i=t=(2*(1-t)-1)*Math.PI,r=25,n=0,o=i*i;do{o=i*i;const e=o*o;n=(i*(1.007226+o*(.015085+e*(.028874*o-.044475-.005916*e)))-t)/(1.007226+o*(.045255+e*(.259866*o-.311325-.005916*11*e))),i=I(i-n,-Hp,Hp)}while(Math.abs(n)>1e-6&&--r>0);o=i*i;const a=I(w(e/(.8707+o*(o*(o*o*o*(.003971-.001529*o)-.013791)-.131979))),-180,180),s=w(i);return new du(a,s)}}const Wp=b(wu);class WinkelTripel extends Projection{project(e,t){t=b(t),e=b(e);const i=Math.cos(t),r=2/Math.PI,n=Math.acos(i*Math.cos(e/2)),o=Math.sin(n)/n,a=.5*(e*r+2*i*Math.sin(e/2)/o)||0,s=.5*(t+Math.sin(t)/o)||0;return{x:.5*(a/Math.PI+.5),y:1-.5*(s/Math.PI+1),z:0}}unproject(e,t){let i=e=(2*e-.5)*Math.PI,r=t=(2*(1-t)-1)*Math.PI,n=25;const o=1e-6;let a=0,s=0;do{const n=Math.cos(r),o=Math.sin(r),l=2*o*n,c=o*o,u=n*n,h=Math.cos(i/2),d=Math.sin(i/2),p=2*h*d,f=d*d,m=1-u*h*h,_=m?1/m:0,g=m?Math.acos(n*h)*Math.sqrt(1/m):0,y=.5*(2*g*n*d+2*i/Math.PI)-e,x=.5*(g*o+r)-t,v=.5*_*(u*f+g*n*h*c)+1/Math.PI,b=_*(p*l/4-g*o*d),w=.125*_*(l*d-g*o*u*p),T=.5*_*(c*h+g*f*n)+.5,E=b*w-T*v;a=(x*b-y*T)/E,s=(y*w-x*v)/E,i=I(i-a,-Math.PI,Math.PI),r=I(r-s,-Wp,Wp)}while((Math.abs(a)>o||Math.abs(s)>o)&&--n>0);return new du(w(i),w(r))}}class CylindricalEqualArea extends Projection{constructor(e){super(e),this.center=e.center||[0,0],this.parallels=e.parallels||[0,0],this.cosPhi=Math.max(.01,Math.cos(b(this.parallels[0]))),this.scale=1/(2*Math.max(Math.PI*this.cosPhi,1/this.cosPhi)),this.wrap=!0,this.supportsWorldCopies=!0}project(e,t){const{scale:i,cosPhi:r}=this;return{x:b(e)*r*i+.5,y:-Math.sin(b(t))/r*i+.5,z:0}}unproject(e,t){const{scale:i,cosPhi:r}=this,n=-(t-.5)/i,o=I(w((e-.5)/i)/r,-180,180),a=Math.asin(I(n*r,-1,1)),s=I(w(a),-wu,wu);return new du(o,s)}}class Globe extends Mercator{constructor(e){super(e),this.requiresDraping=!0,this.supportsWorldCopies=!1,this.supportsFog=!0,this.zAxisUnit="pixels",this.unsupportedLayers=["debug"],this.range=[3,5]}projectTilePoint(e,t,i){const r=Zc(e,t,i),n=Wc(Bc(i));return lc.transformMat4(r,r,n),{x:r[0],y:r[1],z:r[2]}}locationPoint(e,t){const i=qc(t.lat,t.lng),r=lc.normalize([],i),n=e.elevation?e.elevation.getAtPointOrZero(e.locationCoordinate(t),e._centerAltitude):e._centerAltitude,o=yu(1,0)*Ri*n;lc.scaleAndAdd(i,i,r,o);const a=ic.identity(new Float64Array(16));return ic.multiply(a,e.pixelMatrix,e.globeMatrix),lc.transformMat4(i,i,a),new g(i[0],i[1])}pixelsPerMeter(e,t){return yu(1,0)*t}pixelSpaceConversion(e,t,i){const r=yu(1,e)*t,n=yr(yu(1,45)*t,r,i);return this.pixelsPerMeter(e,t)/n}createTileMatrix(e,t,i){const r=Xc(Bc(i.canonical));return ic.multiply(new Float64Array(16),e.globeMatrix,r)}createInversionMatrix(e,t){const{center:i}=e,r=Wc(Bc(t));return ic.rotateY(r,r,b(i.lng)),ic.rotateX(r,r,b(i.lat)),ic.scale(r,r,[e._pixelsPerMercatorPixel,e._pixelsPerMercatorPixel,1]),Float32Array.from(r)}pointCoordinate(e,t,i,r){return Rc(e,t,i,!0)||new MercatorCoordinate(0,0)}pointCoordinate3D(e,t,i){const r=this.pointCoordinate(e,t,i,0);return[r.x,r.y,r.z]}isPointAboveHorizon(e,t){return!Rc(e,t.x,t.y,!1)}farthestPixelDistance(e){const t=function(e,t){const i=e.cameraToCenterDistance,r=e._centerAltitude*t,n=e._camera,o=e._camera.forward(),a=lc.add([],lc.scale([],o,-i),[0,0,r]),s=e.worldSize/(2*Math.PI),l=[0,0,-s],c=e.width/e.height,u=Math.tan(e.fovAboveCenter),h=lc.scale([],n.up(),u),d=lc.scale([],n.right(),u*c),p=lc.normalize([],lc.add([],lc.add([],o,h),d)),f=[];let m;if(new Ray(a,p).closestPointOnSphere(l,s,f)){const t=lc.add([],f,l),i=lc.sub([],t,a);m=Math.cos(e.fovAboveCenter)*lc.length(i)}else{const e=lc.sub([],a,l),t=lc.sub([],l,a);lc.normalize(t,t);const i=lc.length(e)-s;m=Math.sqrt(i*(i+2*s));const r=Math.acos(m/(s+i))-Math.acos(lc.dot(o,t));m*=Math.cos(r)}return 1.01*m}(e,this.pixelsPerMeter(e.center.lat,e.worldSize)),i=Qc(e.zoom);if(i>0){const r=Rp(e,yu(1,e.center.lat)*e.worldSize),n=e.worldSize/(2*Math.PI),o=Math.max(e.width,e.height)/e.worldSize*Math.PI;return yr(t,r+n*(1-Math.cos(o)),Math.pow(i,10))}return t}upVector(e,t,i){return Zc(t,i,e,1)}upVectorScale(e){return{metersToTile:zc($c(Bc(e)))}}}function Xp(e){const t=e.parallels,i=!!t&&Math.abs(t[0]+t[1])<.01;switch(e.name){case"mercator":return new Mercator(e);case"equirectangular":return new Equirectangular(e);case"naturalEarth":return new NaturalEarth(e);case"equalEarth":return new EqualEarth(e);case"winkelTripel":return new WinkelTripel(e);case"albers":return i?new CylindricalEqualArea(e):new Albers(e);case"lambertConformalConic":return i?new CylindricalEqualArea(e):new LambertConformalConic(e);case"globe":return new Globe(e)}throw new Error(`Invalid projection name: ${e.name}`)}const Yp=new Properties({"symbol-placement":new DataConstantProperty(xt.layout_symbol["symbol-placement"]),"symbol-spacing":new DataConstantProperty(xt.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new DataConstantProperty(xt.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new DataDrivenProperty(xt.layout_symbol["symbol-sort-key"]),"symbol-z-order":new DataConstantProperty(xt.layout_symbol["symbol-z-order"]),"symbol-z-elevate":new DataConstantProperty(xt.layout_symbol["symbol-z-elevate"]),"icon-allow-overlap":new DataConstantProperty(xt.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new DataConstantProperty(xt.layout_symbol["icon-ignore-placement"]),"icon-optional":new DataConstantProperty(xt.layout_symbol["icon-optional"]),"icon-rotation-alignment":new DataConstantProperty(xt.layout_symbol["icon-rotation-alignment"]),"icon-size":new DataDrivenProperty(xt.layout_symbol["icon-size"]),"icon-text-fit":new DataDrivenProperty(xt.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new DataDrivenProperty(xt.layout_symbol["icon-text-fit-padding"]),"icon-image":new DataDrivenProperty(xt.layout_symbol["icon-image"]),"icon-rotate":new DataDrivenProperty(xt.layout_symbol["icon-rotate"]),"icon-padding":new DataConstantProperty(xt.layout_symbol["icon-padding"]),"icon-keep-upright":new DataConstantProperty(xt.layout_symbol["icon-keep-upright"]),"icon-offset":new DataDrivenProperty(xt.layout_symbol["icon-offset"]),"icon-anchor":new DataDrivenProperty(xt.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new DataConstantProperty(xt.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new DataConstantProperty(xt.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new DataConstantProperty(xt.layout_symbol["text-rotation-alignment"]),"text-field":new DataDrivenProperty(xt.layout_symbol["text-field"]),"text-font":new DataDrivenProperty(xt.layout_symbol["text-font"]),"text-size":new DataDrivenProperty(xt.layout_symbol["text-size"]),"text-max-width":new DataDrivenProperty(xt.layout_symbol["text-max-width"]),"text-line-height":new DataDrivenProperty(xt.layout_symbol["text-line-height"]),"text-letter-spacing":new DataDrivenProperty(xt.layout_symbol["text-letter-spacing"]),"text-justify":new DataDrivenProperty(xt.layout_symbol["text-justify"]),"text-radial-offset":new DataDrivenProperty(xt.layout_symbol["text-radial-offset"]),"text-variable-anchor":new DataConstantProperty(xt.layout_symbol["text-variable-anchor"]),"text-anchor":new DataDrivenProperty(xt.layout_symbol["text-anchor"]),"text-max-angle":new DataConstantProperty(xt.layout_symbol["text-max-angle"]),"text-writing-mode":new DataConstantProperty(xt.layout_symbol["text-writing-mode"]),"text-rotate":new DataDrivenProperty(xt.layout_symbol["text-rotate"]),"text-padding":new DataConstantProperty(xt.layout_symbol["text-padding"]),"text-keep-upright":new DataConstantProperty(xt.layout_symbol["text-keep-upright"]),"text-transform":new DataDrivenProperty(xt.layout_symbol["text-transform"]),"text-offset":new DataDrivenProperty(xt.layout_symbol["text-offset"]),"text-allow-overlap":new DataConstantProperty(xt.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new DataConstantProperty(xt.layout_symbol["text-ignore-placement"]),"text-optional":new DataConstantProperty(xt.layout_symbol["text-optional"]),visibility:new DataConstantProperty(xt.layout_symbol.visibility)});var Kp={paint:new Properties({"icon-opacity":new DataDrivenProperty(xt.paint_symbol["icon-opacity"]),"icon-emissive-strength":new DataDrivenProperty(xt.paint_symbol["icon-emissive-strength"]),"text-emissive-strength":new DataDrivenProperty(xt.paint_symbol["text-emissive-strength"]),"icon-color":new DataDrivenProperty(xt.paint_symbol["icon-color"]),"icon-halo-color":new DataDrivenProperty(xt.paint_symbol["icon-halo-color"]),"icon-halo-width":new DataDrivenProperty(xt.paint_symbol["icon-halo-width"]),"icon-halo-blur":new DataDrivenProperty(xt.paint_symbol["icon-halo-blur"]),"icon-translate":new DataConstantProperty(xt.paint_symbol["icon-translate"]),"icon-translate-anchor":new DataConstantProperty(xt.paint_symbol["icon-translate-anchor"]),"icon-image-cross-fade":new DataDrivenProperty(xt.paint_symbol["icon-image-cross-fade"]),"text-opacity":new DataDrivenProperty(xt.paint_symbol["text-opacity"]),"text-color":new DataDrivenProperty(xt.paint_symbol["text-color"],{runtimeType:Dt,getOverride:e=>e.textColor,hasOverride:e=>!!e.textColor}),"text-halo-color":new DataDrivenProperty(xt.paint_symbol["text-halo-color"]),"text-halo-width":new DataDrivenProperty(xt.paint_symbol["text-halo-width"]),"text-halo-blur":new DataDrivenProperty(xt.paint_symbol["text-halo-blur"]),"text-translate":new DataConstantProperty(xt.paint_symbol["text-translate"]),"text-translate-anchor":new DataConstantProperty(xt.paint_symbol["text-translate-anchor"])}),layout:Yp};class FormatSectionOverride{constructor(e){this.type=e.property.overrides?e.property.overrides.runtimeType:Mt,this.defaultValue=e}evaluate(e){if(e.formattedSection){const t=this.defaultValue.property.overrides;if(t&&t.hasOverride(e.formattedSection))return t.getOverride(e.formattedSection)}return e.feature&&e.featureState?this.defaultValue.evaluate(e.feature,e.featureState):this.defaultValue.property.specification.default}eachChild(e){this.defaultValue.isConstant()||e(this.defaultValue.value._styleExpression.expression)}outputDefined(){return!1}serialize(){return null}}Fo(FormatSectionOverride,"FormatSectionOverride",{omit:["defaultValue"]});class SymbolStyleLayer extends StyleLayer{constructor(e,t){super(e,Kp,t)}recalculate(e,t){super.recalculate(e,t),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment"));const i=this.layout.get("text-writing-mode");if(i){const e=[];for(const t of i)e.indexOf(t)<0&&e.push(t);this.layout._values["text-writing-mode"]=e}else this.layout._values["text-writing-mode"]="point"===this.layout.get("symbol-placement")?["horizontal"]:["horizontal","vertical"];this._setPaintOverrides()}getValueAndResolveTokens(e,t,i,r){const n=this.layout.get(e).evaluate(t,{},i,r),o=this._unevaluatedLayout._values[e];return o.isDataDriven()||Dn(o.value)||!n?n:function(e,t){return t.replace(/{([^{}]+)}/g,((t,i)=>i in e?String(e[i]):""))}(t.properties,n)}createBucket(e){return new sf(e)}queryRadius(){return 0}queryIntersectsFeature(){return!1}_setPaintOverrides(){for(const e of Kp.paint.overridableProperties){if(!SymbolStyleLayer.hasPaintOverride(this.layout,e))continue;const t=this.paint.get(e),i=new FormatSectionOverride(t),r=new StyleExpression(i,t.property.specification);let n=null;n="constant"===t.value.kind||"source"===t.value.kind?new ZoomConstantExpression("source",r):new ZoomDependentExpression("composite",r,t.value.zoomStops,t.value._interpolationType),this.paint._values[e]=new PossiblyEvaluatedPropertyValue(t.property,n,t.parameters)}}_handleOverridablePaintPropertyUpdate(e,t,i){return!(!this.layout||t.isDataDriven()||i.isDataDriven())&&SymbolStyleLayer.hasPaintOverride(this.layout,e)}static hasPaintOverride(e,t){const i=e.get("text-field"),r=Kp.paint.properties[t];let n=!1;const o=e=>{for(const t of e)if(r.overrides&&r.overrides.hasOverride(t))return void(n=!0)};if("constant"===i.value.kind&&i.value.value instanceof Formatted)o(i.value.value.sections);else if("source"===i.value.kind){const e=t=>{n||(t instanceof Qt&&Kt(t.value)===Rt?o(t.value.sections):t instanceof FormatExpression?o(t.sections):t.eachChild(e))},t=i.value;t._styleExpression&&e(t._styleExpression.expression)}return n}getProgramIds(){const e=0!==this.paint.get("icon-opacity").constantOr(1),t=0!==this.paint.get("text-opacity").constantOr(1),i=[];return e&&i.push("symbolIcon"),t&&i.push("symbolSDF"),i}getDefaultProgramParams(e,t){return{config:new ProgramConfiguration(this,t),overrideFog:!1}}}const Jp=vd.types,Qp=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function ef(e,t,i,r,n,o,a,s,l,c,u,h,d){const p=s?Math.min(zp,Math.round(s[0])):0,f=s?Math.min(zp,Math.round(s[1])):0;e.emplaceBack(t,i,Math.round(32*r),Math.round(32*n),o,a,(p<<1)+(l?1:0),f,16*c,16*u,256*h,256*d)}function tf(e,t,i){e.emplaceBack(t,i)}function rf(e,t,i,r,n,o,a){e.emplaceBack(t,i,r,n,o,a)}function nf(e,t,i,r,n){const o=5*t+2;e.float32[o+0]=i,e.float32[o+1]=r,e.float32[o+2]=n}function of(e,t,i,r,n){e.emplaceBack(t,i,r,n),e.emplaceBack(t,i,r,n),e.emplaceBack(t,i,r,n),e.emplaceBack(t,i,r,n)}function af(e){for(const t of e.sections)if(Wo(t.text))return!0;return!1}class SymbolBuffers{constructor(e){this.layoutVertexArray=new StructArrayLayout4i4ui4i24,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=e,this.segments=new SegmentVector,this.dynamicLayoutVertexArray=new StructArrayLayout4f16,this.opacityVertexArray=new StructArrayLayout1ul4,this.placedSymbolArray=new PlacedSymbolArray,this.iconTransitioningVertexArray=new StructArrayLayout2ui4,this.globeExtVertexArray=new StructArrayLayout3i3f20,this.zOffsetVertexArray=new StructArrayLayout1f4}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length&&0===this.iconTransitioningVertexArray.length}upload(e,t,i,r,n){this.isEmpty()||(i&&(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,rp.members),this.indexBuffer=e.createIndexBuffer(this.indexArray,t),this.dynamicLayoutVertexBuffer=e.createVertexBuffer(this.dynamicLayoutVertexArray,op.members,!0),this.opacityVertexBuffer=e.createVertexBuffer(this.opacityVertexArray,Qp,!0),this.iconTransitioningVertexArray.length>0&&(this.iconTransitioningVertexBuffer=e.createVertexBuffer(this.iconTransitioningVertexArray,sp.members,!0)),this.globeExtVertexArray.length>0&&(this.globeExtVertexBuffer=e.createVertexBuffer(this.globeExtVertexArray,np.members,!0)),!this.zOffsetVertexBuffer&&(this.zOffsetVertexArray.length>0||n)&&(this.zOffsetVertexBuffer=e.createVertexBuffer(this.zOffsetVertexArray,ap.members,!0)),this.opacityVertexBuffer.itemSize=1),(i||r)&&this.programConfigurations.upload(e))}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy(),this.iconTransitioningVertexBuffer&&this.iconTransitioningVertexBuffer.destroy(),this.globeExtVertexBuffer&&this.globeExtVertexBuffer.destroy(),this.zOffsetVertexBuffer&&this.zOffsetVertexBuffer.destroy())}}Fo(SymbolBuffers,"SymbolBuffers");class CollisionBuffers{constructor(e,t,i){this.layoutVertexArray=new e,this.layoutAttributes=t,this.indexArray=new i,this.segments=new SegmentVector,this.collisionVertexArray=new StructArrayLayout2ub2f12,this.collisionVertexArrayExt=new StructArrayLayout3f12}upload(e){this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=e.createVertexBuffer(this.collisionVertexArray,lp.members,!0),this.collisionVertexBufferExt=e.createVertexBuffer(this.collisionVertexArrayExt,cp.members,!0)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy())}}Fo(CollisionBuffers,"CollisionBuffers");class SymbolBucket{constructor(e){this.collisionBoxArray=e.collisionBoxArray,this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.fqid)),this.index=e.index,this.pixelRatio=e.pixelRatio,this.sourceLayerIndex=e.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.fullyClipped=!1,this.hasAnyIconTextFit=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=ic.identity([]),this.placementViewportMatrix=ic.identity([]);const t=this.layers[0]._unevaluatedLayout._values;this.textSizeData=pp(this.zoom,t["text-size"]),this.iconSizeData=pp(this.zoom,t["icon-size"]);const i=this.layers[0].layout,r=i.get("symbol-sort-key"),n=i.get("symbol-z-order");this.canOverlap=i.get("text-allow-overlap")||i.get("icon-allow-overlap")||i.get("text-ignore-placement")||i.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&void 0!==r.constantOr(1),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,this.writingModes=i.get("text-writing-mode").map((e=>Ep[e])),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.sourceID=e.sourceID,this.projection=e.projection,this.hasAnyZOffset=!1,this.zOffsetSortDirty=!1,this.zOffsetBuffersNeedUpload=i.get("symbol-z-elevate")}createArrays(){this.text=new SymbolBuffers(new ProgramConfigurationSet(this.layers,this.zoom,(e=>/^text/.test(e)))),this.icon=new SymbolBuffers(new ProgramConfigurationSet(this.layers,this.zoom,(e=>/^icon/.test(e)))),this.glyphOffsetArray=new GlyphOffsetArray,this.lineVertexArray=new SymbolLineVertexArray,this.symbolInstances=new SymbolInstanceArray}calculateGlyphDependencies(e,t,i,r,n){for(let i=0;i<e.length;i++){const o=e.codePointAt(i);if(void 0===o)break;if(t[o]=!0,r&&n&&o<=65535){const r=yp[e.charAt(i)];r&&(t[r.charCodeAt(0)]=!0)}}}populate(e,t,i,r){const n=this.layers[0],o=n.layout,a="globe"===this.projection.name,s=o.get("text-font"),l=o.get("text-field"),c=o.get("icon-image"),u=("constant"!==l.value.kind||l.value.value instanceof Formatted&&!l.value.value.isEmpty()||l.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),h="constant"!==c.value.kind||!!c.value.value||Object.keys(c.parameters).length>0,d=o.get("symbol-sort-key");if(this.features=[],!u&&!h)return;const p=t.iconDependencies,f=t.glyphDependencies,m=t.availableImages,_=new EvaluationParameters(this.zoom);for(const{feature:t,id:l,index:c,sourceLayerIndex:g}of e){const e=n._featureFilter.needGeometry,y=ku(t,e);if(!n._featureFilter.filter(_,y,i))continue;if(e||(y.geometry=Ru(t,i,r)),a&&1!==t.type&&i.z<=5){const e=y.geometry,t=.98078528056,r=(e,r)=>{const n=Zc(e.x,e.y,i,1),o=Zc(r.x,r.y,i,1);return lc.dot(n,o)<t};for(let t=0;t<e.length;t++)e[t]=Du(e[t],r)}let x,v;if(u){const e=n.getValueAndResolveTokens("text-field",y,i,m),t=Formatted.factory(e);af(t)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===na()||this.hasRTLText&&aa.isParsed())&&(x=gp(t,n,y))}if(h){const e=n.getValueAndResolveTokens("icon-image",y,i,m);v=e instanceof ResolvedImage?e:ResolvedImage.fromString(e)}if(!x&&!v)continue;const b=this.sortFeaturesByKey?d.evaluate(y,{},i):void 0;if(this.features.push({id:l,text:x,icon:v,index:c,sourceLayerIndex:g,geometry:y.geometry,properties:t.properties,type:Jp[t.type],sortKey:b}),v&&(p[v.namePrimary]=!0,v.nameSecondary&&(p[v.nameSecondary]=!0)),x){const e=s.evaluate(y,{},i).join(","),t="map"===o.get("text-rotation-alignment")&&"point"!==o.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Ep.vertical)>=0;for(const i of x.sections)if(i.image)p[i.image.namePrimary]=!0;else{const r=qo(x.toString()),n=i.fontStack||e,o=f[n]=f[n]||{};this.calculateGlyphDependencies(i.text,o,t,this.allowVerticalPlacement,r)}}}"line"===o.get("symbol-placement")&&(this.features=function(e){const t={},i={},r=[];let n=0;function o(t){r.push(e[t]),n++}function a(e,t,n){const o=i[e];return delete i[e],i[t]=o,r[o].geometry[0].pop(),r[o].geometry[0]=r[o].geometry[0].concat(n[0]),o}function s(e,i,n){const o=t[i];return delete t[i],t[e]=o,r[o].geometry[0].shift(),r[o].geometry[0]=n[0].concat(r[o].geometry[0]),o}function l(e,t,i){const r=i?t[0][t[0].length-1]:t[0][0];return`${e}:${r.x}:${r.y}`}for(let c=0;c<e.length;c++){const u=e[c],h=u.geometry,d=u.text?u.text.toString():null;if(!d){o(c);continue}const p=l(d,h),f=l(d,h,!0);if(p in i&&f in t&&i[p]!==t[f]){const e=s(p,f,h),n=a(p,f,r[e].geometry);delete t[p],delete i[f],i[l(d,r[n].geometry,!0)]=n,r[e].geometry=null}else p in i?a(p,f,h):f in t?s(p,f,h):(o(c),t[p]=n-1,i[f]=n-1)}return r.filter((e=>e.geometry))}(this.features)),this.sortFeaturesByKey&&this.features.sort(((e,t)=>e.sortKey-t.sortKey))}update(e,t,i,r,n){const o=0!==Object.keys(e).length;if(o&&!this.stateDependentLayers.length)return;const a=o?this.stateDependentLayers:this.layers;this.text.programConfigurations.updatePaintArrays(e,t,a,i,r,n),this.icon.programConfigurations.updatePaintArrays(e,t,a,i,r,n)}updateZOffset(){const e=(e,t,r)=>{i+=t,i>e.length&&e.resize(i);for(let n=-t;n<0;n++)e.emplace(n+i,r)},t=(e,t,i)=>{r+=t,r>e.length&&e.resize(r);for(let n=-t;n<0;n++)e.emplace(n+r,i)};if(!this.zOffsetBuffersNeedUpload)return;this.zOffsetBuffersNeedUpload=!1;let i=0,r=0;for(let i=0;i<this.symbolInstances.length;i++){const r=this.symbolInstances.get(i),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:o,numIconVertices:a}=r,s=r.zOffset,l=a>0;if((n>0||o>0)&&(e(this.text.zOffsetVertexArray,n,s),e(this.text.zOffsetVertexArray,o,s)),l){const{placedIconSymbolIndex:e,verticalPlacedIconSymbolIndex:i}=r;e>=0&&t(this.icon.zOffsetVertexArray,a,s),i>=0&&t(this.icon.zOffsetVertexArray,r.numVerticalIconVertices,s)}}this.text.zOffsetVertexBuffer&&this.text.zOffsetVertexBuffer.updateData(this.text.zOffsetVertexArray),this.icon.zOffsetVertexBuffer&&this.icon.zOffsetVertexBuffer.updateData(this.icon.zOffsetVertexArray)}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return!this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(e){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(e),this.iconCollisionBox.upload(e)),this.text.upload(e,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.icon.upload(e,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload,this.zOffsetBuffersNeedUpload),this.uploaded=!0}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy()}getProjection(){return this.projectionInstance||(this.projectionInstance=Xp(this.projection)),this.projectionInstance}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData()}addToLineVertexArray(e,t){const i=this.lineVertexArray.length;if(void 0!==e.segment)for(const{x:e,y:i}of t)this.lineVertexArray.emplaceBack(e,i);return{lineStartIndex:i,lineLength:this.lineVertexArray.length-i}}addSymbols(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m){const _=e.indexArray,g=e.layoutVertexArray,y=e.globeExtVertexArray,x=e.segments.prepareSegment(4*t.length,g,_,this.canOverlap?o.sortKey:void 0),v=this.glyphOffsetArray.length,b=x.vertexLength,w=this.allowVerticalPlacement&&a===Ep.vertical?Math.PI/2:0,T=o.text&&o.text.sections;for(let r=0;r<t.length;r++){const{tl:n,tr:a,bl:c,br:u,texPrimary:h,texSecondary:v,pixelOffsetTL:b,pixelOffsetBR:E,minFontScaleX:M,minFontScaleY:S,glyphOffset:A,isSDF:C,sectionIndex:I}=t[r],D=x.vertexLength,P=A[1];if(ef(g,l.x,l.y,n.x,P+n.y,h.x,h.y,i,C,b.x,b.y,M,S),ef(g,l.x,l.y,a.x,P+a.y,h.x+h.w,h.y,i,C,E.x,b.y,M,S),ef(g,l.x,l.y,c.x,P+c.y,h.x,h.y+h.h,i,C,b.x,E.y,M,S),ef(g,l.x,l.y,u.x,P+u.y,h.x+h.w,h.y+h.h,i,C,E.x,E.y,M,S),s){const{x:t,y:i,z:r}=s.anchor,[n,o,a]=s.up;rf(y,t,i,r,n,o,a),rf(y,t,i,r,n,o,a),rf(y,t,i,r,n,o,a),rf(y,t,i,r,n,o,a),of(e.dynamicLayoutVertexArray,t,i,r,w)}else of(e.dynamicLayoutVertexArray,l.x,l.y,l.z,w);if(m){const t=v||h;tf(e.iconTransitioningVertexArray,t.x,t.y),tf(e.iconTransitioningVertexArray,t.x+t.w,t.y),tf(e.iconTransitioningVertexArray,t.x,t.y+t.h),tf(e.iconTransitioningVertexArray,t.x+t.w,t.y+t.h)}_.emplaceBack(D,D+1,D+2),_.emplaceBack(D+1,D+2,D+3),x.vertexLength+=4,x.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(A[0]),r!==t.length-1&&I===t[r+1].sectionIndex||e.programConfigurations.populatePaintArrays(g.length,o,o.index,{},d,p,f,T&&T[I])}const E=s?s.anchor:l;e.placedSymbolArray.emplaceBack(E.x,E.y,E.z,l.x,l.y,v,this.glyphOffsetArray.length-v,b,c,u,l.segment,i?i[0]:0,i?i[1]:0,r[0],r[1],a,0,!1,0,h,0)}_commitLayoutVertex(e,t,i,r,n,o,a){e.emplaceBack(t,i,r,n,o,Math.round(a.x),Math.round(a.y))}_addCollisionDebugVertices(e,t,i,r,n,o,a){const s=i.segments.prepareSegment(4,i.layoutVertexArray,i.indexArray),l=s.vertexLength,c=a.tileAnchorX,u=a.tileAnchorY;for(let e=0;e<4;e++)i.collisionVertexArray.emplaceBack(0,0,0,0);i.collisionVertexArrayExt.emplaceBack(t,-e.padding,-e.padding),i.collisionVertexArrayExt.emplaceBack(t,e.padding,-e.padding),i.collisionVertexArrayExt.emplaceBack(t,e.padding,e.padding),i.collisionVertexArrayExt.emplaceBack(t,-e.padding,e.padding),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x1,e.y1)),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x2,e.y1)),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x2,e.y2)),this._commitLayoutVertex(i.layoutVertexArray,r,n,o,c,u,new g(e.x1,e.y2)),s.vertexLength+=4;const h=i.indexArray;h.emplaceBack(l,l+1),h.emplaceBack(l+1,l+2),h.emplaceBack(l+2,l+3),h.emplaceBack(l+3,l),s.primitiveLength+=4}_addTextDebugCollisionBoxes(e,t,i,r,n,o){for(let a=r;a<n;a++){const r=i.get(a),n=this.getSymbolInstanceTextSize(e,o,t,a);this._addCollisionDebugVertices(r,n,this.textCollisionBox,r.projectedAnchorX,r.projectedAnchorY,r.projectedAnchorZ,o)}}_addIconDebugCollisionBoxes(e,t,i,r,n,o){for(let a=r;a<n;a++){const r=i.get(a),n=this.getSymbolInstanceIconSize(e,t,o.placedIconSymbolIndex);this._addCollisionDebugVertices(r,n,this.iconCollisionBox,r.projectedAnchorX,r.projectedAnchorY,r.projectedAnchorZ,o)}}generateCollisionDebugBuffers(e,t){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new CollisionBuffers(StructArrayLayout3i2i2i16,up.members,StructArrayLayout2ui4),this.iconCollisionBox=new CollisionBuffers(StructArrayLayout3i2i2i16,up.members,StructArrayLayout2ui4);const i=mp(this.iconSizeData,e),r=mp(this.textSizeData,e);for(let n=0;n<this.symbolInstances.length;n++){const o=this.symbolInstances.get(n);this._addTextDebugCollisionBoxes(r,e,t,o.textBoxStartIndex,o.textBoxEndIndex,o),this._addTextDebugCollisionBoxes(r,e,t,o.verticalTextBoxStartIndex,o.verticalTextBoxEndIndex,o),this._addIconDebugCollisionBoxes(i,e,t,o.iconBoxStartIndex,o.iconBoxEndIndex,o),this._addIconDebugCollisionBoxes(i,e,t,o.verticalIconBoxStartIndex,o.verticalIconBoxEndIndex,o)}}getSymbolInstanceTextSize(e,t,i,r){const n=this.text.placedSymbolArray.get(t.rightJustifiedTextSymbolIndex>=0?t.rightJustifiedTextSymbolIndex:t.centerJustifiedTextSymbolIndex>=0?t.centerJustifiedTextSymbolIndex:t.leftJustifiedTextSymbolIndex>=0?t.leftJustifiedTextSymbolIndex:t.verticalPlacedTextSymbolIndex>=0?t.verticalPlacedTextSymbolIndex:r),o=fp(this.textSizeData,e,n)/24;return this.tilePixelRatio*o}getSymbolInstanceIconSize(e,t,i){const r=this.icon.placedSymbolArray.get(i),n=fp(this.iconSizeData,e,r);return this.tilePixelRatio*n}_commitDebugCollisionVertexUpdate(e,t,i){e.emplaceBack(t,-i,-i),e.emplaceBack(t,i,-i),e.emplaceBack(t,i,i),e.emplaceBack(t,-i,i)}_updateTextDebugCollisionBoxes(e,t,i,r,n,o){for(let a=r;a<n;a++){const r=i.get(a),n=this.getSymbolInstanceTextSize(e,o,t,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,n,r.padding)}}_updateIconDebugCollisionBoxes(e,t,i,r,n,o){for(let a=r;a<n;a++){const r=i.get(a),n=this.getSymbolInstanceIconSize(e,t,o);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,n,r.padding)}}updateCollisionDebugBuffers(e,t){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const i=mp(this.iconSizeData,e),r=mp(this.textSizeData,e);for(let n=0;n<this.symbolInstances.length;n++){const o=this.symbolInstances.get(n);this._updateTextDebugCollisionBoxes(r,e,t,o.textBoxStartIndex,o.textBoxEndIndex,o),this._updateTextDebugCollisionBoxes(r,e,t,o.verticalTextBoxStartIndex,o.verticalTextBoxEndIndex,o),this._updateIconDebugCollisionBoxes(i,e,t,o.iconBoxStartIndex,o.iconBoxEndIndex,o.placedIconSymbolIndex),this._updateIconDebugCollisionBoxes(i,e,t,o.verticalIconBoxStartIndex,o.verticalIconBoxEndIndex,o.placedIconSymbolIndex)}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt)}_deserializeCollisionBoxesForSymbol(e,t,i,r,n,o,a,s,l){const c={};if(t<i){const{x1:i,y1:r,x2:n,y2:o,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(t);c.textBox={x1:i,y1:r,x2:n,y2:o,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.textFeatureIndex=p}if(r<n){const{x1:t,y1:i,x2:n,y2:o,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(r);c.verticalTextBox={x1:t,y1:i,x2:n,y2:o,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.verticalTextFeatureIndex=p}if(o<a){const{x1:t,y1:i,x2:r,y2:n,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(o);c.iconBox={x1:t,y1:i,x2:r,y2:n,padding:a,projectedAnchorX:s,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.iconFeatureIndex=p}if(s<l){const{x1:t,y1:i,x2:r,y2:n,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d,featureIndex:p}=e.get(s);c.verticalIconBox={x1:t,y1:i,x2:r,y2:n,padding:o,projectedAnchorX:a,projectedAnchorY:l,projectedAnchorZ:u,tileAnchorX:h,tileAnchorY:d},c.verticalIconFeatureIndex=p}return c}deserializeCollisionBoxes(e){this.collisionArrays=[];for(let t=0;t<this.symbolInstances.length;t++){const i=this.symbolInstances.get(t);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(e,i.textBoxStartIndex,i.textBoxEndIndex,i.verticalTextBoxStartIndex,i.verticalTextBoxEndIndex,i.iconBoxStartIndex,i.iconBoxEndIndex,i.verticalIconBoxStartIndex,i.verticalIconBoxEndIndex))}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}hasIconTextFit(){return this.hasAnyIconTextFit}addIndicesForPlacedSymbol(e,t){const i=e.placedSymbolArray.get(t),r=i.vertexStartIndex+4*i.numGlyphs;for(let t=i.vertexStartIndex;t<r;t+=4)e.indexArray.emplaceBack(t,t+1,t+2),e.indexArray.emplaceBack(t+1,t+2,t+3)}getSortedSymbolIndexes(e){if(this.sortedAngle===e&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const t=Math.sin(e),i=Math.cos(e),r=[],n=[],o=[];for(let e=0;e<this.symbolInstances.length;++e){o.push(e);const a=this.symbolInstances.get(e);r.push(0|Math.round(t*a.tileAnchorX+i*a.tileAnchorY)),n.push(a.featureIndex)}return o.sort(((e,t)=>r[e]-r[t]||n[t]-n[e])),o}getSortedIndexesByZOffset(){if(!this.zOffsetSortDirty)return this.symbolInstanceIndexesSortedZOffset;if(!this.symbolInstanceIndexesSortedZOffset){this.symbolInstanceIndexesSortedZOffset=[];for(let e=0;e<this.symbolInstances.length;++e)this.symbolInstanceIndexesSortedZOffset.push(e)}return this.zOffsetSortDirty=!1,this.symbolInstanceIndexesSortedZOffset.sort(((e,t)=>this.symbolInstances.get(t).zOffset-this.symbolInstances.get(e).zOffset))}addToSortKeyRanges(e,t){const i=this.sortKeyRanges[this.sortKeyRanges.length-1];i&&i.sortKey===t?i.symbolInstanceEnd=e+1:this.sortKeyRanges.push({sortKey:t,symbolInstanceStart:e,symbolInstanceEnd:e+1})}sortFeatures(e){if(this.sortFeaturesByY&&this.sortedAngle!==e&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(e),this.sortedAngle=e,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const e of this.symbolInstanceIndexes){const t=this.symbolInstances.get(e);this.featureSortOrder.push(t.featureIndex);const{rightJustifiedTextSymbolIndex:i,centerJustifiedTextSymbolIndex:r,leftJustifiedTextSymbolIndex:n,verticalPlacedTextSymbolIndex:o,placedIconSymbolIndex:a,verticalPlacedIconSymbolIndex:s}=t;i>=0&&this.addIndicesForPlacedSymbol(this.text,i),r>=0&&r!==i&&this.addIndicesForPlacedSymbol(this.text,r),n>=0&&n!==r&&n!==i&&this.addIndicesForPlacedSymbol(this.text,n),o>=0&&this.addIndicesForPlacedSymbol(this.text,o),a>=0&&this.addIndicesForPlacedSymbol(this.icon,a),s>=0&&this.addIndicesForPlacedSymbol(this.icon,s)}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray)}}}Fo(SymbolBucket,"SymbolBucket",{omit:["layers","collisionBoxArray","features","compareText"]}),SymbolBucket.MAX_GLYPHS=65535,SymbolBucket.addDynamicAttributes=of;var sf=SymbolBucket;const lf=ha([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:cf}=lf,uf=ha([{name:"a_packed",components:4,type:"Float32"}]),{members:hf}=uf,df=vd.types,pf=Math.cos(Math.PI/180*37.5);class LineBucket{constructor(e){this.zoom=e.zoom,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.fqid)),this.index=e.index,this.projection=e.projection,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach((e=>{this.gradients[e.id]={}})),this.layoutVertexArray=new StructArrayLayout2i4ub1f12,this.layoutVertexArray2=new StructArrayLayout4f16,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom),this.segments=new SegmentVector,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id))}populate(e,t,i,r){this.hasPattern=Jh("line",this.layers,t);const n=this.layers[0].layout.get("line-sort-key"),o=[];for(const{feature:t,id:a,index:s,sourceLayerIndex:l}of e){const e=this.layers[0]._featureFilter.needGeometry,c=ku(t,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),c,i))continue;const u=n?n.evaluate(c,{},i):void 0,h={id:a,properties:t.properties,type:t.type,sourceLayerIndex:l,index:s,geometry:e?c.geometry:Ru(t,i,r),patterns:{},sortKey:u};o.push(h)}n&&o.sort(((e,t)=>e.sortKey-t.sortKey));const{lineAtlas:a,featureIndex:s}=t,l=this.addConstantDashes(a);for(const r of o){const{geometry:n,index:o,sourceLayerIndex:c}=r;if(l&&this.addFeatureDashes(r,a),this.hasPattern){const e=Qh("line",this.layers,r,this.zoom,t);this.patternFeatures.push(e)}else this.addFeature(r,n,o,i,a.positions,t.availableImages,t.brightness);s.insert(e[o].feature,n,o,c,this.index)}}addConstantDashes(e){let t=!1;for(const i of this.layers){const r=i.paint.get("line-dasharray").value,n=i.layout.get("line-cap").value;if("constant"!==r.kind||"constant"!==n.kind)t=!0;else{const t=n.value,i=r.value;if(!i)continue;e.addDash(i,t)}}return t}addFeatureDashes(e,t){const i=this.zoom;for(const r of this.layers){const n=r.paint.get("line-dasharray").value,o=r.layout.get("line-cap").value;if("constant"===n.kind&&"constant"===o.kind)continue;let a,s;if("constant"===n.kind){if(a=n.value,!a)continue}else a=n.evaluate({zoom:i},e);s="constant"===o.kind?o.value:o.evaluate({zoom:i},e),t.addDash(a,s),e.patterns[r.id]=t.getKey(a,s)}}update(e,t,i,r,n){const o=0!==Object.keys(e).length;o&&!this.stateDependentLayers.length||this.programConfigurations.updatePaintArrays(e,t,o?this.stateDependentLayers:this.layers,i,r,n)}addFeatures(e,t,i,r,n,o){for(const e of this.patternFeatures)this.addFeature(e,e.geometry,e.index,t,i,r,o)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload}upload(e){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=e.createVertexBuffer(this.layoutVertexArray2,hf)),this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,cf),this.indexBuffer=e.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(e),this.uploaded=!0}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}lineFeatureClips(e){if(e.properties&&e.properties.hasOwnProperty("mapbox_clip_start")&&e.properties.hasOwnProperty("mapbox_clip_end"))return{start:+e.properties.mapbox_clip_start,end:+e.properties.mapbox_clip_end}}addFeature(e,t,i,r,n,o,a){const s=this.layers[0].layout,l=s.get("line-join").evaluate(e,{}),c=s.get("line-cap").evaluate(e,{}),u=s.get("line-miter-limit"),h=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(e);for(const i of t)this.addLine(i,e,l,c,u,h);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,n,o,r,a)}addLine(e,t,i,r,n,o){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let t=0;t<e.length-1;t++)this.totalDistance+=e[t].dist(e[t+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance)}const a="Polygon"===df[t.type];let s=e.length;for(;s>=2&&e[s-1].equals(e[s-2]);)s--;let l=0;for(;l<s-1&&e[l].equals(e[l+1]);)l++;if(s<(a?3:2))return;"bevel"===i&&(n=1.05);const c=this.overscaling<=16?15*Ri/(512*this.overscaling):0,u=this.segments.prepareSegment(10*s,this.layoutVertexArray,this.indexArray);let h,d,p,f,m;this.e1=this.e2=-1,a&&(h=e[s-2],m=e[l].sub(h)._unit()._perp());for(let t=l;t<s;t++){if(p=t===s-1?a?e[l+1]:void 0:e[t+1],p&&e[t].equals(p))continue;m&&(f=m),h&&(d=h),h=e[t],m=p?p.sub(h)._unit()._perp():f,f=f||m;let _=f.add(m);0===_.x&&0===_.y||_._unit();const g=f.x*m.x+f.y*m.y,y=_.x*m.x+_.y*m.y,x=0!==y?1/y:1/0,v=2*Math.sqrt(2-2*y),b=y<pf&&d&&p,w=f.x*m.y-f.y*m.x>0;if(b&&t>l){const e=h.dist(d);if(e>2*c){const t=h.sub(h.sub(d)._mult(c/e)._round());this.updateDistance(d,t),this.addCurrentVertex(t,f,0,0,u),d=t}}const T=d&&p;let E=T?i:a?"butt":r;if(T&&"round"===E&&(x<o?E="miter":x<=2&&(E="fakeround")),"miter"===E&&x>n&&(E="bevel"),"bevel"===E&&(x>2&&(E="flipbevel"),x<n&&(E="miter")),d&&this.updateDistance(d,h),"miter"===E)_._mult(x),this.addCurrentVertex(h,_,0,0,u);else if("flipbevel"===E){if(x>100)_=m.mult(-1);else{const e=x*f.add(m).mag()/f.sub(m).mag();_._perp()._mult(e*(w?-1:1))}this.addCurrentVertex(h,_,0,0,u),this.addCurrentVertex(h,_.mult(-1),0,0,u)}else if("bevel"===E||"fakeround"===E){const e=-Math.sqrt(x*x-1),t=w?e:0,i=w?0:e;if(d&&this.addCurrentVertex(h,f,t,i,u),"fakeround"===E){const e=Math.round(180*v/Math.PI/20);for(let t=1;t<e;t++){let i=t/e;if(.5!==i){const e=i-.5;i+=i*e*(i-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*e*e+(.848013+g*(.215638*g-1.06021)))}const r=m.sub(f)._mult(i)._add(f)._unit()._mult(w?-1:1);this.addHalfVertex(h,r.x,r.y,!1,w,0,u)}}p&&this.addCurrentVertex(h,m,-t,-i,u)}else if("butt"===E)this.addCurrentVertex(h,_,0,0,u);else if("square"===E){const e=d?1:-1;d||this.addCurrentVertex(h,_,e,e,u),this.addCurrentVertex(h,_,0,0,u),d&&this.addCurrentVertex(h,_,e,e,u)}else"round"===E&&(d&&(this.addCurrentVertex(h,f,0,0,u),this.addCurrentVertex(h,f,1,1,u,!0)),p&&(this.addCurrentVertex(h,m,-1,-1,u,!0),this.addCurrentVertex(h,m,0,0,u)));if(b&&t<s-1){const e=h.dist(p);if(e>2*c){const t=h.add(p.sub(h)._mult(c/e)._round());this.updateDistance(h,t),this.addCurrentVertex(t,m,0,0,u),h=t}}}}addCurrentVertex(e,t,i,r,n,o=!1){const a=t.y*r-t.x,s=-t.y-t.x*r;this.addHalfVertex(e,t.x+t.y*i,t.y-t.x*i,o,!1,i,n),this.addHalfVertex(e,a,s,o,!0,-r,n)}addHalfVertex({x:e,y:t},i,r,n,o,a,s){this.layoutVertexArray.emplaceBack((e<<1)+(n?1:0),(t<<1)+(o?1:0),Math.round(63*i)+128,Math.round(63*r)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length,this.lineClips.start,this.lineClips.end);const l=s.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),s.primitiveLength++),o?this.e2=l:this.e1=l}updateScaledDistance(){if(this.lineClips){const e=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=e*this.lineClips.start+this.distance}else this.lineSoFar=this.distance}updateDistance(e,t){this.distance+=e.dist(t),this.updateScaledDistance()}}Fo(LineBucket,"LineBucket",{omit:["layers","patternFeatures"]});class Texture{constructor(e,t,i,r){this.context=e,this.format=i,this.texture=e.gl.createTexture(),this.update(t,r)}update(t,i,r){const{width:n,height:o}=t,{context:a}=this,{gl:s}=a,{HTMLImageElement:l,HTMLCanvasElement:c,HTMLVideoElement:u,ImageData:h,ImageBitmap:d}=e;if(s.bindTexture(s.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===s.RGBA&&(!i||!1!==i.premultiply)),r||this.size&&this.size[0]===n&&this.size[1]===o){const{x:e,y:i}=r||{x:0,y:0};if(t instanceof l||t instanceof c||t instanceof u||t instanceof h||d&&t instanceof d)s.texSubImage2D(s.TEXTURE_2D,0,e,i,s.RGBA,s.UNSIGNED_BYTE,t);else{let r=this.format,a=s.UNSIGNED_BYTE;this.format===s.R32F&&(r=s.RED,a=s.FLOAT),s.texSubImage2D(s.TEXTURE_2D,0,e,i,n,o,r,a,t.data)}}else if(this.size=[n,o],t instanceof l||t instanceof c||t instanceof u||t instanceof h||d&&t instanceof d){let e=this.format;this.format===s.R8&&(e=s.RED),s.texImage2D(s.TEXTURE_2D,0,this.format,e,s.UNSIGNED_BYTE,t)}else{let e=this.format,i=this.format,r=s.UNSIGNED_BYTE;this.format===s.DEPTH_COMPONENT&&(e=s.DEPTH_COMPONENT16,r=s.UNSIGNED_SHORT),this.format===s.R32F&&(r=s.FLOAT,i=s.RED),s.texImage2D(s.TEXTURE_2D,0,e,n,o,0,i,r,t.data)}this.useMipmap=Boolean(i&&i.useMipmap),this.useMipmap&&s.generateMipmap(s.TEXTURE_2D)}bind(e,t){const{context:i}=this,{gl:r}=i;r.bindTexture(r.TEXTURE_2D,this.texture),e!==this.minFilter&&(r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,e),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,this.useMipmap?e===r.NEAREST?r.NEAREST_MIPMAP_NEAREST:r.LINEAR_MIPMAP_NEAREST:e),this.minFilter=e),t!==this.wrapS&&(r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,t),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,t),this.wrapS=t)}bindExtraParam(e,t,i,r){const{context:n}=this,{gl:o}=n;o.bindTexture(o.TEXTURE_2D,this.texture),t!==this.magFilter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,t),this.magFilter=t),e!==this.minFilter&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,this.useMipmap?e===o.NEAREST?o.NEAREST_MIPMAP_NEAREST:o.LINEAR_MIPMAP_NEAREST:e),this.minFilter=e),i!==this.wrapS&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,i),this.wrapS=i),r!==this.wrapT&&(o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,r),this.wrapT=r)}destroy(){const{gl:e}=this.context;e.deleteTexture(this.texture),this.texture=null}}class UserManagedTexture{constructor(e,t){this.context=e,this.texture=t}bind(e,t){const{context:i}=this,{gl:r}=i;r.bindTexture(r.TEXTURE_2D,this.texture),e!==this.minFilter&&(r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MAG_FILTER,e),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_MIN_FILTER,e),this.minFilter=e),t!==this.wrapS&&(r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_S,t),r.texParameteri(r.TEXTURE_2D,r.TEXTURE_WRAP_T,t),this.wrapS=t)}}const ff=32,mf=33,_f=new Uint16Array(8184);for(let e=0;e<2046;e++){let t=e+2,i=0,r=0,n=0,o=0,a=0,s=0;for(1&t?n=o=a=ff:i=r=s=ff;(t>>=1)>1;){const e=i+n>>1,l=r+o>>1;1&t?(n=i,o=r,i=a,r=s):(i=n,r=o,n=a,o=s),a=e,s=l}const l=4*e;_f[l+0]=i,_f[l+1]=r,_f[l+2]=n,_f[l+3]=o}const gf=new Uint16Array(2178),yf=new Uint8Array(1089),xf=new Uint16Array(1089);function vf(e){return 0===e?-.03125:32===e?.03125:0}var bf=ha([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);const wf={type:2,extent:Ri,loadGeometry:()=>[[new g(0,0),new g(Ri+1,0),new g(Ri+1,Ri+1),new g(0,Ri+1),new g(0,0)]]};class Tile{constructor(e,t,i,r,n){this.tileID=e,this.uid=B(),this.uses=0,this.tileSize=t,this.tileZoom=i,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.isRaster=n,r&&r.style&&(this._lastUpdatedBrightness=r.style.getBrightness()),this.expiredRequestCount=0,this.state="loading",r&&r.transform&&(this.projection=r.transform.projection)}registerFadeDuration(e){const t=e+this.timeAdded;t<rt.now()||this.fadeEndTime&&t<this.fadeEndTime||(this.fadeEndTime=t)}wasRequested(){return"errored"===this.state||"loaded"===this.state||"reloading"===this.state}get tileTransform(){return this._tileTransform||(this._tileTransform=kp(this.tileID.canonical,this.projection)),this._tileTransform}loadVectorData(e,t,i){if(this.unloadVectorData(),this.state="loaded",e){e.featureIndex&&(this.latestFeatureIndex=e.featureIndex,e.rawTileData?(this.latestRawTileData=e.rawTileData,this.latestFeatureIndex.rawTileData=e.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=e.collisionBoxArray,this.buckets=function(e,t){const i={};if(!t)return i;for(const r of e){const e=r.layerIds.map((e=>t.getLayer(e))).filter(Boolean);if(0!==e.length){r.layers=e,r.stateDependentLayerIds&&(r.stateDependentLayers=r.stateDependentLayerIds.map((t=>e.filter((e=>e.id===t))[0])));for(const t of e)i[t.fqid]=r}}return i}(e.buckets,t.style),this.hasSymbolBuckets=!1;for(const e in this.buckets){const t=this.buckets[e];if(t instanceof sf){if(this.hasSymbolBuckets=!0,!i)break;t.justReloaded=!0}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const e in this.buckets){const t=this.buckets[e];if(t instanceof sf&&t.hasRTLText){this.hasRTLText=!0,aa.isLoading()||aa.isLoaded()||"deferred"!==na()||oa();break}}this.queryPadding=0;for(const e in this.buckets){const i=this.buckets[e],r=t.style.getOwnLayer(e);if(!r)continue;const n=r.queryRadius(i);this.queryPadding=Math.max(this.queryPadding,n)}e.imageAtlas&&(this.imageAtlas=e.imageAtlas),e.glyphAtlasImage&&(this.glyphAtlasImage=e.glyphAtlasImage),e.lineAtlas&&(this.lineAtlas=e.lineAtlas),this._lastUpdatedBrightness=e.brightness}else this.collisionBoxArray=new CollisionBoxArray}unloadVectorData(){if(this.hasData()){for(const e in this.buckets)this.buckets[e].destroy();this.buckets={},this.imageAtlas&&(this.imageAtlas=null),this.lineAtlas&&(this.lineAtlas=null),this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.lineAtlasTexture&&this.lineAtlasTexture.destroy(),this._tileBoundsBuffer&&(this._tileBoundsBuffer.destroy(),this._tileBoundsIndexBuffer.destroy(),this._tileBoundsSegments.destroy(),this._tileBoundsBuffer=null),this._tileDebugBuffer&&(this._tileDebugBuffer.destroy(),this._tileDebugSegments.destroy(),this._tileDebugBuffer=null),this._tileDebugIndexBuffer&&(this._tileDebugIndexBuffer.destroy(),this._tileDebugIndexBuffer=null),this._globeTileDebugBorderBuffer&&(this._globeTileDebugBorderBuffer.destroy(),this._globeTileDebugBorderBuffer=null),this._tileDebugTextBuffer&&(this._tileDebugTextBuffer.destroy(),this._tileDebugTextSegments.destroy(),this._tileDebugTextIndexBuffer.destroy(),this._tileDebugTextBuffer=null),this._globeTileDebugTextBuffer&&(this._globeTileDebugTextBuffer.destroy(),this._globeTileDebugTextBuffer=null),this.latestFeatureIndex=null,this.state="unloaded"}}getBucket(e){return this.buckets[e.fqid]}upload(e){for(const t in this.buckets){const i=this.buckets[t];i.uploadPending()&&i.upload(e)}const t=e.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Texture(e,this.imageAtlas.image,t.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Texture(e,this.glyphAtlasImage,t.ALPHA),this.glyphAtlasImage=null),this.lineAtlas&&!this.lineAtlas.uploaded&&(this.lineAtlasTexture=new Texture(e,this.lineAtlas.image,t.ALPHA),this.lineAtlas.uploaded=!0)}prepare(e,t,i){if(this.imageAtlas&&this.imageAtlas.patchUpdatedImages(e,this.imageAtlasTexture,i),!t||!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData)return;const r=t.style.getBrightness();(this._lastUpdatedBrightness||r)&&(this._lastUpdatedBrightness&&r&&Math.abs(this._lastUpdatedBrightness-r)<.001||(this._lastUpdatedBrightness=r,this.updateBuckets(void 0,t)))}queryRenderedFeatures(e,t,i,r,n,o,a,s){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:r,pixelPosMatrix:a,transform:o,params:n,tileTransform:this.tileTransform},e,t,i):{}}querySourceFeatures(e,t){const i=this.latestFeatureIndex;if(!i||!i.rawTileData)return;const r=i.loadVTLayers(),n=t?t.sourceLayer:"",o=r._geojsonTileLayer||r[n];if(!o)return;const a=jn(t&&t.filter),{z:s,x:l,y:c}=this.tileID.canonical,u={z:s,x:l,y:c};for(let t=0;t<o.length;t++){const r=o.feature(t);if(a.needGeometry){const e=ku(r,!0);if(!a.filter(new EvaluationParameters(this.tileID.overscaledZ),e,this.tileID.canonical))continue}else if(!a.filter(new EvaluationParameters(this.tileID.overscaledZ),r))continue;const h=i.getId(r,n),d=new Feature(r,s,l,c,h);d.tile=u,e.push(d)}}hasData(){return"loaded"===this.state||"reloading"===this.state||"expired"===this.state}bucketsLoaded(){for(const e in this.buckets)if(this.buckets[e].uploadPending())return!1;return!0}patternsLoaded(){return!!this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(e){const t=this.expirationTime;if(e.cacheControl){const t=J(e.cacheControl);t["max-age"]&&(this.expirationTime=Date.now()+1e3*t["max-age"])}else e.expires&&(this.expirationTime=new Date(e.expires).getTime());if(this.expirationTime){const e=Date.now();let i=!1;if(this.expirationTime>e)i=!1;else if(t)if(this.expirationTime<t)i=!0;else{const r=this.expirationTime-t;r?this.expirationTime=e+Math.max(r,3e4):i=!0}else i=!0;i?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(e,t){this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData&&0!==Object.keys(e).length&&t&&this.updateBuckets(e,t)}updateBuckets(e,t){if(!this.latestFeatureIndex)return;const i=this.latestFeatureIndex.loadVTLayers(),r=t.style.listImages(),n=t.style.getBrightness();for(const o in this.buckets){if(!t.style.hasLayer(o))continue;const a=this.buckets[o],s=a.layers[0].sourceLayer||"_geojsonTileLayer",l=i[s];let c={};if(e&&(c=e[s],!l||!c||0===Object.keys(c).length))continue;if(a.update(c,l,r,this.imageAtlas&&this.imageAtlas.patternPositions||{},n),a instanceof LineBucket||a instanceof FillBucket){const e=t.style.getOwnSourceCache(a.layers[0].source);t._terrain&&t._terrain.enabled&&e&&a.programConfigurations.needsUpload&&t._terrain._clearRenderCacheForTile(e.id,this.tileID)}const u=t&&t.style&&t.style.getOwnLayer(o);u&&(this.queryPadding=Math.max(this.queryPadding,u.queryRadius(a)))}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return!this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<rt.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0}setHoldDuration(e){this.symbolFadeHoldUntil=rt.now()+e}setTexture(e,t){const i=t.context,r=i.gl;this.texture=this.texture||t.getTileTexture(e.width),this.texture?this.texture.update(e,{useMipmap:!0}):(this.texture=new Texture(i,e,r.RGBA,{useMipmap:!0}),this.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE))}setDependencies(e,t){const i={};for(const e of t)i[e]=!0;this.dependencies[e]=i}hasDependency(e,t){for(const i of e){const e=this.dependencies[i];if(e)for(const i of t)if(e[i])return!0}return!1}clearQueryDebugViz(){}_makeDebugTileBoundsBuffers(e,t){if(!t||"mercator"===t.name||this._tileDebugBuffer)return;const i=Ru(wf,this.tileID.canonical,this.tileTransform)[0],r=new StructArrayLayout2i4,n=new StructArrayLayout1ui2;for(let e=0;e<i.length;e++){const{x:t,y:o}=i[e];r.emplaceBack(t,o),n.emplaceBack(e)}n.emplaceBack(0),this._tileDebugIndexBuffer=e.createIndexBuffer(n),this._tileDebugBuffer=e.createVertexBuffer(r,mc.members),this._tileDebugSegments=SegmentVector.simpleSegment(0,0,r.length,n.length)}_makeTileBoundsBuffers(e,t){if(this._tileBoundsBuffer||!t||"mercator"===t.name)return;const i=Ru(wf,this.tileID.canonical,this.tileTransform)[0];let r,n;if(this.isRaster){const e=function(e,t){const i=kp(e,t),r=Math.pow(2,e.z);for(let n=0;n<mf;n++)for(let o=0;o<mf;o++){const a=xu((e.x+(o+vf(o))/ff)/r),s=vu((e.y+(n+vf(n))/ff)/r),l=t.project(a,s),c=n*mf+o;gf[2*c+0]=Math.round((l.x*i.scale-i.x)*Ri),gf[2*c+1]=Math.round((l.y*i.scale-i.y)*Ri)}yf.fill(0),xf.fill(0);for(let e=2045;e>=0;e--){const t=4*e,i=_f[t+0],r=_f[t+1],n=_f[t+2],o=_f[t+3],a=i+n>>1,s=r+o>>1,l=a+s-r,c=s+i-a,u=r*mf+i,h=o*mf+n,d=s*mf+a,p=Math.hypot((gf[2*u+0]+gf[2*h+0])/2-gf[2*d+0],(gf[2*u+1]+gf[2*h+1])/2-gf[2*d+1])>=16;yf[d]=yf[d]||(p?1:0),e<1022&&(yf[d]=yf[d]||yf[(r+c>>1)*mf+(i+l>>1)]||yf[(o+c>>1)*mf+(n+l>>1)])}const n=new StructArrayLayout4i8,o=new StructArrayLayout3ui6;let a=0;function s(e,t){const i=t*mf+e;return 0===xf[i]&&(n.emplaceBack(gf[2*i+0],gf[2*i+1],e*Ri/ff,t*Ri/ff),xf[i]=++a),xf[i]-1}function l(e,t,i,r,n,a){const c=e+i>>1,u=t+r>>1;if(Math.abs(e-n)+Math.abs(t-a)>1&&yf[u*mf+c])l(n,a,e,t,c,u),l(i,r,n,a,c,u);else{const l=s(e,t),c=s(i,r),u=s(n,a);o.emplaceBack(l,c,u)}}return l(0,0,ff,ff,ff,0),l(ff,ff,0,0,0,ff),{vertices:n,indices:o}}(this.tileID.canonical,t);r=e.vertices,n=e.indices}else{r=new StructArrayLayout4i8,n=new StructArrayLayout3ui6;for(const{x:e,y:t}of i)r.emplaceBack(e,t,0,0);const e=Xh(r.int16,void 0,4);for(let t=0;t<e.length;t+=3)n.emplaceBack(e[t],e[t+1],e[t+2])}this._tileBoundsBuffer=e.createVertexBuffer(r,bf.members),this._tileBoundsIndexBuffer=e.createIndexBuffer(n),this._tileBoundsSegments=SegmentVector.simpleSegment(0,0,r.length,n.length)}_makeGlobeTileDebugBuffers(e,t){const i=t.projection;if(!i||"globe"!==i.name||t.freezeTileCoverage)return;const r=this.tileID.canonical,n=Wc(Fc(r,t)),o=Qc(t.zoom);let a;o>0&&(a=ic.invert(new Float64Array(16),t.globeMatrix)),this._makeGlobeTileDebugBorderBuffer(e,r,t,n,a,o),this._makeGlobeTileDebugTextBuffer(e,r,t,n,a,o)}_globePoint(e,t,i,r,n,o,a){let s=Zc(e,t,i);if(o){const n=1<<i.z,l=_u(r.center.lng),c=gu(r.center.lat),u=(i.x+.5)/n-l;let h=0;u>.5?h=-1:u<-.5&&(h=1);let d=(e/Ri+i.x)/n+h,p=(t/Ri+i.y)/n;d=(d-l)*r._pixelsPerMercatorPixel+l,p=(p-c)*r._pixelsPerMercatorPixel+c;const f=[d*r.worldSize,p*r.worldSize,0];lc.transformMat4(f,f,o),s=Oc(s,f,a)}return lc.transformMat4(s,s,n)}_makeGlobeTileDebugBorderBuffer(e,t,i,r,n,o){const a=new StructArrayLayout2i4,s=new StructArrayLayout1ui2,l=new StructArrayLayout3i6,c=(e,c,u,h,d)=>{const p=(u-e)/(d-1),f=(h-c)/(d-1),m=a.length;for(let u=0;u<d;u++){const h=e+u*p,d=c+u*f;a.emplaceBack(h,d);const _=this._globePoint(h,d,t,i,r,n,o);l.emplaceBack(_[0],_[1],_[2]),s.emplaceBack(m+u)}},u=Ri;c(0,0,u,0,16),c(u,0,u,u,16),c(u,u,0,u,16),c(0,u,0,0,16),this._tileDebugIndexBuffer=e.createIndexBuffer(s),this._tileDebugBuffer=e.createVertexBuffer(a,mc.members),this._globeTileDebugBorderBuffer=e.createVertexBuffer(l,fc.members),this._tileDebugSegments=SegmentVector.simpleSegment(0,0,a.length,s.length)}_makeGlobeTileDebugTextBuffer(e,t,i,r,n,o){const a=Ri/4,s=new StructArrayLayout2i4,l=new StructArrayLayout3ui6,c=new StructArrayLayout3i6,u=25;l.reserve(32),s.reserve(u),c.reserve(u);const h=(e,t)=>u*e+t;for(let e=0;e<u;e++){const l=e*a;for(let e=0;e<u;e++){const u=e*a;s.emplaceBack(u,l);const h=this._globePoint(u,l,t,i,r,n,o);c.emplaceBack(h[0],h[1],h[2])}}for(let e=0;e<4;e++)for(let t=0;t<4;t++){const i=h(e,t),r=h(e,t+1),n=h(e+1,t),o=h(e+1,t+1);l.emplaceBack(i,r,n),l.emplaceBack(n,r,o)}this._tileDebugTextIndexBuffer=e.createIndexBuffer(l),this._tileDebugTextBuffer=e.createVertexBuffer(s,mc.members),this._globeTileDebugTextBuffer=e.createVertexBuffer(c,fc.members),this._tileDebugTextSegments=SegmentVector.simpleSegment(0,0,u,32)}}class TileCache{constructor(e,t){this.max=e,this.onRemove=t,this.reset()}reset(){for(const e in this.data)for(const t of this.data[e])t.timeout&&clearTimeout(t.timeout),this.onRemove(t.value);return this.data={},this.order=[],this}add(e,t,i){const r=e.wrapped().key;void 0===this.data[r]&&(this.data[r]=[]);const n={value:t,timeout:void 0};if(void 0!==i&&(n.timeout=setTimeout((()=>{this.remove(e,n)}),i)),this.data[r].push(n),this.order.push(r),this.order.length>this.max){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e)}return this}has(e){return e.wrapped().key in this.data}getAndRemove(e){return this.has(e)?this._getAndRemoveByKey(e.wrapped().key):null}_getAndRemoveByKey(e){const t=this.data[e].shift();return t.timeout&&clearTimeout(t.timeout),0===this.data[e].length&&delete this.data[e],this.order.splice(this.order.indexOf(e),1),t.value}getByKey(e){const t=this.data[e];return t?t[0].value:null}get(e){return this.has(e)?this.data[e.wrapped().key][0].value:null}remove(e,t){if(!this.has(e))return this;const i=e.wrapped().key,r=void 0===t?0:this.data[i].indexOf(t),n=this.data[i][r];return this.data[i].splice(r,1),n.timeout&&clearTimeout(n.timeout),0===this.data[i].length&&delete this.data[i],this.onRemove(n.value),this.order.splice(this.order.indexOf(i),1),this}setMaxSize(e){for(this.max=e;this.order.length>this.max;){const e=this._getAndRemoveByKey(this.order[0]);e&&this.onRemove(e)}return this}filter(e){const t=[];for(const i in this.data)for(const r of this.data[i])e(r.value)||t.push(r);for(const e of t)this.remove(e.value.tileID,e)}}class IndexBuffer{constructor(e,t,i,r){this.id=IndexBuffer.uniqueIdxCounter,IndexBuffer.uniqueIdxCounter++,this.context=e;const n=e.gl;this.buffer=n.createBuffer(),this.dynamicDraw=Boolean(i),this.context.unbindVAO(),e.bindElementBuffer.set(this.buffer),n.bufferData(n.ELEMENT_ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||r||t.destroy()}bind(){this.context.bindElementBuffer.set(this.buffer)}updateData(e){this.id=IndexBuffer.uniqueIdxCounter,IndexBuffer.uniqueIdxCounter++;const t=this.context.gl;this.context.unbindVAO(),this.bind(),t.bufferSubData(t.ELEMENT_ARRAY_BUFFER,0,e.arrayBuffer)}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}IndexBuffer.uniqueIdxCounter=0;const Tf={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class VertexBuffer{constructor(e,t,i,r,n,o){this.length=t.length,this.attributes=i,this.itemSize=t.bytesPerElement,this.dynamicDraw=r,this.instanceCount=o,this.context=e;const a=e.gl;this.buffer=a.createBuffer(),e.bindVertexBuffer.set(this.buffer),a.bufferData(a.ARRAY_BUFFER,t.arrayBuffer,this.dynamicDraw?a.DYNAMIC_DRAW:a.STATIC_DRAW),this.dynamicDraw||n||t.destroy()}bind(){this.context.bindVertexBuffer.set(this.buffer)}updateData(e){const t=this.context.gl;this.bind(),t.bufferSubData(t.ARRAY_BUFFER,0,e.arrayBuffer)}enableAttributes(e,t){for(let i=0;i<this.attributes.length;i++){const r=t.attributes[this.attributes[i].name];void 0!==r&&e.enableVertexAttribArray(r)}}setVertexAttribPointers(e,t,i){for(let r=0;r<this.attributes.length;r++){const n=this.attributes[r],o=t.attributes[n.name];void 0!==o&&e.vertexAttribPointer(o,n.components,e[Tf[n.type]],!1,this.itemSize,n.offset+this.itemSize*(i||0))}}setVertexAttribDivisor(e,t,i){for(let r=0;r<this.attributes.length;r++){const n=t.attributes[this.attributes[r].name];void 0!==n&&this.instanceCount&&this.instanceCount>0&&e.vertexAttribDivisor(n,i)}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer)}}class BaseValue{constructor(e){this.gl=e.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1}get(){return this.current}set(e){}getDefault(){return this.default}setDefault(){this.set(this.default)}}class ClearColor extends BaseValue{getDefault(){return Wt.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.clearColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1)}}class ClearDepth extends BaseValue{getDefault(){return 1}set(e){(e!==this.current||this.dirty)&&(this.gl.clearDepth(e),this.current=e,this.dirty=!1)}}class ClearStencil extends BaseValue{getDefault(){return 0}set(e){(e!==this.current||this.dirty)&&(this.gl.clearStencil(e),this.current=e,this.dirty=!1)}}class ColorMask extends BaseValue{getDefault(){return[!0,!0,!0,!0]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.colorMask(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class DepthMask extends BaseValue{getDefault(){return!0}set(e){(e!==this.current||this.dirty)&&(this.gl.depthMask(e),this.current=e,this.dirty=!1)}}class StencilMask extends BaseValue{getDefault(){return 255}set(e){(e!==this.current||this.dirty)&&(this.gl.stencilMask(e),this.current=e,this.dirty=!1)}}class StencilFunc extends BaseValue{getDefault(){return{func:this.gl.ALWAYS,ref:0,mask:255}}set(e){const t=this.current;(e.func!==t.func||e.ref!==t.ref||e.mask!==t.mask||this.dirty)&&(this.gl.stencilFunc(e.func,e.ref,e.mask),this.current=e,this.dirty=!1)}}class StencilOp extends BaseValue{getDefault(){const e=this.gl;return[e.KEEP,e.KEEP,e.KEEP]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||this.dirty)&&(this.gl.stencilOp(e[0],e[1],e[2]),this.current=e,this.dirty=!1)}}class StencilTest extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.STENCIL_TEST):t.disable(t.STENCIL_TEST),this.current=e,this.dirty=!1}}class DepthRange extends BaseValue{getDefault(){return[0,1]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||this.dirty)&&(this.gl.depthRange(e[0],e[1]),this.current=e,this.dirty=!1)}}class DepthTest extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.DEPTH_TEST):t.disable(t.DEPTH_TEST),this.current=e,this.dirty=!1}}class DepthFunc extends BaseValue{getDefault(){return this.gl.LESS}set(e){(e!==this.current||this.dirty)&&(this.gl.depthFunc(e),this.current=e,this.dirty=!1)}}class Blend extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.BLEND):t.disable(t.BLEND),this.current=e,this.dirty=!1}}class BlendFunc extends BaseValue{getDefault(){const e=this.gl;return[e.ONE,e.ZERO,e.ONE,e.ZERO]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.blendFuncSeparate(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class BlendColor extends BaseValue{getDefault(){return Wt.transparent}set(e){const t=this.current;(e.r!==t.r||e.g!==t.g||e.b!==t.b||e.a!==t.a||this.dirty)&&(this.gl.blendColor(e.r,e.g,e.b,e.a),this.current=e,this.dirty=!1)}}class BlendEquation extends BaseValue{getDefault(){return this.gl.FUNC_ADD}set(e){(e!==this.current||this.dirty)&&(this.gl.blendEquationSeparate(e,e),this.current=e,this.dirty=!1)}}class CullFace extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;e?t.enable(t.CULL_FACE):t.disable(t.CULL_FACE),this.current=e,this.dirty=!1}}class CullFaceSide extends BaseValue{getDefault(){return this.gl.BACK}set(e){(e!==this.current||this.dirty)&&(this.gl.cullFace(e),this.current=e,this.dirty=!1)}}class FrontFace extends BaseValue{getDefault(){return this.gl.CCW}set(e){(e!==this.current||this.dirty)&&(this.gl.frontFace(e),this.current=e,this.dirty=!1)}}let Ef=class Program extends BaseValue{getDefault(){return null}set(e){(e!==this.current||this.dirty)&&(this.gl.useProgram(e),this.current=e,this.dirty=!1)}};class ActiveTextureUnit extends BaseValue{getDefault(){return this.gl.TEXTURE0}set(e){(e!==this.current||this.dirty)&&(this.gl.activeTexture(e),this.current=e,this.dirty=!1)}}class Viewport extends BaseValue{getDefault(){const e=this.gl;return[0,0,e.drawingBufferWidth,e.drawingBufferHeight]}set(e){const t=this.current;(e[0]!==t[0]||e[1]!==t[1]||e[2]!==t[2]||e[3]!==t[3]||this.dirty)&&(this.gl.viewport(e[0],e[1],e[2],e[3]),this.current=e,this.dirty=!1)}}class BindFramebuffer extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindFramebuffer(t.FRAMEBUFFER,e),this.current=e,this.dirty=!1}}class BindRenderbuffer extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindRenderbuffer(t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}class BindTexture extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindTexture(t.TEXTURE_2D,e),this.current=e,this.dirty=!1}}class BindVertexBuffer extends BaseValue{getDefault(){return null}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.bindBuffer(t.ARRAY_BUFFER,e),this.current=e,this.dirty=!1}}class BindElementBuffer extends BaseValue{getDefault(){return null}set(e){const t=this.gl;t.bindBuffer(t.ELEMENT_ARRAY_BUFFER,e),this.current=e,this.dirty=!1}}class BindVertexArrayOES extends BaseValue{getDefault(){return null}set(e){this.gl&&(e!==this.current||this.dirty)&&(this.gl.bindVertexArray(e),this.current=e,this.dirty=!1)}}class PixelStoreUnpack extends BaseValue{getDefault(){return 4}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_ALIGNMENT,e),this.current=e,this.dirty=!1}}class PixelStoreUnpackPremultiplyAlpha extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_PREMULTIPLY_ALPHA_WEBGL,e),this.current=e,this.dirty=!1}}class PixelStoreUnpackFlipY extends BaseValue{getDefault(){return!1}set(e){if(e===this.current&&!this.dirty)return;const t=this.gl;t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,e),this.current=e,this.dirty=!1}}class FramebufferAttachment extends BaseValue{constructor(e,t){super(e),this.context=e,this.parent=t}getDefault(){return null}}class ColorAttachment extends FramebufferAttachment{setDirty(){this.dirty=!0}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,t.COLOR_ATTACHMENT0,t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1}}class DepthRenderbufferAttachment extends FramebufferAttachment{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferRenderbuffer(t.FRAMEBUFFER,this.attachment(),t.RENDERBUFFER,e),this.current=e,this.dirty=!1}}class DepthTextureAttachment extends FramebufferAttachment{attachment(){return this.gl.DEPTH_ATTACHMENT}set(e){if(e===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const t=this.gl;t.framebufferTexture2D(t.FRAMEBUFFER,this.attachment(),t.TEXTURE_2D,e,0),this.current=e,this.dirty=!1}}class DepthStencilAttachment extends DepthRenderbufferAttachment{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}}class Framebuffer{constructor(e,t,i,r,n){this.context=e,this.width=t,this.height=i;const o=this.framebuffer=e.gl.createFramebuffer();r&&(this.colorAttachment=new ColorAttachment(e,o)),n&&(this.depthAttachmentType=n,this.depthAttachment="renderbuffer"===n?new DepthRenderbufferAttachment(e,o):new DepthTextureAttachment(e,o))}destroy(){const e=this.context.gl;if(this.colorAttachment){const t=this.colorAttachment.get();t&&e.deleteTexture(t)}if(this.depthAttachment&&this.depthAttachmentType)if("renderbuffer"===this.depthAttachmentType){const t=this.depthAttachment.get();t&&e.deleteRenderbuffer(t)}else{const t=this.depthAttachment.get();t&&e.deleteTexture(t)}e.deleteFramebuffer(this.framebuffer)}}class DepthMode{constructor(e,t,i){this.func=e,this.mask=t,this.range=i}}DepthMode.ReadOnly=!1,DepthMode.ReadWrite=!0,DepthMode.disabled=new DepthMode(519,DepthMode.ReadOnly,[0,1]);const Mf=7680;class StencilMode{constructor(e,t,i,r,n,o){this.test=e,this.ref=t,this.mask=i,this.fail=r,this.depthFail=n,this.pass=o}}StencilMode.disabled=new StencilMode({func:519,mask:0},0,0,Mf,Mf,Mf);const Sf=771;class ColorMode{constructor(e,t,i,r){this.blendFunction=e,this.blendColor=t,this.mask=i,this.blendEquation=r}}ColorMode.Replace=[1,0,1,0],ColorMode.disabled=new ColorMode(ColorMode.Replace,Wt.transparent,[!1,!1,!1,!1]),ColorMode.unblended=new ColorMode(ColorMode.Replace,Wt.transparent,[!0,!0,!0,!0]),ColorMode.alphaBlended=new ColorMode([1,Sf,1,Sf],Wt.transparent,[!0,!0,!0,!0]),ColorMode.multiply=new ColorMode([774,0,774,0],Wt.transparent,[!0,!0,!0,!0]);const Af=1029,Cf=2305;class CullFaceMode{constructor(e,t,i){this.enable=e,this.mode=t,this.frontFace=i}}CullFaceMode.disabled=new CullFaceMode(!1,Af,Cf),CullFaceMode.backCCW=new CullFaceMode(!0,Af,Cf),CullFaceMode.backCW=new CullFaceMode(!0,Af,2304),CullFaceMode.frontCW=new CullFaceMode(!0,1028,2304),CullFaceMode.frontCCW=new CullFaceMode(!0,1028,Cf);class Context{constructor(e){this.gl=e,this.clearColor=new ClearColor(this),this.clearDepth=new ClearDepth(this),this.clearStencil=new ClearStencil(this),this.colorMask=new ColorMask(this),this.depthMask=new DepthMask(this),this.stencilMask=new StencilMask(this),this.stencilFunc=new StencilFunc(this),this.stencilOp=new StencilOp(this),this.stencilTest=new StencilTest(this),this.depthRange=new DepthRange(this),this.depthTest=new DepthTest(this),this.depthFunc=new DepthFunc(this),this.blend=new Blend(this),this.blendFunc=new BlendFunc(this),this.blendColor=new BlendColor(this),this.blendEquation=new BlendEquation(this),this.cullFace=new CullFace(this),this.cullFaceSide=new CullFaceSide(this),this.frontFace=new FrontFace(this),this.program=new Ef(this),this.activeTexture=new ActiveTextureUnit(this),this.viewport=new Viewport(this),this.bindFramebuffer=new BindFramebuffer(this),this.bindRenderbuffer=new BindRenderbuffer(this),this.bindTexture=new BindTexture(this),this.bindVertexBuffer=new BindVertexBuffer(this),this.bindElementBuffer=new BindElementBuffer(this),this.bindVertexArrayOES=new BindVertexArrayOES(this),this.pixelStoreUnpack=new PixelStoreUnpack(this),this.pixelStoreUnpackPremultiplyAlpha=new PixelStoreUnpackPremultiplyAlpha(this),this.pixelStoreUnpackFlipY=new PixelStoreUnpackFlipY(this),this.extTextureFilterAnisotropic=e.getExtension("EXT_texture_filter_anisotropic")||e.getExtension("MOZ_EXT_texture_filter_anisotropic")||e.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=e.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extStandardDerivativesForceOff=!1,this.extDebugRendererInfo=e.getExtension("WEBGL_debug_renderer_info"),this.extDebugRendererInfo&&(this.renderer=e.getParameter(this.extDebugRendererInfo.UNMASKED_RENDERER_WEBGL),this.vendor=e.getParameter(this.extDebugRendererInfo.UNMASKED_VENDOR_WEBGL)),this.extTextureFloatLinear=e.getExtension("OES_texture_float_linear"),this.extRenderToTextureHalfFloat=e.getExtension("EXT_color_buffer_half_float"),this.extTimerQuery=e.getExtension("EXT_disjoint_timer_query_webgl2"),this.maxTextureSize=e.getParameter(e.MAX_TEXTURE_SIZE)}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault()}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.bindVertexArrayOES.dirty=!0,this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0}createIndexBuffer(e,t,i){return new IndexBuffer(this,e,t,i)}createVertexBuffer(e,t,i,r,n){return new VertexBuffer(this,e,t,i,r,n)}createRenderbuffer(e,t,i){const r=this.gl,n=r.createRenderbuffer();return this.bindRenderbuffer.set(n),r.renderbufferStorage(r.RENDERBUFFER,e,t,i),this.bindRenderbuffer.set(null),n}createFramebuffer(e,t,i,r){return new Framebuffer(this,e,t,i,r)}clear({color:e,depth:t,stencil:i,colorMask:r}){const n=this.gl;let o=0;e&&(o|=n.COLOR_BUFFER_BIT,this.clearColor.set(e),this.colorMask.set(r||[!0,!0,!0,!0])),void 0!==t&&(o|=n.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(t),this.depthMask.set(!0)),void 0!==i&&(o|=n.STENCIL_BUFFER_BIT,this.clearStencil.set(i),this.stencilMask.set(255)),n.clear(o)}setCullFace(e){!1===e.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(e.mode),this.frontFace.set(e.frontFace))}setDepthMode(e){e.func!==this.gl.ALWAYS||e.mask?(this.depthTest.set(!0),this.depthFunc.set(e.func),this.depthMask.set(e.mask),this.depthRange.set(e.range)):this.depthTest.set(!1)}setStencilMode(e){e.test.func!==this.gl.ALWAYS||e.mask?(this.stencilTest.set(!0),this.stencilMask.set(e.mask),this.stencilOp.set([e.fail,e.depthFail,e.pass]),this.stencilFunc.set({func:e.test.func,ref:e.ref,mask:e.test.mask})):this.stencilTest.set(!1)}setColorMode(e){y(e.blendFunction,ColorMode.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(e.blendFunction),this.blendColor.set(e.blendColor),e.blendEquation?this.blendEquation.set(e.blendEquation):this.blendEquation.setDefault()),this.colorMask.set(e.mask)}unbindVAO(){this.bindVertexArrayOES.set(null)}}class SourceCache extends Evented{constructor(e,t,i){super(),this.id=e,this._onlySymbols=i,t.on("data",(e=>{"source"===e.dataType&&"metadata"===e.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===e.dataType&&"content"===e.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform))})),t.on("error",(()=>{this._sourceErrored=!0})),this._source=t,this._tiles={},this._cache=new TileCache(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._minTileCacheSize=t.minTileCacheSize,this._maxTileCacheSize=t.maxTileCacheSize,this._loadedParentTiles={},this.castsShadows=!1,this._coveredTiles={},this._shadowCasterTiles={},this._state=new SourceFeatureState,this._isRaster="raster"===this._source.type||"raster-dem"===this._source.type||"custom"===this._source.type&&"raster"===this._source._dataType}onAdd(e){this.map=e,this._minTileCacheSize=void 0===this._minTileCacheSize&&e?e._minTileCacheSize:this._minTileCacheSize,this._maxTileCacheSize=void 0===this._maxTileCacheSize&&e?e._maxTileCacheSize:this._maxTileCacheSize}loaded(){if(this._sourceErrored)return!0;if(!this._sourceLoaded)return!1;if(!this._source.loaded())return!1;for(const e in this._tiles){const t=this._tiles[e];if("errored"!==t.state&&("loaded"!==t.state||!t.bucketsLoaded()))return!1}return!0}getSource(){return this._source}pause(){this._paused=!0}resume(){if(!this._paused)return;const e=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,e&&this.reload(),this.transform&&this.update(this.transform)}_loadTile(e,t){return e.isSymbolTile=this._onlySymbols,e.isExtraShadowCaster=this._shadowCasterTiles[e.tileID.key],this._source.loadTile(e,t)}_unloadTile(e){if(this._source.unloadTile)return this._source.unloadTile(e,(()=>{}))}_abortTile(e){if(this._source.abortTile)return this._source.abortTile(e,(()=>{}))}serialize(){return this._source.serialize()}prepare(e){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const t in this._tiles){const i=this._tiles[t];i.upload(e),i.prepare(this.map.style.imageManager,this.map?this.map.painter:null,this._source.scope)}}getIds(){return function(e){const t=[];for(const i in e)t.push(e[i]);return t}(this._tiles).map((e=>e.tileID)).sort(If).map((e=>e.key))}getRenderableIds(e,t){const i=[];for(const r in this._tiles)this._isIdRenderable(+r,e,t)&&i.push(this._tiles[r]);return e?i.sort(((e,t)=>{const i=e.tileID,r=t.tileID,n=new g(i.canonical.x,i.canonical.y)._rotate(this.transform.angle),o=new g(r.canonical.x,r.canonical.y)._rotate(this.transform.angle);return i.overscaledZ-r.overscaledZ||o.y-n.y||o.x-n.x})).map((e=>e.tileID.key)):i.map((e=>e.tileID)).sort(If).map((e=>e.key))}hasRenderableParent(e){const t=this.findLoadedParent(e,0);return!!t&&this._isIdRenderable(t.tileID.key)}_isIdRenderable(e,t,i){return this._tiles[e]&&this._tiles[e].hasData()&&!this._coveredTiles[e]&&(t||!this._tiles[e].holdingForFade())&&(i||!this._shadowCasterTiles[e])}reload(){if(this._paused)this._shouldReloadOnResume=!0;else{this._cache.reset();for(const e in this._tiles)"errored"!==this._tiles[e].state&&this._reloadTile(+e,"reloading")}}_reloadTile(e,t){const i=this._tiles[e];i&&("loading"!==i.state&&(i.state=t),this._loadTile(i,this._tileLoaded.bind(this,i,e,t)))}_tileLoaded(e,t,i,r){if(r)if(e.state="errored",404!==r.status)this._source.fire(new ErrorEvent(r,{tile:e}));else if("raster-dem"===this._source.type&&this.usedForTerrain&&this.map.painter.terrain){const e=this.map.painter.terrain;this.update(this.transform,e.getScaledDemTileSize(),!0),e.resetTileLookupCache(this.id)}else this.update(this.transform);else e.timeAdded=rt.now(),"expired"===i&&(e.refreshedUponExpiration=!0),this._setTileReloadTimer(t,e),"raster-dem"===this._source.type&&e.dem&&this._backfillDEM(e),this._state.initializeTileState(e,this.map?this.map.painter:null),this._source.fire(new Event("data",{dataType:"source",tile:e,coord:e.tileID,sourceCacheId:this.id}))}_backfillDEM(e){const t=this.getRenderableIds();for(let r=0;r<t.length;r++){const n=t[r];if(e.neighboringTiles&&e.neighboringTiles[n]){const t=this.getTileByID(n);i(e,t),i(t,e)}}function i(e,t){if(!e.dem||e.dem.borderReady)return;e.needsHillshadePrepare=!0,e.needsDEMTextureUpload=!0;let i=t.tileID.canonical.x-e.tileID.canonical.x;const r=t.tileID.canonical.y-e.tileID.canonical.y,n=Math.pow(2,e.tileID.canonical.z),o=t.tileID.key;0===i&&0===r||Math.abs(r)>1||(Math.abs(i)>1&&(1===Math.abs(i+n)?i+=n:1===Math.abs(i-n)&&(i-=n)),t.dem&&e.dem&&(e.dem.backfillBorder(t.dem,i,r),e.neighboringTiles&&e.neighboringTiles[o]&&(e.neighboringTiles[o].backfilled=!0)))}}getTile(e){return this.getTileByID(e.key)}getTileByID(e){return this._tiles[e]}_retainLoadedChildren(e,t,i,r){for(const n in this._tiles){let o=this._tiles[n];if(r[n]||!o.hasData()||o.tileID.overscaledZ<=t||o.tileID.overscaledZ>i)continue;let a=o.tileID;for(;o&&o.tileID.overscaledZ>t+1;){const e=o.tileID.scaledTo(o.tileID.overscaledZ-1);o=this._tiles[e.key],o&&o.hasData()&&(a=e)}let s=a;for(;s.overscaledZ>t;)if(s=s.scaledTo(s.overscaledZ-1),e[s.key]){r[a.key]=a;break}}}findLoadedParent(e,t){if(e.key in this._loadedParentTiles){const i=this._loadedParentTiles[e.key];return i&&i.tileID.overscaledZ>=t?i:null}for(let i=e.overscaledZ-1;i>=t;i--){const t=e.scaledTo(i),r=this._getLoadedTile(t);if(r)return r}}_getLoadedTile(e){const t=this._tiles[e.key];return t&&t.hasData()?t:this._cache.getByKey(this._source.reparseOverscaled?e.wrapped().key:e.canonical.key)}updateCacheSize(e,t){t=t||this._source.tileSize;const i=Math.ceil(e.width/t)+1,r=Math.ceil(e.height/t)+1,n=Math.floor(i*r*5),o="number"==typeof this._minTileCacheSize?Math.max(this._minTileCacheSize,n):n,a="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,o):o;this._cache.setMaxSize(a)}handleWrapJump(e){const t=Math.round((e-(void 0===this._prevLng?e:this._prevLng))/360);if(this._prevLng=e,t){const e={};for(const i in this._tiles){const r=this._tiles[i];r.tileID=r.tileID.unwrapTo(r.tileID.wrap+t),e[r.tileID.key]=r}this._tiles=e;for(const e in this._timers)clearTimeout(this._timers[e]),delete this._timers[e];for(const e in this._tiles)this._setTileReloadTimer(+e,this._tiles[e])}}update(e,t,i,r){if(this.transform=e,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!i)return;let n;if(this.updateCacheSize(e,t),"globe"!==this.transform.projection.name&&this.handleWrapJump(this.transform.center.lng),this._shadowCasterTiles={},this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?n=e.getVisibleUnwrappedCoordinates(this._source.tileID).map((e=>new OverscaledTileID(e.canonical.z,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y))):(n=e.coveringTiles({tileSize:t||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!i,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain}),this._source.hasTile&&(n=n.filter((e=>this._source.hasTile(e))))):n=[],n.length>0&&this.castsShadows&&r&&"globe"!==this.transform.projection.name&&!this.usedForTerrain&&!Df(this._source.type)){const o=e.coveringZoomLevel({tileSize:t||this._source.tileSize,roundZoom:this._source.roundZoom&&!i}),a=Math.min(o,this._source.maxzoom),s=e.extendTileCoverForShadows(n,r,a);for(const e of s)this._shadowCasterTiles[e.key]=!0,n.push(e)}const o=this._updateRetainedTiles(n);if(Df(this._source.type)&&0!==n.length){const e={},t={},i=Object.keys(o);for(const r of i){const i=o[r],n=this._tiles[r];if(!n||n.fadeEndTime&&n.fadeEndTime<=rt.now())continue;const a=this.findLoadedParent(i,Math.max(i.overscaledZ-SourceCache.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),e[a.tileID.key]=a.tileID),t[r]=i}const r=n[n.length-1].overscaledZ;for(const e in this._tiles){const i=this._tiles[e];if(o[e]||!i.hasData())continue;let n=i.tileID;for(;n.overscaledZ>r;){n=n.scaledTo(n.overscaledZ-1);const r=this._tiles[n.key];if(r&&r.hasData()&&t[n.key]){o[e]=i.tileID;break}}}for(const t in e)o[t]||(this._coveredTiles[t]=!0,o[t]=e[t])}for(const e in o)this._tiles[e].clearFadeHold();const a=function(e,t){const i=[];for(const r in e)r in t||i.push(r);return i}(this._tiles,o);for(const e of a){const t=this._tiles[e];t.hasSymbolBuckets&&!t.holdingForFade()?t.setHoldDuration(this.map._fadeDuration):t.hasSymbolBuckets&&!t.symbolFadeFinished()||this._removeTile(+e)}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate()}releaseSymbolFadeTiles(){for(const e in this._tiles)this._tiles[e].holdingForFade()&&this._removeTile(+e)}_updateRetainedTiles(e){const t={};if(0===e.length)return t;const i={},r=e.reduce(((e,t)=>Math.min(e,t.overscaledZ)),1/0),n=e[0].overscaledZ,o=Math.max(n-SourceCache.maxOverzooming,this._source.minzoom),a=Math.max(n+SourceCache.maxUnderzooming,this._source.minzoom),s={};for(const i of e){const e=this._addTile(i);t[i.key]=i,e.hasData()||r<this._source.maxzoom&&(s[i.key]=i)}this._retainLoadedChildren(s,r,a,t);for(const r of e){let e=this._tiles[r.key];if(e.hasData())continue;if(r.canonical.z>=this._source.maxzoom){const e=r.children(this._source.maxzoom)[0],i=this.getTile(e);if(i&&i.hasData()){t[e.key]=e;continue}}else{const e=r.children(this._source.maxzoom);if(t[e[0].key]&&t[e[1].key]&&t[e[2].key]&&t[e[3].key])continue}let n=e.wasRequested();for(let a=r.overscaledZ-1;a>=o;--a){const o=r.scaledTo(a);if(i[o.key])break;if(i[o.key]=!0,e=this.getTile(o),!e&&n&&(e=this._addTile(o)),e&&(t[o.key]=o,n=e.wasRequested(),e.hasData()))break}}return t}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const e in this._tiles){const t=[];let i,r=this._tiles[e].tileID;for(;r.overscaledZ>0;){if(r.key in this._loadedParentTiles){i=this._loadedParentTiles[r.key];break}t.push(r.key);const e=r.scaledTo(r.overscaledZ-1);if(i=this._getLoadedTile(e),i)break;r=e}for(const e of t)this._loadedParentTiles[e]=i}}_addTile(e){let t=this._tiles[e.key];if(t)return!0!==t.isExtraShadowCaster||!!this._shadowCasterTiles[e.key]||this._reloadTile(e.key,"reloading"),t;t=this._cache.getAndRemove(e),t&&(this._setTileReloadTimer(e.key,t),t.tileID=e,this._state.initializeTileState(t,this.map?this.map.painter:null),this._cacheTimers[e.key]&&(clearTimeout(this._cacheTimers[e.key]),delete this._cacheTimers[e.key],this._setTileReloadTimer(e.key,t)));const i=Boolean(t);if(!i){const i=this.map?this.map.painter:null;t=new Tile(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,i,this._isRaster),this._loadTile(t,this._tileLoaded.bind(this,t,e.key,t.state))}return t?(t.uses++,this._tiles[e.key]=t,i||this._source.fire(new Event("dataloading",{tile:t,coord:t.tileID,dataType:"source"})),t):null}_setTileReloadTimer(e,t){e in this._timers&&(clearTimeout(this._timers[e]),delete this._timers[e]);const i=t.getExpiryTimeout();i&&(this._timers[e]=setTimeout((()=>{this._reloadTile(e,"expired"),delete this._timers[e]}),i))}_removeTile(e){const t=this._tiles[e];t&&(t.uses--,delete this._tiles[e],this._timers[e]&&(clearTimeout(this._timers[e]),delete this._timers[e]),t.uses>0||(t.hasData()&&"reloading"!==t.state?this._cache.add(t.tileID,t,t.getExpiryTimeout()):(t.aborted=!0,this._abortTile(t),this._unloadTile(t))))}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const e in this._tiles)this._removeTile(+e);this._source._clear&&this._source._clear(),this._cache.reset(),this.map&&this.usedForTerrain&&this.map.painter.terrain&&this.map.painter.terrain.resetTileLookupCache(this.id)}tilesIn(e,t,i){const r=[],n=this.transform;if(!n)return r;const o="globe"===n.projection.name,a=_u(n.center.lng);for(const s in this._tiles){const l=this._tiles[s];if(i&&l.clearQueryDebugViz(),l.holdingForFade())continue;let c;if(o){const e=l.tileID.canonical;if(0===e.z){const t=[Math.abs(I(a,...Pf(e,-1))-a),Math.abs(I(a,...Pf(e,1))-a)];c=[0,2*t.indexOf(Math.min(...t))-1]}else{const t=[Math.abs(I(a,...Pf(e,-1))-a),Math.abs(I(a,...Pf(e,0))-a),Math.abs(I(a,...Pf(e,1))-a)];c=[t.indexOf(Math.min(...t))-1]}}else c=[0];for(const i of c){const o=e.containsTile(l,n,t,i);o&&r.push(o)}}return r}getShadowCasterCoordinates(){return this._getRenderableCoordinates(!1,!0)}getVisibleCoordinates(e){return this._getRenderableCoordinates(e)}_getRenderableCoordinates(e,t){const i=this.getRenderableIds(e,t).map((e=>this._tiles[e].tileID));for(const e of i)e.projMatrix=this.transform.calculateProjMatrix(e.toUnwrapped());return i}sortCoordinatesByDistance(e){const t=e.slice(),i=this.transform._camera.position,r=this.transform._camera.forward(),n={};for(const e of t){const t=1/(1<<e.canonical.z);n[e.key]=((e.canonical.x+.5)*t+e.wrap-i[0])*r[0]+((e.canonical.y+.5)*t-i[1])*r[1]-i[2]*r[2]}return t.sort(((e,t)=>n[e.key]-n[t.key])),t}hasTransition(){if(this._source.hasTransition())return!0;if(Df(this._source.type))for(const e in this._tiles){const t=this._tiles[e];if(void 0!==t.fadeEndTime&&t.fadeEndTime>=rt.now())return!0}return!1}setFeatureState(e,t,i){this._state.updateState(e=e||"_geojsonTileLayer",t,i)}removeFeatureState(e,t,i){this._state.removeFeatureState(e=e||"_geojsonTileLayer",t,i)}getFeatureState(e,t){return this._state.getState(e=e||"_geojsonTileLayer",t)}setDependencies(e,t,i){const r=this._tiles[e];r&&r.setDependencies(t,i)}reloadTilesForDependencies(e,t){for(const i in this._tiles)this._tiles[i].hasDependency(e,t)&&this._reloadTile(+i,"reloading");this._cache.filter((i=>!i.hasDependency(e,t)))}_preloadTiles(e,t){if(!this._sourceLoaded){const i=()=>{this._sourceLoaded&&(this._source.off("data",i),this._preloadTiles(e,t))};return void this._source.on("data",i)}const i=new Map,r=Array.isArray(e)?e:[e],n=this.map.painter.terrain,o=this.usedForTerrain&&n?n.getScaledDemTileSize():this._source.tileSize;for(const e of r){const t=e.coveringTiles({tileSize:o,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!this.usedForTerrain,reparseOverscaled:this._source.reparseOverscaled,isTerrainDEM:this.usedForTerrain});for(const e of t)i.set(e.key,e);this.usedForTerrain&&e.updateElevation(!1)}L(Array.from(i.values()),((e,t)=>{const i=new Tile(e,this._source.tileSize*e.overscaleFactor(),this.transform.tileZoom,this.map.painter,this._isRaster);this._loadTile(i,(e=>{"raster-dem"===this._source.type&&i.dem&&this._backfillDEM(i),t(e,i)}))}),t)}}function If(e,t){const i=Math.abs(2*e.wrap)-+(e.wrap<0),r=Math.abs(2*t.wrap)-+(t.wrap<0);return e.overscaledZ-t.overscaledZ||r-i||t.canonical.y-e.canonical.y||t.canonical.x-e.canonical.x}function Df(e){return"raster"===e||"image"===e||"video"===e||"custom"===e}function Pf(e,t){const i=1<<e.z;return[e.x/i+t,(e.x+1)/i+t]}SourceCache.maxOverzooming=10,SourceCache.maxUnderzooming=3;const Lf=ha([{name:"a_pos_3f",components:3,type:"Float32"}]),zf=ha([{name:"a_color_3f",components:3,type:"Float32"}]),Rf=ha([{name:"a_color_4f",components:4,type:"Float32"}]),kf=ha([{name:"a_uv_2f",components:2,type:"Float32"}]),Bf=ha([{name:"a_normal_3f",components:3,type:"Float32"}]),Of=ha([{name:"a_normal_matrix0",components:4,type:"Float32"},{name:"a_normal_matrix1",components:4,type:"Float32"},{name:"a_normal_matrix2",components:4,type:"Float32"},{name:"a_normal_matrix3",components:4,type:"Float32"}]),Ff=ha([{name:"a_pbr",components:4,type:"Uint16"},{name:"a_heightBasedEmissiveStrength",components:3,type:"Float32"}]);class EdgeInsets{constructor(e=0,t=0,i=0,r=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(r)||r<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=r}interpolate(e,t,i){return null!=t.top&&null!=e.top&&(this.top=yr(e.top,t.top,i)),null!=t.bottom&&null!=e.bottom&&(this.bottom=yr(e.bottom,t.bottom,i)),null!=t.left&&null!=e.left&&(this.left=yr(e.left,t.left,i)),null!=t.right&&null!=e.right&&(this.right=yr(e.right,t.right,i)),this}getCenter(e,t){const i=I((this.left+e-this.right)/2,0,e),r=I((this.top+t-this.bottom)/2,0,t);return new g(i,r)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new EdgeInsets(this.top,this.bottom,this.left,this.right)}toJSON(){return{top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Uf(e,t){const i=ie(e,3);ic.fromQuat(e,t),re(e,3,i)}function Vf(e,t){const i=nc.identity([]);return nc.rotateZ(i,i,-t),nc.rotateX(i,i,-e),i}function Nf(e,t){const i=[e[0],e[1],0],r=[t[0],t[1],0];if(lc.length(i)>=1e-15){const e=lc.normalize([],i);lc.scale(r,e,lc.dot(r,e)),t[0]=r[0],t[1]=r[1]}const n=lc.cross([],t,e);if(lc.len(n)<1e-15)return null;const o=Math.atan2(-n[1],n[0]);return Vf(Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2]),o)}class FreeCameraOptions{constructor(e,t){this.position=e,this.orientation=t}get position(){return this._position}set position(e){if(e){const t=e instanceof MercatorCoordinate?e:new MercatorCoordinate(e[0],e[1],e[2]);this._renderWorldCopies&&(t.x=P(t.x,0,1)),this._position=t}else this._position=null}lookAtPoint(e,t){if(this.orientation=null,!this.position)return;const i=this.position,r=this._elevation?this._elevation.getAtPointOrZero(MercatorCoordinate.fromLngLat(e)):0,n=MercatorCoordinate.fromLngLat(e,r),o=[n.x-i.x,n.y-i.y,n.z-i.z];t||(t=[0,0,1]),t[2]=Math.abs(t[2]),this.orientation=Nf(o,t)}setPitchBearing(e,t){this.orientation=Vf(b(e),b(-t))}}class FreeCamera{constructor(e,t){this._transform=ic.identity([]),this.orientation=t,this.position=e}get mercatorPosition(){const e=this.position;return new MercatorCoordinate(e[0],e[1],e[2])}get position(){const e=ie(this._transform,3);return[e[0],e[1],e[2]]}set position(e){var t;e&&re(this._transform,3,[(t=e)[0],t[1],t[2],1])}get orientation(){return this._orientation}set orientation(e){this._orientation=e||nc.identity([]),e&&Uf(this._transform,this._orientation)}getPitchBearing(){const e=this.forward(),t=this.right();return{bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=Vf(e,t),Uf(this._transform,this._orientation)}forward(){const e=ie(this._transform,2);return[-e[0],-e[1],-e[2]]}up(){const e=ie(this._transform,1);return[-e[0],-e[1],-e[2]]}right(){const e=ie(this._transform,0);return[e[0],e[1],e[2]]}getCameraToWorld(e,t){const i=new Float64Array(16);return ic.invert(i,this.getWorldToCamera(e,t)),i}getCameraToWorldMercator(){return this._transform}getWorldToCameraPosition(e,t,i){const r=this.position;lc.scale(r,r,-e);const n=new Float64Array(16);return ic.fromScaling(n,[i,i,i]),ic.translate(n,n,r),n[10]*=t,n}getWorldToCamera(e,t){const i=new Float64Array(16),r=new Float64Array(4),n=this.position;return nc.conjugate(r,this._orientation),lc.scale(n,n,-e),ic.fromQuat(i,r),ic.translate(i,i,n),i[1]*=-1,i[5]*=-1,i[9]*=-1,i[13]*=-1,i[8]*=t,i[9]*=t,i[10]*=t,i[11]*=t,i}getCameraToClipPerspective(e,t,i,r){const n=new Float64Array(16);return ic.perspective(n,e,t,i,r),n}getCameraToClipOrthographic(e,t,i,r,n,o){const a=new Float64Array(16);return ic.ortho(a,e,t,i,r,n,o),a}getDistanceToElevation(e,t=!1){const i=0===e?0:yu(e,t?vu(this.position[1]):this.position[1]),r=this.forward();return(i-this.position[2])/r[2]}clone(){return new FreeCamera([...this.position],[...this.orientation])}}function jf(e,t){const i=qf(e.projection,e.zoom,e.width,e.height),r=function(e,t,i,r,n){const o=new du(i.lng-180*Zf,i.lat),a=new du(i.lng+180*Zf,i.lat),s=e.project(o.lng,o.lat),l=e.project(a.lng,a.lat),c=-Math.atan2(l.y-s.y,l.x-s.x),u=MercatorCoordinate.fromLngLat(i);u.y=I(u.y,-1+Zf,1-Zf);const h=u.toLngLat(),d=e.project(h.lng,h.lat),p=MercatorCoordinate.fromLngLat(h);p.x+=Zf;const f=p.toLngLat(),m=e.project(f.lng,f.lat),_=Hf(m.x-d.x,m.y-d.y,c),g=MercatorCoordinate.fromLngLat(h);g.y+=Zf;const y=g.toLngLat(),x=e.project(y.lng,y.lat),v=Hf(x.x-d.x,x.y-d.y,c),b=Math.abs(_.x)/Math.abs(v.y),w=ic.identity([]);ic.rotateZ(w,w,-c*(1-(n?0:r)));const T=ic.identity([]);return ic.scale(T,T,[1,1-(1-b)*r,1]),T[4]=-v.x/v.y*r,ic.rotateZ(T,T,c),ic.multiply(T,w,T),T}(e.projection,0,e.center,i,t),n=Gf(e);return ic.scale(r,r,[n,n,1]),r}function Gf(e){const t=e.projection,i=qf(e.projection,e.zoom,e.width,e.height),r=$f(t,e.center),n=$f(t,du.convert(t.center));return Math.pow(2,r*i+(1-i)*n)}function qf(e,t,i,r,n=1/0){const o=e.range;if(!o)return 0;const a=Math.min(n,Math.max(i,r)),s=Math.log(a/1024)/Math.LN2;return D(o[0]+s,o[1]+s,t)}const Zf=1/4e4;function $f(e,t){const i=I(t.lat,-wu,wu),r=new du(t.lng-180*Zf,i),n=new du(t.lng+180*Zf,i),o=e.project(r.lng,i),a=e.project(n.lng,i),s=MercatorCoordinate.fromLngLat(r),l=MercatorCoordinate.fromLngLat(n),c=a.x-o.x,u=a.y-o.y,h=l.x-s.x,d=l.y-s.y,p=Math.sqrt((h*h+d*d)/(c*c+u*u));return Math.log(p)/Math.LN2}function Hf(e,t,i){const r=Math.cos(i),n=Math.sin(i);return{x:e*r-t*n,y:e*n+t*r}}function Wf(e,t,i){return t*(Ri/(e.tileSize*Math.pow(2,i-e.tileID.overscaledZ)))}const Xf={unknown:0,flipRequired:1,flipNotRequired:2},Yf=Math.tan(85*Math.PI/180);function Kf(e,t,i,r,n,o,a){const s=ic.create();if(i)if("globe"===o.name){const e=function(e,t){const{x:i,y:r}=e.point,n=Jc(i,r,e.worldSize/e._pixelsPerMercatorPixel,0,0);return ic.multiply(n,n,Xc(Bc(t)))}(n,t);ic.multiply(s,s,e)}else{const e=Kl.invert([],a);s[0]=e[0],s[1]=e[1],s[4]=e[2],s[5]=e[3],r||ic.rotateZ(s,s,n.angle)}else ic.multiply(s,n.labelPlaneMatrix,e);return s}function Jf(e,t,i,r,n,o,a){const s=Kf(e,t,i,r,n,o,a);return"globe"===o.name&&i||(s[2]=s[6]=s[10]=s[14]=0),s}function Qf(e,t,i,r,n,o,a){if(i){if("globe"===o.name){const s=Kf(e,t,i,r,n,o,a);return ic.invert(s,s),ic.multiply(s,e,s),s}{const t=ic.clone(e),i=ic.identity([]);return i[0]=a[0],i[1]=a[1],i[4]=a[2],i[5]=a[3],ic.multiply(t,t,i),r||ic.rotateZ(t,t,-n.angle),t}}return n.glCoordMatrix}function em(e,t,i,r){const n=[e,t,i,1];i?Wl.transformMat4(n,n,r):hm(n,n,r);const o=n[3];return n[0]/=o,n[1]/=o,n[2]/=o,n}function tm(e,t){return Math.min(.5+e/t*.5,1.5)}function im(e,t){const i=e[0]/e[3],r=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&r>=-t[1]&&r<=t[1]}function rm(e,t,i,r,n,o,a,s,l,c){const u=i.transform,h=r?e.textSizeData:e.iconSizeData,d=mp(h,i.transform.zoom),p="globe"===u.projection.name,f=[256/i.width*2+1,256/i.height*2+1],m=r?e.text.dynamicLayoutVertexArray:e.icon.dynamicLayoutVertexArray;m.clear();let _=null;p&&(_=r?e.text.globeExtVertexArray:e.icon.globeExtVertexArray);const y=e.lineVertexArray,x=r?e.text.placedSymbolArray:e.icon.placedSymbolArray,v=i.transform.width/i.transform.height;let b,w=!1;for(let r=0;r<x.length;r++){const p=x.get(r),{numGlyphs:T,writingMode:E}=p;if(E!==Ep.vertical||w||b===Ep.horizontal||(w=!0),b=E,(p.hidden||E===Ep.vertical)&&!w){um(T,m);continue}w=!1;const M=new g(p.tileAnchorX,p.tileAnchorY);let{x:S,y:A,z:C}=u.projection.projectTilePoint(M.x,M.y,c.canonical);if(l){const[e,t,i]=l(M);S+=e,A+=t,C+=i}const I=[S,A,C,1];if(Wl.transformMat4(I,I,t),!im(I,f)){um(T,m);continue}const D=I[3],P=tm(i.transform.getCameraToCenterDistance(u.projection),D),L=fp(h,d,p),z=a?L/P:L*P,R=em(S,A,C,n);if(R[3]<=0){um(T,m);continue}let k={};const B=a?null:l,O=am(p,z,!1,s,t,n,o,e.glyphOffsetArray,y,m,_,R,M,k,v,B,u.projection,c,a);w=O.useVertical,B&&O.needsFlipping&&(k={}),(O.notEnoughRoom||w||O.needsFlipping&&am(p,z,!0,s,t,n,o,e.glyphOffsetArray,y,m,_,R,M,k,v,B,u.projection,c,a).notEnoughRoom)&&um(T,m)}r?(e.text.dynamicLayoutVertexBuffer.updateData(m),_&&e.text.globeExtVertexBuffer&&e.text.globeExtVertexBuffer.updateData(_)):(e.icon.dynamicLayoutVertexBuffer.updateData(m),_&&e.icon.globeExtVertexBuffer&&e.icon.globeExtVertexBuffer.updateData(_))}function nm(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m){const{lineStartIndex:_,glyphStartIndex:g,segment:y}=s,x=g+s.numGlyphs,v=_+s.lineLength,b=t.getoffsetX(g),w=t.getoffsetX(x-1),T=cm(e*b,i,r,n,o,a,y,_,v,l,c,u,h,d,!0,p,f,m);if(!T)return null;const E=cm(e*w,i,r,n,o,a,y,_,v,l,c,u,h,d,!0,p,f,m);return E?{first:T,last:E}:null}function om(e,t,i,r){return e===Ep.horizontal&&Math.abs(r)>Math.abs(i)?{useVertical:!0}:e===Ep.vertical?r>0?{needsFlipping:!0}:null:t!==Xf.unknown&&function(e,t){return 0===e||Math.abs(t/e)>Yf}(i,r)?t===Xf.flipRequired?{needsFlipping:!0}:null:i<0?{needsFlipping:!0}:null}function am(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,y,x){const v=t/24,b=e.lineOffsetX*v,w=e.lineOffsetY*v,{lineStartIndex:T,glyphStartIndex:E,numGlyphs:M,segment:S,writingMode:A,flipState:C}=e,I=T+e.lineLength,D=e=>{if(u){const[t,i,r]=e.up,n=c.length;nf(u,n+0,t,i,r),nf(u,n+1,t,i,r),nf(u,n+2,t,i,r),nf(u,n+3,t,i,r)}const[t,i,r]=e.point;of(c,t,i,r,e.angle)};if(M>1){const t=nm(v,s,b,w,i,h,d,e,l,o,p,m,!1,_,y,x);if(!t)return{notEnoughRoom:!0};if(r&&!i){let[i,r,n]=t.first.point,[o,s,l]=t.last.point;[i,r]=em(i,r,n,a),[o,s]=em(o,s,l,a);const c=om(A,C,(o-i)*f,s-r);if(e.flipState=c&&c.needsFlipping?Xf.flipRequired:Xf.flipNotRequired,c)return c}D(t.first);for(let e=E+1;e<E+M-1;e++){const t=cm(v*s.getoffsetX(e),b,w,i,h,d,S,T,I,l,o,p,m,!1,!1,_,y,x);if(!t)return c.length-=4*(e-E),{notEnoughRoom:!0};D(t)}D(t.last)}else{if(r&&!i){const t=em(d.x,d.y,0,n),i=T+S+1,r=new g(l.getx(i),l.gety(i)),o=em(r.x,r.y,0,n),a=o[3]>0?o:lm(d,r,t,1,n,void 0,_,y.canonical),s=om(A,C,(a[0]-t[0])*f,a[1]-t[1]);if(e.flipState=s&&s.needsFlipping?Xf.flipRequired:Xf.flipNotRequired,s)return s}const t=cm(v*s.getoffsetX(E),b,w,i,h,d,S,T,I,l,o,p,m,!1,!1,_,y,x);if(!t)return{notEnoughRoom:!0};D(t)}return{}}function sm(e,t,i,r,n){const{x:o,y:a,z:s}=r.projectTilePoint(e.x,e.y,t);if(!n)return em(o,a,s,i);const[l,c,u]=n(e);return em(o+l,a+c,s+u,i)}function lm(e,t,i,r,n,o,a,s){const l=sm(e.sub(t)._unit()._add(e),s,n,a,o);return lc.sub(l,i,l),lc.normalize(l,l),lc.scaleAndAdd(l,i,l,r)}function cm(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,y){const x=r?e-t:e+t;let v=x>0?1:-1,b=0;r&&(v*=-1,b=Math.PI),v<0&&(b+=Math.PI);let w=s+a+(v>0?0:1)|0,T=n,E=n,M=0,S=0;const A=Math.abs(x),C=[],I=[];let D=o,P=D;const L=()=>lm(P,D,E,A-M+1,u,d,m,_.canonical);for(;M+S<=A;){if(w+=v,w<s||w>=l)return null;if(E=T,P=D,C.push(E),p&&I.push(P),D=new g(c.getx(w),c.gety(w)),T=h[w],!T){const e=sm(D,_.canonical,u,m,d);T=e[3]>0?h[w]=e:L()}M+=S,S=lc.distance(E,T)}f&&d&&(h[w]&&(T=L(),S=lc.distance(E,T)),h[w]=T);const z=(A-M)/S,R=D.sub(P)._mult(z)._add(P),k=lc.sub([],T,E),B=lc.scaleAndAdd([],E,k,z);let O=[0,0,1],F=k[0],U=k[1];if(y&&(O=m.upVector(_.canonical,R.x,R.y),0!==O[0]||0!==O[1]||1!==O[2])){const e=[O[2],0,-O[0]],t=lc.cross([],O,e);lc.normalize(e,e),lc.normalize(t,t),F=lc.dot(k,e),U=lc.dot(k,t)}if(i){const e=lc.cross([],O,k);lc.normalize(e,e),lc.scaleAndAdd(B,B,e,i*v)}const V=b+Math.atan2(U,F);return C.push(B),p&&I.push(R),{point:B,angle:V,path:C,tilePath:I,up:O}}function um(e,t){const i=t.length,r=i+4*e;t.resize(r),t.float32.fill(-1/0,4*i,4*r)}function hm(e,t,i){const r=t[0],n=t[1];return e[0]=i[0]*r+i[4]*n+i[12],e[1]=i[1]*r+i[5]*n+i[13],e[3]=i[3]*r+i[7]*n+i[15],e}const dm=(e,t,i)=>(1-i)*e+i*t,pm=e=>e*e*e*e*e;class Transform{constructor(e,t,i,r,n,o,a){this.tileSize=512,this._renderWorldCopies=void 0===n||n,this._minZoom=e||0,this._maxZoom=t||22,this._minPitch=null==i?0:i,this._maxPitch=null==r?60:r,this.setProjection(o),this.setMaxBounds(a),this.width=0,this.height=0,this._center=new du(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._nearZ=0,this._farZ=0,this._unmodified=!0,this._edgeInsets=new EdgeInsets,this._projMatrixCache={},this._alignedProjMatrixCache={},this._fogTileMatrixCache={},this._distanceTileDataCache={},this._camera=new FreeCamera,this._centerAltitude=0,this._averageElevation=0,this.cameraElevationReference="ground",this._pixelsPerMercatorPixel=1,this.globeRadius=0,this.globeCenterInViewSpace=[0,0,0],this._horizonShift=.1,this._orthographicProjectionAtLowPitch=!1}clone(){const e=new Transform(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies,this.getProjection());return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e._centerAltitudeValidForExaggeration=this._centerAltitudeValidForExaggeration,e.tileSize=this.tileSize,e.mercatorFromTransition=this.mercatorFromTransition,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._seaLevelZoom=this._seaLevelZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._nearZ=this._nearZ,e._farZ=this._farZ,e._averageElevation=this._averageElevation,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e.frustumCorners=this.frustumCorners,e}get isOrthographic(){return"globe"!==this.projection.name&&this._orthographicProjectionAtLowPitch&&this.pitch<15}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,this._updateCameraOnTerrain(),this._calcMatrices())}get depthOcclusionForSymbolsAndCircles(){return"globe"!==this.projection.name&&!this.isOrthographic}updateElevation(e,t=!1){const i=this._elevation&&this._elevation.exaggeration()!==this._centerAltitudeValidForExaggeration;(null==this._seaLevelZoom||i)&&this._updateCameraOnTerrain(),(e||i)&&this._constrainCamera(t),this._calcMatrices()}getProjection(){return R(this.projection,["name","center","parallels"])}setProjection(e){this.projectionOptions=e||{name:"mercator"};const t=this.projection?this.getProjection():void 0;this.projection=Xp(this.projectionOptions);const i=!y(t,this.getProjection());return i&&this._calcMatrices(),this.mercatorFromTransition=!1,i}setOrthographicProjectionAtLowPitch(e){return this._orthographicProjectionAtLowPitch!==e&&(this._orthographicProjectionAtLowPitch=e,this._calcMatrices(),!0)}setMercatorFromTransition(){const e=this.projection.name;this.mercatorFromTransition=!0,this.projectionOptions={name:"mercator"},this.projection=Xp({name:"mercator"});const t=e!==this.projection.name;return t&&this._calcMatrices(),t}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e))}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e))}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e))}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e))}get renderWorldCopies(){return this._renderWorldCopies&&!0===this.projection.supportsWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e}get worldSize(){return this.tileSize*this.scale}get cameraWorldSizeForFog(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get cameraWorldSize(){const e=Math.max(this._camera.getDistanceToElevation(this._averageElevation,!0),Number.EPSILON);return this._worldSizeFromZoom(this._zoomFromMercatorZ(e))}get pixelsPerMeter(){return this.projection.pixelsPerMeter(this.center.lat,this.worldSize)}get cameraPixelsPerMeter(){return yu(1,this.center.lat)*this.cameraWorldSizeForFog}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new g(this.width,this.height)}get bearing(){return P(this.rotation,-180,180)}set bearing(e){this.rotation=e}get rotation(){return-this.angle/Math.PI*180}set rotation(e){const t=-e*Math.PI/180;this.angle!==t&&(this._unmodified=!1,this.angle=t,this._calcMatrices(),this.rotationMatrix=Kl.create(),Kl.rotate(this.rotationMatrix,this.rotationMatrix,this.angle))}get pitch(){return this._pitch/Math.PI*180}set pitch(e){const t=I(e,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==t&&(this._unmodified=!1,this._pitch=t,this._calcMatrices())}get aspect(){return this.width/this.height}get fov(){return this._fov/Math.PI*180}get fovX(){return this._fov}get fovY(){const e=1/Math.tan(.5*this.fovX);return 2*Math.atan(1/this.aspect/e)}set fov(e){e=Math.max(.01,Math.min(60,e)),this._fov!==e&&(this._unmodified=!1,this._fov=b(e),this._calcMatrices())}get averageElevation(){return this._averageElevation}set averageElevation(e){this._averageElevation=e,this._calcFogMatrices(),this._distanceTileDataCache={}}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._updateSeaLevelZoom(),this._constrain(),this._calcMatrices())}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom}_updateCameraOnTerrain(){const e=this.elevation?this.elevation.getAtPoint(this.locationCoordinate(this.center),Number.NEGATIVE_INFINITY):Number.NEGATIVE_INFINITY,t=this.elevation&&e===Number.NEGATIVE_INFINITY&&this.elevation.visibleDemTiles.length>0&&this.elevation.exaggeration()>0&&this._centerAltitudeValidForExaggeration;if(!this._elevation||e===Number.NEGATIVE_INFINITY&&(!t||!this._centerAltitude))return this._centerAltitude=0,this._seaLevelZoom=null,void(this._centerAltitudeValidForExaggeration=void 0);const i=this._elevation;t||this._centerAltitude&&this._centerAltitudeValidForExaggeration&&i.exaggeration()&&this._centerAltitudeValidForExaggeration!==i.exaggeration()?(this._centerAltitude=this._centerAltitude/this._centerAltitudeValidForExaggeration*i.exaggeration(),this._centerAltitudeValidForExaggeration=i.exaggeration()):(this._centerAltitude=e||0,this._centerAltitudeValidForExaggeration=i.exaggeration()),this._updateSeaLevelZoom()}_updateSeaLevelZoom(){void 0!==this._centerAltitudeValidForExaggeration&&(this._seaLevelZoom=this._zoomFromMercatorZ((this.pixelsPerMeter*this._centerAltitude+this.cameraToCenterDistance)/this.worldSize))}sampleAverageElevation(){if(!this._elevation)return 0;const e=this._elevation,t=[[.5,.2],[.3,.5],[.5,.5],[.7,.5],[.5,.8]],i=this.horizonLineFromTop();let r=0,n=0;for(let o=0;o<t.length;o++){const a=new g(t[o][0]*this.width,i+t[o][1]*(this.height-i)),s=e.pointCoordinate(a);if(!s)continue;const l=1/Math.hypot(s[0]-this._camera.position[0],s[1]-this._camera.position[1]);r+=s[3]*l,n+=l}return 0===n?NaN:r/n}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCameraOnTerrain():this._updateZoomFromElevation()),this._constrain(),this._calcMatrices())}_updateZoomFromElevation(){if(null==this._seaLevelZoom||!this._elevation)return;const e=this._seaLevelZoom,t=this._elevation.getAtPointOrZero(this.locationCoordinate(this.center)),i=this.pixelsPerMeter/this.worldSize*t,r=this._mercatorZfromZoom(e),n=this._mercatorZfromZoom(this._maxZoom),o=Math.max(r-i,n);this._setZoom(this._zoomFromMercatorZ(o))}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices())}computeZoomRelativeTo(e){const t=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,e.toAltitude()));let i;i=e.z<this._camera.position[2]?[t.x,t.y,t.z]:[e.x,e.y,e.z];const r=lc.length(lc.sub([],this._camera.position,i));return I(this._zoomFromMercatorZ(r),this._minZoom,this._maxZoom)}setFreeCameraOptions(e){if(!this.height)return;if(!e.position&&!e.orientation)return;this._updateCameraState();let t=!1;if(e.orientation&&!nc.exactEquals(e.orientation,this._camera.orientation)&&(t=this._setCameraOrientation(e.orientation)),e.position){const i=[e.position.x,e.position.y,e.position.z];lc.exactEquals(i,this._camera.position)||(this._setCameraPosition(i),t=!0)}t&&(this._updateStateFromCamera(),this.recenterOnTerrain())}getFreeCameraOptions(){this._updateCameraState();const e=this._camera.position,t=new FreeCameraOptions;return t.position=new MercatorCoordinate(e[0],e[1],e[2]),t.orientation=this._camera.orientation,t._elevation=this.elevation,t._renderWorldCopies=this.renderWorldCopies,t}_setCameraOrientation(e){if(!nc.length(e))return!1;nc.normalize(e,e);const t=lc.transformQuat([],[0,0,-1],e),i=lc.transformQuat([],[0,-1,0],e);if(i[2]<0)return!1;const r=Nf(t,i);return!!r&&(this._camera.orientation=r,!0)}_setCameraPosition(e){const t=this.zoomScale(this.minZoom)*this.tileSize,i=this.zoomScale(this.maxZoom)*this.tileSize,r=this.cameraToCenterDistance;e[2]=I(e[2],r/i,r/t),this._camera.position=e}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices()}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(e){const t=[new UnwrappedTileID(0,e)];if(this.renderWorldCopies){const i=this.pointCoordinate(new g(0,0)),r=this.pointCoordinate(new g(this.width,0)),n=this.pointCoordinate(new g(this.width,this.height)),o=this.pointCoordinate(new g(0,this.height)),a=Math.floor(Math.min(i.x,r.x,n.x,o.x)),s=Math.floor(Math.max(i.x,r.x,n.x,o.x)),l=1;for(let i=a-l;i<=s+l;i++)0!==i&&t.push(new UnwrappedTileID(i,e))}return t}isLODDisabled(e){return(!e||this.pitch<=60)&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation&&!this.projection.isReprojectedInTileSpace}extendTileCoverForShadows(e,t,i){let r=[];if(0===t[0]&&0===t[1])return r;for(const i of e){const e=i.canonical,n=i.overscaledZ,o=i.wrap,a=1<<e.z,s=e.x+1<a,l=e.x>0,c=e.y+1<a,u=e.y>0,h=i.wrap-(l?0:1),d=i.wrap+(s?0:1),p=l?e.x-1:a-1,f=s?e.x+1:0;t[0]<0?(r.push(new OverscaledTileID(n,d,e.z,f,e.y)),t[1]<0&&c&&(r.push(new OverscaledTileID(n,o,e.z,e.x,e.y+1)),r.push(new OverscaledTileID(n,d,e.z,f,e.y+1))),t[1]>0&&u&&(r.push(new OverscaledTileID(n,o,e.z,e.x,e.y-1)),r.push(new OverscaledTileID(n,d,e.z,f,e.y-1)))):t[0]>0?(r.push(new OverscaledTileID(n,h,e.z,p,e.y)),t[1]<0&&c&&(r.push(new OverscaledTileID(n,o,e.z,e.x,e.y+1)),r.push(new OverscaledTileID(n,h,e.z,p,e.y+1))),t[1]>0&&u&&(r.push(new OverscaledTileID(n,o,e.z,e.x,e.y-1)),r.push(new OverscaledTileID(n,h,e.z,p,e.y-1)))):t[1]<0&&c?r.push(new OverscaledTileID(n,o,e.z,e.x,e.y+1)):u&&r.push(new OverscaledTileID(n,o,e.z,e.x,e.y-1))}if(r.length>1){r.sort(((e,t)=>e.overscaledZ-t.overscaledZ||e.wrap-t.wrap||e.canonical.z-t.canonical.z||e.canonical.x-t.canonical.x||e.canonical.y-t.canonical.y));let e=0,t=0;for(;t<r.length;)r[t].equals(r[e])?++t:r[++e]=r[t++];r.length=e+1}const n=[];for(const e of r)r.some((t=>e.isChildOf(t)))||n.push(e);return r=n.filter((t=>!e.some((e=>!!(t.overscaledZ<i&&e.isChildOf(t))||t.equals(e)||t.isChildOf(e))))),r}coveringTiles(e){let t=this.coveringZoomLevel(e);const i=t,r=this.elevation&&this.elevation.exaggeration(),n=r&&!e.isTerrainDEM,o="mercator"===this.projection.name;if(void 0!==e.minzoom&&t<e.minzoom)return[];void 0!==e.maxzoom&&t>e.maxzoom&&(t=e.maxzoom);const a=this.locationCoordinate(this.center),s=this.center.lat,l=1<<t,c=[l*a.x,l*a.y,0],u="globe"===this.projection.name,h=!u,d=Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,t,h),p=u?this._camera.mercatorPosition:this.pointCoordinate(this.getCameraPoint()),f=l*yu(1,this.center.lat),m=this._camera.position[2]/yu(1,this.center.lat),_=[l*p.x,l*p.y,m*(h?1:f)],g=u||r,y=this.cameraToCenterDistance/e.tileSize*(e.roundZoom?1:.502),x=this.isLODDisabled(!0)?t:0,v=e.isTerrainDEM&&this._elevation?1e4*this._elevation.exaggeration():this._centerAltitude,b=e.isTerrainDEM?-v:this._elevation?this._elevation.getMinElevationBelowMSL():0,w=this.projection.isReprojectedInTileSpace?Gf(this):1,E=e=>{const t=1/4e4,i=new MercatorCoordinate(e.x+t,e.y,e.z),r=new MercatorCoordinate(e.x,e.y+t,e.z),n=e.toLngLat(),o=i.toLngLat(),a=r.toLngLat(),s=this.locationCoordinate(n),l=this.locationCoordinate(o),c=this.locationCoordinate(a),u=Math.hypot(l.x-s.x,l.y-s.y),h=Math.hypot(c.x-s.x,c.y-s.y);return Math.sqrt(u*h)*w/t},M=e=>{const t=v,i=b;return{aabb:Bp(this,l,0,0,0,e,i,t,this.projection),zoom:0,x:0,y:0,minZ:i,maxZ:t,wrap:e,fullyVisible:!1}},S=[];let A=[];const C=t,I=e.reparseOverscaled?i:t,D=e=>e*e,P=D((m-this._centerAltitude)*f),L=e=>{if(!this._elevation||!e.tileID||!o)return;const t=this._elevation.getMinMaxForTile(e.tileID),i=e.aabb;t?(i.min[2]=t.min,i.max[2]=t.max,i.center[2]=(i.min[2]+i.max[2])/2):(e.shouldSplit=z(e),e.shouldSplit||(i.min[2]=i.max[2]=i.center[2]=this._centerAltitude))},z=e=>{if(e.zoom<x)return!0;if(e.zoom===C)return!1;if(null!=e.shouldSplit)return e.shouldSplit;const t=e.aabb.distanceX(_),r=e.aabb.distanceY(_);let o=P,a=1;if(u){o=D(e.aabb.distanceZ(_));const t=Math.pow(2,e.zoom),i=vu((e.y+1)/t),r=vu(e.y/t),n=Math.min(Math.max(s,i),r),l=mu(n)/mu(s);if(a=n===s?1/Math.max(1,this._mercatorScaleRatio-.3):Math.min(1,l/this._mercatorScaleRatio),this.zoom<=Ec&&e.zoom===C-1&&l>=.9)return!0}else if(n&&(o=D(e.aabb.distanceZ(_)*f)),this.projection.isReprojectedInTileSpace&&i<=5){const t=Math.pow(2,e.zoom),i=E(new MercatorCoordinate((e.x+.5)/t,(e.y+.5)/t));a=i>.85?1:i}const l=t*t+r*r+o,c=D((1<<C-e.zoom)*y*a*((e,t)=>{if(t*D(.707)<e)return 1;const i=Math.sqrt(t/e);return i/(1.4144271570014144+(Math.pow(1.1,i-1.4144271570014144+1)-1)/(1.1-1)-1)})(Math.max(o,P),l));return l<c};if(this.renderWorldCopies)for(let e=1;e<=3;e++)S.push(M(-e)),S.push(M(e));for(S.push(M(0));S.length>0;){const i=S.pop(),r=i.x,a=i.y;let s=i.fullyVisible;const h=()=>"globe"===this.projection.name&&(0===i.y||i.y===(1<<i.zoom)-1);if(!s){let e=g?i.aabb.intersects(d):i.aabb.intersectsFlat(d);if(0===e&&h()){const t=new CanonicalTileID(i.zoom,r,a);e=Vc(this,l,t,!0).intersects(d)}if(0===e)continue;s=2===e}if(i.zoom!==C&&z(i))for(let e=0;e<4;e++){const t=(r<<1)+e%2,c=(a<<1)+(e>>1),h={aabb:o?i.aabb.quadrant(e):Bp(this,l,i.zoom+1,t,c,i.wrap,i.minZ,i.maxZ,this.projection),zoom:i.zoom+1,x:t,y:c,wrap:i.wrap,fullyVisible:s,tileID:void 0,shouldSplit:void 0,minZ:i.minZ,maxZ:i.maxZ};n&&!u&&(h.tileID=new OverscaledTileID(i.zoom+1===C?I:i.zoom+1,i.wrap,i.zoom+1,t,c),L(h)),S.push(h)}else{const n=i.zoom===C?I:i.zoom;if(e.minzoom&&e.minzoom>n)continue;if(!s){let e=g?i.aabb.intersectsPrecise(d):i.aabb.intersectsPreciseFlat(d);if(0===e&&h()){const t=new CanonicalTileID(i.zoom,r,a);e=Vc(this,l,t,!0).intersectsPrecise(d)}if(0===e)continue}const o=c[0]-(.5+r+(i.wrap<<i.zoom))*(1<<t-i.zoom),u=c[1]-.5-a,p=i.tileID?i.tileID:new OverscaledTileID(n,i.wrap,i.zoom,r,a);A.push({tileID:p,distanceSq:o*o+u*u})}}if(this.fogCullDistSq){const t=this.fogCullDistSq,i=this.horizonLineFromTop();A=A.filter((r=>{const n=[0,0,0,1],o=[Ri,Ri,0,1],a=this.calculateFogTileMatrix(r.tileID.toUnwrapped());Wl.transformMat4(n,n,a),Wl.transformMat4(o,o,a);const s=function(e,t,i){let r=0;for(let i=0;i<2;++i){const n=0;e[i]>n&&(r+=(e[i]-n)*(e[i]-n)),t[i]<n&&(r+=(n-t[i])*(n-t[i]))}return r}(Wl.min([],n,o),Wl.max([],n,o));if(0===s)return!0;let l=!1;const c=this._elevation;if(c&&s>t&&0!==i){const t=this.calculateProjMatrix(r.tileID.toUnwrapped());let n;e.isTerrainDEM||(n=c.getMinMaxForTile(r.tileID)),n||(n={min:b,max:v});const o=function(e){const t=Math.round((e+45+360)%360/90)%4;return T[t]}(this.rotation),a=[o[0]*Ri,o[1]*Ri,n.max];lc.transformMat4(a,a,t),l=(1-a[1])*this.height*.5<i}return s<t||l}))}return A.sort(((e,t)=>e.distanceSq-t.distanceSq)).map((e=>e.tileID))}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices()}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(e){const t=I(e.lat,-wu,wu),i=this.projection.project(e.lng,t);return new g(i.x*this.worldSize,i.y*this.worldSize)}unproject(e){return this.projection.unproject(e.x/this.worldSize,e.y/this.worldSize)}get point(){return this.project(this.center)}get pointMerc(){return this.point._div(this.worldSize)}get pixelsPerMeterRatio(){return this.pixelsPerMeter/yu(1,this.center.lat)/this.worldSize}setLocationAtPoint(e,t){let i,r;const n=this.centerPoint;if("globe"===this.projection.name){const e=this.worldSize;i=(t.x-n.x)/e,r=(t.y-n.y)/e}else{const e=this.pointCoordinate(t),o=this.pointCoordinate(n);i=e.x-o.x,r=e.y-o.y}const o=this.locationCoordinate(e);this.setLocation(new MercatorCoordinate(o.x-i,o.y-r))}setLocation(e){this.center=this.coordinateLocation(e),this.projection.wrap&&(this.center=this.center.wrap())}locationPoint(e){return this.projection.locationPoint(this,e)}locationPoint3D(e){return this.projection.locationPoint(this,e,!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(e,t){const i=t?yu(t,e.lat):void 0,r=this.projection.project(e.lng,e.lat);return new MercatorCoordinate(r.x,r.y,i)}coordinateLocation(e){return this.projection.unproject(e.x,e.y)}pointRayIntersection(e,t){const i=null!=t?t:this._centerAltitude,r=[e.x,e.y,0,1],n=[e.x,e.y,1,1];Wl.transformMat4(r,r,this.pixelMatrixInverse),Wl.transformMat4(n,n,this.pixelMatrixInverse);const o=n[3];Wl.scale(r,r,1/r[3]),Wl.scale(n,n,1/o);const a=r[2],s=n[2];return{p0:r,p1:n,t:a===s?0:(i-a)/(s-a)}}screenPointToMercatorRay(e){const t=[e.x,e.y,0,1],i=[e.x,e.y,1,1];return Wl.transformMat4(t,t,this.pixelMatrixInverse),Wl.transformMat4(i,i,this.pixelMatrixInverse),Wl.scale(t,t,1/t[3]),Wl.scale(i,i,1/i[3]),t[2]=yu(t[2],this._center.lat)*this.worldSize,i[2]=yu(i[2],this._center.lat)*this.worldSize,Wl.scale(t,t,1/this.worldSize),Wl.scale(i,i,1/this.worldSize),new Ray([t[0],t[1],t[2]],lc.normalize([],lc.sub([],i,t)))}rayIntersectionCoordinate(e){const{p0:t,p1:i,t:r}=e,n=yu(t[2],this._center.lat),o=yu(i[2],this._center.lat);return new MercatorCoordinate(yr(t[0],i[0],r)/this.worldSize,yr(t[1],i[1],r)/this.worldSize,yr(n,o,r))}pointCoordinate(e,t=this._centerAltitude){return this.projection.pointCoordinate(this,e.x,e.y,t)}pointCoordinate3D(e){if(!this.elevation)return this.pointCoordinate(e);let t=this.projection.pointCoordinate3D(this,e.x,e.y);if(t)return new MercatorCoordinate(t[0],t[1],t[2]);let i=0,r=this.horizonLineFromTop();if(e.y>r)return this.pointCoordinate(e);const n=.02*r,o=e.clone();for(let e=0;e<10&&r-i>n;e++){o.y=yr(i,r,.66);const e=this.projection.pointCoordinate3D(this,o.x,o.y);e?(r=o.y,t=e):i=o.y}return t?new MercatorCoordinate(t[0],t[1],t[2]):this.pointCoordinate(e)}isPointAboveHorizon(e){return this.projection.isPointAboveHorizon(this,e)}isPointOnSurface(e){if(e.y<0||e.y>this.height||e.x<0||e.x>this.width)return!1;if(this.elevation||this.zoom>=Mc)return!this.isPointAboveHorizon(e);const t=this.pointCoordinate(e);return t.y>=0&&t.y<=1}_coordinatePoint(e,t){const i=t&&this.elevation?this.elevation.getAtPointOrZero(e,this._centerAltitude):this._centerAltitude,r=[e.x*this.worldSize,e.y*this.worldSize,i+e.toAltitude(),1];return Wl.transformMat4(r,r,this.pixelMatrix),r[3]>0?new g(r[0]/r[3],r[1]/r[3]):new g(Number.MAX_VALUE,Number.MAX_VALUE)}_getBoundsNonRectangular(){const{top:e,left:t}=this._edgeInsets,i=this.height-this._edgeInsets.bottom,r=this.width-this._edgeInsets.right,n=this.pointLocation3D(new g(t,e)),o=this.pointLocation3D(new g(r,e)),a=this.pointLocation3D(new g(r,i)),s=this.pointLocation3D(new g(t,i));let l=Math.min(n.lng,o.lng,a.lng,s.lng),c=Math.max(n.lng,o.lng,a.lng,s.lng),u=Math.min(n.lat,o.lat,a.lat,s.lat),h=Math.max(n.lat,o.lat,a.lat,s.lat);const d=Math.pow(2,-this.zoom)/16*270,p="globe"===this.projection.name?1:4,f=(e,t,i,r,n)=>{const o=(e+i)/2,a=(t+r)/2,s=new g(o,a),{lng:m,lat:_}=this.pointLocation3D(s),y=Math.max(0,l-m,u-_,m-c,_-h);l=Math.min(l,m),c=Math.max(c,m),u=Math.min(u,_),h=Math.max(h,_),(n<p||y>d)&&(f(e,t,o,a,n+1),f(o,a,i,r,n+1))};if(f(t,e,r,e,1),f(r,e,r,i,1),f(r,i,t,i,1),f(t,i,t,e,1),"globe"===this.projection.name){const[e,t]=function(e){const t=ic.identity(new Float64Array(16));ic.multiply(t,e.pixelMatrix,e.globeMatrix);const i=[0,Dc,0],r=[0,Pc,0];return lc.transformMat4(i,i,t),lc.transformMat4(r,r,t),[i[0]>0&&i[0]<=e.width&&i[1]>0&&i[1]<=e.height&&!au(e,new du(e.center.lat,90)),r[0]>0&&r[0]<=e.width&&r[1]>0&&r[1]<=e.height&&!au(e,new du(e.center.lat,-90))]}(this);e?(h=90,c=180,l=-180):t&&(u=-90,c=180,l=-180)}return new LngLatBounds(new du(l,u),new du(c,h))}_getBoundsRectangular(e,t){const{top:i,left:r}=this._edgeInsets,n=this.height-this._edgeInsets.bottom,o=this.width-this._edgeInsets.right,a=new g(r,i),s=new g(o,i),l=new g(o,n),c=new g(r,n);let u=this.pointCoordinate(a,e),h=this.pointCoordinate(s,e);const d=this.pointCoordinate(l,t),p=this.pointCoordinate(c,t),f=(e,t)=>(t.y-e.y)/(t.x-e.x);return u.y>1&&h.y>=0?u=new MercatorCoordinate((1-p.y)/f(p,u)+p.x,1):u.y<0&&h.y<=1&&(u=new MercatorCoordinate(-p.y/f(p,u)+p.x,0)),h.y>1&&u.y>=0?h=new MercatorCoordinate((1-d.y)/f(d,h)+d.x,1):h.y<0&&u.y<=1&&(h=new MercatorCoordinate(-d.y/f(d,h)+d.x,0)),(new LngLatBounds).extend(this.coordinateLocation(u)).extend(this.coordinateLocation(h)).extend(this.coordinateLocation(p)).extend(this.coordinateLocation(d))}_getBoundsRectangularTerrain(){const e=this.elevation;if(!e.visibleDemTiles.length||e.isUsingMockSource())return this._getBoundsRectangular(0,0);const t=e.visibleDemTiles.reduce(((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0])}return e}),{min:Number.MAX_VALUE,max:0});return this._getBoundsRectangular(t.min*e.exaggeration(),t.max*e.exaggeration())}getBounds(){return"mercator"===this.projection.name||"equirectangular"===this.projection.name?this._terrainEnabled()?this._getBoundsRectangularTerrain():this._getBoundsRectangular(0,0):this._getBoundsNonRectangular()}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))-this.centerOffset.y,i=this.height/2-t*(1-this._horizonShift);return e?Math.max(0,i):i}getMaxBounds(){return this.maxBounds}setMaxBounds(e){this.maxBounds=e,this.minLat=-wu,this.maxLat=wu,this.minLng=-180,this.maxLng=180,e&&(this.minLat=e.getSouth(),this.maxLat=e.getNorth(),this.minLng=e.getWest(),this.maxLng=e.getEast(),this.maxLng<this.minLng&&(this.maxLng+=360)),this.worldMinX=_u(this.minLng)*this.tileSize,this.worldMaxX=_u(this.maxLng)*this.tileSize,this.worldMinY=gu(this.maxLat)*this.tileSize,this.worldMaxY=gu(this.minLat)*this.tileSize,this._constrain()}calculatePosMatrix(e,t){return this.projection.createTileMatrix(this,t,e)}calculateDistanceTileData(e){const t=e.key,i=this._distanceTileDataCache;if(i[t])return i[t];const r=e.canonical,n=1/this.height,o=this.cameraWorldSize,a=o/this.zoomScale(r.z),s=(r.x+Math.pow(2,r.z)*e.wrap)*a,l=r.y*a,c=this.point;c.x*=o/this.worldSize,c.y*=o/this.worldSize;const u=this.angle,h=Math.sin(-u),d=-Math.cos(-u);return i[t]={bearing:[h,d],center:[(c.x-s)*n,(c.y-l)*n],scale:a/Ri*n},i[t]}calculateFogTileMatrix(e){const t=e.key,i=this._fogTileMatrixCache;if(i[t])return i[t];const r=this.projection.createTileMatrix(this,this.cameraWorldSizeForFog,e);return ic.multiply(r,this.worldToFogMatrix,r),i[t]=new Float32Array(r),i[t]}calculateProjMatrix(e,t=!1){const i=e.key,r=t?this._alignedProjMatrixCache:this._projMatrixCache;if(r[i])return r[i];const n=this.calculatePosMatrix(e,this.worldSize);return ic.multiply(n,this.projection.isReprojectedInTileSpace?this.mercatorMatrix:t?this.alignedProjMatrix:this.projMatrix,n),r[i]=new Float32Array(n),r[i]}calculatePixelsToTileUnitsMatrix(e){const t=e.tileID.key,i=this._pixelsToTileUnitsCache;if(i[t])return i[t];const r=function(e,t){const{scale:i}=e.tileTransform,r=i*Ri/(e.tileSize*Math.pow(2,t.zoom-e.tileID.overscaledZ+e.tileID.canonical.z));return Kl.scale(new Float32Array(4),t.inverseAdjustmentMatrix,[r,r])}(e,this);return i[t]=r,i[t]}customLayerMatrix(){return this.mercatorMatrix.slice()}globeToMercatorMatrix(){if("globe"===this.projection.name){const e=1/this.worldSize,t=ic.fromScaling([],[e,e,e]);return ic.multiply(t,t,this.globeMatrix),t}}recenterOnTerrain(){if(!this._elevation||"globe"===this.projection.name)return;const e=this._elevation;this._updateCameraState();const t=yu(1,this._center.lat)*this.worldSize,i=this._computeCameraPosition(t),r=this._camera.forward(),n=yu(1,this._center.lat);i[2]/=n,r[2]/=n,lc.normalize(r,r);const o=e.raycast(i,r,e.exaggeration());if(o){const e=lc.scaleAndAdd([],i,r,o),t=new MercatorCoordinate(e[0],e[1],yu(e[2],vu(e[1]))),a=(t.z+lc.length([t.x-i[0],t.y-i[1],t.z-i[2]*n]))*this._pixelsPerMercatorPixel;this._seaLevelZoom=this._zoomFromMercatorZ(a),this._centerAltitude=t.toAltitude(),this._center=this.coordinateLocation(t),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices()}}_constrainCamera(e=!1){if(!this._elevation)return;const t=this._elevation,i=yu(1,this._center.lat)*this.worldSize,r=this._computeCameraPosition(i),n=t.getAtPointOrZero(new MercatorCoordinate(...r)),o=this.pixelsPerMeter/this.worldSize*n,a=this._minimumHeightOverTerrain(),s=r[2]-o;if(s<=a)if(s<0||e){const e=this.locationCoordinate(this._center,this._centerAltitude),t=[r[0],r[1],e.z-r[2]],i=lc.length(t);t[2]-=(a-s)/this._pixelsPerMercatorPixel;const n=lc.length(t);if(0===n)return;lc.scale(t,t,i/n*this._pixelsPerMercatorPixel),this._camera.position=[r[0],r[1],e.z*this._pixelsPerMercatorPixel-t[2]],this._updateStateFromCamera()}else this._isCameraConstrained=!0}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;const e="globe"===this.projection.name||this.mercatorFromTransition;if(this.projection.isReprojectedInTileSpace||e){const t=this.center;return t.lat=I(t.lat,this.minLat,this.maxLat),(this.maxBounds||!this.renderWorldCopies&&!e)&&(t.lng=I(t.lng,this.minLng,this.maxLng)),this.center=t,void(this._constraining=!1)}const t=this._unmodified,{x:i,y:r}=this.point;let n=0,o=i,a=r;const s=this.width/2,l=this.height/2,c=this.worldMinY*this.scale,u=this.worldMaxY*this.scale;if(r-l<c&&(a=c+l),r+l>u&&(a=u-l),u-c<this.height&&(n=Math.max(n,this.height/(u-c)),a=(u+c)/2),this.maxBounds||!this._renderWorldCopies||!this.projection.wrap){const e=this.worldMinX*this.scale,t=this.worldMaxX*this.scale,r=this.worldSize/2-(e+t)/2;o=(i+r+this.worldSize)%this.worldSize-r,o-s<e&&(o=e+s),o+s>t&&(o=t-s),t-e<this.width&&(n=Math.max(n,this.width/(t-e)),o=(t+e)/2)}o===i&&a===r||(this.center=this.unproject(new g(o,a))),n&&(this.zoom+=this.scaleZoom(n)),this._constrainCamera(),this._unmodified=t,this._constraining=!1}_minZoomForBounds(){let e=Math.max(0,this.scaleZoom(this.height/(this.worldMaxY-this.worldMinY)));return this.maxBounds&&(e=Math.max(e,this.scaleZoom(this.width/(this.worldMaxX-this.worldMinX)))),e}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const e=this.centerOffset,t="globe"===this.projection.name,i=this.pixelsPerMeter;"globe"===this.projection.name&&(this._mercatorScaleRatio=yu(1,this.center.lat)/yu(1,45));const r=qf(this.projection,this.zoom,this.width,this.height,1024);this._pixelsPerMercatorPixel=this.projection.pixelSpaceConversion(this.center.lat,this.worldSize,r),this.cameraToCenterDistance=.5/Math.tan(.5*this._fov)*this.height*this._pixelsPerMercatorPixel,this._updateCameraState(),this._farZ=this.projection.farthestPixelDistance(this),this._nearZ=this.height/50;const n="meters"===this.projection.zAxisUnit?i:1,o=this._camera.getWorldToCamera(this.worldSize,n);let a;const s=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,this._nearZ,this._farZ);if(s[8]=2*-e.x/this.width,s[9]=2*e.y/this.height,this.isOrthographic){let t=.5*this.height/Math.tan(this._fov/2)*1*Math.tan(.5*this._fov),i=t*this.aspect,r=-i,n=-t;i-=e.x,r-=e.x,t+=e.y,n+=e.y,a=this._camera.getCameraToClipOrthographic(r,i,n,t,this._nearZ,this._farZ),((e,t,i,r)=>{for(let n=0;n<16;n++)e[n]=dm(t[n],i[n],r)})(a,a,s,pm(this.pitch>=15?1:this.pitch/15))}else a=s;const l=ic.mul([],s,o);let c=ic.mul([],a,o);if(this.projection.isReprojectedInTileSpace){const e=this.locationCoordinate(this.center),t=ic.identity([]);ic.translate(t,t,[e.x*this.worldSize,e.y*this.worldSize,0]),ic.multiply(t,t,jf(this)),ic.translate(t,t,[-e.x*this.worldSize,-e.y*this.worldSize,0]),ic.multiply(c,c,t),ic.multiply(l,l,t),this.inverseAdjustmentMatrix=function(e){const t=jf(e,!0);return Kl.invert([],[t[0],t[1],t[4],t[5]])}(this)}else this.inverseAdjustmentMatrix=[1,0,0,1];this.mercatorMatrix=ic.scale([],c,[this.worldSize,this.worldSize,this.worldSize/n,1]),this.projMatrix=c,this.invProjMatrix=ic.invert(new Float64Array(16),this.projMatrix);const u=ic.invert([],a);this.frustumCorners=FrustumCorners.fromInvProjectionMatrix(u,this.horizonLineFromTop(),this.height),this.cameraFrustum=Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,0,!t);const h=new Float32Array(16);ic.identity(h),ic.scale(h,h,[1,-1,1]),ic.rotateX(h,h,this._pitch),ic.rotateZ(h,h,this.angle);const d=ic.perspective(new Float32Array(16),this._fov,this.width/this.height,this._nearZ,this._farZ);this.starsProjMatrix=ic.clone(d);const p=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;d[8]=2*-e.x/this.width,d[9]=2*(e.y+p)/this.height,this.skyboxMatrix=ic.multiply(h,d,h);const f=this.point,m=f.x,_=f.y,g=this.width%2/2,y=this.height%2/2,x=Math.cos(this.angle),v=Math.sin(this.angle),b=m-Math.round(m)+x*g+v*y,w=_-Math.round(_)+x*y+v*g,T=new Float64Array(c);if(ic.translate(T,T,[b>.5?b-1:b,w>.5?w-1:w,0]),this.alignedProjMatrix=T,c=ic.create(),ic.scale(c,c,[this.width/2,-this.height/2,1]),ic.translate(c,c,[1,-1,0]),this.labelPlaneMatrix=c,c=ic.create(),ic.scale(c,c,[1,-1,1]),ic.translate(c,c,[-1,-1,0]),ic.scale(c,c,[2/this.width,2/this.height,1]),this.glCoordMatrix=c,this.pixelMatrix=ic.multiply(new Float64Array(16),this.labelPlaneMatrix,l),this._calcFogMatrices(),this._distanceTileDataCache={},c=ic.invert(new Float64Array(16),this.pixelMatrix),!c)throw new Error("failed to invert matrix");if(this.pixelMatrixInverse=c,"globe"===this.projection.name||this.mercatorFromTransition){this.globeMatrix=function(e){const{x:t,y:i}=e.point,{lng:r,lat:n}=e._center;return Jc(t,i,e.worldSize,r,n)}(this);const e=[this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]];this.globeCenterInViewSpace=lc.transformMat4(e,e,o),this.globeRadius=this.worldSize/2/Math.PI-1}else this.globeMatrix=c;this._projMatrixCache={},this._alignedProjMatrixCache={},this._pixelsToTileUnitsCache={}}_calcFogMatrices(){this._fogTileMatrixCache={};const e=this.cameraWorldSizeForFog,t=this.cameraPixelsPerMeter,i=this._camera.position,r=1/this.height/this._pixelsPerMercatorPixel,n=[e,e,t];lc.scale(n,n,r),lc.scale(i,i,-1),lc.multiply(i,i,n);const o=ic.create();ic.translate(o,o,i),ic.scale(o,o,n),this.mercatorFogMatrix=o,this.worldToFogMatrix=this._camera.getWorldToCameraPosition(e,t,r)}_computeCameraPosition(e){const t=(e=e||this.pixelsPerMeter)/this.pixelsPerMeter,i=this._camera.forward(),r=this.point,n=this._mercatorZfromZoom(this._seaLevelZoom?this._seaLevelZoom:this._zoom)*t-e/this.worldSize*this._centerAltitude;return[r.x/this.worldSize-i[0]*n,r.y/this.worldSize-i[1]*n,e/this.worldSize*this._centerAltitude-i[2]*n]}_updateCameraState(){this.height&&(this._camera.setPitchBearing(this._pitch,this.angle),this._camera.position=this._computeCameraPosition())}_translateCameraConstrained(e){const t=this._maxCameraBoundsDistance()*Math.cos(this._pitch),i=this._camera.position[2],r=e[2];let n=1;this.projection.wrap&&(this.center=this.center.wrap()),r>0&&(n=Math.min((t-i)/r,1)),this._camera.position=lc.scaleAndAdd([],this._camera.position,e,n),this._updateStateFromCamera()}_updateStateFromCamera(){const e=this._camera.position,t=this._camera.forward(),{pitch:i,bearing:r}=this._camera.getPitchBearing(),n=yu(this._centerAltitude,this.center.lat)*this._pixelsPerMercatorPixel,o=this._mercatorZfromZoom(this._maxZoom)*Math.cos(b(this._maxPitch)),a=Math.max((e[2]-n)/Math.cos(i),o),s=this._zoomFromMercatorZ(a);lc.scaleAndAdd(e,e,t,a),this._pitch=I(i,b(this.minPitch),b(this.maxPitch)),this.angle=P(r,-Math.PI,Math.PI),this._setZoom(I(s,this._minZoom,this._maxZoom)),this._updateSeaLevelZoom(),this._center=this.coordinateLocation(new MercatorCoordinate(e[0],e[1],e[2])),this._unmodified=!1,this._constrain(),this._calcMatrices()}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min((null!=this._seaLevelZoom?this._seaLevelZoom:this._zoom)+4,this._maxZoom);return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}zoomFromMercatorZAdjusted(e){let t=0,i=Mc,r=0,n=1/0;for(;i-t>1e-6&&i>t;){const o=t+.5*(i-t),a=this.tileSize*Math.pow(2,o),s=this.getCameraToCenterDistance(this.projection,o,a),l=this.scaleZoom(s/(e*this.tileSize)),c=Math.abs(o-l);c<n&&(n=c,r=o),o<l?t=o:i=o}return r}_terrainEnabled(){return!(!this._elevation||!this.projection.supportsTerrain&&($("Terrain is not yet supported with alternate projections. Use mercator or globe to enable terrain."),1))}anyCornerOffEdge(e,t){const i=Math.min(e.x,t.x),r=Math.max(e.x,t.x),n=Math.min(e.y,t.y),o=Math.max(e.y,t.y);if(n<this.horizonLineFromTop(!1))return!0;if("mercator"!==this.projection.name)return!1;const a=[new g(i,n),new g(r,o),new g(i,o),new g(r,n)],s=this.renderWorldCopies?-3:0,l=this.renderWorldCopies?4:1;for(const e of a){const t=this.pointRayIntersection(e);if(t.t<0)return!0;const i=this.rayIntersectionCoordinate(t);if(i.x<s||i.y<0||i.x>l||i.y>1)return!0}return!1}isHorizonVisible(){return this.pitch+w(this.fovAboveCenter)>88||this.anyCornerOffEdge(new g(0,0),new g(this.width,this.height))}zoomDeltaToMovement(e,t){const i=lc.length(lc.sub([],this._camera.position,e)),r=this._zoomFromMercatorZ(i)+t;return i-this._mercatorZfromZoom(r)}getCameraPoint(){if("globe"===this.projection.name){const e=function([e,t,i],r){const n=[e,t,i,1];Wl.transformMat4(n,n,r);const o=n[3]=Math.max(n[3],1e-6);return n[0]/=o,n[1]/=o,n[2]/=o,n}([this.globeMatrix[12],this.globeMatrix[13],this.globeMatrix[14]],this.pixelMatrix);return new g(e[0],e[1])}{const e=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new g(0,e))}}getCameraToCenterDistance(e,t=this.zoom,i=this.worldSize){const r=qf(e,t,this.width,this.height,1024),n=e.pixelSpaceConversion(this.center.lat,i,r);let o=.5/Math.tan(.5*this._fov)*this.height*n;return this.isOrthographic&&(o=dm(1,o,pm(this.pitch>=15?1:this.pitch/15))),o}getWorldToCameraMatrix(){const e=this._camera.getWorldToCamera(this.worldSize,"meters"===this.projection.zAxisUnit?this.pixelsPerMeter:1);return"globe"===this.projection.name&&ic.multiply(e,e,this.globeMatrix),e}getFrustum(e){return Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,e,"meters"===this.projection.zAxisUnit)}}function fm(e,t,i){ic.identity(e),ic.rotateZ(e,e,b(t[2])),ic.rotateX(e,e,b(t[0])),ic.rotateY(e,e,b(t[1])),ic.scale(e,e,i),ic.multiply(e,e,[1,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1])}function mm(e,t,i,r,n,o,a,s){const l=[i[0]-t[0],i[1]-t[1],0],c=[r[0]-t[0],r[1]-t[1],0];if(lc.length(l)<1e-12||lc.length(c)<1e-12)return nc.identity(e);const u=lc.cross([],l,c);lc.normalize(u,u),lc.subtract(c,r,t),l[2]=(o-n)*s,c[2]=(a-n)*s;const h=l;return lc.cross(h,l,c),lc.normalize(h,h),nc.rotationTo(e,u,h)}function _m(e,t,i=!1){const r=Qc(t.zoom),n=function(e,t,i){const r=t.worldSize,n=[e[12],e[13],e[14]],o=vu(n[1]/r),a=xu(n[0]/r),s=ic.identity([]),l=yu(1,o)*r,c=yu(1,0)*r*Eu(o,t.zoom),u=1/Yc(r);let h=c*u;if(i){const e=qf(t.projection,t.zoom,t.width,t.height,1024);h=u*t.projection.pixelSpaceConversion(t.center.lat,r,e)}const d=qc(o,a);lc.add(d,d,lc.scale([],lc.normalize([],d),l*h*n[2]));const p=function(e){const t=[e[0],e[1],e[2]];let i=[0,1,0];const r=lc.cross([],i,t);return lc.cross(i,t,r),0===lc.squaredLength(i)&&(i=[0,1,0],lc.cross(r,t,i)),lc.normalize(r,r),lc.normalize(i,i),lc.normalize(t,t),[r[0],r[1],r[2],0,i[0],i[1],i[2],0,t[0],t[1],t[2],0,e[0],e[1],e[2],1]}(d);ic.scale(s,s,[h,h,h*l]),ic.translate(s,s,[-n[0],-n[1],-n[2]]);const f=ic.multiply([],t.globeMatrix,p);return ic.multiply(f,f,s),ic.multiply(f,f,e),f}(e,t,i);if(r>0){const i=function(e,t){const i=t.worldSize,r=yu(1,0)*i*Eu(t.center.lat,t.zoom)/Yc(i),n=yu(1,t.center.lat)*i,o=ic.identity([]);return ic.rotateY(o,o,b(t.center.lng)),ic.rotateX(o,o,b(t.center.lat)),ic.translate(o,o,[0,0,Sc]),ic.scale(o,o,[r,r,r*n]),ic.translate(o,o,[t.point.x-.5*i,t.point.y-.5*i,0]),ic.multiply(o,o,e),ic.multiply(o,t.globeMatrix,o)}(e,t);return function(e,t,i){const r=(e,t,i)=>{const r=lc.length(e),n=lc.length(t),o=Oc(e,t,i);return lc.scale(o,o,1/lc.length(o)*yr(r,n,i))},n=r([e[0],e[1],e[2]],[t[0],t[1],t[2]],i),o=r([e[4],e[5],e[6]],[t[4],t[5],t[6]],i),a=r([e[8],e[9],e[10]],[t[8],t[9],t[10]],i),s=Oc([e[12],e[13],e[14]],[t[12],t[13],t[14]],i);return[n[0],n[1],n[2],0,o[0],o[1],o[2],0,a[0],a[1],a[2],0,s[0],s[1],s[2],1]}(n,i,r)}return n}const gm=[1,1,1];class Model{constructor(e,t,i,r){this.id=e,this.position=null!=t?new du(t[0],t[1]):new du(0,0),this.orientation=null!=i?i:[0,0,0],this.nodes=r,this.uploaded=!1,this.aabb=new Aabb([1/0,1/0,1/0],[-1/0,-1/0,-1/0]),this.matrix=[]}_applyTransformations(e,t){if(ic.multiply(e.matrix,t,e.matrix),e.meshes)for(const t of e.meshes){const i=Aabb.applyTransform(t.aabb,e.matrix);this.aabb.encapsulate(i)}if(e.children)for(const t of e.children)this._applyTransformations(t,e.matrix)}computeBoundsAndApplyParent(){const e=ic.identity([]);for(const t of this.nodes)this._applyTransformations(t,e)}_positionModelOnTerrain(e,t){const i=e.elevation;if(!i)return 0;const r=Aabb.projectAabbCorners(this.aabb,this.matrix),n=yu(1,this.position.lat)*e.worldSize,o=function(e,t){const i=[0,0,1],r=[{corners:[0,1,3,2],dotProductWithUp:0},{corners:[1,5,2,6],dotProductWithUp:0},{corners:[0,4,1,5],dotProductWithUp:0},{corners:[2,6,3,7],dotProductWithUp:0},{corners:[4,7,5,6],dotProductWithUp:0},{corners:[0,3,4,7],dotProductWithUp:0}];for(const n of r){const r=e[n.corners[0]],o=e[n.corners[1]],a=e[n.corners[2]],s=[o[0]-r[0],o[1]-r[1],t*(o[2]-r[2])],l=lc.cross(s,s,[a[0]-r[0],a[1]-r[1],t*(a[2]-r[2])]);lc.normalize(l,l),n.dotProductWithUp=lc.dot(l,i)}return r.sort(((e,t)=>e.dotProductWithUp-t.dotProductWithUp)),r[0].corners}(r,n),a=r[o[0]],s=r[o[1]],l=r[o[2]],c=r[o[3]],u=i.getAtPointOrZero(new MercatorCoordinate(a[0]/e.worldSize,a[1]/e.worldSize),0),h=i.getAtPointOrZero(new MercatorCoordinate(s[0]/e.worldSize,s[1]/e.worldSize),0),d=i.getAtPointOrZero(new MercatorCoordinate(l[0]/e.worldSize,l[1]/e.worldSize),0),p=i.getAtPointOrZero(new MercatorCoordinate(c[0]/e.worldSize,c[1]/e.worldSize),0),f=(u+p)/2,m=(h+d)/2;return f>m?h<d?mm(t,s,c,a,h,p,u,n):mm(t,l,a,c,d,u,p,n):u<p?mm(t,a,s,l,u,h,d,n):mm(t,c,l,s,p,d,h,n),Math.max(f,m)}computeModelMatrix(e,t,i,r,n,o,a=!1){const s=e.transform,l=s.zoom,c=s.project(this.position),u=Eu(this.position.lat,l),h=1/u;ic.identity(this.matrix),ic.translate(this.matrix,this.matrix,[c.x+r[0]*h,c.y+r[1]*h,r[2]]);let d=1,p=1;const f=s.worldSize;if(a){if("mercator"===s.projection.name){let e=0;s.elevation&&(e=s.elevation.getAtPointOrZero(new MercatorCoordinate(c.x/f,c.y/f),0));const t=Wl.transformMat4([],[c.x,c.y,e,1],s.projMatrix)[3]/s.cameraToCenterDistance;d=t,p=t*Eu(s.center.lat,l)}else if("globe"===s.projection.name){const e=_m(this.matrix,s),t=ic.multiply([],s.projMatrix,e),i=[0,0,0,1];Wl.transformMat4(i,i,t);const r=i[3]/s.cameraToCenterDistance,n=Qc(l),o=s.projection.pixelsPerMeter(this.position.lat,f)*Eu(this.position.lat,l),a=s.projection.pixelsPerMeter(s.center.lat,f)*Eu(s.center.lat,l);d=r/yr(o,Tu(s.center.lat),n),p=r*u/o,d*=a,p*=a}}else d=h;ic.scale(this.matrix,this.matrix,[d,d,p]);const m=[...this.matrix],_=this.orientation,g=[];if(fm(g,[_[0]+t[0],_[1]+t[1],_[2]+t[2]],i),ic.multiply(this.matrix,m,g),n&&s.elevation){let e=0;const t=[];if(o&&s.elevation){e=this._positionModelOnTerrain(s,t);const i=ic.fromQuat([],t),r=ic.multiply([],i,g);ic.multiply(this.matrix,m,r)}else e=s.elevation.getAtPointOrZero(new MercatorCoordinate(c.x/f,c.y/f),0);0!==e&&(this.matrix[14]+=e)}}upload(e){if(!this.uploaded){for(const t of this.nodes)vm(t,e);for(const e of this.nodes)bm(e);this.uploaded=!0}}destroy(){for(const e of this.nodes)wm(e)}}function ym(e,t,i=!1){e.uploaded||(e.gfxTexture=new Texture(t,e.image,i?t.gl.R8:t.gl.RGBA,{useMipmap:e.sampler.minFilter>=t.gl.NEAREST_MIPMAP_NEAREST}),e.uploaded=!0,e.image=null)}function xm(e,t,i){e.indexBuffer=t.createIndexBuffer(e.indexArray,!1,!0),e.vertexBuffer=t.createVertexBuffer(e.vertexArray,Lf.members,!1,!0),e.normalArray&&(e.normalBuffer=t.createVertexBuffer(e.normalArray,Bf.members,!1,!0)),e.texcoordArray&&(e.texcoordBuffer=t.createVertexBuffer(e.texcoordArray,kf.members,!1,!0)),e.colorArray&&(e.colorBuffer=t.createVertexBuffer(e.colorArray,(12===e.colorArray.bytesPerElement?zf:Rf).members,!1,!0)),e.featureArray&&(e.pbrBuffer=t.createVertexBuffer(e.featureArray,Ff.members,!0)),e.segments=SegmentVector.simpleSegment(0,0,e.vertexArray.length,e.indexArray.length);const r=e.material;r.pbrMetallicRoughness.baseColorTexture&&ym(r.pbrMetallicRoughness.baseColorTexture,t),r.pbrMetallicRoughness.metallicRoughnessTexture&&ym(r.pbrMetallicRoughness.metallicRoughnessTexture,t),r.normalTexture&&ym(r.normalTexture,t),r.occlusionTexture&&ym(r.occlusionTexture,t,i),r.emissionTexture&&ym(r.emissionTexture,t)}function vm(e,t,i){if(e.meshes)for(const r of e.meshes)xm(r,t,i);if(e.children)for(const r of e.children)vm(r,t,i)}function bm(e){if(e.meshes)for(const t of e.meshes)t.indexArray.destroy(),t.vertexArray.destroy(),t.colorArray&&t.colorArray.destroy(),t.normalArray&&t.normalArray.destroy(),t.texcoordArray&&t.texcoordArray.destroy(),t.featureArray&&t.featureArray.destroy();if(e.children)for(const t of e.children)bm(t)}function wm(e){if(e.meshes)for(const i of e.meshes)i.vertexBuffer&&(i.vertexBuffer.destroy(),i.indexBuffer.destroy(),i.normalBuffer&&i.normalBuffer.destroy(),i.texcoordBuffer&&i.texcoordBuffer.destroy(),i.colorBuffer&&i.colorBuffer.destroy(),i.pbrBuffer&&i.pbrBuffer.destroy(),i.segments.destroy(),i.material&&((t=i.material).pbrMetallicRoughness.baseColorTexture&&t.pbrMetallicRoughness.baseColorTexture.gfxTexture&&t.pbrMetallicRoughness.baseColorTexture.gfxTexture.destroy(),t.pbrMetallicRoughness.metallicRoughnessTexture&&t.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture&&t.pbrMetallicRoughness.metallicRoughnessTexture.gfxTexture.destroy(),t.normalTexture&&t.normalTexture.gfxTexture&&t.normalTexture.gfxTexture.destroy(),t.emissionTexture&&t.emissionTexture.gfxTexture&&t.emissionTexture.gfxTexture.destroy(),t.occlusionTexture&&t.occlusionTexture.gfxTexture&&t.occlusionTexture.gfxTexture.destroy()));var t;if(e.children)for(const t of e.children)wm(t)}class ModelFeature{constructor(e,t){this.feature=e,this.instancedDataOffset=t,this.instancedDataCount=0,this.rotation=[0,0,0],this.scale=[1,1,1],this.translation=[0,0,0]}}class PerModelAttributes{constructor(){this.instancedDataArray=new StructArrayLayout16f64,this.instancesEvaluatedElevation=[],this.features=[],this.idToFeaturesIndex={}}}class ModelBucket{constructor(e){this.zoom=e.zoom,this.canonical=e.canonical,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.fqid)),this.projection=e.projection,this.index=e.index,this.hasZoomDependentProperties=this.layers[0].isZoomDependent(),this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.hasPattern=!1,this.instancesPerModel={},this.validForExaggeration=0,this.maxVerticalOffset=0,this.maxScale=0,this.maxHeight=0,this.lookupDim=this.zoom>this.canonical.z?256:this.zoom>15?75:100,this.instanceCount=0,this.terrainElevationMin=0,this.terrainElevationMax=0,this.validForDEMTile={id:null,timestamp:0}}populate(e,t,i,r){this.tileToMeter=Su(i);const n=this.layers[0]._featureFilter.needGeometry;this.lookup=new Uint8Array(this.lookupDim*this.lookupDim);for(const{feature:o,id:a,index:s,sourceLayerIndex:l}of e){const e=ku(o,n);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),e,i))continue;const c={id:a,sourceLayerIndex:l,index:s,geometry:n?e.geometry:Ru(o,i,r),properties:o.properties,type:o.type,patterns:{}},u=this.addFeature(c,c.geometry,e);u&&t.featureIndex.insert(o,c.geometry,s,l,this.index,this.instancesPerModel[u].instancedDataArray.length)}this.lookup=null}update(e,t,i,r){for(const t in this.instancesPerModel){const i=this.instancesPerModel[t];for(const t in e)i.idToFeaturesIndex.hasOwnProperty(t)&&this.evaluate(i.features[i.idToFeaturesIndex[t]],e[t],i,!0)}this.maxHeight=0}updateZoomBasedPaintProperties(){if(!this.hasZoomDependentProperties)return!1;let e=!1;for(const t in this.instancesPerModel){const i=this.instancesPerModel[t];for(const t of i.features){const r=this.layers[0],n=t.feature,o=this.canonical,a=r.paint.get("model-rotation").evaluate(n,{},o),s=r.paint.get("model-scale").evaluate(n,{},o),l=r.paint.get("model-translation").evaluate(n,{},o);lc.exactEquals(t.rotation,a)&&lc.exactEquals(t.scale,s)&&lc.exactEquals(t.translation,l)||(this.evaluate(t,t.featureStates,i,!0),e=!0)}}return e}isEmpty(){for(const e in this.instancesPerModel)if(0!==this.instancesPerModel[e].instancedDataArray.length)return!1;return!0}uploadPending(){return!this.uploaded}upload(e){if(!this.uploaded)for(const t in this.instancesPerModel){const i=this.instancesPerModel[t];i.instancedDataArray.length<0||0===i.instancedDataArray.length||(i.instancedDataBuffer?i.instancedDataBuffer.updateData(i.instancedDataArray):i.instancedDataBuffer=e.createVertexBuffer(i.instancedDataArray,Of.members,!0,void 0,this.instanceCount))}this.uploaded=!0}destroy(){for(const e in this.instancesPerModel){const t=this.instancesPerModel[e];0!==t.instancedDataArray.length&&t.instancedDataBuffer&&t.instancedDataBuffer.destroy()}}addFeature(e,t,i){const r=this.layers[0],n=r.layout.get("model-id").evaluate(i,{},this.canonical);if(!n)return $(`modelId is not evaluated for layer ${r.id} and it is not going to get rendered.`),n;this.instancesPerModel[n]||(this.instancesPerModel[n]=new PerModelAttributes);const o=this.instancesPerModel[n],a=o.instancedDataArray,s=new ModelFeature(i,a.length);for(const e of t)for(const t of e){if(t.x<0||t.x>=Ri||t.y<0||t.y>=Ri)continue;const e=(this.lookupDim-1)/Ri,i=this.lookupDim*(t.y*e|0)+t.x*e|0;if(this.lookup){if(0!==this.lookup[i])continue;this.lookup[i]=1}this.instanceCount++;const r=a.length;a.resize(r+1),o.instancesEvaluatedElevation.push(0),a.float32[16*r]=t.x,a.float32[16*r+1]=t.y}return s.instancedDataCount=o.instancedDataArray.length-s.instancedDataOffset,s.instancedDataCount>0&&(e.id&&(o.idToFeaturesIndex[e.id]=o.features.length),o.features.push(s),this.evaluate(s,{},o,!1)),n}evaluate(e,t,i,r){const n=this.layers[0],o=e.feature,a=this.canonical,s=e.rotation=n.paint.get("model-rotation").evaluate(o,t,a),l=e.scale=n.paint.get("model-scale").evaluate(o,t,a),c=e.translation=n.paint.get("model-translation").evaluate(o,t,a),u=n.paint.get("model-color").evaluate(o,t,a);u.a=n.paint.get("model-color-mix-intensity").evaluate(o,t,a);const h=[];this.maxVerticalOffset<c[2]&&(this.maxVerticalOffset=c[2]),this.maxScale=Math.max(Math.max(this.maxScale,l[0]),Math.max(l[1],l[2])),fm(h,s,l);const d=Math.round(100*u.a)+u.b/1.05;for(let t=0;t<e.instancedDataCount;++t){const n=e.instancedDataOffset+t,o=16*n,s=i.instancedDataArray.float32;let l=0;r&&(l=s[o+6]-i.instancesEvaluatedElevation[n]);const p=0|s[o+1];s[o]=(0|s[o])+u.r/1.05,s[o+1]=p+u.g/1.05,s[o+2]=d,s[o+3]=1/(a.z>10?this.tileToMeter:Su(a,p)),s[o+4]=c[0],s[o+5]=c[1],s[o+6]=c[2]+l,s[o+7]=h[0],s[o+8]=h[1],s[o+9]=h[2],s[o+10]=h[4],s[o+11]=h[5],s[o+12]=h[6],s[o+13]=h[8],s[o+14]=h[9],s[o+15]=h[10],i.instancesEvaluatedElevation[n]=c[2]}}}Fo(ModelBucket,"ModelBucket",{omit:["layers"]}),Fo(PerModelAttributes,"PerModelAttributes"),Fo(ModelFeature,"ModelFeature");const Tm=new Properties({visibility:new DataConstantProperty(xt.layout_model.visibility),"model-id":new DataDrivenProperty(xt.layout_model["model-id"])});var Em={paint:new Properties({"model-opacity":new DataConstantProperty(xt.paint_model["model-opacity"]),"model-rotation":new DataDrivenProperty(xt.paint_model["model-rotation"]),"model-scale":new DataDrivenProperty(xt.paint_model["model-scale"]),"model-translation":new DataDrivenProperty(xt.paint_model["model-translation"]),"model-color":new DataDrivenProperty(xt.paint_model["model-color"]),"model-color-mix-intensity":new DataDrivenProperty(xt.paint_model["model-color-mix-intensity"]),"model-type":new DataConstantProperty(xt.paint_model["model-type"]),"model-cast-shadows":new DataConstantProperty(xt.paint_model["model-cast-shadows"]),"model-receive-shadows":new DataConstantProperty(xt.paint_model["model-receive-shadows"]),"model-ambient-occlusion-intensity":new DataConstantProperty(xt.paint_model["model-ambient-occlusion-intensity"]),"model-emissive-strength":new DataDrivenProperty(xt.paint_model["model-emissive-strength"]),"model-roughness":new DataDrivenProperty(xt.paint_model["model-roughness"]),"model-height-based-emissive-strength-multiplier":new DataDrivenProperty(xt.paint_model["model-height-based-emissive-strength-multiplier"]),"model-cutoff-fade-range":new DataConstantProperty(xt.paint_model["model-cutoff-fade-range"])}),layout:Tm};const Mm=new Float32Array(262144),Sm=new Uint8Array(262144);function Am(e){let t=0;if(e.meshes)for(const i of e.meshes)t=Math.max(t,i.aabb.max[2]);if(e.children)for(const i of e.children)t=Math.max(t,Am(i));return t}const Cm=["","wall","door","roof","window","lamp","logo"];class Tiled3dModelFeature{constructor(e){this.node=e,this.evaluatedRMEA=[[1,0,0,1],[1,0,0,1],[1,0,0,1],[1,0,0,1],[.4,1,0,1],[1,0,0,1],[1,0,0,1]],this.hiddenByReplacement=!1,this.evaluatedScale=[1,1,1],this.evaluatedColor=[],this.emissionHeightBasedParams=[],this.feature={type:"Point",id:e.id,geometry:[],properties:{height:Am(e)}}}}function Im(e,t){return!e.isLightConstant&&t}function Dm(e,t,i,r,n,o,a,s){let l=(61440&t|(61440&t)>>4)>>8,c=(3840&t|(3840&t)>>4)>>4,u=240&t|(240&t)>>4;i[3]>0&&(l=yr(l,255*i[0],i[3]),c=yr(c,255*i[1],i[3]),u=yr(u,255*i[2],i[3]));const h=l<<8|c,d=u<<8|Math.floor(255*r[3]),p=function(e){const t=I(e,0,2);return Math.min(Math.round(.5*t*255),255)}(r[2])<<8|15*r[0]<<4|15*r[1],f=I(n[0],0,1),m=I(n[1],0,1),_=I(n[2],0,1),g=I(n[3],0,1);let y,x,v,b;if(f!==m&&a!==o&&m!==f){const e=a-o;x=1/(e*(m-f)),v=-(o+e*f)/(e*(m-f));const t=I(n[4],-1,1);b=Math.pow(10,t),y=255*_<<8|255*g}else y=65535,x=0,v=1,b=1;if(e.emplaceBack(h,d,p,y,x,v,b),s){const e=s.length;s.clear();for(let t=0;t<e;t++)s.emplaceBack(h,d,p,y,x,v,b)}}function Pm(e,t){const i=e.node;let r=0;for(const n of i.meshes){if(i.lights&&i.lightMeshIndex===r)continue;if(!n.featureData)continue;n.featureArray=new StructArrayLayout4ui3f20,n.featureArray.reserve(n.featureData.length);let o=t;for(const t of n.featureData){let r;const a=65535&t,s=(15&a)<8?15&a:0,l=t>>16&65535,c=e.evaluatedRMEA[s],u=e.evaluatedColor[s],h=e.emissionHeightBasedParams[s];if(o&&2===s&&i.lights&&(r=new StructArrayLayout4ui3f20,r.resize(10*i.lights.length)),Dm(n.featureArray,l,u,c,h,n.aabb.min[2],n.aabb.max[2],r),r&&o){o=!1;const e=i.meshes[i.lightMeshIndex];e.featureArray=r,e.featureArray._trim()}}n.featureArray._trim(),r++}}Fo(class Tiled3dModelBucket{constructor(e,t,i,r){this.nodes=e,this.id=t,this.modelTraits|=1,this.uploaded=!1,this.hasPattern=!1,i&&(this.modelTraits|=4),this.zoom=-1,this.terrainExaggeration=1,this.projection={name:"mercator"},this.replacementUpdateTime=0,this.elevationReadFromZ=255,this.brightness=r,this.dirty=!0,this.needsUpload=!1}update(){console.log("Update 3D model bucket")}populate(){console.log("populate 3D model bucket")}uploadPending(){return!this.uploaded||this.needsUpload}upload(e){if(!this.needsUpload)return;const t=this.getNodesInfo();for(const i of t){const t=i.node;this.uploaded?this.updatePbrBuffer(t):vm(t,e,!0)}for(const e of t)bm(e.node);this.uploaded=!0,this.needsUpload=!1}updatePbrBuffer(e){let t=!1;if(!e.meshes)return t;for(const i of e.meshes)i.pbrBuffer&&(i.pbrBuffer.updateData(i.featureArray),t=!0);return t}needsReEvaluation(e,t,i){const r=e.transform.projectionOptions,n=e.style.getBrightness(),o=this.brightness!==n;return!!(!this.uploaded||this.dirty||r.name!==this.projection.name||Im(i.paint.get("model-color").value,o)||Im(i.paint.get("model-color-mix-intensity").value,o)||Im(i.paint.get("model-roughness").value,o)||Im(i.paint.get("model-emissive-strength").value,o)||Im(i.paint.get("model-height-based-emissive-strength-multiplier").value,o))&&(this.projection=r,this.brightness=n,!0)}evaluateScale(e,t){if(e.transform.zoom===this.zoom)return;this.zoom=e.transform.zoom;const i=this.getNodesInfo(),r=this.id.canonical;for(const e of i){const i=e.feature;e.evaluatedScale=t.paint.get("model-scale").evaluate(i,{},r)}}evaluate(e){const t=this.getNodesInfo();for(const i of t){if(!i.node.meshes)continue;const t=i.feature,r=i.node.meshes&&i.node.meshes[0].featureData,n=i.evaluatedColor[2],o=i.evaluatedRMEA[2],a=this.id.canonical;if(i.hasTranslucentParts=!1,r){for(let r=0;r<Cm.length;r++){const n=Cm[r];n.length&&(t.properties.part=n);const o=e.paint.get("model-color").evaluate(t,{},a),s=e.paint.get("model-color-mix-intensity").evaluate(t,{},a);i.evaluatedColor[r]=[o.r,o.g,o.b,s],i.evaluatedRMEA[r][0]=e.paint.get("model-roughness").evaluate(t,{},a),i.evaluatedRMEA[r][2]=e.paint.get("model-emissive-strength").evaluate(t,{},a),i.evaluatedRMEA[r][3]=o.a,i.emissionHeightBasedParams[r]=e.paint.get("model-height-based-emissive-strength-multiplier").evaluate(t,{},a),!i.hasTranslucentParts&&o.a<1&&(i.hasTranslucentParts=!0)}delete t.properties.part,Pm(i,n!==i.evaluatedColor[2]||o!==i.evaluatedRMEA[2])}i.evaluatedScale=e.paint.get("model-scale").evaluate(t,{},a),this.updatePbrBuffer(i.node)||(this.needsUpload=!0)}this.dirty=!1}elevationUpdate(e,t,i,r){const n=e.findDEMTileFor(i);if(n&&(n.tileID.canonical!==this.terrainTile||t!==this.terrainExaggeration)){if(n.dem&&n.tileID.overscaledZ!==this.elevationReadFromZ){this.elevationReadFromZ=n.tileID.overscaledZ;const t=DEMSampler.create(e,i,n);if(!t)return;4&this.modelTraits&&this.updateDEM(e,t,i,r);for(const e of this.getNodesInfo()){const i=e.node;if(!i.footprint||!i.footprint.vertices||!i.footprint.vertices.length)continue;const r=i.footprint.vertices;let n=t.getElevationAt(r[0].x,r[0].y,!0,!0);for(let e=1;e<r.length;e++)n=Math.min(n,t.getElevationAt(r[e].x,r[e].y,!0,!0));i.elevation=n}}this.terrainTile=n.tileID.canonical,this.terrainExaggeration=t}}updateDEM(e,t,i,r){let n=t._dem._modifiedForSources[r];if(void 0===n&&(t._dem._modifiedForSources[r]=[],n=t._dem._modifiedForSources[r]),n.includes(i.canonical))return;const o=t._dem.dim;n.push(i.canonical);let a=!1;for(const e of this.getNodesInfo()){const i=e.node;if(!i.footprint||!i.footprint.grid)continue;const r=i.footprint.grid,n=t.tileCoordToPixel(r.min.x,r.min.y),s=t.tileCoordToPixel(r.max.x,r.max.y),l=Math.min(Math.min(o-s.y,n.x),Math.min(n.y,o-s.x));if(l<0)continue;const c=I(l,2,5);let u=Math.max(0,n.x-c),h=Math.max(0,n.y-c),d=Math.min(s.x+c,o-1),p=Math.min(s.y+c,o-1);for(let e=h;e<=p;++e)for(let t=u;t<=d;++t)Sm[e*o+t]=255;let f=0,m=0;for(let e=0;e<r.cellsY;++e)for(let i=0;i<r.cellsX;++i){if(!r.cells[e*r.cellsX+i])continue;const n=t.tileCoordToPixel(r.min.x+i/r.xScale,r.min.y+e/r.yScale),a=t.tileCoordToPixel(r.min.x+(i+1)/r.xScale,r.min.y+(e+1)/r.yScale);for(let e=n.y;e<=Math.min(a.y+1,o-1);++e)for(let i=n.x;i<=Math.min(a.x+1,o-1);++i)255===Sm[e*o+i]&&(Sm[e*o+i]=0,f+=t.getElevationAtPixel(i,e),m++)}const _=f/m;u=Math.max(1,n.x-c),h=Math.max(1,n.y-c),d=Math.min(s.x+c,o-2),p=Math.min(s.y+c,o-2),a=!0;for(let e=h;e<=p;++e)for(let i=u;i<=d;++i)0===Sm[e*o+i]&&(Mm[e*o+i]=t._dem.set(i,e,_));for(let e=1;e<c;++e){u=Math.max(1,n.x-e),h=Math.max(1,n.y-e),d=Math.min(s.x+e,o-2),p=Math.min(s.y+e,o-2);for(let i=h;i<=p;++i)for(let r=u;r<=d;++r){const n=i*o+r;if(255===Sm[n]){let a=0,s=0,l=-1,u=-1;for(let t=-1;t<=1;++t)for(let n=-1;n<=1;++n){const c=(i+t)*o+r+n;if(Sm[c]>=e)continue;const h=Mm[c],d=Math.abs(h);d>s&&(a=h,s=d,l=n,u=t)}if(s>.1){const o=1-(e+.5*Math.abs(l*u))/c;let s=t._dem.get(r,i)+a*o;const h=t._dem.get(r+l,i+u),d=t._dem.get(r-l,i-u,!0);(s-h)*(s-d)>0&&(s=(h+d)/2),Mm[n]=t._dem.set(r,i,s),Sm[n]=e}}}}}a&&(t._demTile.needsDEMTextureUpload=!0,t._dem._timestamp=rt.now())}getNodesInfo(){if(!this.nodesInfo){this.nodesInfo=[];for(const e of this.nodes)this.nodesInfo.push(new Tiled3dModelFeature(e));this.freeNodes()}return this.nodesInfo}freeNodes(){if(this.nodes){for(const e of this.nodes)wm(e);this.nodes.splice(0,this.nodes.length)}}destroy(){this.freeNodes();const e=this.getNodesInfo();for(const t of e)bm(t.node),wm(t.node)}isEmpty(){return!this.nodes.length}updateReplacement(e,t){if(t.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=t.updateTime;const i=t.getReplacementRegionsForTile(e.toUnwrapped()),r=this.getNodesInfo();for(let e=0;e<this.nodesInfo.length;e++){const t=r[e].node;r[e].hiddenByReplacement=!!t.footprint&&!i.find((e=>e.footprint===t.footprint))}}getHeightAtTileCoord(e,t){const i=this.getNodesInfo(),r=[];for(let n=0;n<this.nodesInfo.length;n++){const o=i[n],a=o.node.meshes[0];if(e<a.aabb.min[0]||t<a.aabb.min[1]||e>a.aabb.max[0]||t>a.aabb.max[1])continue;const s=(e-a.aabb.min[0])/(a.aabb.max[0]-a.aabb.min[0])*64|0,l=64*Math.min(63,(t-a.aabb.min[1])/(a.aabb.max[1]-a.aabb.min[1])*64|0)+Math.min(63,s);if(!(a.heightmap[l]<0&&o.node.footprint)){if(o.hiddenByReplacement)return;return{height:a.heightmap[l],maxHeight:o.feature.properties.height,hidden:!1,verticalScale:o.evaluatedScale[2]}}if(o.node.footprint.grid.query(new g(e,t),new g(e,t),r),r.length>0)return{height:void 0,maxHeight:o.feature.properties.height,hidden:o.hiddenByReplacement,verticalScale:o.evaluatedScale[2]}}}},"Tiled3dModelBucket",{omit:["layers"]}),Fo(Tiled3dModelFeature,"Tiled3dModelFeature");class ReplacementSource{constructor(){this._updateTime=0,this._sourceIds=[],this._activeRegions=[],this._prevRegions=[]}clear(){this._activeRegions.length>0&&++this._updateTime,this._activeRegions=[],this._prevRegions=[]}get updateTime(){return this._updateTime}getReplacementRegionsForTile(e){const t=km(new g(0,0),new g(Ri,Ri),e),i=[];for(const r of this._activeRegions){if(r.hiddenByOverlap)continue;if(!Rm(t,r))continue;const n=Bm(r.min,r.max,e);i.push({min:n.min,max:n.max,sourceId:this._sourceIds[r.priority],footprint:r.footprint,footprintTileId:r.tileId})}return i}setSources(e){this._setSources(e.map((e=>({getSourceId:()=>e.cache.id,getFootprints:()=>{const t=[];for(const i of e.cache.getVisibleCoordinates()){const r=e.cache.getTile(i).buckets[e.layer];if(r)for(const e of r.getNodesInfo()){const r=e.node;r.footprint&&t.push({footprint:r.footprint,id:i.toUnwrapped()})}}return t}}))))}_addSource(e){const t=e.getFootprints();if(0!==t.length){for(const e of t){if(!e.footprint)continue;const t=km(e.footprint.min,e.footprint.max,e.id);this._activeRegions.push({min:t.min,max:t.max,hiddenByOverlap:!1,priority:this._sourceIds.length,tileId:e.id,footprint:e.footprint})}this._sourceIds.push(e.getSourceId())}}_computeReplacement(){this._activeRegions.sort(((e,t)=>e.priority-t.priority||Lm(e.min,t.min)||Lm(e.max,t.max)));let e=this._activeRegions.length!==this._prevRegions.length;if(!e){let t=0,i=0;for(;!e&&t!==this._activeRegions.length;){const r=this._activeRegions[t],n=this._prevRegions[i];e=r.priority!==n.priority||!zm(r,n),++t,++i}}if(e){++this._updateTime;const e=e=>{const t=this._activeRegions;if(e>=t.length)return e;const i=t[e].priority;for(;e<t.length&&t[e].priority===i;)++e;return e};if(this._sourceIds.length>1){let t=0,i=e(t);for(;t!==i;){let r=t;const n=t;for(;r!==i;){const e=this._activeRegions[r];e.hiddenByOverlap=!1;for(let t=0;t<n;t++){const i=this._activeRegions[t];if(!i.hiddenByOverlap&&Rm(e,i)&&(e.hiddenByOverlap=Fm(e.footprint,e.tileId,i.footprint,i.tileId),e.hiddenByOverlap))break}++r}t=i,i=e(t)}}}}_setSources(e){[this._prevRegions,this._activeRegions]=[this._activeRegions,[]],this._sourceIds=[];for(let t=e.length-1;t>=0;t--)this._addSource(e[t]);this._computeReplacement()}}function Lm(e,t){return e.x-t.x||e.y-t.y}function zm(e,t){return 0===Lm(e.min,t.min)&&0===Lm(e.max,t.max)}function Rm(e,t){return!(e.min.x>t.max.x||e.max.x<t.min.x||e.min.y>t.max.y||e.max.y<t.min.y)}function km(e,t,i){const r=1/Ri,n=1/(1<<i.canonical.z),o=(t.x*r+i.canonical.x)*n+i.wrap,a=(t.y*r+i.canonical.y)*n;return{min:new g((e.x*r+i.canonical.x)*n+i.wrap,(e.y*r+i.canonical.y)*n),max:new g(o,a)}}function Bm(e,t,i){const r=1<<i.canonical.z,n=((t.x-i.wrap)*r-i.canonical.x)*Ri,o=(t.y*r-i.canonical.y)*Ri;return{min:new g(((e.x-i.wrap)*r-i.canonical.x)*Ri,(e.y*r-i.canonical.y)*Ri),max:new g(n,o)}}function Om(e,t,i,r,n,o,a){const s=e.indices,l=e.vertices,c=[];for(let u=r;u<r+n;u+=3){const r=t[i[u+0]+o],n=t[i[u+1]+o],h=t[i[u+2]+o],d=Math.min(r.x,n.x,h.x),p=Math.max(r.x,n.x,h.x),f=Math.min(r.y,n.y,h.y),m=Math.max(r.y,n.y,h.y);c.length=0,e.grid.query(new g(d,f),new g(p,m),c);for(let e=0;e<c.length;e++){const t=c[e];if(Ku(l[s[3*t+0]],l[s[3*t+1]],l[s[3*t+2]],r,n,h,a))return!0}}return!1}function Fm(e,t,i,r){if(!e||!i)return!1;let n=e.vertices;if(!t.canonical.equals(r.canonical)||t.wrap!==r.wrap){if(i.vertices.length<e.vertices.length)return Fm(i,r,e,t);const o=t.canonical,a=r.canonical,s=Math.pow(2,a.z-o.z);n=e.vertices.map((e=>new g(e.x*o.x*Ri*s-a.x*Ri,e.y*o.y*Ri*s-a.y*Ri)))}return Om(i,n,e.indices,0,e.indices.length,0,0)}const Um=vd.types,Vm=["fill-extrusion-base","fill-extrusion-height","fill-extrusion-color","fill-extrusion-pattern","fill-extrusion-flood-light-wall-radius"],Nm=["fill-extrusion-flood-light-ground-radius"],jm=Math.pow(2,13),Gm=Math.pow(2,15)-1,qm=new g(0,1),Zm=2147483648;function $m(e,t,i,r,n,o,a,s){e.emplaceBack((t<<1)+a,(i<<1)+o,(Math.floor(r*jm)<<1)+n,Math.round(s))}function Hm(e,t,i,r,n,o){e.emplaceBack(t.x,t.y,(i.x<<1)+r,(i.y<<1)+n,o)}function Wm(e,t,i){const r=16384;e.emplaceBack(t.x,t.y,t.z,i[0]*r,i[1]*r,i[2]*r)}class FootprintSegment{constructor(){this.vertexOffset=0,this.vertexCount=0,this.indexOffset=0,this.indexCount=0}}class PartData{constructor(){this.centroidXY=new g(0,0),this.vertexArrayOffset=0,this.vertexCount=0,this.groundVertexArrayOffset=0,this.groundVertexCount=0,this.flags=0,this.footprintSegIdx=-1,this.footprintSegLen=0,this.min=new g(Number.MAX_VALUE,Number.MAX_VALUE),this.max=new g(-Number.MAX_VALUE,-Number.MAX_VALUE),this.height=0}span(){return new g(this.max.x-this.min.x,this.max.y-this.min.y)}}class BorderCentroidData{constructor(){this.acc=new g(0,0),this.accCount=0,this.centroidDataIndex=0}startRing(e,t){e.min.x===Number.MAX_VALUE&&(e.min.x=e.max.x=t.x,e.min.y=e.max.y=t.y)}appendEdge(e,t,i){this.accCount++,this.acc._add(t);let r=!!this.borders;t.x<e.min.x?(e.min.x=t.x,r=!0):t.x>e.max.x&&(e.max.x=t.x,r=!0),t.y<e.min.y?(e.min.y=t.y,r=!0):t.y>e.max.y&&(e.max.y=t.y,r=!0),((0===t.x||t.x===Ri)&&t.x===i.x)!=((0===t.y||t.y===Ri)&&t.y===i.y)&&this.processBorderOverlap(t,i),r&&this.checkBorderIntersection(t,i)}checkBorderIntersection(e,t){t.x<0!=e.x<0&&this.addBorderIntersection(0,yr(t.y,e.y,(0-t.x)/(e.x-t.x))),t.x>Ri!=e.x>Ri&&this.addBorderIntersection(1,yr(t.y,e.y,(Ri-t.x)/(e.x-t.x))),t.y<0!=e.y<0&&this.addBorderIntersection(2,yr(t.x,e.x,(0-t.y)/(e.y-t.y))),t.y>Ri!=e.y>Ri&&this.addBorderIntersection(3,yr(t.x,e.x,(Ri-t.y)/(e.y-t.y)))}addBorderIntersection(e,t){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const i=this.borders[e];t<i[0]&&(i[0]=t),t>i[1]&&(i[1]=t)}processBorderOverlap(e,t){if(e.x===t.x){if(e.y===t.y)return;const i=0===e.x?0:1;this.addBorderIntersection(i,t.y),this.addBorderIntersection(i,e.y)}else{const i=0===e.y?2:3;this.addBorderIntersection(i,t.x),this.addBorderIntersection(i,e.x)}}centroid(){return 0===this.accCount?new g(0,0):new g(Math.floor(Math.max(0,this.acc.x)/this.accCount),Math.floor(Math.max(0,this.acc.y)/this.accCount))}intersectsCount(){return this.borders?this.borders.reduce(((e,t)=>e+ +(t[0]!==Number.MAX_VALUE)),0):0}}function Xm(e,t){const i=e.add(t)._unit(),r=I(e.x*i.x+e.y*i.y,-1,1);var n,o,a;return n=Math.acos(r),Math.min(4,Math.max(-4,Math.tan(n)))/4*Gm*((o=e).x*(a=t).y-o.y*a.x<0?-1:1)}const Ym=[e=>e.x<0,e=>e.x>Ri,e=>e.y<0,e=>e.y>Ri];function Km(e,t,i,r){const n=[4];if(0===r)return n;i._mult(r);const o=e.sub(i),a=t.sub(i),s=[e,t,o,a];for(let e=0;e<4;e++)for(const t of s)if(Ym[e](t)){n.push(e);break}return n}class GroundEffect{constructor(e){this.vertexArray=new StructArrayLayout5i10,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom,(e=>Nm.includes(e))),this._segments=new SegmentVector,this.hiddenByLandmarkVertexArray=new StructArrayLayout1ub1,this._segmentToGroundQuads={},this._segmentToGroundQuads[0]=[],this._segmentToRegionTriCounts={},this._segmentToRegionTriCounts[0]=[0,0,0,0,0],this.regionSegments={},this.regionSegments[4]=new SegmentVector}getDefaultSegment(){return this.regionSegments[4]}hasData(){return 0!==this.vertexArray.length}addData(e,t,i,r=!1){const n=e.length;if(n>2){let o=Math.max(0,this._segments.get().length-1);const a=this._segments._prepareSegment(4*n,this.vertexArray.length,2*this._segmentToGroundQuads[o].length);let s;o!==this._segments.get().length-1&&(o++,this._segmentToGroundQuads[o]=[],this._segmentToRegionTriCounts[o]=[0,0,0,0,0]);{const t=e[0],i=e[1];s=Xm(t.sub(e[n-1])._perp()._unit(),i.sub(t)._perp()._unit())}for(let l=0;l<n;l++){const c=l===n-1?0:l+1,u=e[l],h=e[c],d=e[c===n-1?0:c+1],p=h.sub(u)._perp()._unit(),f=Xm(p,d.sub(h)._perp()._unit()),m=s,_=f;if(t_(u,h,t)||r&&i_(u,t)&&i_(h,t)){s=f;continue}const g=a.vertexLength;Hm(this.vertexArray,u,h,1,1,m),Hm(this.vertexArray,u,h,1,0,m),Hm(this.vertexArray,u,h,0,1,_),Hm(this.vertexArray,u,h,0,0,_),a.vertexLength+=4;const y=Km(u,h,p,i);for(const e of y)this._segmentToGroundQuads[o].push({id:g,region:e}),this._segmentToRegionTriCounts[o][e]+=2,a.primitiveLength+=2;s=f}}}prepareBorderSegments(){if(!this.hasData())return;const e=this._segments.get(),t=e.length;for(let e=0;e<t;e++)this._segmentToGroundQuads[e].sort(((e,t)=>e.region-t.region));for(let i=0;i<t;i++){const t=this._segmentToGroundQuads[i],r=e[i],n=this._segmentToRegionTriCounts[i];n.reduce(((e,t)=>e+t),0);let o=0;for(let e=0;e<=4;e++){const t=n[e];if(0!==t){let i=this.regionSegments[e];i||(i=this.regionSegments[e]=new SegmentVector);const n={vertexOffset:r.vertexOffset,primitiveOffset:r.primitiveOffset+o,vertexLength:r.vertexLength,primitiveLength:t};i.get().push(n)}o+=t}for(let e=0;e<t.length;e++){const i=t[e].id;this.indexArray.emplaceBack(i,i+1,i+3),this.indexArray.emplaceBack(i,i+3,i+2)}}this._segmentToGroundQuads=null,this._segmentToRegionTriCounts=null,this._segments.destroy(),this._segments=null}addPaintPropertiesData(e,t,i,r,n,o){this.hasData()&&this.programConfigurations.populatePaintArrays(this.vertexArray.length,e,t,i,r,n,o)}upload(e){this.hasData()&&(this.vertexBuffer=e.createVertexBuffer(this.vertexArray,rd.members),this.indexBuffer=e.createIndexBuffer(this.indexArray))}uploadPaintProperties(e){this.hasData()&&this.programConfigurations.upload(e)}update(e,t,i,r,n,o){this.hasData()&&this.programConfigurations.updatePaintArrays(e,t,i,r,n,o)}updateHiddenByLandmark(e){if(!this.hasData())return;const t=e.groundVertexCount+e.groundVertexArrayOffset;if(0===e.groundVertexCount)return;const i=e.flags&Zm?1:0;for(let r=e.groundVertexArrayOffset;r<t;++r)this.hiddenByLandmarkVertexArray.emplace(r,i);this._needsHiddenByLandmarkUpdate=!0}uploadHiddenByLandmark(e){this.hasData()&&this._needsHiddenByLandmarkUpdate&&(!this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexArray.length>0?this.hiddenByLandmarkVertexBuffer=e.createVertexBuffer(this.hiddenByLandmarkVertexArray,od.members,!0):this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.updateData(this.hiddenByLandmarkVertexArray),this._needsHiddenByLandmarkUpdate=!1)}destroy(){if(this.vertexBuffer){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.hiddenByLandmarkVertexBuffer&&this.hiddenByLandmarkVertexBuffer.destroy(),this._segments&&this._segments.destroy(),this.programConfigurations.destroy();for(let e=0;e<=4;e++){const t=this.regionSegments[e];t&&t.destroy()}}}}class FillExtrusionBucket{constructor(e){this.zoom=e.zoom,this.canonical=e.canonical,this.overscaling=e.overscaling,this.layers=e.layers,this.layerIds=this.layers.map((e=>e.fqid)),this.index=e.index,this.hasPattern=!1,this.edgeRadius=0,this.projection=e.projection,this.activeReplacements=[],this.replacementUpdateTime=0,this.centroidData=[],this.footprintIndices=new StructArrayLayout3ui6,this.footprintVertices=new StructArrayLayout2i4,this.footprintSegments=[],this.layoutVertexArray=new StructArrayLayout4i8,this.centroidVertexArray=new FillExtrusionCentroidArray,this.indexArray=new StructArrayLayout3ui6,this.programConfigurations=new ProgramConfigurationSet(e.layers,e.zoom,(e=>Vm.includes(e))),this.segments=new SegmentVector,this.stateDependentLayerIds=this.layers.filter((e=>e.isStateDependent())).map((e=>e.id)),this.groundEffect=new GroundEffect(e),this.maxHeight=0,this.partLookup={}}populate(e,t,i,r){this.features=[],this.hasPattern=Jh("fill-extrusion",this.layers,t),this.featuresOnBorder=[],this.borderFeatureIndices=[[],[],[],[]],this.borderDoneWithNeighborZ=[-1,-1,-1,-1],this.tileToMeter=Su(i),this.edgeRadius=this.layers[0].layout.get("fill-extrusion-edge-radius")/this.tileToMeter;for(const{feature:n,id:o,index:a,sourceLayerIndex:s}of e){const e=this.layers[0]._featureFilter.needGeometry,l=ku(n,e);if(!this.layers[0]._featureFilter.filter(new EvaluationParameters(this.zoom),l,i))continue;const c={id:o,sourceLayerIndex:s,index:a,geometry:e?l.geometry:Ru(n,i,r),properties:n.properties,type:n.type,patterns:{}},u=this.layoutVertexArray.length;this.hasPattern?this.features.push(Qh("fill-extrusion",this.layers,c,this.zoom,t)):this.addFeature(c,c.geometry,a,i,{},t.availableImages,r,t.brightness),t.featureIndex.insert(n,c.geometry,a,s,this.index,u)}this.sortBorders(),this.groundEffect.prepareBorderSegments()}addFeatures(e,t,i,r,n,o){for(const e of this.features){const{geometry:a}=e;this.addFeature(e,a,e.index,t,i,r,n,o)}this.sortBorders()}update(e,t,i,r,n){const o=0!==Object.keys(e).length;if(o&&!this.stateDependentLayers.length)return;const a=o?this.stateDependentLayers:this.layers;this.programConfigurations.updatePaintArrays(e,t,a,i,r,n),this.groundEffect.update(e,t,a,i,r,n)}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return!this.uploaded||this.programConfigurations.needsUpload||this.groundEffect.programConfigurations.needsUpload}upload(e){this.uploaded||(this.layoutVertexBuffer=e.createVertexBuffer(this.layoutVertexArray,sd),this.indexBuffer=e.createIndexBuffer(this.indexArray),this.layoutVertexExtArray&&(this.layoutVertexExtBuffer=e.createVertexBuffer(this.layoutVertexExtArray,ad.members,!0)),this.groundEffect.upload(e)),this.groundEffect.uploadPaintProperties(e),this.programConfigurations.upload(e),this.uploaded=!0}uploadCentroid(e){this.groundEffect.uploadHiddenByLandmark(e),this.needsCentroidUpdate&&(!this.centroidVertexBuffer&&this.centroidVertexArray.length>0?this.centroidVertexBuffer=e.createVertexBuffer(this.centroidVertexArray,nd.members,!0):this.centroidVertexBuffer&&this.centroidVertexBuffer.updateData(this.centroidVertexArray),this.needsCentroidUpdate=!1)}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.layoutVertexExtBuffer&&this.layoutVertexExtBuffer.destroy(),this.groundEffect.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy())}addFeature(e,t,i,r,n,o,a,s){const l=this.layers[0].paint.get("fill-extrusion-flood-light-ground-radius").evaluate(e,{})/this.tileToMeter,c=[new g(0,0),new g(Ri,Ri)],u=a.projection,h="globe"===u.name,d="Polygon"===Um[e.type],p=new BorderCentroidData;p.centroidDataIndex=this.centroidData.length;const f=new PartData,m=this.layers[0].paint.get("fill-extrusion-base").evaluate(e,{},r)<=0,_=this.layers[0].paint.get("fill-extrusion-height").evaluate(e,{},r);f.height=_,f.vertexArrayOffset=this.layoutVertexArray.length,f.groundVertexArrayOffset=this.groundEffect.vertexArray.length,h&&!this.layoutVertexExtArray&&(this.layoutVertexExtArray=new StructArrayLayout6i12);const y=Yh(t,500);for(let e=y.length-1;e>=0;e--){const t=y[e];(0===t.length||(x=t[0]).every((e=>e.x<=0))||x.every((e=>e.x>=Ri))||x.every((e=>e.y<=0))||x.every((e=>e.y>=Ri)))&&y.splice(e,1)}var x;let v;if(h)v=a_(y,c,r);else{v=[];for(const e of y)v.push({polygon:e,bounds:c})}const b=d?this.edgeRadius:0,w=b>0&&this.zoom<17,T=(e,t)=>{if(0===e.length)return!1;const i=e[e.length-1];return t.x===i.x&&t.y===i.y};for(const{polygon:e,bounds:t}of v){let i=0,n=0;for(const t of e)d&&!t[0].equals(t[t.length-1])&&t.push(t[0]),n+=d?t.length-1:t.length;const o=this.segments.prepareSegment((d?5:4)*n,this.layoutVertexArray,this.indexArray);f.footprintSegIdx<0&&(f.footprintSegIdx=this.footprintSegments.length);const a=new FootprintSegment;if(a.vertexOffset=this.footprintVertices.length,a.indexOffset=3*this.footprintIndices.length,a.ringIndices=[],d){const n=[],s=[];i=o.vertexLength;for(let i=0;i<e.length;i++){const c=e[i];c.length&&0!==i&&s.push(n.length/2);const d=[];let p,f;p=c[1].sub(c[0])._perp()._unit(),a.ringIndices.push(c.length-1);for(let e=1;e<c.length;e++){const t=c[e],i=c[e===c.length-1?1:e+1],a=t.clone();if(b){f=i.sub(t)._perp()._unit();const e=p.add(f)._unit(),r=b*Math.min(4,1/(p.x*e.x+p.y*e.y));a.x+=r*e.x,a.y+=r*e.y,a.x=Math.round(a.x),a.y=Math.round(a.y),p=f}!m||0!==b&&!w||T(d,a)||d.push(a),$m(this.layoutVertexArray,a.x,a.y,0,0,1,1,0),o.vertexLength++,this.footprintVertices.emplaceBack(t.x,t.y),n.push(t.x,t.y),h&&Wm(this.layoutVertexExtArray,u.projectTilePoint(a.x,a.y,r),u.upVector(r,a.x,a.y))}m&&(0===b||w)&&(0!==d.length&&T(d,d[0])&&d.pop(),this.groundEffect.addData(d,t,l))}const c=Xh(n,s);for(let e=0;e<c.length;e+=3)this.footprintIndices.emplaceBack(a.vertexOffset+c[e+0],a.vertexOffset+c[e+1],a.vertexOffset+c[e+2]),this.indexArray.emplaceBack(i+c[e],i+c[e+2],i+c[e+1]),o.primitiveLength++;a.indexCount+=c.length,a.vertexCount+=this.footprintVertices.length-a.vertexOffset}for(let n=0;n<e.length;n++){const a=e[n];p.startRing(f,a[0]);let s=a.length>4&&r_(a[a.length-2],a[0],a[1]),c=b?Qm(a[a.length-2],a[0],a[1],b):0;const _=[];let g,y,x;y=a[1].sub(a[0])._perp()._unit();let v=!0;for(let e=1,n=0;e<a.length;e++){let l=a[e-1],d=a[e];const w=a[e===a.length-1?1:e+1];if(p.appendEdge(f,d,l),t_(d,l,t)){b&&(y=w.sub(d)._perp()._unit(),v=!v);continue}const E=d.sub(l)._perp(),M=E.x/(Math.abs(E.x)+Math.abs(E.y)),S=E.y>0?1:0,A=l.dist(d);if(n+A>32768&&(n=0),b){x=w.sub(d)._perp()._unit();let e=e_(l,d,w,Jm(y,x),b);isNaN(e)&&(e=0);const t=d.sub(l)._unit();l=l.add(t.mult(c))._round(),d=d.add(t.mult(-e))._round(),c=e,y=x,m&&this.zoom>=17&&(T(_,l)||_.push(l),T(_,d)||_.push(d))}const C=o.vertexLength,I=a.length>4&&r_(l,d,w);let D=n_(n,s,v);if($m(this.layoutVertexArray,l.x,l.y,M,S,0,0,D),$m(this.layoutVertexArray,l.x,l.y,M,S,0,1,D),n+=A,D=n_(n,I,!v),s=I,$m(this.layoutVertexArray,d.x,d.y,M,S,0,0,D),$m(this.layoutVertexArray,d.x,d.y,M,S,0,1,D),o.vertexLength+=4,this.indexArray.emplaceBack(C+0,C+1,C+2),this.indexArray.emplaceBack(C+1,C+3,C+2),o.primitiveLength+=2,b){const r=i+(1===e?a.length-2:e-2),n=1===e?i:r+1;if(this.indexArray.emplaceBack(C+1,r,C+3),this.indexArray.emplaceBack(r,n,C+3),o.primitiveLength+=2,void 0===g&&(g=C),!t_(w,a[e],t)){const t=e===a.length-1?g:o.vertexLength;this.indexArray.emplaceBack(C+2,C+3,t),this.indexArray.emplaceBack(C+3,t+1,t),this.indexArray.emplaceBack(C+3,n,t+1),o.primitiveLength+=3}v=!v}if(h){const e=this.layoutVertexExtArray,t=u.projectTilePoint(l.x,l.y,r),i=u.projectTilePoint(d.x,d.y,r),n=u.upVector(r,l.x,l.y),o=u.upVector(r,d.x,d.y);Wm(e,t,n),Wm(e,t,n),Wm(e,i,o),Wm(e,i,o)}}d&&(i+=a.length-1),m&&b&&this.zoom>=17&&(0!==_.length&&T(_,_[0])&&_.pop(),this.groundEffect.addData(_,t,l,b>0))}this.footprintSegments.push(a),++f.footprintSegLen}if(f.vertexCount=this.layoutVertexArray.length-f.vertexArrayOffset,f.groundVertexCount=this.groundEffect.vertexArray.length-f.groundVertexArrayOffset,0!==f.vertexCount){if(f.centroidXY=p.borders?qm:this.encodeCentroid(p,f),this.centroidData.push(f),p.borders){this.featuresOnBorder.push(p);const e=this.featuresOnBorder.length-1;for(let t=0;t<p.borders.length;t++)p.borders[t][0]!==Number.MAX_VALUE&&this.borderFeatureIndices[t].push(e)}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,e,i,n,o,r,s),this.groundEffect.addPaintPropertiesData(e,i,n,o,r,s),this.maxHeight=Math.max(this.maxHeight,_)}}sortBorders(){for(let e=0;e<this.borderFeatureIndices.length;e++)this.borderFeatureIndices[e].sort(((t,i)=>this.featuresOnBorder[t].borders[e][0]-this.featuresOnBorder[i].borders[e][0]))}encodeCentroid(e,t){const i=e.centroid(),r=t.span(),n=Math.min(7,Math.round(r.x*this.tileToMeter/10)),o=Math.min(7,Math.round(r.y*this.tileToMeter/10));return new g(I(i.x,1,Ri-1)<<3|n,I(i.y,1,Ri-1)<<3|o)}showCentroid(e){const t=this.centroidData[e.centroidDataIndex];t.flags&=Zm,t.centroidXY.x=0,t.centroidXY.y=0,this.writeCentroidToBuffer(t)}writeCentroidToBuffer(e){this.groundEffect.updateHiddenByLandmark(e);const t=e.vertexArrayOffset,i=e.vertexCount+e.vertexArrayOffset,r=e.flags&Zm?qm:e.centroidXY,n=this.centroidVertexArray.geta_centroid_pos0(t);if(this.centroidVertexArray.geta_centroid_pos1(t)!==r.y||n!==r.x){for(let e=t;e<i;++e)this.centroidVertexArray.emplace(e,r.x,r.y);this.needsCentroidUpdate=!0}}createCentroidsBuffer(){this.centroidVertexArray.resize(this.layoutVertexArray.length),this.groundEffect.hiddenByLandmarkVertexArray.resize(this.groundEffect.vertexArray.length);for(const e of this.centroidData)this.writeCentroidToBuffer(e)}updateReplacement(e,t){if(t.updateTime===this.replacementUpdateTime)return;this.replacementUpdateTime=t.updateTime;const i=t.getReplacementRegionsForTile(e.toUnwrapped());if(function(e,t){if(e.length!==t.length)return!1;for(let i=0;i<e.length;i++)if(e[i].sourceId!==t[i].sourceId||!zm(e[i],t[i]))return!1;return!0}(this.activeReplacements,i))return;if(this.activeReplacements=i,0===this.centroidVertexArray.length)this.createCentroidsBuffer();else for(const e of this.centroidData)e.flags&=2147483647;const r=[];for(const t of this.activeReplacements){const i=Math.pow(2,t.footprintTileId.canonical.z-e.canonical.z);for(const n of this.centroidData)if(!(n.flags&Zm||t.min.x>n.max.x||n.min.x>t.max.x||t.min.y>n.max.y||n.min.y>t.max.y))for(let o=0;o<n.footprintSegLen;o++){const a=this.footprintSegments[n.footprintSegIdx+o];if(r.length=0,s_(this.footprintVertices,a.vertexOffset,a.vertexCount,t.footprintTileId.canonical,e.canonical,r),Om(t.footprint,r,this.footprintIndices.uint16,a.indexOffset,a.indexCount,-a.vertexOffset,-i)){n.flags|=Zm;break}}}for(const e of this.centroidData)this.writeCentroidToBuffer(e);this.borderDoneWithNeighborZ=[-1,-1,-1,-1]}footprintContainsPoint(e,t,i){let r=!1;for(let n=0;n<i.footprintSegLen;n++){const o=this.footprintSegments[i.footprintSegIdx+n];let a=0;for(const i of o.ringIndices){for(let n=a,s=i+a-1;n<i+a;s=n++){const i=this.footprintVertices.int16[2*(n+o.vertexOffset)+0],a=this.footprintVertices.int16[2*(n+o.vertexOffset)+1],l=this.footprintVertices.int16[2*(s+o.vertexOffset)+1];a>t!=l>t&&e<(this.footprintVertices.int16[2*(s+o.vertexOffset)+0]-i)*(t-a)/(l-a)+i&&(r=!r)}a=i}}return r}getHeightAtTileCoord(e,t){let i=Number.NEGATIVE_INFINITY,r=!0;const n=4*(e+Ri)*Ri+(t+Ri);if(this.partLookup.hasOwnProperty(n)){const e=this.partLookup[n];return e?{height:e.height,hidden:!!(e.flags&Zm)}:void 0}for(const o of this.centroidData)e>o.max.x||o.min.x>e||t>o.max.y||o.min.y>t||this.footprintContainsPoint(e,t,o)&&o&&o.height>i&&(i=o.height,this.partLookup[n]=o,r=!!(o.flags&Zm));if(i!==Number.NEGATIVE_INFINITY)return{height:i,hidden:r};this.partLookup[n]=void 0}}function Jm(e,t){const i=e.add(t)._unit();return e.x*i.x+e.y*i.y}function Qm(e,t,i,r){const n=t.sub(e)._perp()._unit(),o=i.sub(t)._perp()._unit();return e_(e,t,i,Jm(n,o),r)}function e_(e,t,i,r,n){const o=Math.sqrt(1-r*r);return Math.min(e.dist(t)/3,t.dist(i)/3,n*o/r)}function t_(e,t,i){return e.x<i[0].x&&t.x<i[0].x||e.x>i[1].x&&t.x>i[1].x||e.y<i[0].y&&t.y<i[0].y||e.y>i[1].y&&t.y>i[1].y}function i_(e,t){return e.x<t[0].x||e.x>t[1].x||e.y<t[0].y||e.y>t[1].y}function r_(e,t,i){if(e.x<0||e.x>=Ri||t.x<0||t.x>=Ri||i.x<0||i.x>=Ri)return!1;const r=i.sub(t),n=r.perp(),o=e.sub(t);return(r.x*o.x+r.y*o.y)/Math.sqrt((r.x*r.x+r.y*r.y)*(o.x*o.x+o.y*o.y))>-.866&&n.x*o.x+n.y*o.y<0}function n_(e,t,i){const r=t?2|e:-3&e;return i?1|r:-2&r}function o_(){const e=Math.PI/32,t=Math.tan(e),i=uu;return i*Math.sqrt(1+2*t*t)-i}function a_(e,t,i){const r=1<<i.z,n=xu(i.x/r),o=xu((i.x+1)/r),a=vu(i.y/r),s=vu((i.y+1)/r);return function(e,t,i,r,n=0,o){const a=[];if(!e.length||!i||!r)return a;const s=(e,t)=>{for(const i of e)a.push({polygon:i,bounds:t})},l=Math.ceil(Math.log2(i)),c=Math.ceil(Math.log2(r)),u=l-c,h=[];for(let e=0;e<Math.abs(u);e++)h.push(u>0?0:1);for(let e=0;e<Math.min(l,c);e++)h.push(0),h.push(1);let d=e;if(d=bd(d,t[0].y-n,t[1].y+n,1),d=bd(d,t[0].x-n,t[1].x+n,0),!d.length)return a;const p=[];for(h.length?p.push({polygons:d,bounds:t,depth:0}):s(d,t);p.length;){const e=p.pop(),t=e.depth,i=h[t],r=e.bounds[0],a=e.bounds[1],l=0===i?r.x:r.y,c=0===i?a.x:a.y,u=o?o(i,l,c):.5*(l+c),d=bd(e.polygons,l-n,u+n,i),f=bd(e.polygons,u-n,c+n,i);if(d.length){const e=[r,new g(0===i?u:a.x,1===i?u:a.y)];h.length>t+1?p.push({polygons:d,bounds:e,depth:t+1}):s(d,e)}if(f.length){const e=[new g(0===i?u:r.x,1===i?u:r.y),a];h.length>t+1?p.push({polygons:f,bounds:e,depth:t+1}):s(f,e)}}return a}(e,t,Math.ceil((o-n)/11.25),Math.ceil((a-s)/11.25),1,((e,t,n)=>{if(0===e)return.5*(t+n);{const e=vu((i.y+t/Ri)/r);return(gu(.5*(vu((i.y+n/Ri)/r)+e))*r-i.y)*Ri}}))}function s_(e,t,i,r,n,o){const a=Math.pow(2,r.z-n.z);for(let s=0;s<i;s++){let i=e.int16[2*(s+t)+0],l=e.int16[2*(s+t)+1];i=(i+n.x*Ri)*a-r.x*Ri,l=(l+n.y*Ri)*a-r.y*Ri,o.push(new g(i,l))}}Fo(FillExtrusionBucket,"FillExtrusionBucket",{omit:["layers","features"]}),Fo(PartData,"PartData"),Fo(FootprintSegment,"FootprintSegment"),Fo(BorderCentroidData,"BorderCentroidData"),Fo(GroundEffect,"GroundEffect");const l_=new Properties({visibility:new DataConstantProperty(xt["layout_fill-extrusion"].visibility),"fill-extrusion-edge-radius":new DataConstantProperty(xt["layout_fill-extrusion"]["fill-extrusion-edge-radius"])});var c_={paint:new Properties({"fill-extrusion-opacity":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new DataDrivenProperty(xt["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new DataDrivenProperty(xt["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new DataDrivenProperty(xt["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new DataDrivenProperty(xt["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"]),"fill-extrusion-ambient-occlusion-intensity":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-intensity"]),"fill-extrusion-ambient-occlusion-radius":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-radius"]),"fill-extrusion-ambient-occlusion-wall-radius":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-wall-radius"]),"fill-extrusion-ambient-occlusion-ground-radius":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-radius"]),"fill-extrusion-ambient-occlusion-ground-attenuation":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-ambient-occlusion-ground-attenuation"]),"fill-extrusion-flood-light-color":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-flood-light-color"]),"fill-extrusion-flood-light-intensity":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-flood-light-intensity"]),"fill-extrusion-flood-light-wall-radius":new DataDrivenProperty(xt["paint_fill-extrusion"]["fill-extrusion-flood-light-wall-radius"]),"fill-extrusion-flood-light-ground-radius":new DataDrivenProperty(xt["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-radius"]),"fill-extrusion-flood-light-ground-attenuation":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-flood-light-ground-attenuation"]),"fill-extrusion-vertical-scale":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-vertical-scale"]),"fill-extrusion-rounded-roof":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-rounded-roof"]),"fill-extrusion-cutoff-fade-range":new DataConstantProperty(xt["paint_fill-extrusion"]["fill-extrusion-cutoff-fade-range"])}),layout:l_};class Point3D extends g{constructor(e,t,i){super(e,t),this.z=i}}function u_(e,t){return e.x*t.x+e.y*t.y}function h_(e,t){if(1===e.length){let i=0;const r=t[i++];let n;for(;!n||r.equals(n);)if(n=t[i++],!n)return 1/0;for(;i<t.length;i++){const o=t[i],a=e[0],s=n.sub(r),l=o.sub(r),c=a.sub(r),u=u_(s,s),h=u_(s,l),d=u_(l,l),p=u_(c,s),f=u_(c,l),m=u*d-h*h,_=(d*p-h*f)/m,g=(u*f-h*p)/m,y=r.z*(1-_-g)+n.z*_+o.z*g;if(isFinite(y))return y}return 1/0}{let e=1/0;for(const i of t)e=Math.min(e,i.z);return e}}function d_(e,t,i,r,n,o,a,s){const l=a*n.getElevationAt(e,t,!0,!0),c=0!==o[0],u=c?0===o[1]?a*(o[0]/7-450):a*function(e,t,i){const r=Math.floor(t[0]/8),n=Math.floor(t[1]/8),o=10*(t[0]-8*r),a=10*(t[1]-8*n),s=e.getElevationAt(r,n,!0,!0),l=e.getMeterToDEM(i),c=Math.floor(.5*(o*l-1)),u=Math.floor(.5*(a*l-1)),h=e.tileCoordToPixel(r,n),d=2*c+1,p=2*u+1,f=function(e,t,i,r,n){return[e.getElevationAtPixel(t,i,!0),e.getElevationAtPixel(t+n,i,!0),e.getElevationAtPixel(t,i+n,!0),e.getElevationAtPixel(t+r,i+n,!0)]}(e,h.x-c,h.y-u,d,p),m=Math.abs(f[0]-f[1]),_=Math.abs(f[2]-f[3]),g=Math.abs(f[0]-f[2])+Math.abs(f[1]-f[3]),y=Math.min(.25,.5*l*(m+_)/d),x=Math.min(.25,.5*l*g/p);return s+Math.max(y*o,x*a)}(n,o,s):l;return{base:l+(0===i)?-1:i,top:c?Math.max(u+r,l+i+2):l+r}}const p_=new Properties({"line-cap":new DataDrivenProperty(xt.layout_line["line-cap"]),"line-join":new DataDrivenProperty(xt.layout_line["line-join"]),"line-miter-limit":new DataConstantProperty(xt.layout_line["line-miter-limit"]),"line-round-limit":new DataConstantProperty(xt.layout_line["line-round-limit"]),"line-sort-key":new DataDrivenProperty(xt.layout_line["line-sort-key"]),visibility:new DataConstantProperty(xt.layout_line.visibility)});var f_={paint:new Properties({"line-opacity":new DataDrivenProperty(xt.paint_line["line-opacity"]),"line-color":new DataDrivenProperty(xt.paint_line["line-color"]),"line-translate":new DataConstantProperty(xt.paint_line["line-translate"]),"line-translate-anchor":new DataConstantProperty(xt.paint_line["line-translate-anchor"]),"line-width":new DataDrivenProperty(xt.paint_line["line-width"]),"line-gap-width":new DataDrivenProperty(xt.paint_line["line-gap-width"]),"line-offset":new DataDrivenProperty(xt.paint_line["line-offset"]),"line-blur":new DataDrivenProperty(xt.paint_line["line-blur"]),"line-dasharray":new DataDrivenProperty(xt.paint_line["line-dasharray"]),"line-pattern":new DataDrivenProperty(xt.paint_line["line-pattern"]),"line-gradient":new ColorRampProperty(xt.paint_line["line-gradient"]),"line-trim-offset":new DataConstantProperty(xt.paint_line["line-trim-offset"]),"line-emissive-strength":new DataConstantProperty(xt.paint_line["line-emissive-strength"]),"line-border-width":new DataDrivenProperty(xt.paint_line["line-border-width"]),"line-border-color":new DataDrivenProperty(xt.paint_line["line-border-color"])}),layout:p_};const m_=(e,t,i,r,n,o,a)=>{const s=e.transform,l=s.calculatePixelsToTileUnitsMatrix(t);return{u_matrix:y_(e,t,i,r),u_pixels_to_tile_units:l,u_device_pixel_ratio:o,u_units_to_pixels:[1/s.pixelsToGLUnits[0],1/s.pixelsToGLUnits[1]],u_dash_image:0,u_gradient_image:1,u_image_height:n,u_texsize:v_(i)?t.lineAtlasTexture.size:[0,0],u_tile_units_to_pixels:g_(t,e.transform),u_alpha_discard_threshold:0,u_trim_offset:a,u_emissive_strength:i.paint.get("line-emissive-strength")}},__=(e,t,i,r,n)=>{const o=e.transform;return{u_matrix:y_(e,t,i,r),u_texsize:t.imageAtlasTexture.size,u_pixels_to_tile_units:o.calculatePixelsToTileUnitsMatrix(t),u_device_pixel_ratio:n,u_image:0,u_tile_units_to_pixels:g_(t,o),u_units_to_pixels:[1/o.pixelsToGLUnits[0],1/o.pixelsToGLUnits[1]],u_alpha_discard_threshold:0}};function g_(e,t){return 1/Wf(e,1,t.tileZoom)}function y_(e,t,i,r){return e.translatePosMatrix(r||t.tileID.projMatrix,t,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const x_=e=>{const t=[];v_(e)&&t.push("RENDER_LINE_DASH"),e.paint.get("line-gradient")&&t.push("RENDER_LINE_GRADIENT");const i=e.paint.get("line-trim-offset");return 0===i[0]&&0===i[1]||t.push("RENDER_LINE_TRIM_OFFSET"),0!==e.paint.get("line-border-width").constantOr(1)&&t.push("RENDER_LINE_BORDER"),t};function v_(e){const t=e.paint.get("line-dasharray").value;return t.value||"constant"!==t.kind}const b_=new class LineFloorwidthProperty extends DataDrivenProperty{possiblyEvaluate(e,t){return t=new EvaluationParameters(Math.floor(t.zoom),{now:t.now,fadeDuration:t.fadeDuration,transition:t.transition}),super.possiblyEvaluate(e,t)}evaluate(e,t,i,r){return t=z({},t,{zoom:Math.floor(t.zoom)}),super.evaluate(e,t,i,r)}}(f_.paint.properties["line-width"].specification);function w_(e,t){return t>0?t+2*e:e}b_.useIntegerZoom=!0;const T_=new Properties({visibility:new DataConstantProperty(xt.layout_background.visibility)});var E_={paint:new Properties({"background-color":new DataConstantProperty(xt.paint_background["background-color"]),"background-pattern":new DataConstantProperty(xt.paint_background["background-pattern"]),"background-opacity":new DataConstantProperty(xt.paint_background["background-opacity"]),"background-emissive-strength":new DataConstantProperty(xt.paint_background["background-emissive-strength"])}),layout:T_};const M_=new Properties({visibility:new DataConstantProperty(xt.layout_raster.visibility)});var S_={paint:new Properties({"raster-opacity":new DataConstantProperty(xt.paint_raster["raster-opacity"]),"raster-color":new ColorRampProperty(xt.paint_raster["raster-color"]),"raster-color-mix":new DataConstantProperty(xt.paint_raster["raster-color-mix"]),"raster-color-range":new DataConstantProperty(xt.paint_raster["raster-color-range"]),"raster-hue-rotate":new DataConstantProperty(xt.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new DataConstantProperty(xt.paint_raster["raster-brightness-min"]),"raster-brightness-max":new DataConstantProperty(xt.paint_raster["raster-brightness-max"]),"raster-saturation":new DataConstantProperty(xt.paint_raster["raster-saturation"]),"raster-contrast":new DataConstantProperty(xt.paint_raster["raster-contrast"]),"raster-resampling":new DataConstantProperty(xt.paint_raster["raster-resampling"]),"raster-fade-duration":new DataConstantProperty(xt.paint_raster["raster-fade-duration"])}),layout:M_};function A_(e,t,i,r,n,o,a,s){const l=[e,i,n,t,r,o,1,1,1],c=[a,s,1],u=ec.adjoint([],l),[h,d,p]=lc.transformMat3(c,c,ec.transpose(u,u));return ec.multiply(l,[h,0,0,0,d,0,0,0,p],l)}class ImageSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.onNorthPole=!1,this.onSouthPole=!1,this.setEventedParent(r),this.options=t,this._dirty=!1}load(t,i){if(this._loaded=i||!1,this.fire(new Event("dataloading",{dataType:"source"})),this.url=this.options.url,!this.url)return t&&(this.coordinates=t),this._loaded=!0,void this._finishLoading();this._imageRequest=Me(this.map._requestManager.transformRequest(this.url,_e.Image),((i,r)=>{if(this._imageRequest=null,this._loaded=!0,i)this.fire(new ErrorEvent(i));else if(r){const{HTMLImageElement:i}=e;this.image=r instanceof i?rt.getImageData(r):r,this._dirty=!0,this.width=this.image.width,this.height=this.image.height,t&&(this.coordinates=t),this._finishLoading()}}))}loaded(){return this._loaded}updateImage(e){return this.image&&e.url?(this._imageRequest&&e.url!==this.options.url&&(this._imageRequest.cancel(),this._imageRequest=null),this.options.url=e.url,this.load(e.coordinates,this._loaded),this):this}setTexture(e){if(!(e.handle instanceof WebGLTexture))throw new Error("The provided handle is not a WebGLTexture instance");return this.texture=new UserManagedTexture(this.map.painter.context,e.handle),this.width=e.dimensions[0],this.height=e.dimensions[1],this._dirty=!1,this._loaded=!0,this._finishLoading(),this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})))}onAdd(e){this.map=e,this.load()}onRemove(){this._imageRequest&&(this._imageRequest.cancel(),this._imageRequest=null),!this.texture||this.texture instanceof UserManagedTexture||this.texture.destroy()}setCoordinates(e){if(this.coordinates=e,this._boundsArray=void 0,!e.length)return this;this.onNorthPole=!1,this.onSouthPole=!1;let t=e[0][1],i=e[0][1];for(const r of e)r[1]>i&&(i=r[1]),r[1]<t&&(t=r[1]);const r=(i+t)/2;if(r>wu?this.onNorthPole=!0:r<-wu&&(this.onSouthPole=!0),!this.onNorthPole&&!this.onSouthPole){const t=e.map(MercatorCoordinate.fromLngLat);this.tileID=function(e){let t=1/0,i=1/0,r=-1/0,n=-1/0;for(const o of e)t=Math.min(t,o.x),i=Math.min(i,o.y),r=Math.max(r,o.x),n=Math.max(n,o.y);const o=Math.max(r-t,n-i),a=Math.max(0,Math.floor(-Math.log(o)/Math.LN2)),s=Math.pow(2,a);return new CanonicalTileID(a,Math.floor((t+r)/2*s),Math.floor((i+n)/2*s))}(t),this.minzoom=this.maxzoom=this.tileID.z}return this.fire(new Event("data",{dataType:"source",sourceDataType:"content"})),this}_clear(){this._boundsArray=void 0}_prepareData(e){for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture)}if(this._boundsArray)return;const t=kp(this.tileID,this.map.transform.projection),[i,r,n,o]=this.coordinates.map((e=>{const i=t.projection.project(e[0],e[1]);return Op(t,i)._round()}));this.perspectiveTransform=function(e,t,i,r,n,o,a,s,l,c){const u=A_(0,0,e,0,0,t,e,t),h=A_(i,r,n,o,a,s,l,c);return ec.multiply(h,ec.adjoint(u,u),h),[h[6]/h[8]*e/Ri,h[7]/h[8]*t/Ri]}(this.width,this.height,i.x,i.y,r.x,r.y,o.x,o.y,n.x,n.y);const a=this._boundsArray=new StructArrayLayout4i8;a.emplaceBack(i.x,i.y,0,0),a.emplaceBack(r.x,r.y,Ri,0),a.emplaceBack(o.x,o.y,0,Ri),a.emplaceBack(n.x,n.y,Ri,Ri),this.boundsBuffer&&this.boundsBuffer.destroy(),this.boundsBuffer=e.createVertexBuffer(a,bf.members),this.boundsSegments=SegmentVector.simpleSegment(0,0,4,2)}prepare(){const e=0!==Object.keys(this.tiles).length;if(this.tileID&&!e)return;const t=this.map.painter.context,i=t.gl;!this._dirty||this.texture instanceof UserManagedTexture||(this.texture?this.texture.update(this.image):(this.texture=new Texture(t,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE)),this._dirty=!1),e&&this._prepareData(t)}loadTile(e,t){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={},t(null)):(e.state="errored",t(null))}serialize(){return{type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return!1}}class CustomStyleLayer extends StyleLayer{constructor(e){super(e,{}),this.implementation=e,e.slot&&(this.slot=e.slot)}is3D(){return"3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}isLayerDraped(e){return void 0!==this.implementation.renderToTile}shouldRedrape(){return!!this.implementation.shouldRerenderTiles&&this.implementation.shouldRerenderTiles()}recalculate(){}updateTransitions(){}hasTransition(){return!1}serialize(){}onAdd(e){this.implementation.onAdd&&this.implementation.onAdd(e,e.painter.context.gl)}onRemove(e){this.implementation.onRemove&&this.implementation.onRemove(e,e.painter.context.gl)}}const C_=new Properties({visibility:new DataConstantProperty(xt.layout_sky.visibility)});var I_={paint:new Properties({"sky-type":new DataConstantProperty(xt.paint_sky["sky-type"]),"sky-atmosphere-sun":new DataConstantProperty(xt.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new DataConstantProperty(xt.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new DataConstantProperty(xt.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new DataConstantProperty(xt.paint_sky["sky-gradient-radius"]),"sky-gradient":new ColorRampProperty(xt.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new DataConstantProperty(xt.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new DataConstantProperty(xt.paint_sky["sky-atmosphere-color"]),"sky-opacity":new DataConstantProperty(xt.paint_sky["sky-opacity"])}),layout:C_};function D_(e,t,i){const r=[0,0,1],n=nc.identity([]);return nc.rotateY(n,n,i?-b(e)+Math.PI:b(e)),nc.rotateX(n,n,-b(t)),lc.transformQuat(r,r,n),lc.normalize(r,r)}var P_={paint:new Properties({})};const L_={circle:class CircleStyleLayer extends StyleLayer{constructor(e,t){super(e,rh,t)}createBucket(e){return new CircleBucket(e)}queryRadius(e){const t=e;return Ju("circle-radius",this,t)+Ju("circle-stroke-width",this,t)+Qu(this.paint.get("circle-translate"))}queryIntersectsFeature(e,t,i,r,n,o,a,s){const l=th(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),c=this.paint.get("circle-radius").evaluate(t,i)+this.paint.get("circle-stroke-width").evaluate(t,i);return sh(e,r,o,a,s,"map"===this.paint.get("circle-pitch-alignment"),"map"===this.paint.get("circle-pitch-scale"),l,c)}getProgramIds(){return["circle"]}getDefaultProgramParams(e,t){const i=ah(this);return{config:new ProgramConfiguration(this,t),defines:i,overrideFog:!1}}},heatmap:class HeatmapStyleLayer extends StyleLayer{createBucket(e){return new HeatmapBucket(e)}constructor(e,t){super(e,_h,t),this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(e){"heatmap-color"===e&&this._updateColorRamp()}_updateColorRamp(){this.colorRamp=gh({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null)}queryRadius(e){return Ju("heatmap-radius",this,e)}queryIntersectsFeature(e,t,i,r,n,o,a,s){const l=this.paint.get("heatmap-radius").evaluate(t,i);return sh(e,r,o,a,s,!0,!0,new g(0,0),l)}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return["heatmap","heatmapTexture"]}getDefaultProgramParams(e,t){return"heatmap"===e?{config:new ProgramConfiguration(this,t),overrideFog:!1}:{}}},hillshade:class HillshadeStyleLayer extends StyleLayer{constructor(e,t){super(e,xh,t)}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return["hillshade","hillshadePrepare"]}getDefaultProgramParams(e,t){return{overrideFog:!1}}},fill:class FillStyleLayer extends StyleLayer{constructor(e,t){super(e,td,t)}getProgramIds(){const e=this.paint.get("fill-pattern"),t=e&&e.constantOr(1),i=[t?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&i.push(t&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),i}getDefaultProgramParams(e,t){return{config:new ProgramConfiguration(this,t),overrideFog:!1}}recalculate(e,t){super.recalculate(e,t);const i=this.paint._values["fill-outline-color"];"constant"===i.value.kind&&void 0===i.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"])}createBucket(e){return new FillBucket(e)}queryRadius(){return Qu(this.paint.get("fill-translate"))}queryIntersectsFeature(e,t,i,r,n,o){return!e.queryGeometry.isAboveHorizon&&Vu(eh(e.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),r)}isTileClipped(){return!0}},"fill-extrusion":class FillExtrusionStyleLayer extends StyleLayer{constructor(e,t){super(e,c_,t)}createBucket(e){return new FillExtrusionBucket(e)}queryRadius(){return Qu(this.paint.get("fill-extrusion-translate"))}is3D(){return!0}hasShadowPass(){return!0}cutoffRange(){return this.paint.get("fill-extrusion-cutoff-fade-range")}canCastShadows(){return!0}getProgramIds(){return[this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}queryIntersectsFeature(e,t,i,r,n,o,a,s,l){const c=th(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),u=this.paint.get("fill-extrusion-height").evaluate(t,i),h=this.paint.get("fill-extrusion-base").evaluate(t,i),d=[0,0],p=s&&o.elevation,f=o.elevation?o.elevation.exaggeration():1,m=e.tile.getBucket(this);if(p&&m instanceof FillExtrusionBucket){const e=m.centroidVertexArray,t=l+1;t<e.length&&(d[0]=e.geta_centroid_pos0(t),d[1]=e.geta_centroid_pos1(t))}if(0===d[0]&&1===d[1])return!1;"globe"===o.projection.name&&(r=a_([r],[new g(0,0),new g(Ri,Ri)],e.tileID.canonical).map((e=>e.polygon)).flat());const _=p?s:null,[y,x]=function(e,t,i,r,n,o,a,s,l,c,u){return"globe"===e.projection.name?function(e,t,i,r,n,o,a,s,l,c,u){const h=[],d=[],p=e.projection.upVectorScale(u,e.center.lat,e.worldSize).metersToTile,f=[0,0,0,1],m=[0,0,0,1],_=(e,t,i,r)=>{e[0]=t,e[1]=i,e[2]=r,e[3]=1},g=o_();i>0&&(i+=g),r+=g;for(const g of t){const t=[],y=[];for(const h of g){const d=h.x+n.x,g=h.y+n.y,x=e.projection.projectTilePoint(d,g,u),v=e.projection.upVector(u,h.x,h.y);let b=i,w=r;if(a){const e=d_(d,g,i,r,a,s,l,c);b+=e.base,w+=e.top}0!==i?_(f,x.x+v[0]*p*b,x.y+v[1]*p*b,x.z+v[2]*p*b):_(f,x.x,x.y,x.z),_(m,x.x+v[0]*p*w,x.y+v[1]*p*w,x.z+v[2]*p*w),lc.transformMat4(f,f,o),lc.transformMat4(m,m,o),t.push(new Point3D(f[0],f[1],f[2])),y.push(new Point3D(m[0],m[1],m[2]))}h.push(t),d.push(y)}return[h,d]}(e,t,i,r,n,o,a,s,l,c,u):a?function(e,t,i,r,n,o,a,s,l){const c=[],u=[],h=[0,0,0,1];for(const d of e){const e=[],p=[];for(const c of d){const u=c.x+r.x,d=c.y+r.y,f=d_(u,d,t,i,o,a,s,l);h[0]=u,h[1]=d,h[2]=f.base,h[3]=1,Wl.transformMat4(h,h,n),h[3]=Math.max(h[3],1e-5);const m=new Point3D(h[0]/h[3],h[1]/h[3],h[2]/h[3]);h[0]=u,h[1]=d,h[2]=f.top,h[3]=1,Wl.transformMat4(h,h,n),h[3]=Math.max(h[3],1e-5);const _=new Point3D(h[0]/h[3],h[1]/h[3],h[2]/h[3]);e.push(m),p.push(_)}c.push(e),u.push(p)}return[c,u]}(t,i,r,n,o,a,s,l,c):function(e,t,i,r,n){const o=[],a=[],s=n[8]*t,l=n[9]*t,c=n[10]*t,u=n[11]*t,h=n[8]*i,d=n[9]*i,p=n[10]*i,f=n[11]*i;for(const t of e){const e=[],i=[];for(const o of t){const t=o.x+r.x,a=o.y+r.y,m=n[0]*t+n[4]*a+n[12],_=n[1]*t+n[5]*a+n[13],g=n[2]*t+n[6]*a+n[14],y=n[3]*t+n[7]*a+n[15],x=m+s,v=_+l,b=g+c,w=Math.max(y+u,1e-5),T=m+h,E=_+d,M=g+p,S=Math.max(y+f,1e-5);e.push(new Point3D(x/w,v/w,b/w)),i.push(new Point3D(T/S,E/S,M/S))}o.push(e),a.push(i)}return[o,a]}(t,i,r,n,o)}(o,r,h,u,c,a,_,d,f,o.center.lat,e.tileID.canonical),v=e.queryGeometry;return function(e,t,i){let r=1/0;Vu(i,t)&&(r=h_(i,t[0]));for(let n=0;n<t.length;n++){const o=t[n],a=e[n];for(let e=0;e<o.length-1;e++){const t=o[e],n=[t,o[e+1],a[e+1],a[e],t];Fu(i,n)&&(r=Math.min(r,h_(i,n)))}}return r!==1/0&&r}(y,x,v.isPointQuery()?v.screenBounds:v.screenGeometry)}},line:class LineStyleLayer extends StyleLayer{constructor(e,t){super(e,f_,t),this.gradientVersion=0}_handleSpecialPaintPropertyUpdate(e){if("line-gradient"===e){const e=this._transitionablePaint._values["line-gradient"].value.expression;this.stepInterpolant=e._styleExpression&&e._styleExpression.expression instanceof gr,this.gradientVersion=(this.gradientVersion+1)%Number.MAX_SAFE_INTEGER}}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}widthExpression(){return this._transitionablePaint._values["line-width"].value.expression}recalculate(e,t){super.recalculate(e,t),this.paint._values["line-floorwidth"]=b_.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,e)}createBucket(e){return new LineBucket(e)}getProgramIds(){return[this.paint.get("line-pattern").constantOr(1)?"linePattern":"line"]}getDefaultProgramParams(e,t){const i=x_(this);return{config:new ProgramConfiguration(this,t),defines:i,overrideFog:!1}}queryRadius(e){const t=e,i=w_(Ju("line-width",this,t),Ju("line-gap-width",this,t)),r=Ju("line-offset",this,t);return i/2+Math.abs(r)+Qu(this.paint.get("line-translate"))}queryIntersectsFeature(e,t,i,r,n,o){if(e.queryGeometry.isAboveHorizon)return!1;const a=eh(e.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),o.angle,e.pixelToTileUnitsFactor),s=e.pixelToTileUnitsFactor/2*w_(this.paint.get("line-width").evaluate(t,i),this.paint.get("line-gap-width").evaluate(t,i)),l=this.paint.get("line-offset").evaluate(t,i);return l&&(r=function(e,t){const i=[],r=new g(0,0);for(let n=0;n<e.length;n++){const o=e[n],a=[];for(let e=0;e<o.length;e++){const i=o[e],n=o[e+1],s=0===e?r:i.sub(o[e-1])._unit()._perp(),l=e===o.length-1?r:n.sub(i)._unit()._perp(),c=s._add(l)._unit();c._mult(1/(c.x*l.x+c.y*l.y)),a.push(c._mult(t)._add(i))}i.push(a)}return i}(r,l*e.pixelToTileUnitsFactor)),function(e,t,i){for(let r=0;r<t.length;r++){const n=t[r];if(e.length>=3)for(let t=0;t<n.length;t++)if(Hu(e,n[t]))return!0;if(Nu(e,n,i))return!0}return!1}(a,r,s)}isTileClipped(){return!0}},symbol:SymbolStyleLayer,background:class BackgroundStyleLayer extends StyleLayer{constructor(e,t){super(e,E_,t)}getProgramIds(){return[this.paint.get("background-pattern")?"backgroundPattern":"background"]}getDefaultProgramParams(e,t){return{overrideFog:!1}}},raster:class RasterStyleLayer extends StyleLayer{constructor(e,t){super(e,S_,t),this._updateColorRamp()}getProgramIds(){return["raster"]}hasColorMap(){return!!this._transitionablePaint._values["raster-color"].value.value}isLayerDraped(e){return!(e&&e._source instanceof ImageSource&&(e._source.onNorthPole||e._source.onSouthPole))}_handleSpecialPaintPropertyUpdate(e){"raster-color"!==e&&"raster-color-range"!==e||this._updateColorRamp()}_updateColorRamp(){if(!this.hasColorMap())return;const e=this._transitionablePaint._values["raster-color"].value.expression,[t,i]=this._transitionablePaint._values["raster-color-range"].value.expression.evaluate({zoom:0});this.colorRamp=gh({expression:e,evaluationKey:"rasterValue",image:this.colorRamp,clips:[{start:t,end:i}],resolution:256}),this.colorRampTexture=null}},sky:class SkyLayer extends StyleLayer{constructor(e,t){super(e,I_,t),this._updateColorRamp()}_handleSpecialPaintPropertyUpdate(e){"sky-gradient"===e?this._updateColorRamp():"sky-atmosphere-sun"!==e&&"sky-atmosphere-halo-color"!==e&&"sky-atmosphere-color"!==e&&"sky-atmosphere-sun-intensity"!==e||(this._skyboxInvalidated=!0)}_updateColorRamp(){this.colorRamp=gh({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null)}needsSkyboxCapture(e){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return!0;if(!this.paint.get("sky-atmosphere-sun")){const t=e.style.light.properties.get("position");return this._lightPosition.azimuthal!==t.azimuthal||this._lightPosition.polar!==t.polar}return!1}getCenter(e,t){if("atmosphere"===this.paint.get("sky-type")){const i=this.paint.get("sky-atmosphere-sun"),r=!i,n=e.style.light,o=n.properties.get("position");return r&&"viewport"===n.properties.get("anchor")&&$("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),r?D_(o.azimuthal,90-o.polar,t):D_(i[0],90-i[1],t)}const i=this.paint.get("sky-gradient-center");return D_(i[0],90-i[1],t)}isSky(){return!0}markSkyboxValid(e){this._skyboxInvalidated=!1,this._lightPosition=e.style.light.properties.get("position")}hasOffscreenPass(){return!0}getProgramIds(){const e=this.paint.get("sky-type");return"atmosphere"===e?["skyboxCapture","skybox"]:"gradient"===e?["skyboxGradient"]:null}},slot:class SlotStyleLayer extends StyleLayer{constructor(e,t){super(e,P_)}},model:class ModelStyleLayer extends StyleLayer{constructor(e,t){super(e,Em,t)}createBucket(e){return new ModelBucket(e)}getProgramIds(){return["model"]}is3D(){return!0}hasShadowPass(){return!0}canCastShadows(){return!0}hasLightBeamPass(){return!0}cutoffRange(){return this.paint.get("model-cutoff-fade-range")}queryRadius(){return 0}queryIntersectsFeature(){return!1}_handleOverridablePaintPropertyUpdate(e,t,i){return!(!this.layout||t.isDataDriven()||i.isDataDriven()||"model-color"!==e&&"model-color-mix-intensity"!==e&&"model-rotation"!==e&&"model-scale"!==e&&"model-translation"!==e&&"model-emissive-strength"!==e)}_isPropertyZoomDependent(e){const t=this._transitionablePaint._values[e];return null!=t&&null!=t.value&&null!=t.value.expression&&t.value.expression instanceof ZoomDependentExpression}isZoomDependent(){return this._isPropertyZoomDependent("model-scale")||this._isPropertyZoomDependent("model-rotation")||this._isPropertyZoomDependent("model-translation")}}};function z_(e,t){return"custom"===e.type?new CustomStyleLayer(e):new L_[e.type](e,t)}function R_(e){const{userImage:t}=e;return!!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}class ImageManager extends Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded={},this.requestors=[],this.patterns={},this.atlasImage={},this.atlasTexture={},this.dirty=!0}createScope(e){this.images[e]={},this.loaded[e]=!1,this.updatedImages[e]={},this.patterns[e]={},this.callbackDispatchedThisFrame[e]={},this.atlasImage[e]=new RGBAImage({width:1,height:1})}isLoaded(){for(const e in this.loaded)if(!this.loaded[e])return!1;return!0}setLoaded(e,t){if(this.loaded[t]!==e&&(this.loaded[t]=e,e)){for(const{ids:e,callback:i}of this.requestors)this._notify(e,t,i);this.requestors=[]}}hasImage(e,t){return!!this.getImage(e,t)}getImage(e,t){return this.images[t][e]}addImage(e,t,i){this._validate(e,i)&&(this.images[t][e]=i)}_validate(e,t){let i=!0;return this._validateStretch(t.stretchX,t.data&&t.data.width)||(this.fire(new ErrorEvent(new Error(`Image "${e}" has invalid "stretchX" value`))),i=!1),this._validateStretch(t.stretchY,t.data&&t.data.height)||(this.fire(new ErrorEvent(new Error(`Image "${e}" has invalid "stretchY" value`))),i=!1),this._validateContent(t.content,t)||(this.fire(new ErrorEvent(new Error(`Image "${e}" has invalid "content" value`))),i=!1),i}_validateStretch(e,t){if(!e)return!0;let i=0;for(const r of e){if(r[0]<i||r[1]<r[0]||t<r[1])return!1;i=r[1]}return!0}_validateContent(e,t){return!(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t,i){i.version=this.images[t][e].version+1,this.images[t][e]=i,this.updatedImages[t][e]=!0}removeImage(e,t){const i=this.images[t][e];delete this.images[t][e],delete this.patterns[t][e],i.userImage&&i.userImage.onRemove&&i.userImage.onRemove()}listImages(e){return Object.keys(this.images[e])}getImages(e,t,i){let r=!0;const n=!!this.loaded[t];if(!n)for(const i of e)this.images[t][i]||(r=!1);n||r?this._notify(e,t,i):this.requestors.push({ids:e,scope:t,callback:i})}getUpdatedImages(e){return this.updatedImages[e]}_notify(e,t,i){const r={};for(const i of e){this.images[t][i]||this.fire(new Event("styleimagemissing",{id:i}));const e=this.images[t][i];e?r[i]={data:e.data.clone(),pixelRatio:e.pixelRatio,sdf:e.sdf,version:e.version,stretchX:e.stretchX,stretchY:e.stretchY,content:e.content,hasRenderCallback:Boolean(e.userImage&&e.userImage.render)}:$(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`)}i(null,r)}getPixelSize(e){const{width:t,height:i}=this.atlasImage[e];return{width:t,height:i}}getPattern(e,t){const i=this.patterns[t][e],r=this.getImage(e,t);if(!r)return null;if(i&&i.position.version===r.version)return i.position;if(i)i.position.version=r.version;else{const i={w:r.data.width+2,h:r.data.height+2,x:0,y:0},n=new ImagePosition(i,r);this.patterns[t][e]={bin:i,position:n}}return this._updatePatternAtlas(t),this.patterns[t][e].position}bind(e,t){const i=e.gl;let r=this.atlasTexture[t];r?this.dirty&&(r.update(this.atlasImage[t]),this.dirty=!1):(r=new Texture(e,this.atlasImage[t],i.RGBA),this.atlasTexture[t]=r),r.bind(i.LINEAR,i.CLAMP_TO_EDGE)}_updatePatternAtlas(e){const t=[];for(const i in this.patterns[e])t.push(this.patterns[e][i].bin);const{w:i,h:r}=Tp(t),n=this.atlasImage[e];n.resize({width:i||1,height:r||1});for(const t in this.patterns[e]){const{bin:i}=this.patterns[e][t],r=i.x+1,o=i.y+1,a=this.images[e][t].data,s=a.width,l=a.height;RGBAImage.copy(a,n,{x:0,y:0},{x:r,y:o},{width:s,height:l}),RGBAImage.copy(a,n,{x:0,y:l-1},{x:r,y:o-1},{width:s,height:1}),RGBAImage.copy(a,n,{x:0,y:0},{x:r,y:o+l},{width:s,height:1}),RGBAImage.copy(a,n,{x:s-1,y:0},{x:r-1,y:o},{width:1,height:l}),RGBAImage.copy(a,n,{x:0,y:0},{x:r+s,y:o},{width:1,height:l})}this.dirty=!0}beginFrame(){for(const e in this.images)this.callbackDispatchedThisFrame[e]={}}dispatchRenderCallbacks(e,t){for(const i of e){if(this.callbackDispatchedThisFrame[t][i])continue;this.callbackDispatchedThisFrame[t][i]=!0;const e=this.images[t][i];R_(e)&&this.updateImage(i,t,e)}}}const k_=new Properties({anchor:new DataConstantProperty(xt.light.anchor),position:new class PositionProperty{constructor(e){this.specification=e}possiblyEvaluate(e,t){return X(e.expression.evaluate(t))}interpolate(e,t,i){return{x:yr(e.x,t.x,i),y:yr(e.y,t.y,i),z:yr(e.z,t.z,i),azimuthal:yr(e.azimuthal,t.azimuthal,i),polar:yr(e.polar,t.polar,i)}}}(xt.light.position),color:new DataConstantProperty(xt.light.color),intensity:new DataConstantProperty(xt.light.intensity)});class Light extends Evented{constructor(e,t="flat"){super(),this._transitionable=new Transitionable(k_),this.setLight(e,t),this._transitioning=this._transitionable.untransitioned()}getLight(){return this._transitionable.serialize()}setLight(e,t,i={}){this._validate(wo,e,i)||(this._transitionable.setTransitionOrValue(e),this.id=t)}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}_validate(e,t,i){return(!i||!1!==i.validate)&&Lo(this,e.call(vo,z({value:t,style:{glyphs:!0,sprite:!0},styleSpec:xt})))}}const B_=new Properties({source:new DataConstantProperty(xt.terrain.source),exaggeration:new DataConstantProperty(xt.terrain.exaggeration)});let O_=class Terrain extends Evented{constructor(e,t){super(),this._transitionable=new Transitionable(B_),this.set(e),this._transitioning=this._transitionable.untransitioned(),this.drapeRenderMode=t}setScope(e){this.scope=e}get(){return this._transitionable.serialize()}set(e){this._transitionable.setTransitionOrValue(e)}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}getExaggeration(e){return this._transitioning.possiblyEvaluate(new EvaluationParameters(e)).get("exaggeration")}isZoomDependent(){const e=this._transitionable._values.exaggeration;return null!=e&&null!=e.value&&null!=e.value.expression&&e.value.expression instanceof ZoomDependentExpression}};const F_=45,U_=65,V_=.05;function N_(e,t,i,r){const n=D(F_,U_,i),[o,a]=j_(e,r);let s=1-Math.min(1,Math.exp((t-o)/(a-o)*-6));return s*=s*s,s=Math.min(1,1.00747*s),s*n*e.alpha}function j_(e,t){const i=.5/Math.tan(.5*t);return[e.range[0]+i,e.range[1]+i]}function G_(e,t,i,r,n){const o=lc.transformMat4([],[t,i,r],n.mercatorFogMatrix);return N_(e,lc.length(o),n.pitch,n._fov)}function q_(e,t,i,r,n,o,a){const s=[[i,r,0],[n,r,0],[n,o,0],[i,o,0]];let l=Number.MAX_VALUE,c=-Number.MAX_VALUE;for(const e of s){const i=lc.transformMat4([],e,t),r=lc.length(i);l=Math.min(l,r),c=Math.max(c,r)}return[N_(e,l,a.pitch,a._fov),N_(e,c,a.pitch,a._fov)]}const Z_=new Properties({range:new DataConstantProperty(xt.fog.range),color:new DataConstantProperty(xt.fog.color),"high-color":new DataConstantProperty(xt.fog["high-color"]),"space-color":new DataConstantProperty(xt.fog["space-color"]),"horizon-blend":new DataConstantProperty(xt.fog["horizon-blend"]),"star-intensity":new DataConstantProperty(xt.fog["star-intensity"]),"vertical-range":new DataConstantProperty(xt.fog["vertical-range"])});class Fog extends Evented{constructor(e,t){super(),this._transitionable=new Transitionable(Z_),this.set(e),this._transitioning=this._transitionable.untransitioned(),this._transform=t}get state(){const e=this._transform,t="globe"===e.projection.name,i=Qc(e.zoom),r=this.properties.get("range"),n=[.5,3];return{range:t?[yr(n[0],r[0],i),yr(n[1],r[1],i)]:r,horizonBlend:this.properties.get("horizon-blend"),alpha:this.properties.get("color").a}}get(){return this._transitionable.serialize()}set(e,t={}){if(this._validate(Mo,e,t))return;const i=z({},e);for(const e of Object.keys(xt.fog))void 0===i[e]&&(i[e]=xt.fog[e].default);this._transitionable.setTransitionOrValue(i)}getOpacity(e){if(!this._transform.projection.supportsFog)return 0;const t=this.properties&&this.properties.get("color")||1;return("globe"===this._transform.projection.name?1:D(F_,U_,e))*t.a}getOpacityAtLatLng(e,t){return this._transform.projection.supportsFog?function(e,t,i){const r=MercatorCoordinate.fromLngLat(t),n=i.elevation?i.elevation.getAtPointOrZero(r):0;return G_(e,r.x,r.y,n,i)}(this.state,e,t):0}getOpacityForTile(e){if(!this._transform.projection.supportsFog)return[1,1];const t=this._transform.calculateFogTileMatrix(e.toUnwrapped());return q_(this.state,t,0,0,Ri,Ri,this._transform)}getOpacityForBounds(e,t,i,r,n){return this._transform.projection.supportsFog?q_(this.state,e,t,i,r,n,this._transform):[1,1]}getFovAdjustedRange(e){return this._transform.projection.supportsFog?j_(this.state,e):[0,1]}isVisibleOnFrustum(e){if(!this._transform.projection.supportsFog)return!1;const t=[4,5,6,7];for(const i of t){const t=e.points[i];let r;if(t[2]>=0)r=t;else{const n=e.points[i-4];r=xr(n,t,n[2]/(n[2]-t[2]))}if(G_(this.state,r[0],r[1],0,this._transform)>=V_)return!0}return!1}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}_validate(e,t,i){return(!i||!1!==i.validate)&&Lo(this,e.call(vo,z({value:t,style:{glyphs:!0,sprite:!0},styleSpec:xt})))}}class ThrottledInvoker{constructor(e){this._callback=e,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback()})}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout((()=>{this._triggered=!1,this._callback()}),0))}remove(){this._channel=void 0,this._callback=()=>{}}}class Scheduler{constructor(){this.tasks={},this.taskQueue=[],V(["process"],this),this.invoker=new ThrottledInvoker(this.process),this.nextId=0}add(e,t){const i=this.nextId++,r=function({type:e,isSymbolTile:t,zoom:i}){return i=i||0,"message"===e?0:"maybePrepare"!==e||t?"parseTile"!==e||t?"parseTile"===e&&t?300-i:"maybePrepare"===e&&t?400-i:500:200-i:100-i}(t);if(0===r){K();try{e()}finally{}return{cancel:()=>{}}}return this.tasks[i]={fn:e,metadata:t,priority:r,id:i},this.taskQueue.push(i),this.invoker.trigger(),{cancel:()=>{delete this.tasks[i]}}}process(){K();try{if(this.taskQueue=this.taskQueue.filter((e=>!!this.tasks[e])),!this.taskQueue.length)return;const e=this.pick();if(null===e)return;const t=this.tasks[e];if(delete this.tasks[e],this.taskQueue.length&&this.invoker.trigger(),!t)return;t.fn()}finally{}}pick(){let e=null,t=1/0;for(let i=0;i<this.taskQueue.length;i++){const r=this.tasks[this.taskQueue[i]];r.priority<t&&(t=r.priority,e=i)}if(null===e)return null;const i=this.taskQueue[e];return this.taskQueue.splice(e,1),i}remove(){this.invoker.remove()}}class Dispatcher{constructor(e,t){this.workerPool=e,this.actors=[],this.currentActor=0,this.id=B();const i=this.workerPool.acquire(this.id);for(let e=0;e<i.length;e++){const r=new Dispatcher.Actor(i[e],t,this.id);r.name=`Worker ${e}`,this.actors.push(r)}this.ready=!1,this.broadcast("checkIfReady",null,(()=>{this.ready=!0}))}broadcast(e,t,i){L(this.actors,((i,r)=>{i.send(e,t,r)}),i=i||function(){})}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach((e=>{e.remove()})),this.actors=[],this.workerPool.release(this.id)}}Dispatcher.Actor=class Actor{constructor(e,t,i){this.target=e,this.parent=t,this.mapId=i,this.callbacks={},this.cancelCallbacks={},V(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.scheduler=new Scheduler}send(e,t,i,r,n=!1,o){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);i&&(i.metadata=o,this.callbacks[a]=i);const s=new Set;return this.target.postMessage({id:a,type:e,hasCallback:!!i,targetMapId:r,mustQueue:n,sourceMapId:this.mapId,data:No(t,s)},s),{cancel:()=>{i&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:r,sourceMapId:this.mapId})}}}receive(e){const t=e.data,i=t.id;if(i&&(!t.targetMapId||this.mapId===t.targetMapId))if("<cancel>"===t.type){const e=this.cancelCallbacks[i];delete this.cancelCallbacks[i],e&&e.cancel()}else if(t.mustQueue||K()){const e=this.callbacks[i];this.cancelCallbacks[i]=this.scheduler.add((()=>this.processTask(i,t)),e&&e.metadata||{type:"message"})}else this.processTask(i,t)}processTask(e,t){if("<response>"===t.type){const i=this.callbacks[e];delete this.callbacks[e],i&&(t.error?i(jo(t.error)):i(null,jo(t.data)))}else{const i=new Set,r=t.hasCallback?(t,r)=>{delete this.cancelCallbacks[e],this.target.postMessage({id:e,type:"<response>",sourceMapId:this.mapId,error:t?No(t):null,data:No(r,i)},i)}:e=>{},n=jo(t.data);if(this.parent[t.type])this.parent[t.type](t.sourceMapId,n,r);else if(this.parent.getWorkerSource){const e=t.type.split(".");this.parent.getWorkerSource(t.sourceMapId,e[0],n.source,n.scope)[e[1]](n,r)}else r(new Error(`Could not find function ${t.type}`))}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1)}};class Lights extends Evented{constructor(e,t,i,r){super(),this.scope=i,this._options=e,this.properties=new PossiblyEvaluated(t),this._transitionable=new Transitionable(t,new Map(r)),this._transitionable.setTransitionOrValue(e.properties),this._transitioning=this._transitionable.untransitioned()}updateConfig(e){this._transitionable.setTransitionOrValue(this._options.properties,new Map(e))}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning)}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e)}get(){return this._options.properties=this._transitionable.serialize(),this._options}set(e,t){this._options=e,this._transitionable.setTransitionOrValue(e.properties,t)}shadowsEnabled(){return!!this.properties&&!0===this.properties.get("cast-shadows")}}const $_=new Properties({color:new DataConstantProperty(xt.properties_light_ambient.color),intensity:new DataConstantProperty(xt.properties_light_ambient.intensity)}),H_=new Properties({direction:new class DirectionProperty{constructor(e){this.specification=e}possiblyEvaluate(e,t){return function([e,t]){const i=X([1,e,t]);return{x:i.x,y:i.y,z:i.z}}(e.expression.evaluate(t))}interpolate(e,t,i){return{x:yr(e.x,t.x,i),y:yr(e.y,t.y,i),z:yr(e.z,t.z,i)}}}(xt.properties_light_directional.direction),color:new DataConstantProperty(xt.properties_light_directional.color),intensity:new DataConstantProperty(xt.properties_light_directional.intensity),"cast-shadows":new DataConstantProperty(xt.properties_light_directional["cast-shadows"]),"shadow-intensity":new DataConstantProperty(xt.properties_light_directional["shadow-intensity"])});class QueryGeometry{constructor(e,t,i,r){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this._bufferedScreenMercator(0,r)}static createFromScreenPoints(e,t){let i,r;if(e instanceof g||"number"==typeof e[0]){const n=g.convert(e);i=[n],r=t.isPointAboveHorizon(n)}else{const n=g.convert(e[0]),o=g.convert(e[1]);i=[n,o],r=S(n,o).every((e=>t.isPointAboveHorizon(e)))}return new QueryGeometry(i,t.getCameraPoint(),r,t)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(e){return S(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],e)}bufferedCameraGeometry(e){const t=this.screenBounds[0],i=1===this.screenBounds.length?this.screenBounds[0].add(new g(1,1)):this.screenBounds[1],r=S(t,i,0,!1);return this.cameraPoint.y>i.y&&(this.cameraPoint.x>t.x&&this.cameraPoint.x<i.x?r.splice(3,0,this.cameraPoint):this.cameraPoint.x>=i.x?r[2]=this.cameraPoint:this.cameraPoint.x<=t.x&&(r[3]=this.cameraPoint)),function(e,t){const i=[];for(let r=0;r<e.length;r++){const n=P(r-1,-1,e.length-1),o=P(r+1,-1,e.length-1),a=e[r],s=e[o],l=e[n].sub(a).unit(),c=s.sub(a).unit(),u=c.angleWithSep(l.x,l.y),h=l.add(c).unit().mult(-1*t/Math.sin(u/2));i.push(a.add(h))}return i}(r,e)}bufferedCameraGeometryGlobe(e){const t=this.screenBounds[0],i=1===this.screenBounds.length?this.screenBounds[0].add(new g(1,1)):this.screenBounds[1],r=S(t,i,e),n=this.cameraPoint.clone();switch(3*((n.y>t.y)+(n.y>i.y))+((n.x>t.x)+(n.x>i.x))){case 0:r[0]=n,r[4]=n.clone();break;case 1:r.splice(1,0,n);break;case 2:r[1]=n;break;case 3:r.splice(4,0,n);break;case 5:r.splice(2,0,n);break;case 6:r[3]=n;break;case 7:r.splice(3,0,n);break;case 8:r[2]=n}return r}containsTile(e,t,i,r=0){const n=e.queryPadding/t._pixelsPerMercatorPixel+1,o=i?this._bufferedCameraMercator(n,t):this._bufferedScreenMercator(n,t);let a=e.tileID.wrap+(o.unwrapped?r:0);const s=o.polygon.map((t=>Op(e.tileTransform,t,a)));if(!Wu(s,0,0,Ri,Ri))return;a=e.tileID.wrap+(this.screenGeometryMercator.unwrapped?r:0);const l=this.screenGeometryMercator.polygon.map((t=>Fp(e.tileTransform,t,a))),c=l.map((e=>new g(e[0],e[1]))),u=t.getFreeCameraOptions().position||new MercatorCoordinate(0,0,0),h=Fp(e.tileTransform,u,a),d=l.map((e=>{const t=lc.sub(e,e,h);return lc.normalize(t,t),new Ray(h,t)})),p=Wf(e,1,t.zoom)*t._pixelsPerMercatorPixel;return{queryGeometry:this,tilespaceGeometry:c,tilespaceRays:d,bufferedTilespaceGeometry:s,bufferedTilespaceBounds:(f=M(s),f.min.x=I(f.min.x,0,Ri),f.min.y=I(f.min.y,0,Ri),f.max.x=I(f.max.x,0,Ri),f.max.y=I(f.max.y,0,Ri),f),tile:e,tileID:e.tileID,pixelToTileUnitsFactor:p};var f}_bufferedScreenMercator(e,t){const i=Y_(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{let r;return r="globe"===t.projection.name?this._projectAndResample(this.bufferedScreenGeometry(e),t):{polygon:this.bufferedScreenGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._screenRaycastCache[i]=r,r}}_bufferedCameraMercator(e,t){const i=Y_(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{let r;return r="globe"===t.projection.name?this._projectAndResample(this.bufferedCameraGeometryGlobe(e),t):{polygon:this.bufferedCameraGeometry(e).map((e=>t.pointCoordinate3D(e))),unwrapped:!0},this._cameraRaycastCache[i]=r,r}}_projectAndResample(e,t){const i=function(e,t){const i=ic.multiply([],t.pixelMatrix,t.globeMatrix),r=[0,-Sc,0,1],n=[0,Sc,0,1],o=[0,0,0,1];Wl.transformMat4(r,r,i),Wl.transformMat4(n,n,i),Wl.transformMat4(o,o,i);const a=new g(r[0]/r[3],r[1]/r[3]),s=new g(n[0]/n[3],n[1]/n[3]),l=Hu(e,a)&&r[3]<o[3],c=Hu(e,s)&&n[3]<o[3];if(!l&&!c)return null;const u=function(e,t,i){for(let r=1;r<e.length;r++){const n=X_(t.pointCoordinate3D(e[r-1]).x),o=X_(t.pointCoordinate3D(e[r]).x);if(i<0){if(n<o)return{idx:r,t:-n/(o-1-n)}}else if(o<n)return{idx:r,t:(1-n)/(o+1-n)}}return null}(e,t,l?-1:1);if(!u)return null;const{idx:h,t:d}=u;let p=h>1?W_(e.slice(0,h),t):[],f=h<e.length?W_(e.slice(h),t):[];p=p.map((e=>new g(X_(e.x),e.y))),f=f.map((e=>new g(X_(e.x),e.y)));const m=[...p];0===m.length&&m.push(f[f.length-1]);const _=yr(m[m.length-1].y,(0===f.length?p[0]:f[0]).y,d);let y;return y=l?[new g(0,_),new g(0,0),new g(1,0),new g(1,_)]:[new g(1,_),new g(1,1),new g(0,1),new g(0,_)],m.push(...y),0===f.length?m.push(p[0]):m.push(...f),{polygon:m.map((e=>new MercatorCoordinate(e.x,e.y))),unwrapped:!1}}(e,t);if(i)return i;const r=function(e,t){let i=!1,r=-1/0,n=0;for(let t=0;t<e.length-1;t++)e[t].x>r&&(r=e[t].x,n=t);for(let t=0;t<e.length-1;t++){const r=(n+t)%(e.length-1),o=e[r],a=e[r+1];Math.abs(o.x-a.x)>.5&&(o.x<a.x?(o.x+=1,0===r&&(e[e.length-1].x+=1)):(a.x+=1,r+1===e.length-1&&(e[0].x+=1)),i=!0)}const o=_u(t.center.lng);return i&&o<Math.abs(o-1)&&e.forEach((e=>{e.x-=1})),{polygon:e,unwrapped:i}}(W_(e,t).map((e=>new g(X_(e.x),e.y))),t);return{polygon:r.polygon.map((e=>new MercatorCoordinate(e.x,e.y))),unwrapped:r.unwrapped}}}function W_(e,t){return Cu(e,(e=>{const i=t.pointCoordinate3D(e);e.x=i.x,e.y=i.y}),1/256)}function X_(e){return e<0?1+e%1:e%1}function Y_(e){return 100*e|0}function K_(e,t,i,r,n){const o=function(i,r){if(i)return n(i);if(r){e.url&&r.tiles&&e.tiles&&delete e.tiles;const i=R(z(r,e),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(i.vectorLayers=r.vector_layers,i.vectorLayerIds=i.vectorLayers.map((e=>e.id))),i.tiles=t.canonicalizeTileset(i,e.url),n(null,i)}};return e.url?xe(t.transformRequest(t.normalizeSourceURL(e.url,null,i,r),_e.Source),o):rt.frame((()=>o(null,e)))}class TileBounds{constructor(e,t,i){this.bounds=LngLatBounds.convert(this.validateBounds(e)),this.minzoom=t||0,this.maxzoom=i||24}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(e){const t=Math.pow(2,e.z),i=Math.floor(_u(this.bounds.getWest())*t),r=Math.floor(gu(this.bounds.getNorth())*t),n=Math.ceil(_u(this.bounds.getEast())*t),o=Math.ceil(gu(this.bounds.getSouth())*t);return e.x>=i&&e.x<n&&e.y>=r&&e.y<o}}Fo(class LineAtlas{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.image=new AlphaImage({width:e,height:t}),this.positions={},this.uploaded=!1}getDash(e,t){const i=this.getKey(e,t);return this.positions[i]}trim(){const e=this.width,t=this.height=F(this.nextRow);this.image.resize({width:e,height:t})}getKey(e,t){return e.join(",")+t}getDashRanges(e,t,i){const r=[];let n=e.length%2==1?-e[e.length-1]*i:0,o=e[0]*i,a=!0;r.push({left:n,right:o,isDash:a,zeroLength:0===e[0]});let s=e[0];for(let t=1;t<e.length;t++){a=!a;const l=e[t];n=s*i,s+=l,o=s*i,r.push({left:n,right:o,isDash:a,zeroLength:0===l})}return r}addRoundDash(e,t,i){const r=t/2;for(let t=-i;t<=i;t++){const n=this.width*(this.nextRow+i+t);let o=0,a=e[o];for(let s=0;s<this.width;s++){s/a.right>1&&(a=e[++o]);const l=Math.abs(s-a.left),c=Math.abs(s-a.right),u=Math.min(l,c);let h;const d=t/i*(r+1);if(a.isDash){const e=r-Math.abs(d);h=Math.sqrt(u*u+e*e)}else h=r-Math.sqrt(u*u+d*d);this.image.data[n+s]=Math.max(0,Math.min(255,h+128))}}}addRegularDash(e,t){for(let t=e.length-1;t>=0;--t){const i=e[t],r=e[t+1];i.zeroLength?e.splice(t,1):r&&r.isDash===i.isDash&&(r.left=i.left,e.splice(t,1))}const i=e[0],r=e[e.length-1];i.isDash===r.isDash&&(i.left=r.left-this.width,r.right=i.right+this.width);const n=this.width*this.nextRow;let o=0,a=e[o];for(let i=0;i<this.width;i++){i/a.right>1&&(a=e[++o]);const r=Math.abs(i-a.left),s=Math.abs(i-a.right),l=Math.min(r,s);this.image.data[n+i]=Math.max(0,Math.min(255,(a.isDash?l:-l)+t+128))}}addDash(e,t){const i=this.getKey(e,t);if(this.positions[i])return this.positions[i];const r="round"===t,n=r?7:0,o=2*n+1;if(this.nextRow+o>this.height)return $("LineAtlas out of space"),null;0===e.length&&e.push(1);let a=0;for(let t=0;t<e.length;t++)e[t]<0&&($("Negative value is found in line dasharray, replacing values with 0"),e[t]=0),a+=e[t];if(0!==a){const i=this.width/a,o=this.getDashRanges(e,this.width,i);r?this.addRoundDash(o,i,n):this.addRegularDash(o,"square"===t?.5*i:0)}const s=this.nextRow+n;this.nextRow+=o;const l={tl:[s,n],br:[a,0]};return this.positions[i]=l,l}},"LineAtlas"),Fo(class GlyphAtlas{constructor(e){const t={},i=[];for(const r in e){const n=e[r],o=t[r]={};for(const e in n.glyphs){const t=n.glyphs[+e];if(!t||0===t.bitmap.width||0===t.bitmap.height)continue;const r=t.metrics.localGlyph?2:1,a={x:0,y:0,w:t.bitmap.width+2*r,h:t.bitmap.height+2*r};i.push(a),o[e]=a}}const{w:r,h:n}=Tp(i),o=new AlphaImage({width:r||1,height:n||1});for(const i in e){const r=e[i];for(const e in r.glyphs){const n=r.glyphs[+e];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=t[i][e],s=n.metrics.localGlyph?2:1;AlphaImage.copy(n.bitmap,o,{x:0,y:0},{x:a.x+s,y:a.y+s},n.bitmap)}}this.image=o,this.positions=t}},"GlyphAtlas");class DedupedRequest{constructor(e){this.entries={},this.scheduler=e}request(e,t,i,r){const n=this.entries[e]=this.entries[e]||{callbacks:[]};if(n.result){const[e,i]=n.result;return this.scheduler?this.scheduler.add((()=>{r(e,i)}),t):r(e,i),()=>{}}return n.callbacks.push(r),n.cancel||(n.cancel=i(((i,r)=>{n.result=[i,r];for(const e of n.callbacks)this.scheduler?this.scheduler.add((()=>{e(i,r)}),t):e(i,r);setTimeout((()=>delete this.entries[e]),3e3)}))),()=>{n.result||(n.callbacks=n.callbacks.filter((e=>e!==r)),n.callbacks.length||(n.cancel(),delete this.entries[e]))}}}function J_(e,t,i){const r=JSON.stringify(e.request);return e.data&&(this.deduped.entries[r]={result:[null,e.data]}),this.deduped.request(r,{type:"parseTile",isSymbolTile:e.isSymbolTile,zoom:e.tileZoom},(t=>{const r=ve(e.request,((e,r,n,o)=>{e?t(e):r&&t(null,{vectorTile:i?void 0:new xd(new qd(r)),rawData:r,cacheControl:n,expires:o})}));return()=>{r.cancel(),t()}}),t)}class VectorTileSource extends Evented{constructor(e,t,i,r){if(super(),this.id=e,this.dispatcher=i,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,z(this,R(t,["url","scheme","tileSize","promoteId"])),this._options=z({type:"vector"},t),this._collectResourceTiming=!!t.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(r),this._tileWorkers={},this._deduped=new DedupedRequest}load(e){this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"}));const t=Array.isArray(this.map._language)?this.map._language.join():this.map._language,i=this.map._worldview;this._tileJSONRequest=K_(this._options,this.map._requestManager,t,i,((r,n)=>{this._tileJSONRequest=null,this._loaded=!0,r?(t&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${t}`),i&&2!==i.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${i}`),this.fire(new ErrorEvent(r))):n&&(z(this,n),n.bounds&&(this.tileBounds=new TileBounds(n.bounds,this.minzoom,this.maxzoom)),Fe(n.tiles,this.map._requestManager._customAccessToken),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))),e&&e(r)}))}loaded(){return this._loaded}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load()}reload(){this.cancelTileJSONRequest();const e=sa(this.id,this.scope);this.load((()=>this.map.style.clearSource(e)))}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest()}serialize(){return z({},this._options)}loadTile(e,t){const i=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(i,_e.Tile),data:void 0,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,pixelRatio:rt.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:e.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0,extraShadowCaster:e.isExtraShadowCaster};if(r.request.collectResourceTiming=this._collectResourceTiming,e.actor&&"expired"!==e.state)"loading"===e.state?e.reloadCallback=t:e.request=e.actor.send("reloadTile",r,n.bind(this));else if(e.actor=this._tileWorkers[i]=this._tileWorkers[i]||this.dispatcher.getActor(),this.dispatcher.ready)e.request=e.actor.send("loadTile",r,n.bind(this),void 0,!0);else{const t=J_.call({deduped:this._deduped},r,((t,i)=>{t||!i?n.call(this,t):(r.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},e.actor&&e.actor.send("loadTile",r,n.bind(this),void 0,!0))}),!0);e.request={cancel:t}}function n(i,r){return delete e.request,e.aborted?t(null):i&&404!==i.status?t(i):(r&&r.resourceTiming&&(e.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&r&&e.setExpiryData(r),e.loadVectorData(r,this.map.painter),me(this.dispatcher),t(null),void(e.reloadCallback&&(this.loadTile(e,e.reloadCallback),e.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope})}unloadTile(e){e.unloadVectorData(),e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope})}hasTransition(){return!1}afterUpdate(){this._tileWorkers={}}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null)}}class RasterTileSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.dispatcher=i,this.setEventedParent(r),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=z({type:"raster"},t),z(this,R(t,["url","scheme","tileSize"]))}load(e){this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"})),this._tileJSONRequest=K_(this._options,this.map._requestManager,null,null,((t,i)=>{this._tileJSONRequest=null,this._loaded=!0,t?this.fire(new ErrorEvent(t)):i&&(z(this,i),i.bounds&&(this.tileBounds=new TileBounds(i.bounds,this.minzoom,this.maxzoom)),Fe(i.tiles),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))),e&&e(t)}))}loaded(){return this._loaded}onAdd(e){this.map=e,this.load()}reload(){this.cancelTileJSONRequest();const e=sa(this.id,this.scope);this.load((()=>this.map.style.clearSource(e)))}setTiles(e){return this._options.tiles=e,this.reload(),this}setUrl(e){return this.url=e,this._options.url=e,this.reload(),this}onRemove(){this.cancelTileJSONRequest()}serialize(){return z({},this._options)}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(e,t){const i=rt.devicePixelRatio>=2,r=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme),i,this.tileSize);e.request=Me(this.map._requestManager.transformRequest(r,_e.Tile),((i,r,n,o)=>(delete e.request,e.aborted?(e.state="unloaded",t(null)):i?(e.state="errored",t(i)):r?(this.map._refreshExpiredTiles&&e.setExpiryData({cacheControl:n,expires:o}),e.setTexture(r,this.map.painter),e.state="loaded",me(this.dispatcher),void t(null)):t(null))))}static loadTileData(e,t,i){e.setTexture(t,i)}static unloadTileData(e,t){e.texture&&t.saveTileTexture(e.texture)}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t()}unloadTile(e,t){e.texture&&this.map.painter.saveTileTexture(e.texture),t()}hasTransition(){return!1}cancelTileJSONRequest(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null)}}let Q_;function eg(){return null!=ib.workerClass?new ib.workerClass:new e.Worker(ib.workerUrl)}const tg="mapboxgl_preloaded_worker_pool";class WorkerPool{constructor(){this.active={}}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<WorkerPool.workerCount;)this.workers.push(new eg);return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],this.workers&&0===this.numActive()&&(this.workers.forEach((e=>{e.terminate()})),this.workers=null)}isPreloaded(){return!!this.active[tg]}numActive(){return Object.keys(this.active).length}}let ig;function rg(){return ig||(ig=new WorkerPool),ig}WorkerPool.workerCount=2;let ng,og,ag,sg=null;function lg(){return K()&&self.worker&&self.worker.dracoUrl?self.worker.dracoUrl:og||r.DRACO_URL}const cg=5123,ug=5126,hg={5120:Int8Array,5121:Uint8Array,5122:Int16Array,[cg]:Uint16Array,5125:Uint32Array,[ug]:Float32Array},dg={5120:"DT_INT8",5121:"DT_UINT8",5122:"DT_INT16",[cg]:"DT_UINT16",5125:"DT_UINT32",[ug]:"DT_FLOAT32"},pg={SCALAR:1,VEC2:2,VEC3:3,VEC4:4,MAT2:4,MAT3:9,MAT4:16};function fg(e,t,i){const r=i.json.bufferViews.length,n=i.buffers.length;t.bufferView=r,i.json.bufferViews[r]={buffer:n,byteLength:e.byteLength},i.buffers[n]=e}const mg="KHR_draco_mesh_compression";function _g(e,t){const i=e.extensions&&e.extensions[mg];if(!i)return;const r=new ag.Decoder,n=vg(t,i.bufferView),o=new ag.Mesh;if(!r.DecodeArrayToMesh(n,n.byteLength,o))throw new Error("Failed to decode Draco mesh");const a=t.json.accessors[e.indices],s=hg[a.componentType],l=a.count*s.BYTES_PER_ELEMENT,c=ag._malloc(l);s===Uint16Array?r.GetTrianglesUInt16Array(o,l,c):r.GetTrianglesUInt32Array(o,l,c),fg(ag.memory.buffer.slice(c,c+l),a,t),ag._free(c);for(const n of Object.keys(i.attributes)){const a=r.GetAttributeByUniqueId(o,i.attributes[n]),s=t.json.accessors[e.attributes[n]],l=dg[s.componentType],c=s.count*pg[s.type]*hg[s.componentType].BYTES_PER_ELEMENT,u=ag._malloc(c);r.GetAttributeDataArrayForAllPoints(o,a,ag[l],c,u),fg(ag.memory.buffer.slice(u,u+c),s,t),ag._free(u)}r.destroy(),o.destroy(),delete e.extensions[mg]}const gg=new TextDecoder("utf8");function yg(e,t){return new URL(e,t).href}function xg(e,t,i,r){return fetch(yg(e.uri,r)).then((e=>e.arrayBuffer())).then((e=>{t.buffers[i]=e}))}function vg(e,t){const i=e.json.bufferViews[t];return new Uint8Array(e.buffers[i.buffer],i.byteOffset||0,i.byteLength)}function bg(t,i,r,n){if(t.uri){const o=yg(t.uri,n);return fetch(o).then((e=>e.blob())).then((t=>e.createImageBitmap(t))).then((e=>{i.images[r]=e}))}if(void 0!==t.bufferView){const n=vg(i,t.bufferView),o=new e.Blob([n],{type:t.mimeType});return e.createImageBitmap(o).then((e=>{i.images[r]=e}))}}function wg(e){return fetch(e).then((e=>e.arrayBuffer())).then((t=>function(e,t=0,i){const r={json:null,images:[],buffers:[]};if(1179937895===new Uint32Array(e,t,1)[0]){const i=new Uint32Array(e,t);let n=2;const o=(i[n++]>>2)-3,a=i[n++]>>2;if(n++,r.json=JSON.parse(gg.decode(i.subarray(n,n+a))),n+=a,n<o){const o=i[n++];n++;const a=t+(n<<2);r.buffers[0]=e.slice(a,a+o)}}else r.json=JSON.parse(gg.decode(new Uint8Array(e,t)));const{buffers:n,images:o,meshes:a,extensionsUsed:s}=r.json;let l=Promise.resolve();if(n){const e=[];for(let t=0;t<n.length;t++){const o=n[t];o.uri?e.push(xg(o,r,t,i)):r.buffers[t]||(r.buffers[t]=null)}l=Promise.all(e)}return l.then((()=>{const e=[],t=s&&s.includes(mg);if(t&&e.push(function(){if(!ag)return ng||(ng=function(e){let t,i=null;function r(){t=new Uint8Array(i.buffer)}function n(){throw new Error("Unexpected Draco error.")}const o={a:{a:n,d:function(e,i,r){return t.copyWithin(e,i,i+r)},c:function(e){const n=t.length,o=Math.max(e>>>0,Math.ceil(1.2*n)),a=Math.ceil((o-n)/65536);try{return i.grow(a),r(),!0}catch(e){return!1}},b:n}};return(WebAssembly.instantiateStreaming?WebAssembly.instantiateStreaming(e,o):e.then((e=>e.arrayBuffer())).then((e=>WebAssembly.instantiate(e,o)))).then((e=>{const{Rb:n,Qb:o,P:a,T:s,X:l,Ja:c,La:u,Qa:h,Va:d,Wa:p,eb:f,jb:m,f:_,e:g,yb:y,zb:x,Ab:v,Bb:b,Db:w,Gb:T}=e.instance.exports;i=g;const E=(()=>{let e=0,i=0,r=0,a=0;return s=>{r&&(n(a),n(e),i+=r,r=e=0),e||(i+=128,e=o(i));const l=s.length+7&-8;let c=e;l>=i&&(r=l,c=a=o(l));for(let e=0;e<s.length;e++)t[c+e]=s[e];return c}})();return r(),_(),{memory:g,_free:n,_malloc:o,Mesh:class Mesh{constructor(){this.ptr=a()}destroy(){s(this.ptr)}},Decoder:class Decoder{constructor(){this.ptr=c()}destroy(){m(this.ptr)}DecodeArrayToMesh(e,t,i){const r=E(e),n=u(this.ptr,r,t,i.ptr);return!!l(n)}GetAttributeByUniqueId(e,t){return{ptr:h(this.ptr,e.ptr,t)}}GetTrianglesUInt16Array(e,t,i){d(this.ptr,e.ptr,t,i)}GetTrianglesUInt32Array(e,t,i){p(this.ptr,e.ptr,t,i)}GetAttributeDataArrayForAllPoints(e,t,i,r,n){f(this.ptr,e.ptr,t.ptr,i,r,n)}},DT_INT8:y(),DT_UINT8:x(),DT_INT16:v(),DT_UINT16:b(),DT_UINT32:w(),DT_FLOAT32:T()}}))}(fetch(lg())),ng.then((e=>{ag=e,ng=void 0})))}()),o)for(let t=0;t<o.length;t++)e.push(bg(o[t],r,t,i));return(e.length?Promise.all(e):Promise.resolve()).then((()=>{if(t&&a)for(const{primitives:e}of a)for(const t of e)_g(t,r);return r}))}))}(t,0,e)))}class TriangleGridIndex{constructor(e,t,i){if(this.triangleCount=t.length/3,this.min=new g(0,0),this.max=new g(0,0),this.xScale=0,this.yScale=0,this.cellsX=0,this.cellsY=0,this.cells=[],this.payload=[],0===this.triangleCount||0===e.length||0===i)return;const r=e.map((e=>e.x)),n=e.map((e=>e.y));this.min=new g(Math.min(...r),Math.min(...n)),this.max=new g(Math.max(...r),Math.max(...n));const o=this.max.sub(this.min);o.x=Math.max(o.x,1),o.y=Math.max(o.y,1);const a=Math.max(o.x,o.y)/i;this.cellsX=Math.max(1,Math.ceil(o.x/a)),this.cellsY=Math.max(1,Math.ceil(o.y/a)),this.xScale=1/a,this.yScale=1/a;const s=[];for(let i=0;i<this.triangleCount;i++){const r=e[t[3*i+0]].sub(this.min),n=e[t[3*i+1]].sub(this.min),o=e[t[3*i+2]].sub(this.min),l=Tg(Math.floor(Math.min(r.x,n.x,o.x)),this.xScale,this.cellsX),c=Tg(Math.floor(Math.max(r.x,n.x,o.x)),this.xScale,this.cellsX),u=Tg(Math.floor(Math.min(r.y,n.y,o.y)),this.yScale,this.cellsY),h=Tg(Math.floor(Math.max(r.y,n.y,o.y)),this.yScale,this.cellsY),d=new g(0,0),p=new g(0,0),f=new g(0,0),m=new g(0,0);for(let e=u;e<=h;++e){d.y=p.y=e*a,f.y=m.y=(e+1)*a;for(let t=l;t<=c;++t)d.x=f.x=t*a,p.x=m.x=(t+1)*a,(Ku(r,n,o,d,p,m)||Ku(r,n,o,d,m,f))&&s.push({cellIdx:e*this.cellsX+t,triIdx:i})}}if(0===s.length)return;s.sort(((e,t)=>e.cellIdx-t.cellIdx||e.triIdx-t.triIdx));let l=0;for(;l<s.length;){const e=s[l].cellIdx,t={start:this.payload.length,len:0};for(;l<s.length&&s[l].cellIdx===e;)++t.len,this.payload.push(s[l++].triIdx);this.cells[e]=t}}query(e,t,i){if(0===this.triangleCount||0===this.cells.length)return;if(e.x>this.max.x||this.min.x>t.x)return;if(e.y>this.max.y||this.min.y>t.y)return;this.lookup||(this.lookup=new Uint8Array(Math.ceil(this.triangleCount/8)));for(let e=0;e<this.lookup.length;e++)this.lookup[e]=0;const r=Tg(e.x-this.min.x,this.xScale,this.cellsX),n=Tg(t.x-this.min.x,this.xScale,this.cellsX),o=Tg(e.y-this.min.y,this.yScale,this.cellsY),a=Tg(t.y-this.min.y,this.yScale,this.cellsY);for(let e=o;e<=a;e++)for(let t=r;t<=n;t++){const r=this.cells[e*this.cellsX+t];if(r)for(let e=0;e<r.len;e++){const t=this.payload[r.start+e],n=Math.floor(t/8),o=1<<t%8;if(!(this.lookup[n]&o)&&(this.lookup[n]|=o,i.push(t),i.length===this.triangleCount))return}}}}function Tg(e,t,i){return Math.max(0,Math.min(i-1,Math.floor(e*t)))}function Eg(e,t){const i=e.json.bufferViews[t.bufferView];return new(0,hg[t.componentType])(e.buffers[i.buffer],(t.byteOffset||0)+(i.byteOffset||0),t.count*pg[t.type])}function Mg(e,t,i){const r=e.indices,n=e.attributes,o={};o.indexArray=new StructArrayLayout3ui6;const a=t.json.accessors[r],s=a.count/3;o.indexArray.reserve(s);const l=Eg(t,a);for(let e=0;e<s;e++)o.indexArray.emplaceBack(l[3*e],l[3*e+1],l[3*e+2]);o.indexArray._trim(),o.vertexArray=new StructArrayLayout3f12;const c=t.json.accessors[n.POSITION];o.vertexArray.reserve(c.count);const u=Eg(t,c);for(let e=0;e<c.count;e++)o.vertexArray.emplaceBack(u[3*e],u[3*e+1],u[3*e+2]);if(o.vertexArray._trim(),o.aabb=new Aabb(c.min,c.max),o.centroid=function(e,t){const i=[0,0,0],r=e.length;if(r>0){for(let n=0;n<r;n++){const r=3*e[n];i[0]+=t[r],i[1]+=t[r+1],i[2]+=t[r+2]}i[0]/=r,i[1]/=r,i[2]/=r}return i}(l,u),void 0!==n.COLOR_0){const e=t.json.accessors[n.COLOR_0],i=pg[e.type];if(e.componentType===ug){o.colorArray=3===i?new StructArrayLayout3f12:new StructArrayLayout4f16,o.colorArray.reserve(e.count);const r=Eg(t,e);if(3===i)for(let t=0;t<e.count;t++)o.colorArray.emplaceBack(r[3*t],r[3*t+1],r[3*t+2]);else for(let t=0;t<e.count;t++)o.colorArray.emplaceBack(r[4*t],r[4*t+1],r[4*t+2],r[4*t+3]);o.colorArray._trim()}else if(e.componentType===cg&&4===i){o.colorArray=new StructArrayLayout4f16,o.colorArray.resize(e.count);const i=Eg(t,e),r=1/65535,n=o.colorArray.float32;for(let e=0;e<4*i.length;++e)n[e]=i[e]*r}else $(`glTF color buffer parsing for accessor ${JSON.stringify(e)} is not supported`)}if(void 0!==n.NORMAL){o.normalArray=new StructArrayLayout3f12;const e=t.json.accessors[n.NORMAL];o.normalArray.reserve(e.count);const i=Eg(t,e);for(let t=0;t<e.count;t++)o.normalArray.emplaceBack(i[3*t],i[3*t+1],i[3*t+2]);o.normalArray._trim()}if(void 0!==n.TEXCOORD_0&&i.length>0){o.texcoordArray=new StructArrayLayout2f8;const e=t.json.accessors[n.TEXCOORD_0];o.texcoordArray.reserve(e.count);const i=Eg(t,e);for(let t=0;t<e.count;t++)o.texcoordArray.emplaceBack(i[2*t],i[2*t+1]);o.texcoordArray._trim()}const h=e.material;return o.material=function(e,t){const{emissiveFactor:i=[0,0,0],alphaMode:r="OPAQUE",alphaCutoff:n=.5,normalTexture:o,occlusionTexture:a,emissiveTexture:s,doubleSided:l}=e,{baseColorFactor:c=[1,1,1,1],metallicFactor:u=1,roughnessFactor:h=1,baseColorTexture:d,metallicRoughnessTexture:p}=e.pbrMetallicRoughness||{};return{pbrMetallicRoughness:{baseColorFactor:new Wt(...c),metallicFactor:u,roughnessFactor:h,baseColorTexture:d?t[d.index]:void 0,metallicRoughnessTexture:p?t[p.index]:void 0},doubleSided:l,emissiveFactor:i,alphaMode:r,alphaCutoff:n,normalTexture:o?t[o.index]:void 0,occlusionTexture:a?t[a.index]:void 0,emissionTexture:s?t[s.index]:void 0,defined:void 0===e.defined}}(void 0!==h?t.json.materials[h]:{defined:!1},i),void 0!==n._FEATURE_RGBA4444&&(o.featureData=new Uint32Array(Eg(t,t.json.accessors[n._FEATURE_RGBA4444]).buffer)),o}function Sg(e,t,i){const{matrix:r,rotation:n,translation:o,scale:a,mesh:s,extras:l,children:c}=e,u={};if(u.matrix=r||ic.fromRotationTranslationScale([],n||[0,0,0,1],o||[0,0,0],a||[1,1,1]),void 0!==s){u.meshes=i[s];const e=u.anchor=[0,0];for(const t of u.meshes){const{min:i,max:r}=t.aabb;e[0]+=i[0]+r[0],e[1]+=i[1]+r[1]}e[0]=Math.floor(e[0]/u.meshes.length/2),e[1]=Math.floor(e[1]/u.meshes.length/2)}if(l&&(l.id&&(u.id=l.id),l.lights&&(u.lights=function(e){if(!e.length)return[];const t=function(e){const t=atob(e),i=new Uint8Array(t.length);for(let e=0;e<t.length;e++)i[e]=t.codePointAt(e);return i}(e),i=[],r=t.length/24,n=new Uint16Array(t.buffer),o=new Float32Array(t.buffer);for(let e=0;e<r;e++){const t=n[2*e*6]/30,r=n[2*e*6+1]/30,a=n[2*e*6+10]/100,s=o[6*e+1],l=o[6*e+2],c=o[6*e+3],u=o[6*e+4],h=c-s,d=u-l,p=Math.hypot(h,d);i.push({pos:[s+.5*h,l+.5*d,r],normal:[d/p,-h/p,0],width:p,height:t,depth:a,points:[s,l,c,u]})}return i}(l.lights))),c){const e=[];for(const r of c)e.push(Sg(t.json.nodes[r],t,i));u.children=e}return u}function Ag(e){if(0===e.vertices.length||0===e.indices.length)return null;const[t,i]=[e.vertices[0].clone(),e.vertices[0].clone()];for(let r=1;r<e.vertices.length;++r){const n=e.vertices[r];t.x=Math.min(t.x,n.x),t.y=Math.min(t.y,n.y),i.x=Math.max(i.x,n.x),i.y=Math.max(i.y,n.y)}const r=Math.ceil(Math.max(i.x-t.x,i.y-t.y)/256),n=Math.max(8,r),o=new TriangleGridIndex(e.vertices,e.indices,n);return{vertices:e.vertices,indices:e.indices,grid:o,min:t,max:i}}function Cg(e){if(!e.extras||!e.extras.ground)return null;const t=e.extras.ground;if(!t||!Array.isArray(t)||0===t.length)return null;const i=t[0];if(!i||!Array.isArray(i)||0===i.length)return null;const r=[];for(const e of i){if(!Array.isArray(e)||2!==e.length)continue;const t=e[0],i=e[1];"number"==typeof t&&"number"==typeof i&&r.push(new g(t,i))}if(r.length<3)return null;r.length>1&&r[r.length-1].equals(r[0])&&r.pop();let n=0;for(let e=0;e<r.length;e++){const t=r[e],i=r[(e+1)%r.length],o=r[(e+2)%r.length];n+=(t.x-i.x)*(o.y-i.y)-(o.x-i.x)*(t.y-i.y)}n>0&&r.reverse();const o=Xh(r.flatMap((e=>[e.x,e.y])),[]);return 0===o.length?null:{vertices:r,indices:o}}function Ig(e){const t=[],i=[];let r=0;for(const n of e){r=t.length;const e=n.vertexArray.float32,o=n.indexArray.uint16;for(let i=0;i<n.vertexArray.length;i++)t.push(new g(e[3*i+0],e[3*i+1]));for(let e=0;e<3*n.indexArray.length;e++)i.push(o[e]+r)}if(i.length%3!=0)return null;for(let e=0;e<i.length;e+=3){const r=t[i[e+0]],n=t[i[e+1]],o=t[i[e+2]];(r.x-n.x)*(o.y-n.y)-(o.x-n.x)*(r.y-n.y)>0&&([i[e+1],i[e+2]]=[i[e+2],i[e+1]])}return{vertices:t,indices:i}}function Dg(t){const i=function(t,i){const r=[],n=e.WebGL2RenderingContext;if(t.json.textures)for(const e of t.json.textures){const o={magFilter:n.LINEAR,minFilter:n.NEAREST,wrapS:n.REPEAT,wrapT:n.REPEAT};void 0!==e.sampler&&Object.assign(o,t.json.samplers[e.sampler]),r.push({image:i[e.source],sampler:o,uploaded:!1})}return r}(t,t.images),r=function(e,t){const i=[];for(const r of e.json.meshes){const n=[];for(const i of r.primitives)n.push(Mg(i,e,t));i.push(n)}return i}(t,i),{scenes:n,scene:o,nodes:a}=t.json,s=n?n[o||0].nodes:a,l=[];for(const e of s)l.push(Sg(a[e],t,r));return function(e,t,i){const r={},n=new Set;for(let o=0;o<e.length;o++){const e=i[t[o]];if(!e.extras)continue;const a=e.extras["mapbox:footprint:version"],s=e.extras["mapbox:footprint:id"];(a||s)&&n.add(o),"1.0.0"===a&&s&&(r[s]=o)}for(let o=0;o<e.length;o++){if(n.has(o))continue;const a=e[o],s=i[t[o]];if(!s.extras)continue;let l=null;a.id in r&&(l=Ig(e[r[a.id]].meshes)),l||(l=Cg(s)),l&&(a.footprint=Ag(l))}if(n.size>0){const t=Array.from(n.values()).sort(((e,t)=>e-t));for(let i=t.length-1;i>=0;i--)e.splice(t[i],1)}}(l,s,t.json.nodes),l}Fo(TriangleGridIndex,"TriangleGridIndex");const Pg={vector:VectorTileSource,raster:RasterTileSource,"raster-dem":class RasterDEMTileSource extends RasterTileSource{constructor(e,t,i,r){super(e,t,i,r),this.type="raster-dem",this.maxzoom=22,this._options=z({type:"raster-dem"},t),this.encoding=t.encoding||"mapbox"}loadTile(t,i){const r=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);t.request=Me(this.map._requestManager.transformRequest(r,_e.Tile),function(r,a,s,l){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(r)t.state="errored",i(r);else if(a){this.map._refreshExpiredTiles&&t.setExpiryData({cacheControl:s,expires:l});const i=e.ImageBitmap&&a instanceof e.ImageBitmap&&(null==Q_&&(Q_=e.OffscreenCanvas&&new e.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof e.createImageBitmap),Q_),r=1-(a.width-((c=a.width)<=1?1:Math.pow(2,Math.floor(Math.log(c)/Math.LN2))))/2;r<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const u=i?a:rt.getImageData(a,r),h={uid:t.uid,coord:t.tileID,source:this.id,scope:this.scope,rawImageData:u,encoding:this.encoding,padding:r,convertToFloat:n};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",h,o.bind(this),void 0,!0))}var c}.bind(this));const n=this.map?.painter?.terrainUseFloatDEM();function o(e,r){e&&(t.state="errored",i(e)),r&&(t.dem=r,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null))}}_getNeighboringTiles(e){const t=e.canonical,i=Math.pow(2,t.z),r=(t.x-1+i)%i,n=0===t.x?e.wrap-1:e.wrap,o=(t.x+1+i)%i,a=t.x+1===i?e.wrap+1:e.wrap,s={};return s[new OverscaledTileID(e.overscaledZ,n,t.z,r,t.y).key]={backfilled:!1},s[new OverscaledTileID(e.overscaledZ,a,t.z,o,t.y).key]={backfilled:!1},t.y>0&&(s[new OverscaledTileID(e.overscaledZ,n,t.z,r,t.y-1).key]={backfilled:!1},s[new OverscaledTileID(e.overscaledZ,e.wrap,t.z,t.x,t.y-1).key]={backfilled:!1},s[new OverscaledTileID(e.overscaledZ,a,t.z,o,t.y-1).key]={backfilled:!1}),t.y+1<i&&(s[new OverscaledTileID(e.overscaledZ,n,t.z,r,t.y+1).key]={backfilled:!1},s[new OverscaledTileID(e.overscaledZ,e.wrap,t.z,t.x,t.y+1).key]={backfilled:!1},s[new OverscaledTileID(e.overscaledZ,a,t.z,o,t.y+1).key]={backfilled:!1}),s}unloadTile(e){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.hillshadeFBO&&(e.hillshadeFBO.destroy(),delete e.hillshadeFBO),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded"}},geojson:class GeoJSONSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._loaded=!1,this.actor=i.getActor(),this.setEventedParent(r),this._data=t.data,this._options=z({},t),this._collectResourceTiming=t.collectResourceTiming,void 0!==t.maxzoom&&(this.maxzoom=t.maxzoom),t.type&&(this.type=t.type),t.attribution&&(this.attribution=t.attribution),this.promoteId=t.promoteId;const n=Ri/this.tileSize;this.workerOptions=z({source:this.id,scope:this.scope,cluster:t.cluster||!1,geojsonVtOptions:{buffer:(void 0!==t.buffer?t.buffer:128)*n,tolerance:(void 0!==t.tolerance?t.tolerance:.375)*n,extent:Ri,maxZoom:this.maxzoom,lineMetrics:t.lineMetrics||!1,generateId:t.generateId||!1},superclusterOptions:{maxZoom:void 0!==t.clusterMaxZoom?t.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,t.clusterMinPoints||2),extent:Ri,radius:(void 0!==t.clusterRadius?t.clusterRadius:50)*n,log:!1,generateId:t.generateId||!1},clusterProperties:t.clusterProperties,filter:t.filter},t.workerOptions)}onAdd(e){this.map=e,this.setData(this._data)}setData(e){return this._data=e,this._updateWorkerData(),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id,scope:this.scope},t),this}getClusterLeaves(e,t,i,r){return this.actor.send("geojson.getClusterLeaves",{source:this.id,scope:this.scope,clusterId:e,limit:t,offset:i},r),this}_updateWorkerData(){if(this._pendingLoad)return void(this._coalesce=!0);this.fire(new Event("dataloading",{dataType:"source"})),this._loaded=!1;const e=z({},this.workerOptions);e.scope=this.scope;const t=this._data;"string"==typeof t?(e.request=this.map._requestManager.transformRequest(rt.resolveURL(t),_e.Source),e.request.collectResourceTiming=this._collectResourceTiming):e.data=JSON.stringify(t),this._pendingLoad=this.actor.send(`${this.type}.loadData`,e,((e,t)=>{if(this._loaded=!0,this._pendingLoad=null,e)this.fire(new ErrorEvent(e));else{const e={dataType:"source",sourceDataType:this._metadataFired?"content":"metadata"};this._collectResourceTiming&&t&&t.resourceTiming&&t.resourceTiming[this.id]&&(e.resourceTiming=t.resourceTiming[this.id]),this.fire(new Event("data",e)),this._metadataFired=!0}this._coalesce&&(this._updateWorkerData(),this._coalesce=!1)}))}loaded(){return this._loaded}loadTile(e,t){const i=e.actor?"reloadTile":"loadTile";e.actor=this.actor;const r={type:this.type,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,scope:this.scope,pixelRatio:rt.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,brightness:this.map.style&&this.map.style.getBrightness()||0};e.request=this.actor.send(i,r,((r,n)=>(delete e.request,e.unloadVectorData(),e.aborted?t(null):r?t(r):(e.loadVectorData(n,this.map.painter,"reloadTile"===i),t(null)))),void 0,"loadTile"===i)}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0}unloadTile(e){e.unloadVectorData(),this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id,scope:this.scope})}onRemove(){this._pendingLoad&&this._pendingLoad.cancel()}serialize(){return z({},this._options,{type:this.type,data:this._data})}hasTransition(){return!1}},video:class VideoSource extends ImageSource{constructor(e,t,i,r){super(e,t,i,r),this.roundZoom=!0,this.type="video",this.options=t}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const e of t.urls)this.urls.push(this.map._requestManager.transformRequest(e,_e.Source).url);!function(t,i){const r=e.document.createElement("video");r.muted=!0,r.onloadstart=function(){i(null,r)};for(let i=0;i<t.length;i++){const n=e.document.createElement("source");be(t[i])||(r.crossOrigin="Anonymous"),n.src=t[i],r.appendChild(n)}}(this.urls,((e,t)=>{this._loaded=!0,e?this.fire(new ErrorEvent(e)):t&&(this.video=t,this.video.loop=!0,this.video.setAttribute("playsinline",""),this.video.addEventListener("playing",(()=>{this.map.triggerRepaint()})),this.map&&this.video.play(),this._finishLoading())}))}pause(){this.video&&this.video.pause()}play(){this.video&&this.video.play()}seek(e){if(this.video){const t=this.video.seekable;e<t.start(0)||e>t.end(0)?this.fire(new ErrorEvent(new ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${t.start(0)} and ${t.end(0)}-second mark.`))):this.video.currentTime=e}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)))}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const e=this.map.painter.context,t=e.gl;this.texture?this.video.paused||(this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE),t.texSubImage2D(t.TEXTURE_2D,0,0,0,t.RGBA,t.UNSIGNED_BYTE,this.video)):(this.texture=new Texture(e,this.video,t.RGBA),this.texture.bind(t.LINEAR,t.CLAMP_TO_EDGE),this.width=this.video.videoWidth,this.height=this.video.videoHeight),this._prepareData(e)}serialize(){return{type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:ImageSource,model:class ModelSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.type="model",this.models=[],this._loaded=!1,this._options=t}load(){const e=[];for(const t in this._options.models){const i=this._options.models[t],r=wg(this.map._requestManager.transformRequest(i.uri,_e.Model).url).then((e=>{if(!e)return;const r=Dg(e),n=new Model(t,i.position,i.orientation,r);n.computeBoundsAndApplyParent(),this.models.push(n)})).catch((e=>{this.fire(new ErrorEvent(new Error(`Could not load model ${t} from ${i.uri}: ${e.message}`)))}));e.push(r)}return Promise.allSettled(e).then((()=>{this._loaded=!0,this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"}))})).catch((e=>{this.fire(new ErrorEvent(new Error(`Could not load models: ${e.message}`)))}))}onAdd(e){this.map=e,this.load()}hasTransition(){return!1}loaded(){return this._loaded}getModels(){return this.models}loadTile(e,t){}serialize(){return{type:"model"}}},"batched-model":class Tiled3DModelSource extends Evented{constructor(e,t,i,r){super(),this.type="batched-model",this.id=e,this.tileSize=512,this._options=t,this.tiles=this._options.tiles,this.maxzoom=t.maxzoom||19,this.minzoom=t.minzoom||0,this.roundZoom=!0,this.usedInConflation=!0,this.dispatcher=i,this.reparseOverscaled=!1,this.scheme="xyz",this._loaded=!1,this.setEventedParent(r)}onAdd(e){this.map=e,this.load()}load(e){this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"}));const t=Array.isArray(this.map._language)?this.map._language.join():this.map._language,i=this.map._worldview;this._tileJSONRequest=K_(this._options,this.map._requestManager,t,i,((r,n)=>{this._tileJSONRequest=null,this._loaded=!0,r?(t&&console.warn(`Ensure that your requested language string is a valid BCP-47 code or list of codes. Found: ${t}`),i&&2!==i.length&&console.warn(`Requested worldview strings must be a valid ISO alpha-2 code. Found: ${i}`),this.fire(new ErrorEvent(r))):n&&(z(this,n),n.bounds&&(this.tileBounds=new TileBounds(n.bounds,this.minzoom,this.maxzoom)),Fe(n.tiles,this.map._requestManager._customAccessToken),this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))),e&&e(r)}))}hasTransition(){return!1}hasTile(e){return!this.tileBounds||this.tileBounds.contains(e.canonical)}loaded(){return this._loaded}loadTile(e,t){const i=this.map._requestManager.normalizeTileURL(e.tileID.canonical.url(this.tiles,this.scheme)),r={request:this.map._requestManager.transformRequest(i,_e.Tile),data:void 0,uid:e.uid,tileID:e.tileID,tileZoom:e.tileZoom,zoom:e.tileID.overscaledZ,tileSize:this.tileSize*e.tileID.overscaleFactor(),type:this.type,source:this.id,scope:this.scope,showCollisionBoxes:this.map.showCollisionBoxes,isSymbolTile:e.isSymbolTile,brightness:this.map.style&&this.map.style.getBrightness()||0};if(e.actor&&"expired"!==e.state)if("loading"===e.state)e.reloadCallback=t;else{if(e.buckets){const t=Object.values(e.buckets);for(const e of t)e.dirty=!0;return void(e.state="loaded")}e.request=e.actor.send("reloadTile",r,n.bind(this))}else e.actor=this.dispatcher.getActor(),e.request=e.actor.send("loadTile",r,n.bind(this),void 0,!0);function n(i,r){return e.aborted?t(null):i&&404!==i.status?t(i):(r&&(r.resourceTiming&&(e.resourceTiming=r.resourceTiming),this.map._refreshExpiredTiles&&e.setExpiryData(r),e.buckets={...e.buckets,...r.buckets}),e.state="loaded",void t(null))}}serialize(){return z({},this._options)}},canvas:class CanvasSource extends ImageSource{constructor(t,i,r,n){super(t,i,r,n),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some((e=>!Array.isArray(e)||2!==e.length||e.some((e=>"number"!=typeof e))))||this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof e.HTMLCanvasElement||this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new ErrorEvent(new ValidationError(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof e.HTMLCanvasElement?this.options.canvas:e.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint()},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1)},this._finishLoading())}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play()}onRemove(){this.pause()}prepare(){let e=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,e=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,e=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const t=this.map.painter.context;this.texture?!e&&!this._playing||this.texture instanceof UserManagedTexture||this.texture.update(this.canvas,{premultiply:!0}):this.texture=new Texture(t,this.canvas,t.gl.RGBA,{premultiply:!0}),this._prepareData(t)}serialize(){return{type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of[this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return!0;return!1}},custom:class CustomSource extends Evented{constructor(e,t,i,r){super(),this.id=e,this.type="custom",this._dataType="raster",this._dispatcher=i,this._implementation=t,this.setEventedParent(r),this.scheme="xyz",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this._loaded=!1,this.roundZoom=!0,this._implementation||this.fire(new ErrorEvent(new Error(`Missing implementation for ${this.id} custom source`))),this._implementation.loadTile||this.fire(new ErrorEvent(new Error(`Missing loadTile implementation for ${this.id} custom source`))),this._implementation.bounds&&(this.tileBounds=new TileBounds(this._implementation.bounds,this.minzoom,this.maxzoom)),t.update=this._update.bind(this),t.clearTiles=this._clearTiles.bind(this),t.coveringTiles=this._coveringTiles.bind(this),z(this,R(t,["dataType","scheme","minzoom","maxzoom","tileSize","attribution","minTileCacheSize","maxTileCacheSize"]))}serialize(){return R(this,["type","scheme","minzoom","maxzoom","tileSize","attribution"])}load(){this._loaded=!0,this.fire(new Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))}loaded(){return this._loaded}onAdd(e){this._map=e,this._loaded=!1,this.fire(new Event("dataloading",{dataType:"source"})),this._implementation.onAdd&&this._implementation.onAdd(e),this.load()}onRemove(e){this._implementation.onRemove&&this._implementation.onRemove(e)}hasTile(e){if(this._implementation.hasTile){const{x:t,y:i,z:r}=e.canonical;return this._implementation.hasTile({x:t,y:i,z:r})}return!this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const{x:r,y:n,z:o}=t.tileID.canonical,a=new e.AbortController;t.request=Promise.resolve(this._implementation.loadTile({x:r,y:n,z:o},{signal:a.signal})).then(function(r){return delete t.request,t.aborted?(t.state="unloaded",i(null)):void 0===r?(t.state="errored",i(null)):null===r?(this.loadTileData(t,{width:this.tileSize,height:this.tileSize,data:null}),t.state="loaded",i(null)):function(t){return t instanceof e.ImageData||t instanceof e.HTMLCanvasElement||t instanceof e.ImageBitmap||t instanceof e.HTMLImageElement}(r)?(this.loadTileData(t,r),t.state="loaded",void i(null)):(t.state="errored",i(new Error(`Can't infer data type for ${this.id}, only raster data supported at the moment`)))}.bind(this)).catch((e=>{20!==e.code&&(t.state="errored",i(e))})),t.request.cancel=()=>a.abort()}loadTileData(e,t){RasterTileSource.loadTileData(e,t,this._map.painter)}unloadTileData(e){RasterTileSource.unloadTileData(e,this._map.painter)}unloadTile(e,t){if(this.unloadTileData(e),this._implementation.unloadTile){const{x:t,y:i,z:r}=e.tileID.canonical;this._implementation.unloadTile({x:t,y:i,z:r})}t()}abortTile(e,t){e.request&&e.request.cancel&&(e.request.cancel(),delete e.request),t()}hasTransition(){return!1}_coveringTiles(){return this._map.transform.coveringTiles({tileSize:this.tileSize,minzoom:this.minzoom,maxzoom:this.maxzoom,roundZoom:this.roundZoom}).map((e=>({x:e.canonical.x,y:e.canonical.y,z:e.canonical.z})))}_clearTiles(){const e=sa(this.id,this.scope);this._map.style.clearSource(e)}_update(){this.fire(new Event("data",{dataType:"source",sourceDataType:"content"}))}}},Lg=function(e,t,i,r){const n=new Pg[t.type](e,t,i,r);if(n.id!==e)throw new Error(`Expected Source id to be ${e} instead of ${n.id}`);return V(["load","abort","unload","serialize","prepare"],n),n};function zg(e,t){const i=ic.identity([]);return ic.scale(i,i,[.5*e.width,.5*-e.height,1]),ic.translate(i,i,[1,-1,0]),ic.multiply(i,i,e.calculateProjMatrix(t.toUnwrapped())),Float32Array.from(i)}function Rg(e,t,i,r,n,o,a,s=!1){const l=e.tilesIn(r,a,s);l.sort(Bg);const c=[];for(const r of l)c.push({wrappedTileID:r.tile.tileID.wrapped().key,queryResults:r.tile.queryRenderedFeatures(t,i,e._state,r,n,o,zg(e.transform,r.tile.tileID),s)});const u=function(e){const t={},i={};for(const r of e){const e=r.queryResults,n=r.wrappedTileID,o=i[n]=i[n]||{};for(const i in e){const r=e[i],n=o[i]=o[i]||{},a=t[i]=t[i]||[];for(const e of r)n[e.featureIndex]||(n[e.featureIndex]=!0,a.push(e))}}return t}(c);for(const t in u)u[t].forEach((t=>{const i=t.feature,r=i.layer;r&&"background"!==r.type&&"sky"!==r.type&&"slot"!==r.type&&(i.source=r.source,r["source-layer"]&&(i.sourceLayer=r["source-layer"]),i.state=void 0!==i.id?e.getFeatureState(r["source-layer"],i.id):{})}));return u}function kg(e,t){const i=e.getRenderableIds().map((t=>e.getTileByID(t))),r=[],n={};for(let e=0;e<i.length;e++){const o=i[e],a=o.tileID.canonical.key;n[a]||(n[a]=!0,o.querySourceFeatures(r,t))}return r}function Bg(e,t){const i=e.tileID,r=t.tileID;return i.overscaledZ-r.overscaledZ||i.canonical.y-r.canonical.y||i.wrap-r.wrap||i.canonical.x-r.canonical.x}class BuildingIndex{constructor(e){this.style=e}processLayersChanged(){this.layers=[];for(const e in this.style._mergedLayers){const t=this.style._mergedLayers[e];if("fill-extrusion"===t.type)this.layers.push(t);else if("model"===t.type){const e=this.style.getLayerSource(t);e&&"batched-model"===e.type&&this.layers.push(t)}}}updateZOffset(e,t){this.currentBuildingBuckets=[];for(let e=0;e<this.layers.length;++e){const i=this.layers[e],r=this.style.getLayerSourceCache(i);let n=1;"fill-extrusion"===i.type&&(n=i.paint.get("fill-extrusion-opacity")>0?i.paint.get("fill-extrusion-vertical-scale"):0);let o=r?r.getTile(t):null;if(!o&&r&&t.canonical.z>r.getSource().minzoom){let e=t.scaledTo(Math.min(r.getSource().maxzoom,t.overscaledZ-1));for(;e.overscaledZ>=r.getSource().minzoom&&(o=r.getTile(e),!o&&0!==e.overscaledZ);)e=e.scaledTo(e.overscaledZ-1)}this.currentBuildingBuckets.push({bucket:o?o.getBucket(i):null,tileID:o?o.tileID:t,verticalScale:n})}e.hasAnyZOffset=!1;let i=!1;for(let r=0;r<e.symbolInstances.length;r++){const n=e.symbolInstances.get(r),o=n.zOffset,a=this._getHeightAtTileOffset(t,n.tileAnchorX,n.tileAnchorY);n.zOffset=-1!==a?a:o,i||o===n.zOffset||(i=!0),e.hasAnyZOffset||0===n.zOffset||(e.hasAnyZOffset=!0)}i&&(e.zOffsetBuffersNeedUpload=!0,e.zOffsetSortDirty=!0)}_mapCoordToOverlappingTile(e,t,i,r){let n=t,o=i;if(e.canonical.z!==r.canonical.z){const a=r.canonical,s=1/(1<<e.canonical.z-a.z);n=(t+e.canonical.x*Ri)*s-a.x*Ri|0,o=(i+e.canonical.y*Ri)*s-a.y*Ri|0}return{tileX:n,tileY:o}}_getHeightAtTileOffset(e,t,i){let r;for(let n=0;n<this.layers.length;++n){if("fill-extrusion"!==this.layers[n].type)continue;const{bucket:o,tileID:a,verticalScale:s}=this.currentBuildingBuckets[n];if(!o)continue;const{tileX:l,tileY:c}=this._mapCoordToOverlappingTile(e,t,i,a),u=o.getHeightAtTileCoord(l,c);if(u&&void 0!==u.height){if(!u.hidden)return u.height*s;r=u.height}}for(let n=0;n<this.layers.length;++n){if("model"!==this.layers[n].type)continue;const{bucket:o,tileID:a}=this.currentBuildingBuckets[n];if(!o)continue;const{tileX:s,tileY:l}=this._mapCoordToOverlappingTile(e,t,i,a),c=o.getHeightAtTileCoord(s,l);if(c&&!c.hidden)return void 0===c.height&&void 0!==r?Math.min(c.maxHeight,r)*c.verticalScale:(c.height||0)*c.verticalScale}return-1}}var Og=["type","source","source-layer","minzoom","maxzoom","filter","layout"];function Fg(e,t){const i={};for(const t in e)"ref"!==t&&(i[t]=e[t]);return Og.forEach((e=>{e in t&&(i[e]=t[e])})),i}function Ug(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=Fg(e[i],t[e[i].ref]));return e}const Vg={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setSlot:"setSlot",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain",setFog:"setFog",setCamera:"setCamera",setLights:"setLights",setProjection:"setProjection",addImport:"addImport",removeImport:"removeImport",setImportUrl:"setImportUrl",setImportData:"setImportData",setImportConfig:"setImportConfig"};function Ng(e,t,i){i.push({command:Vg.addSource,args:[e,t[e]]})}function jg(e,t,i){t.push({command:Vg.removeSource,args:[e]}),i[e]=!0}function Gg(e,t,i,r){jg(e,i,r),Ng(e,t,i)}function qg(e,t,i){let r;for(r in e[i])if(e[i].hasOwnProperty(r)&&"data"!==r&&!y(e[i][r],t[i][r]))return!1;for(r in t[i])if(t[i].hasOwnProperty(r)&&"data"!==r&&!y(e[i][r],t[i][r]))return!1;return!0}function Zg(e,t,i,r,n,o){let a;for(a in t=t||{},e=e||{})e.hasOwnProperty(a)&&(y(e[a],t[a])||i.push({command:o,args:[r,a,t[a],n]}));for(a in t)t.hasOwnProperty(a)&&!e.hasOwnProperty(a)&&(y(e[a],t[a])||i.push({command:o,args:[r,a,t[a],n]}))}function $g(e){return e.id}function Hg(e,t){return e[t.id]=t,e}class PathInterpolator{constructor(e,t){this.reset(e,t)}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding}lerp(e){if(1===this.points.length)return this.points[0];e=I(e,0,1);let t=1,i=this._distances[t];const r=e*this.paddedLength+this.padding;for(;i<r&&t<this._distances.length;)i=this._distances[++t];const n=t-1,o=this._distances[n],a=i-o,s=a>0?(r-o)/a:0;return this.points[n].mult(1-s).add(this.points[t].mult(s))}}class GridIndex{constructor(e,t,i){const r=this.boxCells=[],n=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)r.push([]),n.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,r,n){this._forEachCell(t,i,r,n,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(r),this.bboxes.push(n)}insertCircle(e,t,i,r){this._forEachCell(t-r,i-r,t+r,i+r,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(r)}_insertBoxCell(e,t,i,r,n,o){this.boxCells[n].push(o)}_insertCircleCell(e,t,i,r,n,o){this.circleCells[n].push(o)}_query(e,t,i,r,n,o){if(i<0||e>this.width||r<0||t>this.height)return!n&&[];const a=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=r){if(n)return!0;for(let e=0;e<this.boxKeys.length;e++)a.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],r=this.circles[3*e+2];a.push({key:this.circleKeys[e],x1:t-r,y1:i-r,x2:t+r,y2:i+r})}return o?a.filter(o):a}return this._forEachCell(e,t,i,r,this._queryCell,a,{hitTest:n,seenUids:{box:{},circle:{}}},o),n?a.length>0:a}_queryCircle(e,t,i,r,n){const o=e-i,a=e+i,s=t-i,l=t+i;if(a<0||o>this.width||l<0||s>this.height)return!r&&[];const c=[];return this._forEachCell(o,s,a,l,this._queryCellCircle,c,{hitTest:r,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},n),r?c.length>0:c}query(e,t,i,r,n){return this._query(e,t,i,r,!1,n)}hitTest(e,t,i,r,n){return this._query(e,t,i,r,!0,n)}hitTestCircle(e,t,i,r){return this._queryCircle(e,t,i,!0,r)}_queryCell(e,t,i,r,n,o,a,s){const l=a.seenUids,c=this.boxCells[n];if(null!==c){const n=this.bboxes;for(const u of c)if(!l.box[u]){l.box[u]=!0;const c=4*u;if(e<=n[c+2]&&t<=n[c+3]&&i>=n[c+0]&&r>=n[c+1]&&(!s||s(this.boxKeys[u]))){if(a.hitTest)return o.push(!0),!0;o.push({key:this.boxKeys[u],x1:n[c],y1:n[c+1],x2:n[c+2],y2:n[c+3]})}}}const u=this.circleCells[n];if(null!==u){const n=this.circles;for(const c of u)if(!l.circle[c]){l.circle[c]=!0;const u=3*c;if(this._circleAndRectCollide(n[u],n[u+1],n[u+2],e,t,i,r)&&(!s||s(this.circleKeys[c]))){if(a.hitTest)return o.push(!0),!0;{const e=n[u],t=n[u+1],i=n[u+2];o.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i})}}}}}_queryCellCircle(e,t,i,r,n,o,a,s){const l=a.circle,c=a.seenUids,u=this.boxCells[n];if(null!==u){const e=this.bboxes;for(const t of u)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!s||s(this.boxKeys[t])))return o.push(!0),!0}}const h=this.circleCells[n];if(null!==h){const e=this.circles;for(const t of h)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!s||s(this.circleKeys[t])))return o.push(!0),!0}}}_forEachCell(e,t,i,r,n,o,a,s){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),u=this._convertToXCellCoord(i),h=this._convertToYCellCoord(r);for(let d=l;d<=u;d++)for(let l=c;l<=h;l++)if(n.call(this,e,t,i,r,this.xCellCount*l+d,o,a,s))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,r,n,o){const a=r-e,s=n-t,l=i+o;return l*l>a*a+s*s}_circleAndRectCollide(e,t,i,r,n,o,a){const s=(o-r)/2,l=Math.abs(e-(r+s));if(l>s+i)return!1;const c=(a-n)/2,u=Math.abs(t-(n+c));if(u>c+i)return!1;if(l<=s||u<=c)return!0;const h=l-s,d=u-c;return h*h+d*d<=i*i}}const Wg=100;class CollisionIndex{constructor(e,t,i=new GridIndex(e.width+200,e.height+200,25),r=new GridIndex(e.width+200,e.height+200,25)){this.transform=e,this.grid=i,this.ignoredGrid=r,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+Wg,this.screenBottomBoundary=e.height+Wg,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200,this.fogState=t}placeCollisionBox(e,t,i,r,n,o,a,s){let l=i.projectedAnchorX,c=i.projectedAnchorY,u=i.projectedAnchorZ;const h=i.elevation,d=i.tileID,p=e.getProjection();if(h&&d){const[e,t,r]=p.upVector(d.canonical,i.tileAnchorX,i.tileAnchorY),n=p.upVectorScale(d.canonical,this.transform.center.lat,this.transform.worldSize).metersToTile;l+=e*h*n,c+=t*h*n,u+=r*h*n}const f=this.projectAndGetPerspectiveRatio(a,l,c,u,i.tileID,"globe"===p.name||!!h||this.transform.pitch>0,p),m=o*f.perspectiveRatio,_=(i.x1*t+r.x-i.padding)*m+f.point.x,g=(i.y1*t+r.y-i.padding)*m+f.point.y,y=(i.x2*t+r.x+i.padding)*m+f.point.x,x=(i.y2*t+r.y+i.padding)*m+f.point.y,v=f.perspectiveRatio<=.55||f.occluded;return!this.isInsideGrid(_,g,y,x)||!n&&this.grid.hitTest(_,g,y,x,s)||v?{box:[],offscreen:!1,occluded:f.occluded}:{box:[_,g,y,x],offscreen:this.isOffscreen(_,g,y,x),occluded:!1}}placeCollisionCircles(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f){const m=[],_=this.transform.elevation,y=e.getProjection(),x=_?_.getAtTileOffsetFunc(f,this.transform.center.lat,this.transform.worldSize,y):null,v=new g(i.tileAnchorX,i.tileAnchorY);let{x:b,y:w,z:T}=y.projectTilePoint(v.x,v.y,f.canonical);if(x){const[e,t,i]=x(v);b+=e,w+=t,T+=i}const E="globe"===y.name,M=this.projectAndGetPerspectiveRatio(a,b,w,T,f,E||!!_||this.transform.pitch>0,y),{perspectiveRatio:S}=M,A=(u?o/S:o*S)/24,C=em(b,w,T,s),I=M.signedDistanceFromCamera>0?nm(A,n,i.lineOffsetX*A,i.lineOffsetY*A,!1,C,v,i,r,s,{},_&&!u?x:null,u&&!!_,y,f,u):null;let D=!1,P=!1,L=!0;if(I&&!M.occluded){const e=.5*d*S+p,i=new g(-100,-100),r=new g(this.screenRightBoundary,this.screenBottomBoundary),n=new PathInterpolator,{first:o,last:a}=I,s=o.path.length;let u=[];for(let e=s-1;e>=1;e--)u.push(o.path[e]);for(let e=1;e<a.path.length;e++)u.push(a.path[e]);const f=2.5*e;l&&(u=u.map((([e,t,i],r)=>(x&&!E&&(i=x(r<s-1?o.tilePath[s-1-r]:a.tilePath[r-s+2])[2]),em(e,t,i,l)))),u.some((e=>e[3]<=0))&&(u=[]));let _=[];if(u.length>0){let e=1/0,t=-1/0,n=1/0,o=-1/0;for(const i of u)e=Math.min(e,i[0]),n=Math.min(n,i[1]),t=Math.max(t,i[0]),o=Math.max(o,i[1]);t>=i.x&&e<=r.x&&o>=i.y&&n<=r.y&&(_=[u.map((e=>new g(e[0],e[1])))],(e<i.x||t>r.x||n<i.y||o>r.y)&&(_=function(e,t,i,r,n){const o=[];for(let a=0;a<e.length;a++){const s=e[a];let l;for(let e=0;e<s.length-1;e++){let a=s[e],c=s[e+1];a.x<t&&c.x<t||(a.x<t?a=new g(t,a.y+(t-a.x)/(c.x-a.x)*(c.y-a.y))._round():c.x<t&&(c=new g(t,a.y+(t-a.x)/(c.x-a.x)*(c.y-a.y))._round()),a.y<i&&c.y<i||(a.y<i?a=new g(a.x+(i-a.y)/(c.y-a.y)*(c.x-a.x),i)._round():c.y<i&&(c=new g(a.x+(i-a.y)/(c.y-a.y)*(c.x-a.x),i)._round()),a.x>=r&&c.x>=r||(a.x>=r?a=new g(r,a.y+(r-a.x)/(c.x-a.x)*(c.y-a.y))._round():c.x>=r&&(c=new g(r,a.y+(r-a.x)/(c.x-a.x)*(c.y-a.y))._round()),a.y>=n&&c.y>=n||(a.y>=n?a=new g(a.x+(n-a.y)/(c.y-a.y)*(c.x-a.x),n)._round():c.y>=n&&(c=new g(a.x+(n-a.y)/(c.y-a.y)*(c.x-a.x),n)._round()),l&&a.equals(l[l.length-1])||(l=[a],o.push(l)),l.push(c)))))}}return o}(_,i.x,i.y,r.x,r.y)))}for(const i of _){n.reset(i,.25*e);let r=0;r=n.length<=.5*e?1:Math.ceil(n.paddedLength/f)+1;for(let i=0;i<r;i++){const o=i/Math.max(r-1,1),a=n.lerp(o),s=a.x+Wg,l=a.y+Wg;m.push(s,l,e,0);const u=s-e,d=l-e,p=s+e,f=l+e;if(L=L&&this.isOffscreen(u,d,p,f),P=P||this.isInsideGrid(u,d,p,f),!t&&this.grid.hitTestCircle(s,l,e,h)&&(D=!0,!c))return{circles:[],offscreen:!1,collisionDetected:D,occluded:!1}}}}return{circles:!c&&D||!P?[]:m,offscreen:L,collisionDetected:D,occluded:M.occluded}}queryRenderedSymbols(e){if(0===e.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return{};const t=[];let i=1/0,r=1/0,n=-1/0,o=-1/0;for(const a of e){const e=new g(a.x+Wg,a.y+Wg);i=Math.min(i,e.x),r=Math.min(r,e.y),n=Math.max(n,e.x),o=Math.max(o,e.y),t.push(e)}const a=this.grid.query(i,r,n,o).concat(this.ignoredGrid.query(i,r,n,o)),s={},l={};for(const e of a){const i=e.key;void 0===s[i.bucketInstanceId]&&(s[i.bucketInstanceId]={}),s[i.bucketInstanceId][i.featureIndex]||Fu(t,[new g(e.x1,e.y1),new g(e.x2,e.y1),new g(e.x2,e.y2),new g(e.x1,e.y2)])&&(s[i.bucketInstanceId][i.featureIndex]=!0,void 0===l[i.bucketInstanceId]&&(l[i.bucketInstanceId]=[]),l[i.bucketInstanceId].push(i.featureIndex))}return l}insertCollisionBox(e,t,i,r,n){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:r,collisionGroupID:n},e[0],e[1],e[2],e[3])}insertCollisionCircles(e,t,i,r,n){const o=t?this.ignoredGrid:this.grid,a={bucketInstanceId:i,featureIndex:r,collisionGroupID:n};for(let t=0;t<e.length;t+=4)o.insertCircle(a,e[t],e[t+1],e[t+2])}projectAndGetPerspectiveRatio(e,t,i,r,n,o,a){const s=[t,i,r,1];let l=!1;if(r||this.transform.pitch>0){if(Wl.transformMat4(s,s,e),this.fogState&&n&&"globe"!==a.name){const e=function(e,t,i,r,n,o){const a=o.calculateFogTileMatrix(n),s=[t,i,r];return lc.transformMat4(s,s,a),N_(e,lc.length(s),o.pitch,o._fov)}(this.fogState,t,i,r,n.toUnwrapped(),this.transform);l=e>.9}}else hm(s,s,e);const c=s[3];return{point:new g((s[0]/c+1)/2*this.transform.width+Wg,(-s[1]/c+1)/2*this.transform.height+Wg),perspectiveRatio:Math.min(.5+this.transform.getCameraToCenterDistance(a)/c*.5,1.5),signedDistanceFromCamera:c,occluded:o&&s[2]>c||l}}isOffscreen(e,t,i,r){return i<Wg||e>=this.screenRightBoundary||r<Wg||t>this.screenBottomBoundary}isInsideGrid(e,t,i,r){return i>=0&&e<this.gridRightBoundary&&r>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const e=ic.identity([]);return ic.translate(e,e,[-100,-100,0]),e}}function Xg(e,t,i){const r=t.createTileMatrix(e,e.worldSize,i.toUnwrapped());return ic.multiply(new Float32Array(16),e.projMatrix,r)}function Yg(e,t,i){if(t.projection.name===i.projection.name)return e.projMatrix;const r=i.clone();return r.setProjection(t.projection),Xg(r,t.getProjection(),e)}function Kg(e,t,i){return t.name===i.projection.name?e.projMatrix:Xg(i,t,e)}class OpacityState{constructor(e,t,i,r){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):r&&i?1:0,this.placed=i}isHidden(){return 0===this.opacity&&!this.placed}}class JointOpacityState{constructor(e,t,i,r,n,o=!1){this.text=new OpacityState(e?e.text:null,t,i,n),this.icon=new OpacityState(e?e.icon:null,t,r,n),this.clipped=o}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class JointPlacement{constructor(e,t,i,r=!1){this.text=e,this.icon=t,this.skipFade=i,this.clipped=r}}class CollisionCircleArray{constructor(){this.invProjMatrix=ic.create(),this.viewportMatrix=ic.create(),this.circles=[]}}class RetainedQueryData{constructor(e,t,i,r,n){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=r,this.tileID=n}}class CollisionGroups{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={}}get(e){if(this.crossSourceCollisions)return{ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t}}return this.collisionGroups[e]}}function Jg(e,t,i,r,n){const{horizontalAlign:o,verticalAlign:a}=Mp(e),s=-(o-.5)*t,l=-(a-.5)*i,c=Lp(e,r);return new g(s+c[0]*n,l+c[1]*n)}function Qg(e,t,i,r,n){const o=new g(e,t);return i&&o._rotate(r?n:-n),o}class Placement{constructor(e,t,i,r,n,o){this.transform=e.clone(),this.projection=e.projection.name,this.collisionIndex=new CollisionIndex(this.transform,n),this.buildingIndex=o,this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new CollisionGroups(i),this.collisionCircleArrays={},this.prevPlacement=r,r&&(r.prevPlacement=void 0),this.placedOrientations={}}getBucketParts(e,t,i,r){const n=i.getBucket(t),o=i.latestFeatureIndex;if(!n||!o||t.fqid!==n.layerIds[0])return;const a=n.layers[0].layout,s=i.collisionBoxArray,l=Math.pow(2,this.transform.zoom-i.tileID.overscaledZ),c=i.tileSize/Ri,u=i.tileID.toUnwrapped();this.transform.setProjection(n.projection);const h=(d=i.tileID,p=n.getProjection(),f=this.transform,p.name===this.projection?f.calculateProjMatrix(d.toUnwrapped()):Xg(f,p,d));var d,p,f;const m="map"===a.get("text-pitch-alignment"),_="map"===a.get("text-rotation-alignment");t.compileFilter();const g=t.dynamicFilter(),y=t.dynamicFilterNeedsFeature(),x=this.transform.calculatePixelsToTileUnitsMatrix(i),v=Jf(h,i.tileID.canonical,m,_,this.transform,n.getProjection(),x);let b=null;if(m){const e=Qf(h,i.tileID.canonical,m,_,this.transform,n.getProjection(),x);b=ic.multiply([],this.transform.labelPlaneMatrix,e)}let w=null;g&&i.latestFeatureIndex&&(w={unwrappedTileID:u,dynamicFilter:g,dynamicFilterNeedsFeature:y,featureIndex:i.latestFeatureIndex}),this.retainedQueryData[n.bucketInstanceId]=new RetainedQueryData(n.bucketInstanceId,o,n.sourceLayerIndex,n.index,i.tileID);const T={bucket:n,layout:a,posMatrix:h,textLabelPlaneMatrix:v,labelToScreenMatrix:b,clippingData:w,scale:l,textPixelRatio:c,holdingForFade:i.holdingForFade(),collisionBoxArray:s,partiallyEvaluatedTextSize:mp(n.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:mp(n.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(n.sourceID)};if(r)for(const t of n.sortKeyRanges){const{sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n}=t;e.push({sortKey:i,symbolInstanceStart:r,symbolInstanceEnd:n,parameters:T})}else e.push({symbolInstanceStart:0,symbolInstanceEnd:n.symbolInstances.length,parameters:T})}attemptAnchorPlacement(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g){const{textOffset0:y,textOffset1:x,crossTileID:v}=h,b=[y,x],w=Jg(e,i,r,b,n),T=this.collisionIndex.placeCollisionBox(p,n,t,Qg(w.x,w.y,o,a,this.transform.angle),u,s,l,c.predicate);if(m){const e=p.getSymbolInstanceIconSize(g,this.transform.zoom,h.placedIconSymbolIndex);if(0===this.collisionIndex.placeCollisionBox(p,e,m,Qg(w.x,w.y,o,a,this.transform.angle),u,s,l,c.predicate).box.length)return}if(T.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[v]&&this.prevPlacement.placements[v]&&this.prevPlacement.placements[v].text&&(t=this.prevPlacement.variableOffsets[v].anchor),this.variableOffsets[v]={textOffset:b,width:i,height:r,anchor:e,textScale:n,prevAnchor:t},this.markUsedJustification(p,e,h,f),p.allowVerticalPlacement&&(this.markUsedOrientation(p,f,h),this.placedOrientations[v]=f),{shift:w,placedGlyphBoxes:T}}}placeLayerBucketPart(e,t,i,r){const{bucket:n,layout:o,posMatrix:a,textLabelPlaneMatrix:s,labelToScreenMatrix:l,clippingData:c,textPixelRatio:u,holdingForFade:h,collisionBoxArray:d,partiallyEvaluatedTextSize:p,partiallyEvaluatedIconSize:f,collisionGroup:m}=e.parameters,_=o.get("text-optional"),y=o.get("icon-optional"),x=o.get("text-allow-overlap"),v=o.get("icon-allow-overlap"),b="map"===o.get("text-rotation-alignment"),w="map"===o.get("text-pitch-alignment"),T="viewport-y"===o.get("symbol-z-order"),E=o.get("symbol-z-elevate");this.transform.setProjection(n.projection);let M=x&&(v||!n.hasIconData()||y),S=v&&(x||!n.hasTextData()||_);!n.collisionArrays&&d&&n.deserializeCollisionBoxes(d),i&&r&&n.updateCollisionDebugBuffers(this.transform.zoom,d);const A=(e,r,d)=>{const{crossTileID:T,numVerticalGlyphVertices:E}=e;if(c){const i={zoom:this.transform.zoom,pitch:this.transform.pitch};let r=null;if(c.dynamicFilterNeedsFeature){const t=this.retainedQueryData[n.bucketInstanceId];r=c.featureIndex.loadFeature({featureIndex:e.featureIndex,bucketIndex:t.bucketIndex,sourceLayerIndex:t.sourceLayerIndex,layoutVertexArrayOffset:0})}if(!(0,c.dynamicFilter)(i,r,this.retainedQueryData[n.bucketInstanceId].tileID.canonical,new g(e.tileAnchorX,e.tileAnchorY),this.transform.calculateDistanceTileData(c.unwrappedTileID)))return this.placements[T]=new JointPlacement(!1,!1,!1,!0),void t.add(T)}if(t.has(T))return;if(h)return void(this.placements[T]=new JointPlacement(!1,!1,!1));let A=!1,C=!1,I=!0,D=!1,P=!1,L=null,z={box:null,offscreen:null,occluded:null},R={box:null,offscreen:null,occluded:null},k=null,B=null,O=null,F=0,U=0,V=0;d.textFeatureIndex?F=d.textFeatureIndex:e.useRuntimeCollisionCircles&&(F=e.featureIndex),d.verticalTextFeatureIndex&&(U=d.verticalTextFeatureIndex);const N=t=>{t.tileID=this.retainedQueryData[n.bucketInstanceId].tileID;const i=this.transform.elevation;t.elevation=e.zOffset+(i?i.getAtTileOffset(t.tileID,t.tileAnchorX,t.tileAnchorY):0)},j=d.textBox;if(j){N(j);const t=t=>{let i=Ep.horizontal;if(n.allowVerticalPlacement&&!t&&this.prevPlacement){const t=this.prevPlacement.placedOrientations[T];t&&(this.placedOrientations[T]=t,i=t,this.markUsedOrientation(n,i,e))}return i},i=(e,t)=>{if(n.allowVerticalPlacement&&E>0&&d.verticalTextBox){for(const i of n.writingModes)if(i===Ep.vertical?(z=t(),R=z):z=e(),z&&z.box&&z.box.length)break}else z=e()};if(o.get("text-variable-anchor")){let s=o.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[T]){const e=this.prevPlacement.variableOffsets[T];s.indexOf(e.anchor)>0&&(s=s.filter((t=>t!==e.anchor)),s.unshift(e.anchor))}const l=(t,i,o)=>{const l=n.getSymbolInstanceTextSize(p,e,this.transform.zoom,r),c=(t.x2-t.x1)*l+2*t.padding,h=(t.y2-t.y1)*l+2*t.padding,d=e.hasIconTextFit&&!v?i:null;d&&N(d);let _={box:[],offscreen:!1,occluded:!1};const g=x?2*s.length:s.length;for(let i=0;i<g;++i){const g=this.attemptAnchorPlacement(s[i%s.length],t,c,h,l,b,w,u,a,m,i>=s.length,e,r,n,o,d,p,f);if(g&&(_=g.placedGlyphBoxes,_&&_.box&&_.box.length)){A=!0,L=g.shift;break}}return _};i((()=>l(j,d.iconBox,Ep.horizontal)),(()=>{const e=d.verticalTextBox;return e&&N(e),n.allowVerticalPlacement&&!(z&&z.box&&z.box.length)&&E>0&&e?l(e,d.verticalIconBox,Ep.vertical):{box:null,offscreen:null,occluded:null}})),z&&(A=z.box,I=z.offscreen,D=z.occluded);const c=t(!(!z||!z.box));if(!A&&this.prevPlacement){const t=this.prevPlacement.variableOffsets[T];t&&(this.variableOffsets[T]=t,this.markUsedJustification(n,t.anchor,e,c))}}else{const o=(t,i)=>{const o=n.getSymbolInstanceTextSize(p,e,this.transform.zoom,r),s=this.collisionIndex.placeCollisionBox(n,o,t,new g(0,0),x,u,a,m.predicate);return s&&s.box&&s.box.length&&(this.markUsedOrientation(n,i,e),this.placedOrientations[T]=i),s};i((()=>o(j,Ep.horizontal)),(()=>{const e=d.verticalTextBox;return n.allowVerticalPlacement&&E>0&&e?(N(e),o(e,Ep.vertical)):{box:null,offscreen:null,occluded:null}})),t(!!(z&&z.box&&z.box.length))}}if(k=z,A=k&&k.box&&k.box.length>0,I=k&&k.offscreen,D=k&&k.occluded,e.useRuntimeCollisionCircles){const t=n.text.placedSymbolArray.get(e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex),r=fp(n.textSizeData,p,t),c=o.get("text-padding");B=this.collisionIndex.placeCollisionCircles(n,x,t,n.lineVertexArray,n.glyphOffsetArray,r,a,s,l,i,w,m.predicate,e.collisionCircleDiameter*r/24,c,this.retainedQueryData[n.bucketInstanceId].tileID),A=x||B.circles.length>0&&!B.collisionDetected,I=I&&B.offscreen,D=B.occluded}if(d.iconFeatureIndex&&(V=d.iconFeatureIndex),d.iconBox){const t=t=>{N(t);const i=e.hasIconTextFit&&L?Qg(L.x,L.y,b,w,this.transform.angle):new g(0,0),r=n.getSymbolInstanceIconSize(f,this.transform.zoom,e.placedIconSymbolIndex);return this.collisionIndex.placeCollisionBox(n,r,t,i,v,u,a,m.predicate)};R&&R.box&&R.box.length&&d.verticalIconBox?(O=t(d.verticalIconBox),C=O.box.length>0):(O=t(d.iconBox),C=O.box.length>0),I=I&&O.offscreen,P=O.occluded}const G=_||0===e.numHorizontalGlyphVertices&&0===E,q=y||0===e.numIconVertices;if(G||q?q?G||(C=C&&A):A=C&&A:C=A=C&&A,A&&k&&k.box&&this.collisionIndex.insertCollisionBox(k.box,o.get("text-ignore-placement"),n.bucketInstanceId,R&&R.box&&U?U:F,m.ID),C&&O&&this.collisionIndex.insertCollisionBox(O.box,o.get("icon-ignore-placement"),n.bucketInstanceId,V,m.ID),B&&(A&&this.collisionIndex.insertCollisionCircles(B.circles,o.get("text-ignore-placement"),n.bucketInstanceId,F,m.ID),i)){const e=n.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new CollisionCircleArray);for(let e=0;e<B.circles.length;e+=4)t.circles.push(B.circles[e+0]),t.circles.push(B.circles[e+1]),t.circles.push(B.circles[e+2]),t.circles.push(B.collisionDetected?1:0)}const Z="globe"!==n.projection.name;M=M&&(Z||!D),S=S&&(Z||!P),this.placements[T]=new JointPlacement(A||M,C||S,I||n.justReloaded),t.add(T)};if(E&&this.buildingIndex&&(this.buildingIndex.updateZOffset(n,this.retainedQueryData[n.bucketInstanceId].tileID),n.updateZOffset()),T){const e=n.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];A(n.symbolInstances.get(i),i,n.collisionArrays[i])}n.hasAnyZOffset&&$(`${n.layerIds[0]} layer symbol-z-elevate: symbols are not sorted by elevation if symbol-z-order is evaluated to viewport-y`)}else if(n.hasAnyZOffset){const e=n.getSortedIndexesByZOffset();for(let t=0;t<e.length;++t){const i=e[t];A(n.symbolInstances.get(i),i,n.collisionArrays[i])}}else for(let t=e.symbolInstanceStart;t<e.symbolInstanceEnd;t++)A(n.symbolInstances.get(t),t,n.collisionArrays[t]);if(i&&n.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[n.bucketInstanceId];ic.invert(e.invProjMatrix,a),e.viewportMatrix=this.collisionIndex.getViewportMatrix()}n.justReloaded=!1}markUsedJustification(e,t,i,r){const{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:o,rightJustifiedTextSymbolIndex:a,verticalPlacedTextSymbolIndex:s,crossTileID:l}=i,c=function(e){switch(e){case"right":case"top-right":case"bottom-right":return"right";case"left":case"top-left":case"bottom-left":return"left"}return"center"}(t),u=r===Ep.vertical?s:"left"===c?n:"center"===c?o:"right"===c?a:-1;n>=0&&(e.text.placedSymbolArray.get(n).crossTileID=u>=0&&n!==u?0:l),o>=0&&(e.text.placedSymbolArray.get(o).crossTileID=u>=0&&o!==u?0:l),a>=0&&(e.text.placedSymbolArray.get(a).crossTileID=u>=0&&a!==u?0:l),s>=0&&(e.text.placedSymbolArray.get(s).crossTileID=u>=0&&s!==u?0:l)}markUsedOrientation(e,t,i){const r=t===Ep.horizontal||t===Ep.horizontalOnly?t:0,n=t===Ep.vertical?t:0,{leftJustifiedTextSymbolIndex:o,centerJustifiedTextSymbolIndex:a,rightJustifiedTextSymbolIndex:s,verticalPlacedTextSymbolIndex:l}=i,c=e.text.placedSymbolArray;o>=0&&(c.get(o).placedOrientation=r),a>=0&&(c.get(a).placedOrientation=r),s>=0&&(c.get(s).placedOrientation=r),l>=0&&(c.get(l).placedOrientation=n)}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const r=t?t.symbolFadeChange(e):1,n=t?t.opacities:{},o=t?t.variableOffsets:{},a=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],o=n[e];o?(this.opacities[e]=new JointOpacityState(o,r,t.text,t.icon,null,t.clipped),i=i||t.text!==o.text.placed||t.icon!==o.icon.placed):(this.opacities[e]=new JointOpacityState(null,r,t.text,t.icon,t.skipFade,t.clipped),i=i||t.text||t.icon)}for(const e in n){const t=n[e];if(!this.opacities[e]){const n=new JointOpacityState(t,r,!1,!1);n.isHidden()||(this.opacities[e]=n,i=i||t.text.placed||t.icon.placed)}}for(const e in o)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=o[e]);for(const e in a)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=a[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e)}updateLayerOpacities(e,t){const i=new Set;for(const r of t){const t=r.getBucket(e);t&&r.latestFeatureIndex&&e.fqid===t.layerIds[0]&&(this.updateBucketOpacities(t,i,r.collisionBoxArray),t.layers[0].layout.get("symbol-z-elevate")&&this.buildingIndex&&(this.buildingIndex.updateZOffset(t,r.tileID),t.updateZOffset()))}}updateBucketOpacities(e,t,i){e.hasTextData()&&e.text.opacityVertexArray.clear(),e.hasIconData()&&e.icon.opacityVertexArray.clear(),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexArray.clear(),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexArray.clear();const r=e.layers[0].layout,n=!!e.layers[0].dynamicFilter(),o=new JointOpacityState(null,0,!1,!1,!0),a=r.get("text-allow-overlap"),s=r.get("icon-allow-overlap"),l=r.get("text-variable-anchor"),c="map"===r.get("text-rotation-alignment"),u="map"===r.get("text-pitch-alignment"),h=new JointOpacityState(null,0,a&&(s||!e.hasIconData()||r.get("icon-optional")),s&&(a||!e.hasTextData()||r.get("text-optional")),!0);!e.collisionArrays&&i&&(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData())&&e.deserializeCollisionBoxes(i);const d=(e,t,i)=>{for(let r=0;r<t/4;r++)e.opacityVertexArray.emplaceBack(i)};let p=0;for(let i=0;i<e.symbolInstances.length;i++){const r=e.symbolInstances.get(i),{numHorizontalGlyphVertices:a,numVerticalGlyphVertices:s,crossTileID:f,numIconVertices:m}=r,_=t.has(f);let y=this.opacities[f];_?y=o:y||(y=h,this.opacities[f]=y),t.add(f);const x=a>0||s>0,v=m>0,b=this.placedOrientations[f],w=b===Ep.vertical,T=b===Ep.horizontal||b===Ep.horizontalOnly;if(!x&&!v||y.isHidden()||p++,x){const t=ly(y.text);d(e.text,a,w?cy:t),d(e.text,s,T?cy:t);const i=y.text.isHidden(),{leftJustifiedTextSymbolIndex:n,centerJustifiedTextSymbolIndex:o,rightJustifiedTextSymbolIndex:l,verticalPlacedTextSymbolIndex:c}=r,u=e.text.placedSymbolArray,h=i||w?1:0;n>=0&&(u.get(n).hidden=h),o>=0&&(u.get(o).hidden=h),l>=0&&(u.get(l).hidden=h),c>=0&&(u.get(c).hidden=i||T?1:0);const p=this.variableOffsets[f];p&&this.markUsedJustification(e,p.anchor,r,b);const m=this.placedOrientations[f];m&&(this.markUsedJustification(e,"left",r,m),this.markUsedOrientation(e,m,r))}if(v){const t=ly(y.icon),{placedIconSymbolIndex:i,verticalPlacedIconSymbolIndex:n}=r,o=e.icon.placedSymbolArray,a=y.icon.isHidden()?1:0;i>=0&&(d(e.icon,m,w?cy:t),o.get(i).hidden=a),n>=0&&(d(e.icon,r.numVerticalIconVertices,T?cy:t),o.get(n).hidden=a)}if(e.hasIconCollisionBoxData()||e.hasTextCollisionBoxData()){const t=e.collisionArrays[i];if(t){let i=new g(0,0),o=!0;if(t.textBox||t.verticalTextBox){if(l){const e=this.variableOffsets[f];e?(i=Jg(e.anchor,e.width,e.height,e.textOffset,e.textScale),c&&i._rotate(u?this.transform.angle:-this.transform.angle)):o=!1}n&&(o=!y.clipped),t.textBox&&ey(e.textCollisionBox.collisionVertexArray,y.text.placed,!o||w,i.x,i.y),t.verticalTextBox&&ey(e.textCollisionBox.collisionVertexArray,y.text.placed,!o||T,i.x,i.y)}const a=o&&Boolean(!T&&t.verticalIconBox);t.iconBox&&ey(e.iconCollisionBox.collisionVertexArray,y.icon.placed,a,r.hasIconTextFit?i.x:0,r.hasIconTextFit?i.y:0),t.verticalIconBox&&ey(e.iconCollisionBox.collisionVertexArray,y.icon.placed,!a,r.hasIconTextFit?i.x:0,r.hasIconTextFit?i.y:0)}}}if(e.fullyClipped=0===p,e.sortFeatures(this.transform.angle),this.retainedQueryData[e.bucketInstanceId]&&(this.retainedQueryData[e.bucketInstanceId].featureSortOrder=e.featureSortOrder),e.hasTextData()&&e.text.opacityVertexBuffer&&e.text.opacityVertexBuffer.updateData(e.text.opacityVertexArray),e.hasIconData()&&e.icon.opacityVertexBuffer&&e.icon.opacityVertexBuffer.updateData(e.icon.opacityVertexArray),e.hasIconCollisionBoxData()&&e.iconCollisionBox.collisionVertexBuffer&&e.iconCollisionBox.collisionVertexBuffer.updateData(e.iconCollisionBox.collisionVertexArray),e.hasTextCollisionBoxData()&&e.textCollisionBox.collisionVertexBuffer&&e.textCollisionBox.collisionVertexBuffer.updateData(e.textCollisionBox.collisionVertexArray),e.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[e.bucketInstanceId];e.placementInvProjMatrix=t.invProjMatrix,e.placementViewportMatrix=t.viewportMatrix,e.collisionCircleArray=t.circles,delete this.collisionCircleArrays[e.bucketInstanceId]}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0}}function ey(e,t,i,r,n){e.emplaceBack(t?1:0,i?1:0,r||0,n||0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0),e.emplaceBack(t?1:0,i?1:0,r||0,n||0)}const ty=Math.pow(2,25),iy=Math.pow(2,24),ry=Math.pow(2,17),ny=Math.pow(2,16),oy=Math.pow(2,9),ay=Math.pow(2,8),sy=Math.pow(2,1);function ly(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*ty+t*iy+i*ry+t*ny+i*oy+t*ay+i*sy+t}const cy=0;class LayerPlacement{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs=new Set,this._bucketParts=[]}continuePlacement(e,t,i,r,n){const o=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(o,r,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,n())return!0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,o.sort(((e,t)=>e.sortKey-t.sortKey)));this._currentPartIndex<o.length;){const e=o[this._currentPartIndex];if(t.placeLayerBucketPart(e,this._seenCrossTileIDs,i,0===e.symbolInstanceStart),this._currentPartIndex++,n())return!0}return!1}}class PauseablePlacement{constructor(e,t,i,r,n,o,a,s,l){this.placement=new Placement(e,n,o,a,s,l),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=r,this._done=!1}isDone(){return this._done}continuePlacement(e,t,i,r){const n=rt.now(),o=()=>{const e=rt.now()-n;return!this._forceFullPlacement&&e>2};for(;this._currentPlacementIndex>=0;){const n=t[e[this._currentPlacementIndex]],a=this.placement.collisionIndex.transform.zoom;if("symbol"===n.type&&(!n.minzoom||n.minzoom<=a)&&(!n.maxzoom||n.maxzoom>a)){const e=n,t=e.layout.get("symbol-z-elevate"),a=this._inProgressLayer=this._inProgressLayer||new LayerPlacement(e),s=sa(n.source,n.scope);if(a.continuePlacement(t?r[s]:i[s],this.placement,this._showCollisionBoxes,n,o))return;delete this._inProgressLayer}this._currentPlacementIndex--}this._done=!0}commit(e){return this.placement.commit(e),this.placement}}const uy=[Int8Array,Uint8Array,Uint8ClampedArray,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];class KDBush{static from(e){if(!(e instanceof ArrayBuffer))throw new Error("Data must be an instance of ArrayBuffer.");const[t,i]=new Uint8Array(e,0,2);if(219!==t)throw new Error("Data does not appear to be in a KDBush format.");const r=i>>4;if(1!==r)throw new Error(`Got v${r} data when expected v1.`);const n=uy[15&i];if(!n)throw new Error("Unrecognized array type.");const[o]=new Uint16Array(e,2,1),[a]=new Uint32Array(e,4,1);return new KDBush(a,o,n,e)}constructor(e,t=64,i=Float64Array,r){if(isNaN(e)||e<0)throw new Error(`Unpexpected numItems value: ${e}.`);this.numItems=+e,this.nodeSize=Math.min(Math.max(+t,2),65535),this.ArrayType=i,this.IndexArrayType=e<65536?Uint16Array:Uint32Array;const n=uy.indexOf(this.ArrayType),o=2*e*this.ArrayType.BYTES_PER_ELEMENT,a=e*this.IndexArrayType.BYTES_PER_ELEMENT,s=(8-a%8)%8;if(n<0)throw new Error(`Unexpected typed array class: ${i}.`);r&&r instanceof ArrayBuffer?(this.data=r,this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+a+s,2*e),this._pos=2*e,this._finished=!0):(this.data=new ArrayBuffer(8+o+a+s),this.ids=new this.IndexArrayType(this.data,8,e),this.coords=new this.ArrayType(this.data,8+a+s,2*e),this._pos=0,this._finished=!1,new Uint8Array(this.data,0,2).set([219,16+n]),new Uint16Array(this.data,2,1)[0]=t,new Uint32Array(this.data,4,1)[0]=e)}add(e,t){const i=this._pos>>1;return this.ids[i]=i,this.coords[this._pos++]=e,this.coords[this._pos++]=t,i}finish(){const e=this._pos>>1;if(e!==this.numItems)throw new Error(`Added ${e} items when expected ${this.numItems}.`);return hy(this.ids,this.coords,this.nodeSize,0,this.numItems-1,0),this._finished=!0,this}range(e,t,i,r){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:n,coords:o,nodeSize:a}=this,s=[0,n.length-1,0],l=[];for(;s.length;){const c=s.pop()||0,u=s.pop()||0,h=s.pop()||0;if(u-h<=a){for(let a=h;a<=u;a++){const s=o[2*a],c=o[2*a+1];s>=e&&s<=i&&c>=t&&c<=r&&l.push(n[a])}continue}const d=h+u>>1,p=o[2*d],f=o[2*d+1];p>=e&&p<=i&&f>=t&&f<=r&&l.push(n[d]),(0===c?e<=p:t<=f)&&(s.push(h),s.push(d-1),s.push(1-c)),(0===c?i>=p:r>=f)&&(s.push(d+1),s.push(u),s.push(1-c))}return l}within(e,t,i){if(!this._finished)throw new Error("Data not yet indexed - call index.finish().");const{ids:r,coords:n,nodeSize:o}=this,a=[0,r.length-1,0],s=[],l=i*i;for(;a.length;){const c=a.pop()||0,u=a.pop()||0,h=a.pop()||0;if(u-h<=o){for(let i=h;i<=u;i++)my(n[2*i],n[2*i+1],e,t)<=l&&s.push(r[i]);continue}const d=h+u>>1,p=n[2*d],f=n[2*d+1];my(p,f,e,t)<=l&&s.push(r[d]),(0===c?e-i<=p:t-i<=f)&&(a.push(h),a.push(d-1),a.push(1-c)),(0===c?e+i>=p:t+i>=f)&&(a.push(d+1),a.push(u),a.push(1-c))}return s}}function hy(e,t,i,r,n,o){if(n-r<=i)return;const a=r+n>>1;dy(e,t,a,r,n,o),hy(e,t,i,r,a-1,1-o),hy(e,t,i,a+1,n,1-o)}function dy(e,t,i,r,n,o){for(;n>r;){if(n-r>600){const a=n-r+1,s=i-r+1,l=Math.log(a),c=.5*Math.exp(2*l/3),u=.5*Math.sqrt(l*c*(a-c)/a)*(s-a/2<0?-1:1);dy(e,t,i,Math.max(r,Math.floor(i-s*c/a+u)),Math.min(n,Math.floor(i+(a-s)*c/a+u)),o)}const a=t[2*i+o];let s=r,l=n;for(py(e,t,r,i),t[2*n+o]>a&&py(e,t,r,n);s<l;){for(py(e,t,s,l),s++,l--;t[2*s+o]<a;)s++;for(;t[2*l+o]>a;)l--}t[2*r+o]===a?py(e,t,r,l):(l++,py(e,t,l,n)),l<=i&&(r=l+1),i<=l&&(n=l-1)}}function py(e,t,i,r){fy(e,i,r),fy(t,2*i,2*r),fy(t,2*i+1,2*r+1)}function fy(e,t,i){const r=e[t];e[t]=e[i],e[i]=r}function my(e,t,i,r){const n=e-i,o=t-r;return n*n+o*o}const _y=512/Ri/2;class TileLayerIndex{constructor(e,t,i){this.tileID=e,this.bucketInstanceId=i,this.index=new KDBush(t.length,16,Int32Array),this.keys=[],this.crossTileIDs=[];const r=e.canonical.x*Ri,n=e.canonical.y*Ri;for(let e=0;e<t.length;e++){const{key:i,crossTileID:o,tileAnchorX:a,tileAnchorY:s}=t.get(e),l=Math.floor((r+a)*_y),c=Math.floor((n+s)*_y);this.index.add(l,c),this.keys.push(i),this.crossTileIDs.push(o)}this.index.finish()}findMatches(e,t,i){const r=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z),n=_y/Math.pow(2,t.canonical.z-this.tileID.canonical.z),o=t.canonical.x*Ri,a=t.canonical.y*Ri;for(let t=0;t<e.length;t++){const s=e.get(t);if(s.crossTileID)continue;const{key:l,tileAnchorX:c,tileAnchorY:u}=s,h=Math.floor((o+c)*n),d=Math.floor((a+u)*n),p=this.index.range(h-r,d-r,h+r,d+r);for(const e of p){const t=this.crossTileIDs[e];if(this.keys[e]===l&&!i.has(t)){i.add(t),s.crossTileID=t;break}}}}}class CrossTileIDs{constructor(){this.maxCrossTileID=0}generate(){return++this.maxCrossTileID}}class CrossTileSymbolLayerIndex{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],r={};for(const e in i){const n=i[e];n.tileID=n.tileID.unwrapTo(n.tileID.wrap+t),r[n.tileID.key]=n}this.indexes[e]=r}this.lng=e}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return!1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key])}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]=new Set);const r=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const n=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in n){const o=n[i];o.tileID.isChildOf(e)&&o.findMatches(t.symbolInstances,e,r)}else{const o=n[e.scaledTo(Number(i)).key];o&&o.findMatches(t.symbolInstances,e,r)}}for(let e=0;e<t.symbolInstances.length;e++){const n=t.symbolInstances.get(e);n.crossTileID||(n.crossTileID=i.generate(),r.add(n.crossTileID))}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new TileLayerIndex(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i of t.crossTileIDs)this.usedCrossTileIDs[e].delete(i)}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const r=this.indexes[i];for(const n in r)e[r[n].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,r[n]),delete r[n],t=!0)}return t}}class CrossTileSymbolIndex{constructor(){this.layerIndexes={},this.crossTileIDs=new CrossTileIDs,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={}}addLayer(e,t,i,r){let n=this.layerIndexes[e.fqid];void 0===n&&(n=this.layerIndexes[e.fqid]=new CrossTileSymbolLayerIndex);let o=!1;const a={};"globe"!==r.name&&n.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.fqid===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),n.addBucket(i.tileID,t,this.crossTileIDs)&&(o=!0),a[t.bucketInstanceId]=!0)}return n.removeStaleBuckets(a)&&(o=!0),o}pruneUnusedLayers(e){const t={};e.forEach((e=>{t[e]=!0}));for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e]}}var gy="\n#define EPSILON 0.0000001\n#define PI 3.141592653589793\n#define EXTENT 8192.0\n#define HALF_PI PI/2.0\n#define QUARTER_PI PI/4.0\n#define RAD_TO_DEG 180.0/PI\n#define DEG_TO_RAD PI/180.0\n#define GLOBE_RADIUS EXTENT/PI/2.0\nvec3 linearTosRGB(vec3 color)\n{return pow(color,vec3(1./2.2));}vec3 sRGBToLinear(vec3 srgbIn)\n{return pow(srgbIn,vec3(2.2));}vec3 linearProduct(vec3 srgbIn,vec3 k)\n{return srgbIn*pow(k,vec3(1./2.2));}\n#if __VERSION__ >=300\n#define _HANDLE_WIREFRAME_DEPTH gl_FragDepth=gl_FragCoord.z-0.0001;\n#else\n#define _HANDLE_WIREFRAME_DEPTH\n#endif\n#ifdef DEBUG_WIREFRAME\n#define HANDLE_WIREFRAME_DEBUG \\\ngl_FragColor=vec4(0.7,0.0,0.0,0.7); \\\n_HANDLE_WIREFRAME_DEPTH;\n#else\n#define HANDLE_WIREFRAME_DEBUG\n#endif\n#ifdef RENDER_CUTOFF\nfloat cutoff_opacity(vec4 cutoff_params,float depth) {float near=cutoff_params.x;float far=cutoff_params.y;float cutoffStart=cutoff_params.z;float cutoffEnd=cutoff_params.w-0.0001;float linearDepth=(depth-near)/(far-near);return clamp((linearDepth-cutoffStart)/(cutoffEnd-cutoffStart),0.0,1.0);}\n#endif",yy="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}",xy="\n#define ELEVATION_SCALE 7.0\n#define ELEVATION_OFFSET 450.0\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_tl_up;uniform vec3 u_tile_tr_up;uniform vec3 u_tile_br_up;uniform vec3 u_tile_bl_up;uniform float u_tile_up_scale;vec3 elevationVector(vec2 pos) {vec2 uv=pos/EXTENT;vec3 up=normalize(mix(\nmix(u_tile_tl_up,u_tile_tr_up,uv.xxx),mix(u_tile_bl_up,u_tile_br_up,uv.xxx),uv.yyy));return up*u_tile_up_scale;}\n#else\nvec3 elevationVector(vec2 pos) { return vec3(0,0,1); }\n#endif\nconst float skirtOffset=24575.0;vec3 decomposeToPosAndSkirt(vec2 posWithComposedSkirt)\n{float skirt=float(posWithComposedSkirt.x >=skirtOffset);vec2 pos=posWithComposedSkirt-vec2(skirt*skirtOffset,0.0);return vec3(pos,skirt);}\n#ifdef TERRAIN\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;\n#else\nuniform highp sampler2D u_dem;uniform highp sampler2D u_dem_prev;\n#endif\nuniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale+u_dem_tl)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture(u_dem,pos).r;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));float tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}float prevElevation(vec2 apos) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nvec2 pos=(u_dem_size*(apos/8192.0*u_dem_scale_prev+u_dem_tl_prev)+1.5)/(u_dem_size+2.0);return u_exaggeration*texture(u_dem_prev,pos).r;\n#else\nfloat dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);\n#endif\n}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nfloat nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {\n#ifdef ZERO_EXAGGERATION\nreturn 0.0;\n#endif\nreturn currentElevation(apos);}\n#endif\nhighp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nfloat tl=texture(u_dem,pos).r;float tr=texture(u_dem,pos+vec2(off.x,0.0)).r;float bl=texture(u_dem,pos+vec2(0.0,off.y)).r;float br=texture(u_dem,pos+off).r;\n#else\nvec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);\n#endif\nreturn vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*(word/ELEVATION_SCALE-ELEVATION_OFFSET);}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",vy="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump mat4 u_fog_matrix;varying vec3 v_fog_pos;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}vec3 fog_position(vec3 pos) {return (u_fog_matrix*vec4(pos,1.0)).xyz;}vec3 fog_position(vec2 pos) {return fog_position(vec3(pos,0.0));}float fog(vec3 pos) {float depth=length(pos);float opacity=fog_opacity(fog_range(depth));return opacity*fog_horizon_blending(pos/depth);}\n#endif",by="#ifdef FOG\nuniform mediump vec4 u_fog_color;uniform mediump vec2 u_fog_range;uniform mediump float u_fog_horizon_blend;uniform mediump vec2 u_fog_vertical_limit;uniform mediump float u_fog_temporal_offset;varying vec3 v_fog_pos;uniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform highp vec2 u_viewport;uniform float u_globe_transition;uniform int u_is_globe;float fog_range(float depth) {return (depth-u_fog_range[0])/(u_fog_range[1]-u_fog_range[0]);}float fog_horizon_blending(vec3 camera_dir) {float t=max(0.0,camera_dir.z/u_fog_horizon_blend);return u_fog_color.a*exp(-3.0*t*t);}float fog_opacity(float t) {const float decay=6.0;float falloff=1.0-min(1.0,exp(-decay*t));falloff*=falloff*falloff;return u_fog_color.a*min(1.0,1.00747*falloff);}float globe_glow_progress() {highp vec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);highp vec3 dir=normalize(ray_dir);highp vec3 closest_point=dot(u_globe_pos,dir)*dir;highp float sdf=length(closest_point-u_globe_pos)/u_globe_radius;return sdf+PI*0.5;}float fog_opacity(vec3 pos) {float depth=length(pos);return fog_opacity(fog_range(depth));}vec3 fog_apply(vec3 color,vec3 pos) {float depth=length(pos);float opacity;if (u_is_globe==1) {float glow_progress=globe_glow_progress();float t=mix(glow_progress,depth,u_globe_transition);opacity=fog_opacity(fog_range(t));} else {opacity=fog_opacity(fog_range(depth));opacity*=fog_horizon_blending(pos/depth);}return mix(color,u_fog_color.rgb,opacity);}vec4 fog_apply_from_vert(vec4 color,float fog_opac) {float alpha=EPSILON+color.a;color.rgb=mix(color.rgb/alpha,u_fog_color.rgb,fog_opac)*alpha;return color;}vec3 fog_apply_sky_gradient(vec3 camera_ray,vec3 sky_color) {float horizon_blend=fog_horizon_blending(normalize(camera_ray));return mix(sky_color,u_fog_color.rgb,horizon_blend);}vec4 fog_apply_premultiplied(vec4 color,vec3 pos) {float alpha=EPSILON+color.a;color.rgb=fog_apply(color.rgb/alpha,pos)*alpha;return color;}vec4 fog_apply_premultiplied(vec4 color,vec3 pos,float heightMeters) {float verticalProgress=(u_fog_vertical_limit.x > 0.0 || u_fog_vertical_limit.y > 0.0) ? smoothstep(u_fog_vertical_limit.x,u_fog_vertical_limit.y,heightMeters) : 0.0;float opacityLimit=1.0-smoothstep(0.9,1.0,fog_opacity(pos));return mix(fog_apply_premultiplied(color,pos),color,min(verticalProgress,opacityLimit));}vec3 fog_dither(vec3 color) {\n#ifdef FOG_DITHERING\nvec2 dither_seed=gl_FragCoord.xy+u_fog_temporal_offset;return dither(color,dither_seed);\n#else\nreturn color;\n#endif\n}vec4 fog_dither(vec4 color) {return vec4(fog_dither(color.rgb),color.a);}\n#endif",wy="#ifdef RENDER_SHADOWS\nuniform mediump vec3 u_shadow_direction;uniform highp vec3 u_shadow_normal_offset;vec3 shadow_normal_offset(vec3 normal) {float tileInMeters=u_shadow_normal_offset[0];vec3 n=vec3(-normal.xy,tileInMeters*normal.z);float dotScale=min(1.0-dot(normal,u_shadow_direction),1.0)*0.5+0.5;return n*dotScale;}vec3 shadow_normal_offset_model(vec3 normal) {float dotScale=min(1.0-dot(normal,u_shadow_direction),1.0)*0.5+0.5;return normal*dotScale;}float shadow_normal_offset_multiplier0() {return u_shadow_normal_offset[1];}float shadow_normal_offset_multiplier1() {return u_shadow_normal_offset[2];}\n#endif//RENDER_SHADOWS",Ty="#ifdef RENDER_SHADOWS\n#if defined(NATIVE) && __VERSION__ >=300\n#define TEXTURE_GATHER\n#endif\n#ifdef DEPTH_TEXTURE\nuniform highp sampler2D u_shadowmap_0;uniform highp sampler2D u_shadowmap_1;\n#else\nuniform sampler2D u_shadowmap_0;uniform sampler2D u_shadowmap_1;\n#endif\nuniform float u_shadow_intensity;uniform float u_shadow_map_resolution;uniform float u_shadow_texel_size;uniform highp vec3 u_shadow_normal_offset;uniform vec2 u_fade_range;uniform mediump vec3 u_shadow_direction;uniform highp vec3 u_shadow_bias;highp float shadow_sample_1(highp vec2 uv,highp float compare) {highp float shadow_depth;\n#ifdef DEPTH_TEXTURE\nshadow_depth=texture2D(u_shadowmap_1,uv).r;\n#else\nshadow_depth=unpack_depth(texture2D(u_shadowmap_1,uv))*0.5+0.5;\n#endif\nreturn step(shadow_depth,compare);}highp float shadow_sample_0(highp vec2 uv,highp float compare) {highp float shadow_depth;\n#ifdef DEPTH_TEXTURE\nshadow_depth=texture2D(u_shadowmap_0,uv).r;\n#else\nshadow_depth=unpack_depth(texture2D(u_shadowmap_0,uv))*0.5+0.5;\n#endif\nreturn step(shadow_depth,compare);}float shadow_occlusion_1(highp vec4 pos,highp float bias) {highp vec2 uv=pos.xy;return shadow_sample_1(uv,pos.z-bias);}float shadow_occlusion_0(highp vec4 pos,highp float bias) {highp float compare0=pos.z-bias;\n#ifdef TEXTURE_GATHER\nhighp vec2 uv=pos.xy;highp vec4 samples=textureGather(u_shadowmap_0,uv,0);lowp vec4 stepSamples=step(samples,vec4(compare0));\n#else\nhighp vec2 uv00=pos.xy-vec2(0.5*u_shadow_texel_size);highp vec2 uv10=uv00+vec2(u_shadow_texel_size,0.0);highp vec2 uv01=uv00+vec2(0.0,u_shadow_texel_size);highp vec2 uv11=uv01+vec2(u_shadow_texel_size,0.0);lowp vec4 stepSamples=vec4(\nshadow_sample_0(uv01,compare0),shadow_sample_0(uv11,compare0),shadow_sample_0(uv10,compare0),shadow_sample_0(uv00,compare0)\n);\n#endif\nvec2 f=fract(pos.xy*u_shadow_map_resolution-vec2(0.5));lowp vec2 lerpx=mix(stepSamples.wx,stepSamples.zy,f.xx);return mix(lerpx.x,lerpx.y,f.y);}float shadow_occlusion(highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth,highp float bias) {\n#ifdef SHADOWS_SINGLE_CASCADE\nlight_view_pos0.xyz=light_view_pos0.xyz/light_view_pos0.w*0.5+0.5;return shadow_occlusion_0(light_view_pos0,bias);\n#else\nlight_view_pos0.xyz/=light_view_pos0.w;light_view_pos1.xyz/=light_view_pos1.w;vec4 uv=vec4(light_view_pos0.xy,light_view_pos1.xy);vec4 abs_bounds=abs(uv);if (abs_bounds.x < 1.0 && abs_bounds.y < 1.0) {light_view_pos0.xyz=light_view_pos0.xyz*0.5+0.5;return shadow_occlusion_0(light_view_pos0,bias);}if (abs_bounds.z >=1.0 || abs_bounds.w >=1.0) {return 0.0;}light_view_pos1.xyz=light_view_pos1.xyz*0.5+0.5;float occlusion1=shadow_occlusion_1(light_view_pos1,bias);return mix(occlusion1,0.0,smoothstep(u_fade_range.x,u_fade_range.y,view_depth));\n#endif\n}highp float calculate_shadow_bias(float NDotL) {\n#ifdef NORMAL_OFFSET\nreturn 0.5*u_shadow_bias.x;\n#else\nreturn 0.5*(u_shadow_bias.x+clamp(u_shadow_bias.y*tan(acos(NDotL)),0.0,u_shadow_bias.z));\n#endif\n}float shadowed_light_factor_normal(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float NDotL=dot(N,u_shadow_direction);float bias=calculate_shadow_bias(NDotL);float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor_normal_unbiased(vec3 N,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float NDotL=dot(N,u_shadow_direction);float bias=0.0;float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return mix(0.0,(1.0-(u_shadow_intensity*occlusion))*NDotL,step(0.0,NDotL));}float shadowed_light_factor(highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float bias=0.0;float occlusion=shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);return 1.0-(u_shadow_intensity*occlusion);}float shadow_occlusion(float ndotl,highp vec4 light_view_pos0,highp vec4 light_view_pos1,float view_depth) {float bias=calculate_shadow_bias(ndotl);return shadow_occlusion(light_view_pos0,light_view_pos1,view_depth,bias);}\n#endif";const Ey=[];Dy(gy,Ey);const My={"_prelude_fog.vertex.glsl":vy,"_prelude_terrain.vertex.glsl":xy,"_prelude_shadow.vertex.glsl":wy,"_prelude_fog.fragment.glsl":by,"_prelude_shadow.fragment.glsl":Ty,"_prelude_lighting.glsl":"\n#ifdef LIGHTING_3D_MODE\nuniform mediump vec3 u_lighting_ambient_color;uniform mediump vec3 u_lighting_directional_dir;uniform mediump vec3 u_lighting_directional_color;uniform mediump vec3 u_ground_radiance;float calculate_ambient_directional_factor(vec3 normal) {float NdotL=dot(normal,u_lighting_directional_dir);const float factor_reduction_max=0.3;float dir_luminance=dot(u_lighting_directional_color,vec3(0.2126,0.7152,0.0722));float directional_factor_min=1.0-factor_reduction_max*min(dir_luminance,1.0);float ambient_directional_factor=mix(directional_factor_min,1.0,min((NdotL+1.0),1.0));const float vertical_factor_min=0.92;float vertical_factor=mix(vertical_factor_min,1.0,normal.z*0.5+0.5);return vertical_factor*ambient_directional_factor;}vec3 apply_lighting(vec3 color,vec3 normal,float dir_factor) {float ambient_directional_factor=calculate_ambient_directional_factor(normal);vec3 ambient_contrib=ambient_directional_factor*u_lighting_ambient_color;vec3 directional_contrib=u_lighting_directional_color*dir_factor;return linearProduct(color,ambient_contrib+directional_contrib);}vec4 apply_lighting(vec4 color,vec3 normal,float dir_factor) {return vec4(apply_lighting(color.rgb,normal,dir_factor),color.a);}vec3 apply_lighting(vec3 color,vec3 normal) {float dir_factor=max(dot(normal,u_lighting_directional_dir),0.0);return apply_lighting(color.rgb,normal,dir_factor);}vec4 apply_lighting(vec4 color,vec3 normal) {float dir_factor=max(dot(normal,u_lighting_directional_dir),0.0);return vec4(apply_lighting(color.rgb,normal,dir_factor),color.a);}vec3 apply_lighting_ground(vec3 color) {return color*u_ground_radiance;}vec4 apply_lighting_ground(vec4 color) {return vec4(apply_lighting_ground(color.rgb),color.a);}float calculate_NdotL(vec3 normal) {const float ext=0.70710678118;return (clamp(dot(normal,u_lighting_directional_dir),-ext,1.0)+ext)/(1.0+ext);}vec4 apply_lighting_with_emission_ground(vec4 color,float emissive_strength) {return mix(apply_lighting_ground(color),color,emissive_strength);}vec3 compute_flood_lighting(vec3 flood_light_color,float fully_occluded_factor,float occlusion,vec3 ground_shadow_factor) {vec3 fully_occluded_color=flood_light_color*mix(ground_shadow_factor,vec3(1.0),fully_occluded_factor);float occlusion_ramp=smoothstep(0.0,0.2,1.0-occlusion);return mix(fully_occluded_color,flood_light_color,occlusion_ramp);}vec3 compute_emissive_draped(vec3 unlit_color,float fully_occluded_factor,float occlusion,vec3 ground_shadow_factor) {vec3 fully_occluded_color=unlit_color*mix(ground_shadow_factor,vec3(1.0),fully_occluded_factor);return mix(fully_occluded_color,unlit_color,1.0-occlusion);}\n#endif//LIGHTING_3D_MODE"},Sy={};Py("",xy),Py(by,vy),Py(Ty,wy);const Ay=Py("\n#if __VERSION__ >=300\n#define varying in\n#define gl_FragColor glFragColor\n#define texture2D texture\n#define textureCube texture\nout vec4 glFragColor;\n#endif\nhighp vec3 hash(highp vec2 p) {highp vec3 p3=fract(p.xyx*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract((p3.xxy+p3.yzz)*p3.zyx);}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;return color+rnd/255.0;}highp float unpack_depth(highp vec4 rgba_depth)\n{const highp vec4 bit_shift=vec4(1.0/(255.0*255.0*255.0),1.0/(255.0*255.0),1.0/255.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}highp vec4 pack_depth(highp float ndc_z) {highp float depth=ndc_z*0.5+0.5;const highp vec4 bit_shift=vec4(255.0*255.0*255.0,255.0*255.0,255.0,1.0);const highp vec4 bit_mask =vec4(0.0,1.0/255.0,1.0/255.0,1.0/255.0);highp vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}\n#ifdef INDICATOR_CUTOUT\nuniform vec2 u_indicator_cutout_centers;uniform vec4 u_indicator_cutout_params;\n#endif\nvec4 applyCutout(vec4 color) {\n#ifdef INDICATOR_CUTOUT\nfloat holeMinOpacity=u_indicator_cutout_params.x;float holeRadius=max(u_indicator_cutout_params.y,0.0);float holeAspectRatio=u_indicator_cutout_params.z;float fadeStart=u_indicator_cutout_params.w;float distA=distance(vec2(gl_FragCoord.x,gl_FragCoord.y*holeAspectRatio),vec2(u_indicator_cutout_centers[0],u_indicator_cutout_centers[1]*holeAspectRatio));return color*min(smoothstep(fadeStart,holeRadius,distA)+holeMinOpacity,1.0);\n#else\nreturn color;\n#endif\n}\n#ifdef RENDER_CUTOFF\nuniform highp vec4 u_cutoff_params;varying float v_cutoff_opacity;\n#endif","\n#if __VERSION__ >=300\n#define attribute in\n#define varying out\n#define texture2D texture\n#endif\nfloat wrap(float n,float min,float max) {float d=max-min;float w=mod(mod(n-min,d)+d,d)+min;return (w==min) ? max : w;}\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 mercator_tile_position(mat4 matrix,vec2 tile_anchor,vec3 tile_id,vec2 mercator_center) {\n#ifndef PROJECTED_POS_ON_VIEWPORT\nfloat tiles=tile_id.z;vec2 mercator=(tile_anchor/EXTENT+tile_id.xy)/tiles;mercator-=mercator_center;mercator.x=wrap(mercator.x,-0.5,0.5);vec4 mercator_tile=vec4(mercator.xy*EXTENT,EXTENT/(2.0*PI),1.0);mercator_tile=matrix*mercator_tile;return mercator_tile.xyz;\n#else\nreturn vec3(0.0);\n#endif\n}vec3 mix_globe_mercator(vec3 globe,vec3 mercator,float t) {return mix(globe,mercator,t);}mat3 globe_mercator_surface_vectors(vec3 pos_normal,vec3 up_dir,float zoom_transition) {vec3 normal=zoom_transition==0.0 ? pos_normal : normalize(mix(pos_normal,up_dir,zoom_transition));vec3 xAxis=normalize(vec3(normal.z,0.0,-normal.x));vec3 yAxis=normalize(cross(normal,xAxis));return mat3(xAxis,yAxis,normal);}\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}\n#ifdef RENDER_CUTOFF\nuniform vec4 u_cutoff_params;varying float v_cutoff_opacity;\n#endif\nconst vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered."),Cy=gy;var Iy={background:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec4 u_color;uniform float u_opacity;\n#ifdef LIGHTING_3D_MODE\nvarying vec4 v_color;\n#endif\nvoid main() {vec4 out_color;\n#ifdef LIGHTING_3D_MODE\nout_color=v_color;\n#else\nout_color=u_color;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_lighting.glsl"\nattribute vec2 a_pos;uniform mat4 u_matrix;\n#ifdef LIGHTING_3D_MODE\nuniform mediump vec4 u_color;varying vec4 v_color;uniform float u_emissive_strength;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef LIGHTING_3D_MODE\nv_color=apply_lighting_with_emission_ground(u_color,u_emissive_strength);\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),backgroundPattern:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_pattern_tl;uniform vec2 u_pattern_br;uniform vec2 u_texsize;uniform float u_opacity;uniform float u_emissive_strength;uniform sampler2D u_image;varying vec2 v_pos;void main() {vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(u_pattern_tl/u_texsize,u_pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pattern_size;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_pattern_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),circle:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nvarying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nuniform float u_emissive_strength;void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);vec4 out_color=mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_apply_premultiplied(out_color,v_fog_pos);\n#endif\ngl_FragColor=out_color*(v_visibility*opacity_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform mat2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale,mat3 surface_vectors) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\n#ifdef PROJECTION_GLOBE_VIEW\nreturn u_matrix*( world_center+vec4(sample_offset.x*surface_vectors[0]+sample_offset.y*surface_vectors[1],0) );\n#else\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#endif\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);vec4 world_center;mat3 surface_vectors;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(circle_center)*circle_elevation(circle_center);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*circle_elevation(circle_center);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,circle_center,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;vec3 pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);world_center=vec4(pos,1);\n#else \nsurface_vectors=mat3(1.0);float height=circle_elevation(circle_center);world_center=vec4(circle_center,height,1);\n#endif\nvec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale,surface_vectors);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();vec4 occlusion_world_center;vec4 occlusion_projected_center;\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);occlusion_world_center=vec4(circle_center,cantilevered_height,1);occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nocclusion_world_center=world_center;occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale,surface_vectors);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);\n#ifdef FOG\nv_fog_pos=fog_position(world_center.xyz);\n#endif\n}'),clippingMask:Py("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),heatmap:Py('#include "_prelude_fog.fragment.glsl"\nuniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef FOG\nif (u_is_globe==0) {gl_FragColor.r*=pow(1.0-fog_opacity(v_fog_pos),2.0);}\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;\n#endif\nvarying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec2 tilePos=floor(a_pos*0.5);vec3 pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 pos_normal_3=a_pos_normal_3/16384.0;mat3 surface_vectors=globe_mercator_surface_vectors(pos_normal_3,u_up_dir,u_zoom_transition);vec3 surface_extrusion=extrude.x*surface_vectors[0]+extrude.y*surface_vectors[1];vec3 globe_elevation=elevationVector(tilePos)*elevation(tilePos);vec3 globe_pos=a_pos_3+surface_extrusion+globe_elevation;vec3 mercator_elevation=u_up_dir*u_tile_up_scale*elevation(tilePos);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,tilePos,u_tile_id,u_merc_center)+surface_extrusion+mercator_elevation;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#else\npos=vec3(tilePos+extrude,elevation(tilePos));\n#endif\ngl_Position=u_matrix*vec4(pos,1);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),heatmapTexture:Py("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}","attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=vec4(a_pos,0,1);v_pos=a_pos*0.5+0.5;}"),collisionBox:Py("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}",'#include "_prelude_terrain.vertex.glsl"\nattribute vec3 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_pos+elevationVector(a_anchor_pos)*elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=projectedPoint;gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}'),collisionCircle:Py("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),debug:Py("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}",'#include "_prelude_terrain.vertex.glsl"\nattribute vec2 a_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;\n#endif\nvarying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*vec4(a_pos_3+elevationVector(a_pos)*h,1);\n#else\ngl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);\n#endif\n}'),fill:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nuniform float u_emissive_strength;void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\nvec4 out_color=color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nattribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillOutline:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nvarying vec2 v_pos;uniform float u_emissive_strength;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=outline_color;\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nattribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillOutlinePattern:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_emissive_strength;varying vec2 v_pos;varying vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);float dist=length(v_pos_world-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;varying vec2 v_pos_world;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);v_pos_world=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillPattern:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;varying vec2 v_pos;uniform float u_emissive_strength;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\ngl_FragColor=out_color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,a_pos);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),fillExtrusion:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nvarying vec4 v_color;\n#ifdef RENDER_SHADOWS\nvarying highp vec4 v_pos_light_view_0;varying highp vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nuniform lowp float u_opacity;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec2 v_ao;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nvarying vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nvarying highp vec3 v_normal;\n#endif\nuniform vec3 u_flood_light_color;uniform highp float u_vertical_scale;uniform float u_flood_light_intensity;uniform vec3 u_ground_shadow_factor;\n#if defined(LIGHTING_3D_MODE) && defined(FLOOD_LIGHT)\nvarying float v_flood_radius;varying float v_has_floodlight;\n#endif\nvarying float v_height;void main() {\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nvec3 normal=normalize(v_normal);\n#endif\nfloat z;vec4 color=v_color;\n#ifdef ZERO_ROOF_RADIUS\nz=float(normal.z > 0.00001);\n#ifdef LIGHTING_3D_MODE\nnormal=mix(normal,vec3(0.0,0.0,1.0),z);\n#else\ncolor=mix(v_color,v_roof_color,z);\n#endif\n#endif\nfloat h=max(0.0,v_height);float ao_shade=1.0;\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h_floors=h/(u_ao[1]*u_vertical_scale);float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);ao_shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;\n#ifdef ZERO_ROOF_RADIUS\nconcave*=(1.0-z);\n#endif\nfloat x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);ao_shade*=mix(1.0,x_shade*x_shade*x_shade,concave);\n#ifdef LIGHTING_3D_MODE\n#ifdef FLOOD_LIGHT\ncolor.rgb*=mix(ao_shade,1.0,v_has_floodlight);\n#else\ncolor.rgb*=ao_shade;\n#endif\n#else\ncolor.rgb*=ao_shade;\n#endif\n#endif\n#ifdef LIGHTING_3D_MODE\nfloat flood_radiance=0.0;\n#ifdef FLOOD_LIGHT\nflood_radiance=(1.0-min(h/v_flood_radius,1.0))*u_flood_light_intensity*v_has_floodlight;\n#endif\n#ifdef RENDER_SHADOWS\n#ifdef FLOOD_LIGHT\nfloat ndotl_unclamped=dot(normal,u_shadow_direction);float ndotl=max(0.0,ndotl_unclamped);float occlusion=ndotl_unclamped < 0.0 ? 1.0 : shadow_occlusion(ndotl,v_pos_light_view_0,v_pos_light_view_1,v_depth);vec3 litColor=apply_lighting(color.rgb,normal,(1.0-u_shadow_intensity*occlusion)*ndotl);vec3 floodLitColor=compute_flood_lighting(u_flood_light_color*u_opacity,1.0-u_shadow_intensity,occlusion,u_ground_shadow_factor);color.rgb=mix(litColor,floodLitColor,flood_radiance);\n#else\nfloat shadowed_lighting_factor=shadowed_light_factor_normal(normal,v_pos_light_view_0,v_pos_light_view_1,v_depth);color.rgb=apply_lighting(color.rgb,normal,shadowed_lighting_factor);\n#endif\n#else\ncolor.rgb=apply_lighting(color.rgb,normal);\n#ifdef FLOOD_LIGHT\ncolor.rgb=mix(color.rgb,u_flood_light_color*u_opacity,flood_radiance);\n#endif\n#endif\ncolor*=u_opacity;\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos,h));\n#endif\n#ifdef RENDER_CUTOFF\ncolor*=v_cutoff_opacity;\n#endif\n#ifdef INDICATOR_CUTOUT\ncolor=applyCutout(color);\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_shadow.vertex.glsl"\n#include "_prelude_lighting.glsl"\n#if __VERSION__ >=300\n#ifdef RENDER_CUTOFF\ninvariant gl_Position;\n#endif\n#endif\nuniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform float u_edge_radius;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nuniform highp float u_vertical_scale;varying vec4 v_color;\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying highp vec4 v_pos_light_view_0;varying highp vec4 v_pos_light_view_1;varying float v_depth;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nvarying vec4 v_roof_color;\n#endif\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nvarying highp vec3 v_normal;\n#endif\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec2 v_ao;\n#endif\n#if defined(LIGHTING_3D_MODE) && defined(FLOOD_LIGHT)\nvarying float v_flood_radius;varying float v_has_floodlight;\n#endif\nvarying float v_height;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define highp float flood_light_wall_radius\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize highp float flood_light_wall_radius\nbase*=u_vertical_scale;height*=u_vertical_scale;vec4 pos_nx=floor(a_pos_normal_ed*0.5);vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));\n#if defined(ZERO_ROOF_RADIUS) || defined(RENDER_SHADOWS) || defined(LIGHTING_3D_MODE)\nv_normal=normal;\n#endif\nbase=max(0.0,base);height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=0.0;float c_ele;vec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);pos=vec3(pos_nx.xy,h);\n#else\nh=t > 0.0 ? height : base;pos=vec3(pos_nx.xy,h);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*h);vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,pos.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*pos.z;pos=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);h=h-ele;v_height=h;\n#ifdef RENDER_SHADOWS\nvec3 shd_pos0=pos;vec3 shd_pos1=pos;\n#ifdef NORMAL_OFFSET\nvec3 offset=shadow_normal_offset(normal);shd_pos0+=offset*shadow_normal_offset_multiplier0();shd_pos1+=offset*shadow_normal_offset_multiplier1();\n#endif\nv_pos_light_view_0=u_light_matrix_0*vec4(shd_pos0,1);v_pos_light_view_1=u_light_matrix_1*vec4(shd_pos1,1);v_depth=gl_Position.w;\n#endif\nfloat NdotL=0.0;float colorvalue=0.0;\n#ifndef LIGHTING_3D_MODE\ncolorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;NdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),NdotL);if (normal.y !=0.0) {float r=0.84;r=mix(0.7,0.98,1.0-u_lightintensity);NdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#endif\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec2(mix(concave,-concave,start),y_ground);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\n#ifdef FLOOD_LIGHT\nfloat is_wall=1.0-float(t > 0.0 && top_up_ny.y > 0.0);v_has_floodlight=float(flood_light_wall_radius > 0.0 && is_wall > 0.0);v_flood_radius=flood_light_wall_radius*u_vertical_scale;\n#endif\nv_color=vec4(color.rgb,1.0);\n#else\nv_color=vec4(0.0,0.0,0.0,1.0);v_color.rgb+=clamp(color.rgb*NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_color*=u_opacity;\n#endif\n#if defined(ZERO_ROOF_RADIUS) && !defined(LIGHTING_3D_MODE)\nfloat roofNdotL=clamp(u_lightpos.z,0.0,1.0);roofNdotL=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),roofNdotL);v_roof_color=vec4(0.0,0.0,0.0,1.0);v_roof_color.rgb+=clamp(color.rgb*roofNdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_roof_color*=u_opacity;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n#ifdef RENDER_CUTOFF\nv_cutoff_opacity=cutoff_opacity(u_cutoff_params,gl_Position.z);\n#endif\n}'),fillExtrusionDepth:Py("varying highp float v_depth;void main() {\n#ifndef DEPTH_TEXTURE\ngl_FragColor=pack_depth(v_depth);\n#endif\n}",'#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_edge_radius;uniform float u_vertical_scale;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\nvarying highp float v_depth;void main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\nbase*=u_vertical_scale;height*=u_vertical_scale;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;base=max(0.0,base);height=max(0.0,top_up_ny.y==0.0 && top_up_ny.x==1.0 ? height-u_edge_radius : height);float t=top_up_ny.x;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nvec3 pos;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;float ele=elevation(pos_nx.xy);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base);pos=vec3(pos_nx.xy,h);\n#else\npos=vec3(pos_nx.xy,t > 0.0 ? height : base);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(pos,1),AWAY,hidden);v_depth=gl_Position.z/gl_Position.w;}'),fillExtrusionPattern:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform vec2 u_texsize;uniform sampler2D u_image;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nvarying vec3 v_normal;\n#endif\nvarying vec2 v_pos;varying vec4 v_lighting;uniform lowp float u_opacity;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define highp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize highp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 imagecoord=mod(v_pos,1.0);vec2 pos=mix(pattern_tl/u_texsize,pattern_br/u_texsize,imagecoord);vec4 out_color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting(out_color,normalize(v_normal))*u_opacity;\n#else\nout_color=out_color*v_lighting;\n#endif\n#ifdef FAUX_AO\nfloat intensity=u_ao[0];float h=max(0.0,v_ao.z);float h_floors=h/u_ao[1];float y_shade=1.0-0.9*intensity*min(v_ao.y,1.0);float shade=(1.0-0.08*intensity)*(y_shade+(1.0-y_shade)*(1.0-pow(1.0-min(h_floors/16.0,1.0),16.0)))+0.08*intensity*min(h_floors/160.0,1.0);float concave=v_ao.x*v_ao.x;float x_shade=mix(1.0,mix(0.6,0.75,min(h_floors/30.0,1.0)),intensity)+0.1*intensity*min(h,1.0);shade*=mix(1.0,x_shade*x_shade*x_shade,concave);out_color.rgb=out_color.rgb*shade;\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\n#ifdef INDICATOR_CUTOUT\nout_color=applyCutout(out_color);\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\n#include "_prelude_lighting.glsl"\nuniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform float u_tile_units_to_pixels;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_pos_3;attribute vec3 a_pos_normal_3;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_tile_id;uniform float u_zoom_transition;uniform vec3 u_up_dir;uniform float u_height_lift;\n#endif\nvarying vec2 v_pos;varying vec4 v_lighting;\n#ifdef FAUX_AO\nuniform lowp vec2 u_ao;varying vec3 v_ao;\n#endif\n#ifdef LIGHTING_3D_MODE\nvarying vec3 v_normal;\n#endif\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define mediump vec4 pattern\n#pragma mapbox: define highp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize highp float pixel_ratio\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec4 pos_nx=floor(a_pos_normal_ed*0.5);mediump vec4 top_up_ny_start=a_pos_normal_ed-2.0*pos_nx;mediump vec3 top_up_ny=top_up_ny_start.xyz;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;vec2 centroid_pos=vec2(0.0);\n#if defined(HAS_CENTROID) || defined(TERRAIN)\ncentroid_pos=a_centroid_pos;\n#endif\nfloat ele=0.0;float h=z;vec3 p;float c_ele;\n#ifdef TERRAIN\nbool flat_roof=centroid_pos.x !=0.0 && t > 0.0;ele=elevation(pos_nx.xy);c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);p=vec3(pos_nx.xy,h);\n#else\np=vec3(pos_nx.xy,z);\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nfloat lift=float((t+base) > 0.0)*u_height_lift;h+=lift;vec3 globe_normal=normalize(mix(a_pos_normal_3/16384.0,u_up_dir,u_zoom_transition));vec3 globe_pos=a_pos_3+globe_normal*(u_tile_up_scale*(p.z+lift));vec3 merc_pos=mercator_tile_position(u_inv_rot_matrix,p.xy,u_tile_id,u_merc_center)+u_up_dir*u_tile_up_scale*p.z;p=mix_globe_mercator(globe_pos,merc_pos,u_zoom_transition);\n#endif\nfloat hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);gl_Position=mix(u_matrix*vec4(p,1),AWAY,hidden);vec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,display_size,u_tile_units_to_pixels,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float NdotL=0.0;\n#ifdef LIGHTING_3D_MODE\nNdotL=calculate_NdotL(normal);\n#else\nNdotL=clamp(dot(normal,u_lightpos),0.0,1.0);NdotL=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),NdotL);\n#endif\nif (normal.y !=0.0) {float r=0.84;\n#ifndef LIGHTING_3D_MODE\nr=mix(0.7,0.98,1.0-u_lightintensity);\n#endif\nNdotL*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),r,1.0)));}\n#ifdef FAUX_AO\nfloat concave=pos_nx.w-floor(pos_nx.w*0.5)*2.0;float start=top_up_ny_start.w;float y_ground=1.0-clamp(t+base,0.0,1.0);float top_height=height;\n#ifdef TERRAIN\ntop_height=mix(max(c_ele+height,ele+base+2.0),ele+height,float(centroid_pos.x==0.0))-ele;y_ground+=y_ground*5.0/max(3.0,top_height);\n#endif\nv_ao=vec3(mix(concave,-concave,start),y_ground,h-ele);NdotL*=(1.0+0.05*(1.0-top_up_ny.y)*u_ao[0]);\n#ifdef PROJECTION_GLOBE_VIEW\ntop_height+=u_height_lift;\n#endif\ngl_Position.z-=(0.0000006*(min(top_height,500.)+2.0*min(base,500.0)+60.0*concave+3.0*start))*gl_Position.w;\n#endif\n#ifdef LIGHTING_3D_MODE\nv_normal=normal;\n#else\nv_lighting.rgb+=clamp(NdotL*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;\n#endif \n#ifdef FOG\nv_fog_pos=fog_position(p);\n#endif\n}'),groundShadow:Py('#include "_prelude_shadow.fragment.glsl"\n#ifdef GL_ES\nprecision highp float;\n#endif\nuniform vec3 u_ground_shadow_factor;varying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\nvoid main() {float light=shadowed_light_factor(v_pos_light_view_0,v_pos_light_view_1,v_depth);vec3 shadow=mix(u_ground_shadow_factor,vec3(1.0),light);\n#ifdef RENDER_CUTOFF\nshadow=mix(vec3(1.0),shadow,cutoff_opacity(u_cutoff_params,v_depth));\n#endif\n#ifdef FOG\nshadow=mix(shadow,vec3(1.0),v_fog_opacity);\n#endif\n#ifdef INDICATOR_CUTOUT\nshadow=mix(shadow,vec3(1.0),1.0-applyCutout(vec4(1.0)).r);\n#endif\ngl_FragColor=vec4(shadow,1.0);}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;attribute vec2 a_pos;varying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\nvoid main() {gl_Position=u_matrix*vec4(a_pos,0.0,1.0);v_pos_light_view_0=u_light_matrix_0*vec4(a_pos,0.0,1.0);v_pos_light_view_1=u_light_matrix_1*vec4(a_pos,0.0,1.0);v_depth=gl_Position.w;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);v_fog_opacity=fog(v_fog_pos);\n#endif\n}'),fillExtrusionGroundEffect:Py("uniform highp float u_ao_pass;uniform highp float u_opacity;uniform highp float u_flood_light_intensity;uniform highp vec3 u_flood_light_color;uniform highp float u_attenuation;uniform sampler2D u_fb;uniform float u_fb_size;\n#ifdef SDF_SUBPASS\nvarying highp vec2 v_pos;varying highp vec4 v_line_segment;varying highp float v_flood_light_radius_tile;varying highp vec2 v_ao;float line_df(highp vec2 a,highp vec2 b,highp vec2 p) {highp vec2 ba=b-a;highp vec2 pa=p-a;highp float r=clamp(dot(pa,ba)/dot(ba,ba),0.0,1.0);return length(pa-r*ba);}\n#ifdef FOG\nvarying highp float v_fog;\n#endif\n#endif\nvoid main() {\n#ifdef CLEAR_SUBPASS\nvec4 color=vec4(1.0);\n#ifdef CLEAR_FROM_TEXTURE\ncolor=texture2D(u_fb,gl_FragCoord.xy/vec2(u_fb_size));\n#endif\ngl_FragColor=color;\n#else\n#ifdef SDF_SUBPASS\nhighp float d=line_df(v_line_segment.xy,v_line_segment.zw,v_pos);highp float effect_radius=mix(v_flood_light_radius_tile,v_ao.y,u_ao_pass);d/=effect_radius;d=min(d,1.0);d=1.0-pow(1.0-d,u_attenuation);highp float effect_intensity=mix(u_flood_light_intensity,v_ao.x,u_ao_pass);highp float fog=1.0;\n#ifdef FOG\nfog=v_fog;\n#endif\n#ifdef RENDER_CUTOFF\nfog*=v_cutoff_opacity;\n#endif\ngl_FragColor=vec4(vec3(0.0),mix(1.0,d,effect_intensity*u_opacity*fog));\n#else\nvec4 color=mix(vec4(u_flood_light_color,1.0),vec4(vec3(0.0),1.0),u_ao_pass);\n#ifdef OVERDRAW_INSPECTOR\ncolor=vec4(1.0);\n#endif\ngl_FragColor=color;HANDLE_WIREFRAME_DEBUG;\n#endif\n#endif\n}",'#include "_prelude_fog.vertex.glsl"\nattribute highp vec4 a_pos_end;attribute highp float a_angular_offset_factor;attribute highp float a_hidden_by_landmark;\n#ifdef SDF_SUBPASS\nvarying highp vec2 v_pos;varying highp vec4 v_line_segment;varying highp float v_flood_light_radius_tile;varying highp vec2 v_ao;\n#ifdef FOG\nvarying highp float v_fog;\n#endif\n#endif\nuniform highp float u_flood_light_intensity;uniform highp mat4 u_matrix;uniform highp float u_ao_pass;uniform highp float u_meter_to_tile;uniform highp float u_edge_radius;uniform highp vec2 u_ao;\n#pragma mapbox: define highp float flood_light_ground_radius\nconst float TANGENT_CUTOFF=4.0;const float NORM=32767.0;void main() {\n#pragma mapbox: initialize highp float flood_light_ground_radius\nvec2 p=a_pos_end.xy;vec2 q=floor(a_pos_end.zw*0.5);vec2 start_bottom=a_pos_end.zw-q*2.0;float fl_ground_radius=flood_light_ground_radius;\n#ifdef FORCE_ABS_FL_GROUND_RADIUS\nfl_ground_radius=abs(flood_light_ground_radius);\n#endif\nfloat flood_radius_tile=fl_ground_radius*u_meter_to_tile;vec2 v=normalize(q-p);float ao_radius=u_ao.y/3.5;float effect_radius=mix(flood_radius_tile,ao_radius,u_ao_pass)+u_edge_radius;float angular_offset_factor=a_angular_offset_factor/NORM*TANGENT_CUTOFF;float angular_offset=angular_offset_factor*effect_radius;float top=1.0-start_bottom.y;float side=(0.5-start_bottom.x)*2.0;vec2 extrusion_parallel=v*side*mix(1.0,angular_offset,top);vec2 perp=vec2(v.y,-v.x);vec2 extrusion_perp=perp*effect_radius*top;vec3 pos=vec3(mix(q,p,start_bottom.x),0.0);pos.xy+=extrusion_parallel+extrusion_perp;\n#ifdef SDF_SUBPASS\nv_pos=pos.xy;v_line_segment=vec4(p,q)+perp.xyxy*u_edge_radius;v_flood_light_radius_tile=flood_radius_tile;v_ao=vec2(u_ao.x,ao_radius);\n#ifdef FOG\nv_fog_pos=fog_position(pos);v_fog=1.0-fog(v_fog_pos);\n#endif\n#endif\nfloat hidden_by_landmark=0.0;\n#ifdef HAS_CENTROID\nhidden_by_landmark=a_hidden_by_landmark;\n#endif\nfloat isFloodlit=float(fl_ground_radius > 0.0 && u_flood_light_intensity > 0.0);float hidden=mix(1.0-isFloodlit,isFloodlit,u_ao_pass);hidden+=hidden_by_landmark;gl_Position=mix(u_matrix*vec4(pos,1.0),AWAY,float(hidden > 0.0));\n#ifdef RENDER_CUTOFF\nv_cutoff_opacity=cutoff_opacity(u_cutoff_params,gl_Position.z);\n#endif\n}'),hillshadePrepare:Py("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord) {\n#ifdef TERRAIN_DEM_FLOAT_FORMAT\nreturn texture(u_image,coord).r/4.0;\n#else\nvec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;\n#endif\n}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y));float b=getElevation(v_pos+vec2(0,-epsilon.y));float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y));float d=getElevation(v_pos+vec2(-epsilon.x,0));float e=getElevation(v_pos+vec2(epsilon.x,0));float f=getElevation(v_pos+vec2(-epsilon.x,epsilon.y));float g=getElevation(v_pos+vec2(0,epsilon.y));float h=getElevation(v_pos+vec2(epsilon.x,epsilon.y));float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+e+e+h)-(a+d+d+f),(f+g+g+h)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),hillshade:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;uniform float u_emissive_strength;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef LIGHTING_3D_MODE\ngl_FragColor=apply_lighting_with_emission_ground(gl_FragColor,u_emissive_strength);\n#endif\n#ifdef FOG\ngl_FragColor=fog_dither(fog_apply_premultiplied(gl_FragColor,v_fog_pos));\n#endif\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\n}'),line:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform lowp float u_device_pixel_ratio;uniform float u_alpha_discard_threshold;uniform highp vec2 u_trim_offset;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform sampler2D u_dash_image;varying vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform sampler2D u_gradient_image;\n#endif\nfloat luminance(vec3 c) {return (c.r+c.r+c.b+c.g+c.g+c.g)*0.1667;}uniform float u_emissive_strength;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float border_width\n#pragma mapbox: define lowp vec4 border_color\nfloat linearstep(float edge0,float edge1,float x) {return  clamp((x-edge0)/(edge1-edge0),0.0,1.0);}void main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float border_width\n#pragma mapbox: initialize lowp vec4 border_color\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);\n#ifdef RENDER_LINE_DASH\nfloat sdfdist=texture2D(u_dash_image,v_tex).a;float sdfgamma=1.0/(2.0*u_device_pixel_ratio)/dash.z;alpha*=linearstep(0.5-sdfgamma/floorwidth,0.5+sdfgamma/floorwidth,sdfdist);\n#endif\nhighp vec4 out_color;\n#ifdef RENDER_LINE_GRADIENT\nout_color=texture2D(u_gradient_image,v_uv.xy);\n#else\nout_color=color;\n#endif\nfloat trimmed=1.0;\n#ifdef RENDER_LINE_TRIM_OFFSET\nhighp float start=v_uv[2];highp float end=v_uv[3];highp float trim_start=u_trim_offset[0];highp float trim_end=u_trim_offset[1];highp float line_progress=(start+(v_uv.x)*(end-start));if (trim_end > trim_start) {if (line_progress <=trim_end && line_progress >=trim_start) {out_color=vec4(0,0,0,0);trimmed=0.0;}}\n#endif\nif (u_alpha_discard_threshold !=0.0) {if (alpha < u_alpha_discard_threshold) {discard;}}\n#ifdef RENDER_LINE_BORDER\nfloat edgeBlur=(border_width+1.0/u_device_pixel_ratio);float alpha2=clamp(min(dist-(v_width2.t-edgeBlur),v_width2.s-dist)/edgeBlur,0.0,1.0);if (alpha2 < 1.) {float smoothAlpha=smoothstep(0.6,1.0,alpha2);if (border_color.a==0.0) {    \nfloat Y=(out_color.a > 0.01) ? luminance(out_color.rgb/out_color.a) : 1.;float adjustment=(Y > 0.) ? 0.5/Y : 0.45;if (out_color.a > 0.25 && Y < 0.25) {vec3 borderColor=(Y > 0.) ? out_color.rgb : vec3(1,1,1)*out_color.a;out_color.rgb=out_color.rgb+borderColor*(adjustment*(1.0-smoothAlpha));} else {out_color.rgb*=(0.6 +0.4*smoothAlpha);}} else {out_color.rgb=mix(border_color.rgb*border_color.a*trimmed,out_color.rgb,smoothAlpha);}}\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,u_emissive_strength);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply_premultiplied(out_color,v_fog_pos));\n#endif\nout_color*=(alpha*opacity);\n#ifdef INDICATOR_CUTOUT\nout_color=applyCutout(out_color);\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#define EXTRUDE_SCALE 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nattribute highp vec4 a_packed;\n#endif\n#ifdef RENDER_LINE_DASH\nattribute float a_linesofar;\n#endif\nuniform mat4 u_matrix;uniform mat2 u_pixels_to_tile_units;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec4 v_uv;\n#ifdef RENDER_LINE_DASH\nuniform vec2 u_texsize;uniform float u_tile_units_to_pixels;varying vec2 v_tex;\n#endif\n#ifdef RENDER_LINE_GRADIENT\nuniform float u_image_height;\n#endif\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 dash\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float border_width\n#pragma mapbox: define lowp vec4 border_color\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize lowp vec4 dash\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float border_width\n#pragma mapbox: initialize lowp vec4 border_color\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*EXTRUDE_SCALE;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*EXTRUDE_SCALE*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\n#if defined(RENDER_LINE_GRADIENT) || defined(RENDER_LINE_TRIM_OFFSET)\nfloat a_uv_x=a_packed[0];float a_split_index=a_packed[1];highp float a_clip_start=a_packed[2];highp float a_clip_end=a_packed[3];\n#ifdef RENDER_LINE_GRADIENT\nhighp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec4(a_uv_x,a_split_index*texel_height-half_texel_height,a_clip_start,a_clip_end);\n#else\nv_uv=vec4(a_uv_x,0.0,a_clip_start,a_clip_end);\n#endif\n#endif\n#ifdef RENDER_LINE_DASH\nfloat scale=dash.z==0.0 ? 0.0 : u_tile_units_to_pixels/dash.z;float height=dash.y;v_tex=vec2(a_linesofar*scale/floorwidth,(-normal.y*height+dash.x+0.5)/u_texsize.y);\n#endif\nv_width2=vec2(outset,inset);\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),linePattern:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_tile_units_to_pixels;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl=pattern.xy;vec2 pattern_br=pattern.zw;vec2 display_size=(pattern_br-pattern_tl)/pixel_ratio;vec2 pattern_size=vec2(display_size.x/u_tile_units_to_pixels,display_size.y);float aspect=display_size.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x=mod(v_linesofar/pattern_size.x*aspect,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos=mix(pattern_tl*texel_size-texel_size,pattern_br*texel_size+texel_size,vec2(x,y));vec4 color=texture2D(u_image,pos);\n#ifdef LIGHTING_3D_MODE\ncolor=apply_lighting_ground(color);\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ncolor*=(alpha*opacity);\n#ifdef INDICATOR_CUTOUT\ncolor=applyCutout(color);\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mat2 u_pixels_to_tile_units;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern\n#pragma mapbox: define lowp float pixel_ratio\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern\n#pragma mapbox: initialize lowp float pixel_ratio\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist*u_pixels_to_tile_units,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2*u_pixels_to_tile_units,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;\n#ifdef FOG\nv_fog_pos=fog_position(pos);\n#endif\n}'),raster:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;\n#ifdef RASTER_COLOR\nuniform sampler2D u_color_ramp;uniform highp vec2 u_colorization_scale;uniform highp vec4 u_colorization_mix;highp vec4 colormap (highp float value) {highp float scaled_value=value*u_colorization_scale.y+u_colorization_scale.x;highp vec2 coords=vec2(scaled_value,0.5);return texture2D(u_color_ramp,coords);}\n#endif\nvoid main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);vec4 color;\n#ifdef RASTER_COLOR\nhighp vec4 fadedColor=mix(color0,color1,u_fade_t);color=colormap(dot(vec4(fadedColor.rgb,1),u_colorization_mix));color.a*=fadedColor.a;if (color.a > 0.0) {color.rgb/=color.a;}\n#else\nif (color0.a > 0.0) {color0.rgb/=color0.a;}if (color1.a > 0.0) {color1.rgb/=color1.a;}color=mix(color0,color1,u_fade_t);\n#endif\ncolor.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);vec3 out_color=mix(u_high_vec,u_low_vec,rgb);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_ground(out_color);\n#endif\n#ifdef FOG\nout_color=fog_dither(fog_apply(out_color,v_fog_pos));\n#endif\ngl_FragColor=vec4(out_color*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\nuniform mat4 u_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform vec2 u_perspective_transform;\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_pos;attribute vec2 a_uv;\n#else\nattribute vec2 a_pos;attribute vec2 a_texture_pos;\n#endif\nvarying vec2 v_pos0;varying vec2 v_pos1;void main() {vec2 uv;\n#ifdef PROJECTION_GLOBE_VIEW\ngl_Position=u_matrix*u_globe_matrix*vec4(a_globe_pos,1.0);uv=a_uv;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(a_globe_pos,1.0)).xyz);\n#endif\n#else\nfloat w=1.0+dot(a_texture_pos,u_perspective_transform);gl_Position=u_matrix*vec4(a_pos*w,0,w);\n#ifdef FOG\nv_fog_pos=fog_position(a_pos);\n#endif\nuv=a_texture_pos/8192.0;\n#endif\nv_pos0=uv;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}'),symbolIcon:Py('#include "_prelude_lighting.glsl"\nuniform sampler2D u_texture;\n#ifdef ICON_TRANSITION\nuniform float u_icon_transition;\n#endif\nvarying float v_fade_opacity;varying vec2 v_tex_a;\n#ifdef ICON_TRANSITION\nvarying vec2 v_tex_b;\n#endif\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float emissive_strength\nlowp float alpha=opacity*v_fade_opacity;vec4 out_color;\n#ifdef ICON_TRANSITION\nvec4 a=texture2D(u_texture,v_tex_a)*(1.0-u_icon_transition);vec4 b=texture2D(u_texture,v_tex_b)*u_icon_transition;out_color=(a+b)*alpha;\n#else\nout_color=texture2D(u_texture,v_tex_a)*alpha;\n#endif\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nattribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef Z_OFFSET\nattribute float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\n#ifdef ICON_TRANSITION\nattribute vec2 a_texb;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;uniform vec3 u_up_vector;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\nvarying vec2 v_tex_a;\n#ifdef ICON_TRANSITION\nvarying vec2 v_tex_b;\n#endif\nvarying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float emissive_strength\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_min_font_scale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetProjected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetProjected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetProjected_point.xy/offsetProjected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_min_font_scale,font_scale)+a_pxoffset/16.0);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float out_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change))*projection_transition_fade;float alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nv_tex_a=a_tex/u_texsize;\n#ifdef ICON_TRANSITION\nv_tex_b=a_texb/u_texsize;\n#endif\nv_fade_opacity=out_fade_opacity;}'),symbolSDF:Py('#include "_prelude_lighting.glsl"\n#define SDF_PX 8.0\nuniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;uniform bool u_is_halo;\n#if __VERSION__ >=300\nflat varying float v_draw_halo;\n#endif\nvarying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;bool draw_halo;\n#if __VERSION__ >=300\ndraw_halo=v_draw_halo > 0.0;\n#else\ndraw_halo=u_is_halo;\n#endif\nif (draw_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);vec4 out_color=color*(alpha*opacity*fade_opacity);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nattribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_pixeloffset;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef Z_OFFSET\nattribute float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;uniform bool u_is_halo;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\n#if __VERSION__ >=300\nflat varying float v_draw_halo;\n#endif\nvarying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetprojected_point;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 displacement=vec3(a_globe_normal.z,0,-a_globe_normal.x);offsetprojected_point=u_matrix*vec4(a_globe_anchor+displacement,1);\n#else\noffsetprojected_point=u_matrix*vec4(tile_anchor+vec2(1,0),0,1);\n#endif\nvec2 a=projected_point.xy/projected_point.w;vec2 b=offsetprojected_point.xy/offsetprojected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nvec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float out_fade_opacity=interpolated_fade_opacity*projection_transition_fade;float alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nfloat gamma_scale=gl_Position.w;\n#if __VERSION__ >=300\nv_draw_halo=(u_is_halo && float(gl_InstanceID)==0.0) ? 1.0 : 0.0;\n#endif\nv_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,out_fade_opacity);}'),symbolTextAndIcon:Py('#include "_prelude_lighting.glsl"\n#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_halo;\n#if __VERSION__ >=300\nflat varying float v_draw_halo;\n#endif\nvarying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;bool draw_halo;\n#if __VERSION__ >=300\ndraw_halo=v_draw_halo > 0.0;\n#else\ndraw_halo=u_is_halo;\n#endif\nif (draw_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);vec4 out_color=color*(alpha*opacity*fade_opacity);\n#ifdef LIGHTING_3D_MODE\nout_color=apply_lighting_with_emission_ground(out_color,emissive_strength);\n#endif\ngl_FragColor=out_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_terrain.vertex.glsl"\nattribute vec4 a_pos_offset;attribute vec4 a_tex_size;attribute vec4 a_projected_pos;attribute float a_fade_opacity;\n#ifdef Z_OFFSET\nattribute float a_z_offset;\n#endif\n#ifdef PROJECTION_GLOBE_VIEW\nattribute vec3 a_globe_anchor;attribute vec3 a_globe_normal;\n#endif\nuniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec3 u_up_vector;uniform vec2 u_texsize_icon;uniform bool u_is_halo;\n#ifdef PROJECTION_GLOBE_VIEW\nuniform vec3 u_tile_id;uniform mat4 u_inv_rot_matrix;uniform vec2 u_merc_center;uniform vec3 u_camera_forward;uniform float u_zoom_transition;uniform vec3 u_ecef_origin;uniform mat4 u_tile_matrix;\n#endif\n#if __VERSION__ >=300\nflat varying float v_draw_halo;\n#endif\nvarying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\n#pragma mapbox: define lowp float emissive_strength\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\n#pragma mapbox: initialize lowp float emissive_strength\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_tex_size.xy;vec2 a_size=a_tex_size.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[3];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}vec2 tile_anchor=a_pos;float e=elevation(tile_anchor);\n#ifdef Z_OFFSET\ne+=a_z_offset;\n#endif\nvec3 h=elevationVector(tile_anchor)*e;float globe_occlusion_fade;vec3 world_pos;vec3 mercator_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nmercator_pos=mercator_tile_position(u_inv_rot_matrix,tile_anchor,u_tile_id,u_merc_center);world_pos=mix_globe_mercator(a_globe_anchor+h,mercator_pos,u_zoom_transition);vec4 ecef_point=u_tile_matrix*vec4(world_pos,1.0);vec3 origin_to_point=ecef_point.xyz-u_ecef_origin;globe_occlusion_fade=dot(origin_to_point,u_camera_forward) >=0.0 ? 0.0 : 1.0;\n#else\nworld_pos=vec3(tile_anchor,0)+h;globe_occlusion_fade=1.0;\n#endif\nvec4 projected_point=u_matrix*vec4(world_pos,1);highp float camera_to_anchor_distance=projected_point.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float font_scale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offset_projected_point=u_matrix*vec4(a_pos+vec2(1,0),0,1);vec2 a=projected_point.xy/projected_point.w;vec2 b=offset_projected_point.xy/offset_projected_point.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}vec4 projected_pos;\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 proj_pos=mix_globe_mercator(a_projected_pos.xyz+h,mercator_pos,u_zoom_transition);projected_pos=u_label_plane_matrix*vec4(proj_pos,1.0);\n#else\nprojected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h.z,1.0);\n#endif\nhighp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*font_scale);\n#ifdef TERRAIN\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\n#endif\nfloat occlusion_fade=occlusionFade(projected_point)*globe_occlusion_fade;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));float projection_transition_fade=1.0;\n#if defined(PROJECTED_POS_ON_VIEWPORT) && defined(PROJECTION_GLOBE_VIEW)\nprojection_transition_fade=1.0-step(EPSILON,u_zoom_transition);\n#endif\nfloat out_fade_opacity=interpolated_fade_opacity*projection_transition_fade;float alpha=opacity*out_fade_opacity;float hidden=float(alpha==0.0 || projected_point.w <=0.0 || occlusion_fade==0.0);\n#ifdef PROJECTION_GLOBE_VIEW\nvec3 xAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,u_up_vector)) : vec3(1,0,0);vec3 yAxis=u_pitch_with_map ? normalize(cross(a_globe_normal,xAxis)) : vec3(0,1,0);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xyz/projected_pos.w+xAxis*offset.x+yAxis*offset.y,1.0),AWAY,hidden);\n#else\ngl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,hidden);\n#endif\nfloat gamma_scale=gl_Position.w;\n#if __VERSION__ >=300\nv_draw_halo=(u_is_halo && float(gl_InstanceID)==0.0) ? 1.0 : 0.0;\n#endif\nv_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,out_fade_opacity,is_sdf);}'),terrainRaster:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image0;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nvarying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nuniform vec3 u_ground_shadow_factor;void main() {vec4 image_color=texture2D(u_image0,v_pos0);vec4 color;\n#ifdef LIGHTING_3D_MODE\nconst vec3 normal=vec3(0.0,0.0,1.0);\n#ifdef RENDER_SHADOWS\nfloat cutoffOpacity=1.0;\n#ifdef RENDER_CUTOFF\ncutoffOpacity=cutoff_opacity(u_cutoff_params,v_depth);\n#endif\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\nvec3 unlit_base=image_color.rgb*(1.0-image_color.a);vec3 emissive_base=image_color.rgb*image_color.a;float ndotl=u_shadow_direction.z;float occlusion=ndotl < 0.0 ? 1.0 : shadow_occlusion(v_pos_light_view_0,v_pos_light_view_1,v_depth,0.0);ndotl=max(0.0,ndotl);vec3 lit=apply_lighting(unlit_base,normal,mix(1.0,(1.0-(u_shadow_intensity*occlusion))*ndotl,cutoffOpacity));vec3 emissive=compute_emissive_draped(emissive_base,1.0-u_shadow_intensity,occlusion,u_ground_shadow_factor);color.rgb=lit+emissive;color.a=1.0;\n#else\nfloat lighting_factor=shadowed_light_factor_normal_unbiased(normal,v_pos_light_view_0,v_pos_light_view_1,v_depth);color=apply_lighting(image_color,normal,mix(1.0,lighting_factor,cutoffOpacity));\n#endif\n#else\nfloat lighting_factor=u_lighting_directional_dir.z;color=apply_lighting(image_color,normal,lighting_factor);\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\ncolor.rgb=mix(color.rgb,image_color.rgb,image_color.a);color.a=1.0;\n#endif\n#endif\n#else\ncolor=image_color;\n#endif\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#else\ncolor=fog_dither(fog_apply_from_vert(color,v_fog_opacity));\n#endif\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;varying vec2 v_pos0;\n#ifdef FOG\nvarying float v_fog_opacity;\n#endif\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth;\n#endif\nvoid main() {vec3 decomposedPosAndSkirt=decomposeToPosAndSkirt(a_pos);float skirt=decomposedPosAndSkirt.z;vec2 decodedPos=decomposedPosAndSkirt.xy;float elevation=elevation(decodedPos)-skirt*u_skirt_height;v_pos0=decodedPos/8192.0;gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);\n#ifdef FOG\n#ifdef ZERO_EXAGGERATION\nv_fog_pos=fog_position(decodedPos);\n#else\nv_fog_opacity=fog(fog_position(vec3(decodedPos,elevation)));\n#endif\n#endif\n#ifdef RENDER_SHADOWS\nvec3 pos=vec3(decodedPos,elevation);v_pos_light_view_0=u_light_matrix_0*vec4(pos,1.);v_pos_light_view_1=u_light_matrix_1*vec4(pos,1.);v_depth=gl_Position.w;\n#endif\n}'),terrainDepth:Py("#ifdef GL_ES\nprecision highp float;\n#endif\nvarying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}",'#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_matrix;attribute vec2 a_pos;varying float v_depth;void main() {float elevation=elevation(a_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}'),skybox:Py('#include "_prelude_fog.fragment.glsl"\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;\n#ifdef FOG\nsky_color=fog_apply_sky_gradient(v_uv.xzy,sky_color);\n#endif\nsky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}',yy),skyboxGradient:Py('#include "_prelude_fog.fragment.glsl"\nvarying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform highp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5));\n#ifdef FOG\ncolor.rgb=fog_apply_sky_gradient(v_uv.xzy,color.rgb/color.a)*color.a;\n#endif\ncolor*=u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}',yy),skyboxCapture:Py("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}"),globeRaster:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform sampler2D u_image0;varying vec2 v_pos0;\n#ifndef FOG\nuniform highp vec3 u_frustum_tl;uniform highp vec3 u_frustum_tr;uniform highp vec3 u_frustum_br;uniform highp vec3 u_frustum_bl;uniform highp vec3 u_globe_pos;uniform highp float u_globe_radius;uniform vec2 u_viewport;\n#endif\nvoid main() {vec4 color;\n#ifdef CUSTOM_ANTIALIASING\nvec2 uv=gl_FragCoord.xy/u_viewport;highp vec3 ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,uv.x),mix(u_frustum_bl,u_frustum_br,uv.x),1.0-uv.y);vec3 dir=normalize(ray_dir);vec3 closest_point=dot(u_globe_pos,dir)*dir;float norm_dist_from_center=1.0-length(closest_point-u_globe_pos)/u_globe_radius;const float antialias_pixel=2.0;float antialias_factor=antialias_pixel*fwidth(norm_dist_from_center);float antialias=smoothstep(0.0,antialias_factor,norm_dist_from_center);vec4 raster=texture2D(u_image0,v_pos0);\n#ifdef LIGHTING_3D_MODE\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\nraster=apply_lighting_with_emission_ground(raster,raster.a);color=vec4(raster.rgb*antialias,antialias);\n#else\nraster=apply_lighting_ground(raster);color=vec4(raster.rgb*antialias,raster.a*antialias);\n#endif\n#else\ncolor=vec4(raster.rgb*antialias,raster.a*antialias);\n#endif\n#else\ncolor=texture2D(u_image0,v_pos0);\n#ifdef LIGHTING_3D_MODE\n#ifdef LIGHTING_3D_ALPHA_EMISSIVENESS\ncolor=apply_lighting_with_emission_ground(color,color.a);color.a=1.0;\n#else\ncolor=apply_lighting_ground(color);\n#endif\n#endif\n#endif\n#ifdef FOG\ncolor=fog_dither(fog_apply_premultiplied(color,v_fog_pos));\n#endif\ngl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_terrain.vertex.glsl"\nuniform mat4 u_proj_matrix;uniform mat4 u_normalize_matrix;uniform mat4 u_globe_matrix;uniform mat4 u_merc_matrix;uniform float u_zoom_transition;uniform vec2 u_merc_center;uniform mat3 u_grid_matrix;uniform float u_skirt_height;\n#ifdef GLOBE_POLES\nattribute vec3 a_globe_pos;attribute vec2 a_uv;\n#else\nattribute vec2 a_pos;\n#endif\nvarying vec2 v_pos0;float mercatorXfromLng(float lng) {return (180.0+lng)/360.0;}float mercatorYfromLat(float lat) {return (180.0-(RAD_TO_DEG*log(tan(QUARTER_PI+lat/2.0*DEG_TO_RAD))))/360.0;}vec3 latLngToECEF(vec2 latLng) {latLng=DEG_TO_RAD*latLng;float cosLat=cos(latLng[0]);float sinLat=sin(latLng[0]);float cosLng=cos(latLng[1]);float sinLng=sin(latLng[1]);float sx=cosLat*sinLng*GLOBE_RADIUS;float sy=-sinLat*GLOBE_RADIUS;float sz=cosLat*cosLng*GLOBE_RADIUS;return vec3(sx,sy,sz);}void main() {\n#ifdef GLOBE_POLES\nvec3 globe_pos=a_globe_pos;vec2 uv=a_uv;\n#else\nfloat tiles=u_grid_matrix[0][2];float idx=u_grid_matrix[1][2];float idy=u_grid_matrix[2][2];vec3 decomposed_pos_and_skirt=decomposeToPosAndSkirt(a_pos);vec3 latLng=u_grid_matrix*vec3(decomposed_pos_and_skirt.xy,1.0);float mercatorY=mercatorYfromLat(latLng[0]);float uvY=mercatorY*tiles-idy;float mercatorX=mercatorXfromLng(latLng[1]);float uvX=mercatorX*tiles-idx;vec3 globe_pos=latLngToECEF(latLng.xy);vec2 merc_pos=vec2(mercatorX,mercatorY);vec2 uv=vec2(uvX,uvY);\n#endif\nv_pos0=uv;vec2 tile_pos=uv*EXTENT;vec3 globe_derived_up_vector=normalize(globe_pos)*u_tile_up_scale;\n#ifdef GLOBE_POLES\nvec3 up_vector=globe_derived_up_vector;\n#else\nvec3 up_vector=elevationVector(tile_pos);\n#endif\nfloat height=elevation(tile_pos);globe_pos+=up_vector*height;\n#ifndef GLOBE_POLES\nglobe_pos-=globe_derived_up_vector*u_skirt_height*decomposed_pos_and_skirt.z;\n#endif\n#ifdef GLOBE_POLES\nvec4 interpolated_pos=u_globe_matrix*vec4(globe_pos,1.0);\n#else\nvec4 globe_world_pos=u_globe_matrix*vec4(globe_pos,1.0);vec4 merc_world_pos=vec4(0.0);if (u_zoom_transition > 0.0) {merc_world_pos=vec4(merc_pos,height-u_skirt_height*decomposed_pos_and_skirt.z,1.0);merc_world_pos.xy-=u_merc_center;merc_world_pos.x=wrap(merc_world_pos.x,-0.5,0.5);merc_world_pos=u_merc_matrix*merc_world_pos;}vec4 interpolated_pos=vec4(mix(globe_world_pos.xyz,merc_world_pos.xyz,u_zoom_transition),1.0);\n#endif\ngl_Position=u_proj_matrix*interpolated_pos;\n#ifdef FOG\nv_fog_pos=fog_position((u_normalize_matrix*vec4(globe_pos,1.0)).xyz);\n#endif\n}'),globeAtmosphere:Py('#include "_prelude_fog.fragment.glsl"\nuniform float u_transition;uniform highp float u_fadeout_range;uniform highp float u_temporal_offset;uniform vec4 u_color;uniform vec4 u_high_color;uniform vec4 u_space_color;uniform float u_horizon_angle;varying highp vec3 v_ray_dir;varying highp vec3 v_horizon_dir;void main() {highp vec3 dir=normalize(v_ray_dir);float globe_pos_dot_dir;\n#ifdef PROJECTION_GLOBE_VIEW\nglobe_pos_dot_dir=dot(u_globe_pos,dir);highp vec3 closest_point_forward=abs(globe_pos_dot_dir)*dir;float norm_dist_from_center=length(closest_point_forward-u_globe_pos)/u_globe_radius;if (norm_dist_from_center < 0.98) {\n#ifdef ALPHA_PASS\ngl_FragColor=vec4(0,0,0,0);return;\n#else\n#ifdef NATIVE\ngl_FragColor=vec4(1,1,1,1);\n#else\ngl_FragColor=vec4(0,0,0,1);\n#endif\nreturn;\n#endif\n}\n#endif\nhighp vec3 horizon_dir=normalize(v_horizon_dir);float horizon_angle_mercator=dir.y < horizon_dir.y ?\n0.0 : max(acos(clamp(dot(dir,horizon_dir),-1.0,1.0)),0.0);float horizon_angle;\n#ifdef PROJECTION_GLOBE_VIEW\nhighp vec3 closest_point=globe_pos_dot_dir*dir;highp float closest_point_to_center=length(closest_point-u_globe_pos);highp float theta=asin(clamp(closest_point_to_center/length(u_globe_pos),-1.0,1.0));horizon_angle=globe_pos_dot_dir < 0.0 ?\nPI-theta-u_horizon_angle : theta-u_horizon_angle;float angle_t=pow(u_transition,10.0);horizon_angle=mix(horizon_angle,horizon_angle_mercator,angle_t);\n#else\nhorizon_angle=horizon_angle_mercator;\n#endif\nhorizon_angle/=PI;float t=exp(-horizon_angle/u_fadeout_range);float alpha_0=u_color.a;float alpha_1=u_high_color.a;float alpha_2=u_space_color.a;vec3 color_stop_0=u_color.rgb;vec3 color_stop_1=u_high_color.rgb;vec3 color_stop_2=u_space_color.rgb;\n#ifdef ALPHA_PASS\nfloat a0=mix(alpha_2,1.0,alpha_1);float a1=mix(a0,1.0,alpha_0);float a2=mix(a0,a1,t);float a =mix(alpha_2,a2,t);gl_FragColor=vec4(1.0,1.0,1.0,a);\n#else\nvec3 c0=mix(color_stop_2,color_stop_1,alpha_1);vec3 c1=mix(c0,color_stop_0,alpha_0);vec3 c2=mix(c0,c1,t);vec3 c=c2;\n#ifndef NATIVE\nc=dither(c,gl_FragCoord.xy+u_temporal_offset);\n#endif\ngl_FragColor=vec4(c*t,t);\n#endif\n}',"attribute vec3 a_pos;attribute vec2 a_uv;uniform vec3 u_frustum_tl;uniform vec3 u_frustum_tr;uniform vec3 u_frustum_br;uniform vec3 u_frustum_bl;uniform float u_horizon;varying highp vec3 v_ray_dir;varying highp vec3 v_horizon_dir;void main() {v_ray_dir=mix(\nmix(u_frustum_tl,u_frustum_tr,a_uv.x),mix(u_frustum_bl,u_frustum_br,a_uv.x),a_uv.y);v_horizon_dir=mix(\nmix(u_frustum_tl,u_frustum_bl,u_horizon),mix(u_frustum_tr,u_frustum_br,u_horizon),a_uv.x);gl_Position=vec4(a_pos,1.0);}"),model:Py('#include "_prelude_fog.fragment.glsl"\n#include "_prelude_shadow.fragment.glsl"\n#include "_prelude_lighting.glsl"\nuniform float u_opacity;uniform vec3 u_lightcolor;uniform vec3 u_lightpos;uniform float u_lightintensity;uniform vec4 u_baseColorFactor;uniform vec4 u_emissiveFactor;uniform float u_metallicFactor;uniform float u_roughnessFactor;uniform float u_emissive_strength;varying highp vec4 v_position_height;varying lowp vec4 v_color_mix;\n#ifdef RENDER_SHADOWS\nvarying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth_shadows;\n#endif\n#pragma mapbox: define-attribute highp vec3 normal_3f\n#pragma mapbox: define-attribute highp vec3 color_3f\n#pragma mapbox: define-attribute highp vec4 color_4f\n#pragma mapbox: define-attribute highp vec2 uv_2f\n#pragma mapbox: initialize-attribute highp vec3 normal_3f\n#pragma mapbox: initialize-attribute highp vec3 color_3f\n#pragma mapbox: initialize-attribute highp vec4 color_4f\n#pragma mapbox: initialize-attribute highp vec2 uv_2f\n#ifdef HAS_ATTRIBUTE_a_pbr\nvarying lowp vec4 v_roughness_metallic_emissive_alpha;varying mediump vec4 v_height_based_emission_params;\n#endif\n#ifdef HAS_TEXTURE_u_baseColorTexture\nuniform sampler2D u_baseColorTexture;uniform bool u_baseTextureIsAlpha;uniform bool u_alphaMask;uniform float u_alphaCutoff;\n#endif\n#ifdef HAS_TEXTURE_u_metallicRoughnessTexture\nuniform sampler2D u_metallicRoughnessTexture;\n#endif\n#ifdef HAS_TEXTURE_u_occlusionTexture\nuniform sampler2D u_occlusionTexture;uniform float u_aoIntensity;\n#endif\n#ifdef HAS_TEXTURE_u_normalTexture\nuniform sampler2D u_normalTexture;\n#endif\n#ifdef HAS_TEXTURE_u_emissionTexture\nuniform sampler2D u_emissionTexture;\n#endif\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nvarying highp float v_depth;uniform sampler2D u_depthTexture;uniform vec2 u_inv_depth_size;bool isOccluded() {vec2 coord=gl_FragCoord.xy*u_inv_depth_size;highp float depth=unpack_depth(texture2D(u_depthTexture,coord));return v_depth > depth+0.0005;}\n#endif\nconst float M_PI=3.141592653589793;\n#define saturate(_x) clamp(_x,0.,1.)\nfloat calculate_NdotL(vec3 normal,vec3 lightDir) {const float ext=0.70710678118;return (clamp(dot(normal,lightDir),-ext,1.0)+ext)/(1.0+ext);}vec3 getDiffuseShadedColor(vec3 albedo,vec3 normal,vec3 lightDir,vec3 lightColor)\n{\n#ifdef LIGHTING_3D_MODE\nvec3 transformed_normal=vec3(-normal.xy,normal.z);float lighting_factor;\n#ifdef RENDER_SHADOWS\nlighting_factor=shadowed_light_factor_normal(transformed_normal,v_pos_light_view_0,v_pos_light_view_1,v_depth_shadows);\n#else\nlighting_factor=saturate(dot(transformed_normal,u_lighting_directional_dir));\n#endif\nreturn apply_lighting(albedo,transformed_normal,lighting_factor);\n#else\nvec3 n=normal;float colorvalue=((albedo.x*0.2126)+(albedo.y*0.7152))+(albedo.z*0.0722);vec3 c=vec3(0.03,0.03,0.03);float directional=clamp(dot(n,vec3(lightDir)),0.0,1.0);directional=mix(1.0-u_lightintensity,max((1.0-colorvalue)+u_lightintensity,1.0),directional);vec3 c3=c+clamp((albedo*directional)*lightColor,mix(vec3(0.0),vec3(0.3),vec3(1.0)-lightColor),vec3(1.0));return c3;\n#endif\n}vec4 getBaseColor() {vec4 albedo=u_baseColorFactor;\n#ifdef HAS_ATTRIBUTE_a_color_3f\nalbedo*=vec4(color_3f,1.0);\n#endif\n#ifdef HAS_ATTRIBUTE_a_pbr\n#else\n#ifdef HAS_ATTRIBUTE_a_color_4f\nalbedo*=color_4f;\n#endif\n#endif\n#if defined (HAS_TEXTURE_u_baseColorTexture) && defined (HAS_ATTRIBUTE_a_uv_2f)\nvec4 texColor=texture2D(u_baseColorTexture,uv_2f);if(u_alphaMask) {if (texColor.w < u_alphaCutoff) {discard;}}\n#ifdef UNPREMULT_TEXTURE_IN_SHADER\nif(texColor.w > 0.0) {texColor.rgb/=texColor.w;}texColor.w=1.0;\n#endif\ntexColor.rgb=sRGBToLinear(texColor.rgb);if(u_baseTextureIsAlpha) {if (texColor.w < 0.5) {discard;}albedo*=mix(vec4(texColor.rgb,texColor.a),vec4(texColor.a),float(u_baseTextureIsAlpha));} else {albedo*=texColor;}\n#endif\nreturn vec4(mix(albedo.rgb,v_color_mix.rgb,v_color_mix.a),albedo.a);}highp mat3 cotangentFrame(highp vec3 N,highp vec3 p,highp vec2 uv ) {\n#ifdef HAS_TEXTURE_u_normalTexture\nhighp vec3 dp1=vec3(dFdx(p.x),dFdx(p.y),dFdx(p.z));highp vec3 dp2=vec3(dFdy(p.x),dFdy(p.y),dFdy(p.z));highp vec2 duv1=vec2(dFdx(uv.x),dFdx(uv.y));highp vec2 duv2=vec2(dFdy(uv.x),dFdy(uv.y));highp vec3 dp2perp=cross( dp2,N );highp vec3 dp1perp=cross( N,dp1 );highp vec3 T=dp2perp*duv1.x+dp1perp*duv2.x;highp vec3 B=dp2perp*duv1.y+dp1perp*duv2.y;highp float lengthT=dot(T,T);highp float lengthB=dot(B,B);highp float maxLength=max(lengthT,lengthB);highp float invmax=inversesqrt( maxLength );highp mat3 res=mat3( T*invmax,B*invmax,N );return res;\n#else\nreturn mat3(1.0);\n#endif\n}highp vec3 getNormal(){highp vec3 n;\n#ifdef HAS_ATTRIBUTE_a_normal_3f\nn=normalize(normal_3f);\n#else\nhighp vec3 fdx=vec3(dFdx(v_position_height.x),dFdx(v_position_height.y),dFdx(v_position_height.z));highp vec3 fdy=vec3(dFdy(v_position_height.x),dFdy(v_position_height.y),dFdy(v_position_height.z));n=normalize(cross(fdx,fdy))*-1.0;\n#endif\n#if defined(HAS_TEXTURE_u_normalTexture) && defined(HAS_ATTRIBUTE_a_uv_2f)\nvec3 nMap=texture2D( u_normalTexture,uv_2f).xyz;nMap=normalize(2.0*nMap-vec3(1.0));highp vec3 v=normalize(-v_position_height.xyz);highp mat3 TBN=cotangentFrame(n,v,uv_2f);n=normalize(TBN*nMap);\n#endif\nreturn n;}struct Material {float perceptualRoughness;float alphaRoughness;float metallic;vec3 f90;vec4 baseColor;vec3 diffuseColor;vec3 specularColor;highp vec3 normal;};Material getPBRMaterial() {Material mat;mat.baseColor=getBaseColor();mat.perceptualRoughness=u_roughnessFactor;mat.metallic=u_metallicFactor;\n#ifdef HAS_ATTRIBUTE_a_pbr\nmat.perceptualRoughness=v_roughness_metallic_emissive_alpha.x;mat.metallic=v_roughness_metallic_emissive_alpha.y;mat.baseColor.w*=v_roughness_metallic_emissive_alpha.w;\n#endif\n#if defined(HAS_TEXTURE_u_metallicRoughnessTexture) && defined(HAS_ATTRIBUTE_a_uv_2f) \nvec4 mrSample=texture2D(u_metallicRoughnessTexture,uv_2f);mat.perceptualRoughness*=mrSample.g;mat.metallic*=mrSample.b;\n#endif\nconst float c_minRoughness=0.04;mat.perceptualRoughness=clamp(mat.perceptualRoughness,c_minRoughness,1.0);mat.metallic=saturate(mat.metallic);mat.alphaRoughness=mat.perceptualRoughness*mat.perceptualRoughness;const vec3 f0=vec3(0.04);mat.diffuseColor=mat.baseColor.rgb*(vec3(1.0)-f0);mat.diffuseColor*=1.0-mat.metallic;mat.specularColor=mix(f0,mat.baseColor.rgb,mat.metallic);highp float reflectance=max(max(mat.specularColor.r,mat.specularColor.g),mat.specularColor.b);highp float reflectance90=saturate(reflectance*25.0);mat.f90=vec3(reflectance90);mat.normal=getNormal();return mat;}float V_GGX(float NdotL,float NdotV,float roughness)\n{float a2=roughness*roughness;float GGXV=NdotL*sqrt(NdotV*NdotV*(1.0-a2)+a2);float GGXL=NdotV*sqrt(NdotL*NdotL*(1.0-a2)+a2);return 0.5/(GGXV+GGXL);}float V_GGXFast(float NdotL,float NdotV,float roughness) {float a=roughness;float GGXV=NdotL*(NdotV*(1.0-a)+a);float GGXL=NdotV*(NdotL*(1.0-a)+a);return 0.5/(GGXV+GGXL);}vec3 F_Schlick(vec3 specularColor,vec3 f90,float VdotH)\n{return specularColor+(f90-specularColor)*pow(clamp(1.0-VdotH,0.0,1.0),5.0);}vec3 F_SchlickFast(vec3 specularColor,float VdotH)\n{float x=1.0-VdotH;float x4=x*x*x*x;return specularColor+(1.0-specularColor)*x4*x;}float D_GGX(highp float NdotH,float alphaRoughness)\n{highp float a4=alphaRoughness*alphaRoughness;highp float f=(NdotH*a4-NdotH)*NdotH+1.0;return a4/(M_PI*f*f);}vec3 diffuseBurley(Material mat,float LdotH,float NdotL,float NdotV)\n{float f90=2.0*LdotH*LdotH*mat.alphaRoughness-0.5;return (mat.diffuseColor/M_PI)*(1.0+f90*pow((1.0-NdotL),5.0))*(1.0+f90*pow((1.0-NdotV),5.0));}vec3 diffuseLambertian(Material mat)\n{\n#ifdef LIGHTING_3D_MODE\nreturn mat.diffuseColor;\n#else\nreturn mat.diffuseColor/M_PI;\n#endif\n}vec3 EnvBRDFApprox(vec3 specularColor,float roughness,highp float NdotV)\n{vec4 c0=vec4(-1,-0.0275,-0.572,0.022);vec4 c1=vec4(1,0.0425,1.04,-0.04);highp vec4 r=roughness*c0+c1;highp float a004=min(r.x*r.x,exp2(-9.28*NdotV))*r.x+r.y;vec2 AB=vec2(-1.04,1.04)*a004+r.zw;return specularColor*AB.x+AB.y;}vec3 computeIndirectLightContribution(Material mat,float NdotV,vec3 normal)\n{vec3 env_light=vec3(0.65,0.65,0.65);\n#ifdef LIGHTING_3D_MODE\nfloat ambient_factor=calculate_ambient_directional_factor(normal);env_light=u_lighting_ambient_color*ambient_factor;\n#endif\nvec3 envBRDF=EnvBRDFApprox(mat.specularColor,mat.perceptualRoughness,NdotV);vec3 indirectSpecular= envBRDF*env_light;vec3 indirectDiffuse=mat.diffuseColor*env_light;return indirectSpecular+indirectDiffuse;}vec3 computeLightContribution(Material mat,vec3 lightPosition,vec3 lightColor)\n{highp vec3 n=mat.normal;highp vec3 v=normalize(-v_position_height.xyz);highp vec3 l=normalize(lightPosition);highp vec3 h=normalize(v+l);float NdotV=clamp(abs(dot(n,v)),0.001,1.0);float NdotL=saturate(dot(n,l));highp float NdotH=saturate(dot(n,h));float VdotH=saturate(dot(v,h));vec3 f=F_SchlickFast(mat.specularColor,VdotH);float g=V_GGXFast(NdotL,NdotV,mat.alphaRoughness);float d=D_GGX(NdotH,mat.alphaRoughness);vec3 diffuseTerm=(1.0-f)*diffuseLambertian(mat);vec3 specularTerm=f*g*d;vec3 transformed_normal=vec3(-n.xy,n.z);float lighting_factor;\n#ifdef RENDER_SHADOWS\nlighting_factor=shadowed_light_factor_normal(transformed_normal,v_pos_light_view_0,v_pos_light_view_1,v_depth_shadows);\n#else\nlighting_factor=NdotL;\n#endif\nvec3 directLightColor=(specularTerm+diffuseTerm)*lighting_factor*lightColor;vec3 indirectLightColor=computeIndirectLightContribution(mat,NdotV,transformed_normal);vec3 color=(saturate(directLightColor)+indirectLightColor);float intensityFactor=1.0;\n#if !defined(LIGHTING_3D_MODE)\nconst vec3 luminosityFactor=vec3(0.2126,0.7152,0.0722);float luminance=dot(diffuseTerm,luminosityFactor);intensityFactor=mix((1.0-u_lightintensity),max((1.0-luminance+u_lightintensity),1.0),NdotL);\n#endif\ncolor*=intensityFactor;return color;}void main() {\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nif (isOccluded()) {discard;}\n#endif\nvec3 lightDir=u_lightpos;vec3 lightColor=u_lightcolor;\n#ifdef LIGHTING_3D_MODE\nlightDir=u_lighting_directional_dir;lightDir.xy=-lightDir.xy;lightColor=u_lighting_directional_color;\n#endif\nvec4 finalColor;\n#ifdef DIFFUSE_SHADED\nvec3 N=getNormal();vec3 diffuse=getDiffuseShadedColor(getBaseColor().rgb,N,lightDir,lightColor);\n#ifdef HAS_TEXTURE_u_occlusionTexture\nfloat ao=(texture2D(u_occlusionTexture,uv_2f).r-1.0)*u_aoIntensity+1.0;diffuse*=ao;\n#endif\nfinalColor=vec4(diffuse,1.0)*u_opacity;\n#else\nMaterial mat=getPBRMaterial();vec3 color=computeLightContribution(mat,lightDir,lightColor);\n#if defined (HAS_TEXTURE_u_occlusionTexture) && defined(HAS_ATTRIBUTE_a_uv_2f)\nfloat ao=(texture2D(u_occlusionTexture,uv_2f).x-1.0)*u_aoIntensity+1.0;color*=ao;\n#endif\nvec4 emissive=u_emissiveFactor;\n#if defined(HAS_TEXTURE_u_emissionTexture) && defined(HAS_ATTRIBUTE_a_uv_2f)\nemissive.rgb*=sRGBToLinear(texture2D(u_emissionTexture,uv_2f).rgb);\n#endif\ncolor+=emissive.rgb;float opacity=mat.baseColor.w*u_opacity;\n#ifdef HAS_ATTRIBUTE_a_pbr\nfloat resEmission=v_roughness_metallic_emissive_alpha.z;resEmission*=v_height_based_emission_params.z+v_height_based_emission_params.w*pow(clamp(v_height_based_emission_params.x,0.0,1.0),v_height_based_emission_params.y);color=mix(color,v_color_mix.rgb,min(1.0,resEmission));\n#ifdef HAS_ATTRIBUTE_a_color_4f\nfloat distance=length(vec2(1.3*max(0.0,abs(color_4f.x)-color_4f.z),color_4f.y));distance+= mix(0.5,0.0,clamp(resEmission-1.0,0.0,1.0));opacity*=v_roughness_metallic_emissive_alpha.w*saturate(1.0-distance*distance);\n#endif\n#endif\ncolor=mix(color,mat.baseColor.rgb,u_emissive_strength);color=linearTosRGB(color);color*=opacity;finalColor=vec4(color,opacity);\n#endif\n#ifdef FOG\nfinalColor=fog_dither(fog_apply_premultiplied(finalColor,v_fog_pos,v_position_height.w));\n#endif\n#ifdef RENDER_CUTOFF\nfinalColor*=v_cutoff_opacity;\n#endif\n#ifdef INDICATOR_CUTOUT\nfinalColor=applyCutout(finalColor);\n#endif\ngl_FragColor=finalColor;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nHANDLE_WIREFRAME_DEBUG;}','#include "_prelude_fog.vertex.glsl"\n#include "_prelude_shadow.vertex.glsl"\nattribute vec3 a_pos_3f;\n#pragma mapbox: define-attribute highp vec3 normal_3f\n#pragma mapbox: define-attribute highp vec2 uv_2f\n#pragma mapbox: define-attribute highp vec3 color_3f\n#pragma mapbox: define-attribute highp vec4 color_4f\n#pragma mapbox: define-attribute-vertex-shader-only highp vec4 pbr\n#pragma mapbox: define-attribute-vertex-shader-only highp vec3 heightBasedEmissiveStrength\nuniform mat4 u_matrix;uniform mat4 u_lighting_matrix;uniform vec3 u_camera_pos;uniform vec4 u_color_mix;\n#ifdef INSTANCED_ARRAYS\nattribute vec4 a_normal_matrix0;attribute vec4 a_normal_matrix1;attribute vec4 a_normal_matrix2;attribute vec4 a_normal_matrix3;\n#else\nuniform highp mat4 u_normal_matrix;\n#endif\n#ifdef RENDER_SHADOWS\nuniform mat4 u_light_matrix_0;uniform mat4 u_light_matrix_1;varying vec4 v_pos_light_view_0;varying vec4 v_pos_light_view_1;varying float v_depth_shadows;\n#endif\nvarying vec4 v_position_height;varying lowp vec4 v_color_mix;\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nvarying highp float v_depth;\n#endif\n#ifdef HAS_ATTRIBUTE_a_pbr\nvarying lowp vec4 v_roughness_metallic_emissive_alpha;varying mediump vec4 v_height_based_emission_params;\n#endif\nvoid main() {\n#pragma mapbox: initialize-attribute highp vec3 normal_3f\n#pragma mapbox: initialize-attribute highp vec2 uv_2f\n#pragma mapbox: initialize-attribute highp vec3 color_3f\n#pragma mapbox: initialize-attribute highp vec4 color_4f\n#pragma mapbox: initialize-attribute-custom highp vec4 pbr\n#pragma mapbox: initialize-attribute-custom highp vec3 heightBasedEmissiveStrength\nhighp mat4 normal_matrix;\n#ifdef INSTANCED_ARRAYS\nnormal_matrix=mat4(a_normal_matrix0,a_normal_matrix1,a_normal_matrix2,a_normal_matrix3);\n#else\nnormal_matrix=u_normal_matrix;\n#endif\nvec3 local_pos;mat3 rs;\n#ifdef MODEL_POSITION_ON_GPU\nvec3 pos_color=normal_matrix[0].xyz;vec4 translate=normal_matrix[1];vec3 pos_a=floor(pos_color);vec3 rgb=1.05*(pos_color-pos_a);float color_mix=pos_a.z/100.0;v_color_mix=vec4(sRGBToLinear(rgb),color_mix);float meter_to_tile=normal_matrix[0].w;vec4 pos=vec4(pos_a.xy,translate.z,1.0);rs[0].x=normal_matrix[1].w;rs[0].yz=normal_matrix[2].xy;rs[1].xy=normal_matrix[2].zw;rs[1].z=normal_matrix[3].x;rs[2].xyz=normal_matrix[3].yzw;vec4 pos_node=u_lighting_matrix*vec4(a_pos_3f,1.0);vec3 rotated_pos_node=rs*pos_node.xyz;vec3 pos_model_tile=(rotated_pos_node+vec3(translate.xy,0.0))*vec3(meter_to_tile,meter_to_tile,1.0);pos.xyz+=pos_model_tile;local_pos=pos.xyz;gl_Position=u_matrix*pos;pos.z*=meter_to_tile;v_position_height.xyz=pos.xyz-u_camera_pos;\n#else\nlocal_pos=a_pos_3f;gl_Position=u_matrix*vec4(a_pos_3f,1);v_position_height.xyz=vec3(u_lighting_matrix*vec4(a_pos_3f,1));v_color_mix=vec4(sRGBToLinear(u_color_mix.rgb),u_color_mix.a);\n#endif\nv_position_height.w=a_pos_3f.z;\n#ifdef HAS_ATTRIBUTE_a_pbr\nvec4 albedo_c=decode_color(pbr.xy);vec2 e_r_m=unpack_float(pbr.z);vec2 r_m= unpack_float(e_r_m.y*16.0);r_m.r=r_m.r*16.0;v_color_mix=vec4(albedo_c.rgb,1.0);v_roughness_metallic_emissive_alpha=vec4(vec3(r_m,e_r_m.x)/255.0,albedo_c.a);v_roughness_metallic_emissive_alpha.z*=2.0;float heightBasedRelativeIntepolation=a_pos_3f.z*heightBasedEmissiveStrength.x+heightBasedEmissiveStrength.y;v_height_based_emission_params.x=heightBasedRelativeIntepolation;v_height_based_emission_params.y=heightBasedEmissiveStrength.z;vec2 emissionMultiplierValues=unpack_float(pbr.w)/256.0;v_height_based_emission_params.z=emissionMultiplierValues.x;v_height_based_emission_params.w=emissionMultiplierValues.y-emissionMultiplierValues.x;\n#endif\n#ifdef FOG\nv_fog_pos=fog_position(local_pos);\n#endif\n#ifdef RENDER_CUTOFF\nv_cutoff_opacity=cutoff_opacity(u_cutoff_params,gl_Position.z);\n#endif\n#ifdef TERRAIN_FRAGMENT_OCCLUSION\nv_depth=gl_Position.z/gl_Position.w;\n#endif\n#ifdef HAS_ATTRIBUTE_a_normal_3f\n#ifdef MODEL_POSITION_ON_GPU\nfloat x_squared_scale=dot(rs[0],rs[0]);float y_squared_scale=dot(rs[1],rs[1]);float z_squared_scale=dot(rs[2],rs[2]);vec3 squared_scale=vec3(x_squared_scale,y_squared_scale,z_squared_scale);normal_3f=rs*((u_lighting_matrix*vec4(normal_3f,0.0)).xyz/squared_scale);normal_3f=normalize(normal_3f);\n#else\nnormal_3f=vec3(normal_matrix*vec4(normal_3f,0));\n#endif\n#endif\n#ifdef HAS_ATTRIBUTE_a_pbr\n#ifdef HAS_ATTRIBUTE_a_color_4f\nv_roughness_metallic_emissive_alpha.w=clamp(color_4f.a*v_roughness_metallic_emissive_alpha.w*(v_roughness_metallic_emissive_alpha.z-1.0),0.0,1.0);\n#endif\n#endif\n#ifdef RENDER_SHADOWS\nvec3 shadow_pos=local_pos;\n#ifdef NORMAL_OFFSET\n#ifdef HAS_ATTRIBUTE_a_normal_3f\n#ifdef MODEL_POSITION_ON_GPU\nvec3 offset=shadow_normal_offset(vec3(-normal_3f.xy,normal_3f.z));shadow_pos+=offset*shadow_normal_offset_multiplier0();\n#else\nvec3 offset=shadow_normal_offset_model(normalize(normal_3f));shadow_pos+=offset*shadow_normal_offset_multiplier0();\n#endif\n#endif\n#endif\nv_pos_light_view_0=u_light_matrix_0*vec4(shadow_pos,1);v_pos_light_view_1=u_light_matrix_1*vec4(shadow_pos,1);v_depth_shadows=gl_Position.w;\n#endif\n}'),modelDepth:Py("varying highp float v_depth;void main() {\n#ifndef DEPTH_TEXTURE\ngl_FragColor=pack_depth(v_depth);\n#endif\n}","attribute vec3 a_pos_3f;uniform mat4 u_matrix;varying highp float v_depth;\n#ifdef MODEL_POSITION_ON_GPU\n#ifdef INSTANCED_ARRAYS\nattribute vec4 a_normal_matrix0;attribute vec4 a_normal_matrix1;attribute vec4 a_normal_matrix2;attribute vec4 a_normal_matrix3;\n#else\nuniform highp mat4 u_instance;\n#endif\nuniform highp mat4 u_node_matrix;\n#endif\nvoid main() {\n#ifdef MODEL_POSITION_ON_GPU\nhighp mat4 instance;\n#ifdef INSTANCED_ARRAYS\ninstance=mat4(a_normal_matrix0,a_normal_matrix1,a_normal_matrix2,a_normal_matrix3);\n#else\ninstance=u_instance;\n#endif\nvec3 pos_color=instance[0].xyz;vec4 translate=instance[1];vec3 pos_a=floor(pos_color);float meter_to_tile=instance[0].w;vec4 pos=vec4(pos_a.xy,translate.z,1.0);mat3 rs;rs[0].x=instance[1].w;rs[0].yz=instance[2].xy;rs[1].xy=instance[2].zw;rs[1].z=instance[3].x;rs[2].xyz=instance[3].yzw;vec4 pos_node=u_node_matrix*vec4(a_pos_3f,1.0);vec3 rotated_pos_node=rs*pos_node.xyz;vec3 pos_model_tile=(rotated_pos_node+vec3(translate.xy,0.0))*vec3(meter_to_tile,meter_to_tile,1.0);pos.xyz+=pos_model_tile;gl_Position=u_matrix*pos;\n#else\ngl_Position=u_matrix*vec4(a_pos_3f,1);\n#endif\nv_depth=gl_Position.z/gl_Position.w;}"),stars:Py("varying highp vec2 v_uv;varying mediump float v_intensity;float shapeCircle(in vec2 uv)\n{float beginFade=0.6;float lengthFromCenter=length(v_uv);return 1.0-clamp((lengthFromCenter-beginFade)/(1.0-beginFade),0.0,1.0);}void main() {float alpha=shapeCircle(v_uv);vec3 color=vec3(1.0,1.0,1.0);alpha*=v_intensity;gl_FragColor=vec4(color*alpha,alpha);HANDLE_WIREFRAME_DEBUG;}","\nattribute vec3 a_pos_3f;attribute vec2 a_uv;attribute float a_size_scale;attribute float a_fade_opacity;uniform mat4 u_matrix;uniform vec3 u_up;uniform vec3 u_right;uniform float u_intensity_multiplier;varying highp vec2 v_uv;varying mediump float v_intensity;void main() {v_uv=a_uv;v_intensity=a_fade_opacity*u_intensity_multiplier;vec3 pos=a_pos_3f;pos+=a_uv.x*u_right*a_size_scale;pos+=a_uv.y*u_up*a_size_scale;gl_Position=u_matrix*vec4(pos,1.0);}")};function Dy(e,t){const i=e.replace(/\s*\/\/[^\n]*\n/g,"\n").split("\n");for(let e of i)if(e=e.trim(),"#"===e[0]&&e.includes("if")&&!e.includes("endif")){e=e.replace("#","").replace(/ifdef|ifndef|elif|if/g,"").replace(/!|defined|\(|\)|\|\||&&/g,"").replace(/\s+/g," ").trim();const i=e.split(" ");for(const e of i)t.includes(e)||t.push(e)}}function Py(e,t){const i=/#include\s+"([^"]+)"/g,r=/#pragma mapbox: ([\w\-]+) ([\w]+) ([\w]+) ([\w]+)/g;let n=t.match(/attribute(\S*) (highp |mediump |lowp )?([\w]+) ([\w]+)/g);n&&(n=n.filter(((e,t)=>n.indexOf(e)===t)));const o={},a=[],s=[];e=e.replace(i,((e,t)=>(s.push(t),""))),t=t.replace(i,((e,t)=>(a.push(t),"")));let l=[...Ey];Dy(e,l),Dy(t,l);for(const e of[...a,...s])My[e]||console.error(`Undefined include: ${e}`),Sy[e]||(Sy[e]=[],Dy(My[e],Sy[e])),l=[...l,...Sy[e]];return{fragmentSource:e=e.replace(r,((e,t,i,r,n)=>(o[n]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nvarying ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"initialize"===t?`\n#ifdef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define-attribute"===t?`\n#ifdef HAS_ATTRIBUTE_a_${n}\n    varying ${i} ${r} ${n};\n#endif\n`:"initialize-attribute"===t?"":void 0))),vertexSource:t=t.replace(r,((e,t,i,r,n)=>{const a="float"===r?"vec2":r,s=n.match(/color/)?"color":a;return"define-attribute-vertex-shader-only"===t?`\n#ifdef HAS_ATTRIBUTE_a_${n}\nattribute ${i} ${r} a_${n};\n#endif\n`:o[n]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nattribute ${i} ${a} a_${n};\nvarying ${i} ${r} ${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"initialize"===t?"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${n} = unpack_mix_${s}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:"define-attribute"===t?`\n#ifdef HAS_ATTRIBUTE_a_${n}\n    attribute ${i} ${r} a_${n};\n    varying ${i} ${r} ${n};\n#endif\n`:"initialize-attribute"===t?`\n#ifdef HAS_ATTRIBUTE_a_${n}\n    ${n} = a_${n};\n#endif\n`:void 0:"define"===t?`\n#ifndef HAS_UNIFORM_u_${n}\nuniform lowp float u_${n}_t;\nattribute ${i} ${a} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"define-instanced"===t?"mat4"===s?`\n#ifdef INSTANCED_ARRAYS\nattribute vec4 a_${n}0;\nattribute vec4 a_${n}1;\nattribute vec4 a_${n}2;\nattribute vec4 a_${n}3;\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:`\n#ifdef INSTANCED_ARRAYS\nattribute ${i} ${a} a_${n};\n#else\nuniform ${i} ${r} u_${n};\n#endif\n`:"initialize-attribute-custom"===t?`\n#ifdef HAS_ATTRIBUTE_a_${n}\n    ${i} ${r} ${n} = a_${n};\n#endif\n`:"vec4"===s?`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = a_${n};\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${n}\n    ${i} ${r} ${n} = unpack_mix_${s}(a_${n}, u_${n}_t);\n#else\n    ${i} ${r} ${n} = u_${n};\n#endif\n`})),staticAttributes:n,usedDefines:l,vertexIncludes:a,fragmentIncludes:s}}class VertexArrayObject{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffers=[],this.vao=null}bind(e,t,i,r,n,o,a,s){this.context=e;let l=this.boundPaintVertexBuffers.length!==r.length;for(let e=0;!l&&e<r.length;e++)this.boundPaintVertexBuffers[e]!==r[e]&&(l=!0);let c=this.boundDynamicVertexBuffers.length!==a.length;for(let e=0;!c&&e<a.length;e++)this.boundDynamicVertexBuffers[e]!==a[e]&&(c=!0);if(!this.vao||this.boundProgram!==t||this.boundLayoutVertexBuffer!==i||l||c||this.boundIndexBuffer!==n||this.boundVertexOffset!==o)this.freshBind(t,i,r,n,o,a,s);else{e.bindVertexArrayOES.set(this.vao);for(const i of a)i&&(i.bind(),s&&i.instanceCount&&i.setVertexAttribDivisor(e.gl,t,s));n&&n.dynamicDraw&&n.bind()}}freshBind(e,t,i,r,n,o,a){const s=e.numAttributes,l=this.context,c=l.gl;this.vao&&this.destroy(),this.vao=l.gl.createVertexArray(),l.bindVertexArrayOES.set(this.vao),this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=r,this.boundVertexOffset=n,this.boundDynamicVertexBuffers=o,t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,n);for(const t of i)t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,n);for(const t of o)t&&(t.enableAttributes(c,e),t.bind(),t.setVertexAttribPointers(c,e,n),a&&t.instanceCount&&t.setVertexAttribDivisor(c,e,a));r&&r.bind(),l.currentNumAttributes=s}destroy(){this.vao&&(this.context.gl.deleteVertexArray(this.vao),this.vao=null)}}function Ly(e,t){const i=Math.pow(2,t.canonical.z),r=t.canonical.y;return[new MercatorCoordinate(0,r/i).toLngLat().lat,new MercatorCoordinate(0,(r+1)/i).toLngLat().lat]}function zy(e,t,i,r,n,o,a){const s=e.context,l=s.gl,c=i.hillshadeFBO;if(!c)return;e.prepareDrawTile();const u=e.isTileAffectedByFog(t),h=e.getOrCreateProgram("hillshade",{overrideFog:u});s.activeTexture.set(l.TEXTURE0),l.bindTexture(l.TEXTURE_2D,c.colorAttachment.get());const d=((e,t,i,r)=>{const n=i.paint.get("hillshade-shadow-color"),o=i.paint.get("hillshade-highlight-color"),a=i.paint.get("hillshade-accent-color"),s=i.paint.get("hillshade-emissive-strength");let l=b(i.paint.get("hillshade-illumination-direction"));if("viewport"===i.paint.get("hillshade-illumination-anchor"))l-=e.transform.angle;else if(e.style&&e.style.enable3dLights()&&e.style.directionalLight){const t=e.style.directionalLight.properties.get("direction");l=b(Y(t.x,t.y,t.z)[1])}const c=!e.options.moving;return{u_matrix:r||e.transform.calculateProjMatrix(t.tileID.toUnwrapped(),c),u_image:0,u_latrange:Ly(0,t.tileID),u_light:[i.paint.get("hillshade-exaggeration"),l],u_shadow:n,u_highlight:o,u_emissive_strength:s,u_accent:a}})(e,i,r,e.terrain?t.projMatrix:null);e.uploadCommonUniforms(s,h,t.toUnwrapped());const{tileBoundsBuffer:p,tileBoundsIndexBuffer:f,tileBoundsSegments:m}=e.getTileBoundsBuffers(i);h.draw(e,l.TRIANGLES,n,o,a,CullFaceMode.disabled,d,r.id,p,f,m)}function Ry(e,t,i){if(!t.needsDEMTextureUpload)return;const r=e.context,n=r.gl;r.pixelStoreUnpackPremultiplyAlpha.set(!1),t.demTexture=t.demTexture||e.getTileTexture(i.stride);const o=i.getPixels();t.demTexture?t.demTexture.update(o,{premultiply:!1}):t.demTexture=new Texture(r,o,e.terrainUseFloatDEM()?n.R32F:n.RGBA,{premultiply:!1}),t.needsDEMTextureUpload=!1}function ky(e,t,i){const r=e.context,n=r.gl;if(!t.dem)return;const o=t.dem;if(r.activeTexture.set(n.TEXTURE1),Ry(e,t,o),!t.demTexture)return;t.demTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE);const a=o.dim;r.activeTexture.set(n.TEXTURE0);let s=t.hillshadeFBO;if(!s){const e=new Texture(r,{width:a,height:a,data:null},n.RGBA);e.bind(n.LINEAR,n.CLAMP_TO_EDGE),s=t.hillshadeFBO=r.createFramebuffer(a,a,!0,"renderbuffer"),s.colorAttachment.set(e.texture)}r.bindFramebuffer.set(s.framebuffer),r.viewport.set([0,0,a,a]);const{tileBoundsBuffer:l,tileBoundsIndexBuffer:c,tileBoundsSegments:u}=e.getMercatorTileBoundsBuffers(),h=[];e.terrainUseFloatDEM()&&h.push("TERRAIN_DEM_FLOAT_FORMAT"),e.getOrCreateProgram("hillshadePrepare",{defines:h}).draw(e,n.TRIANGLES,DepthMode.disabled,StencilMode.disabled,ColorMode.unblended,CullFaceMode.disabled,((e,t)=>{const i=t.stride,r=ic.create();return ic.ortho(r,0,Ri,-Ri,0,0,1),ic.translate(r,r,[0,-Ri,0]),{u_matrix:r,u_image:1,u_dimension:[i,i],u_zoom:e.overscaledZ,u_unpack:t.unpackVector}})(t.tileID,o),i.id,l,c,u),t.needsHillshadePrepare=!1}const By=e=>({u_matrix:new UniformMatrix4f(e),u_image0:new Uniform1i(e),u_skirt_height:new Uniform1f(e),u_ground_shadow_factor:new Uniform3f(e)}),Oy=(e,t,i)=>({u_matrix:e,u_image0:0,u_skirt_height:t,u_ground_shadow_factor:i}),Fy=(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f)=>({u_proj_matrix:Float32Array.from(e),u_globe_matrix:t,u_normalize_matrix:Float32Array.from(r),u_merc_matrix:i,u_zoom_transition:n,u_merc_center:o,u_image0:0,u_frustum_tl:a,u_frustum_tr:s,u_frustum_br:l,u_frustum_bl:c,u_globe_pos:u,u_globe_radius:h,u_viewport:d,u_grid_matrix:f?Float32Array.from(f):new Float32Array(9),u_skirt_height:p}),Uy=(e,t)=>{if(t>0&&e.terrain&&$("Cutoff is currently disabled on terrain"),t<=0||e.terrain)return{shouldRenderCutoff:!1,uniformValues:{u_cutoff_params:[0,0,0,0]}};const i=e.transform,r=Math.max(Math.abs(i._zoom-(e.minCutoffZoom-1)),1),n=i.isLODDisabled(!1)?D(60,45,i.pitch):D(30,15,i.pitch),o=i._farZ-i._nearZ,a=t*i.height,s=((1-(l=n))*(.75*i.cameraToCenterDistance)+l*(i._farZ+a))*r;var l;return{shouldRenderCutoff:n<1,uniformValues:{u_cutoff_params:[i._nearZ,i._farZ,(s-i._nearZ)/o,(s-a-i._nearZ)/o]}}};function Vy(e,t){return null!=e&&null!=t&&!(!e.hasData()||!t.hasData())&&null!=e.demTexture&&null!=t.demTexture&&e.tileID.key!==t.tileID.key}const Ny=new class VertexMorphing{constructor(){this.operations={}}newMorphing(e,t,i,r,n){if(e in this.operations){const t=this.operations[e];t.to.tileID.key!==i.tileID.key&&(t.queued=i)}else this.operations[e]={startTime:r,phase:0,duration:n,from:t,to:i,queued:null}}getMorphValuesForProxy(e){if(!(e in this.operations))return null;const t=this.operations[e];return{from:t.from,to:t.to,phase:t.phase}}update(e){for(const t in this.operations){const i=this.operations[t];for(i.phase=(e-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,e)){delete this.operations[t];break}}}_nextOp(e,t){return!!e.queued&&(e.from=e.to,e.to=e.queued,e.queued=null,e.phase=0,e.startTime=t,!0)}_validOp(e){return e.from.hasData()&&e.to.hasData()}},jy={0:null,1:"TERRAIN_VERTEX_MORPHING"};function Gy(e,t,i){if(0===t)return 0;const r=t<1&&514===i?.25/t:1;return 6*Math.pow(1.5,22-e)*Math.max(t,1)*r}function qy(e,t){const i=1<<e.z;return!t&&(0===e.x||e.x===i-1)||0===e.y||e.y===i-1}const Zy=e=>({u_matrix:e});function $y(e,t,i,r,n){if(n>0){const o=rt.now(),a=(o-e.timeAdded)/n,s=t?(o-t.timeAdded)/n:-1,l=i.getSource(),c=r.coveringZoomLevel({tileSize:l.tileSize,roundZoom:l.roundZoom}),u=!t||Math.abs(t.tileID.overscaledZ-c)>Math.abs(e.tileID.overscaledZ-c),h=u&&e.refreshedUponExpiration?1:I(u?a:1-s,0,1);return e.refreshedUponExpiration&&a>=1&&(e.refreshedUponExpiration=!1),t?{opacity:1,mix:1-h}:{opacity:h,mix:0}}return{opacity:1,mix:0}}class MockSourceCache extends SourceCache{constructor(e){const t={type:"raster-dem",maxzoom:e.transform.maxZoom},i=new Dispatcher(rg(),null),r=Lg("mock-dem",t,i,e.style);super("mock-dem",r,!1),r.setEventedParent(this),this._sourceLoaded=!0}_loadTile(e,t){e.state="loaded",t(null)}}class ProxySourceCache extends SourceCache{constructor(e){const t=Lg("proxy",{type:"geojson",maxzoom:e.transform.maxZoom},new Dispatcher(rg(),null),e.style);super("proxy",t,!1),t.setEventedParent(this),this.map=this.getSource().map=e,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={}}update(e,t,i){if(e.freezeTileCoverage)return;this.transform=e;const r=e.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled}).reduce(((t,i)=>{if(t[i.key]="",!this._tiles[i.key]){const t=new Tile(i,this._source.tileSize*i.overscaleFactor(),e.tileZoom);t.state="loaded",this._tiles[i.key]=t}return t}),{});for(const e in this._tiles)e in r||(this.freeFBO(e),this._tiles[e].unloadVectorData(),delete this._tiles[e])}freeFBO(e){const t=this.proxyCachedFBO[e];if(void 0!==t){const i=Object.values(t);this.renderCachePool.push(...i),delete this.proxyCachedFBO[e]}}deallocRenderCache(){this.renderCache.forEach((e=>e.fb.destroy())),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={}}}class ProxiedTileID extends OverscaledTileID{constructor(e,t,i){super(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y),this.proxyTileKey=t,this.projMatrix=i}}class Terrain extends Elevation{constructor(e,t){super(),this.painter=e,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[i,r,n]=function(e){const t=new StructArrayLayout2i4,i=new StructArrayLayout3ui6,r=131;t.reserve(17161),i.reserve(33800);const n=Ri/128,o=Ri+n/2,a=o+n;for(let e=-n;e<a;e+=n)for(let i=-n;i<a;i+=n){const r=i<0||i>o||e<0||e>o?24575:0,n=I(Math.round(i),0,Ri),a=I(Math.round(e),0,Ri);t.emplaceBack(n+r,a)}const s=(e,t)=>{const n=t*r+e;i.emplaceBack(n+1,n,n+r),i.emplaceBack(n+r,n+r+1,n+1)};for(let e=1;e<129;e++)for(let t=1;t<129;t++)s(t,e);return[0,129].forEach((e=>{for(let t=0;t<130;t++)s(t,e),s(e,t)})),[t,i,32768]}(),o=e.context;this.gridBuffer=o.createVertexBuffer(i,mc.members),this.gridIndexBuffer=o.createIndexBuffer(r),this.gridSegments=SegmentVector.simpleSegment(0,0,i.length,r.length),this.gridNoSkirtSegments=SegmentVector.simpleSegment(0,0,i.length,n),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._drapedRenderBatches=[],this._sourceTilesOverlap={},this.proxySourceCache=new ProxySourceCache(t.map),this.orthoMatrix=ic.create(),ic.ortho(this.orthoMatrix,"globe"===this.painter.transform.projection.name?.015:0,Ri,0,Ri,0,1);const a=o.gl;this._overlapStencilMode=new StencilMode({func:a.GEQUAL,mask:255},0,255,a.KEEP,a.KEEP,a.REPLACE),this._previousZoom=e.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=t,this._useVertexMorphing=!0,this._exaggeration=1,this._mockSourceCache=new MockSourceCache(t.map),this._pendingGroundEffectLayers=[]}set style(e){e.on("data",this._onStyleDataEvent.bind(this)),this._style=e,this._style.map.on("moveend",(()=>{this._clearLineLayersFromRenderCache()}))}update(e,t,i){if(e&&e.terrain){this._style!==e&&(this.style=e,this._evaluationZoom=void 0);const r=e.terrain.properties,n=0===e.terrain.drapeRenderMode,o=e.terrain.isZoomDependent();this._previousUpdateTimestamp=this.enabled?this._updateTimestamp:void 0,this._updateTimestamp=rt.now();const a=e.terrain&&e.terrain.scope,s=r.get("source"),l=n?this._mockSourceCache:e.getSourceCache(s,a);if(!l)return void $(`Couldn't find terrain source "${s}".`);if(this.sourceCache=l,this._exaggeration=o?this.calculateExaggeration(t):r.get("exaggeration"),!t.projection.requiresDraping&&o&&0===this._exaggeration)return void this._disable();this.enabled=!0;const c=()=>{this.sourceCache.used&&$(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\nThis leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.`);const e=this.getScaledDemTileSize();this.sourceCache.update(t,e,!0),this.resetTileLookupCache(this.sourceCache.id)};this.sourceCache.usedForTerrain||(this.resetTileLookupCache(this.sourceCache.id),this.sourceCache.usedForTerrain=!0,c(),this._initializing=!0),c(),t.updateElevation(!0,i),this.resetTileLookupCache(this.proxySourceCache.id),this.proxySourceCache.update(t),this._emptyDEMTextureDirty=!0,this._previousZoom=t.zoom}else this._disable()}calculateExaggeration(e){const t=this._previousCameraAltitude,i=e.getFreeCameraOptions().position.z/e.pixelsPerMeter*e.worldSize;this._previousCameraAltitude=i;const r=null!=t?i-t:Number.MAX_VALUE;if(Math.abs(r)<2)return this._exaggeration;const n=e.zoom,o=this._style.terrain;if(!this._previousUpdateTimestamp)return o.getExaggeration(n);let a=n-this._previousZoom;const s=this._previousUpdateTimestamp;let l=n;null!=this._evaluationZoom&&(l=this._evaluationZoom,Math.abs(n-l)>.5&&(a=.5*(n-l+a)),a*r<0&&(l+=a)),this._evaluationZoom=l;const c=o.getExaggeration(l),u=c===o.getExaggeration(Math.max(0,l-.1));if(u&&Math.abs(c-this._exaggeration)<.01)return c;let h=Math.min(.1,.00375*(this._updateTimestamp-s));return(u||c<.1||Math.abs(a)<1e-4)&&(h=Math.min(.2,4*h)),yr(this._exaggeration,c,h)}resetTileLookupCache(e){this._findCoveringTileCache[e]={}}getScaledDemTileSize(){return this.sourceCache.getSource().tileSize/128*this.proxySourceCache.getSource().tileSize}_onStyleDataEvent(e){e.coord&&"source"===e.dataType?this._clearRenderCacheForTile(e.sourceCacheId,e.coord):"style"===e.dataType&&(this.invalidateRenderCache=!0,this._evaluationZoom=void 0,this._previousUpdateTimestamp=void 0,this._previousCameraAltitude=void 0)}_disable(){if(this.enabled&&(this.enabled=!1,this._sharedDepthStencil=void 0,this._evaluationZoom=void 0,this._previousUpdateTimestamp=void 0,this.proxySourceCache.deallocRenderCache(),this._style))for(const e in this._style._mergedSourceCaches)this._style._mergedSourceCaches[e].usedForTerrain=!1}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this._emptyDepthBufferTexture&&this._emptyDepthBufferTexture.destroy(),this.pool.forEach((e=>e.fb.destroy())),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),this._depthFBO=void 0,this._depthTexture=void 0),this.framebufferCopyTexture&&this.framebufferCopyTexture.destroy()}_source(){return this.enabled?this.sourceCache:null}isUsingMockSource(){return this.sourceCache===this._mockSourceCache}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const e=2*this.proxySourceCache.getSource().tileSize;return[e,e]}set useVertexMorphing(e){this._useVertexMorphing=e}updateTileBinding(e){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const t=this.proxySourceCache,i=this.painter.transform;this._initializing&&(this._initializing=0===i._centerAltitude&&-1===this.getAtPointOrZero(MercatorCoordinate.fromLngLat(i.center),-1),this._emptyDEMTextureDirty=!this._initializing);const r=this.proxyCoords=t.getIds().map((e=>{const r=t.getTileByID(e).tileID;return r.projMatrix=i.calculateProjMatrix(r.toUnwrapped()),r}));!function(e,t){const i=t.transform.pointCoordinate(t.transform.getCameraPoint()),r=new g(i.x,i.y);e.sort(((e,t)=>{if(t.overscaledZ-e.overscaledZ)return t.overscaledZ-e.overscaledZ;const i=new g(e.canonical.x+(1<<e.canonical.z)*e.wrap,e.canonical.y),n=new g(t.canonical.x+(1<<t.canonical.z)*t.wrap,t.canonical.y),o=r.mult(1<<e.canonical.z);return o.x-=.5,o.y-=.5,o.distSqr(i)-o.distSqr(n)}))}(r,this.painter);const n=this.proxyToSource||{};this.proxyToSource={},r.forEach((e=>{this.proxyToSource[e.key]={}})),this.terrainTileForTile={};const o=this._style._mergedSourceCaches;for(const t in o){const i=o[t];if(!i.used)continue;if(i!==this.sourceCache&&this.resetTileLookupCache(i.id),this._setupProxiedCoordsForOrtho(i,e[t],n),i.usedForTerrain)continue;const r=e[t];i.getSource().reparseOverscaled&&this._assignTerrainTiles(r)}this.proxiedCoords[t.id]=r.map((e=>new ProxiedTileID(e,e.key,this.orthoMatrix))),this._assignTerrainTiles(r),this._prepareDEMTextures(),this._setupDrapedRenderBatches(),this._initFBOPool(),this._setupRenderCache(n),this.renderingToTexture=!1;const a={};this._visibleDemTiles=[];for(const e of this.proxyCoords){const t=this.terrainTileForTile[e.key];if(!t)continue;const i=t.tileID.key;i in a||(this._visibleDemTiles.push(t),a[i]=i)}}_assignTerrainTiles(e){this._initializing||e.forEach((e=>{if(this.terrainTileForTile[e.key])return;const t=this._findTileCoveringTileID(e,this.sourceCache);t&&(this.terrainTileForTile[e.key]=t)}))}_prepareDEMTextures(){const e=this.painter.context,t=e.gl;for(const i in this.terrainTileForTile){const r=this.terrainTileForTile[i],n=r.dem;!n||r.demTexture&&!r.needsDEMTextureUpload||(e.activeTexture.set(t.TEXTURE1),Ry(this.painter,r,n))}}_prepareDemTileUniforms(e,t,i,r){if(!t||null==t.demTexture)return!1;const n=e.tileID.canonical,o=Math.pow(2,t.tileID.canonical.z-n.z),a=r||"";return i[`u_dem_tl${a}`]=[n.x*o%1,n.y*o%1],i[`u_dem_scale${a}`]=o,!0}get emptyDEMTexture(){return!this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}get emptyDepthBufferTexture(){const e=this.painter.context,t=e.gl;if(!this._emptyDepthBufferTexture){const i=new RGBAImage({width:1,height:1},Uint8Array.of(255,255,255,255));this._emptyDepthBufferTexture=new Texture(e,i,t.RGBA,{premultiply:!1})}return this._emptyDepthBufferTexture}_getLoadedAreaMinimum(){let e=0;const t=this._visibleDemTiles.reduce(((t,i)=>{if(!i.dem)return t;const r=i.dem.tree.minimums[0];return r>0&&e++,t+r}),0);return e?t/e:0}_updateEmptyDEMTexture(){const e=this.painter.context,t=e.gl;e.activeTexture.set(t.TEXTURE2);const i=this._getLoadedAreaMinimum(),[r,n]=(()=>{if(this.painter.terrainUseFloatDEM()){const e=new Float32Image({width:1,height:1},new Float32Array([i]));return[t.R32F,e]}{const e=new RGBAImage({width:1,height:1},new Uint8Array(DEMData.pack(i,this.sourceCache.getSource().encoding)));return[t.RGBA,e]}})();this._emptyDEMTextureDirty=!1;let o=this._emptyDEMTexture;return o?o.update(n,{premultiply:!1}):o=this._emptyDEMTexture=new Texture(e,n,r,{premultiply:!1}),o}setupElevationDraw(e,t,i){const r=this.painter.context,n=r.gl,o=(a=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:DEMData.getUnpackVector(a),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0});var a;o.u_exaggeration=this.exaggeration();let s=null,l=null,c=1;if(i&&i.morphing&&this._useVertexMorphing){const t=i.morphing.srcDemTile,r=i.morphing.dstDemTile;c=i.morphing.phase,t&&r&&(this._prepareDemTileUniforms(e,t,o,"_prev")&&(l=t),this._prepareDemTileUniforms(e,r,o)&&(s=r))}const u=e=>e&&e.demTexture&&this.painter.terrainUseFloatDEM()?n.LINEAR:n.NEAREST,h=e=>{o.u_dem_size=1===e.size[0]?1:e.size[0]-2};if(l&&s)r.activeTexture.set(n.TEXTURE2),s.demTexture.bind(u(s),n.CLAMP_TO_EDGE),r.activeTexture.set(n.TEXTURE4),l.demTexture.bind(u(l),n.CLAMP_TO_EDGE),s.demTexture&&h(s.demTexture),o.u_dem_lerp=c;else{s=this.terrainTileForTile[e.tileID.key],r.activeTexture.set(n.TEXTURE2);const t=this._prepareDemTileUniforms(e,s,o)?s.demTexture:this.emptyDEMTexture;t.bind(u(s),n.CLAMP_TO_EDGE),h(t)}if(r.activeTexture.set(n.TEXTURE3),i&&i.useDepthForOcclusion?(this._depthTexture&&this._depthTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),this._depthFBO&&(o.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height])):(this.emptyDepthBufferTexture.bind(n.NEAREST,n.CLAMP_TO_EDGE),o.u_depth_size_inv=[1,1]),i&&i.useMeterToDem&&s){const e=(1<<s.tileID.canonical.z)*yu(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;o.u_meter_to_dem=e}if(i&&i.labelPlaneMatrixInv&&(o.u_label_plane_matrix_inv=i.labelPlaneMatrixInv),t.setTerrainUniformValues(r,o),"globe"===this.painter.transform.projection.name){const n=this.globeUniformValues(this.painter.transform,e.tileID.canonical,i&&i.useDenormalizedUpVectorScale);t.setGlobeUniformValues(r,n)}}globeUniformValues(e,t,i){const r=e.projection;return{u_tile_tl_up:r.upVector(t,0,0),u_tile_tr_up:r.upVector(t,Ri,0),u_tile_br_up:r.upVector(t,Ri,Ri),u_tile_bl_up:r.upVector(t,0,Ri),u_tile_up_scale:i?zc(1):r.upVectorScale(t,e.center.lat,e.worldSize).metersToTile}}renderToBackBuffer(e){const t=this.painter,i=this.painter.context;0!==e.length&&(i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height]),t.gpuTimingDeferredRenderStart(),this.renderingToTexture=!1,function(e,t,i,r,n){if("globe"===e.transform.projection.name)!function(e,t,i,r,n){const o=e.context,a=o.gl;let s,l;const c=e.transform,u=tu(e,o,c),h=(t,i)=>{if(l===i)return;const r=[jy[i],"PROJECTION_GLOBE_VIEW"];u&&r.push("CUSTOM_ANTIALIASING");const n=e.isTileAffectedByFog(t);s=e.getOrCreateProgram("globeRaster",{defines:r,overrideFog:n}),l=i},d=e.colorModeForRenderPass(),p=new DepthMode(a.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D);Ny.update(n);const f=function(e){const t=e.pixelsPerMeter,i=t/yu(1,e.center.lat),r=ic.identity(new Float64Array(16));return ic.translate(r,r,[e.point.x,e.point.y,0]),ic.scale(r,r,[i,i,t]),Float32Array.from(r)}(c),m=[_u(c.center.lng),gu(c.center.lat)],_=e.globeSharedBuffers,g=[c.width*rt.devicePixelRatio,c.height*rt.devicePixelRatio],y=Float32Array.from(c.globeMatrix),x={useDenormalizedUpVectorScale:!0};{const c=e.transform,u=Gy(c.zoom,t.exaggeration(),t.sourceCache._source.tileSize);l=-1;const v=a.TRIANGLES;for(const l of r){const r=i.getTile(l),b=StencilMode.disabled,w=t.prevTerrainTileForTile[l.key],T=t.terrainTileForTile[l.key];Vy(w,T)&&Ny.newMorphing(l.key,w,T,n,250),o.activeTexture.set(a.TEXTURE0),r.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE);const M=Ny.getMorphValuesForProxy(l.key),S=M?1:0;M&&vt(x,{morphing:{srcDemTile:M.from,dstDemTile:M.to,phase:E(M.phase)}});const A=Nc(l.canonical),C=ru(A.getCenter().lat),I=iu(l.canonical,A,C,c.worldSize/c._pixelsPerMercatorPixel),D=Wc(Bc(l.canonical)),P=Fy(c.projMatrix,y,f,D,Qc(c.zoom),m,c.frustumCorners.TL,c.frustumCorners.TR,c.frustumCorners.BR,c.frustumCorners.BL,c.globeCenterInViewSpace,c.globeRadius,g,u,I);if(h(l,S),s&&(t.setupElevationDraw(r,s,x),e.uploadCommonUniforms(o,s,l.toUnwrapped()),_)){const[t,i,r]=_.getGridBuffers(C,0!==u);s.draw(e,v,p,b,d,CullFaceMode.backCCW,P,"globe_raster",t,i,r)}}}if(_&&(e.renderDefaultNorthPole||e.renderDefaultSouthPole)){const n=["GLOBE_POLES","PROJECTION_GLOBE_VIEW"];u&&n.push("CUSTOM_ANTIALIASING"),s=e.getOrCreateProgram("globeRaster",{defines:n});for(const n of r){const{x:r,y:l,z:u}=n.canonical,h=0===l,f=l===(1<<u)-1,[y,v,b,w]=_.getPoleBuffers(u,!1);if(w&&(h||f)){const l=i.getTile(n);o.activeTexture.set(a.TEXTURE0),l.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE);let _=eu(u,r,c);const T=Wc(Bc(n.canonical)),E=(t,i)=>t.draw(e,a.TRIANGLES,p,StencilMode.disabled,d,CullFaceMode.disabled,Fy(c.projMatrix,_,_,T,0,m,c.frustumCorners.TL,c.frustumCorners.TR,c.frustumCorners.BR,c.frustumCorners.BL,c.globeCenterInViewSpace,c.globeRadius,g,0),"globe_pole_raster",i,b,w);t.setupElevationDraw(l,s,x),e.uploadCommonUniforms(o,s,n.toUnwrapped()),h&&e.renderDefaultNorthPole&&E(s,y),f&&e.renderDefaultSouthPole&&(_=ic.scale(ic.create(),_,[1,-1,1]),E(s,v))}}}}(e,t,i,r,n);else{const o=e.context,a=o.gl;let s,l;const c=e.shadowRenderer,u=Uy(e,e.longestCutoffRange),h=t=>{if(l===t)return;const i=[];i.push(jy[t]),u.shouldRenderCutoff&&i.push("RENDER_CUTOFF"),s=e.getOrCreateProgram("terrainRaster",{defines:i}),l=t},d=e.colorModeForRenderPass(),p=new DepthMode(a.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D);Ny.update(n);const f=e.transform,m=Gy(f.zoom,t.exaggeration(),t.sourceCache._source.tileSize);let _=[0,0,0];if(c){const t=e.style.directionalLight,i=e.style.ambientLight;t&&i&&(_=_v(t,i))}{l=-1;const g=a.TRIANGLES,[y,x]=[t.gridIndexBuffer,t.gridSegments];for(const l of r){const r=i.getTile(l),v=StencilMode.disabled,b=t.prevTerrainTileForTile[l.key],w=t.terrainTileForTile[l.key];Vy(b,w)&&Ny.newMorphing(l.key,b,w,n,250),o.activeTexture.set(a.TEXTURE0),r.texture.bind(a.LINEAR,a.CLAMP_TO_EDGE,a.LINEAR_MIPMAP_NEAREST);const T=Ny.getMorphValuesForProxy(l.key),M=T?1:0;let S;T&&(S={morphing:{srcDemTile:T.from,dstDemTile:T.to,phase:E(T.phase)}});const A=Oy(l.projMatrix,qy(l.canonical,f.renderWorldCopies)?m/10:m,_);if(h(M),!s)continue;t.setupElevationDraw(r,s,S);const C=l.toUnwrapped();c&&c.setupShadows(C,s),e.uploadCommonUniforms(o,s,C,null,u),s.draw(e,g,p,v,d,CullFaceMode.backCCW,A,"terrain_raster",t.gridBuffer,y,x)}}}}(t,this,this.proxySourceCache,e,this._updateTimestamp),this.renderingToTexture=!0,t.gpuTimingDeferredRenderEnd(),e.splice(0,e.length))}renderBatch(e){if(0===this._drapedRenderBatches.length)return e+1;this.renderingToTexture=!0;const t=this.painter,i=this.painter.context,r=this.proxySourceCache,n=this.proxiedCoords[r.id],o=this._drapedRenderBatches.shift(),a=t.style.order,s=[];let l=0;for(const c of n){const n=r.getTileByID(c.proxyTileKey),u=r.proxyCachedFBO[c.key]?r.proxyCachedFBO[c.key][e]:void 0,h=void 0!==u?r.renderCache[u]:this.pool[l++],d=void 0!==u;if(n.texture=h.tex,d&&!h.dirty){s.push(n.tileID);continue}let p;i.bindFramebuffer.set(h.fb.framebuffer),this.renderedToTile=!1,h.dirty&&(i.clear({color:Wt.transparent,stencil:0}),h.dirty=!1);for(let e=o.start;e<=o.end;++e){const r=t.style._mergedLayers[a[e]];if(r.isHidden(t.transform.zoom))continue;const n=t.style.getLayerSourceCache(r),o=n?this.proxyToSource[c.key][n.id]:[c];if(!o)continue;const s=o;i.viewport.set([0,0,h.fb.width,h.fb.height]),p!==(n?n.id:null)&&(this._setupStencil(h,o,r,n),p=n?n.id:null),t.renderLayer(t,n,r,s)}if(0===this._drapedRenderBatches.length)for(const e of this._pendingGroundEffectLayers){const r=t.style._mergedLayers[a[e]];if(r.isHidden(t.transform.zoom))continue;const n=t.style.getLayerSourceCache(r),o=n?this.proxyToSource[c.key][n.id]:[c];if(!o)continue;const s=o;i.viewport.set([0,0,h.fb.width,h.fb.height]),p!==(n?n.id:null)&&(this._setupStencil(h,o,r,n),p=n?n.id:null),t.renderLayer(t,n,r,s)}this.renderedToTile?(h.dirty=!0,s.push(n.tileID)):d||--l,5===l&&(l=0,this.renderToBackBuffer(s))}return this.renderToBackBuffer(s),this.renderingToTexture=!1,i.bindFramebuffer.set(null),i.viewport.set([0,0,t.width,t.height]),o.end+1}postRender(){}isLayerOrderingCorrect(e){const t=e.order.length;let i=-1,r=t;for(let n=0;n<t;++n)this._style.isLayerDraped(e._mergedLayers[e.order[n]])?i=Math.max(i,n):r=Math.min(r,n);return r>i}getMinElevationBelowMSL(){let e=0;return this._visibleDemTiles.filter((e=>e.dem)).forEach((t=>{e=Math.min(e,t.dem.tree.minimums[0])})),0===e?e:(e-30)*this._exaggeration}raycast(e,t,i){if(!this._visibleDemTiles)return null;const r=this._visibleDemTiles.filter((e=>e.dem)).map((r=>{const n=r.tileID,o=1<<n.overscaledZ,{x:a,y:s}=n.canonical,l=a/o,c=(a+1)/o,u=s/o,h=(s+1)/o;return{minx:l,miny:u,maxx:c,maxy:h,t:r.dem.tree.raycastRoot(l,u,c,h,e,t,i),tile:r}}));r.sort(((e,t)=>(null!==e.t?e.t:Number.MAX_VALUE)-(null!==t.t?t.t:Number.MAX_VALUE)));for(const n of r){if(null==n.t)return null;const r=n.tile.dem.tree.raycast(n.minx,n.miny,n.maxx,n.maxy,e,t,i);if(null!=r)return r}return null}_createFBO(){const e=this.painter.context,t=e.gl,i=this.drapeBufferSize;e.activeTexture.set(t.TEXTURE0);const r=new Texture(e,{width:i[0],height:i[1],data:null},t.RGBA);r.bind(t.LINEAR,t.CLAMP_TO_EDGE);const n=e.createFramebuffer(i[0],i[1],!0,null);return n.colorAttachment.set(r.texture),n.depthAttachment=new DepthStencilAttachment(e,n.framebuffer),void 0===this._sharedDepthStencil?(this._sharedDepthStencil=e.createRenderbuffer(e.gl.DEPTH_STENCIL,i[0],i[1]),this._stencilRef=0,n.depthAttachment.set(this._sharedDepthStencil),e.clear({stencil:0})):n.depthAttachment.set(this._sharedDepthStencil),e.extTextureFilterAnisotropic&&!e.extTextureFilterAnisotropicForceOff&&t.texParameterf(t.TEXTURE_2D,e.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.extTextureFilterAnisotropicMax),{fb:n,tex:r,dirty:!1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO())}_shouldDisableRenderCache(){if(this._style.hasLightTransitions())return!0;for(const e in this._style._mergedSourceCaches)if(this._style._mergedSourceCaches[e].hasTransition())return!0;return this._style.order.some((e=>{const t=this._style._mergedLayers[e],i=t.isHidden(this.painter.transform.zoom);return"custom"===t.type?!i&&t.shouldRedrape():!i&&t.hasTransition()}))}_clearLineLayersFromRenderCache(){let e=!1;for(const t of this._style.getSources())if(t instanceof VectorTileSource){e=!0;break}if(!e)return;const t={};for(let e=0;e<this._style.order.length;++e){const i=this._style._mergedLayers[this._style.order[e]],r=this._style.getLayerSourceCache(i);if(r&&!t[r.id]&&!i.isHidden(this.painter.transform.zoom)&&"line"===i.type&&i.widthExpression()instanceof ZoomDependentExpression){t[r.id]=!0;for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][r.id];if(t)for(const e of t)this._clearRenderCacheForTile(r.id,e)}}}}_clearRasterLayersFromRenderCache(){let e=!1;for(const t in this._style._mergedSourceCaches)if(this._style._mergedSourceCaches[t]._source instanceof RasterTileSource){e=!0;break}if(!e)return;const t={};for(let e=0;e<this._style.order.length;++e){const i=this._style._mergedLayers[this._style.order[e]],r=this._style.getLayerSourceCache(i);if(!r||t[r.id])continue;if(i.isHidden(this.painter.transform.zoom)||"raster"!==i.type)continue;const n=i.paint.get("raster-fade-duration");for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][r.id];if(t)for(const e of t){const t=$y(r.getTile(e),r.findLoadedParent(e,0),r,this.painter.transform,n);(1!==t.opacity||0!==t.mix)&&this._clearRenderCacheForTile(r.id,e)}}}}_setupDrapedRenderBatches(){const e=this._style.order,t=e.length;if(0===t)return;const i=[];this._pendingGroundEffectLayers=[];let r,n=0,o=this._style._mergedLayers[e[n]];for(;!this._style.isLayerDraped(o)&&o.isHidden(this.painter.transform.zoom)&&++n<t;)o=this._style._mergedLayers[e[n]];for(;n<t;++n){const t=this._style._mergedLayers[e[n]];t.isHidden(this.painter.transform.zoom)||(this._style.isLayerDraped(t)?void 0===r&&(r=n):("fill-extrusion"===t.type&&this._pendingGroundEffectLayers.push(n),void 0!==r&&(i.push({start:r,end:n-1}),r=void 0)))}if(void 0!==r&&i.push({start:r,end:n-1}),0!==i.length){const e=i[i.length-1],t=this._pendingGroundEffectLayers.every((t=>t>e.end));t||$("fill-extrusion with flood lighting and/or ground ambient occlusion should be moved to be on top of all draped layers.")}this._drapedRenderBatches=i}_setupRenderCache(e){const t=this.proxySourceCache;if(this._shouldDisableRenderCache()||this.invalidateRenderCache){if(this.invalidateRenderCache=!1,t.renderCache.length>t.renderCachePool.length){const e=Object.values(t.proxyCachedFBO);t.proxyCachedFBO={};for(let i=0;i<e.length;++i){const r=Object.values(e[i]);t.renderCachePool.push(...r)}}return}this._clearRasterLayersFromRenderCache();const i=this.proxyCoords,r=this._tilesDirty;for(let n=i.length-1;n>=0;n--){const o=i[n];if(t.getTileByID(o.key),void 0!==t.proxyCachedFBO[o.key]){const i=e[o.key],n=this.proxyToSource[o.key];let a=0;for(const e in n){const t=n[e],o=i[e];if(!o||o.length!==t.length||t.some(((t,i)=>t!==o[i]||r[e]&&r[e].hasOwnProperty(t.key)))){a=-1;break}++a}for(const e in t.proxyCachedFBO[o.key])t.renderCache[t.proxyCachedFBO[o.key][e]].dirty=a<0||a!==Object.values(i).length}}const n=[...this._drapedRenderBatches];n.sort(((e,t)=>t.end-t.start-(e.end-e.start)));for(const e of n)for(const r of i){if(t.proxyCachedFBO[r.key])continue;let i=t.renderCachePool.pop();void 0===i&&t.renderCache.length<50&&(i=t.renderCache.length,t.renderCache.push(this._createFBO())),void 0!==i&&(t.proxyCachedFBO[r.key]={},t.proxyCachedFBO[r.key][e.start]=i,t.renderCache[i].dirty=!0)}this._tilesDirty={}}_setupStencil(e,t,i,r){if(!r||!this._sourceTilesOverlap[r.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const n=this.painter.context,o=n.gl;if(t.length<=1)return void(this._overlapStencilType=!1);let a;if(i.isTileClipped())a=t.length,this._overlapStencilMode.test={func:o.EQUAL,mask:255},this._overlapStencilType="Clip";else{if(!(t[0].overscaledZ>t[t.length-1].overscaledZ))return void(this._overlapStencilType=!1);a=1,this._overlapStencilMode.test={func:o.GREATER,mask:255},this._overlapStencilType="Mask"}this._stencilRef+a>255&&(n.clear({stencil:0}),this._stencilRef=0),this._stencilRef+=a,this._overlapStencilMode.ref=this._stencilRef,i.isTileClipped()&&this._renderTileClippingMasks(t,this._overlapStencilMode.ref)}clipOrMaskOverlapStencilType(){return"Clip"===this._overlapStencilType||"Mask"===this._overlapStencilType}stencilModeForRTTOverlap(e){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[e.key]),this._overlapStencilMode):StencilMode.disabled}_renderTileClippingMasks(e,t){const i=this.painter,r=this.painter.context,n=r.gl;i._tileClippingMaskIDs={},r.setColorMode(ColorMode.disabled),r.setDepthMode(DepthMode.disabled);const o=i.getOrCreateProgram("clippingMask");for(const r of e){const e=i._tileClippingMaskIDs[r.key]=--t;o.draw(i,n.TRIANGLES,DepthMode.disabled,new StencilMode({func:n.ALWAYS,mask:0},e,255,n.KEEP,n.KEEP,n.REPLACE),ColorMode.disabled,CullFaceMode.disabled,Zy(r.projMatrix),"$clipping",i.tileExtentBuffer,i.quadTriangleIndexBuffer,i.tileExtentSegments)}}pointCoordinate(e){const t=this.painter.transform;if(e.x<0||e.x>t.width||e.y<0||e.y>t.height)return null;const i=[e.x,e.y,1,1];Wl.transformMat4(i,i,t.pixelMatrixInverse),Wl.scale(i,i,1/i[3]),i[0]/=t.worldSize,i[1]/=t.worldSize;const r=t._camera.position,n=yu(1,t.center.lat),o=[r[0],r[1],r[2]/n,0],a=lc.subtract([],i.slice(0,3),o);lc.normalize(a,a);const s=this.raycast(o,a,this._exaggeration);return null!==s&&s?(lc.scaleAndAdd(o,o,a,s),o[3]=o[2],o[2]*=n,o):null}drawDepth(){const e=this.painter,t=e.context,i=this.proxySourceCache,r=Math.ceil(e.width),n=Math.ceil(e.height);if(!this._depthFBO||this._depthFBO.width===r&&this._depthFBO.height===n||(this._depthFBO.destroy(),this._depthFBO=void 0,this._depthTexture=void 0),!this._depthFBO){const e=t.gl,i=t.createFramebuffer(r,n,!0,"renderbuffer");t.activeTexture.set(e.TEXTURE0);const o=new Texture(t,{width:r,height:n,data:null},e.RGBA);o.bind(e.NEAREST,e.CLAMP_TO_EDGE),i.colorAttachment.set(o.texture);const a=t.createRenderbuffer(t.gl.DEPTH_COMPONENT16,r,n);i.depthAttachment.set(a),this._depthFBO=i,this._depthTexture=o}t.bindFramebuffer.set(this._depthFBO.framebuffer),t.viewport.set([0,0,r,n]),function(e,t,i,r){if("globe"===e.transform.projection.name)return;const n=e.context,o=n.gl;n.clear({depth:1});const a=e.getOrCreateProgram("terrainDepth"),s=new DepthMode(o.LESS,DepthMode.ReadWrite,e.depthRangeFor3D);for(const n of r){const r=i.getTile(n),l=Oy(n.projMatrix,0,[0,0,0]);t.setupElevationDraw(r,a),a.draw(e,o.TRIANGLES,s,StencilMode.disabled,ColorMode.unblended,CullFaceMode.backCCW,l,"terrain_depth",t.gridBuffer,t.gridIndexBuffer,t.gridNoSkirtSegments)}}(e,this,i,this.proxyCoords)}_setupProxiedCoordsForOrtho(e,t,i){if(e.getSource()instanceof ImageSource)return this._setupProxiedCoordsForImageSource(e,t,i);this._findCoveringTileCache[e.id]=this._findCoveringTileCache[e.id]||{};const r=this.proxiedCoords[e.id]=[],n=this.proxyCoords;for(let t=0;t<n.length;t++){const o=n[t],a=this._findTileCoveringTileID(o,e);if(a){const t=this._createProxiedId(o,a,i[o.key]&&i[o.key][e.id]);r.push(t),this.proxyToSource[o.key][e.id]=[t]}}let o=!1;for(let n=0;n<t.length;n++){const a=e.getTile(t[n]);if(!a||!a.hasData())continue;const s=this._findTileCoveringTileID(a.tileID,this.proxySourceCache);if(s&&s.tileID.canonical.z!==a.tileID.canonical.z){const t=this.proxyToSource[s.tileID.key][e.id],n=this._createProxiedId(s.tileID,a,i[s.tileID.key]&&i[s.tileID.key][e.id]);t?t.splice(t.length-1,0,n):this.proxyToSource[s.tileID.key][e.id]=[n],r.push(n),o=!0}}this._sourceTilesOverlap[e.id]=o}_setupProxiedCoordsForImageSource(e,t,i){if(!e.getSource().loaded())return;const r=this.proxiedCoords[e.id]=[],n=this.proxyCoords,o=e.getSource(),a=o.tileID;if(!a)return;const s=new g(a.x,a.y)._div(1<<a.z),l=o.coordinates.map(MercatorCoordinate.fromLngLat).reduce(((e,t)=>(e.min.x=Math.min(e.min.x,t.x-s.x),e.min.y=Math.min(e.min.y,t.y-s.y),e.max.x=Math.max(e.max.x,t.x-s.x),e.max.y=Math.max(e.max.y,t.y-s.y),e)),{min:new g(Number.MAX_VALUE,Number.MAX_VALUE),max:new g(-Number.MAX_VALUE,-Number.MAX_VALUE)}),c=(e,t)=>{const i=e.wrap+e.canonical.x/(1<<e.canonical.z),r=e.canonical.y/(1<<e.canonical.z),n=Ri/(1<<e.canonical.z),o=t.wrap+t.canonical.x/(1<<t.canonical.z),a=t.canonical.y/(1<<t.canonical.z);return i+n<o+l.min.x||i>o+l.max.x||r+n<a+l.min.y||r>a+l.max.y};for(let o=0;o<n.length;o++){const a=n[o];for(let n=0;n<t.length;n++){const o=e.getTile(t[n]);if(!o||!o.hasData())continue;if(c(a,o.tileID))continue;const s=this._createProxiedId(a,o,i[a.key]&&i[a.key][e.id]),l=this.proxyToSource[a.key][e.id];l?l.push(s):this.proxyToSource[a.key][e.id]=[s],r.push(s)}}}_createProxiedId(e,t,i){let r=this.orthoMatrix;if(i){const e=i.find((e=>e.key===t.tileID.key));if(e)return e}if(t.tileID.key!==e.key){const i=e.canonical.z-t.tileID.canonical.z;let n,o,a;r=ic.create();const s=t.tileID.wrap-e.wrap<<e.overscaledZ;i>0?(n=Ri>>i,o=n*((t.tileID.canonical.x<<i)-e.canonical.x+s),a=n*((t.tileID.canonical.y<<i)-e.canonical.y)):(n=Ri<<-i,o=Ri*(t.tileID.canonical.x-(e.canonical.x+s<<-i)),a=Ri*(t.tileID.canonical.y-(e.canonical.y<<-i))),ic.ortho(r,0,n,0,n,0,1),ic.translate(r,r,[o,a,0])}return new ProxiedTileID(t.tileID,e.key,r)}_findTileCoveringTileID(e,t){let i=t.getTile(e);if(i&&i.hasData())return i;const r=this._findCoveringTileCache[t.id],n=r[e.key];if(i=n?t.getTileByID(n):null,i&&i.hasData()||null===n)return i;let o=i?i.tileID:e,a=o.overscaledZ;const s=t.getSource().minzoom,l=[];if(!n){const r=t.getSource().maxzoom;if(e.canonical.z>=r){const i=e.canonical.z-r;t.getSource().reparseOverscaled?(a=Math.max(e.canonical.z+2,t.transform.tileZoom),o=new OverscaledTileID(a,e.wrap,r,e.canonical.x>>i,e.canonical.y>>i)):0!==i&&(a=r,o=new OverscaledTileID(a,e.wrap,r,e.canonical.x>>i,e.canonical.y>>i))}o.key!==e.key&&(l.push(o.key),i=t.getTile(o))}const c=e=>{l.forEach((t=>{r[t]=e})),l.length=0};for(a-=1;a>=s&&(!i||!i.hasData());a--){i&&c(i.tileID.key);const e=o.calculateScaledKey(a);if(i=t.getTileByID(e),i&&i.hasData())break;const n=r[e];if(null===n)break;void 0===n?l.push(e):i=t.getTileByID(n)}return c(i?i.tileID.key:null),i&&i.hasData()?i:null}findDEMTileFor(e){return this.enabled?this._findTileCoveringTileID(e,this.sourceCache):null}prepareDrawTile(){this.renderedToTile=!0}_clearRenderCacheForTile(e,t){let i=this._tilesDirty[e];i||(i=this._tilesDirty[e]={}),i[t.key]=!0}}function Hy(e,t,i){const r=function(e,t,i){const r=lc.dot(t,e),n=lc.dot(i,[.2126,.7152,.0722]),o=(e,t,i)=>(1-i)*e+i*t,a=o(1-.3*Math.min(n,1),1,Math.min(r+1,1));return o(.92,1,Math.asin(I(t[2],-1,1))/Math.PI+.5)*a}(e,[0,0,1],t),n=[0,0,0];lc.scale(n,i.slice(0,3),r);const o=[0,0,0];lc.scale(o,t.slice(0,3),e[2]);const a=[0,0,0];return lc.add(a,n,o),oe(a)}const Wy=["fill","fillOutline","fillPattern","line","linePattern","background","backgroundPattern","hillshade","raster"],Xy=["stars","fillExtrusion","fillExtrusionGroundEffect","model","symbolSDF","symbolIcon","symbolTextAndIcon"];class Program{static cacheKey(e,t,i,r){let n=`${t}${r?r.cacheKey:""}`;for(const t of i)e.usedDefines.includes(t)&&(n+=`/${t}`);return n}constructor(e,t,i,r,n,o){const a=e.gl;this.program=a.createProgram(),this.configuration=r,this.name=t,this.fixedDefines=[...o];const s=function(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const r=e[i].split(" ");t.push(r.pop())}return t}(i.staticAttributes),l=r?r.getBinderAttributes():[],c=s.concat(l);let u=r?r.defines():[];u=u.concat(o.map((e=>`#define ${e}`)));const h="#version 300 es\n";let d=h+u.concat("\n#ifdef GL_ES\nprecision mediump float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif",Cy,Ay.fragmentSource).join("\n");for(const e of i.fragmentIncludes)d+=`\n${My[e]}`;d+=`\n${i.fragmentSource}`;let p=h+u.concat("\n#ifdef GL_ES\nprecision highp float;\n#else\n\n#if !defined(lowp)\n#define lowp\n#endif\n\n#if !defined(mediump)\n#define mediump\n#endif\n\n#if !defined(highp)\n#define highp\n#endif\n\n#endif",Cy,Ay.vertexSource).join("\n");for(const e of i.vertexIncludes)p+=`\n${My[e]}`;p+=`\n${i.vertexSource}`;const f=a.createShader(a.FRAGMENT_SHADER);if(a.isContextLost())return void(this.failedToCreate=!0);a.shaderSource(f,d),a.compileShader(f),a.attachShader(this.program,f);const m=a.createShader(a.VERTEX_SHADER);if(a.isContextLost())this.failedToCreate=!0;else{a.shaderSource(m,p),a.compileShader(m),a.attachShader(this.program,m),this.attributes={},this.numAttributes=c.length;for(let e=0;e<this.numAttributes;e++)if(c[e]){const t=c[e].startsWith("a_")?c[e]:`a_${c[e]}`;a.bindAttribLocation(this.program,e,t),this.attributes[t]=e}a.linkProgram(this.program),a.deleteShader(m),a.deleteShader(f),this.fixedUniforms=n(e),this.binderUniforms=r?r.getUniforms(e):[],o.includes("TERRAIN")&&(this.terrainUniforms=(e=>({u_dem:new Uniform1i(e),u_dem_prev:new Uniform1i(e),u_dem_unpack:new Uniform4f(e),u_dem_tl:new Uniform2f(e),u_dem_scale:new Uniform1f(e),u_dem_tl_prev:new Uniform2f(e),u_dem_scale_prev:new Uniform1f(e),u_dem_size:new Uniform1f(e),u_dem_lerp:new Uniform1f(e),u_exaggeration:new Uniform1f(e),u_depth:new Uniform1i(e),u_depth_size_inv:new Uniform2f(e),u_meter_to_dem:new Uniform1f(e),u_label_plane_matrix_inv:new UniformMatrix4f(e)}))(e)),o.includes("GLOBE")&&(this.globeUniforms=(e=>({u_tile_tl_up:new Uniform3f(e),u_tile_tr_up:new Uniform3f(e),u_tile_br_up:new Uniform3f(e),u_tile_bl_up:new Uniform3f(e),u_tile_up_scale:new Uniform1f(e)}))(e)),o.includes("FOG")&&(this.fogUniforms=(e=>({u_fog_matrix:new UniformMatrix4f(e),u_fog_range:new Uniform2f(e),u_fog_color:new Uniform4f(e),u_fog_horizon_blend:new Uniform1f(e),u_fog_vertical_limit:new Uniform2f(e),u_fog_temporal_offset:new Uniform1f(e),u_frustum_tl:new Uniform3f(e),u_frustum_tr:new Uniform3f(e),u_frustum_br:new Uniform3f(e),u_frustum_bl:new Uniform3f(e),u_globe_pos:new Uniform3f(e),u_globe_radius:new Uniform1f(e),u_globe_transition:new Uniform1f(e),u_is_globe:new Uniform1i(e),u_viewport:new Uniform2f(e)}))(e)),o.includes("RENDER_CUTOFF")&&(this.cutoffUniforms=(e=>({u_cutoff_params:new Uniform4f(e)}))(e)),o.includes("LIGHTING_3D_MODE")&&(this.lightsUniforms=(e=>({u_lighting_ambient_color:new Uniform3f(e),u_lighting_directional_dir:new Uniform3f(e),u_lighting_directional_color:new Uniform3f(e),u_ground_radiance:new Uniform3f(e)}))(e)),o.includes("RENDER_SHADOWS")&&(this.shadowUniforms=(e=>({u_light_matrix_0:new UniformMatrix4f(e),u_light_matrix_1:new UniformMatrix4f(e),u_fade_range:new Uniform2f(e),u_shadow_normal_offset:new Uniform3f(e),u_shadow_intensity:new Uniform1f(e),u_shadow_texel_size:new Uniform1f(e),u_shadow_map_resolution:new Uniform1f(e),u_shadow_direction:new Uniform3f(e),u_shadow_bias:new Uniform3f(e),u_shadowmap_0:new Uniform1i(e),u_shadowmap_1:new Uniform1i(e)}))(e))}}setTerrainUniformValues(e,t){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e]&&i[e].set(this.program,e,t[e])}}setGlobeUniformValues(e,t){if(!this.globeUniforms)return;const i=this.globeUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e]&&i[e].set(this.program,e,t[e])}}setFogUniformValues(e,t){if(!this.fogUniforms)return;const i=this.fogUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(this.program,e,t[e])}}setCutoffUniformValues(e,t){if(!this.cutoffUniforms)return;const i=this.cutoffUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(this.program,e,t[e])}}setLightsUniformValues(e,t){if(!this.lightsUniforms)return;const i=this.lightsUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(this.program,e,t[e])}}setShadowUniformValues(e,t){if(this.failedToCreate||!this.shadowUniforms)return;const i=this.shadowUniforms;e.program.set(this.program);for(const e in t)i[e].set(this.program,e,t[e])}_drawDebugWireframe(e,t,i,r,n,o,a,s,l,c){const u=e.options.wireframe;if(!1===u.terrain&&!1===u.layers2D&&!1===u.layers3D)return;const h=e.context;if(!(()=>!(!u.terrain||"terrainRaster"!==this.name&&"globeRaster"!==this.name)||!(!u.layers2D||e._terrain&&e._terrain.renderingToTexture||!Wy.includes(this.name))||!(!u.layers3D||!Xy.includes(this.name)))())return;const d=h.gl,p=e.wireframeDebugCache.getLinesFromTrianglesBuffer(e.frameCounter,n,h);if(!p)return;const f=[...this.fixedDefines];f.push("DEBUG_WIREFRAME");const m=e.getOrCreateProgram(this.name,{config:this.configuration,defines:f});h.program.set(m.program);const _=(e,t,i)=>{if(t[e]&&i[e])for(const r in t[e])i[e][r]&&i[e][r].set(i.program,r,t[e][r].current)};l&&l.setUniforms(m.program,h,m.binderUniforms,a,{zoom:s}),_("fixedUniforms",this,m),_("terrainUniforms",this,m),_("globeUniforms",this,m),_("fogUniforms",this,m),_("lightsUniforms",this,m),_("shadowUniforms",this,m),p.bind(),h.setColorMode(new ColorMode([d.ONE,d.ONE_MINUS_SRC_ALPHA,d.ZERO,d.ONE],Wt.transparent,[!0,!0,!0,!1])),h.setDepthMode(new DepthMode(t.func===d.LESS?d.LEQUAL:t.func,DepthMode.ReadOnly,t.range)),h.setStencilMode(StencilMode.disabled);const g=3*o.primitiveLength*2,y=3*o.primitiveOffset*2*2;c&&c>1?d.drawElementsInstanced(d.LINES,g,d.UNSIGNED_SHORT,y,c):d.drawElements(d.LINES,g,d.UNSIGNED_SHORT,y),n.bind(),h.program.set(this.program),h.setDepthMode(t),h.setStencilMode(i),h.setColorMode(r)}draw(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m){const _=e.context,g=_.gl;if(this.failedToCreate)return;_.program.set(this.program),_.setDepthMode(i),_.setStencilMode(r),_.setColorMode(n),_.setCullFace(o);for(const e of Object.keys(this.fixedUniforms))this.fixedUniforms[e].set(this.program,e,a[e]);p&&p.setUniforms(this.program,_,this.binderUniforms,h,{zoom:d});const y={[g.LINES]:2,[g.TRIANGLES]:3,[g.LINE_STRIP]:1}[t],x=m&&m>0?1:void 0;for(const o of u.get()){const a=o.vaos||(o.vaos={});(a[s]||(a[s]=new VertexArrayObject)).bind(_,this,l,p?p.getPaintVertexBuffers():[],c,o.vertexOffset,f||[],x),m&&m>1?g.drawElementsInstanced(t,o.primitiveLength*y,g.UNSIGNED_SHORT,o.primitiveOffset*y*2,m):g.drawElements(t,o.primitiveLength*y,g.UNSIGNED_SHORT,o.primitiveOffset*y*2),t===g.TRIANGLES&&this._drawDebugWireframe(e,i,r,n,c,o,h,d,p,m)}}}function Yy(e,t){const i=Math.pow(2,t.tileID.overscaledZ),r=t.tileSize*Math.pow(2,e.transform.tileZoom)/i,n=r*(t.tileID.canonical.x+t.tileID.wrap*i),o=r*t.tileID.canonical.y;return{u_image:0,u_texsize:t.imageAtlasTexture.size,u_tile_units_to_pixels:1/Wf(t,1,e.transform.tileZoom),u_pixel_coord_upper:[n>>16,o>>16],u_pixel_coord_lower:[65535&n,65535&o]}}const Ky=ic.create(),Jy=(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f)=>{const m=t.style.light,_=m.properties.get("position"),g=[_.x,_.y,_.z],y=ec.create();"viewport"===m.properties.get("anchor")&&(ec.fromRotation(y,-t.transform.angle),lc.transformMat3(g,g,y));const x=m.properties.get("color"),v=t.transform,b={u_matrix:e,u_lightpos:g,u_lightintensity:m.properties.get("intensity"),u_lightcolor:[x.r,x.g,x.b],u_vertical_gradient:+i,u_opacity:r,u_tile_id:[0,0,0],u_zoom_transition:0,u_inv_rot_matrix:Ky,u_merc_center:[0,0],u_up_dir:[0,0,0],u_height_lift:0,u_ao:n,u_edge_radius:o,u_flood_light_color:h,u_vertical_scale:d,u_flood_light_intensity:p,u_ground_shadow_factor:f};return"globe"===v.projection.name&&(b.u_tile_id=[a.canonical.x,a.canonical.y,1<<a.canonical.z],b.u_zoom_transition=l,b.u_inv_rot_matrix=u,b.u_merc_center=c,b.u_up_dir=v.projection.upVector(new CanonicalTileID(0,0,0),c[0]*Ri,c[1]*Ri),b.u_height_lift=s),b},Qy=(e,t,i)=>({u_matrix:e,u_edge_radius:t,u_vertical_scale:i}),ex=(e,t,i,r,n,o,a,s,l,c,u,h,d,p)=>{const f=Jy(e,t,i,r,n,o,a,l,c,u,h,d,p,1,[0,0,0]),m={u_height_factor:-Math.pow(2,a.overscaledZ)/s.tileSize/8};return z(f,Yy(t,s),m)},tx=(e,t)=>({u_matrix:e,u_emissive_strength:t}),ix=(e,t,i,r)=>z(tx(e,t),Yy(i,r)),rx=(e,t,i)=>({u_matrix:e,u_world:i,u_emissive_strength:t}),nx=(e,t,i,r,n)=>z(ix(e,t,i,r),{u_world:n}),ox=(e,t,i,r)=>{const n=Ri/i.tileSize;return{u_matrix:e,u_camera_to_center_distance:t.getCameraToCenterDistance(r),u_extrude_scale:[t.pixelsToGLUnits[0]/n,t.pixelsToGLUnits[1]/n]}},ax=(e,t,i=1)=>({u_matrix:e,u_color:t,u_overlay:0,u_overlay_scale:i}),sx=ic.create(),lx=(e,t,i,r,n,o,a)=>{const s=e.transform,l="globe"===s.projection.name,c=l?Kc(s.zoom,t.canonical)*s._pixelsPerMercatorPixel:Wf(i,1,o),u={u_matrix:t.projMatrix,u_extrude_scale:c,u_intensity:a,u_inv_rot_matrix:sx,u_merc_center:[0,0],u_tile_id:[0,0,0],u_zoom_transition:0,u_up_dir:[0,0,0]};if(l){u.u_inv_rot_matrix=r,u.u_merc_center=n,u.u_tile_id=[t.canonical.x,t.canonical.y,1<<t.canonical.z],u.u_zoom_transition=Qc(s.zoom);const e=n[0]*Ri,i=n[1]*Ri;u.u_up_dir=s.projection.upVector(new CanonicalTileID(0,0,0),e,i)}return u},cx=(e,t,i,r,n,o,a,s,l,c,u)=>{return{u_matrix:e,u_normalize_matrix:t,u_globe_matrix:i,u_tl_parent:r,u_scale_parent:n,u_fade_t:o.mix,u_opacity:o.opacity*a.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:a.paint.get("raster-brightness-min"),u_brightness_high:a.paint.get("raster-brightness-max"),u_saturation_factor:(d=a.paint.get("raster-saturation"),d>0?1-1/(1.001-d):-d),u_contrast_factor:(h=a.paint.get("raster-contrast"),h>0?1/(1-h):1+h),u_spin_weights:ux(a.paint.get("raster-hue-rotate")),u_perspective_transform:s,u_colorization_mix:c,u_colorization_scale:hx(u),u_color_ramp:l};var h,d};function ux(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return[(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}function hx([e,t]){if(e===t)return[e,t];const i=(t+e)/2,r=(t-e)/2*256/255;return[-(e=i-r)/((t=i+r)-e),1/(t-e)]}const dx=ic.create(),px=(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_)=>{const g=n.transform,y={u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:g.getCameraToCenterDistance(m),u_rotate_symbol:+i,u_aspect_ratio:g.width/g.height,u_fade_change:n.options.fadeDuration?n.symbolFadeChange:1,u_matrix:o,u_label_plane_matrix:a,u_coord_matrix:s,u_is_text:+l,u_pitch_with_map:+r,u_texsize:c,u_texture:0,u_tile_id:[0,0,0],u_zoom_transition:0,u_inv_rot_matrix:dx,u_merc_center:[0,0],u_camera_forward:[0,0,0],u_ecef_origin:[0,0,0],u_tile_matrix:dx,u_up_vector:[0,-1,0],u_icon_transition:_||0};return"globe"===m.name&&(y.u_tile_id=[u.canonical.x,u.canonical.y,1<<u.canonical.z],y.u_zoom_transition=h,y.u_inv_rot_matrix=p,y.u_merc_center=d,y.u_camera_forward=g._camera.forward(),y.u_ecef_origin=function(e,t){const i=[0,0,0],r=Wc(Bc(t.canonical));return lc.transformMat4(i,i,r),lc.transformMat4(i,i,e),i}(g.globeMatrix,u.toUnwrapped()),y.u_tile_matrix=Float32Array.from(g.globeMatrix),y.u_up_vector=f),y},fx=(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_)=>z(px(e,t,i,r,n,o,a,s,l,c,h,d,p,f,m,_),{u_gamma_scale:r?n.transform.getCameraToCenterDistance(_)*Math.cos(n.terrain?0:n.transform._pitch):1,u_device_pixel_ratio:rt.devicePixelRatio,u_is_halo:+u,undefined:void 0}),mx=(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m)=>z(fx(e,t,i,r,n,o,a,s,!0,l,!0,u,h,d,p,f,m),{u_texsize_icon:c,u_texture_icon:1}),_x=(e,t,i,r)=>({u_matrix:e,u_emissive_strength:t,u_opacity:i,u_color:r}),gx=(e,t,i,r,n,o,a)=>z(function(e,t,i,r){const n=i.imageManager.getPattern(e.toString(),t),{width:o,height:a}=i.imageManager.getPixelSize(t),s=Math.pow(2,r.tileID.overscaledZ),l=r.tileSize*Math.pow(2,i.transform.tileZoom)/s,c=l*(r.tileID.canonical.x+r.tileID.wrap*s),u=l*r.tileID.canonical.y;return{u_image:0,u_pattern_tl:n.tl,u_pattern_br:n.br,u_texsize:[o,a],u_pattern_size:n.displaySize,u_tile_units_to_pixels:1/Wf(r,1,i.transform.tileZoom),u_pixel_coord_upper:[c>>16,u>>16],u_pixel_coord_lower:[65535&c,65535&u]}}(n,o,r,a),{u_matrix:e,u_emissive_strength:t,u_opacity:i}),yx={BaseColor:5,MetallicRoughness:6,Normal:7,Occlusion:8,Emission:9,ShadowMap0:10},xx=(e,t,i,r,n,o,a,s,l,c,u,h=[0,0,0])=>{const d=r.style.light,p=d.properties.get("position"),f=[-p.x,-p.y,p.z],m=ec.create();"viewport"===d.properties.get("anchor")&&(ec.fromRotation(m,-r.transform.angle),lc.transformMat3(f,f,m));const _="MASK"===c.alphaMode,g=d.properties.get("color"),y=u.paint.get("model-ambient-occlusion-intensity"),x=u.paint.get("model-color").constantOr(Wt.white),v=u.paint.get("model-color-mix-intensity").constantOr(0);return{u_matrix:e,u_lighting_matrix:t,u_normal_matrix:i,u_lightpos:f,u_lightintensity:d.properties.get("intensity"),u_lightcolor:[g.r,g.g,g.b],u_camera_pos:h,u_opacity:n,u_baseTextureIsAlpha:0,u_alphaMask:+_,u_alphaCutoff:c.alphaCutoff,u_baseColorFactor:[o.r,o.g,o.b,o.a],u_emissiveFactor:[a[0],a[1],a[2],1],u_metallicFactor:s,u_roughnessFactor:l,u_baseColorTexture:yx.BaseColor,u_metallicRoughnessTexture:yx.MetallicRoughness,u_normalTexture:yx.Normal,u_occlusionTexture:yx.Occlusion,u_emissionTexture:yx.Emission,u_color_mix:[x.r,x.g,x.b,v],u_aoIntensity:y}},vx=new Float32Array(16),bx=(e,t=vx,i=vx)=>({u_matrix:e,u_instance:t,u_node_matrix:i}),wx={fillExtrusion:e=>({u_matrix:new UniformMatrix4f(e),u_lightpos:new Uniform3f(e),u_lightintensity:new Uniform1f(e),u_lightcolor:new Uniform3f(e),u_vertical_gradient:new Uniform1f(e),u_opacity:new Uniform1f(e),u_edge_radius:new Uniform1f(e),u_ao:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_up_dir:new Uniform3f(e),u_height_lift:new Uniform1f(e),u_flood_light_color:new Uniform3f(e),u_vertical_scale:new Uniform1f(e),u_flood_light_intensity:new Uniform1f(e),u_ground_shadow_factor:new Uniform3f(e)}),fillExtrusionDepth:e=>({u_matrix:new UniformMatrix4f(e),u_edge_radius:new Uniform1f(e),u_vertical_scale:new Uniform1f(e)}),fillExtrusionPattern:e=>({u_matrix:new UniformMatrix4f(e),u_lightpos:new Uniform3f(e),u_lightintensity:new Uniform1f(e),u_lightcolor:new Uniform3f(e),u_vertical_gradient:new Uniform1f(e),u_height_factor:new Uniform1f(e),u_edge_radius:new Uniform1f(e),u_ao:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_up_dir:new Uniform3f(e),u_height_lift:new Uniform1f(e),u_image:new Uniform1i(e),u_texsize:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e),u_opacity:new Uniform1f(e)}),fillExtrusionGroundEffect:e=>({u_matrix:new UniformMatrix4f(e),u_opacity:new Uniform1f(e),u_ao_pass:new Uniform1f(e),u_meter_to_tile:new Uniform1f(e),u_ao:new Uniform2f(e),u_flood_light_intensity:new Uniform1f(e),u_flood_light_color:new Uniform3f(e),u_attenuation:new Uniform1f(e),u_edge_radius:new Uniform1f(e),u_fb:new Uniform1i(e),u_fb_size:new Uniform1f(e)}),fill:e=>({u_matrix:new UniformMatrix4f(e),u_emissive_strength:new Uniform1f(e)}),fillPattern:e=>({u_matrix:new UniformMatrix4f(e),u_emissive_strength:new Uniform1f(e),u_image:new Uniform1i(e),u_texsize:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e)}),fillOutline:e=>({u_matrix:new UniformMatrix4f(e),u_emissive_strength:new Uniform1f(e),u_world:new Uniform2f(e)}),fillOutlinePattern:e=>({u_matrix:new UniformMatrix4f(e),u_emissive_strength:new Uniform1f(e),u_world:new Uniform2f(e),u_image:new Uniform1i(e),u_texsize:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e)}),circle:e=>({u_camera_to_center_distance:new Uniform1f(e),u_extrude_scale:new UniformMatrix2f(e),u_device_pixel_ratio:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_up_dir:new Uniform3f(e),u_emissive_strength:new Uniform1f(e)}),collisionBox:e=>({u_matrix:new UniformMatrix4f(e),u_camera_to_center_distance:new Uniform1f(e),u_extrude_scale:new Uniform2f(e)}),collisionCircle:e=>({u_matrix:new UniformMatrix4f(e),u_inv_matrix:new UniformMatrix4f(e),u_camera_to_center_distance:new Uniform1f(e),u_viewport_size:new Uniform2f(e)}),debug:e=>({u_color:new UniformColor(e),u_matrix:new UniformMatrix4f(e),u_overlay:new Uniform1i(e),u_overlay_scale:new Uniform1f(e)}),clippingMask:e=>({u_matrix:new UniformMatrix4f(e)}),heatmap:e=>({u_extrude_scale:new Uniform1f(e),u_intensity:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_up_dir:new Uniform3f(e)}),heatmapTexture:e=>({u_image:new Uniform1i(e),u_color_ramp:new Uniform1i(e),u_opacity:new Uniform1f(e)}),hillshade:e=>({u_matrix:new UniformMatrix4f(e),u_image:new Uniform1i(e),u_latrange:new Uniform2f(e),u_light:new Uniform2f(e),u_shadow:new UniformColor(e),u_highlight:new UniformColor(e),u_emissive_strength:new Uniform1f(e),u_accent:new UniformColor(e)}),hillshadePrepare:e=>({u_matrix:new UniformMatrix4f(e),u_image:new Uniform1i(e),u_dimension:new Uniform2f(e),u_zoom:new Uniform1f(e),u_unpack:new Uniform4f(e)}),line:e=>({u_matrix:new UniformMatrix4f(e),u_pixels_to_tile_units:new UniformMatrix2f(e),u_device_pixel_ratio:new Uniform1f(e),u_units_to_pixels:new Uniform2f(e),u_dash_image:new Uniform1i(e),u_gradient_image:new Uniform1i(e),u_image_height:new Uniform1f(e),u_texsize:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e),u_alpha_discard_threshold:new Uniform1f(e),u_trim_offset:new Uniform2f(e),u_emissive_strength:new Uniform1f(e)}),linePattern:e=>({u_matrix:new UniformMatrix4f(e),u_texsize:new Uniform2f(e),u_pixels_to_tile_units:new UniformMatrix2f(e),u_device_pixel_ratio:new Uniform1f(e),u_image:new Uniform1i(e),u_units_to_pixels:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e),u_alpha_discard_threshold:new Uniform1f(e)}),raster:e=>({u_matrix:new UniformMatrix4f(e),u_normalize_matrix:new UniformMatrix4f(e),u_globe_matrix:new UniformMatrix4f(e),u_tl_parent:new Uniform2f(e),u_scale_parent:new Uniform1f(e),u_fade_t:new Uniform1f(e),u_opacity:new Uniform1f(e),u_image0:new Uniform1i(e),u_image1:new Uniform1i(e),u_brightness_low:new Uniform1f(e),u_brightness_high:new Uniform1f(e),u_saturation_factor:new Uniform1f(e),u_contrast_factor:new Uniform1f(e),u_spin_weights:new Uniform3f(e),u_perspective_transform:new Uniform2f(e),u_colorization_mix:new Uniform4f(e),u_colorization_scale:new Uniform2f(e),u_color_ramp:new Uniform1i(e)}),symbolIcon:e=>({u_is_size_zoom_constant:new Uniform1i(e),u_is_size_feature_constant:new Uniform1i(e),u_size_t:new Uniform1f(e),u_size:new Uniform1f(e),u_camera_to_center_distance:new Uniform1f(e),u_rotate_symbol:new Uniform1i(e),u_aspect_ratio:new Uniform1f(e),u_fade_change:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_label_plane_matrix:new UniformMatrix4f(e),u_coord_matrix:new UniformMatrix4f(e),u_is_text:new Uniform1i(e),u_pitch_with_map:new Uniform1i(e),u_texsize:new Uniform2f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_camera_forward:new Uniform3f(e),u_tile_matrix:new UniformMatrix4f(e),u_up_vector:new Uniform3f(e),u_ecef_origin:new Uniform3f(e),u_texture:new Uniform1i(e),u_icon_transition:new Uniform1f(e)}),symbolSDF:e=>({u_is_size_zoom_constant:new Uniform1i(e),u_is_size_feature_constant:new Uniform1i(e),u_size_t:new Uniform1f(e),u_size:new Uniform1f(e),u_camera_to_center_distance:new Uniform1f(e),u_rotate_symbol:new Uniform1i(e),u_aspect_ratio:new Uniform1f(e),u_fade_change:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_label_plane_matrix:new UniformMatrix4f(e),u_coord_matrix:new UniformMatrix4f(e),u_is_text:new Uniform1i(e),u_pitch_with_map:new Uniform1i(e),u_texsize:new Uniform2f(e),u_texture:new Uniform1i(e),u_gamma_scale:new Uniform1f(e),u_device_pixel_ratio:new Uniform1f(e),u_tile_id:new Uniform3f(e),u_zoom_transition:new Uniform1f(e),u_inv_rot_matrix:new UniformMatrix4f(e),u_merc_center:new Uniform2f(e),u_camera_forward:new Uniform3f(e),u_tile_matrix:new UniformMatrix4f(e),u_up_vector:new Uniform3f(e),u_ecef_origin:new Uniform3f(e),u_is_halo:new Uniform1i(e)}),symbolTextAndIcon:e=>({u_is_size_zoom_constant:new Uniform1i(e),u_is_size_feature_constant:new Uniform1i(e),u_size_t:new Uniform1f(e),u_size:new Uniform1f(e),u_camera_to_center_distance:new Uniform1f(e),u_rotate_symbol:new Uniform1i(e),u_aspect_ratio:new Uniform1f(e),u_fade_change:new Uniform1f(e),u_matrix:new UniformMatrix4f(e),u_label_plane_matrix:new UniformMatrix4f(e),u_coord_matrix:new UniformMatrix4f(e),u_is_text:new Uniform1i(e),u_pitch_with_map:new Uniform1i(e),u_texsize:new Uniform2f(e),u_texsize_icon:new Uniform2f(e),u_texture:new Uniform1i(e),u_texture_icon:new Uniform1i(e),u_gamma_scale:new Uniform1f(e),u_device_pixel_ratio:new Uniform1f(e),u_is_halo:new Uniform1i(e)}),background:e=>({u_matrix:new UniformMatrix4f(e),u_emissive_strength:new Uniform1f(e),u_opacity:new Uniform1f(e),u_color:new UniformColor(e)}),backgroundPattern:e=>({u_matrix:new UniformMatrix4f(e),u_emissive_strength:new Uniform1f(e),u_opacity:new Uniform1f(e),u_image:new Uniform1i(e),u_pattern_tl:new Uniform2f(e),u_pattern_br:new Uniform2f(e),u_texsize:new Uniform2f(e),u_pattern_size:new Uniform2f(e),u_pixel_coord_upper:new Uniform2f(e),u_pixel_coord_lower:new Uniform2f(e),u_tile_units_to_pixels:new Uniform1f(e)}),terrainRaster:By,terrainDepth:By,skybox:e=>({u_matrix:new UniformMatrix4f(e),u_sun_direction:new Uniform3f(e),u_cubemap:new Uniform1i(e),u_opacity:new Uniform1f(e),u_temporal_offset:new Uniform1f(e)}),skyboxGradient:e=>({u_matrix:new UniformMatrix4f(e),u_color_ramp:new Uniform1i(e),u_center_direction:new Uniform3f(e),u_radius:new Uniform1f(e),u_opacity:new Uniform1f(e),u_temporal_offset:new Uniform1f(e)}),skyboxCapture:e=>({u_matrix_3f:new UniformMatrix3f(e),u_sun_direction:new Uniform3f(e),u_sun_intensity:new Uniform1f(e),u_color_tint_r:new Uniform4f(e),u_color_tint_m:new Uniform4f(e),u_luminance:new Uniform1f(e)}),globeRaster:e=>({u_proj_matrix:new UniformMatrix4f(e),u_globe_matrix:new UniformMatrix4f(e),u_normalize_matrix:new UniformMatrix4f(e),u_merc_matrix:new UniformMatrix4f(e),u_zoom_transition:new Uniform1f(e),u_merc_center:new Uniform2f(e),u_image0:new Uniform1i(e),u_grid_matrix:new UniformMatrix3f(e),u_skirt_height:new Uniform1f(e),u_frustum_tl:new Uniform3f(e),u_frustum_tr:new Uniform3f(e),u_frustum_br:new Uniform3f(e),u_frustum_bl:new Uniform3f(e),u_globe_pos:new Uniform3f(e),u_globe_radius:new Uniform1f(e),u_viewport:new Uniform2f(e)}),globeAtmosphere:e=>({u_frustum_tl:new Uniform3f(e),u_frustum_tr:new Uniform3f(e),u_frustum_br:new Uniform3f(e),u_frustum_bl:new Uniform3f(e),u_horizon:new Uniform1f(e),u_transition:new Uniform1f(e),u_fadeout_range:new Uniform1f(e),u_color:new Uniform4f(e),u_high_color:new Uniform4f(e),u_space_color:new Uniform4f(e),u_temporal_offset:new Uniform1f(e),u_horizon_angle:new Uniform1f(e)}),model:e=>({u_matrix:new UniformMatrix4f(e),u_lighting_matrix:new UniformMatrix4f(e),u_normal_matrix:new UniformMatrix4f(e),u_lightpos:new Uniform3f(e),u_lightintensity:new Uniform1f(e),u_lightcolor:new Uniform3f(e),u_camera_pos:new Uniform3f(e),u_opacity:new Uniform1f(e),u_baseColorFactor:new Uniform4f(e),u_emissiveFactor:new Uniform4f(e),u_metallicFactor:new Uniform1f(e),u_roughnessFactor:new Uniform1f(e),u_baseTextureIsAlpha:new Uniform1i(e),u_alphaMask:new Uniform1i(e),u_alphaCutoff:new Uniform1f(e),u_baseColorTexture:new Uniform1i(e),u_metallicRoughnessTexture:new Uniform1i(e),u_normalTexture:new Uniform1i(e),u_occlusionTexture:new Uniform1i(e),u_emissionTexture:new Uniform1i(e),u_color_mix:new Uniform4f(e),u_aoIntensity:new Uniform1f(e)}),modelDepth:e=>({u_matrix:new UniformMatrix4f(e),u_instance:new UniformMatrix4f(e),u_node_matrix:new UniformMatrix4f(e)}),groundShadow:e=>({u_matrix:new UniformMatrix4f(e),u_ground_shadow_factor:new Uniform3f(e)}),stars:e=>({u_matrix:new UniformMatrix4f(e),u_up:new Uniform3f(e),u_right:new Uniform3f(e),u_intensity_multiplier:new Uniform1f(e)})};let Tx;function Ex(e,t,i,r,n,o,a){const s=e.context,l=s.gl,c=e.transform,u=e.getOrCreateProgram("collisionBox"),h=[];let d=0,p=0;for(let s=0;s<r.length;s++){const f=r[s],m=t.getTile(f),_=m.getBucket(i);if(!_)continue;const g=Yg(f,_,c);let y=g;0===n[0]&&0===n[1]||(y=e.translatePosMatrix(g,m,n,o));const x=a?_.textCollisionBox:_.iconCollisionBox,v=_.collisionCircleArray;if(v.length>0){const e=ic.create(),t=y;ic.mul(e,_.placementInvProjMatrix,c.glCoordMatrix),ic.mul(e,e,_.placementViewportMatrix),h.push({circleArray:v,circleOffset:p,transform:t,invTransform:e,projection:_.getProjection()}),d+=v.length/4,p=d}x&&(e.terrain&&e.terrain.setupElevationDraw(m,u),u.draw(e,l.LINES,DepthMode.disabled,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.disabled,ox(y,c,m,_.getProjection()),i.id,x.layoutVertexBuffer,x.indexBuffer,x.segments,null,c.zoom,null,[x.collisionVertexBuffer,x.collisionVertexBufferExt]))}if(!a||!h.length)return;const f=e.getOrCreateProgram("collisionCircle"),m=new StructArrayLayout2f1f2i16;m.resize(4*d),m._trim();let _=0;for(const e of h)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,r=e.circleArray[i+0],n=e.circleArray[i+1],o=e.circleArray[i+2],a=e.circleArray[i+3];m.emplace(_++,r,n,o,a,0),m.emplace(_++,r,n,o,a,1),m.emplace(_++,r,n,o,a,2),m.emplace(_++,r,n,o,a,3)}(!Tx||Tx.length<2*d)&&(Tx=function(e){const t=2*e,i=new StructArrayLayout3ui6;i.resize(t),i._trim();for(let e=0;e<t;e++){const t=6*e;i.uint16[t+0]=4*e+0,i.uint16[t+1]=4*e+1,i.uint16[t+2]=4*e+2,i.uint16[t+3]=4*e+2,i.uint16[t+4]=4*e+3,i.uint16[t+5]=4*e+0}return i}(d));const g=s.createIndexBuffer(Tx,!0),y=s.createVertexBuffer(m,hp.members,!0);for(const t of h){const r={u_matrix:t.transform,u_inv_matrix:t.invTransform,u_camera_to_center_distance:(x=c).getCameraToCenterDistance(t.projection),u_viewport_size:[x.width,x.height]};f.draw(e,l.TRIANGLES,DepthMode.disabled,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.disabled,r,i.id,y,g,SegmentVector.simpleSegment(0,2*t.circleOffset,t.circleArray.length,t.circleArray.length/2),null,c.zoom)}var x;y.destroy(),g.destroy()}const Mx=ic.create();function Sx({width:e,height:t,anchor:i,textOffset:r,textScale:n},o){const{horizontalAlign:a,verticalAlign:s}=Mp(i),l=-(a-.5)*e,c=-(s-.5)*t,u=Lp(i,r);return new g((l/n+u[0])*o,(c/n+u[1])*o)}function Ax(e,t,i,r,n,o,a,s,l,c,u){const h=e.text.placedSymbolArray,d=e.text.dynamicLayoutVertexArray,p=e.icon.dynamicLayoutVertexArray,f={},m=e.getProjection(),_=Kg(s,m,o),g=o.elevation,y=m.upVectorScale(s.canonical,o.center.lat,o.worldSize).metersToTile;d.clear();for(let p=0;p<h.length;p++){const x=h.get(p),{tileAnchorX:v,tileAnchorY:b,numGlyphs:w}=x,T=x.hidden||!x.crossTileID||e.allowVerticalPlacement&&!x.placedOrientation?null:r[x.crossTileID];if(T){let r=0,h=0,p=0;if(g){const e=g?g.getAtTileOffset(s,v,b):0,[t,i,n]=m.upVector(s.canonical,v,b);r=e*t*y,h=e*i*y,p=e*n*y}let[E,M,S,A]=em(x.projectedAnchorX+r,x.projectedAnchorY+h,x.projectedAnchorZ+p,i?_:a);const C=tm(o.getCameraToCenterDistance(m),A);let I=n.evaluateSizeForFeature(e.textSizeData,c,x)*C/24;i&&(I*=e.tilePixelRatio/l);const D=Sx(T,I);i?(({x:E,y:M,z:S}=m.projectTilePoint(v+D.x,b+D.y,s.canonical)),[E,M,S]=em(E+r,M+h,S+p,a)):(t&&D._rotate(-o.angle),E+=D.x,M+=D.y,S=0);const P=e.allowVerticalPlacement&&x.placedOrientation===Ep.vertical?Math.PI/2:0;for(let e=0;e<w;e++)of(d,E,M,S,P);u&&x.associatedIconIndex>=0&&(f[x.associatedIconIndex]={x:E,y:M,z:S,angle:P})}else um(w,d)}if(u){p.clear();const t=e.icon.placedSymbolArray;for(let e=0;e<t.length;e++){const i=t.get(e),{numGlyphs:r}=i,n=f[e];if(i.hidden||!n)um(r,p);else{const{x:e,y:t,z:i,angle:o}=n;for(let n=0;n<r;n++)of(p,e,t,i,o)}}e.icon.dynamicLayoutVertexBuffer.updateData(p)}e.text.dynamicLayoutVertexBuffer.updateData(d)}function Cx(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function Ix(e,t,i,r,n,o,a,s,l,c,u,h){const d=e.context,p=d.gl,f=e.transform,m="map"===s,_="map"===l,g=m&&"point"!==i.layout.get("symbol-placement"),y=m&&!_&&!g,x=void 0!==i.layout.get("symbol-sort-key").constantOr(1);let v=!1;const b=e.depthModeForSublayer(0,DepthMode.ReadOnly),w=[_u(f.center.lng),gu(f.center.lat)],T=i.layout.get("text-variable-anchor"),E="globe"===f.projection.name,M=[],S=[0,-1,0];let A=S;!E&&!f.mercatorFromTransition||m||(A=function(e){const t=e._camera.getWorldToCamera(e.worldSize,1),i=ic.multiply([],t,e.globeMatrix);ic.invert(i,i);const r=[0,0,0],n=[0,1,0,0];return Wl.transformMat4(n,n,i),r[0]=n[0],r[1]=n[1],r[2]=n[2],lc.normalize(r,r),r}(f));for(const s of r){const r=t.getTile(s),l=r.getBucket(i);if(!l)continue;if("mercator"===l.projection.name&&E)continue;const u=n?l.text:l.icon;if(!u||l.fullyClipped||!u.segments.get().length)continue;const h=u.programConfigurations.get(i.id),d=n||l.sdfIcons,b=n?l.textSizeData:l.iconSizeData,C=_||0!==f.pitch,I=mp(b,f.zoom);let D,P,L,z,R=[0,0],k=null;if(n)P=r.glyphAtlasTexture,L=p.LINEAR,D=r.glyphAtlasTexture.size,l.iconsInText&&(R=r.imageAtlasTexture.size,k=r.imageAtlasTexture,z=C||e.options.rotating||e.options.zooming||"composite"===b.kind||"camera"===b.kind?p.LINEAR:p.NEAREST);else{const t=1!==i.layout.get("icon-size").constantOr(0)||l.iconsNeedLinear;P=r.imageAtlasTexture,L=d||e.options.rotating||e.options.zooming||t||C?p.LINEAR:p.NEAREST,D=r.imageAtlasTexture.size}const B="globe"===l.projection.name,O=B?A:S,F=B?Qc(f.zoom):0,U=Kg(s,l.getProjection(),f),V=f.calculatePixelsToTileUnitsMatrix(r),N=Kf(U,r.tileID.canonical,_,m,f,l.getProjection(),V),j=e.terrain&&_&&g?ic.invert(ic.create(),N):Mx,G=Qf(U,r.tileID.canonical,_,m,f,l.getProjection(),V),q=T&&l.hasTextData(),Z=l.hasIconTextFit()&&q&&l.hasIconData();if(g){const t=f.elevation,i=t?t.getAtTileOffsetFunc(s,f.center.lat,f.worldSize,l.getProjection()):null,o=Jf(U,r.tileID.canonical,_,m,f,l.getProjection(),V);rm(l,U,e,n,o,G,_,c,i,s)}const $=g||n&&T||Z,H=e.translatePosMatrix(U,r,o,a),W=$?Mx:N,X=e.translatePosMatrix(G,r,o,a,!0),Y=l.getProjection().createInversionMatrix(f,s.canonical),K=i.paint.get("icon-image-cross-fade").constantOr(0),J=[];e.terrainRenderModeElevated()&&_&&J.push("PITCH_WITH_MAP_TERRAIN"),B&&(J.push("PROJECTION_GLOBE_VIEW"),$&&J.push("PROJECTED_POS_ON_VIEWPORT")),K>0&&J.push("ICON_TRANSITION"),u.zOffsetVertexBuffer&&J.push("Z_OFFSET");const Q=d&&0!==i.paint.get(n?"text-halo-width":"icon-halo-width").constantOr(1);let ee;ee=d?l.iconsInText?mx(b.kind,I,y,_,e,H,W,X,D,R,s,F,w,Y,O,l.getProjection()):fx(b.kind,I,y,_,e,H,W,X,n,D,!0,s,F,w,Y,O,l.getProjection()):px(b.kind,I,y,_,e,H,W,X,n,D,s,F,w,Y,O,l.getProjection(),K);const te={program:e.getOrCreateProgram(Cx(d,n,l),{config:h,defines:J}),buffers:u,uniformValues:ee,atlasTexture:P,atlasTextureIcon:k,atlasInterpolation:L,atlasInterpolationIcon:z,isSDF:d,hasHalo:Q,tile:r,labelPlaneMatrixInv:j};if(x&&l.canOverlap){v=!0;const e=u.segments.get();for(const t of e)M.push({segments:new SegmentVector([t]),sortKey:t.sortKey,state:te})}else M.push({segments:u.segments,sortKey:0,state:te})}v&&M.sort(((e,t)=>e.sortKey-t.sortKey));for(const t of M){const r=t.state;if(e.terrain&&e.terrain.setupElevationDraw(r.tile,r.program,{useDepthForOcclusion:f.depthOcclusionForSymbolsAndCircles,labelPlaneMatrixInv:r.labelPlaneMatrixInv}),d.activeTexture.set(p.TEXTURE0),r.atlasTexture.bind(r.atlasInterpolation,p.CLAMP_TO_EDGE),r.atlasTextureIcon&&(d.activeTexture.set(p.TEXTURE1),r.atlasTextureIcon&&r.atlasTextureIcon.bind(r.atlasInterpolationIcon,p.CLAMP_TO_EDGE)),e.uploadCommonLightUniforms(e.context,r.program),r.hasHalo){const n=r.uniformValues;n.u_is_halo=1,Dx(r.buffers,t.segments,i,e,r.program,b,u,h,n,2),n.u_is_halo=0}else{if(r.isSDF){const n=r.uniformValues;r.hasHalo&&(n.u_is_halo=1,Dx(r.buffers,t.segments,i,e,r.program,b,u,h,n,1)),n.u_is_halo=0}Dx(r.buffers,t.segments,i,e,r.program,b,u,h,r.uniformValues,1)}}}function Dx(e,t,i,r,n,o,a,s,l,c){const u=[e.dynamicLayoutVertexBuffer,e.opacityVertexBuffer,e.iconTransitioningVertexBuffer,e.globeExtVertexBuffer,e.zOffsetVertexBuffer];n.draw(r,r.context.gl.TRIANGLES,o,a,s,CullFaceMode.disabled,l,i.id,e.layoutVertexBuffer,e.indexBuffer,t,i.paint,r.transform.zoom,e.programConfigurations.get(i.id),u,c)}function Px(e,t,i,r,n,o,a){const s=e.context.gl,l=i.paint.get("fill-pattern"),c=l&&l.constantOr(1);let u,h,d,p,f;a?(h=c&&!i.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",u=s.LINES):(h=c?"fillPattern":"fill",u=s.TRIANGLES);for(const m of r){const r=t.getTile(m);if(c&&!r.patternsLoaded())continue;const _=r.getBucket(i);if(!_)continue;e.prepareDrawTile();const g=_.programConfigurations.get(i.id),y=e.isTileAffectedByFog(m),x=e.getOrCreateProgram(h,{config:g,overrideFog:y});c&&(e.context.activeTexture.set(s.TEXTURE0),r.imageAtlasTexture.bind(s.LINEAR,s.CLAMP_TO_EDGE),g.updatePaintBuffers());const v=l.constantOr(null);if(v&&r.imageAtlas){const e=r.imageAtlas.patternPositions[v.toString()];e&&g.setConstantPatternPositions(e)}const b=e.translatePosMatrix(m.projMatrix,r,i.paint.get("fill-translate"),i.paint.get("fill-translate-anchor")),w=i.paint.get("fill-emissive-strength");if(a){p=_.indexBuffer2,f=_.segments2;const t=e.terrain&&e.terrain.renderingToTexture?e.terrain.drapeBufferSize:[s.drawingBufferWidth,s.drawingBufferHeight];d="fillOutlinePattern"===h&&c?nx(b,w,e,r,t):rx(b,w,t)}else p=_.indexBuffer,f=_.segments,d=c?ix(b,w,e,r):tx(b,w);e.uploadCommonUniforms(e.context,x,m.toUnwrapped()),x.draw(e,u,n,e.stencilModeForClipping(m),o,CullFaceMode.disabled,d,i.id,_.layoutVertexBuffer,p,f,i.paint,e.transform.zoom,g,void 0)}}function Lx(e,t,i,r,n,o,a,s){const l=e.context,c=l.gl,u=e.transform,h=i.paint.get("fill-extrusion-pattern"),d=h.constantOr(1),p=i.paint.get("fill-extrusion-opacity"),f=e.style.enable3dLights(),m=i.paint.get(f&&!d?"fill-extrusion-ambient-occlusion-wall-radius":"fill-extrusion-ambient-occlusion-radius"),_=[i.paint.get("fill-extrusion-ambient-occlusion-intensity"),m],g=i.layout.get("fill-extrusion-edge-radius"),y=g>0&&!i.paint.get("fill-extrusion-rounded-roof"),x=y?0:g,v="globe"===u.projection.name?o_():0,b="globe"===u.projection.name,w=b?Qc(u.zoom):0,T=[_u(u.center.lng),gu(u.center.lat)],E=i.paint.get("fill-extrusion-flood-light-color").toArray01().slice(0,3),M=i.paint.get("fill-extrusion-flood-light-intensity"),S=i.paint.get("fill-extrusion-vertical-scale"),A=Uy(e,i.paint.get("fill-extrusion-cutoff-fade-range")),C=[];let I;b&&C.push("PROJECTION_GLOBE_VIEW"),_[0]>0&&C.push("FAUX_AO"),y&&C.push("ZERO_ROOF_RADIUS"),s&&C.push("HAS_CENTROID"),M>0&&C.push("FLOOD_LIGHT"),A.shouldRenderCutoff&&C.push("RENDER_CUTOFF");const D="shadow"===e.renderPass,P=e.shadowRenderer,L=D&&!!P;e.shadowRenderer&&(e.shadowRenderer.useNormalOffset=!0);let z=[0,0,0];if(P){const t=e.style.directionalLight,i=e.style.ambientLight;t&&i&&(z=_v(t,i)),I=C.concat(["SHADOWS_SINGLE_CASCADE"])}const R=L?"fillExtrusionDepth":d?"fillExtrusionPattern":"fillExtrusion";for(const f of r){const r=t.getTile(f),m=r.getBucket(i);if(!m||m.projection.name!==u.projection.name)continue;let g=!1;P&&(g=0===P.getMaxCascadeForTile(f.toUnwrapped()));const y=e.isTileAffectedByFog(f),L=m.programConfigurations.get(i.id),k=e.getOrCreateProgram(R,{config:L,defines:g?I:C,overrideFog:y});if(e.terrain){const t=e.terrain;e.style.terrainSetForDrapingOnly(),t.setupElevationDraw(r,k,{useMeterToDem:!0})}if(!m.centroidVertexBuffer){const e=k.attributes.a_centroid_pos;void 0!==e&&c.vertexAttrib2f(e,0,0)}!D&&P&&P.setupShadows(r.tileID.toUnwrapped(),k,"vector-tile",r.tileID.overscaledZ),d&&(e.context.activeTexture.set(c.TEXTURE0),r.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),L.updatePaintBuffers());const B=h.constantOr(null);if(B&&r.imageAtlas){const e=r.imageAtlas.patternPositions[B.toString()];e&&L.setConstantPatternPositions(e)}const O=i.paint.get("fill-extrusion-vertical-gradient");let F;if(D&&P){if(Fx(r.tileID,m,e))continue;const t=P.calculateShadowPassMatrixFromTile(r.tileID.toUnwrapped());F=Qy(t,x,S)}else{const t=e.translatePosMatrix(f.projMatrix,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),n=u.projection.createInversionMatrix(u,f.canonical);F=d?ex(t,e,O,p,_,x,f,r,v,w,T,n,E,S):Jy(t,e,O,p,_,x,f,v,w,T,n,E,S,M,z)}e.uploadCommonUniforms(l,k,f.toUnwrapped(),null,A);const U=[];(e.terrain||s)&&U.push(m.centroidVertexBuffer),b&&U.push(m.layoutVertexExtBuffer),k.draw(e,l.gl.TRIANGLES,n,o,a,CullFaceMode.backCCW,F,i.id,m.layoutVertexBuffer,m.indexBuffer,m.segments,i.paint,e.transform.zoom,L,U)}e.shadowRenderer&&(e.shadowRenderer.useNormalOffset=!1)}function zx(e,t,i,r,n,o,a,s,l,c,u,h,d,p,f,m,_,g,y){const x=e.context,v=x.gl,b=e.transform,w=e.transform.zoom,T=[],E=Uy(e,i.paint.get("fill-extrusion-cutoff-fade-range"));"clear"===c?(T.push("CLEAR_SUBPASS"),y&&(T.push("CLEAR_FROM_TEXTURE"),x.activeTexture.set(v.TEXTURE0),y.bind(v.LINEAR,v.CLAMP_TO_EDGE))):"sdf"===c&&T.push("SDF_SUBPASS"),_&&T.push("HAS_CENTROID"),E.shouldRenderCutoff&&T.push("RENDER_CUTOFF");const M=i.layout.get("fill-extrusion-edge-radius"),S=(t,r,c,g,v)=>{const b=r.programConfigurations.get(i.id),S=e.isTileAffectedByFog(t),A=e.getOrCreateProgram("fillExtrusionGroundEffect",{config:b,defines:T,overrideFog:S}),C=((e,t,i,r,n,o,a,s,l,c,u)=>({u_matrix:t,u_opacity:i,u_ao_pass:r?1:0,u_meter_to_tile:n,u_ao:o,u_flood_light_intensity:a,u_flood_light_color:s,u_attenuation:l,u_edge_radius:c,u_fb:0,u_fb_size:u}))(0,g,u,l,v,[h,d*v],p,f,m,w>=17?0:M*v,y?y.size[0]:0),I=[];_&&I.push(r.hiddenByLandmarkVertexBuffer),e.uploadCommonUniforms(x,A,t.toUnwrapped(),null,E),A.draw(e,x.gl.TRIANGLES,n,o,a,s,C,i.id,r.vertexBuffer,r.indexBuffer,c,i.paint,w,b,I)};for(const n of r){const r=t.getTile(n),o=r.getBucket(i);if(!o||o.projection.name!==b.projection.name||!o.groundEffect||o.groundEffect&&!o.groundEffect.hasData())continue;const a=o.groundEffect,s=1/o.tileToMeter;{const t=e.translatePosMatrix(n.projMatrix,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),o=a.getDefaultSegment();S(n,a,o,t,s)}if(g)for(let o=0;o<4;o++){const a=xc[o](n),l=t.getTile(a);if(!l)continue;const c=l.getBucket(i);if(!c||c.projection.name!==b.projection.name||!c.groundEffect||c.groundEffect&&!c.groundEffect.hasData())continue;const u=c.groundEffect;let h,d;0===o?(h=[-Ri,0,0],d=1):1===o?(h=[Ri,0,0],d=0):2===o?(h=[0,-Ri,0],d=3):(h=[0,Ri,0],d=2);const p=u.regionSegments[d];if(!p)continue;const f=new Float32Array(16);ic.translate(f,n.projMatrix,h),S(n,u,p,e.translatePosMatrix(f,r,i.paint.get("fill-extrusion-translate"),i.paint.get("fill-extrusion-translate-anchor")),s)}}}function Rx(e,t,i,r,n,o,a){0===r.centroidVertexArray.length&&r.createCentroidsBuffer();const s=o?o.findDEMTileFor(i):null;if(!(s&&s.dem||a))return;const l=e=>{const i=t.getSource().minzoom,r=e=>{const i=t.getTileByID(e);if(i&&i.hasData())return i.getBucket(n)},o=[0,-1,1];for(const t of o){if(e.overscaledZ+t<i)continue;const n=r(e.calculateScaledKey(e.overscaledZ+t));if(n)return n}},c=[0,0,0],u=(e,t)=>(c[0]=Math.min(e.min.y,t.min.y),c[1]=Math.max(e.max.y,t.max.y),c[2]=Ri-t.min.x>e.max.x?t.min.x-Ri:e.max.x,c),h=(e,t)=>(c[0]=Math.min(e.min.x,t.min.x),c[1]=Math.max(e.max.x,t.max.x),c[2]=Ri-t.min.y>e.max.y?t.min.y-Ri:e.max.y,c),d=[(e,t)=>u(e,t),(e,t)=>u(t,e),(e,t)=>h(e,t),(e,t)=>h(t,e)],p=(e,t,r,n,a,l,c)=>{if(!o)return 0;const u=[[l?r:e,l?e:r,0],[l?r:t,l?t:r,0]],h=c<0?Ri+c:c,d=[l?h:(e+t)/2,l?(e+t)/2:h,0];return 0===r&&c<0||0!==r&&c>0?o.getForTilePoints(a,[d],!0,n):u.push(d),o.getForTilePoints(i,u,!0,s),Math.max(u[0][2],u[1][2],d[2])/o.exaggeration()};for(let e=0;e<4;e++){const t=r.borderFeatureIndices[e];if(0===t.length)continue;const n=xc[e](i),s=l(n);if(!(s&&s instanceof FillExtrusionBucket))continue;if(r.borderDoneWithNeighborZ[e]===s.canonical.z)continue;0===s.centroidVertexArray.length&&s.createCentroidsBuffer();const c=o?o.findDEMTileFor(n):null;if(!(c&&c.dem||a))continue;const u=(e<2?1:5)-e,h=s.borderDoneWithNeighborZ[u]!==r.canonical.z,y=s.borderFeatureIndices[u];let x=0;if(r.canonical.z!==s.canonical.z){for(const e of t)r.showCentroid(r.featuresOnBorder[e]);if(h)for(const e of y)s.showCentroid(s.featuresOnBorder[e]);r.borderDoneWithNeighborZ[e]=s.canonical.z,s.borderDoneWithNeighborZ[u]=r.canonical.z}for(const i of t){const t=r.featuresOnBorder[i],o=r.centroidData[t.centroidDataIndex],l=t.borders[e];let h;for(;x<y.length;){h=s.featuresOnBorder[y[x]];const e=h.borders[u];if(e[1]>l[0]+3||e[0]>l[0]-3)break;s.showCentroid(h),x++}if(h&&x<y.length){const i=x;let v=0;for(;!(h.borders[u][0]>l[1]-3)&&(v++,++x!==y.length);)h=s.featuresOnBorder[y[x]];if(h=s.featuresOnBorder[y[i]],v>1){const e=h.borders[u];Math.abs(l[0]-e[0])<3&&Math.abs(l[1]-e[1])<3&&(v=1,x=i+1)}else if(0===v){r.showCentroid(t);continue}const b=s.centroidData[h.centroidDataIndex];a&&1===v&&(((m=o).flags|(_=b).flags)&Zm?(m.flags|=Zm,_.flags|=Zm):(m.flags&=2147483647,_.flags&=2147483647));let w=new g(0,0);if(v>1)x=i;else if(c&&c.dem&&!(t.intersectsCount()>1||h.intersectsCount()>1)){const t=d[e](o,b),i=e%2?Ri-1:0;f=p(t[0],Math.min(Ri-1,t[1]),i,c,n,e<2,t[2]),w=new g(Math.ceil(7*(f+450)),0)}o.centroidXY=b.centroidXY=w,r.writeCentroidToBuffer(o),s.writeCentroidToBuffer(b)}else r.showCentroid(t)}r.borderDoneWithNeighborZ[e]=s.canonical.z,s.borderDoneWithNeighborZ[u]=r.canonical.z}var f,m,_;(r.needsCentroidUpdate||!r.centroidVertexBuffer&&0!==r.centroidVertexArray.length)&&r.uploadCentroid(e)}const kx=[1,0,0],Bx=[0,1,0],Ox=[0,0,1];function Fx(e,t,i){const r=i.transform,n=i.shadowRenderer;if(!n)return!0;const o=e.toUnwrapped(),a=r.tileSize*n._cascades[i.currentShadowCascade].scale;let s=t.maxHeight;if(r.elevation){const t=r.elevation.getMinMaxForTile(e);t&&(s+=t.max)}const l=[...n.shadowDirection];l[2]=-l[2];const c=n.computeSimplifiedTileShadowVolume(o,s,a,l);if(!c)return!1;const u=[kx,Bx,Ox,l,[l[0],0,l[2]],[0,l[1],l[2]]],h="globe"===r.projection.name,d=r.scaleZoom(a),p=Frustum.fromInvProjectionMatrix(r.invProjMatrix,r.worldSize,d,!h),f=n.getCurrentCascadeFrustum();return 0===p.intersectsPrecise(c.vertices,c.planes,u)||0===f.intersectsPrecise(c.vertices,c.planes,u)}const Ux=new Wt(1,0,0,1),Vx=new Wt(0,1,0,1),Nx=new Wt(0,0,1,1),jx=new Wt(1,0,1,1),Gx=new Wt(0,1,1,1);function qx(e,t,i){const r=e.context,n=e.transform,o=r.gl,a="globe"===n.projection.name,s=a?["PROJECTION_GLOBE_VIEW"]:[];let l=i.projMatrix;if(a&&Qc(n.zoom)>0){const e=Xc(Fc(i.canonical,n));l=ic.multiply(new Float32Array(16),n.globeMatrix,e),ic.multiply(l,n.projMatrix,l)}const c=e.getOrCreateProgram("debug",{defines:s}),u=t.getTileByID(i.key);e.terrain&&e.terrain.setupElevationDraw(u,c);const h=DepthMode.disabled,d=StencilMode.disabled,p=e.colorModeForRenderPass(),f="$debug";r.activeTexture.set(o.TEXTURE0),e.emptyTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE),a?u._makeGlobeTileDebugBuffers(e.context,n):u._makeDebugTileBoundsBuffers(e.context,n.projection);const m=u._tileDebugBuffer||e.debugBuffer,_=u._tileDebugIndexBuffer||e.debugIndexBuffer,g=u._tileDebugSegments||e.debugSegments;c.draw(e,o.LINE_STRIP,h,d,p,CullFaceMode.disabled,ax(l,Wt.red),f,m,_,g,null,null,null,[u._globeTileDebugBorderBuffer]);const y=u.latestRawTileData,x=Math.floor((y&&y.byteLength||0)/1024),v=t.getTile(i).tileSize,b=512/Math.min(v,512)*(i.overscaledZ/n.zoom)*.5;let w=i.canonical.toString();i.overscaledZ!==i.canonical.z&&(w+=` => ${i.overscaledZ}`),w+=` ${x}kb`,function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,r=e.context.gl,n=e.debugOverlayCanvas.getContext("2d");n.clearRect(0,0,i.width,i.height),n.shadowColor="white",n.shadowBlur=2,n.lineWidth=1.5,n.strokeStyle="white",n.textBaseline="top",n.font="bold 36px Open Sans, sans-serif",n.fillText(t,5,5),n.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE)}(e,w);const T=u._tileDebugTextBuffer||e.debugBuffer,E=u._tileDebugTextIndexBuffer||e.quadTriangleIndexBuffer,M=u._tileDebugTextSegments||e.debugSegments;c.draw(e,o.TRIANGLES,h,d,ColorMode.alphaBlended,CullFaceMode.disabled,ax(l,Wt.transparent,b),f,T,E,M,null,null,null,[u._globeTileDebugTextBuffer])}function Zx(e,t,i,r){Hx(e,0,t+i/2,e.transform.width,i,r)}function $x(e,t,i,r){Hx(e,t-i/2,0,i,e.transform.height,r)}function Hx(e,t,i,r,n,o){const a=e.context,s=a.gl;s.enable(s.SCISSOR_TEST),s.scissor(t*rt.devicePixelRatio,i*rt.devicePixelRatio,r*rt.devicePixelRatio,n*rt.devicePixelRatio),a.clear({color:o}),s.disable(s.SCISSOR_TEST)}const Wx=ha([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:Xx}=Wx;function Yx(e,t,i,r){e.emplaceBack(t,i,r)}class SkyboxGeometry{constructor(e){this.vertexArray=new StructArrayLayout3f12,this.indices=new StructArrayLayout3ui6,Yx(this.vertexArray,-1,-1,1),Yx(this.vertexArray,1,-1,1),Yx(this.vertexArray,-1,1,1),Yx(this.vertexArray,1,1,1),Yx(this.vertexArray,-1,-1,-1),Yx(this.vertexArray,1,-1,-1),Yx(this.vertexArray,-1,1,-1),Yx(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=e.createVertexBuffer(this.vertexArray,Xx),this.indexBuffer=e.createIndexBuffer(this.indices),this.segment=SegmentVector.simpleSegment(0,0,36,12)}}function Kx(e,t,i,r,n,o){const a=e.context.gl,s=t.paint.get("sky-atmosphere-color"),l=t.paint.get("sky-atmosphere-halo-color"),c=t.paint.get("sky-atmosphere-sun-intensity"),u=((e,t,i,r,n)=>({u_matrix_3f:e,u_sun_direction:t,u_sun_intensity:i,u_color_tint_r:[r.r,r.g,r.b,r.a],u_color_tint_m:[n.r,n.g,n.b,n.a],u_luminance:5e-5}))(ec.fromMat4(ec.create(),r),n,c,s,l);a.framebufferTexture2D(a.FRAMEBUFFER,a.COLOR_ATTACHMENT0,a.TEXTURE_CUBE_MAP_POSITIVE_X+o,t.skyboxTexture,0),i.draw(e,a.TRIANGLES,DepthMode.disabled,StencilMode.disabled,ColorMode.unblended,CullFaceMode.frontCW,u,"skyboxCapture",t.skyboxGeometry.vertexBuffer,t.skyboxGeometry.indexBuffer,t.skyboxGeometry.segment)}const Jx=ha([{type:"Float32",name:"a_pos",components:3},{type:"Float32",name:"a_uv",components:2}]);class AtmosphereBuffer{constructor(e){const t=new StructArrayLayout5f20;t.emplaceBack(-1,1,1,0,0),t.emplaceBack(1,1,1,1,0),t.emplaceBack(1,-1,1,1,1),t.emplaceBack(-1,-1,1,0,1);const i=new StructArrayLayout3ui6;i.emplaceBack(0,1,2),i.emplaceBack(2,3,0),this.vertexBuffer=e.createVertexBuffer(t,Jx.members),this.indexBuffer=e.createIndexBuffer(i),this.segments=SegmentVector.simpleSegment(0,0,4,2)}destroy(){this.vertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy()}}const Qx=ha([{type:"Float32",name:"a_pos_3f",components:3},{type:"Float32",name:"a_uv",components:2},{type:"Float32",name:"a_size_scale",components:1},{type:"Float32",name:"a_fade_opacity",components:1}]);class Atmosphere{constructor(){this.colorModeAlphaBlendedWriteRGB=new ColorMode([1,Sf,1,Sf],Wt.transparent,[!0,!0,!0,!1]),this.colorModeWriteAlpha=new ColorMode([1,0,1,0],Wt.transparent,[!1,!1,!1,!0])}update(e){const t=e.context;if(!this.atmosphereBuffer){this.atmosphereBuffer=new AtmosphereBuffer(t);const e=100,i=200,r=function(e){const t=on(30),i=[];for(let e=0;e<16e3;++e){const e=2*Math.PI*t(),r=Math.acos(1-2*t())-.5*Math.PI;i.push(lc.fromValues(Math.cos(r)*Math.cos(e),Math.cos(r)*Math.sin(e),Math.sin(r)))}return i}(),n=on(300),o=new StructArrayLayout7f28,a=new StructArrayLayout3ui6;let s=0;for(let t=0;t<r.length;++t){const l=lc.scale([],r[t],200),c=Math.max(0,1+.01*e*(1*n()-.5)),u=Math.max(0,1+.01*i*(1*n()-.5));o.emplaceBack(l[0],l[1],l[2],-1,-1,c,u),o.emplaceBack(l[0],l[1],l[2],1,-1,c,u),o.emplaceBack(l[0],l[1],l[2],1,1,c,u),o.emplaceBack(l[0],l[1],l[2],-1,1,c,u),a.emplaceBack(s+0,s+1,s+2),a.emplaceBack(s+0,s+2,s+3),s+=4}this.starsVx=t.createVertexBuffer(o,Qx.members),this.starsIdx=t.createIndexBuffer(a),this.starsSegments=SegmentVector.simpleSegment(0,0,o.length,a.length)}}destroy(){this.atmosphereBuffer&&this.atmosphereBuffer.destroy(),this.starsVx&&this.starsVx.destroy(),this.starsIdx&&this.starsIdx.destroy()}drawAtmosphereGlow(e,t){const i=e.context,r=i.gl,n=e.transform,o=new DepthMode(r.LEQUAL,DepthMode.ReadOnly,[0,1]),a=Qc(n.zoom),s=t.properties.get("color").toArray01(),l=t.properties.get("high-color").toArray01(),c=t.properties.get("space-color").toArray01PremultipliedAlpha(),u=5e-4,h=I((t.properties.get("horizon-blend")-0)/1*.2495+u,5e-4,.25),d=tu(e,i,n)&&h===u?n.worldSize/(2*Math.PI*1.025)-1:n.globeRadius,p=e.frameCounter/1e3%1,f=lc.length(n.globeCenterInViewSpace),m=Math.sqrt(Math.pow(f,2)-Math.pow(d,2)),_=Math.acos(m/f),g=t=>{const u="globe"===n.projection.name?["PROJECTION_GLOBE_VIEW","FOG"]:["FOG"];t&&u.push("ALPHA_PASS");const d=e.getOrCreateProgram("globeAtmosphere",{defines:u}),f=((e,t,i,r,n,o,a,s,l,c,u,h)=>({u_frustum_tl:e,u_frustum_tr:t,u_frustum_br:i,u_frustum_bl:r,u_horizon:n,u_transition:o,u_fadeout_range:a,u_color:s,u_high_color:l,u_space_color:c,u_temporal_offset:u,u_horizon_angle:h}))(n.frustumCorners.TL,n.frustumCorners.TR,n.frustumCorners.BR,n.frustumCorners.BL,n.frustumCorners.horizon,a,h,s,l,c,p,_);e.uploadCommonUniforms(i,d);const m=this.atmosphereBuffer;m&&d.draw(e,r.TRIANGLES,o,StencilMode.disabled,t?this.colorModeWriteAlpha:this.colorModeAlphaBlendedWriteRGB,CullFaceMode.backCW,f,t?"atmosphere_glow_alpha":"atmosphere_glow",m.vertexBuffer,m.indexBuffer,m.segments)};g(!1),g(!0)}drawStars(e,t){const i=I(t.properties.get("star-intensity"),0,1);if(0===i)return;const r=e.context,n=r.gl,o=e.transform,a=e.getOrCreateProgram("stars"),s=nc.identity([]);nc.rotateX(s,s,-o._pitch),nc.rotateZ(s,s,-o.angle),nc.rotateX(s,s,b(o._center.lat)),nc.rotateY(s,s,-b(o._center.lng));const l=ic.fromQuat(new Float32Array(16),s),c=ic.multiply([],o.starsProjMatrix,l),u=ec.fromMat4([],l),h=ec.invert([],u),d=[0,1,0];lc.transformMat3(d,d,h),lc.scale(d,d,.15);const p=[1,0,0];lc.transformMat3(p,p,h),lc.scale(p,p,.15);const f=((e,t,i,r)=>({u_matrix:Float32Array.from(e),u_up:t,u_right:i,u_intensity_multiplier:r}))(c,d,p,i);e.uploadCommonUniforms(r,a),this.starsVx&&this.starsIdx&&a.draw(e,n.TRIANGLES,DepthMode.disabled,StencilMode.disabled,this.colorModeAlphaBlendedWriteRGB,CullFaceMode.disabled,f,"atmosphere_stars",this.starsVx,this.starsIdx,this.starsSegments)}}function ev(e,t){const i=[...e],r=t.cameraWorldSizeForFog/t.worldSize,n=ic.identity([]);return ic.scale(n,n,[r,r,1]),ic.multiply(i,n,i),ic.multiply(i,t.worldToFogMatrix,i),i}function tv(e,t,i,r){const n=i.material,o=r.context,{baseColorTexture:a,metallicRoughnessTexture:s}=n.pbrMetallicRoughness,{normalTexture:l,occlusionTexture:c,emissionTexture:u}=n;function h(t,i,r){if(t&&(e.push(i),o.activeTexture.set(o.gl.TEXTURE0+r),t.gfxTexture)){const{minFilter:e,magFilter:i,wrapS:r,wrapT:n}=t.sampler;t.gfxTexture.bindExtraParam(e,i,r,n)}}h(a,"HAS_TEXTURE_u_baseColorTexture",yx.BaseColor),h(s,"HAS_TEXTURE_u_metallicRoughnessTexture",yx.MetallicRoughness),h(l,"HAS_TEXTURE_u_normalTexture",yx.Normal),h(c,"HAS_TEXTURE_u_occlusionTexture",yx.Occlusion),h(u,"HAS_TEXTURE_u_emissionTexture",yx.Emission),i.texcoordBuffer&&(e.push("HAS_ATTRIBUTE_a_uv_2f"),t.push(i.texcoordBuffer)),i.colorBuffer&&(e.push(12===i.colorBuffer.itemSize?"HAS_ATTRIBUTE_a_color_3f":"HAS_ATTRIBUTE_a_color_4f"),t.push(i.colorBuffer)),i.normalBuffer&&(e.push("HAS_ATTRIBUTE_a_normal_3f"),t.push(i.normalBuffer)),i.pbrBuffer&&(e.push("HAS_ATTRIBUTE_a_pbr"),e.push("HAS_ATTRIBUTE_a_heightBasedEmissiveStrength"),t.push(i.pbrBuffer)),"OPAQUE"!==n.alphaMode&&"MASK"!==n.alphaMode||e.push("UNPREMULT_TEXTURE_IN_SHADER"),n.defined||e.push("DIFFUSE_SHADED"),e.push("USE_STANDARD_DERIVATIVES")}function iv(e,t,i,r,n,o){const a=i.paint.get("model-opacity"),s=t.context,l=new DepthMode(t.context.gl.LEQUAL,DepthMode.ReadWrite,t.depthRangeFor3D),c=t.transform,u=e.mesh,h=u.material,d=h.pbrMetallicRoughness,p=t.style.fog;let f;f="pixels"===t.transform.projection.zAxisUnit?[...e.nodeModelMatrix]:ic.multiply([],r.zScaleMatrix,e.nodeModelMatrix),ic.multiply(f,r.negCameraPosMatrix,f);const m=ic.invert([],f);ic.transpose(m,m);const _=xx(new Float32Array(e.worldViewProjection),new Float32Array(f),new Float32Array(m),t,a,d.baseColorFactor,h.emissiveFactor,d.metallicFactor,d.roughnessFactor,h,i),g={defines:[]},y=[];tv(g.defines,y,u,t);const x=t.shadowRenderer;x&&(x.useNormalOffset=!1);let v=null;if(p){const i=ev(e.nodeModelMatrix,t.transform);if(v=new Float32Array(i),"globe"!==c.projection.name){const e=u.aabb.min,t=u.aabb.max,[r,n]=p.getOpacityForBounds(i,e[0],e[1],t[0],t[1]);g.overrideFog=r>=V_||n>=V_}}const b=Uy(t,i.paint.get("model-cutoff-fade-range"));b.shouldRenderCutoff&&g.defines.push("RENDER_CUTOFF");const w=t.getOrCreateProgram("model",g);t.uploadCommonUniforms(s,w,null,v,b),"shadow"!==t.renderPass&&x&&x.setupShadowsFromMatrix(e.nodeModelMatrix,w),w.draw(t,s.gl.TRIANGLES,l,n,o,u.material.doubleSided?CullFaceMode.disabled:CullFaceMode.backCCW,_,i.id,u.vertexBuffer,u.indexBuffer,u.segments,i.paint,t.transform.zoom,void 0,y)}function rv(e,t,i,r,n,o,a){let s;s="globe"===e.projection.name?_m(i,e):[...i],ic.multiply(s,s,t.matrix);const l=ic.multiply([],r,s);if(t.meshes)for(const e of t.meshes){if("BLEND"!==e.material.alphaMode){a.push({mesh:e,depth:0,modelIndex:n,worldViewProjection:l,nodeModelMatrix:s});continue}const t=lc.transformMat4([],e.centroid,l);t[2]>0&&o.push({mesh:e,depth:t[2],modelIndex:n,worldViewProjection:l,nodeModelMatrix:s})}if(t.children)for(const s of t.children)rv(e,s,i,r,n,o,a)}function nv(e,t,i,r){const n=i.shadowRenderer;if(!n)return;const o=n.getShadowPassDepthMode(),a=n.getShadowPassColorMode(),s=n.calculateShadowPassMatrixFromMatrix(t),l=bx(s);i.getOrCreateProgram("modelDepth",{defines:["DEPTH_TEXTURE"]}).draw(i,i.context.gl.TRIANGLES,o,StencilMode.disabled,a,CullFaceMode.backCCW,l,r.id,e.vertexBuffer,e.indexBuffer,e.segments,r.paint,i.transform.zoom,void 0,void 0)}function ov(e,t,i){const r=t.updateZoomBasedPaintProperties(),n=function(e,t,i){let r,n,o,a=e.terrain?e.terrain.exaggeration():0;if(e.terrain&&a>0){const t=e.terrain,n=t.findDEMTileFor(i);n&&n.dem?r=DEMSampler.create(t,i,n):a=0}if(0===a&&(t.terrainElevationMin=0,t.terrainElevationMax=0),a===t.validForExaggeration&&(0===a||r&&r._demTile&&r._demTile.tileID===t.validForDEMTile.id&&r._dem._timestamp===t.validForDEMTile.timestamp))return!1;for(const e in t.instancesPerModel){const i=t.instancesPerModel[e];for(let e=0;e<i.instancedDataArray.length;++e){const s=(r?a*r.getElevationAt(0|i.instancedDataArray.float32[16*e],0|i.instancedDataArray.float32[16*e+1],!0,!0):0)+i.instancesEvaluatedElevation[e];i.instancedDataArray.float32[16*e+6]=s,n=n?Math.min(t.terrainElevationMin,s):s,o=o?Math.max(t.terrainElevationMax,s):s}}return t.terrainElevationMin=n||0,t.terrainElevationMax=o||0,t.validForExaggeration=a,t.validForDEMTile=r&&r._demTile?{id:r._demTile.tileID,timestamp:r._dem._timestamp}:{id:void 0,timestamp:0},!0}(e,t,i);(r||n)&&(t.uploaded=!1,t.upload(e.context))}const av={shadowUniformsInitialized:!1,useSingleShadowCascade:!1,tileMatrix:new Float64Array(16),shadowTileMatrix:new Float32Array(16),aabb:new Aabb([0,0,0],[Ri,Ri,0])};function sv(e,t){const i=1<<e.canonical.z,r=t.getFreeCameraOptions().position,n=t.elevation,o=e.canonical.x/i,a=(e.canonical.x+1)/i,s=e.canonical.y/i,l=(e.canonical.y+1)/i;let c=t._centerAltitude;if(n){const t=n.getMinMaxForTile(e);t&&t.max>c&&(c=t.max)}const u=I(r.x,o,a)-r.x,h=I(r.y,s,l)-r.y,d=yu(c,t.center.lat)-r.z;return t._zoomFromMercatorZ(Math.sqrt(u*u+h*h+d*d))}function lv(e,t,i,r,n,o,a){const s=e.context,l="shadow"===e.renderPass,c=e.shadowRenderer,u=l&&c?c.getShadowPassDepthMode():new DepthMode(s.gl.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D),h=e.isTileAffectedByFog(o);if(i.meshes)for(const d of i.meshes){const p=["MODEL_POSITION_ON_GPU"],f=[];let m,_,g;r.instancedDataArray.length>20&&p.push("INSTANCED_ARRAYS");const y=Uy(e,t.paint.get("model-cutoff-fade-range"));if(y.shouldRenderCutoff&&p.push("RENDER_CUTOFF"),l&&c)m=e.getOrCreateProgram("modelDepth",{defines:p}),_=bx(a.shadowTileMatrix,a.shadowTileMatrix,Float32Array.from(i.matrix)),g=c.getShadowPassColorMode();else{tv(p,f,d,e),m=e.getOrCreateProgram("model",{defines:p,overrideFog:h});const r=d.material,l=r.pbrMetallicRoughness,u=t.paint.get("model-opacity");_=xx(o.projMatrix,Float32Array.from(i.matrix),new Float32Array(16),e,u,l.baseColorFactor,r.emissiveFactor,l.metallicFactor,l.roughnessFactor,r,t,n),c&&(a.shadowUniformsInitialized?m.setShadowUniformValues(s,c.getShadowUniformValues()):(c.setupShadows(o.toUnwrapped(),m,"model-tile",o.overscaledZ),a.shadowUniformsInitialized=!0)),g=y.shouldRenderCutoff||u<1||"OPAQUE"!==r.alphaMode?ColorMode.alphaBlended:ColorMode.unblended}e.uploadCommonUniforms(s,m,o.toUnwrapped(),null,y);const x=d.material.doubleSided?CullFaceMode.disabled:CullFaceMode.backCCW;if(r.instancedDataArray.length>20)f.push(r.instancedDataBuffer),m.draw(e,s.gl.TRIANGLES,u,StencilMode.disabled,g,x,_,t.id,d.vertexBuffer,d.indexBuffer,d.segments,t.paint,e.transform.zoom,void 0,f,r.instancedDataArray.length);else{const i=l?"u_instance":"u_normal_matrix";for(let n=0;n<r.instancedDataArray.length;++n)_[i]=new Float32Array(r.instancedDataArray.arrayBuffer,64*n,16),m.draw(e,s.gl.TRIANGLES,u,StencilMode.disabled,g,x,_,t.id,d.vertexBuffer,d.indexBuffer,d.segments,t.paint,e.transform.zoom,void 0,f)}}if(i.children)for(const s of i.children)lv(e,t,s,r,n,o,a)}const cv=[1,-1,1];function uv(e,t,i,r){if(!i.modelManager)return!0;const n=i.modelManager;if(!i.shadowRenderer)return!0;const o=i.shadowRenderer,a=t.aabb;let s=!0,l=e.maxHeight;if(0===l){let t=0;for(const i in e.instancesPerModel){const e=n.getModel(i,r);e?t=Math.max(t,Math.max(Math.max(e.aabb.max[0],e.aabb.max[1]),e.aabb.max[2])):s=!1}l=e.maxScale*t*1.41+e.maxVerticalOffset,s&&(e.maxHeight=l)}a.max[2]=l,a.min[2]+=e.terrainElevationMin,a.max[2]+=e.terrainElevationMax,lc.transformMat4(a.min,a.min,t.tileMatrix),lc.transformMat4(a.max,a.max,t.tileMatrix);const c=a.intersects(o.getCurrentCascadeFrustum());return 0===i.currentShadowCascade&&(e.isInsideFirstShadowMapFrustum=2===c),0===c}class CacheEntry{}class WireframeDebugCache{constructor(){this._storage=new Map}getLinesFromTrianglesBuffer(e,t,i){{const i=this._storage.get(t.id);if(i)return i.lastUsedFrameIdx=e,i.buf}const r=i.gl,n=r.getBufferParameter(r.ELEMENT_ARRAY_BUFFER,r.BUFFER_SIZE),o=new ArrayBuffer(n),a=new Int16Array(o);r.getBufferSubData(r.ELEMENT_ARRAY_BUFFER,0,new Int16Array(o));const s=new StructArrayLayout2ui4;for(let e=0;e<n/2;e+=3){const t=a[e],i=a[e+1],r=a[e+2];s.emplaceBack(t,i),s.emplaceBack(i,r),s.emplaceBack(r,t)}const l=i.bindVertexArrayOES.current,c=new CacheEntry;return c.buf=new IndexBuffer(i,s),c.lastUsedFrameIdx=e,this._storage.set(t.id,c),i.bindVertexArrayOES.set(l),c.buf}update(e){for(const[t,i]of this._storage)e-i.lastUsedFrameIdx>30&&(i.buf.destroy(),this._storage.delete(t))}destroy(){for(const[e,t]of this._storage)t.buf.destroy(),this._storage.delete(e)}}const hv={symbol:function(e,t,i,r,n){if("translucent"!==e.renderPass)return;const o=StencilMode.disabled,a=e.colorModeForRenderPass();i.layout.get("text-variable-anchor")&&function(e,t,i,r,n,o,a){const s=t.transform,l="map"===n,c="map"===o;for(const t of e){const e=r.getTile(t),n=e.getBucket(i);if(!n||!n.text||!n.text.segments.get().length)continue;const o=mp(n.textSizeData,s.zoom),u=Kg(t,n.getProjection(),s),h=s.calculatePixelsToTileUnitsMatrix(e),d=Kf(u,e.tileID.canonical,c,l,s,n.getProjection(),h),p=n.hasIconTextFit()&&n.hasIconData();if(o){const i=Math.pow(2,s.zoom-e.tileID.overscaledZ);Ax(n,l,c,a,_p,s,d,t,i,o,p)}}}(r,e,i,t,i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),n),0!==i.paint.get("icon-opacity").constantOr(1)&&Ix(e,t,i,r,!1,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),i.layout.get("icon-rotation-alignment"),i.layout.get("icon-pitch-alignment"),i.layout.get("icon-keep-upright"),o,a),0!==i.paint.get("text-opacity").constantOr(1)&&Ix(e,t,i,r,!0,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),i.layout.get("text-rotation-alignment"),i.layout.get("text-pitch-alignment"),i.layout.get("text-keep-upright"),o,a),t.map.showCollisionBoxes&&(Ex(e,t,i,r,i.paint.get("text-translate"),i.paint.get("text-translate-anchor"),!0),Ex(e,t,i,r,i.paint.get("icon-translate"),i.paint.get("icon-translate-anchor"),!1))},circle:function(e,t,i,r){if("translucent"!==e.renderPass)return;const n=i.paint.get("circle-opacity"),o=i.paint.get("circle-stroke-width"),a=i.paint.get("circle-stroke-opacity"),s=void 0!==i.layout.get("circle-sort-key").constantOr(1),l=i.paint.get("circle-emissive-strength");if(0===n.constantOr(1)&&(0===o.constantOr(1)||0===a.constantOr(1)))return;const c=e.context,u=c.gl,h=e.transform,d=e.depthModeForSublayer(0,DepthMode.ReadOnly),p=StencilMode.disabled,f=e.colorModeForDrapableLayerRenderPass(l),m="globe"===h.projection.name,_=[_u(h.center.lng),gu(h.center.lat)],g=[];for(let n=0;n<r.length;n++){const o=r[n],a=t.getTile(o),l=a.getBucket(i);if(!l||l.projection.name!==h.projection.name)continue;const c=l.programConfigurations.get(i.id),u=ah(i),d=e.isTileAffectedByFog(o);m&&u.push("PROJECTION_GLOBE_VIEW");const p=e.getOrCreateProgram("circle",{config:c,defines:u,overrideFog:d}),f=l.layoutVertexBuffer,y=l.globeExtVertexBuffer,x=l.indexBuffer,v=h.projection.createInversionMatrix(h,o.canonical),b={programConfiguration:c,program:p,layoutVertexBuffer:f,globeExtVertexBuffer:y,indexBuffer:x,uniformValues:oh(e,o,a,v,_,i),tile:a};if(s){const e=l.segments.get();for(const t of e)g.push({segments:new SegmentVector([t]),sortKey:t.sortKey,state:b})}else g.push({segments:l.segments,sortKey:0,state:b})}s&&g.sort(((e,t)=>e.sortKey-t.sortKey));const y={useDepthForOcclusion:h.depthOcclusionForSymbolsAndCircles};for(const t of g){const{programConfiguration:r,program:n,layoutVertexBuffer:o,globeExtVertexBuffer:a,indexBuffer:s,uniformValues:l,tile:m}=t.state,_=t.segments;e.terrain&&e.terrain.setupElevationDraw(m,n,y),e.uploadCommonUniforms(c,n,m.tileID.toUnwrapped()),n.draw(e,u.TRIANGLES,d,p,f,CullFaceMode.disabled,l,i.id,o,s,_,i.paint,h.zoom,r,[a])}},heatmap:function(e,t,i,r){if(0!==i.paint.get("heatmap-opacity"))if("offscreen"===e.renderPass){const n=e.context,o=n.gl,a=StencilMode.disabled,s=new ColorMode([o.ONE,o.ONE,o.ONE,o.ONE],Wt.transparent,[!0,!0,!0,!0]);!function(e,t,i,r){const n=e.gl,o=t.width*r,a=t.height*r;e.activeTexture.set(n.TEXTURE1),e.viewport.set([0,0,o,a]);let s=i.heatmapFbo;if(!s||s&&(s.width!==o||s.height!==a)){s&&s.destroy();const t=n.createTexture();n.bindTexture(n.TEXTURE_2D,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,n.LINEAR),s=i.heatmapFbo=e.createFramebuffer(o,a,!0,null),function(e,t,i,r,n,o){const a=e.gl;a.texImage2D(a.TEXTURE_2D,0,e.extRenderToTextureHalfFloat?a.RGBA16F:a.RGBA,n,o,0,a.RGBA,e.extRenderToTextureHalfFloat?a.HALF_FLOAT:a.UNSIGNED_BYTE,null),r.colorAttachment.set(i)}(e,0,t,s,o,a)}else n.bindTexture(n.TEXTURE_2D,s.colorAttachment.get()),e.bindFramebuffer.set(s.framebuffer)}(n,e,i,"globe"===e.transform.projection.name?.5:.25),n.clear({color:Wt.transparent});const l=e.transform,c="globe"===l.projection.name,u=c?["PROJECTION_GLOBE_VIEW"]:[],h=c?CullFaceMode.frontCCW:CullFaceMode.disabled,d=[_u(l.center.lng),gu(l.center.lat)];for(let p=0;p<r.length;p++){const f=r[p];if(t.hasRenderableParent(f))continue;const m=t.getTile(f),_=m.getBucket(i);if(!_||_.projection.name!==l.projection.name)continue;const g=e.isTileAffectedByFog(f),y=_.programConfigurations.get(i.id),x=e.getOrCreateProgram("heatmap",{config:y,defines:u,overrideFog:g}),{zoom:v}=e.transform;e.terrain&&e.terrain.setupElevationDraw(m,x),e.uploadCommonUniforms(n,x,f.toUnwrapped());const b=l.projection.createInversionMatrix(l,f.canonical);x.draw(e,o.TRIANGLES,DepthMode.disabled,a,s,h,lx(e,f,m,b,d,v,i.paint.get("heatmap-intensity")),i.id,_.layoutVertexBuffer,_.indexBuffer,_.segments,i.paint,e.transform.zoom,y,c?[_.globeExtVertexBuffer]:null)}n.viewport.set([0,0,e.width,e.height])}else"translucent"===e.renderPass&&(e.context.setColorMode(e.colorModeForRenderPass()),function(e,t){const i=e.context,r=i.gl,n=t.heatmapFbo;if(!n)return;i.activeTexture.set(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,n.colorAttachment.get()),i.activeTexture.set(r.TEXTURE1);let o=t.colorRampTexture;o||(o=t.colorRampTexture=new Texture(i,t.colorRamp,r.RGBA)),o.bind(r.LINEAR,r.CLAMP_TO_EDGE),e.getOrCreateProgram("heatmapTexture").draw(e,r.TRIANGLES,DepthMode.disabled,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.disabled,((e,t,i,r)=>({u_image:0,u_color_ramp:1,u_opacity:t.paint.get("heatmap-opacity")}))(0,t),t.id,e.viewportBuffer,e.quadTriangleIndexBuffer,e.viewportSegments,t.paint,e.transform.zoom)}(e,i))},line:function(e,t,i,r){if("translucent"!==e.renderPass)return;const n=i.paint.get("line-opacity"),o=i.paint.get("line-width");if(0===n.constantOr(1)||0===o.constantOr(1))return;const a=i.paint.get("line-emissive-strength"),s=e.depthModeForSublayer(0,DepthMode.ReadOnly),l=e.colorModeForDrapableLayerRenderPass(a),c=e.terrain&&e.terrain.renderingToTexture?1:rt.devicePixelRatio,u=i.paint.get("line-dasharray"),h=u.constantOr(1),d=i.layout.get("line-cap"),p=i.paint.get("line-pattern"),f=p.constantOr(1),m=i.paint.get("line-pattern").constantOr(1),_=1!==i.paint.get("line-opacity").constantOr(1);let g=!m&&_;const y=i.paint.get("line-gradient"),x=f?"linePattern":"line",v=e.context,b=v.gl,w=x_(i);e.terrain&&e.terrain.clipOrMaskOverlapStencilType()&&(g=!1);for(const n of r){const r=t.getTile(n);if(f&&!r.patternsLoaded())continue;const o=r.getBucket(i);if(!o)continue;e.prepareDrawTile();const a=o.programConfigurations.get(i.id),m=e.isTileAffectedByFog(n),_=e.getOrCreateProgram(x,{config:a,defines:w,overrideFog:m}),T=p.constantOr(null);if(T&&r.imageAtlas){const e=r.imageAtlas.patternPositions[T.toString()];e&&a.setConstantPatternPositions(e)}const E=u.constantOr(null),M=d.constantOr(null);if(!f&&E&&M&&r.lineAtlas){const e=r.lineAtlas.getDash(E,M);e&&a.setConstantPatternPositions(e)}let[S,A]=i.paint.get("line-trim-offset");if("round"===M||"square"===M){const e=1;S!==A&&(0===S&&(S-=e),1===A&&(A+=e))}const C=e.terrain?n.projMatrix:null,D=f?__(e,r,i,C,c):m_(e,r,i,C,o.lineClipsArray.length,c,[S,A]);if(y){const r=o.gradients[i.id];let a=r.texture;if(i.gradientVersion!==r.version){let s=256;if(i.stepInterpolant){const i=t.getSource().maxzoom,r=n.canonical.z===i?Math.ceil(1<<e.transform.maxZoom-n.canonical.z):1;s=I(F(o.maxLineLength/Ri*1024*r),256,v.maxTextureSize)}r.gradient=gh({expression:i.gradientExpression(),evaluationKey:"lineProgress",resolution:s,image:r.gradient||void 0,clips:o.lineClipsArray}),r.texture?r.texture.update(r.gradient):r.texture=new Texture(v,r.gradient,b.RGBA),r.version=i.gradientVersion,a=r.texture}v.activeTexture.set(b.TEXTURE1),a.bind(i.stepInterpolant?b.NEAREST:b.LINEAR,b.CLAMP_TO_EDGE)}h&&(v.activeTexture.set(b.TEXTURE0),r.lineAtlasTexture.bind(b.LINEAR,b.REPEAT),a.updatePaintBuffers()),f&&(v.activeTexture.set(b.TEXTURE0),r.imageAtlasTexture.bind(b.LINEAR,b.CLAMP_TO_EDGE),a.updatePaintBuffers()),e.uploadCommonUniforms(v,_,n.toUnwrapped());const P=t=>{_.draw(e,b.TRIANGLES,s,t,l,CullFaceMode.disabled,D,i.id,o.layoutVertexBuffer,o.indexBuffer,o.segments,i.paint,e.transform.zoom,a,[o.layoutVertexBuffer2])};if(g){const t=e.stencilModeForClipping(n).ref;0===t&&e.terrain&&v.clear({stencil:0});const i={func:b.EQUAL,mask:255};D.u_alpha_discard_threshold=.8,P(new StencilMode(i,t,255,b.KEEP,b.KEEP,b.INVERT)),D.u_alpha_discard_threshold=0,P(new StencilMode(i,t,255,b.KEEP,b.KEEP,b.KEEP))}else P(e.stencilModeForClipping(n))}g&&(e.resetStencilClippingMasks(),e.terrain&&v.clear({stencil:0}))},fill:function(e,t,i,r){const n=i.paint.get("fill-color"),o=i.paint.get("fill-opacity");if(0===o.constantOr(1))return;const a=i.paint.get("fill-emissive-strength"),s=e.colorModeForDrapableLayerRenderPass(a),l=i.paint.get("fill-pattern"),c=e.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===n.constantOr(Wt.transparent).a&&1===o.constantOr(0)?"opaque":"translucent";if(e.renderPass===c){const n=e.depthModeForSublayer(1,"opaque"===e.renderPass?DepthMode.ReadWrite:DepthMode.ReadOnly);Px(e,t,i,r,n,s,!1)}if("translucent"===e.renderPass&&i.paint.get("fill-antialias")){const n=e.depthModeForSublayer(i.getPaintProperty("fill-outline-color")?2:0,DepthMode.ReadOnly);Px(e,t,i,r,n,s,!0)}},"fill-extrusion":function(e,t,i,r){const n=i.paint.get("fill-extrusion-opacity"),o=e.context,a=o.gl,s=e.terrain,l=s&&s.renderingToTexture,c=i.paint.get("fill-extrusion-cutoff-fade-range");if(0===n)return;const u=e.conflationActive&&e.layerUsedInConflation(i,t.getSource());if(u&&function(e,t,i,r){for(const n of r){const r=t.getTile(n).getBucket(i);r&&(r.updateReplacement(n,e.replacementSource),r.uploadCentroid(e.context))}}(e,t,i,r),s||u)for(const n of r){const r=t.getTile(n).getBucket(i);r&&Rx(e.context,t,n,r,i,s,u)}if("shadow"===e.renderPass&&e.shadowRenderer){const o=e.shadowRenderer;if(s&&n<.65&&i._transitionablePaint._values["fill-extrusion-opacity"].value.expression instanceof ZoomDependentExpression)return;const a=o.getShadowPassDepthMode(),l=o.getShadowPassColorMode();Lx(e,t,i,r,a,StencilMode.disabled,l,u)}else if("translucent"===e.renderPass){const h=!i.paint.get("fill-extrusion-pattern").constantOr(1);if(!l){const o=new DepthMode(e.context.gl.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D);0===c&&1===n&&h?Lx(e,t,i,r,o,StencilMode.disabled,ColorMode.unblended,u):(Lx(e,t,i,r,o,StencilMode.disabled,ColorMode.disabled,u),Lx(e,t,i,r,o,e.stencilModeFor3D(),e.colorModeForRenderPass(),u),e.resetStencilClippingMasks())}if(e.style.enable3dLights()&&h&&(!s&&"globe"!==e.transform.projection.name||l)){const n=i.paint.get("fill-extrusion-opacity"),c=i.paint.get("fill-extrusion-ambient-occlusion-intensity"),h=i.paint.get("fill-extrusion-ambient-occlusion-ground-radius"),d=i.paint.get("fill-extrusion-flood-light-intensity"),p=i.paint.get("fill-extrusion-flood-light-color").toArray01().slice(0,3),f=c>0&&h>0,m=d>0,_=(e,t,i)=>(1-i)*e+i*t,g=o=>{const s=e.depthModeForSublayer(1,DepthMode.ReadOnly,a.LEQUAL,!0),l=i.paint.get(o?"fill-extrusion-ambient-occlusion-ground-attenuation":"fill-extrusion-flood-light-ground-attenuation"),f=_(.1,3,l),m=e._showOverdrawInspector;if(!m){const l=new StencilMode({func:a.ALWAYS,mask:255},255,255,a.KEEP,a.KEEP,a.REPLACE),m=new ColorMode([a.ONE,a.ONE,a.ONE,a.ONE],Wt.transparent,[!1,!1,!1,!0],a.MIN);zx(e,t,i,r,s,l,m,CullFaceMode.disabled,o,"sdf",n,c,h,d,p,f,u,!1)}{const l=m?StencilMode.disabled:new StencilMode({func:a.EQUAL,mask:255},255,255,a.KEEP,a.DECR,a.DECR),_=m?e.colorModeForRenderPass():new ColorMode([a.ONE_MINUS_DST_ALPHA,a.DST_ALPHA,a.ONE,a.ONE],Wt.transparent,[!0,!0,!0,!0]);zx(e,t,i,r,s,l,_,CullFaceMode.disabled,o,"color",n,c,h,d,p,f,u,!1)}};if(l){const l=(o,s,l)=>{const f=e.depthModeForSublayer(1,DepthMode.ReadOnly,a.LEQUAL,!1),m=i.paint.get(o?"fill-extrusion-ambient-occlusion-ground-attenuation":"fill-extrusion-flood-light-ground-attenuation"),g=_(.1,3,m);{const l=new ColorMode([a.ONE,a.ONE,a.ONE,a.ONE],Wt.transparent,[!1,!1,!1,!0]);zx(e,t,i,r,f,StencilMode.disabled,l,CullFaceMode.disabled,o,"clear",n,c,h,d,p,g,u,s)}{const l=new StencilMode({func:a.ALWAYS,mask:255},255,255,a.KEEP,a.KEEP,a.REPLACE),m=new ColorMode([a.ONE,a.ONE,a.ONE,a.ONE],Wt.transparent,[!1,!1,!1,!0],a.MIN);zx(e,t,i,r,f,l,m,CullFaceMode.disabled,o,"sdf",n,c,h,d,p,g,u,s)}{const l=o?a.ZERO:a.ONE_MINUS_DST_ALPHA,m=new StencilMode({func:a.EQUAL,mask:255},255,255,a.KEEP,a.DECR,a.DECR),_=new ColorMode([l,a.DST_ALPHA,a.ONE_MINUS_DST_ALPHA,a.ZERO],Wt.transparent,[!0,!0,!0,!0]);zx(e,t,i,r,f,m,_,CullFaceMode.disabled,o,"color",n,c,h,d,p,g,u,s)}{const m=new ColorMode([a.ONE,a.ONE,a.ONE,o?a.ZERO:a.ONE],Wt.transparent,[!1,!1,!1,!0],o?a.FUNC_ADD:a.MAX);zx(e,t,i,r,f,StencilMode.disabled,m,CullFaceMode.disabled,o,"clear",n,c,h,d,p,g,u,s,l)}};if(f||m){let t;if(e.prepareDrawTile(),s){const e=s.drapeBufferSize[0],i=s.drapeBufferSize[1];t=s.framebufferCopyTexture,t&&(!t||t.size[0]===e&&t.size[1]===i)||(t&&t.destroy(),t=s.framebufferCopyTexture=new Texture(o,new RGBAImage({width:e,height:i}),a.RGBA)),t.bind(a.LINEAR,a.CLAMP_TO_EDGE),a.copyTexImage2D(a.TEXTURE_2D,0,a.RGBA,0,0,e,i,0)}f&&l(!0,!1,t),m&&l(!1,!0,t)}}else f&&g(!0),m&&g(!1)}}},hillshade:function(e,t,i,r){if("offscreen"!==e.renderPass&&"translucent"!==e.renderPass)return;const n=e.context,o=e.terrain&&e.terrain.renderingToTexture,[a,s]="translucent"!==e.renderPass||o?[{},r]:e.stencilConfigForOverlap(r);for(const r of s){const n=t.getTile(r);if(n.needsHillshadePrepare&&"offscreen"===e.renderPass)ky(e,n,i);else if("translucent"===e.renderPass){const t=e.depthModeForSublayer(0,DepthMode.ReadOnly),s=i.paint.get("hillshade-emissive-strength"),l=e.colorModeForDrapableLayerRenderPass(s),c=o&&e.terrain?e.terrain.stencilModeForRTTOverlap(r):a[r.overscaledZ];zy(e,r,n,i,t,c,l)}}n.viewport.set([0,0,e.width,e.height]),e.resetStencilClippingMasks()},raster:function(e,t,i,r,n,o){if("translucent"!==e.renderPass)return;if(0===i.paint.get("raster-opacity"))return;const a=e.context,s=a.gl,l=t.getSource(),c=function(e,t,i){const r=[];let n,o;if(e.paint.get("raster-color")){r.push("RASTER_COLOR"),n=e.paint.get("raster-color-mix"),o=e.paint.get("raster-color-range"),t.activeTexture.set(i.TEXTURE2);let a=e.colorRampTexture;a||(a=e.colorRampTexture=new Texture(t,e.colorRamp,i.RGBA)),a.bind(i.LINEAR,i.CLAMP_TO_EDGE)}return{mix:n,range:o,defines:r}}(i,a,s),u=c.defines;let h=!1;if(l instanceof ImageSource&&!r.length){if("globe"!==e.transform.projection.name)return;if(l.onNorthPole)h=!0,u.push("PROJECTION_GLOBE_VIEW");else{if(!l.onSouthPole)return;h=!0,u.push("PROJECTION_GLOBE_VIEW")}}const d=e.colorModeForDrapableLayerRenderPass(),p=e.terrain&&e.terrain.renderingToTexture,f=!e.options.moving,m="nearest"===i.paint.get("raster-resampling")?s.NEAREST:s.LINEAR;if(h){const r=t.getSource();if(!(r instanceof ImageSource))return;const n=r.texture;if(!n)return;const o=e.globeSharedBuffers;if(!o)return;const l=new DepthMode(s.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D),u=Float32Array.from(e.transform.projMatrix);let h=eu(0,0,e.transform);const p=Float32Array.from(Wc(Bc(new CanonicalTileID(0,0,0)))),f={opacity:1,mix:0};e.terrain&&e.terrain.prepareDrawTile(),a.activeTexture.set(s.TEXTURE0),n.bind(m,s.CLAMP_TO_EDGE),a.activeTexture.set(s.TEXTURE1),n.bind(m,s.CLAMP_TO_EDGE),n.useMipmap&&a.extTextureFilterAnisotropic&&e.transform.pitch>20&&s.texParameterf(s.TEXTURE_2D,a.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,a.extTextureFilterAnisotropicMax);const[_,g,y,x]=o.getPoleBuffers(0,!0);let v;r.onNorthPole?(v=_,e.renderDefaultNorthPole=!1):(h=ic.scale(ic.create(),h,[1,-1,1]),v=g,e.renderDefaultSouthPole=!1);const b=cx(u,p,h,[0,0],1,f,i,r.perspectiveTransform||[0,0],2,c.mix||[0,0,0,0],c.range||[0,0]),w=e.getOrCreateProgram("raster",{defines:c.defines});return e.uploadCommonUniforms(a,w,null),void w.draw(e,s.TRIANGLES,l,StencilMode.disabled,d,CullFaceMode.disabled,b,i.id,v,y,x)}if(!r.length)return;const[_,g]=l instanceof ImageSource||p?[{},r]:e.stencilConfigForOverlap(r),y=g[g.length-1].overscaledZ;for(const r of g){const n=p?DepthMode.disabled:e.depthModeForSublayer(r.overscaledZ-y,1===i.paint.get("raster-opacity")?DepthMode.ReadWrite:DepthMode.ReadOnly,s.LESS),u=r.toUnwrapped(),h=t.getTile(r);if(p&&(!h||!h.hasData()))continue;if(!h.texture)continue;const g=p?r.projMatrix:e.transform.calculateProjMatrix(u,f),x=e.terrain&&p?e.terrain.stencilModeForRTTOverlap(r):_[r.overscaledZ],v=o?0:i.paint.get("raster-fade-duration");h.registerFadeDuration(v);const b=t.findLoadedParent(r,0),w=$y(h,b,t,e.transform,v);let T,E;e.terrain&&e.terrain.prepareDrawTile(),a.activeTexture.set(s.TEXTURE0),h.texture.bind(m,s.CLAMP_TO_EDGE),a.activeTexture.set(s.TEXTURE1),b?(b.texture.bind(m,s.CLAMP_TO_EDGE),T=Math.pow(2,b.tileID.overscaledZ-h.tileID.overscaledZ),E=[h.tileID.canonical.x*T%1,h.tileID.canonical.y*T%1]):h.texture.bind(m,s.CLAMP_TO_EDGE),h.texture.useMipmap&&a.extTextureFilterAnisotropic&&e.transform.pitch>20&&s.texParameterf(s.TEXTURE_2D,a.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,a.extTextureFilterAnisotropicMax);const M=l instanceof ImageSource?l.perspectiveTransform:[0,0],S=new Float32Array(16),A=cx(g,S,S,E||[0,0],T||1,w,i,M,2,c.mix||[0,0,0,0],c.range||[0,0]),C=e.isTileAffectedByFog(r),I=e.getOrCreateProgram("raster",{defines:c.defines,overrideFog:C});if(e.uploadCommonUniforms(a,I,u),l instanceof ImageSource)l.boundsBuffer&&l.boundsSegments&&I.draw(e,s.TRIANGLES,n,StencilMode.disabled,d,CullFaceMode.disabled,A,i.id,l.boundsBuffer,e.quadTriangleIndexBuffer,l.boundsSegments);else{const{tileBoundsBuffer:t,tileBoundsIndexBuffer:r,tileBoundsSegments:o}=e.getTileBoundsBuffers(h);I.draw(e,s.TRIANGLES,n,x,d,CullFaceMode.disabled,A,i.id,t,r,o)}}e.resetStencilClippingMasks()},background:function(e,t,i,r){const n=i.paint.get("background-color"),o=i.paint.get("background-opacity"),a=i.paint.get("background-emissive-strength");if(0===o)return;const s=e.context,l=s.gl,c=e.transform,u=c.tileSize,h=i.paint.get("background-pattern");if(e.isPatternMissing(h,i.scope))return;const d=!h&&1===n.a&&1===o&&e.opaquePassEnabledForLayer()?"opaque":"translucent";if(e.renderPass!==d)return;const p=StencilMode.disabled,f=e.depthModeForSublayer(0,"opaque"===d?DepthMode.ReadWrite:DepthMode.ReadOnly),m=e.colorModeForDrapableLayerRenderPass(a),_=h?"backgroundPattern":"background";let g,y=r;y||(g=e.getBackgroundTiles(),y=Object.values(g).map((e=>e.tileID))),h&&(s.activeTexture.set(l.TEXTURE0),e.imageManager.bind(e.context,i.scope));for(const d of y){const y=e.isTileAffectedByFog(d),x=e.getOrCreateProgram(_,{overrideFog:y}),v=d.toUnwrapped(),b=r?d.projMatrix:e.transform.calculateProjMatrix(v);e.prepareDrawTile();const w=t?t.getTile(d):g?g[d.key]:new Tile(d,u,c.zoom,e),T=h?gx(b,a,o,e,h,i.scope,{tileID:d,tileSize:u}):_x(b,a,o,n);e.uploadCommonUniforms(s,x,v);const{tileBoundsBuffer:E,tileBoundsIndexBuffer:M,tileBoundsSegments:S}=e.getTileBoundsBuffers(w);x.draw(e,l.TRIANGLES,f,p,m,CullFaceMode.disabled,T,i.id,E,M,S)}},sky:function(e,t,i){const r=e._atmosphere?Qc(e.transform.zoom):1,n=i.paint.get("sky-opacity")*r;if(0===n)return;const o=e.context,a=i.paint.get("sky-type"),s=new DepthMode(o.gl.LEQUAL,DepthMode.ReadOnly,[0,1]),l=e.frameCounter/1e3%1;"atmosphere"===a?"offscreen"===e.renderPass?i.needsSkyboxCapture(e)&&(function(e,t,i,r){const n=e.context,o=n.gl;let a=t.skyboxFbo;if(!a){a=t.skyboxFbo=n.createFramebuffer(32,32,!0,null),t.skyboxGeometry=new SkyboxGeometry(n),t.skyboxTexture=n.gl.createTexture(),o.bindTexture(o.TEXTURE_CUBE_MAP,t.skyboxTexture),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_CUBE_MAP,o.TEXTURE_MAG_FILTER,o.LINEAR);for(let e=0;e<6;++e)o.texImage2D(o.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,o.RGBA,32,32,0,o.RGBA,o.UNSIGNED_BYTE,null)}n.bindFramebuffer.set(a.framebuffer),n.viewport.set([0,0,32,32]);const s=t.getCenter(e,!0),l=e.getOrCreateProgram("skyboxCapture"),c=new Float64Array(16);ic.identity(c),ic.rotateY(c,c,.5*-Math.PI),Kx(e,t,l,c,s,0),ic.identity(c),ic.rotateY(c,c,.5*Math.PI),Kx(e,t,l,c,s,1),ic.identity(c),ic.rotateX(c,c,.5*-Math.PI),Kx(e,t,l,c,s,2),ic.identity(c),ic.rotateX(c,c,.5*Math.PI),Kx(e,t,l,c,s,3),ic.identity(c),Kx(e,t,l,c,s,4),ic.identity(c),ic.rotateY(c,c,Math.PI),Kx(e,t,l,c,s,5),n.viewport.set([0,0,e.width,e.height])}(e,i),i.markSkyboxValid(e)):"sky"===e.renderPass&&function(e,t,i,r,n){const o=e.context,a=o.gl,s=e.transform,l=e.getOrCreateProgram("skybox");o.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_CUBE_MAP,t.skyboxTexture);const c=((e,t,i,r,n)=>({u_matrix:e,u_sun_direction:t,u_cubemap:0,u_opacity:r,u_temporal_offset:n}))(s.skyboxMatrix,t.getCenter(e,!1),0,r,n);e.uploadCommonUniforms(o,l),l.draw(e,a.TRIANGLES,i,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.backCW,c,"skybox",t.skyboxGeometry.vertexBuffer,t.skyboxGeometry.indexBuffer,t.skyboxGeometry.segment)}(e,i,s,n,l):"gradient"===a&&"sky"===e.renderPass&&function(e,t,i,r,n){const o=e.context,a=o.gl,s=e.transform,l=e.getOrCreateProgram("skyboxGradient");t.skyboxGeometry||(t.skyboxGeometry=new SkyboxGeometry(o)),o.activeTexture.set(a.TEXTURE0);let c=t.colorRampTexture;c||(c=t.colorRampTexture=new Texture(o,t.colorRamp,a.RGBA)),c.bind(a.LINEAR,a.CLAMP_TO_EDGE);const u=((e,t,i,r,n)=>({u_matrix:e,u_color_ramp:0,u_center_direction:t,u_radius:b(i),u_opacity:r,u_temporal_offset:n}))(s.skyboxMatrix,t.getCenter(e,!1),t.paint.get("sky-gradient-radius"),r,n);e.uploadCommonUniforms(o,l),l.draw(e,a.TRIANGLES,i,StencilMode.disabled,e.colorModeForRenderPass(),CullFaceMode.backCW,u,"skyboxGradient",t.skyboxGeometry.vertexBuffer,t.skyboxGeometry.indexBuffer,t.skyboxGeometry.segment)}(e,i,s,n,l)},debug:function(e,t,i){for(let r=0;r<i.length;r++)qx(e,t,i[r])},custom:function(e,t,i,r){const n=e.context,o=i.implementation;if(!e.transform.projection.unsupportedLayers||!e.transform.projection.unsupportedLayers.includes("custom")||e.terrain&&(e.terrain.renderingToTexture||"offscreen"===e.renderPass)&&i.isLayerDraped(t)){if("offscreen"===e.renderPass){const t=o.prerender;if(t){if(e.setCustomLayerDefaults(),n.setColorMode(e.colorModeForRenderPass()),"globe"===e.transform.projection.name){const i=e.transform.pointMerc;t.call(o,n.gl,e.transform.customLayerMatrix(),e.transform.getProjection(),e.transform.globeToMercatorMatrix(),Qc(e.transform.zoom),[i.x,i.y],e.transform.pixelsPerMeterRatio)}else t.call(o,n.gl,e.transform.customLayerMatrix());n.setDirty(),e.setBaseState()}}else if("translucent"===e.renderPass){if(e.terrain&&e.terrain.renderingToTexture){const t=o.renderToTile;if(t){const i=r[0].canonical,a=new MercatorCoordinate(i.x+r[0].wrap*(1<<i.z),i.y,i.z);n.setDepthMode(DepthMode.disabled),n.setStencilMode(StencilMode.disabled),n.setColorMode(e.colorModeForRenderPass()),e.setCustomLayerDefaults(),t.call(o,n.gl,a),n.setDirty(),e.setBaseState()}return}e.setCustomLayerDefaults(),n.setColorMode(e.colorModeForRenderPass()),n.setStencilMode(StencilMode.disabled);const t="3d"===o.renderingMode?new DepthMode(e.context.gl.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D):e.depthModeForSublayer(0,DepthMode.ReadOnly);if(n.setDepthMode(t),"globe"===e.transform.projection.name){const t=e.transform.pointMerc;o.render(n.gl,e.transform.customLayerMatrix(),e.transform.getProjection(),e.transform.globeToMercatorMatrix(),Qc(e.transform.zoom),[t.x,t.y],e.transform.pixelsPerMeterRatio)}else o.render(n.gl,e.transform.customLayerMatrix());n.setDirty(),e.setBaseState(),n.bindFramebuffer.set(null)}}else $("Custom layers are not yet supported with this projection. Use mercator or globe to enable usage of custom layers.")},model:function(e,t,i,r){if("opaque"===e.renderPass)return;const n=i.paint.get("model-opacity");if(0===n)return;const o=i.paint.get("model-cast-shadows");if("shadow"===e.renderPass){if(!o)return;if(e.terrain&&n<.65&&i._transitionablePaint._values["model-opacity"].value.expression instanceof ZoomDependentExpression)return}const a=e.shadowRenderer,s=i.paint.get("model-receive-shadows");a&&(a.useNormalOffset=!0,s||(a.enabled=!1));const l=()=>{a&&(a.useNormalOffset=!0,s||(a.enabled=!0))},c=t.getSource();if("light-beam"===e.renderPass&&"batched-model"!==c.type)return;if("vector"===c.type||"geojson"===c.type)return function(e,t,i,r){const n=e.transform;if("mercator"!==n.projection.name)return void $(`Drawing 3D models for ${n.projection.name} projection is not yet implemented`);const o=n.getFreeCameraOptions().position;if(!e.modelManager)return;const a=e.modelManager,s=e.shadowRenderer;if(!i._unevaluatedLayout._values.hasOwnProperty("model-id"))return;const l=i._unevaluatedLayout._values["model-id"],c={...i.layout.get("model-id").parameters};for(const u of r){const r=t.getTile(u).getBucket(i);if(!r||r.projection.name!==n.projection.name)continue;const h=sv(u,n);c.zoom=h;const d=l.possiblyEvaluate(c);if(ov(e,r,u),av.shadowUniformsInitialized=!1,av.useSingleShadowCascade=!!s&&0===s.getMaxCascadeForTile(u.toUnwrapped()),"shadow"===e.renderPass&&s){if(1===e.currentShadowCascade&&r.isInsideFirstShadowMapFrustum)continue;const t=n.calculatePosMatrix(u.toUnwrapped(),n.worldSize);if(av.tileMatrix.set(t),av.shadowTileMatrix=Float32Array.from(s.calculateShadowPassMatrixFromMatrix(t)),av.aabb.min.fill(0),av.aabb.max[0]=av.aabb.max[1]=Ri,av.aabb.max[2]=0,uv(r,av,e,i.scope))continue}const p=1<<u.canonical.z,f=[((o.x-u.wrap)*p-u.canonical.x)*Ri,(o.y*p-u.canonical.y)*Ri,o.z*p*Ri];for(let t in r.instancesPerModel){const n=r.instancesPerModel[t];n.features.length>0&&(t=d.evaluate(n.features[0].feature,{}));const o=a.getModel(t,i.scope);if(o&&o.uploaded)for(const t of o.nodes)lv(e,i,t,n,f,u,av)}}}(e,t,i,r),void l();if(!c.loaded())return;if("batched-model"===c.type)return function(e,t,i,r){const n=e.context,o=e.transform,a=e.style.fog,s=e.shadowRenderer;if("mercator"!==o.projection.name)return void $(`Drawing 3D landmark models for ${o.projection.name} projection is not yet implemented`);const l=e.transform.getFreeCameraOptions().position,c=lc.scale([],[l.x,l.y,l.z],e.transform.worldSize);lc.negate(c,c);const u=ic.identity([]),h=Eu(o.center.lat,o.zoom),d=ic.fromScaling([],[1,1,1/h]);ic.translate(u,u,c);const p=i.paint.get("model-opacity"),f=new DepthMode(n.gl.LEQUAL,DepthMode.ReadWrite,e.depthRangeFor3D),m=new DepthMode(n.gl.LEQUAL,DepthMode.ReadOnly,e.depthRangeFor3D),_=function(l,c){for(const h of r){const r=t.getTile(h).getBucket(i);if(!r||!r.uploaded)continue;let _=!1;s&&(_=0===s.getMaxCascadeForTile(h.toUnwrapped()));const g=o.calculatePosMatrix(h.toUnwrapped(),o.worldSize),y=r.modelTraits;for(const t of r.getNodesInfo()){if(t.hiddenByReplacement)continue;if(!t.node.meshes)continue;const r=t.node,x="light-beam"===e.renderPass,v=[...g],b=t.evaluatedScale;let w=0;e.terrain&&r.elevation&&(w=r.elevation*e.terrain.exaggeration()),ic.translate(v,v,[(r.anchor?r.anchor[0]:0)*(b[0]-1),(r.anchor?r.anchor[1]:0)*(b[1]-1),w]),b!==gm&&ic.scale(v,v,b),ic.multiply(v,v,r.matrix);const T=ic.multiply([],d,v);ic.multiply(T,u,T);const E=ic.invert([],T);ic.transpose(E,E),ic.scale(E,E,cv);const M=ic.multiply([],o.projMatrix,v);for(let u=0;u<r.meshes.length;++u){const d=r.meshes[u],g=u===r.lightMeshIndex;if(g){if(!x&&!e.terrain&&e.shadowRenderer){e.currentLayer<e.firstLightBeamLayer&&(e.firstLightBeamLayer=e.currentLayer);continue}}else if(x)continue;const b={defines:[]},w=[];tv(b.defines,w,d,e),4&y||b.defines.push("DIFFUSE_SHADED"),_&&b.defines.push("SHADOWS_SINGLE_CASCADE");const S="shadow"===e.renderPass;if(S){nv(d,v,e,i);continue}let A=null;if(a){const t=ev(v,e.transform);if(A=new Float32Array(t),"globe"!==o.projection.name){const e=d.aabb.min,i=d.aabb.max,[r,n]=a.getOpacityForBounds(t,e[0],e[1],i[0],i[1]);b.overrideFog=r>=V_||n>=V_}}const C=e.getOrCreateProgram("model",b);!S&&s&&(s.useNormalOffset=!!d.normalBuffer,s.setupShadowsFromMatrix(v,C,s.useNormalOffset)),e.uploadCommonUniforms(n,C,h.toUnwrapped(),A);const I=d.material,D=I.pbrMetallicRoughness;D.metallicFactor=.9,D.roughnessFactor=.5;const P=xx(new Float32Array(M),new Float32Array(T),new Float32Array(E),e,p,D.baseColorFactor,I.emissiveFactor,D.metallicFactor,D.roughnessFactor,I,i);C.draw(e,n.gl.TRIANGLES,c&&!g?f:m,