/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface LessThanOptions extends ValidateOptions {
    // Default is true
    inclusive: boolean;
    max?: number;
}
export interface LessThanLocalization extends Localization {
    lessThan: {
        default: string;
        notInclusive: string;
    };
}

export function lessThan(): ValidateFunctionInterface<LessThanOptions, ValidateResult>;
