/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { Plugin } from '@form-validation/core';

type ContainerCallback = (field: string, element: HTMLElement) => HTMLElement;

export interface MessageOptions {
    clazz?: string;
    container?: string | ContainerCallback;
}
export interface MessageDisplayedEvent {
    element: HTMLElement;
    field: string;
    message: string;
    messageElement: HTMLElement;
    meta: unknown;
    validator: string;
}
export interface MessagePlacedEvent {
    element: HTMLElement;
    elements: HTMLElement[];
    field: string;
    messageElement: HTMLElement;
}

export class Message extends Plugin<MessageOptions> {
    static getClosestContainer(element: HTMLElement, upper: HTMLElement, pattern: RegExp): HTMLElement;
    constructor(opts?: MessageOptions);
}
