<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FeeChallansSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Demo entries for app_fee table
        DB::table('app_fee')->insert([
            'challan_no' => 'CH-000001',
            'app_school_id' => 1,
            'app_class_id' => 1,
            'app_section_id' => 1,
            'app_student_id' => 1,
            'app_staff_id' => 1,
            'feemonth' => 'January',
            'amount' => 5000,
            'feeamount' => 5000,
            'transid' => 'TXN-001',
            'status' => 'issued',
            'feestatus' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('app_fee')->insert([
            'challan_no' => 'CH-000002',
            'app_school_id' => 1,
            'app_class_id' => 1,
            'app_section_id' => 1,
            'app_student_id' => 2,
            'app_staff_id' => 1,
            'feemonth' => 'January',
            'amount' => 5000,
            'feeamount' => 5000,
            'transid' => 'TXN-002',
            'status' => 'pending',
            'feestatus' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('app_fee')->insert([
            'challan_no' => 'CH-000003',
            'app_school_id' => 1,
            'app_class_id' => 2,
            'app_section_id' => 2,
            'app_student_id' => 3,
            'app_staff_id' => 1,
            'feemonth' => 'January',
            'amount' => 4500,
            'feeamount' => 4500,
            'transid' => 'TXN-003',
            'status' => 'paid',
            'feestatus' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);

        DB::table('app_fee')->insert([
            'challan_no' => 'CH-000004',
            'app_school_id' => 1,
            'app_class_id' => 2,
            'app_section_id' => 2,
            'app_student_id' => 4,
            'app_staff_id' => 1,
            'feemonth' => 'February',
            'amount' => 4500,
            'feeamount' => 4500,
            'transid' => null,
            'status' => 'issued',
            'feestatus' => 'Active',
            'created_at' => now(),
            'updated_at' => now(),
        ]);
    }
}
