<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_fee_history', function (Blueprint $table) {
            // Drop old foreign key
            $table->dropForeign(['changed_by']);

            // Add new foreign key to app_staff
            $table->foreign('changed_by')->references('id')->on('app_staff')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_fee_history', function (Blueprint $table) {
            // Drop new foreign key
            $table->dropForeign(['changed_by']);

            // Restore old foreign key to users
            $table->foreign('changed_by')->references('id')->on('users')->onDelete('cascade');
        });
    }
};
