<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_fee_history', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('app_fee_id');
            $table->tinyInteger('old_status')->nullable();
            $table->tinyInteger('new_status');
            $table->integer('changed_by');
            $table->text('notes')->nullable();
            $table->timestamps();

            $table->foreign('app_fee_id')->references('id')->on('app_fee')->onDelete('cascade');
            $table->foreign('changed_by')->references('id')->on('app_staff')->onDelete('cascade');

            $table->index(['app_fee_id', 'created_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_fee_history');
    }
};
