<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // First, convert existing string values to integers
        DB::statement("UPDATE app_fee SET status = CASE 
            WHEN status = 'issued' THEN 0
            WHEN status = 'pending' THEN 1
            WHEN status = 'cancelled' THEN 3
            WHEN status = 'paid' THEN 4
            ELSE 0
        END");

        // Then change the column type to integer
        Schema::table('app_fee', function (Blueprint $table) {
            $table->tinyInteger('status')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // First change back to string
        Schema::table('app_fee', function (Blueprint $table) {
            $table->string('status', 50)->default('issued')->change();
        });

        // Then convert integers back to strings
        DB::statement("UPDATE app_fee SET status = CASE 
            WHEN status = 0 THEN 'issued'
            WHEN status = 1 THEN 'pending'
            WHEN status = 2 THEN 'waiting'
            WHEN status = 3 THEN 'cancelled'
            WHEN status = 4 THEN 'paid'
            ELSE 'issued'
        END");
    }
};
