<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_fee_extra', function (Blueprint $table) {
            if (!Schema::hasColumn('app_fee_extra', 'app_section_id')) {
                $table->foreignId('app_section_id')->nullable()->constrained('app_section')->onDelete('cascade');
            }
            if (!Schema::hasColumn('app_fee_extra', 'app_staff_id')) {
                $table->foreignId('app_staff_id')->nullable()->constrained('app_staff')->onDelete('cascade');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_fee_extra', function (Blueprint $table) {
            //
        });
    }
};
