<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_fee_extra', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('app_school_id')->nullable();
            $table->unsignedBigInteger('app_student_id')->nullable();
            $table->unsignedBigInteger('app_class_id')->nullable();
            $table->string('description')->nullable(); // e.g., "Lab Fee", "Activity Fee"
            $table->decimal('amount', 10, 2);
            $table->string('feemonth')->nullable(); // Month for which extra fee is charged
            $table->string('status')->default('active'); // active, inactive
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_fee_extra');
    }
};
