<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('app_fee', function (Blueprint $table) {
            $table->unsignedBigInteger('app_student_id')->nullable()->after('app_class_id');
            $table->unsignedBigInteger('app_section_id')->nullable()->after('app_student_id');
            $table->unsignedBigInteger('app_staff_id')->nullable()->after('app_section_id');
            $table->string('challan_no')->unique()->nullable()->after('app_staff_id');
            $table->decimal('amount', 10, 2)->nullable()->after('challan_no');
            $table->string('transid')->nullable()->after('amount');
            $table->string('status')->default('issued')->after('transid');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('app_fee', function (Blueprint $table) {
            $table->dropColumn([
                'app_student_id',
                'app_section_id',
                'app_staff_id',
                'challan_no',
                'amount',
                'transid',
                'status'
            ]);
        });
    }
};
