<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('app_fee')) {
            Schema::create('app_fee', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('app_school_id')->nullable();
                $table->unsignedBigInteger('app_class_id')->nullable();
                $table->unsignedBigInteger('app_section_id')->nullable();
                $table->unsignedBigInteger('app_student_id')->nullable();
                $table->unsignedBigInteger('app_staff_id')->nullable();
                $table->string('challan_no')->unique()->nullable();
                $table->string('feemonth')->nullable();
                $table->decimal('amount', 10, 2)->nullable();
                $table->decimal('feeamount', 10, 2)->nullable();
                $table->string('transid')->nullable();
                $table->string('status')->default('issued');
                $table->string('feestatus')->default('Active');
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('app_fee');
    }
};
