<?php

namespace App\Providers;

use Illuminate\Support\Facades\View;
use Illuminate\Routing\Route;

use Illuminate\Support\ServiceProvider;

class MenuServiceProvider extends ServiceProvider
{
  /**
   * Register services.
   */
  public function register(): void
  {
    //
  }

  /**
   * Bootstrap services.
   */
  public function boot(): void
  {

    // Conditionally load horizontal menu based on the route
    if (request()->is('admin*')) {
      $verticalMenuJson = file_get_contents(base_path('resources/menu/myapp/adminMenu.json'));
    } else {
      $verticalMenuJson = file_get_contents(base_path('resources/menu/verticalMenu.json'));
    }
    $verticalMenuData = json_decode($verticalMenuJson);








    $horizontalMenuJson = file_get_contents(base_path('resources/menu/horizontalMenu.json'));
    $horizontalMenuData = json_decode($horizontalMenuJson);


    //myapp menu
    $adminMenuJson = file_get_contents(base_path('resources/menu/myapp/adminMenu.json'));
    $adminMenuData = json_decode($adminMenuJson);

    // Share all menuData to all the views
    $this->app->make('view')->share('menuData', [$verticalMenuData, $horizontalMenuData, $adminMenuData]);
  }
}
