<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\EncryptsIds;

class FeeChallans extends Model
{
  use HasFactory, EncryptsIds;

  protected $table = 'app_fee';

  protected $fillable = [
    'challan_no',
    'amount',
    'description',
    'feemonth',
    'transid',
    'status',
    'cancellation_reason',
    'payment_method',
    'bank_reference',
    'app_student_id',
    'app_class_id',
    'app_section_id',
    'app_staff_id',
    'app_school_id',
  ];

  protected $casts = [
    'created_at' => 'datetime',
    'updated_at' => 'datetime',
  ];

  /**
   * Relationships
   */
  public function student()
  {
    return $this->belongsTo(App_student::class, 'app_student_id');
  }

  public function class()
  {
    return $this->belongsTo(App_class::class, 'app_class_id');
  }

  public function section()
  {
    return $this->belongsTo(App_section::class, 'app_section_id');
  }

  public function staff()
  {
    return $this->belongsTo(App_staff::class, 'app_staff_id');
  }

  public function school()
  {
    return $this->belongsTo(App_school::class, 'app_school_id');
  }

  public function feeExtras()
  {
    return $this->hasMany(App_fee_extra::class, 'app_student_id', 'app_student_id')
      ->where('feemonth', $this->feemonth)
      ->where('status', 'active');
  }

  /**
   * Get status change history for this challan
   */
  public function history()
  {
    return $this->hasMany(App_fee_history::class, 'app_fee_id');
  }

  /**
   * Get the latest status change
   */
  public function latestHistory()
  {
    return $this->hasOne(App_fee_history::class, 'app_fee_id')->latestOfMany();
  }
}
