<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\EncryptsIds;

class App_student extends Model
{
  use EncryptsIds;
  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [
    'name',
    'fname',
    'mob1',
    'mob2',
    'join_date',
    'address',
    'fee',
    'fstatus',
    'image',
    'roll_no',
    'app_staff_id',
    'app_class_id',
    'app_section_id',
    'app_school_id',
  ];

  /**
   * Get the class that the student belongs to.
   */
  public function class()
  {
    return $this->belongsTo(App_class::class, 'app_class_id');
  }

  /**
   * Get the section that the student belongs to.
   */
  public function section()
  {
    return $this->belongsTo(App_section::class, 'app_section_id');
  }

  /**
   * Get the school that the student belongs to.
   */
  public function school()
  {
    return $this->belongsTo(App_school::class, 'app_school_id');
  }

  /**
   * Get the staff member who registered the student.
   */
  public function staff()
  {
    return $this->belongsTo(App_staff::class, 'app_staff_id');
  }

  /**
   * Get the fee challans for the student.
   */
  public function challans()
  {
    return $this->hasMany(FeeChallans::class, 'app_student_id');
  }
}
