<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Traits\EncryptsIds;

class App_staff extends Authenticatable
{
  use EncryptsIds;
  /**
   * The table associated with the model.
   *
   * @var string
   */
  protected $table = 'app_staff';

  /**
   * The attributes that are mass assignable.
   *
   * @var array
   */
  protected $fillable = [
    'name',
    'mob',
    'email',
    'password',
    'address',
    'image',
    'app_stype_id',
    'app_school_id',
    'status',
    'joined_at',
  ];

  /**
   * The attributes that should be hidden for arrays.
   *
   * @var array
   */
  protected $hidden = [
    'password',
    'remember_token',
  ];

  /**
   * Get the staff type
   */
  public function stype()
  {
    return $this->belongsTo(App_stype::class, 'app_stype_id');
  }

  /**
   * Get the school
   */
  public function school()
  {
    return $this->belongsTo(App_school::class, 'app_school_id');
  }
}
