<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\EncryptsIds;

class App_section extends Model
{
    use EncryptsIds;
    protected $fillable = ['name', 'app_school_id', 'app_class_id'];

    /**
     * Get the class this section belongs to.
     */
    public function class()
    {
        return $this->belongsTo(App_class::class, 'app_class_id');
    }

    /**
     * Get the students in this section.
     */
    public function students()
    {
        return $this->hasMany(App_student::class, 'app_section_id');
    }
}
