<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class App_fee_history extends Model
{
    protected $table = 'app_fee_history';

    protected $fillable = [
        'app_fee_id',
        'old_status',
        'new_status',
        'changed_by',
        'notes'
    ];

    /**
     * Get the challan that this history belongs to.
     */
    public function challan()
    {
        return $this->belongsTo(FeeChallans::class, 'app_fee_id');
    }

    /**
     * Get the staff who made the change.
     */
    public function staff()
    {
        return $this->belongsTo(App_staff::class, 'changed_by');
    }

    /**
     * Get status label.
     */
    public function getStatusLabel($status)
    {
        $labels = [
            0 => 'Issued',
            1 => 'Pending',
            2 => 'Waiting Approval',
            3 => 'Cancelled',
            4 => 'Paid'
        ];
        return $labels[$status] ?? 'Unknown';
    }
}
