<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class App_fee_extra extends Model
{
    protected $table = 'app_fee_extra';

    protected $fillable = [
        'app_school_id',
        'app_student_id',
        'app_class_id',
        'app_section_id',
        'app_staff_id',
        'description',
        'amount',
        'feemonth',
        'status',
    ];

    /**
     * Relationships
     */
    public function student()
    {
        return $this->belongsTo(App_student::class, 'app_student_id');
    }

    public function class()
    {
        return $this->belongsTo(App_class::class, 'app_class_id');
    }

    public function school()
    {
        return $this->belongsTo(App_school::class, 'app_school_id');
    }
}
