<?php

namespace App\Http\Controllers\myapp;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules\Password;
// use App\Models\User;
use App\Models\App_staff;





class Authentications extends Controller
{


  //All Get operation

  public function index()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.login', ['pageConfigs' => $pageConfigs]);
  }

  public function showLoginForm()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.login', ['pageConfigs' => $pageConfigs]);
  }




  public function signup()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.signup', ['pageConfigs' => $pageConfigs]);
  }

  public function showRegistrationForm()
  {
    return view('auth.signup'); // Your existing register view
  }




  public function verifyemail()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.verify-email', ['pageConfigs' => $pageConfigs]);
  }

  public function resetpassword()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.reset-password', ['pageConfigs' => $pageConfigs]);
  }

  public function forgotpassword()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.forgot-password', ['pageConfigs' => $pageConfigs]);
  }

  public function twosteps()
  {
    $pageConfigs = ['myLayout' => 'blank'];
    return view('myapp.login.two-steps', ['pageConfigs' => $pageConfigs]);
  }




  //All Post operation

  public function login(Request $request)
  {
    $credentials = $request->validate([
      'email' => 'required|email',
      'password' => 'required',
    ]);

    $remember = $request->has('remember');

    // Check credentials against App_staff model
    $user = App_staff::where('email', $credentials['email'])->first();

    if ($user && Hash::check($credentials['password'], $user->password)) {
      // If user's status is 1, treat account as disabled and return an error
      if (isset($user->status) && $user->status == 1) {
        throw ValidationException::withMessages([
          'msg' => __('Account disabled.'),
        ]);
      }

      Auth::guard('staff')->login($user, $remember);
      $request->session()->regenerate();

      return redirect()->intended('/admin/'); // Change to your desired redirect
    }

    throw ValidationException::withMessages([
      'msg' => __('The provided credentials do not match our records.'),

    ]);
  }



  public function logout(Request $request)
  {
    Auth::guard('staff')->logout();

    $request->session()->invalidate();
    $request->session()->regenerateToken();

    return redirect('/admin');
  }



  public function register(Request $request)
  {
    $validated = $request->validate([
      'name' => 'required|string|max:255',
      'email' => 'required|string|email|max:255|unique:app_staff',
      'password' => ['required', 'confirmed', Password::min(8)],
    ]);

    $user = App_staff::create([
      'name' => $validated['name'],
      'email' => $validated['email'],
      'password' => Hash::make($validated['password']),
    ]);

    Auth::guard('staff')->login($user);

    return redirect('/admin/'); // Change to your desired redirect
  }
}
