<?php

/**
 * Global helper functions for ID encryption
 * These functions can be used throughout the application
 */

use App\Helpers\IdEncryption;

if (!function_exists('encrypt_id')) {
    /**
     * Encrypt an ID for public use
     *
     * @param int|string $id
     * @return string|null
     */
    function encrypt_id($id)
    {
        return IdEncryption::encrypt($id);
    }
}

if (!function_exists('decrypt_id')) {
    /**
     * Decrypt an ID from encrypted string
     *
     * @param string $encryptedId
     * @return int|null
     */
    function decrypt_id($encryptedId)
    {
        return IdEncryption::decrypt($encryptedId);
    }
}

if (!function_exists('encrypt_ids')) {
    /**
     * Encrypt multiple IDs
     *
     * @param array $ids
     * @return array
     */
    function encrypt_ids(array $ids)
    {
        return IdEncryption::encryptMany($ids);
    }
}

if (!function_exists('decrypt_ids')) {
    /**
     * Decrypt multiple IDs
     *
     * @param array $encryptedIds
     * @return array
     */
    function decrypt_ids(array $encryptedIds)
    {
        return IdEncryption::decryptMany($encryptedIds);
    }
}

if (!function_exists('is_encrypted_id')) {
    /**
     * Check if a string is a valid encrypted ID
     *
     * @param string $value
     * @return bool
     */
    function is_encrypted_id($value)
    {
        return IdEncryption::isEncrypted($value);
    }
}
